/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.SetupData;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.Util.FileExtensionFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLPackageDescription {
    private String key = "";
    private String value = null;
    private Hashtable attributes = new Hashtable();
    private Vector children = new Vector();

    protected XMLPackageDescription() {
    }

    private void add(XMLPackageDescription p) {
        this.children.add(p);
    }

    protected String getKey() {
        return this.key;
    }

    protected String getAttribute(String key) {
        return (String)this.attributes.get(key);
    }

    protected String getValue() {
        return this.value;
    }

    protected XMLPackageDescription getElement(String key) {
        return this.getElement(key, null, null);
    }

    protected XMLPackageDescription getElement(String key, String attrKey, String attrValue) {
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            XMLPackageDescription child = (XMLPackageDescription)e.nextElement();
            if (!child.key.equals(key)) continue;
            if (attrKey == null) {
                return child;
            }
            if (!attrValue.equals(child.getAttribute(attrKey))) continue;
            return child;
        }
        return null;
    }

    private XMLPackageDescription findPackage(String name) {
        XMLPackageDescription child;
        String self = (String)this.attributes.get("name");
        if (self != null && self.equals(name)) {
            return this;
        }
        XMLPackageDescription found = null;
        Enumeration e = this.children.elements();
        while (e.hasMoreElements() && ((child = (XMLPackageDescription)e.nextElement()).getAttribute("parent") == null || (found = child.findPackage(name)) == null)) {
        }
        return found;
    }

    private void adjust(XMLPackageDescription root) {
        String self = (String)this.attributes.get("name");
        for (int i = this.children.size() - 1; i >= 0; --i) {
            XMLPackageDescription newParent;
            XMLPackageDescription child = (XMLPackageDescription)this.children.elementAt(i);
            String childParentName = child.getAttribute("parent");
            if (childParentName == null) continue;
            child.adjust(root);
            if (childParentName == null || childParentName.length() <= 0 || childParentName.equals(self) || (newParent = root.findPackage(childParentName)) == null) continue;
            newParent.add(child);
            this.children.remove(i);
        }
    }

    protected void read() {
        PackageDescriptionHandler handler = new PackageDescriptionHandler(this);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            InstallData data = InstallData.getInstance();
            File xpdRoot = data.getInfoRoot("xpd");
            if (xpdRoot != null) {
                File[] file = xpdRoot.listFiles(new FileExtensionFilter("xpd"));
                if (file != null) {
                    for (int i = 0; i < file.length; ++i) {
                        parser.parse(file[i], (DefaultHandler)handler);
                    }
                } else {
                    this.key = "";
                    this.value = "no package file found";
                }
            } else {
                System.err.println("Did not find xpd directory");
            }
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
        this.adjust(this);
    }

    protected Enumeration elements() {
        return new Elements();
    }

    public void dump() {
        this.dump("");
    }

    public void dump(String indent) {
        String space = "    ";
        if (this.key != null) {
            System.out.print(indent + "<" + this.key);
        }
        Enumeration<Object> e = this.attributes.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this.attributes.get(key);
            System.out.print(" " + key + "=\"" + value + "\"");
        }
        if (this.key != null) {
            System.out.print(">");
        }
        if (this.value != null && this.value.length() > 0) {
            String trimmedValue = this.value.trim();
            if (trimmedValue.length() > 60) {
                trimmedValue = trimmedValue.substring(0, 57) + "...";
            }
            if (trimmedValue.length() > 0) {
                System.out.print(trimmedValue);
            }
        }
        e = this.children.elements();
        while (e.hasMoreElements()) {
            XMLPackageDescription current = (XMLPackageDescription)e.nextElement();
            System.out.println();
            current.dump(indent + "    ");
        }
        if (this.children.size() > 0) {
            System.out.println();
            System.out.print(indent);
        }
        if (this.key != null) {
            System.out.print("</" + this.key + ">");
        }
    }

    protected class Elements
    implements Enumeration {
        Enumeration e;

        protected Elements() {
            this.e = XMLPackageDescription.this.children.elements();
        }

        public boolean hasMoreElements() {
            return this.e.hasMoreElements();
        }

        public Object nextElement() {
            return this.e.nextElement();
        }
    }

    private class PackageDescriptionHandler
    extends DefaultHandler {
        private XMLPackageDescription root;
        private Stack stack;

        public PackageDescriptionHandler(XMLPackageDescription base) {
            this.root = base;
            this.stack = new Stack();
        }

        private PackageDescriptionHandler() {
        }

        public XMLPackageDescription getDescription() {
            return this.root;
        }

        public void characters(char[] ch, int start, int length) {
            XMLPackageDescription entity;
            entity.value = (entity = (XMLPackageDescription)this.stack.peek()).value == null ? new String(ch, start, length) : entity.value + new String(ch, start, length);
        }

        public void startDocument() {
            this.stack.push(this.root);
        }

        public void endDocument() {
            this.stack.pop();
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            XMLPackageDescription parent = (XMLPackageDescription)this.stack.peek();
            XMLPackageDescription entity = new XMLPackageDescription();
            entity.key = qName;
            for (int i = 0; i < attributes.getLength(); ++i) {
                entity.attributes.put(attributes.getQName(i), attributes.getValue(i));
            }
            parent.add(entity);
            this.stack.push(entity);
        }

        public void endElement(String uri, String localName, String qName) {
            this.stack.pop();
        }

        public void error(SAXParseException e) {
            System.err.println("Parse Error:" + e);
        }

        public void processingInstruction(String target, String data) {
        }

        public void skippedEntity(String name) {
        }

        public void warning(SAXParseException e) {
            System.err.println("Warning:" + e);
        }
    }
}

