/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.soap.name;

import com.sun.org.apache.xerces.internal.xni.NamespaceContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import org.w3c.dom.Element;

public class NameImpl
implements Name {
    public static final String XML_NAMESPACE_PREFIX = "xml";
    public static final String XML_SCHEMA_NAMESPACE_PREFIX = "xs";
    public static final String SOAP_ENVELOPE_PREFIX = "SOAP-ENV";
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    public static final String SOAP11_NAMESPACE = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String SOAP12_NAMESPACE = "http://www.w3.org/2003/05/soap-envelope";
    public static final String XML_SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    protected String uri = "";
    protected String localName = "";
    protected String prefix = "";
    private String qualifiedName = null;
    protected static final Logger log = Logger.getLogger("javax.xml.messaging.saaj.soap.name", "com.sun.xml.internal.messaging.saaj.soap.name.LocalStrings");

    protected NameImpl(String string) {
        this.localName = string == null ? "" : string;
    }

    protected NameImpl(String string, String string2, String string3) {
        this.uri = string3 == null ? "" : string3;
        this.localName = string == null ? "" : string;
        String string4 = this.prefix = string2 == null ? "" : string2;
        if (this.prefix.equals("xmlns") && this.uri.equals("")) {
            this.uri = NamespaceContext.XMLNS_URI;
        }
        if (this.uri.equals(NamespaceContext.XMLNS_URI) && this.prefix.equals("")) {
            this.prefix = "xmlns";
        }
    }

    public static Name convertToName(QName qName) {
        return new NameImpl(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
    }

    public static QName convertToQName(Name name) {
        return new QName(name.getURI(), name.getLocalName(), name.getPrefix());
    }

    public static NameImpl createFromUnqualifiedName(String string) {
        return new NameImpl(string);
    }

    public static Name createFromTagName(String string) {
        return NameImpl.createFromTagAndUri(string, "");
    }

    public static Name createFromQualifiedName(String string, String string2) {
        return NameImpl.createFromTagAndUri(string, string2);
    }

    protected static Name createFromTagAndUri(String string, String string2) {
        if (string == null) {
            log.severe("SAAJ0201.name.not.created.from.null.tag");
            throw new IllegalArgumentException("Cannot create a name from a null tag.");
        }
        int n = string.indexOf(58);
        if (n < 0) {
            return new NameImpl(string, "", string2);
        }
        return new NameImpl(string.substring(n + 1), string.substring(0, n), string2);
    }

    protected static int getPrefixSeparatorIndex(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            log.log(Level.SEVERE, "SAAJ0202.name.invalid.arg.format", new String[]{string});
            throw new IllegalArgumentException("Argument \"" + string + "\" must be of the form: \"prefix:localName\"");
        }
        return n;
    }

    public static String getPrefixFromQualifiedName(String string) {
        return string.substring(0, NameImpl.getPrefixSeparatorIndex(string));
    }

    public static String getLocalNameFromQualifiedName(String string) {
        return string.substring(NameImpl.getPrefixSeparatorIndex(string) + 1);
    }

    public static String getPrefixFromTagName(String string) {
        if (NameImpl.isQualified(string)) {
            return NameImpl.getPrefixFromQualifiedName(string);
        }
        return "";
    }

    public static String getLocalNameFromTagName(String string) {
        if (NameImpl.isQualified(string)) {
            return NameImpl.getLocalNameFromQualifiedName(string);
        }
        return string;
    }

    public static boolean isQualified(String string) {
        return string.indexOf(58) >= 0;
    }

    public static NameImpl create(String string, String string2, String string3) {
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        if (string == null) {
            string = "";
        }
        if (!string3.equals("") && !string.equals("")) {
            if (string3.equals(SOAP11_NAMESPACE)) {
                if (string.equalsIgnoreCase("Envelope")) {
                    return NameImpl.createEnvelope1_1Name(string2);
                }
                if (string.equalsIgnoreCase("Header")) {
                    return NameImpl.createHeader1_1Name(string2);
                }
                if (string.equalsIgnoreCase("Body")) {
                    return NameImpl.createBody1_1Name(string2);
                }
                if (string.equalsIgnoreCase("Fault")) {
                    return NameImpl.createFault1_1Name(string2);
                }
                return new SOAP1_1Name(string, string2);
            }
            if (string3.equals(SOAP12_NAMESPACE)) {
                if (string.equalsIgnoreCase("Envelope")) {
                    return NameImpl.createEnvelope1_2Name(string2);
                }
                if (string.equalsIgnoreCase("Header")) {
                    return NameImpl.createHeader1_2Name(string2);
                }
                if (string.equalsIgnoreCase("Body")) {
                    return NameImpl.createBody1_2Name(string2);
                }
                if (string.equals("Fault") || string.equals("Reason") || string.equals("Detail")) {
                    return NameImpl.createFault1_2Name(string, string2);
                }
                if (string.equals("Code") || string.equals("Subcode")) {
                    return NameImpl.createCodeSubcode1_2Name(string2, string);
                }
                return new SOAP1_2Name(string, string2);
            }
        }
        return new NameImpl(string, string2, string3);
    }

    public static String createQName(String string, String string2) {
        if (string == null || string.equals("")) {
            return string2;
        }
        return string + ":" + string2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Name)) {
            return false;
        }
        Name name = (Name)object;
        if (!this.uri.equals(name.getURI())) {
            return false;
        }
        return this.localName.equals(name.getLocalName());
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getURI() {
        return this.uri;
    }

    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.prefix != null && this.prefix.length() > 0 ? this.prefix + ":" + this.localName : this.localName;
        }
        return this.qualifiedName;
    }

    public static NameImpl createEnvelope1_1Name(String string) {
        return new Envelope1_1Name(string);
    }

    public static NameImpl createEnvelope1_2Name(String string) {
        return new Envelope1_2Name(string);
    }

    public static NameImpl createHeader1_1Name(String string) {
        return new Header1_1Name(string);
    }

    public static NameImpl createHeader1_2Name(String string) {
        return new Header1_2Name(string);
    }

    public static NameImpl createBody1_1Name(String string) {
        return new Body1_1Name(string);
    }

    public static NameImpl createBody1_2Name(String string) {
        return new Body1_2Name(string);
    }

    public static NameImpl createFault1_1Name(String string) {
        return new Fault1_1Name(string);
    }

    public static NameImpl createNotUnderstood1_2Name(String string) {
        return new NotUnderstood1_2Name(string);
    }

    public static NameImpl createUpgrade1_2Name(String string) {
        return new Upgrade1_2Name(string);
    }

    public static NameImpl createSupportedEnvelope1_2Name(String string) {
        return new SupportedEnvelope1_2Name(string);
    }

    public static NameImpl createFault1_2Name(String string, String string2) {
        return new Fault1_2Name(string, string2);
    }

    public static NameImpl createCodeSubcode1_2Name(String string, String string2) {
        return new CodeSubcode1_2Name(string2, string);
    }

    public static NameImpl createDetail1_1Name() {
        return new Detail1_1Name();
    }

    public static NameImpl createDetail1_1Name(String string) {
        return new Detail1_1Name(string);
    }

    public static NameImpl createFaultElement1_1Name(String string) {
        return new FaultElement1_1Name(string);
    }

    public static NameImpl createFaultElement1_1Name(String string, String string2) {
        return new FaultElement1_1Name(string, string2);
    }

    public static NameImpl createSOAP11Name(String string) {
        return new SOAP1_1Name(string, null);
    }

    public static NameImpl createSOAP12Name(String string) {
        return new SOAP1_2Name(string, null);
    }

    public static NameImpl createSOAP12Name(String string, String string2) {
        return new SOAP1_2Name(string, string2);
    }

    public static NameImpl createXmlName(String string) {
        return new NameImpl(string, XML_NAMESPACE_PREFIX, XML_NAMESPACE);
    }

    public static Name copyElementName(Element element) {
        String string = element.getLocalName();
        String string2 = element.getPrefix();
        String string3 = element.getNamespaceURI();
        return NameImpl.create(string, string2, string3);
    }

    static class Body1_1Name
    extends SOAP1_1Name {
        Body1_1Name(String string) {
            super("Body", string);
        }
    }

    static class Body1_2Name
    extends SOAP1_2Name {
        Body1_2Name(String string) {
            super("Body", string);
        }
    }

    static class CodeSubcode1_2Name
    extends SOAP1_2Name {
        CodeSubcode1_2Name(String string, String string2) {
            super(string, string2);
        }
    }

    static class Detail1_1Name
    extends NameImpl {
        Detail1_1Name() {
            super("detail");
        }

        Detail1_1Name(String string) {
            super("detail", string, "");
        }
    }

    static class Envelope1_1Name
    extends SOAP1_1Name {
        Envelope1_1Name(String string) {
            super("Envelope", string);
        }
    }

    static class Envelope1_2Name
    extends SOAP1_2Name {
        Envelope1_2Name(String string) {
            super("Envelope", string);
        }
    }

    static class Fault1_1Name
    extends NameImpl {
        Fault1_1Name(String string) {
            super("Fault", string == null || string.equals("") ? NameImpl.SOAP_ENVELOPE_PREFIX : string, NameImpl.SOAP11_NAMESPACE);
        }
    }

    static class Fault1_2Name
    extends NameImpl {
        Fault1_2Name(String string, String string2) {
            super(string == null || string.equals("") ? "Fault" : string, string2 == null || string2.equals("") ? "env" : string2, NameImpl.SOAP12_NAMESPACE);
        }
    }

    static class FaultElement1_1Name
    extends NameImpl {
        FaultElement1_1Name(String string) {
            super(string);
        }

        FaultElement1_1Name(String string, String string2) {
            super(string, string2, "");
        }
    }

    static class Header1_1Name
    extends SOAP1_1Name {
        Header1_1Name(String string) {
            super("Header", string);
        }
    }

    static class Header1_2Name
    extends SOAP1_2Name {
        Header1_2Name(String string) {
            super("Header", string);
        }
    }

    static class NotUnderstood1_2Name
    extends NameImpl {
        NotUnderstood1_2Name(String string) {
            super("NotUnderstood", string == null || string.equals("") ? "env" : string, NameImpl.SOAP12_NAMESPACE);
        }
    }

    static class SOAP1_1Name
    extends NameImpl {
        SOAP1_1Name(String string, String string2) {
            super(string, string2 == null || string2.equals("") ? NameImpl.SOAP_ENVELOPE_PREFIX : string2, NameImpl.SOAP11_NAMESPACE);
        }
    }

    static class SOAP1_2Name
    extends NameImpl {
        SOAP1_2Name(String string, String string2) {
            super(string, string2 == null || string2.equals("") ? "env" : string2, NameImpl.SOAP12_NAMESPACE);
        }
    }

    static class SupportedEnvelope1_2Name
    extends NameImpl {
        SupportedEnvelope1_2Name(String string) {
            super("SupportedEnvelope", string == null || string.equals("") ? "env" : string, NameImpl.SOAP12_NAMESPACE);
        }
    }

    static class Upgrade1_2Name
    extends NameImpl {
        Upgrade1_2Name(String string) {
            super("Upgrade", string == null || string.equals("") ? "env" : string, NameImpl.SOAP12_NAMESPACE);
        }
    }
}

