/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.PaintEvent;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.MotifColorUtilities;
import sun.awt.X11.Native;
import sun.awt.X11.XAwtState;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XEvent;
import sun.awt.X11.XMenuBarPeer;
import sun.awt.X11.XMenuItemPeer;
import sun.awt.X11.XMenuPeer;
import sun.awt.X11.XMenuWindow;
import sun.awt.X11.XPopupMenuPeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XlibWrapper;
import sun.java2d.SurfaceData;

public abstract class XBaseMenuWindow
extends XWindow {
    private static Logger log = Logger.getLogger("sun.awt.X11.XBaseMenuWindow");
    private Color backgroundColor;
    private Color foregroundColor;
    private Color lightShadowColor;
    private Color darkShadowColor;
    private Color selectedColor;
    private Color disabledColor;
    private ArrayList<XMenuItemPeer> items;
    private int selectedIndex = -1;
    private XMenuPeer showingSubmenu = null;
    private static Object menuTreeLock = new Object();
    private XMenuPeer showingMousePressedSubmenu = null;
    protected Point grabInputPoint = null;
    protected boolean hasPointerMoved = false;
    private MappingData mappingData;

    XBaseMenuWindow() {
        super(new XCreateWindowParams(new Object[]{"delayed", Boolean.TRUE}));
    }

    protected abstract XBaseMenuWindow getParentMenuWindow();

    protected abstract MappingData map();

    protected abstract Rectangle getSubmenuBounds(Rectangle var1, Dimension var2);

    protected abstract void updateSize();

    void instantPreInit(XCreateWindowParams xCreateWindowParams) {
        super.instantPreInit(xCreateWindowParams);
        this.items = new ArrayList();
    }

    static Object getMenuTreeLock() {
        return menuTreeLock;
    }

    protected void resetMapping() {
        this.mappingData = null;
    }

    void postPaintEvent() {
        if (this.isShowing()) {
            PaintEvent paintEvent = new PaintEvent(this.target, 800, new Rectangle(0, 0, this.width, this.height));
            this.postEvent(paintEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XMenuItemPeer getItem(int n) {
        if (n >= 0) {
            Object object = XBaseMenuWindow.getMenuTreeLock();
            synchronized (object) {
                if (this.items.size() > n) {
                    return this.items.get(n);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XMenuItemPeer[] copyItems() {
        Object object = XBaseMenuWindow.getMenuTreeLock();
        synchronized (object) {
            return this.items.toArray(new XMenuItemPeer[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XMenuItemPeer getSelectedItem() {
        Object object = XBaseMenuWindow.getMenuTreeLock();
        synchronized (object) {
            if (this.selectedIndex >= 0 && this.items.size() > this.selectedIndex) {
                return this.items.get(this.selectedIndex);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XMenuPeer getShowingSubmenu() {
        Object object = XBaseMenuWindow.getMenuTreeLock();
        synchronized (object) {
            return this.showingSubmenu;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(MenuItem menuItem) {
        XMenuItemPeer xMenuItemPeer = (XMenuItemPeer)menuItem.getPeer();
        if (xMenuItemPeer != null) {
            xMenuItemPeer.setContainer(this);
            Object object = XBaseMenuWindow.getMenuTreeLock();
            synchronized (object) {
                this.items.add(xMenuItemPeer);
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("WARNING: Attempt to add menu item without a peer");
        }
        this.updateSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delItem(int n) {
        Object object = XBaseMenuWindow.getMenuTreeLock();
        synchronized (object) {
            if (this.selectedIndex == n) {
                this.selectItem(null, false);
            } else if (this.selectedIndex > n) {
                --this.selectedIndex;
            }
            if (n < this.items.size()) {
                this.items.remove(n);
            } else if (log.isLoggable(Level.FINE)) {
                log.fine("WARNING: Attempt to remove non-existing menu item, index : " + n + ", item count : " + this.items.size());
            }
        }
        this.updateSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadItems(Vector vector) {
        Object object = XBaseMenuWindow.getMenuTreeLock();
        synchronized (object) {
            this.items.clear();
            MenuItem[] menuItemArray = vector.toArray(new MenuItem[0]);
            int n = menuItemArray.length;
            for (int i = 0; i < n; ++i) {
                this.addItem(menuItemArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectItem(XMenuItemPeer xMenuItemPeer, boolean bl) {
        Object object = XBaseMenuWindow.getMenuTreeLock();
        synchronized (object) {
            XMenuPeer xMenuPeer;
            int n;
            XMenuPeer xMenuPeer2 = this.getShowingSubmenu();
            int n2 = n = xMenuItemPeer != null ? this.items.indexOf(xMenuItemPeer) : -1;
            if (this.selectedIndex != n) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Selected index changed, was : " + this.selectedIndex + ", new : " + n);
                }
                this.selectedIndex = n;
                this.postPaintEvent();
            }
            XMenuPeer xMenuPeer3 = xMenuPeer = bl && xMenuItemPeer instanceof XMenuPeer ? (XMenuPeer)xMenuItemPeer : null;
            if (xMenuPeer != xMenuPeer2) {
                XToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

                    public void run() {
                        XBaseMenuWindow.this.doShowSubmenu(xMenuPeer);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doShowSubmenu(XMenuPeer xMenuPeer) {
        XMenuWindow xMenuWindow = xMenuPeer != null ? xMenuPeer.getMenuWindow() : null;
        Dimension dimension = null;
        Rectangle rectangle = null;
        if (xMenuWindow != null) {
            xMenuWindow.ensureCreated();
        }
        XToolkit.awtLock();
        try {
            Object object = XBaseMenuWindow.getMenuTreeLock();
            synchronized (object) {
                if (this.showingSubmenu != xMenuPeer) {
                    XMenuWindow xMenuWindow2;
                    if (log.isLoggable(Level.FINER)) {
                        log.finest("Changing showing submenu");
                    }
                    if (this.showingSubmenu != null && (xMenuWindow2 = this.showingSubmenu.getMenuWindow()) != null) {
                        xMenuWindow2.hide();
                    }
                    if (xMenuPeer != null) {
                        dimension = xMenuWindow.getDesiredSize();
                        rectangle = xMenuWindow.getParentMenuWindow().getSubmenuBounds(xMenuPeer.getBounds(), dimension);
                        xMenuWindow.show(rectangle);
                    }
                    this.showingSubmenu = xMenuPeer;
                }
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    MappingData getMappingData() {
        MappingData mappingData = this.mappingData;
        if (mappingData == null) {
            this.mappingData = mappingData = this.map();
        }
        return (MappingData)mappingData.clone();
    }

    XMenuItemPeer getItemFromPoint(Point point) {
        XMenuItemPeer[] xMenuItemPeerArray = this.getMappingData().getItems();
        int n = xMenuItemPeerArray.length;
        for (int i = 0; i < n; ++i) {
            if (!xMenuItemPeerArray[i].getBounds().contains(point)) continue;
            return xMenuItemPeerArray[i];
        }
        return null;
    }

    XMenuItemPeer getNextSelectableItem() {
        int n;
        XMenuItemPeer[] xMenuItemPeerArray = this.getMappingData().getItems();
        XMenuItemPeer xMenuItemPeer = this.getSelectedItem();
        int n2 = xMenuItemPeerArray.length;
        int n3 = -1;
        for (n = 0; n < n2; ++n) {
            if (xMenuItemPeerArray[n] != xMenuItemPeer) continue;
            n3 = n;
            break;
        }
        n = n3 == n2 - 1 ? 0 : n3 + 1;
        for (int i = 0; i < n2; ++i) {
            XMenuItemPeer xMenuItemPeer2 = xMenuItemPeerArray[n];
            if (!xMenuItemPeer2.isSeparator() && xMenuItemPeer2.isTargetItemEnabled()) {
                return xMenuItemPeer2;
            }
            if (++n < n2) continue;
            n = 0;
        }
        return null;
    }

    XMenuItemPeer getPrevSelectableItem() {
        int n;
        XMenuItemPeer[] xMenuItemPeerArray = this.getMappingData().getItems();
        XMenuItemPeer xMenuItemPeer = this.getSelectedItem();
        int n2 = xMenuItemPeerArray.length;
        int n3 = -1;
        for (n = 0; n < n2; ++n) {
            if (xMenuItemPeerArray[n] != xMenuItemPeer) continue;
            n3 = n;
            break;
        }
        n = n3 <= 0 ? n2 - 1 : n3 - 1;
        for (int i = 0; i < n2; ++i) {
            XMenuItemPeer xMenuItemPeer2 = xMenuItemPeerArray[n];
            if (!xMenuItemPeer2.isSeparator() && xMenuItemPeer2.isTargetItemEnabled()) {
                return xMenuItemPeer2;
            }
            if (--n >= 0) continue;
            n = n2 - 1;
        }
        return null;
    }

    XMenuItemPeer getFirstSelectableItem() {
        for (XMenuItemPeer xMenuItemPeer : this.getMappingData().getItems()) {
            if (xMenuItemPeer.isSeparator() || !xMenuItemPeer.isTargetItemEnabled()) continue;
            return xMenuItemPeer;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XBaseMenuWindow getShowingLeaf() {
        Object object = XBaseMenuWindow.getMenuTreeLock();
        synchronized (object) {
            XBaseMenuWindow xBaseMenuWindow = this;
            XMenuPeer xMenuPeer = xBaseMenuWindow.getShowingSubmenu();
            while (xMenuPeer != null) {
                xBaseMenuWindow = xMenuPeer.getMenuWindow();
                xMenuPeer = xBaseMenuWindow.getShowingSubmenu();
            }
            return xBaseMenuWindow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XBaseMenuWindow getRootMenuWindow() {
        Object object = XBaseMenuWindow.getMenuTreeLock();
        synchronized (object) {
            XBaseMenuWindow xBaseMenuWindow = this;
            XBaseMenuWindow xBaseMenuWindow2 = xBaseMenuWindow.getParentMenuWindow();
            while (xBaseMenuWindow2 != null) {
                xBaseMenuWindow = xBaseMenuWindow2;
                xBaseMenuWindow2 = xBaseMenuWindow.getParentMenuWindow();
            }
            return xBaseMenuWindow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XBaseMenuWindow getMenuWindowFromPoint(Point point) {
        Object object = XBaseMenuWindow.getMenuTreeLock();
        synchronized (object) {
            for (XBaseMenuWindow xBaseMenuWindow = this.getShowingLeaf(); xBaseMenuWindow != null; xBaseMenuWindow = xBaseMenuWindow.getParentMenuWindow()) {
                Rectangle rectangle = new Rectangle(xBaseMenuWindow.toGlobal(new Point(0, 0)), xBaseMenuWindow.getSize());
                if (!rectangle.contains(point)) continue;
                return xBaseMenuWindow;
            }
            return null;
        }
    }

    Rectangle fitWindowBelow(Rectangle rectangle, Dimension dimension, Dimension dimension2) {
        int n;
        int n2 = dimension.width;
        int n3 = dimension.height;
        int n4 = rectangle.x > 0 ? rectangle.x : 0;
        int n5 = n = rectangle.y + rectangle.height > 0 ? rectangle.y + rectangle.height : 0;
        if (n + n3 <= dimension2.height) {
            if (n2 > dimension2.width) {
                n2 = dimension2.width;
            }
            if (n4 + n2 > dimension2.width) {
                n4 = dimension2.width - n2;
            }
            return new Rectangle(n4, n, n2, n3);
        }
        return null;
    }

    Rectangle fitWindowAbove(Rectangle rectangle, Dimension dimension, Dimension dimension2) {
        int n;
        int n2 = dimension.width;
        int n3 = dimension.height;
        int n4 = rectangle.x > 0 ? rectangle.x : 0;
        int n5 = n = rectangle.y > dimension2.height ? dimension2.height - n3 : rectangle.y - n3;
        if (n >= 0) {
            if (n2 > dimension2.width) {
                n2 = dimension2.width;
            }
            if (n4 + n2 > dimension2.width) {
                n4 = dimension2.width - n2;
            }
            return new Rectangle(n4, n, n2, n3);
        }
        return null;
    }

    Rectangle fitWindowRight(Rectangle rectangle, Dimension dimension, Dimension dimension2) {
        int n;
        int n2 = dimension.width;
        int n3 = dimension.height;
        int n4 = rectangle.x + rectangle.width > 0 ? rectangle.x + rectangle.width : 0;
        int n5 = n = rectangle.y > 0 ? rectangle.y : 0;
        if (n4 + n2 <= dimension2.width) {
            if (n3 > dimension2.height) {
                n3 = dimension2.height;
            }
            if (n + n3 > dimension2.height) {
                n = dimension2.height - n3;
            }
            return new Rectangle(n4, n, n2, n3);
        }
        return null;
    }

    Rectangle fitWindowLeft(Rectangle rectangle, Dimension dimension, Dimension dimension2) {
        int n;
        int n2 = dimension.width;
        int n3 = dimension.height;
        int n4 = rectangle.x < dimension2.width ? rectangle.x - n2 : dimension2.width - n2;
        int n5 = n = rectangle.y > 0 ? rectangle.y : 0;
        if (n4 >= 0) {
            if (n3 > dimension2.height) {
                n3 = dimension2.height;
            }
            if (n + n3 > dimension2.height) {
                n = dimension2.height - n3;
            }
            return new Rectangle(n4, n, n2, n3);
        }
        return null;
    }

    Rectangle fitWindowToScreen(Dimension dimension, Dimension dimension2) {
        int n = dimension.width < dimension2.width ? dimension.width : dimension2.width;
        int n2 = dimension.height < dimension2.height ? dimension.height : dimension2.height;
        return new Rectangle(0, 0, n, n2);
    }

    void resetColors() {
        this.replaceColors(this.target == null ? SystemColor.window : this.target.getBackground());
    }

    void replaceColors(Color color) {
        if (color != this.backgroundColor) {
            this.backgroundColor = color;
            int n = color.getRed();
            int n2 = color.getGreen();
            int n3 = color.getBlue();
            this.foregroundColor = new Color(MotifColorUtilities.calculateForegroundFromBackground(n, n2, n3));
            this.lightShadowColor = new Color(MotifColorUtilities.calculateTopShadowFromBackground(n, n2, n3));
            this.darkShadowColor = new Color(MotifColorUtilities.calculateBottomShadowFromBackground(n, n2, n3));
            this.selectedColor = new Color(MotifColorUtilities.calculateSelectFromBackground(n, n2, n3));
            this.disabledColor = color.equals(Color.BLACK) ? this.foregroundColor.darker() : color.darker();
        }
    }

    Color getBackgroundColor() {
        return this.backgroundColor;
    }

    Color getForegroundColor() {
        return this.foregroundColor;
    }

    Color getLightShadowColor() {
        return this.lightShadowColor;
    }

    Color getDarkShadowColor() {
        return this.darkShadowColor;
    }

    Color getSelectedColor() {
        return this.selectedColor;
    }

    Color getDisabledColor() {
        return this.disabledColor;
    }

    void draw3DRect(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        Color color = graphics.getColor();
        graphics.setColor(bl ? this.getLightShadowColor() : this.getDarkShadowColor());
        graphics.drawLine(n, n2, n, n2 + n4 - 1);
        graphics.drawLine(n + 1, n2, n + n3 - 1, n2);
        graphics.setColor(bl ? this.getDarkShadowColor() : this.getLightShadowColor());
        graphics.drawLine(n + 1, n2 + n4 - 1, n + n3, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 1);
        graphics.setColor(color);
    }

    protected boolean isEventDisabled(XEvent xEvent) {
        switch (xEvent.get_type()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 17: {
                return super.isEventDisabled(xEvent);
            }
        }
        return true;
    }

    public void dispose() {
        this.setDisposed(true);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                XBaseMenuWindow.this.doDispose();
            }
        });
    }

    protected void doDispose() {
        this.xSetVisible(false);
        SurfaceData surfaceData = this.surfaceData;
        this.surfaceData = null;
        if (surfaceData != null) {
            surfaceData.invalidate();
        }
        XToolkit.targetDisposedPeer(this.target, this);
        this.destroy();
    }

    void postEvent(final AWTEvent aWTEvent) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                XBaseMenuWindow.this.handleEvent(aWTEvent);
            }
        });
    }

    protected void handleEvent(AWTEvent aWTEvent) {
        switch (aWTEvent.getID()) {
            case 800: {
                this.doHandleJavaPaintEvent((PaintEvent)aWTEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean grabInput() {
        int n;
        int n2;
        boolean bl;
        XToolkit.awtLock();
        try {
            long l = XlibWrapper.RootWindow(XToolkit.getDisplay(), this.getScreenNumber());
            bl = XlibWrapper.XQueryPointer(XToolkit.getDisplay(), l, XlibWrapper.larg1, XlibWrapper.larg2, XlibWrapper.larg3, XlibWrapper.larg4, XlibWrapper.larg5, XlibWrapper.larg6, XlibWrapper.larg7);
            n2 = Native.getInt(XlibWrapper.larg3);
            n = Native.getInt(XlibWrapper.larg4);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
        if (bl &= super.grabInput()) {
            this.grabInputPoint = new Point(n2, n);
            this.hasPointerMoved = false;
        } else {
            this.grabInputPoint = null;
            this.hasPointerMoved = true;
        }
        return bl;
    }

    void doHandleJavaPaintEvent(PaintEvent paintEvent) {
        Rectangle rectangle = paintEvent.getUpdateRect();
        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    void doHandleJavaMouseEvent(MouseEvent mouseEvent) {
        XBaseMenuWindow xBaseMenuWindow;
        if (!XToolkit.isLeftMouseButton(mouseEvent) && !XToolkit.isRightMouseButton(mouseEvent)) {
            return;
        }
        XBaseWindow xBaseWindow = XAwtState.getGrabWindow();
        Point point = this.toGlobal(mouseEvent.getPoint());
        if (!(this.hasPointerMoved || this.grabInputPoint != null && Math.abs(point.x - this.grabInputPoint.x) <= XBaseMenuWindow.getMouseMovementSmudge() && Math.abs(point.y - this.grabInputPoint.y) <= XBaseMenuWindow.getMouseMovementSmudge())) {
            this.hasPointerMoved = true;
        }
        XMenuItemPeer xMenuItemPeer = (xBaseMenuWindow = this.getMenuWindowFromPoint(point)) != null ? xBaseMenuWindow.getItemFromPoint(xBaseMenuWindow.toLocal(point)) : null;
        XBaseMenuWindow xBaseMenuWindow2 = this.getShowingLeaf();
        switch (mouseEvent.getID()) {
            case 501: {
                this.showingMousePressedSubmenu = null;
                if (xBaseWindow == this && xBaseMenuWindow == null) {
                    XBaseMenuWindow.ungrabInput();
                    break;
                }
                this.grabInput();
                if (xMenuItemPeer != null && !xMenuItemPeer.isSeparator() && xMenuItemPeer.isTargetItemEnabled()) {
                    if (xBaseMenuWindow.getShowingSubmenu() == xMenuItemPeer) {
                        this.showingMousePressedSubmenu = (XMenuPeer)xMenuItemPeer;
                    }
                    xBaseMenuWindow.selectItem(xMenuItemPeer, true);
                    break;
                }
                if (xBaseMenuWindow == null) break;
                xBaseMenuWindow.selectItem(null, false);
                break;
            }
            case 502: {
                if (xMenuItemPeer != null && !xMenuItemPeer.isSeparator() && xMenuItemPeer.isTargetItemEnabled()) {
                    if (xMenuItemPeer instanceof XMenuPeer) {
                        if (this.showingMousePressedSubmenu == xMenuItemPeer) {
                            if (xBaseMenuWindow instanceof XMenuBarPeer) {
                                XBaseMenuWindow.ungrabInput();
                            } else {
                                xBaseMenuWindow.selectItem(xMenuItemPeer, false);
                            }
                        }
                    } else {
                        xMenuItemPeer.action(mouseEvent.getWhen());
                        XBaseMenuWindow.ungrabInput();
                    }
                } else if (this.hasPointerMoved || xBaseMenuWindow instanceof XMenuBarPeer) {
                    XBaseMenuWindow.ungrabInput();
                }
                this.showingMousePressedSubmenu = null;
                break;
            }
            case 506: {
                if (xBaseMenuWindow != null) {
                    if (xMenuItemPeer != null && !xMenuItemPeer.isSeparator() && xMenuItemPeer.isTargetItemEnabled()) {
                        if (xBaseWindow != this) break;
                        xBaseMenuWindow.selectItem(xMenuItemPeer, true);
                        break;
                    }
                    xBaseMenuWindow.selectItem(null, false);
                    break;
                }
                if (xBaseMenuWindow2 == null) break;
                xBaseMenuWindow2.selectItem(null, false);
            }
        }
    }

    void doHandleJavaKeyEvent(KeyEvent keyEvent) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(keyEvent.toString());
        }
        if (keyEvent.getID() != 401) {
            return;
        }
        int n = keyEvent.getKeyCode();
        XBaseMenuWindow xBaseMenuWindow = this.getShowingLeaf();
        XMenuItemPeer xMenuItemPeer = xBaseMenuWindow.getSelectedItem();
        switch (n) {
            case 38: 
            case 224: {
                if (xBaseMenuWindow instanceof XMenuBarPeer) break;
                xBaseMenuWindow.selectItem(xBaseMenuWindow.getPrevSelectableItem(), false);
                break;
            }
            case 40: 
            case 225: {
                if (xBaseMenuWindow instanceof XMenuBarPeer) {
                    this.selectItem(this.getSelectedItem(), true);
                    break;
                }
                xBaseMenuWindow.selectItem(xBaseMenuWindow.getNextSelectableItem(), false);
                break;
            }
            case 37: 
            case 226: {
                if (xBaseMenuWindow instanceof XMenuBarPeer) {
                    this.selectItem(this.getPrevSelectableItem(), false);
                    break;
                }
                if (xBaseMenuWindow.getParentMenuWindow() instanceof XMenuBarPeer) {
                    this.selectItem(this.getPrevSelectableItem(), true);
                    break;
                }
                XBaseMenuWindow xBaseMenuWindow2 = xBaseMenuWindow.getParentMenuWindow();
                if (xBaseMenuWindow2 == null) break;
                xBaseMenuWindow2.selectItem(xBaseMenuWindow2.getSelectedItem(), false);
                break;
            }
            case 39: 
            case 227: {
                if (xBaseMenuWindow instanceof XMenuBarPeer) {
                    this.selectItem(this.getNextSelectableItem(), false);
                    break;
                }
                if (xMenuItemPeer instanceof XMenuPeer) {
                    xBaseMenuWindow.selectItem(xMenuItemPeer, true);
                    break;
                }
                if (!(this instanceof XMenuBarPeer)) break;
                this.selectItem(this.getNextSelectableItem(), true);
                break;
            }
            case 10: 
            case 32: {
                if (xMenuItemPeer instanceof XMenuPeer) {
                    xBaseMenuWindow.selectItem(xMenuItemPeer, true);
                    break;
                }
                if (xMenuItemPeer == null) break;
                xMenuItemPeer.action(keyEvent.getWhen());
                XBaseMenuWindow.ungrabInput();
                break;
            }
            case 27: {
                if (xBaseMenuWindow instanceof XMenuBarPeer || xBaseMenuWindow.getParentMenuWindow() instanceof XMenuBarPeer) {
                    XBaseMenuWindow.ungrabInput();
                    break;
                }
                if (xBaseMenuWindow instanceof XPopupMenuPeer) {
                    XBaseMenuWindow.ungrabInput();
                    break;
                }
                XBaseMenuWindow xBaseMenuWindow3 = xBaseMenuWindow.getParentMenuWindow();
                xBaseMenuWindow3.selectItem(xBaseMenuWindow3.getSelectedItem(), false);
                break;
            }
            case 121: {
                XBaseMenuWindow.ungrabInput();
                break;
            }
        }
    }

    static class MappingData
    implements Cloneable {
        private XMenuItemPeer[] items;

        MappingData(XMenuItemPeer[] xMenuItemPeerArray) {
            this.items = xMenuItemPeerArray;
        }

        MappingData() {
            this.items = new XMenuItemPeer[0];
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        public XMenuItemPeer[] getItems() {
            return this.items;
        }
    }
}

