/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.si.DeploySIListener;
import com.sun.deploy.si.SingleInstanceImpl;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.ui.DialogTemplate;
import com.sun.deploy.ui.UITextArea;
import com.sun.deploy.util.DeployUIManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class AboutDialog
extends JDialog
implements DeploySIListener {
    private SingleInstanceImpl sil = null;
    private static String ABOUT_JAVA_ID = "com_sun_deploy_AboutJava-" + Config.getProperty("deployment.version");

    public AboutDialog(JFrame jFrame, boolean bl, boolean bl2) {
        super((Frame)jFrame, bl);
        if (bl2) {
            this.initSIImpl();
        }
        this.initComponents();
    }

    public AboutDialog(JFrame jFrame, boolean bl) {
        super((Frame)jFrame, bl);
        this.initComponents();
    }

    public AboutDialog(JDialog jDialog, boolean bl) {
        super((Dialog)jDialog, bl);
        this.initComponents();
    }

    private void initSIImpl() {
        this.sil = new SingleInstanceImpl();
        this.sil.addSingleInstanceListener(this, ABOUT_JAVA_ID);
    }

    public static boolean shouldStartNewInstance() {
        return !SingleInstanceManager.isServerRunning(ABOUT_JAVA_ID) || !SingleInstanceManager.connectToServer("");
    }

    private void initComponents() {
        int n;
        this.setTitle(this.getMessage("about.dialog.title"));
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AboutDialog.this.closeDialog(windowEvent);
            }
        });
        Color color = new Color(210, 219, 228);
        Color color2 = new Color(112, 114, 119);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setForeground(color);
        jPanel.setBackground(color);
        jPanel.setOpaque(true);
        jPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        URL uRL = ClassLoader.getSystemResource("com/sun/deploy/resources/image/aboutjava.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        JLabel jLabel = new JLabel(imageIcon);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        final int n2 = imageIcon.getIconWidth() - 20;
        String string = System.getProperty("java.version");
        int n3 = string.indexOf(".");
        String string2 = string.substring(n3 + 1, string.indexOf(".", n3 + 1));
        int n4 = string.lastIndexOf("_");
        String string3 = null;
        if (n4 != -1 && (string3 = (n = string.indexOf("-")) != -1 ? string.substring(n4 + 1, n) : string.substring(n4 + 1, string.length())).indexOf("0") != -1) {
            string3 = string3.substring(1);
        }
        String string4 = null;
        string4 = string3 != null ? MessageFormat.format(this.getMessage("about.java.version.update"), string2, string3) : MessageFormat.format(this.getMessage("about.java.version"), string2);
        String string5 = MessageFormat.format(this.getMessage("about.java.build"), System.getProperty("java.runtime.version"));
        Font font = ResourceManager.getUIFont().deriveFont((float)DialogTemplate.getSubpanelFontSize());
        JLabel jLabel2 = new JLabel(string4);
        jLabel2.setForeground(color2);
        jLabel2.setBackground(color);
        jLabel2.setFont(font);
        JTextArea jTextArea = new JTextArea(string5);
        jTextArea.setEditable(false);
        jTextArea.setForeground(color2);
        jTextArea.setBackground(color);
        jTextArea.setFont(font);
        String string6 = this.getMessage("about.copyright");
        String string7 = this.getMessage("about.legal.note");
        String string8 = this.getMessage("about.prompt.info");
        String string9 = this.getMessage("about.home.link");
        String string10 = string6 + "\n" + string7;
        UITextArea uITextArea = new UITextArea(DialogTemplate.getSubpanelFontSize(), n2, false);
        uITextArea.setText(string10);
        uITextArea.setForeground(color2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(color);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout2);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridwidth = -1;
        gridBagLayout2.setConstraints(jLabel2, gridBagConstraints2);
        jPanel2.add(jLabel2);
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 15;
        gridBagConstraints2.insets = new Insets(0, 10, 0, 0);
        gridBagLayout2.setConstraints(jTextArea, gridBagConstraints2);
        jPanel2.add(jTextArea);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints2.weightx = 0.0;
        gridBagLayout2.setConstraints(uITextArea, gridBagConstraints2);
        jPanel2.add(uITextArea);
        final String string11 = "<font face=" + ResourceManager.getUIFont().getFamily() + " color=#707277>" + string8 + " " + " <a style='color:#35556b' href=" + string9 + '>' + string9 + "</a></font>";
        final JEditorPane jEditorPane = new JEditorPane(){

            public Dimension getPreferredSize() {
                Cloneable cloneable;
                if (this.getWidth() == 0) {
                    cloneable = this.getInsets();
                    this.setSize(n2, cloneable.top + cloneable.bottom + 1);
                }
                cloneable = super.getPreferredSize();
                ((Dimension)cloneable).width = this.getWidth();
                return cloneable;
            }
        };
        jEditorPane.setFont(font);
        jEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jEditorPane.setContentType("text/html");
        jEditorPane.setText(string11);
        jEditorPane.setForeground(color2);
        jEditorPane.setBackground(color);
        FontMetrics fontMetrics = jEditorPane.getFontMetrics(font);
        int n5 = fontMetrics.stringWidth(string8 + string9);
        jEditorPane.setEditable(false);
        jEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    Config.getInstance().showDocument(hyperlinkEvent.getURL().toString());
                } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    jEditorPane.setText(string11.replaceFirst("'color:#35556b'", "'color:#c06600'"));
                } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    jEditorPane.setText(string11);
                }
            }
        });
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        gridBagConstraints.insets = new Insets(10, 10, 30, 10);
        gridBagLayout.setConstraints(jEditorPane, gridBagConstraints);
        jPanel.add(jEditorPane);
        JLabel jLabel3 = new JLabel();
        ImageIcon imageIcon2 = ResourceManager.getIcon("sun.logo.image");
        jLabel3.setIcon(imageIcon2);
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel.add(jLabel3);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 10, 10));
        JButton jButton = new JButton(this.getMessage("about.option.close"));
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AboutDialog.this.okBtnActionPerformed(actionEvent);
            }
        };
        jButton.addActionListener(abstractAction);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().getInputMap(2).put(keyStroke, "cancel");
        this.getRootPane().getActionMap().put("cancel", abstractAction);
        jEditorPane.getInputMap().put(keyStroke, "cancel");
        jEditorPane.getActionMap().put("cancel", null);
        jPanel3.add(jButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel3, "South");
        this.getRootPane().setDefaultButton(jButton);
        this.pack();
        this.setResizable(false);
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        if (this.sil != null) {
            this.sil.removeSingleInstanceListener(this);
        }
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        if (this.sil != null) {
            this.sil.removeSingleInstanceListener(this);
        }
        this.setVisible(false);
        this.dispose();
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    public void newActivation(String[] stringArray) {
        this.toFront();
    }

    public Object getSingleInstanceListener() {
        return this;
    }

    static {
        DeployUIManager.setLookAndFeel();
    }
}

