/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import java.io.UnsupportedEncodingException;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import sun.security.internal.spec.TlsPrfParameterSpec;

public final class TlsPrfGenerator
extends KeyGeneratorSpi {
    private static final byte[] B0 = new byte[0];
    static final byte[] LABEL_MASTER_SECRET = new byte[]{109, 97, 115, 116, 101, 114, 32, 115, 101, 99, 114, 101, 116};
    static final byte[] LABEL_KEY_EXPANSION = new byte[]{107, 101, 121, 32, 101, 120, 112, 97, 110, 115, 105, 111, 110};
    static final byte[] LABEL_CLIENT_WRITE_KEY = new byte[]{99, 108, 105, 101, 110, 116, 32, 119, 114, 105, 116, 101, 32, 107, 101, 121};
    static final byte[] LABEL_SERVER_WRITE_KEY = new byte[]{115, 101, 114, 118, 101, 114, 32, 119, 114, 105, 116, 101, 32, 107, 101, 121};
    static final byte[] LABEL_IV_BLOCK = new byte[]{73, 86, 32, 98, 108, 111, 99, 107};
    private static final byte[] HMAC_ipad = TlsPrfGenerator.genPad((byte)54, 64);
    private static final byte[] HMAC_opad = TlsPrfGenerator.genPad((byte)92, 64);
    static final byte[][] SSL3_CONST = TlsPrfGenerator.genConst();
    private static final String MSG = "TlsPrfGenerator must be initialized using a TlsPrfParameterSpec";
    private TlsPrfParameterSpec spec;

    static byte[] genPad(byte by, int n) {
        byte[] byArray = new byte[n];
        Arrays.fill(byArray, by);
        return byArray;
    }

    static byte[] concat(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        int n2 = byArray2.length;
        byte[] byArray3 = new byte[n + n2];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        System.arraycopy(byArray2, 0, byArray3, n, n2);
        return byArray3;
    }

    private static byte[][] genConst() {
        int n = 10;
        byte[][] byArrayArray = new byte[n][];
        for (int i = 0; i < n; ++i) {
            byte[] byArray = new byte[i + 1];
            Arrays.fill(byArray, (byte)(65 + i));
            byArrayArray[i] = byArray;
        }
        return byArrayArray;
    }

    public TlsPrfGenerator() {
        SunJCE.a(this.getClass());
    }

    protected void engineInit(SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof TlsPrfParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        this.spec = (TlsPrfParameterSpec)algorithmParameterSpec;
        SecretKey secretKey = this.spec.getSecret();
        if (secretKey != null && !"RAW".equals(secretKey.getFormat())) {
            throw new InvalidAlgorithmParameterException("Key encoding format must be RAW");
        }
    }

    protected void engineInit(int n, SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    protected SecretKey engineGenerateKey() {
        if (this.spec == null) {
            throw new IllegalStateException("TlsPrfGenerator must be initialized");
        }
        SecretKey secretKey = this.spec.getSecret();
        byte[] byArray = secretKey == null ? null : secretKey.getEncoded();
        try {
            byte[] byArray2 = this.spec.getLabel().getBytes("UTF8");
            int n = this.spec.getOutputLength();
            byte[] byArray3 = TlsPrfGenerator.doPRF(byArray, byArray2, this.spec.getSeed(), n);
            return new SecretKeySpec(byArray3, "TlsPrf");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ProviderException("Could not generate PRF", generalSecurityException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ProviderException("Could not generate PRF", unsupportedEncodingException);
        }
    }

    static final byte[] doPRF(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) throws NoSuchAlgorithmException, DigestException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        MessageDigest messageDigest2 = MessageDigest.getInstance("SHA1");
        return TlsPrfGenerator.doPRF(byArray, byArray2, byArray3, n, messageDigest, messageDigest2);
    }

    static final byte[] doPRF(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, MessageDigest messageDigest, MessageDigest messageDigest2) throws DigestException {
        if (byArray == null) {
            byArray = B0;
        }
        int n2 = byArray.length >> 1;
        int n3 = n2 + (byArray.length & 1);
        byte[] byArray4 = new byte[n];
        TlsPrfGenerator.expand(messageDigest, 16, byArray, 0, n3, byArray2, byArray3, byArray4);
        TlsPrfGenerator.expand(messageDigest2, 20, byArray, n2, n3, byArray2, byArray3, byArray4);
        return byArray4;
    }

    private static final void expand(MessageDigest messageDigest, int n, byte[] byArray, int n2, int n3, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws DigestException {
        int n4;
        byte[] byArray5 = (byte[])HMAC_ipad.clone();
        byte[] byArray6 = (byte[])HMAC_opad.clone();
        for (int i = 0; i < n3; ++i) {
            int n5 = i;
            byArray5[n5] = (byte)(byArray5[n5] ^ byArray[i + n2]);
            int n6 = i;
            byArray6[n6] = (byte)(byArray6[n6] ^ byArray[i + n2]);
        }
        byte[] byArray7 = new byte[n];
        byte[] byArray8 = null;
        int n7 = 0;
        for (int i = byArray4.length; i > 0; i -= n4) {
            messageDigest.update(byArray5);
            if (byArray8 == null) {
                messageDigest.update(byArray2);
                messageDigest.update(byArray3);
            } else {
                messageDigest.update(byArray8);
            }
            messageDigest.digest(byArray7, 0, n);
            messageDigest.update(byArray6);
            messageDigest.update(byArray7);
            if (byArray8 == null) {
                byArray8 = new byte[n];
            }
            messageDigest.digest(byArray8, 0, n);
            messageDigest.update(byArray5);
            messageDigest.update(byArray8);
            messageDigest.update(byArray2);
            messageDigest.update(byArray3);
            messageDigest.digest(byArray7, 0, n);
            messageDigest.update(byArray6);
            messageDigest.update(byArray7);
            messageDigest.digest(byArray7, 0, n);
            n4 = Math.min(n, i);
            for (int j = 0; j < n4; ++j) {
                int n8 = n7++;
                byArray4[n8] = (byte)(byArray4[n8] ^ byArray7[j]);
            }
        }
    }
}

