/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.AccessController;
import java.util.HashMap;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.AuthCacheValue;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.security.action.GetBooleanAction;

abstract class AuthenticationInfo
extends AuthCacheValue
implements Cloneable {
    static final char SERVER_AUTHENTICATION = 's';
    static final char PROXY_AUTHENTICATION = 'p';
    static boolean serializeAuth = AccessController.doPrivileged(new GetBooleanAction("http.auth.serializeRequests"));
    protected transient PasswordAuthentication pw;
    private static HashMap requests = new HashMap();
    char type;
    char authType;
    String protocol;
    String host;
    int port;
    String realm;
    String path;
    String s1;
    String s2;

    public PasswordAuthentication credentials() {
        return this.pw;
    }

    public AuthCacheValue.Type getAuthType() {
        return this.type == 's' ? AuthCacheValue.Type.Server : AuthCacheValue.Type.Proxy;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getPath() {
        return this.path;
    }

    public String getProtocolScheme() {
        return this.protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean requestIsInProgress(String string) {
        if (!serializeAuth) {
            return false;
        }
        HashMap hashMap = requests;
        synchronized (hashMap) {
            Thread thread = Thread.currentThread();
            Thread thread2 = (Thread)requests.get(string);
            if (thread2 == null) {
                requests.put(string, thread);
                return false;
            }
            if (thread2 == thread) {
                return false;
            }
            while (requests.containsKey(string)) {
                try {
                    requests.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void requestCompleted(String string) {
        HashMap hashMap = requests;
        synchronized (hashMap) {
            boolean bl;
            boolean bl2 = bl = requests.remove(string) != null;
            assert (bl);
            requests.notifyAll();
        }
    }

    AuthenticationInfo(char c, char c2, String string, int n, String string2) {
        this.type = c;
        this.authType = c2;
        this.protocol = "";
        this.host = string.toLowerCase();
        this.port = n;
        this.realm = string2;
        this.path = null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    AuthenticationInfo(char c, char c2, URL uRL, String string) {
        this.type = c;
        this.authType = c2;
        this.protocol = uRL.getProtocol().toLowerCase();
        this.host = uRL.getHost().toLowerCase();
        this.port = uRL.getPort();
        if (this.port == -1) {
            this.port = uRL.getDefaultPort();
        }
        this.realm = string;
        String string2 = uRL.getPath();
        this.path = string2.length() == 0 ? string2 : AuthenticationInfo.reducePath(string2);
    }

    static String reducePath(String string) {
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(46);
        if (n != -1) {
            if (n < n2) {
                return string.substring(0, n + 1);
            }
            return string;
        }
        return string;
    }

    static AuthenticationInfo getServerAuth(URL uRL) {
        int n = uRL.getPort();
        if (n == -1) {
            n = uRL.getDefaultPort();
        }
        String string = "s:" + uRL.getProtocol().toLowerCase() + ":" + uRL.getHost().toLowerCase() + ":" + n;
        return AuthenticationInfo.getAuth(string, uRL);
    }

    static AuthenticationInfo getServerAuth(URL uRL, String string, char c) {
        String string2;
        AuthenticationInfo authenticationInfo;
        int n = uRL.getPort();
        if (n == -1) {
            n = uRL.getDefaultPort();
        }
        if ((authenticationInfo = AuthenticationInfo.getAuth(string2 = "s:" + c + ":" + uRL.getProtocol().toLowerCase() + ":" + uRL.getHost().toLowerCase() + ":" + n + ":" + string, null)) == null && AuthenticationInfo.requestIsInProgress(string2)) {
            authenticationInfo = AuthenticationInfo.getAuth(string2, null);
        }
        return authenticationInfo;
    }

    static AuthenticationInfo getAuth(String string, URL uRL) {
        if (uRL == null) {
            return (AuthenticationInfo)cache.get(string, null);
        }
        return (AuthenticationInfo)cache.get(string, uRL.getPath());
    }

    static AuthenticationInfo getProxyAuth(String string, int n) {
        String string2 = "p::" + string.toLowerCase() + ":" + n;
        AuthenticationInfo authenticationInfo = (AuthenticationInfo)cache.get(string2, null);
        return authenticationInfo;
    }

    static AuthenticationInfo getProxyAuth(String string, int n, String string2, char c) {
        String string3 = "p:" + c + "::" + string.toLowerCase() + ":" + n + ":" + string2;
        AuthenticationInfo authenticationInfo = (AuthenticationInfo)cache.get(string3, null);
        if (authenticationInfo == null && AuthenticationInfo.requestIsInProgress(string3)) {
            authenticationInfo = (AuthenticationInfo)cache.get(string3, null);
        }
        return authenticationInfo;
    }

    void addToCache() {
        cache.put(this.cacheKey(true), this);
        if (this.supportsPreemptiveAuthorization()) {
            cache.put(this.cacheKey(false), this);
        }
        this.endAuthRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endAuthRequest() {
        if (!serializeAuth) {
            return;
        }
        HashMap hashMap = requests;
        synchronized (hashMap) {
            AuthenticationInfo.requestCompleted(this.cacheKey(true));
        }
    }

    void removeFromCache() {
        cache.remove(this.cacheKey(true), this);
        if (this.supportsPreemptiveAuthorization()) {
            cache.remove(this.cacheKey(false), this);
        }
    }

    abstract boolean supportsPreemptiveAuthorization();

    abstract String getHeaderName();

    abstract String getHeaderValue(URL var1, String var2);

    abstract boolean setHeaders(HttpURLConnection var1, HeaderParser var2, String var3);

    abstract boolean isAuthorizationStale(String var1);

    abstract void checkResponse(String var1, String var2, URL var3) throws IOException;

    String cacheKey(boolean bl) {
        if (bl) {
            return this.type + ":" + this.authType + ":" + this.protocol + ":" + this.host + ":" + this.port + ":" + this.realm;
        }
        return this.type + ":" + this.protocol + ":" + this.host + ":" + this.port;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.pw = new PasswordAuthentication(this.s1, this.s2.toCharArray());
        this.s1 = null;
        this.s2 = null;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.s1 = this.pw.getUserName();
        this.s2 = new String(this.pw.getPassword());
        objectOutputStream.defaultWriteObject();
    }
}

