/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding.soap.internal;

import com.sun.xml.internal.bind.api.BridgeContext;
import com.sun.xml.internal.messaging.saaj.util.ByteOutputStream;
import com.sun.xml.internal.ws.encoding.jaxb.JAXBBridgeInfo;
import com.sun.xml.internal.ws.encoding.soap.SerializationException;
import com.sun.xml.internal.ws.server.RuntimeContext;
import com.sun.xml.internal.ws.util.ASCIIUtility;
import com.sun.xml.internal.ws.util.ByteArrayDataSource;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.imageio.ImageIO;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;

public abstract class AttachmentBlock {
    public static AttachmentBlock fromDataHandler(String string, DataHandler dataHandler) {
        return new DataHandlerImpl(string, dataHandler);
    }

    public static AttachmentBlock fromSAAJ(AttachmentPart attachmentPart) {
        return new SAAJImpl(attachmentPart);
    }

    public static AttachmentBlock fromByteArray(String string, byte[] byArray, int n, int n2, String string2) {
        return new ByteArrayImpl(string, byArray, n, n2, string2);
    }

    public static AttachmentBlock fromByteArray(String string, byte[] byArray, String string2) {
        return new ByteArrayImpl(string, byArray, 0, byArray.length, string2);
    }

    public static AttachmentBlock fromJAXB(String string, JAXBBridgeInfo jAXBBridgeInfo, RuntimeContext runtimeContext, String string2) {
        return new JAXBImpl(string, jAXBBridgeInfo, runtimeContext, string2);
    }

    private AttachmentBlock() {
    }

    public abstract String getId();

    public final String getWSDLPartName() {
        String string = this.getId();
        int n = string.lastIndexOf(64, string.length());
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        if ((n = string2.lastIndexOf(61, string2.length())) == -1) {
            return null;
        }
        try {
            return URLDecoder.decode(string2.substring(0, n), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SerializationException(unsupportedEncodingException);
        }
    }

    public abstract String getContentType();

    public byte[] asByteArray() {
        try {
            return ASCIIUtility.getBytes(this.asInputStream());
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
    }

    public abstract DataHandler asDataHandler();

    public Source asSource() {
        return new StreamSource(this.asInputStream());
    }

    public InputStream asInputStream() {
        ByteOutputStream byteOutputStream = new ByteOutputStream();
        try {
            this.writeTo(byteOutputStream);
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
        return byteOutputStream.newInputStream();
    }

    public final void deserialize(BridgeContext bridgeContext, JAXBBridgeInfo jAXBBridgeInfo) {
        jAXBBridgeInfo.deserialize(this.asInputStream(), bridgeContext);
    }

    public void addTo(SOAPMessage sOAPMessage) throws SOAPException {
        AttachmentPart attachmentPart = sOAPMessage.createAttachmentPart(this.asDataHandler());
        attachmentPart.setContentId(this.getId());
        attachmentPart.setMimeHeader("Content-transfer-encoding", "binary");
        sOAPMessage.addAttachmentPart(attachmentPart);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        ASCIIUtility.copyStream(this.asInputStream(), outputStream);
    }

    public final Image asImage() throws IOException {
        return ImageIO.read(this.asInputStream());
    }

    private static final class ByteArrayImpl
    extends AttachmentBlock {
        private final String cid;
        private byte[] data;
        private int start;
        private int len;
        private final String mimeType;

        public ByteArrayImpl(String string, byte[] byArray, int n, int n2, String string2) {
            this.cid = string;
            this.data = byArray;
            this.start = n;
            this.len = n2;
            this.mimeType = string2;
        }

        public String getId() {
            return this.cid;
        }

        public String getContentType() {
            return this.mimeType;
        }

        public byte[] asByteArray() {
            if (this.start != 0 || this.len != this.data.length) {
                byte[] byArray = new byte[this.len];
                System.arraycopy(this.data, this.start, byArray, 0, this.len);
                this.start = 0;
                this.data = byArray;
            }
            return this.data;
        }

        public DataHandler asDataHandler() {
            return new DataHandler(new ByteArrayDataSource(this.data, this.start, this.len, this.getContentType()));
        }

        public InputStream asInputStream() {
            return new ByteArrayInputStream(this.data, this.start, this.len);
        }

        public void addTo(SOAPMessage sOAPMessage) throws SOAPException {
            AttachmentPart attachmentPart = sOAPMessage.createAttachmentPart();
            attachmentPart.setRawContentBytes(this.data, this.start, this.len, this.getContentType());
            attachmentPart.setContentId(this.getId());
            sOAPMessage.addAttachmentPart(attachmentPart);
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            outputStream.write(this.data, this.start, this.len);
        }
    }

    private static final class DataHandlerImpl
    extends AttachmentBlock {
        private final String cid;
        private final DataHandler dh;

        public DataHandlerImpl(String string, DataHandler dataHandler) {
            this.cid = string;
            this.dh = dataHandler;
        }

        public String getId() {
            return this.cid;
        }

        public String getContentType() {
            return this.dh.getContentType();
        }

        public DataHandler asDataHandler() {
            return this.dh;
        }

        public InputStream asInputStream() {
            try {
                return this.dh.getInputStream();
            }
            catch (IOException iOException) {
                throw new WebServiceException(iOException);
            }
        }
    }

    private static final class JAXBImpl
    extends AttachmentBlock
    implements DataSource {
        private final String id;
        private final JAXBBridgeInfo bridgeInfo;
        private final RuntimeContext rtContext;
        private final String type;

        public JAXBImpl(String string, JAXBBridgeInfo jAXBBridgeInfo, RuntimeContext runtimeContext, String string2) {
            this.id = string;
            this.bridgeInfo = jAXBBridgeInfo;
            this.rtContext = runtimeContext;
            this.type = string2;
        }

        public String getId() {
            return this.id;
        }

        public String getContentType() {
            return this.type;
        }

        public DataHandler asDataHandler() {
            return new DataHandler(this);
        }

        public InputStream getInputStream() {
            return this.asInputStream();
        }

        public String getName() {
            return null;
        }

        public OutputStream getOutputStream() {
            throw new UnsupportedOperationException();
        }

        public void writeTo(OutputStream outputStream) {
            this.bridgeInfo.serialize(this.rtContext.getBridgeContext(), outputStream, null);
        }
    }

    private static final class SAAJImpl
    extends AttachmentBlock {
        private final AttachmentPart ap;

        public SAAJImpl(AttachmentPart attachmentPart) {
            this.ap = attachmentPart;
        }

        public String getId() {
            return this.ap.getContentId();
        }

        public String getContentType() {
            return this.ap.getContentType();
        }

        public byte[] asByteArray() {
            try {
                return this.ap.getRawContentBytes();
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }

        public DataHandler asDataHandler() {
            try {
                return this.ap.getDataHandler();
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }

        public Source asSource() {
            try {
                return new StreamSource(this.ap.getRawContent());
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }

        public InputStream asInputStream() {
            try {
                return this.ap.getRawContent();
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }

        public void addTo(SOAPMessage sOAPMessage) {
            sOAPMessage.addAttachmentPart(this.ap);
        }
    }
}

