/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.io.File;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import org.openoffice.setup.DeckOfPanels;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.PanelController;
import org.openoffice.setup.ResourceManager;
import org.openoffice.setup.SetupActionListener;

public class SetupFrame
extends WindowAdapter {
    String StringPrevious = ResourceManager.getString("String_Previous");
    String StringNext = ResourceManager.getString("String_Next");
    String StringCancel = ResourceManager.getString("String_Cancel");
    String StringFinish = ResourceManager.getString("String_Finish");
    String StringHelp = ResourceManager.getString("String_Help");
    String StringAppTitle;
    Icon IconStarOffice;
    public static final String ACTION_NEXT = "ActionNext";
    public static final String ACTION_PREVIOUS = "ActionPrevious";
    public static final String ACTION_CANCEL = "ActionCancel";
    public static final String ACTION_HELP = "ActionHelp";
    public static final String ACTION_DETAILS = "ActionDetails";
    public static final String ACTION_STOP = "ActionStop";
    public static final int CODE_OK = 0;
    public static final int CODE_CANCEL = 1;
    public static final int CODE_ERROR = 2;
    public static final int BUTTON_NEXT = 1;
    public static final int BUTTON_PREVIOUS = 2;
    public static final int BUTTON_CANCEL = 3;
    public static final int BUTTON_HELP = 4;
    private JButton mNextButton;
    private JButton mPreviousButton;
    private JButton mCancelButton;
    private JButton mHelpButton;
    private JDialog mDialog;
    private JPanel mCardPanel;
    private CardLayout mCardLayout;
    private SetupActionListener mActionListener;
    private DeckOfPanels mDeck;

    public SetupFrame() {
        InstallData data = InstallData.getInstance();
        this.StringAppTitle = data.isInstallationMode() ? ResourceManager.getString("String_ApplicationTitle") : ResourceManager.getString("String_ApplicationTitleUninstallation");
        File iconFile = data.getInfoRoot("images");
        iconFile = new File(iconFile, "Setup.gif");
        this.IconStarOffice = ResourceManager.getIconFromPath(iconFile);
        this.mActionListener = new SetupActionListener(this);
        this.mDeck = new DeckOfPanels();
        this.mDialog = new JDialog();
        this.mDialog.setTitle(this.StringAppTitle);
        this.initFrame();
    }

    public void addPanel(PanelController panel, String name) {
        this.mCardPanel.add((Component)panel.getPanel(), name);
        panel.setSetupFrame(this);
        this.mDeck.addPanel(panel, name);
    }

    public PanelController getCurrentPanel() {
        return this.mDeck.getCurrentPanel();
    }

    public void setCurrentPanel(String name, boolean ignoreRepeat, boolean isNext) {
        if (name == null) {
            this.close(2);
        }
        PanelController panel = this.mDeck.getCurrentPanel();
        boolean repeatDialog = false;
        if (panel != null) {
            repeatDialog = panel.afterShow(isNext);
            if (isNext) {
                name = panel.getNext();
            }
            if (ignoreRepeat) {
                repeatDialog = false;
            }
        }
        if (repeatDialog) {
            name = panel.getName();
        }
        if ((panel = this.mDeck.setCurrentPanel(name)) != null) {
            this.setButtonsForPanel(panel);
            panel.beforeShow();
            this.mCardLayout.show(this.mCardPanel, name);
            panel.duringShow();
        }
    }

    void setButtonsForPanel(PanelController panel) {
        this.setButtonText(this.StringCancel, 3);
        this.setButtonText(this.StringHelp, 4);
        this.setButtonText(this.StringPrevious, 2);
        if (panel.getNext() == null) {
            this.setButtonText(this.StringFinish, 1);
        } else {
            this.setButtonText(this.StringNext, 1);
        }
    }

    public void setButtonText(String text, int button) {
        switch (button) {
            case 1: {
                this.mNextButton.setText(text);
                break;
            }
            case 2: {
                this.mPreviousButton.setText(text);
                break;
            }
            case 3: {
                this.mCancelButton.setText(text);
                break;
            }
            case 4: {
                this.mHelpButton.setText(text);
            }
        }
    }

    public void setButtonSelected(int button) {
        switch (button) {
            case 1: {
                this.mNextButton.grabFocus();
                break;
            }
            case 2: {
                this.mPreviousButton.grabFocus();
                break;
            }
            case 3: {
                this.mCancelButton.grabFocus();
                break;
            }
            case 4: {
                this.mHelpButton.grabFocus();
            }
        }
    }

    public void setButtonEnabled(boolean enabled, int button) {
        switch (button) {
            case 1: {
                this.mNextButton.setEnabled(enabled);
                break;
            }
            case 2: {
                this.mPreviousButton.setEnabled(enabled);
                break;
            }
            case 3: {
                this.mCancelButton.setEnabled(enabled);
                break;
            }
            case 4: {
                this.mHelpButton.setEnabled(enabled);
            }
        }
    }

    public void removeButtonIcon(int button) {
        switch (button) {
            case 1: {
                this.mNextButton.setIcon(null);
                break;
            }
            case 2: {
                this.mPreviousButton.setIcon(null);
                break;
            }
            case 3: {
                this.mCancelButton.setIcon(null);
                break;
            }
            case 4: {
                this.mHelpButton.setIcon(null);
            }
        }
    }

    public SetupActionListener getSetupActionListener() {
        return this.mActionListener;
    }

    void close(int code) {
        this.mDialog.dispose();
    }

    public JDialog getDialog() {
        return this.mDialog;
    }

    public int showFrame() {
        this.mDialog.pack();
        this.mDialog.setLocationRelativeTo(null);
        this.mDialog.setModal(true);
        this.mDialog.setResizable(false);
        this.mDialog.setVisible(true);
        return 0;
    }

    private void initFrame() {
        this.mDialog.getContentPane().setLayout(new BorderLayout());
        this.mCardLayout = new CardLayout();
        this.mCardPanel = new JPanel();
        this.mCardPanel.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        this.mCardPanel.setLayout(this.mCardLayout);
        this.mPreviousButton = new JButton();
        this.mNextButton = new JButton();
        this.mCancelButton = new JButton();
        this.mHelpButton = new JButton();
        this.mPreviousButton.setHorizontalTextPosition(4);
        this.mNextButton.setHorizontalTextPosition(2);
        this.mPreviousButton.setIcon(ResourceManager.getIcon("Icon_Previous"));
        this.mNextButton.setIcon(ResourceManager.getIcon("Icon_Next"));
        this.mPreviousButton.setActionCommand(ACTION_PREVIOUS);
        this.mNextButton.setActionCommand(ACTION_NEXT);
        this.mCancelButton.setActionCommand(ACTION_CANCEL);
        this.mHelpButton.setActionCommand(ACTION_HELP);
        this.mPreviousButton.addActionListener(this.mActionListener);
        this.mNextButton.addActionListener(this.mActionListener);
        this.mCancelButton.addActionListener(this.mActionListener);
        this.mHelpButton.addActionListener(this.mActionListener);
        Box ButtonBox = new Box(0);
        ButtonBox.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        ButtonBox.add(this.mPreviousButton);
        ButtonBox.add(Box.createHorizontalStrut(10));
        ButtonBox.add(this.mNextButton);
        ButtonBox.add(Box.createHorizontalStrut(30));
        ButtonBox.add(this.mCancelButton);
        ButtonBox.add(Box.createHorizontalStrut(10));
        ButtonBox.add(this.mHelpButton);
        JPanel ButtonPanel = new JPanel();
        JSeparator Separator = new JSeparator();
        ButtonPanel.setLayout(new BorderLayout());
        ButtonPanel.setPreferredSize(new Dimension(612, 44));
        ButtonPanel.add((Component)Separator, "North");
        ButtonPanel.add((Component)ButtonBox, "East");
        JPanel IconPanel = new JPanel();
        JLabel Icon2 = new JLabel();
        Icon2.setIcon(this.IconStarOffice);
        IconPanel.setLayout(new BorderLayout());
        IconPanel.add(Icon2);
        this.mDialog.getContentPane().add((Component)ButtonPanel, "South");
        this.mDialog.getContentPane().add((Component)this.mCardPanel, "Center");
        this.mDialog.getContentPane().add((Component)IconPanel, "West");
    }
}

