/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Util;

import java.io.File;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.ResourceManager;
import org.openoffice.setup.SetupData.SetupDataProvider;
import org.openoffice.setup.Util.Informer;
import org.openoffice.setup.Util.InstallChangeCtrl;
import org.openoffice.setup.Util.LogManager;
import org.openoffice.setup.Util.SystemManager;

public class Controller {
    private Controller() {
    }

    public static void checkPackagePathExistence(InstallData installData) {
        String packagePath = installData.getPackagePath();
        if (packagePath == null || packagePath.equals("")) {
            String message = ResourceManager.getString("String_InstallationOngoing_PackagePath_Not_Found");
            String title = ResourceManager.getString("String_Error");
            Informer.showErrorMessage(message, title);
            System.exit(1);
        }
    }

    public static void checkPackageFormat(InstallData installData) {
        String packageFormat = installData.getPackageFormat();
        String os = installData.getOSType();
        boolean notSupportedPackageFormat = true;
        if (os.equalsIgnoreCase("SunOS") && packageFormat.equalsIgnoreCase("pkg")) {
            notSupportedPackageFormat = false;
        }
        if (os.equalsIgnoreCase("Linux") && packageFormat.equalsIgnoreCase("rpm")) {
            notSupportedPackageFormat = false;
        }
        if (notSupportedPackageFormat) {
            System.err.println("Error: Package format not supported by this OS!");
            String mainmessage = ResourceManager.getString("String_Packageformat_Not_Supported");
            String osstring = ResourceManager.getString("String_Operating_System");
            String formatstring = ResourceManager.getString("String_Packageformat");
            String message = mainmessage + "\n" + osstring + ": " + os + "\n" + formatstring + ": " + packageFormat;
            String title = ResourceManager.getString("String_Error");
            Informer.showErrorMessage(message, title);
            System.exit(1);
        }
    }

    public static boolean createdSubDirectory(String dir) {
        boolean createdDirectory = false;
        boolean errorShown = false;
        String subDirName = "testdir";
        File testDir = new File(dir, subDirName);
        try {
            createdDirectory = SystemManager.create_directory(testDir.getPath());
        }
        catch (SecurityException ex) {
            String message = ResourceManager.getString("String_ChooseDirectory_No_Write_Access") + ": " + dir;
            String title = ResourceManager.getString("String_Error");
            Informer.showErrorMessage(message, title);
            errorShown = true;
        }
        if (!createdDirectory && !errorShown) {
            String message = ResourceManager.getString("String_ChooseDirectory_No_Write_Access") + ": " + dir;
            String title = ResourceManager.getString("String_Error");
            Informer.showErrorMessage(message, title);
            errorShown = true;
        }
        if (SystemManager.exists_directory(testDir.getPath())) {
            testDir.delete();
        }
        return createdDirectory;
    }

    public static boolean createdDirectory(String dir) {
        boolean createdDirectory = false;
        try {
            createdDirectory = SystemManager.create_directory(dir);
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        if (!createdDirectory) {
            String message = ResourceManager.getString("String_ChooseDirectory_No_Success") + ": " + dir;
            String title = ResourceManager.getString("String_Error");
            Informer.showErrorMessage(message, title);
        }
        return createdDirectory;
    }

    public static void checkForNewerVersion(InstallData installData) {
        LogManager.setCommandsHeaderLine("Checking change installation");
        InstallChangeCtrl.checkInstallChange(installData);
        if (installData.newerVersionExists()) {
            SetupDataProvider.setNewMacro("DIR", installData.getInstallDir());
            System.err.println("Error: A newer version is already installed in " + installData.getInstallDir() + " !");
            String message1 = ResourceManager.getString("String_Newer_Version_Installed_Found") + "\n" + installData.getInstallDir() + "\n";
            String message2 = ResourceManager.getString("String_Newer_Version_Installed_Remove");
            String message = message1 + "\n" + message2;
            String title = ResourceManager.getString("String_Error");
            Informer.showErrorMessage(message, title);
            System.exit(1);
        }
    }

    public static void checkForUidFile(InstallData installData) {
        File getuidFile = Controller.findUidFile(installData);
        if (getuidFile == null || !getuidFile.exists()) {
            System.err.println("Root privileges required for installation!");
            String message = ResourceManager.getString("String_Root_Privileges_Required_1") + "\n" + ResourceManager.getString("String_Root_Privileges_Required_2");
            String title = ResourceManager.getString("String_Error");
            Informer.showErrorMessage(message, title);
            System.exit(1);
        } else {
            installData.setGetUidPath(getuidFile.getPath());
        }
    }

    private static File findUidFile(InstallData data) {
        File getuidFile = null;
        if (data.isInstallationMode()) {
            String defaultfilename;
            String getuidpath = System.getProperty("GETUID_PATH");
            if (getuidpath != null && (getuidFile = new File(getuidpath)).isDirectory() && !getuidFile.isFile() && !(getuidFile = new File(getuidpath, defaultfilename = "getuid.so")).exists()) {
                getuidFile = null;
            }
        } else {
            getuidFile = new File(data.getGetUidPath());
        }
        return getuidFile;
    }
}

