/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CachedJarFile;
import com.sun.deploy.cache.CachedJarFile14;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.net.MessageHeader;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class CacheEntry {
    private File indexFile = null;
    private File tempDataFile = null;
    private WeakReference resourceRef = null;
    private int busy = 1;
    private int incomplete = 0;
    private int forceUpdate = 0;
    private int noHref = 0;
    private int cacheVersion = Cache.getCacheVersion();
    private int contentLength = 0;
    private int isShortcutImage = 0;
    private long lastModified = 0L;
    private long expirationDate = 0L;
    private String version = null;
    private String url = "";
    private String namespaceID = "";
    private MessageHeader headerFields = new MessageHeader();
    private Manifest manifest = null;
    private String filename = null;
    private long manifestPosition = -1L;
    private boolean doneReadManifest = false;
    private String codebaseIP = null;
    private static final String CODEBASEIP_HEADER_KEY = "deploy_resource_codebase_ip";
    private static final String META_FILE_DIR = "META-INF/";
    private static final String JAR_INDEX_NAME = "META-INF/INDEX.LIST";
    private HashMap signerMap = new HashMap();
    private CodeSigner[] signers = null;
    private HashMap signerMapCert = new HashMap();
    private Certificate[] certificates = null;

    public CacheEntry(File file) {
        String string = file.getPath();
        this.filename = string.substring(0, string.length() - 4);
        this.indexFile = file;
        this.tempDataFile = new File(this.filename + "-temp");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CacheEntry.this.readIndexFile();
                return null;
            }
        });
    }

    public void generateShortcutImage() throws IOException {
        if (this.getIsShortcutImage() == 0) {
            this.setIsShortcutImage(1);
            this.writeFileToDisk();
        }
    }

    public boolean isReferenceClear() {
        if (this.resourceRef == null) {
            return true;
        }
        return this.resourceRef.get() == null;
    }

    private static boolean isIssuerOf(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        Principal principal;
        Principal principal2 = x509Certificate.getIssuerDN();
        return ((Object)principal2).equals(principal = x509Certificate2.getSubjectDN());
    }

    private void lockFile(RandomAccessFile randomAccessFile, boolean bl) {
        if (randomAccessFile == null || !Config.isJavaVersionAtLeast14()) {
            return;
        }
        try {
            FileChannel fileChannel = randomAccessFile.getChannel();
            FileLock fileLock = null;
            while (fileLock == null) {
                try {
                    fileLock = fileChannel.lock(0L, Long.MAX_VALUE, bl);
                }
                catch (OverlappingFileLockException overlappingFileLockException) {
                    Trace.ignoredException(overlappingFileLockException);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        Trace.ignoredException(exception);
                    }
                    fileLock = null;
                }
            }
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void readIndexFile() {
        block15: {
            RandomAccessFile randomAccessFile;
            block14: {
                randomAccessFile = null;
                if (!this.indexFile.exists()) break block14;
                boolean bl = false;
                boolean bl2 = false;
                randomAccessFile = new RandomAccessFile(this.indexFile, "r");
                this.lockFile(randomAccessFile, true);
                this.setBusy(randomAccessFile.read());
                this.setIncomplete(randomAccessFile.read());
                this.setCacheVersion(randomAccessFile.readInt());
                if (this.getCacheVersion() == Cache.getCacheVersion()) {
                    this.setForceUpdate(randomAccessFile.read());
                    this.setNoHref(randomAccessFile.read());
                    this.setIsShortcutImage(randomAccessFile.read());
                    this.setContentLength(randomAccessFile.readInt());
                    this.setLastModified(randomAccessFile.readLong());
                    this.setExpirationDate(randomAccessFile.readLong());
                    this.setVersion(randomAccessFile.readUTF());
                    this.setURL(randomAccessFile.readUTF());
                    this.setNamespaceID(randomAccessFile.readUTF());
                    File file = new File(this.getResourceFilename());
                    if (!file.exists()) {
                        this.setIncomplete(1);
                    }
                } else {
                    this.setIncomplete(1);
                }
                if (this.getIncomplete() != 0) break block14;
                this.readHeaders(randomAccessFile);
                if (!this.isJarFile(this.url)) break block14;
                this.manifestPosition = randomAccessFile.getFilePointer();
            }
            Object var6_6 = null;
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                break block15;
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
            break block15;
            {
                catch (IOException iOException) {
                    this.setIncomplete(1);
                    Trace.ignoredException(iOException);
                    Object var6_7 = null;
                    try {
                        if (randomAccessFile != null) {
                            randomAccessFile.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException2) {
                        Trace.ignoredException(iOException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
                throw throwable;
            }
        }
    }

    void setBusy(int n) {
        this.busy = n;
    }

    int getBusy() {
        return this.busy;
    }

    private void setCacheVersion(int n) {
        this.cacheVersion = n;
    }

    int getCacheVersion() {
        return this.cacheVersion;
    }

    void setIncomplete(int n) {
        this.incomplete = n;
    }

    int getIncomplete() {
        return this.incomplete;
    }

    public void setIsShortcutImage(int n) {
        this.isShortcutImage = n;
    }

    public int getIsShortcutImage() {
        return this.isShortcutImage;
    }

    private void setForceUpdate(int n) {
        this.forceUpdate = n;
    }

    private int getForceUpdate() {
        return this.forceUpdate;
    }

    void setNoHref(int n) {
        this.noHref = n;
    }

    private int getNoHref() {
        return this.noHref;
    }

    boolean removeBefore(CacheEntry cacheEntry) {
        long l;
        long l2;
        if (this.getIncomplete() == 1) {
            return true;
        }
        if (cacheEntry.getIncomplete() == 1) {
            return false;
        }
        long l3 = this.getIndexFile().lastModified();
        if (l3 < (l2 = cacheEntry.getIndexFile().lastModified())) {
            return true;
        }
        if (l3 > l2) {
            return false;
        }
        long l4 = System.currentTimeMillis();
        long l5 = this.getExpirationDate();
        if (l5 != (l = cacheEntry.getExpirationDate())) {
            if (l5 < l4) {
                return true;
            }
            if (l < l4) {
                return false;
            }
        }
        return this.getContentLength() >= cacheEntry.getContentLength();
    }

    void setContentLength(int n) {
        this.contentLength = n;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public HashMap getCertificateMap() {
        if (!this.doneReadManifest) {
            try {
                this.readManifest();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
        }
        return this.signerMapCert;
    }

    public CodeSigner[] getCodeSigners() {
        if (!this.doneReadManifest) {
            try {
                this.readManifest();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
        }
        return this.signers;
    }

    public Certificate[] getCertificates() {
        if (!this.doneReadManifest) {
            try {
                this.readManifest();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
        }
        return this.certificates;
    }

    void setLastModified(long l) {
        this.lastModified = l;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    void setExpirationDate(long l) {
        this.expirationDate = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void updateExpirationInIndexFile(long l) {
        block11: {
            if (this.getExpirationDate() == l) {
                return;
            }
            this.setExpirationDate(l);
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.indexFile, "rw");
                this.lockFile(randomAccessFile, false);
                randomAccessFile.seek(21L);
                randomAccessFile.writeLong(this.expirationDate);
                Object var6_4 = null;
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
                break block11;
                {
                    catch (IOException iOException) {
                        Trace.ignoredException(iOException);
                        Object var6_5 = null;
                        try {
                            randomAccessFile.close();
                        }
                        catch (IOException iOException2) {
                            Trace.ignoredException(iOException2);
                        }
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException(iOException);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                Trace.ignoredException(fileNotFoundException);
            }
        }
    }

    public long getExpirationDate() {
        return this.expirationDate;
    }

    public boolean isExpired() {
        return this.expirationDate == 0L || System.currentTimeMillis() >= this.expirationDate;
    }

    void setURL(String string) {
        this.url = string;
    }

    public String getURL() {
        return this.url;
    }

    void setVersion(String string) {
        this.version = string == null || string.equals("") ? null : string;
    }

    public String getVersion() {
        return this.version;
    }

    private void setNamespaceID(String string) {
        this.namespaceID = string;
    }

    private String getNamespaceID() {
        return this.namespaceID;
    }

    public JarFile getJarFile() {
        JarFile jarFile = (JarFile)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (Config.isJavaVersionAtLeast15()) {
                    if (CacheEntry.this.resourceRef == null || CacheEntry.this.resourceRef.get() == null) {
                        try {
                            if (!CacheEntry.this.doneReadManifest) {
                                CacheEntry.this.readManifest();
                            }
                            CacheEntry.this.resourceRef = Cache.createResourceReference(new CachedJarFile(new File(CacheEntry.this.filename), CacheEntry.this.signers, CacheEntry.this.signerMap, CacheEntry.this.manifest), CacheEntry.this.url);
                        }
                        catch (IOException iOException) {
                            Trace.ignoredException(iOException);
                            return null;
                        }
                    }
                    return (CachedJarFile)CacheEntry.this.resourceRef.get();
                }
                if (CacheEntry.this.resourceRef == null || CacheEntry.this.resourceRef.get() == null) {
                    try {
                        if (!CacheEntry.this.doneReadManifest) {
                            CacheEntry.this.readManifest();
                        }
                        CacheEntry.this.resourceRef = Cache.createResourceReference(new CachedJarFile14(new File(CacheEntry.this.filename), CacheEntry.this.certificates, CacheEntry.this.signerMapCert, CacheEntry.this.manifest), CacheEntry.this.url);
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException(iOException);
                        return null;
                    }
                }
                return (CachedJarFile14)CacheEntry.this.resourceRef.get();
            }
        });
        return jarFile;
    }

    public String getResourceFilename() {
        return this.filename;
    }

    public File getDataFile() {
        Object t;
        if (this.resourceRef == null || this.resourceRef.get() == null) {
            if (this.filename != null && !this.url.equals("")) {
                this.resourceRef = Cache.createResourceReference(new File(this.filename), this.url);
            } else {
                return null;
            }
        }
        if ((t = this.resourceRef.get()) instanceof File) {
            return (File)t;
        }
        if (t instanceof JarFile) {
            return new File(((JarFile)t).getName());
        }
        return null;
    }

    File getTempDataFile() {
        return this.tempDataFile;
    }

    public File getIndexFile() {
        return this.indexFile;
    }

    public long getSize() {
        return this.getDataFile().length() + this.getIndexFile().length();
    }

    void setHeaders(MessageHeader messageHeader) {
        this.headerFields = messageHeader;
    }

    public Map getHeaders() {
        return this.headerFields.getHeaders();
    }

    public boolean isHttpNoCacheEnabled() {
        String string = this.headerFields.getValue(this.headerFields.getKey("cache-control"));
        if (string != null && string.equals("no-cache")) {
            return true;
        }
        String string2 = this.headerFields.getValue(this.headerFields.getKey("pragma"));
        return string2 != null && string2.equals("no-cache");
    }

    boolean processTempDataFile(boolean bl, DownloadEngine.DownloadDelegate downloadDelegate, URL uRL, URL uRL2, String string) {
        boolean bl2 = false;
        if (bl) {
            String string2 = null;
            String string3 = uRL2.getQuery().toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "&");
            String string4 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
                if (!string4.startsWith("current-version-id")) continue;
                string2 = string4.substring("current-version-id".length() + 1);
                break;
            }
            CacheEntry cacheEntry = null;
            cacheEntry = Cache.getCacheEntry(uRL, null, string2);
            File file = null;
            if (cacheEntry != null) {
                file = new File(cacheEntry.getResourceFilename());
            }
            File file2 = null;
            try {
                Trace.println(ResourceManager.getString("cacheEntry.applyJarDiff", uRL == null ? "" : uRL.toString(), string2, string), TraceLevel.NETWORK);
                file2 = DownloadEngine.applyPatch(file, this.tempDataFile, uRL, string, downloadDelegate, this.filename);
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
            this.tempDataFile.delete();
            if (file2 != null) {
                bl2 = true;
            }
        }
        if (this.tempDataFile.renameTo(new File(this.filename))) {
            bl2 = true;
        }
        return bl2;
    }

    public Manifest getManifest() {
        if (!this.doneReadManifest) {
            try {
                this.readManifest();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
        }
        return this.manifest;
    }

    private void setCodebaseIP(String string) {
        this.codebaseIP = string;
    }

    String getCodebaseIP() {
        return this.codebaseIP;
    }

    private void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    public void writeFileToDisk() throws IOException {
        block2: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        CacheEntry.this.writeFileToDisk(0, null);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!(privilegedActionException.getException() instanceof IOException)) break block2;
                throw (IOException)privilegedActionException.getException();
            }
        }
    }

    private boolean hasMimeType(String string) {
        if (this.headerFields != null) {
            Object v = this.getHeaders().get("content-type");
            if (!(v instanceof List)) {
                return false;
            }
            List list = (List)v;
            return list.contains(string);
        }
        return false;
    }

    private boolean hasRequestType(String string) {
        if (this.headerFields != null) {
            Object v = this.getHeaders().get("deploy-request-content-type");
            if (!(v instanceof List)) {
                return false;
            }
            List list = (List)v;
            return list.contains(string);
        }
        return false;
    }

    private boolean isJarFile(String string) {
        if (this.hasRequestType("application/x-java-archive")) {
            return true;
        }
        int n = string.indexOf(";");
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf("?")) != -1) {
            string = string.substring(0, n);
        }
        return string.toLowerCase().endsWith(".jar") || string.toLowerCase().endsWith(".jarjar") || this.hasMimeType("application/x-java-archive") || this.hasMimeType("application/java-archive") || this.hasMimeType("application/x-java-archive-diff");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void writeFileToDisk(int n, DownloadEngine.DownloadDelegate downloadDelegate) throws IOException {
        ZipFile zipFile;
        block18: {
            zipFile = null;
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.indexFile, "rw");
            try {
                try {
                    Object object;
                    this.lockFile(randomAccessFile, false);
                    randomAccessFile.writeByte(this.busy);
                    randomAccessFile.writeByte(this.incomplete);
                    randomAccessFile.writeInt(this.cacheVersion);
                    randomAccessFile.writeByte(this.forceUpdate);
                    randomAccessFile.writeByte(this.noHref);
                    randomAccessFile.writeByte(this.isShortcutImage);
                    randomAccessFile.writeInt(this.contentLength);
                    randomAccessFile.writeLong(this.lastModified);
                    randomAccessFile.writeLong(this.expirationDate);
                    randomAccessFile.writeUTF(this.version == null ? "" : this.version);
                    randomAccessFile.writeUTF(this.url);
                    randomAccessFile.writeUTF(this.namespaceID);
                    InetAddress inetAddress = null;
                    if (this.url != null && !this.url.equals("")) {
                        object = new URL(this.url);
                        String string = ((URL)object).getHost();
                        inetAddress = Cache.getHostIP(string);
                    }
                    if (this.headerFields != null || inetAddress != null) {
                        if (inetAddress != null) {
                            if (this.headerFields == null) {
                                this.headerFields = new MessageHeader();
                            }
                            this.headerFields.add(CODEBASEIP_HEADER_KEY, inetAddress.getHostAddress());
                        }
                        this.writeHeaders(randomAccessFile);
                    } else {
                        randomAccessFile.writeInt(0);
                    }
                    if (this.incomplete == 0) {
                        if (this.isJarFile(this.url)) {
                            zipFile = new JarFile(new File(this.filename));
                            object = ((JarFile)zipFile).getManifest();
                            this.manifestPosition = randomAccessFile.getFilePointer();
                            this.writeManifest(randomAccessFile, (JarFile)zipFile, (Manifest)object, n, downloadDelegate);
                            this.setManifest((Manifest)object);
                        }
                        DownloadEngine.addToUpdateCheckDoneList(this.url);
                        Cache.addToCleanupThreadLoadedResourceList(this.url);
                    }
                }
                catch (Exception exception) {
                    Trace.ignoredException(exception);
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                        randomAccessFile = null;
                    }
                    if (zipFile != null) {
                        zipFile.close();
                        zipFile = null;
                    }
                    Cache.removeCacheEntry(this);
                    if (exception instanceof JARSigningException) {
                        throw (JARSigningException)exception;
                    }
                    if (!(exception instanceof ZipException)) throw new IOException(exception.getMessage());
                    throw new JARSigningException(new URL(this.url), this.version, 2, exception);
                }
                Object var9_9 = null;
                if (randomAccessFile == null) break block18;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                if (zipFile != null) {
                    zipFile.close();
                }
                Cache.cleanup();
                throw throwable;
            }
            randomAccessFile.close();
        }
        if (zipFile != null) {
            zipFile.close();
        }
        Cache.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readManifest() throws IOException {
        if (this.manifestPosition == -1L) return;
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.indexFile, "r");
        this.lockFile(randomAccessFile, true);
        randomAccessFile.seek(this.manifestPosition);
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(randomAccessFile.getFD()));
            this.readManifest(bufferedInputStream);
            this.doneReadManifest = true;
            Object var4_3 = null;
            if (randomAccessFile == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (randomAccessFile == null) throw throwable;
            randomAccessFile.close();
            throw throwable;
        }
        randomAccessFile.close();
    }

    private void readManifest(BufferedInputStream bufferedInputStream) throws IOException {
        int n;
        Object object;
        ObjectInputStream objectInputStream = null;
        BufferedReader bufferedReader = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        objectInputStream = new ObjectInputStream(bufferedInputStream);
        bufferedReader = new BufferedReader(new InputStreamReader(objectInputStream));
        int n2 = objectInputStream.readInt();
        if (n2 > 0) {
            byte[] byArray = new byte[n2];
            objectInputStream.readFully(byArray, 0, n2);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            object = new GZIPInputStream(byteArrayInputStream);
            this.manifest = new Manifest();
            this.manifest.read((InputStream)object);
            ((GZIPInputStream)object).close();
            if (!Environment.isJavaPlugin()) {
                this.manifest.getMainAttributes().remove(Attributes.Name.CLASS_PATH);
            }
        }
        if ((n = objectInputStream.readInt()) > 0) {
            int n3;
            Object object2;
            int n4;
            String string;
            this.signerMap = new HashMap();
            this.certificates = new Certificate[n];
            try {
                for (int i = 0; i < n; ++i) {
                    this.certificates[i] = (Certificate)objectInputStream.readObject();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Error reading signer certificates");
            }
            String string2 = bufferedReader.readLine();
            object = null;
            while (string2 != null && !string2.equals("")) {
                string = string2;
                if (string.startsWith("/")) {
                    string = (String)object + string;
                } else {
                    int n5 = string.lastIndexOf("/");
                    if (n5 != -1) {
                        object = string.substring(0, n5);
                    }
                }
                string2 = bufferedReader.readLine();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " ", false);
                n4 = Integer.parseInt(stringTokenizer.nextToken());
                object2 = new int[n4];
                for (n3 = 0; n3 < n4; ++n3) {
                    object2[n3] = Integer.parseInt(stringTokenizer.nextToken());
                }
                arrayList.add(string);
                this.signerMapCert.put(string, object2);
                string2 = bufferedReader.readLine();
            }
            if (Config.isJavaVersionAtLeast15()) {
                string = bufferedReader.readLine();
                int n6 = 0;
                if (string != null) {
                    n6 = Integer.parseInt(string);
                }
                if (n6 == 0) {
                    try {
                        int n7;
                        Object object3;
                        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                        object2 = new ArrayList();
                        n3 = 0;
                        int n8 = 0;
                        int n9 = 0;
                        while (n9 < this.certificates.length) {
                            Serializable serializable;
                            object3 = new ArrayList();
                            n7 = n8;
                            for (n7 = n8; n7 < this.certificates.length; ++n7) {
                                serializable = null;
                                Serializable serializable2 = null;
                                if (this.certificates[n7] instanceof X509Certificate) {
                                    serializable = (X509Certificate)this.certificates[n7];
                                }
                                serializable2 = n7 + 1 < this.certificates.length && this.certificates[n7 + 1] instanceof X509Certificate ? (X509Certificate)this.certificates[n7 + 1] : serializable;
                                ((ArrayList)object3).add(serializable);
                                if (!CacheEntry.isIssuerOf((X509Certificate)serializable, (X509Certificate)serializable2)) break;
                            }
                            n9 = n7 < this.certificates.length ? n7 + 1 : n7;
                            serializable = certificateFactory.generateCertPath((List<? extends Certificate>)object3);
                            ((ArrayList)object3).clear();
                            ((ArrayList)object2).add(serializable);
                            n8 = n9;
                            ++n3;
                        }
                        this.signers = new CodeSigner[n3];
                        object3 = new int[n3];
                        for (n7 = 0; n7 < n3; ++n7) {
                            this.signers[n7] = new CodeSigner((CertPath)((ArrayList)object2).get(n7), null);
                            object3[n7] = n7;
                        }
                        for (n7 = 0; n7 < arrayList.size(); ++n7) {
                            this.signerMap.put(arrayList.get(n7), object3);
                        }
                    }
                    catch (CertificateException certificateException) {
                        throw new IOException("Error process signer certificates");
                    }
                }
                if (n6 > 0) {
                    this.signers = new CodeSigner[n6];
                    try {
                        for (n4 = 0; n4 < n6; ++n4) {
                            this.signers[n4] = (CodeSigner)objectInputStream.readObject();
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new IOException("Error reading code signer");
                    }
                    String string3 = bufferedReader.readLine();
                    object2 = null;
                    while (string3 != null && !string3.equals("")) {
                        String string4 = string3;
                        if (string4.startsWith("/")) {
                            string4 = (String)object2 + string4;
                        } else {
                            int n10 = string4.lastIndexOf("/");
                            if (n10 != -1) {
                                object2 = string4.substring(0, n10);
                            }
                        }
                        string3 = bufferedReader.readLine();
                        StringTokenizer stringTokenizer = new StringTokenizer(string3, " ", false);
                        int n11 = Integer.parseInt(stringTokenizer.nextToken());
                        int[] nArray = new int[n11];
                        for (int i = 0; i < n11; ++i) {
                            nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
                        }
                        this.signerMap.put(string4, nArray);
                        string3 = bufferedReader.readLine();
                    }
                }
            }
        } else {
            Trace.println(ResourceManager.getString("cacheEntry.unsignedJar", this.url), TraceLevel.NETWORK);
        }
    }

    public String getNativeLibPath() {
        return this.getResourceFilename() + "-n";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeManifest(RandomAccessFile randomAccessFile, JarFile jarFile, Manifest manifest, int n, DownloadEngine.DownloadDelegate downloadDelegate) throws IOException {
        int n2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        ArrayList<CodeSigner> arrayList2 = new ArrayList<CodeSigner>();
        CodeSigner[] codeSignerArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        FilterOutputStream filterOutputStream = null;
        byte[] byArray = new byte[2048];
        Enumeration<JarEntry> enumeration = jarFile.entries();
        int n3 = jarFile.size();
        int n4 = 0;
        URL uRL = new URL(this.url);
        if (downloadDelegate != null) {
            downloadDelegate.validating(uRL, 0, n3);
        }
        while (enumeration.hasMoreElements()) {
            block35: {
                object6 = enumeration.nextElement();
                object5 = ((ZipEntry)object6).getName();
                if (((String)object5).startsWith(META_FILE_DIR) && !((String)object5).equals(JAR_INDEX_NAME)) continue;
                object4 = null;
                int n5 = 0;
                try {
                    try {
                        object4 = jarFile.getInputStream((ZipEntry)object6);
                        if (n == 1) {
                            object3 = new File(this.getNativeLibPath(), (String)object5);
                            if (((ZipEntry)object6).isDirectory()) {
                                object3.mkdirs();
                            } else {
                                object3.getParentFile().mkdirs();
                                filterOutputStream = new BufferedOutputStream(new FileOutputStream((File)object3));
                            }
                        }
                        while ((n5 = ((InputStream)object4).read(byArray, 0, byArray.length)) != -1) {
                            if (filterOutputStream == null) continue;
                            ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n5);
                        }
                        object2 = null;
                        if (filterOutputStream == null) break block35;
                    }
                    catch (SecurityException securityException) {
                        throw new JARSigningException(new URL(this.url), this.version, 2, securityException);
                    }
                }
                catch (Throwable throwable) {
                    object2 = null;
                    if (filterOutputStream != null) {
                        filterOutputStream.close();
                        filterOutputStream = null;
                    }
                    if (object4 == null) throw throwable;
                    ((InputStream)object4).close();
                    throw throwable;
                }
                filterOutputStream.close();
                filterOutputStream = null;
            }
            if (object4 != null) {
                ((InputStream)object4).close();
            }
            if ((object3 = ((JarEntry)object6).getCertificates()) != null && ((Certificate[])object3).length > 0) {
                object = new int[((Certificate[])object3).length];
                for (int i = 0; i < ((Certificate[])object3).length; ++i) {
                    n2 = arrayList.indexOf(object3[i]);
                    if (n2 == -1) {
                        n2 = arrayList.size();
                        arrayList.add(object3[i]);
                    }
                    object[i] = n2;
                }
                this.signerMapCert.put(object5, object);
            }
            if (Config.isJavaVersionAtLeast15() && (codeSignerArray = ((JarEntry)object6).getCodeSigners()) != null && codeSignerArray.length > 0) {
                object = new int[codeSignerArray.length];
                for (int i = 0; i < codeSignerArray.length; ++i) {
                    n2 = arrayList2.indexOf(codeSignerArray[i]);
                    if (n2 == -1) {
                        n2 = arrayList2.size();
                        arrayList2.add(codeSignerArray[i]);
                    }
                    object[i] = n2;
                }
                this.signerMap.put(object5, object);
            }
            if (downloadDelegate == null) continue;
            downloadDelegate.validating(uRL, ++n4, n3);
        }
        if (manifest != null) {
            object6 = new ByteArrayOutputStream();
            object5 = new GZIPOutputStream((OutputStream)object6);
            manifest.write((OutputStream)object5);
            ((DeflaterOutputStream)object5).close();
            object4 = ((ByteArrayOutputStream)object6).toByteArray();
            objectOutputStream.writeInt(((byte[])object4).length);
            objectOutputStream.write((byte[])object4);
        } else {
            objectOutputStream.writeInt(0);
        }
        object6 = new BufferedWriter(new OutputStreamWriter(objectOutputStream));
        if (!arrayList.isEmpty()) {
            objectOutputStream.writeInt(arrayList.size());
            object5 = arrayList.iterator();
            while (object5.hasNext()) {
                objectOutputStream.writeObject(object5.next());
            }
            object4 = this.signerMapCert.keySet().iterator();
            String string = null;
            while (object4.hasNext()) {
                object3 = (String)object4.next();
                object = (int[])this.signerMapCert.get(object3);
                if (object3.indexOf("/") != -1) {
                    object2 = object3.substring(0, object3.lastIndexOf("/"));
                    if (string != null && ((String)object2).equals(string)) {
                        object3 = object3.substring(((String)object2).length());
                    }
                    string = object2;
                }
                ((Writer)object6).write((String)object3);
                ((BufferedWriter)object6).newLine();
                object2 = String.valueOf(((int[])object).length);
                for (n2 = 0; n2 < ((int[])object).length; ++n2) {
                    object2 = (String)object2 + " " + (int)object[n2];
                }
                ((BufferedWriter)object6).write((String)object2, 0, ((String)object2).length());
                ((BufferedWriter)object6).newLine();
            }
            ((BufferedWriter)object6).newLine();
            ((BufferedWriter)object6).flush();
        } else {
            objectOutputStream.writeInt(0);
        }
        if (!arrayList2.isEmpty()) {
            object5 = new Integer(arrayList2.size());
            ((Writer)object6).write(((Integer)object5).toString());
            ((BufferedWriter)object6).newLine();
            ((BufferedWriter)object6).flush();
            object4 = arrayList2.iterator();
            while (object4.hasNext()) {
                objectOutputStream.writeObject(object4.next());
            }
            Iterator iterator = this.signerMap.keySet().iterator();
            object3 = null;
            while (iterator.hasNext()) {
                String string;
                object = (String)iterator.next();
                object2 = (int[])this.signerMap.get(object);
                if (((String)object).indexOf("/") != -1) {
                    string = ((String)object).substring(0, ((String)object).lastIndexOf("/"));
                    if (object3 != null && string.equals(object3)) {
                        object = ((String)object).substring(string.length());
                    }
                    object3 = string;
                }
                ((Writer)object6).write((String)object);
                ((BufferedWriter)object6).newLine();
                string = String.valueOf(((Object)object2).length);
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    string = string + " " + (int)object2[i];
                }
                ((BufferedWriter)object6).write(string, 0, string.length());
                ((BufferedWriter)object6).newLine();
            }
        } else {
            ((Writer)object6).write("0");
        }
        ((BufferedWriter)object6).flush();
        objectOutputStream.flush();
        randomAccessFile.write(byteArrayOutputStream.toByteArray());
        if (Config.isJavaVersionAtLeast15()) {
            if (arrayList2.isEmpty()) return;
            this.signers = new CodeSigner[arrayList2.size()];
            this.signers = arrayList2.toArray(this.signers);
            return;
        }
        if (arrayList.isEmpty()) return;
        this.certificates = new Certificate[arrayList.size()];
        this.certificates = arrayList.toArray(this.certificates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeaders(RandomAccessFile randomAccessFile) throws IOException {
        try {
            for (int i = randomAccessFile.readInt(); i > 0; --i) {
                String string = randomAccessFile.readUTF();
                if (string.equals(CODEBASEIP_HEADER_KEY)) {
                    this.setCodebaseIP(randomAccessFile.readUTF());
                    continue;
                }
                if (string.equals("<null>")) {
                    string = null;
                }
                this.headerFields.add(string, randomAccessFile.readUTF());
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHeaders(RandomAccessFile randomAccessFile) throws IOException {
        try {
            Map map = this.headerFields.getHeaders();
            if (!map.isEmpty()) {
                randomAccessFile.writeInt(map.size());
                for (int i = 0; i < map.size(); ++i) {
                    String string = this.headerFields.getKey(i);
                    if (null == string) {
                        string = "<null>";
                    }
                    randomAccessFile.writeUTF(string);
                    randomAccessFile.writeUTF(this.headerFields.getValue(i));
                }
            } else {
                randomAccessFile.writeInt(0);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }

    private String printManifest() {
        if (this.manifest != null) {
            StringBuffer stringBuffer = new StringBuffer();
            Attributes attributes = this.manifest.getMainAttributes();
            Iterator<Object> iterator = attributes.keySet().iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                stringBuffer.append("key: " + object);
                stringBuffer.append(" value: " + attributes.get(object) + "\n");
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-----Cache Entry------\n");
        stringBuffer.append("busy: " + this.getBusy() + "\n");
        stringBuffer.append("incomplete: " + this.getIncomplete() + "\n");
        stringBuffer.append("cacheVersion: " + this.getCacheVersion() + "\n");
        stringBuffer.append("forceUpdate: " + this.getForceUpdate() + "\n");
        stringBuffer.append("noHref: " + this.getNoHref() + "\n");
        stringBuffer.append("contentLength: " + this.getContentLength() + "\n");
        long l = this.getLastModified();
        stringBuffer.append("lastModified: " + l + " [" + new Date(l).toString() + "]\n");
        stringBuffer.append("expirationDate: " + this.getExpirationDate() + "\n");
        stringBuffer.append("version: " + this.getVersion() + "\n");
        stringBuffer.append("URL: " + this.url + "\n");
        stringBuffer.append("NamespaceID: " + this.getNamespaceID() + "\n");
        stringBuffer.append("HTTP/HTTPS Header: " + this.getHeaders() + "\n");
        if (this.getManifest() != null) {
            stringBuffer.append("Jar-Manifest Main Attributes:\n");
            stringBuffer.append(this.printManifest());
            stringBuffer.append("----------------------\n");
        }
        return stringBuffer.toString();
    }
}

