/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Vector;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.CompositeView;
import javax.swing.text.Element;
import javax.swing.text.LabelView;
import javax.swing.text.Position;
import javax.swing.text.TabExpander;
import javax.swing.text.TabableView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class FlowView
extends BoxView {
    protected int layoutSpan = Integer.MAX_VALUE;
    protected View layoutPool;
    protected FlowStrategy strategy = new FlowStrategy();

    public FlowView(Element element, int n) {
        super(element, n);
    }

    public int getFlowAxis() {
        if (this.getAxis() == 1) {
            return 0;
        }
        return 1;
    }

    public int getFlowSpan(int n) {
        return this.layoutSpan;
    }

    public int getFlowStart(int n) {
        return 0;
    }

    protected abstract View createRow();

    protected void loadChildren(ViewFactory viewFactory) {
        if (this.layoutPool == null) {
            this.layoutPool = new LogicalView(this.getElement());
        }
        this.layoutPool.setParent(this);
        this.strategy.insertUpdate(this, null, null);
    }

    protected int getViewIndexAtPosition(int n) {
        if (n >= this.getStartOffset() && n < this.getEndOffset()) {
            for (int i = 0; i < this.getViewCount(); ++i) {
                View view = this.getView(i);
                if (n < view.getStartOffset() || n >= view.getEndOffset()) continue;
                return i;
            }
        }
        return -1;
    }

    protected void layout(int n, int n2) {
        int n3 = this.getFlowAxis();
        int n4 = n3 == 0 ? n : n2;
        if (this.layoutSpan != n4) {
            this.layoutChanged(n3);
            this.layoutChanged(this.getAxis());
            this.layoutSpan = n4;
        }
        if (!this.isLayoutValid(n3)) {
            int n5 = this.getAxis();
            int n6 = n5 == 0 ? this.getWidth() : this.getHeight();
            this.strategy.layout(this);
            int n7 = (int)this.getPreferredSpan(n5);
            if (n6 != n7) {
                Container container;
                View view = this.getParent();
                if (view != null) {
                    view.preferenceChanged(this, n5 == 0, n5 == 1);
                }
                if ((container = this.getContainer()) != null) {
                    container.repaint();
                }
            }
        }
        super.layout(n, n2);
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        float f = this.layoutPool.getPreferredSpan(n);
        float f2 = this.layoutPool.getMinimumSpan(n);
        sizeRequirements.minimum = (int)f2;
        sizeRequirements.preferred = Math.max(sizeRequirements.minimum, (int)f);
        sizeRequirements.maximum = Integer.MAX_VALUE;
        sizeRequirements.alignment = 0.5f;
        return sizeRequirements;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.layoutPool.insertUpdate(documentEvent, shape, viewFactory);
        this.strategy.insertUpdate(this, documentEvent, this.getInsideAllocation(shape));
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.layoutPool.removeUpdate(documentEvent, shape, viewFactory);
        this.strategy.removeUpdate(this, documentEvent, this.getInsideAllocation(shape));
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.layoutPool.changedUpdate(documentEvent, shape, viewFactory);
        this.strategy.changedUpdate(this, documentEvent, this.getInsideAllocation(shape));
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view == null && this.layoutPool != null) {
            this.layoutPool.setParent(null);
        }
    }

    public static class FlowStrategy {
        int damageStart = Integer.MAX_VALUE;
        Vector<View> viewBuffer;

        void addDamage(FlowView flowView, int n) {
            if (n >= flowView.getStartOffset() && n < flowView.getEndOffset()) {
                this.damageStart = Math.min(this.damageStart, n);
            }
        }

        void unsetDamage() {
            this.damageStart = Integer.MAX_VALUE;
        }

        public void insertUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
            if (documentEvent != null) {
                this.addDamage(flowView, documentEvent.getOffset());
            }
            if (rectangle != null) {
                Container container = flowView.getContainer();
                if (container != null) {
                    container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            } else {
                flowView.preferenceChanged(null, true, true);
            }
        }

        public void removeUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
            this.addDamage(flowView, documentEvent.getOffset());
            if (rectangle != null) {
                Container container = flowView.getContainer();
                if (container != null) {
                    container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            } else {
                flowView.preferenceChanged(null, true, true);
            }
        }

        public void changedUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
            this.addDamage(flowView, documentEvent.getOffset());
            if (rectangle != null) {
                Container container = flowView.getContainer();
                if (container != null) {
                    container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            } else {
                flowView.preferenceChanged(null, true, true);
            }
        }

        protected View getLogicalView(FlowView flowView) {
            return flowView.layoutPool;
        }

        public void layout(FlowView flowView) {
            int n;
            int n2;
            View view = this.getLogicalView(flowView);
            int n3 = flowView.getEndOffset();
            if (flowView.majorAllocValid) {
                if (this.damageStart == Integer.MAX_VALUE) {
                    return;
                }
                while ((n2 = flowView.getViewIndexAtPosition(this.damageStart)) < 0) {
                    --this.damageStart;
                }
                if (n2 > 0) {
                    --n2;
                }
                n = flowView.getView(n2).getStartOffset();
            } else {
                n2 = 0;
                n = flowView.getStartOffset();
            }
            this.reparentViews(view, n);
            this.viewBuffer = new Vector(10, 10);
            int n4 = flowView.getViewCount();
            while (n < n3) {
                View view2;
                if (n2 >= n4) {
                    view2 = flowView.createRow();
                    flowView.append(view2);
                } else {
                    view2 = flowView.getView(n2);
                }
                n = this.layoutRow(flowView, n2, n);
                ++n2;
            }
            this.viewBuffer = null;
            if (n2 < n4) {
                flowView.replace(n2, n4 - n2, null);
            }
            this.unsetDamage();
        }

        protected int layoutRow(FlowView flowView, int n, int n2) {
            Object object;
            View view = flowView.getView(n);
            float f = flowView.getFlowStart(n);
            float f2 = flowView.getFlowSpan(n);
            int n3 = flowView.getEndOffset();
            TabExpander tabExpander = flowView instanceof TabExpander ? (TabExpander)((Object)flowView) : null;
            int n4 = flowView.getFlowAxis();
            int n5 = 0;
            float f3 = 0.0f;
            float f4 = 0.0f;
            int n6 = -1;
            int n7 = 0;
            this.viewBuffer.clear();
            while (n2 < n3 && f2 >= 0.0f && (object = this.createView(flowView, n2, (int)f2, n)) != null) {
                float f5;
                int n8 = ((View)object).getBreakWeight(n4, f, f2);
                if (n8 >= 3000) {
                    View view2 = ((View)object).breakView(n4, n2, f, f2);
                    if (view2 != null) {
                        this.viewBuffer.add(view2);
                        break;
                    }
                    if (n7 != 0) break;
                    this.viewBuffer.add((View)object);
                    break;
                }
                if (n8 >= n5 && n8 > 0) {
                    n5 = n8;
                    f3 = f;
                    f4 = f2;
                    n6 = n7;
                }
                if ((f5 = n4 == 0 && object instanceof TabableView ? ((TabableView)object).getTabbedSpan(f, tabExpander) : ((View)object).getPreferredSpan(n4)) > f2 && n6 >= 0) {
                    if (n6 < n7) {
                        object = this.viewBuffer.get(n6);
                    }
                    for (int i = n7 - 1; i >= n6; --i) {
                        this.viewBuffer.remove(i);
                    }
                    object = ((View)object).breakView(n4, ((View)object).getStartOffset(), f3, f4);
                }
                f2 -= f5;
                f += f5;
                this.viewBuffer.add((View)object);
                n2 = ((View)object).getEndOffset();
                ++n7;
            }
            object = new View[this.viewBuffer.size()];
            this.viewBuffer.toArray((T[])object);
            view.replace(0, view.getViewCount(), (View[])object);
            return ((View[])object).length > 0 ? view.getEndOffset() : n2;
        }

        protected void adjustRow(FlowView flowView, int n, int n2, int n3) {
            View view;
            View view2;
            int n4;
            int n5 = flowView.getFlowAxis();
            View view3 = flowView.getView(n);
            int n6 = view3.getViewCount();
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = -1;
            for (n4 = 0; n4 < n6; ++n4) {
                int n11;
                view2 = view3.getView(n4);
                int n12 = view2.getBreakWeight(n5, n3 + n7, n11 = n2 - n7);
                if (n12 >= n8 && n12 > 0) {
                    n8 = n12;
                    n10 = n4;
                    n9 = n7;
                    if (n12 >= 3000) break;
                }
                n7 = (int)((float)n7 + view2.getPreferredSpan(n5));
            }
            if (n10 < 0) {
                return;
            }
            n4 = n2 - n9;
            view2 = view3.getView(n10);
            view2 = view2.breakView(n5, view2.getStartOffset(), n3 + n9, n4);
            View[] viewArray = new View[]{view2};
            View view4 = this.getLogicalView(flowView);
            int n13 = view3.getView(n10).getStartOffset();
            int n14 = view3.getEndOffset();
            for (int i = 0; i < view4.getViewCount() && (view = view4.getView(i)).getEndOffset() <= n14; ++i) {
                if (view.getStartOffset() < n13) continue;
                view.setParent(view4);
            }
            view3.replace(n10, n6 - n10, viewArray);
        }

        void reparentViews(View view, int n) {
            int n2 = view.getViewIndex(n, Position.Bias.Forward);
            if (n2 >= 0) {
                for (int i = n2; i < view.getViewCount(); ++i) {
                    view.getView(i).setParent(view);
                }
            }
        }

        protected View createView(FlowView flowView, int n, int n2, int n3) {
            int n4;
            View view = this.getLogicalView(flowView);
            View view2 = view.getView(n4 = view.getViewIndex(n, Position.Bias.Forward));
            if (n == view2.getStartOffset()) {
                return view2;
            }
            view2 = view2.createFragment(n, view2.getEndOffset());
            return view2;
        }
    }

    static class LogicalView
    extends CompositeView {
        LogicalView(Element element) {
            super(element);
        }

        protected int getViewIndexAtPosition(int n) {
            Element element = this.getElement();
            if (element.isLeaf()) {
                return 0;
            }
            return super.getViewIndexAtPosition(n);
        }

        protected void loadChildren(ViewFactory viewFactory) {
            Element element = this.getElement();
            if (element.isLeaf()) {
                LabelView labelView = new LabelView(element);
                this.append(labelView);
            } else {
                super.loadChildren(viewFactory);
            }
        }

        public AttributeSet getAttributes() {
            View view = this.getParent();
            return view != null ? view.getAttributes() : null;
        }

        public float getPreferredSpan(int n) {
            float f = 0.0f;
            float f2 = 0.0f;
            int n2 = this.getViewCount();
            for (int i = 0; i < n2; ++i) {
                View view = this.getView(i);
                f2 += view.getPreferredSpan(n);
                if (view.getBreakWeight(n, 0.0f, 2.1474836E9f) < 3000) continue;
                f = Math.max(f, f2);
                f2 = 0.0f;
            }
            f = Math.max(f, f2);
            return f;
        }

        public float getMinimumSpan(int n) {
            float f = 0.0f;
            float f2 = 0.0f;
            boolean bl = false;
            int n2 = this.getViewCount();
            for (int i = 0; i < n2; ++i) {
                View view = this.getView(i);
                if (view.getBreakWeight(n, 0.0f, 2.1474836E9f) == 0) {
                    f2 += view.getPreferredSpan(n);
                    bl = true;
                } else if (bl) {
                    f = Math.max(f2, f);
                    bl = false;
                    f2 = 0.0f;
                }
                if (!(view instanceof ComponentView)) continue;
                f = Math.max(f, view.getMinimumSpan(n));
            }
            f = Math.max(f, f2);
            return f;
        }

        protected void forwardUpdateToView(View view, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            View view2 = view.getParent();
            view.setParent(this);
            super.forwardUpdateToView(view, documentEvent, shape, viewFactory);
            view.setParent(view2);
        }

        public void paint(Graphics graphics, Shape shape) {
        }

        protected boolean isBefore(int n, int n2, Rectangle rectangle) {
            return false;
        }

        protected boolean isAfter(int n, int n2, Rectangle rectangle) {
            return false;
        }

        protected View getViewAtPoint(int n, int n2, Rectangle rectangle) {
            return null;
        }

        protected void childAllocation(int n, Rectangle rectangle) {
        }
    }
}

