/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SpinnerUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSpinnerUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthArrowButton;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthSpinnerUI
extends BasicSpinnerUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;

    SynthSpinnerUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthSpinnerUI();
    }

    protected void installListeners() {
        super.installListeners();
        this.spinner.addPropertyChangeListener(this);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.spinner.removePropertyChangeListener(this);
    }

    protected void installDefaults() {
        LayoutManager layoutManager = this.spinner.getLayout();
        if (layoutManager == null || layoutManager instanceof UIResource) {
            this.spinner.setLayout(this.createLayout());
        }
        this.updateStyle(this.spinner);
    }

    private void updateStyle(JSpinner jSpinner) {
        SynthContext synthContext = this.getContext(jSpinner, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle && synthStyle != null) {
            this.installKeyboardActions();
        }
        synthContext.dispose();
    }

    protected void uninstallDefaults() {
        if (this.spinner.getLayout() instanceof UIResource) {
            this.spinner.setLayout(null);
        }
        SynthContext synthContext = this.getContext(this.spinner, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected LayoutManager createLayout() {
        return new SpinnerLayout();
    }

    protected Component createPreviousButton() {
        SynthArrowButton synthArrowButton = new SynthArrowButton(5);
        synthArrowButton.setName("Spinner.previousButton");
        this.installPreviousButtonListeners(synthArrowButton);
        return synthArrowButton;
    }

    protected Component createNextButton() {
        SynthArrowButton synthArrowButton = new SynthArrowButton(1);
        synthArrowButton.setName("Spinner.nextButton");
        this.installNextButtonListeners(synthArrowButton);
        return synthArrowButton;
    }

    protected JComponent createEditor() {
        JComponent jComponent = this.spinner.getEditor();
        jComponent.setName("Spinner.editor");
        this.updateEditorAlignment(jComponent);
        return jComponent;
    }

    protected void replaceEditor(JComponent jComponent, JComponent jComponent2) {
        this.spinner.remove(jComponent);
        this.updateEditorAlignment(jComponent2);
        this.spinner.add((Component)jComponent2, "Editor");
    }

    private void updateEditorAlignment(JComponent jComponent) {
        SynthContext synthContext;
        Integer n;
        if (jComponent instanceof JSpinner.DefaultEditor && (n = (Integer)(synthContext = this.getContext(this.spinner)).getStyle().get(synthContext, "Spinner.editorAlignment")) != null) {
            JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)jComponent).getTextField();
            jFormattedTextField.setHorizontalAlignment(n);
        }
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintSpinnerBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintSpinnerBorder(synthContext, graphics, n, n2, n3, n4);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        JSpinner jSpinner = (JSpinner)propertyChangeEvent.getSource();
        SpinnerUI spinnerUI = jSpinner.getUI();
        if (spinnerUI instanceof SynthSpinnerUI) {
            SynthSpinnerUI synthSpinnerUI = (SynthSpinnerUI)spinnerUI;
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                synthSpinnerUI.updateStyle(jSpinner);
            }
        }
    }

    private static class SpinnerLayout
    implements LayoutManager,
    UIResource {
        private Component nextButton = null;
        private Component previousButton = null;
        private Component editor = null;

        private SpinnerLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
            if ("Next".equals(string)) {
                this.nextButton = component;
            } else if ("Previous".equals(string)) {
                this.previousButton = component;
            } else if ("Editor".equals(string)) {
                this.editor = component;
            }
        }

        public void removeLayoutComponent(Component component) {
            if (component == this.nextButton) {
                component = null;
            } else if (component == this.previousButton) {
                this.previousButton = null;
            } else if (component == this.editor) {
                this.editor = null;
            }
        }

        private Dimension preferredSize(Component component) {
            return component == null ? new Dimension(0, 0) : component.getPreferredSize();
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = this.preferredSize(this.nextButton);
            Dimension dimension2 = this.preferredSize(this.previousButton);
            Dimension dimension3 = this.preferredSize(this.editor);
            dimension3.height = (dimension3.height + 1) / 2 * 2;
            Dimension dimension4 = new Dimension(dimension3.width, dimension3.height);
            dimension4.width += Math.max(dimension.width, dimension2.width);
            Insets insets = container.getInsets();
            dimension4.width += insets.left + insets.right;
            dimension4.height += insets.top + insets.bottom;
            return dimension4;
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        private void setBounds(Component component, int n, int n2, int n3, int n4) {
            if (component != null) {
                component.setBounds(n, n2, n3, n4);
            }
        }

        public void layoutContainer(Container container) {
            int n;
            int n2;
            Insets insets = container.getInsets();
            int n3 = container.getWidth() - (insets.left + insets.right);
            int n4 = container.getHeight() - (insets.top + insets.bottom);
            Dimension dimension = this.preferredSize(this.nextButton);
            Dimension dimension2 = this.preferredSize(this.previousButton);
            int n5 = n4 / 2;
            int n6 = n4 - n5;
            int n7 = Math.max(dimension.width, dimension2.width);
            int n8 = n3 - n7;
            if (container.getComponentOrientation().isLeftToRight()) {
                n2 = insets.left;
                n = n2 + n8;
            } else {
                n = insets.left;
                n2 = n + n7;
            }
            int n9 = insets.top + n5;
            this.setBounds(this.editor, n2, insets.top, n8, n4);
            this.setBounds(this.nextButton, n, insets.top, n7, n5);
            this.setBounds(this.previousButton, n, n9, n7, n6);
        }
    }
}

