/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.spi.servicecontext;

import com.sun.corba.se.impl.encoding.CDRInputStream;
import com.sun.corba.se.impl.encoding.EncapsInputStream;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.util.Utility;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.servicecontext.ServiceContext;
import com.sun.corba.se.spi.servicecontext.ServiceContextData;
import com.sun.corba.se.spi.servicecontext.ServiceContextRegistry;
import com.sun.corba.se.spi.servicecontext.UnknownServiceContext;
import com.sun.org.omg.SendingContext.CodeBase;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.OctetSeqHelper;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class ServiceContexts {
    private static final int JAVAIDL_ALIGN_SERVICE_ID = -1106033203;
    private ORB orb;
    private Map scMap;
    private boolean addAlignmentOnWrite;
    private CodeBase codeBase;
    private GIOPVersion giopVersion;
    private ORBUtilSystemException wrapper;

    private static boolean isDebugging(OutputStream outputStream) {
        ORB oRB = (ORB)outputStream.orb();
        if (oRB == null) {
            return false;
        }
        return oRB.serviceContextDebugFlag;
    }

    private static boolean isDebugging(InputStream inputStream) {
        ORB oRB = (ORB)inputStream.orb();
        if (oRB == null) {
            return false;
        }
        return oRB.serviceContextDebugFlag;
    }

    private void dprint(String string) {
        ORBUtility.dprint(this, string);
    }

    public static void writeNullServiceContext(OutputStream outputStream) {
        if (ServiceContexts.isDebugging(outputStream)) {
            ORBUtility.dprint("ServiceContexts", "Writing null service context");
        }
        outputStream.write_long(0);
    }

    private void createMapFromInputStream(InputStream inputStream) {
        this.orb = (ORB)inputStream.orb();
        if (this.orb.serviceContextDebugFlag) {
            this.dprint("Constructing ServiceContexts from input stream");
        }
        int n = inputStream.read_long();
        if (this.orb.serviceContextDebugFlag) {
            this.dprint("Number of service contexts = " + n);
        }
        for (int i = 0; i < n; ++i) {
            int n2 = inputStream.read_long();
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("Reading service context id " + n2);
            }
            byte[] byArray = OctetSeqHelper.read(inputStream);
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("Service context" + n2 + " length: " + byArray.length);
            }
            this.scMap.put(new Integer(n2), byArray);
        }
    }

    public ServiceContexts(ORB oRB) {
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.protocol");
        this.addAlignmentOnWrite = false;
        this.scMap = new HashMap();
        this.giopVersion = oRB.getORBData().getGIOPVersion();
        this.codeBase = null;
    }

    public ServiceContexts(InputStream inputStream) {
        this((ORB)inputStream.orb());
        this.codeBase = ((CDRInputStream)inputStream).getCodeBase();
        this.createMapFromInputStream(inputStream);
        this.giopVersion = ((CDRInputStream)inputStream).getGIOPVersion();
    }

    private ServiceContext unmarshal(Integer n, byte[] byArray) {
        ServiceContextRegistry serviceContextRegistry = this.orb.getServiceContextRegistry();
        ServiceContextData serviceContextData = serviceContextRegistry.findServiceContextData(n);
        ServiceContext serviceContext = null;
        if (serviceContextData == null) {
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("Could not find ServiceContextData for " + n + " using UnknownServiceContext");
            }
            serviceContext = new UnknownServiceContext((int)n, byArray);
        } else {
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("Found " + serviceContextData);
            }
            EncapsInputStream encapsInputStream = new EncapsInputStream((org.omg.CORBA.ORB)this.orb, byArray, byArray.length, this.giopVersion, this.codeBase);
            encapsInputStream.consumeEndian();
            serviceContext = serviceContextData.makeServiceContext(encapsInputStream, this.giopVersion);
            if (serviceContext == null) {
                throw this.wrapper.svcctxUnmarshalError(CompletionStatus.COMPLETED_MAYBE);
            }
        }
        return serviceContext;
    }

    public void addAlignmentPadding() {
        this.addAlignmentOnWrite = true;
    }

    public void write(OutputStream outputStream, GIOPVersion gIOPVersion) {
        if (ServiceContexts.isDebugging(outputStream)) {
            this.dprint("Writing service contexts to output stream");
            Utility.printStackTrace();
        }
        int n = this.scMap.size();
        if (this.addAlignmentOnWrite) {
            if (ServiceContexts.isDebugging(outputStream)) {
                this.dprint("Adding alignment padding");
            }
            ++n;
        }
        if (ServiceContexts.isDebugging(outputStream)) {
            this.dprint("Service context has " + n + " components");
        }
        outputStream.write_long(n);
        this.writeServiceContextsInOrder(outputStream, gIOPVersion);
        if (this.addAlignmentOnWrite) {
            if (ServiceContexts.isDebugging(outputStream)) {
                this.dprint("Writing alignment padding");
            }
            outputStream.write_long(-1106033203);
            outputStream.write_long(4);
            outputStream.write_octet((byte)0);
            outputStream.write_octet((byte)0);
            outputStream.write_octet((byte)0);
            outputStream.write_octet((byte)0);
        }
        if (ServiceContexts.isDebugging(outputStream)) {
            this.dprint("Service context writing complete");
        }
    }

    private void writeServiceContextsInOrder(OutputStream outputStream, GIOPVersion gIOPVersion) {
        Integer n = new Integer(9);
        Object v = this.scMap.remove(n);
        for (Integer n2 : this.scMap.keySet()) {
            this.writeMapEntry(outputStream, n2, this.scMap.get(n2), gIOPVersion);
        }
        if (v != null) {
            this.writeMapEntry(outputStream, n, v, gIOPVersion);
            this.scMap.put(n, v);
        }
    }

    private void writeMapEntry(OutputStream outputStream, Integer n, Object object, GIOPVersion gIOPVersion) {
        if (object instanceof byte[]) {
            if (ServiceContexts.isDebugging(outputStream)) {
                this.dprint("Writing service context bytes for id " + n);
            }
            OctetSeqHelper.write(outputStream, (byte[])object);
        } else {
            ServiceContext serviceContext = (ServiceContext)object;
            if (ServiceContexts.isDebugging(outputStream)) {
                this.dprint("Writing service context " + serviceContext);
            }
            serviceContext.write(outputStream, gIOPVersion);
        }
    }

    public void put(ServiceContext serviceContext) {
        Integer n = new Integer(serviceContext.getId());
        this.scMap.put(n, serviceContext);
    }

    public void delete(int n) {
        this.delete(new Integer(n));
    }

    public void delete(Integer n) {
        this.scMap.remove(n);
    }

    public ServiceContext get(int n) {
        return this.get(new Integer(n));
    }

    public ServiceContext get(Integer n) {
        Object v = this.scMap.get(n);
        if (v == null) {
            return null;
        }
        if (v instanceof byte[]) {
            ServiceContext serviceContext = this.unmarshal(n, (byte[])v);
            this.scMap.put(n, serviceContext);
            return serviceContext;
        }
        return (ServiceContext)v;
    }
}

