/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.perf.DeployPerfUtil;
import com.sun.deploy.util.NativeLibraryBundle;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.progress.ProgressListener;
import com.sun.javaws.security.AppPolicy;
import com.sun.jnlp.BasicServiceImpl;
import com.sun.jnlp.ClipboardServiceImpl;
import com.sun.jnlp.DownloadService2Impl;
import com.sun.jnlp.DownloadServiceImpl;
import com.sun.jnlp.ExtendedServiceImpl;
import com.sun.jnlp.ExtensionInstallerServiceImpl;
import com.sun.jnlp.FileOpenServiceImpl;
import com.sun.jnlp.FileSaveServiceImpl;
import com.sun.jnlp.IntegrationServiceImpl;
import com.sun.jnlp.JNLPClassLoaderIf;
import com.sun.jnlp.PersistenceServiceImpl;
import com.sun.jnlp.PrintServiceImpl;
import com.sun.jnlp.SingleInstanceServiceImpl;
import java.awt.AWTPermission;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.jnlp.BasicService;
import javax.jnlp.ClipboardService;
import javax.jnlp.DownloadService;
import javax.jnlp.DownloadService2;
import javax.jnlp.ExtendedService;
import javax.jnlp.ExtensionInstallerService;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.IntegrationService;
import javax.jnlp.PersistenceService;
import javax.jnlp.PrintService;
import javax.jnlp.SingleInstanceService;
import sun.awt.AppContext;
import sun.misc.Resource;
import sun.misc.URLClassPath;
import sun.reflect.Reflection;

public final class JNLPPreverifyClassLoader
extends URLClassLoader
implements JNLPClassLoaderIf {
    private static Field ucpField = JNLPPreverifyClassLoader.getUCPField("ucp");
    private static Method defineClassMethod = JNLPPreverifyClassLoader.getDefineClassMethod("defineClass");
    private static JNLPPreverifyClassLoader _instance = null;
    private ClassLoader _delegatingClassLoader = null;
    private LaunchDesc _launchDesc = null;
    private AppPolicy _appPolicy;
    private AccessControlContext _acc = null;
    private boolean _initialized = false;
    private ArrayList _jarsInURLClassLoader = new ArrayList();
    private ArrayList _jarsNotInURLClassLoader = new ArrayList();
    private NativeLibraryBundle nativeLibraries = null;
    private boolean processingException = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$sun$misc$Resource;
    static /* synthetic */ Class class$java$net$URLClassLoader;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Class;

    public JNLPPreverifyClassLoader(ClassLoader classLoader) {
        super(new URL[0], classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
    }

    public void setDelegatingClassLoader(ClassLoader classLoader) {
        this._delegatingClassLoader = classLoader;
    }

    public void initialize(LaunchDesc launchDesc, AppPolicy appPolicy) {
        int n;
        this._launchDesc = launchDesc;
        this._acc = AccessController.getContext();
        this._appPolicy = appPolicy;
        this._initialized = false;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc != null) {
            this.sortDescriptors(resourcesDesc);
            for (n = 0; n < this._jarsInURLClassLoader.size(); ++n) {
                JARDesc jARDesc = (JARDesc)this._jarsInURLClassLoader.get(n);
                if (!Cache.isCacheEnabled()) continue;
                CacheEntry cacheEntry = Cache.getSystemCacheEntry((URL)jARDesc.getLocation(), (String)jARDesc.getVersion());
                if (cacheEntry != null && cacheEntry.getClassesVerificationStatus() == 1 && cacheEntry.isKnownToBeSigned()) {
                    arrayList.add(jARDesc.getLocation());
                    Trace.println((String)("JNLPPreverifyClassLoader.initialize: addURL: " + jARDesc.getLocation()), (TraceLevel)TraceLevel.CACHE);
                    continue;
                }
                if (!Environment.allowAltJavaFxRuntimeURL()) {
                    this._initialized = false;
                    Trace.println((String)("JNLPPreverifyClassLoader.initialize: FAILED: " + jARDesc.getLocation()), (TraceLevel)TraceLevel.CACHE);
                    return;
                }
                Trace.println((String)("JNLPPreverifyClassLoader.initialize: skip " + jARDesc.getLocation()), (TraceLevel)TraceLevel.CACHE);
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.addURL((URL)arrayList.get(n));
        }
        _instance = this;
        this._initialized = true;
    }

    public boolean contains(URL uRL) {
        if (!this._initialized) {
            return false;
        }
        String string = uRL.toString();
        URL[] uRLArray = this.getURLs();
        for (int i = 0; i < uRLArray.length; ++i) {
            if (!string.equals(uRLArray[i].toString())) continue;
            return true;
        }
        return false;
    }

    public JARDesc getJarDescFromURL(URL uRL) {
        for (int i = 0; i < this._jarsInURLClassLoader.size(); ++i) {
            JARDesc jARDesc = (JARDesc)this._jarsInURLClassLoader.get(i);
            if (!jARDesc.getLocation().toString().equals(uRL.toString())) continue;
            return jARDesc;
        }
        return null;
    }

    public void downloadResource(URL uRL, String string, ProgressListener progressListener, boolean bl) throws JNLPException, IOException {
        LaunchDownload.downloadResource(this._launchDesc, uRL, string, progressListener, bl);
    }

    public void downloadParts(String[] stringArray, ProgressListener progressListener, boolean bl) throws JNLPException, IOException {
        LaunchDownload.downloadParts(this._launchDesc, stringArray, progressListener, bl);
    }

    public void downloadExtensionParts(URL uRL, String string, String[] stringArray, ProgressListener progressListener, boolean bl) throws JNLPException, IOException {
        LaunchDownload.downloadExtensionPart(this._launchDesc, uRL, string, stringArray, progressListener, bl);
    }

    public void downloadEager(ProgressListener progressListener, boolean bl) throws JNLPException, IOException {
        LaunchDownload.downloadEagerorAll(this._launchDesc, false, progressListener, bl);
    }

    public static JNLPClassLoaderIf getInstance() {
        return _instance;
    }

    public LaunchDesc getLaunchDesc() {
        return this._launchDesc;
    }

    public int getDefaultSecurityModel() {
        return this._launchDesc.getSecurityModel();
    }

    public URL getResource(final String string) {
        URL uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() throws SecurityException {
                URL uRL = null;
                for (int i = 0; uRL == null && i < 3; ++i) {
                    uRL = JNLPPreverifyClassLoader.super.getResource(string);
                }
                return uRL;
            }
        });
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String findLibrary(String string) {
        JARDesc[] jARDescArray;
        DeployPerfUtil.put((String)"JNLPPreverifyClassLoader.findLibrary - start()");
        if (!this._initialized) {
            Trace.println((String)("JNLPPreverifyClassLoader.findLibrary: " + string + ": not initialized -> super()"), (TraceLevel)TraceLevel.BASIC);
            return super.findLibrary(string);
        }
        string = Config.getInstance().getLibraryPrefix() + string + Config.getInstance().getLibrarySufix();
        Trace.println((String)("JNLPPreverifyClassLoader.findLibrary: Looking up native library: " + string), (TraceLevel)TraceLevel.BASIC);
        Object object = this;
        synchronized (object) {
            if (this.nativeLibraries != null) {
                jARDescArray = this.nativeLibraries.get(string);
                if (jARDescArray != null) {
                    Trace.println((String)("JNLPPreverifyClassLoader.findLibrary: native library found: " + (String)jARDescArray), (TraceLevel)TraceLevel.BASIC);
                    DeployPerfUtil.put((String)"JNLPPreverifyClassLoader.findLibrary - reusing library");
                    return jARDescArray;
                }
            } else {
                this.nativeLibraries = new NativeLibraryBundle();
            }
        }
        object = this._launchDesc.getResources();
        jARDescArray = ((ResourcesDesc)object).getEagerOrAllJarDescs(true);
        for (int i = 0; i < jARDescArray.length; ++i) {
            if (!jARDescArray[i].isNativeLib()) continue;
            try {
                CacheEntry cacheEntry;
                String string2 = DownloadEngine.getLibraryDirForJar((String)string, (URL)jARDescArray[i].getLocation(), (String)jARDescArray[i].getVersion());
                if (string2 == null || (cacheEntry = Cache.getSystemCacheEntry((URL)jARDescArray[i].getLocation(), (String)jARDescArray[i].getVersion())) == null) continue;
                JarFile jarFile = cacheEntry.getJarFile();
                this.nativeLibraries.prepareLibrary(string, jarFile, string2);
                String string3 = this.nativeLibraries.get(string);
                Trace.println((String)("JNLPPreverifyClassLoader.findLibrary: native library found: " + string3), (TraceLevel)TraceLevel.BASIC);
                DeployPerfUtil.put((String)"JNLPPreverifyClassLoader.findLibrary - found library");
                return string3;
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        Trace.println((String)("Native library " + string + " not found"), (TraceLevel)TraceLevel.BASIC);
        DeployPerfUtil.put((String)"JNLPPreverifyClassLoader.findLibrary - return super.findLibrary");
        return super.findLibrary(string);
    }

    private static Method getDefineClassMethod(final String string) {
        return (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Method method = (class$java$net$URLClassLoader == null ? (class$java$net$URLClassLoader = JNLPPreverifyClassLoader.class$("java.net.URLClassLoader")) : class$java$net$URLClassLoader).getDeclaredMethod(string, class$java$lang$String == null ? (class$java$lang$String = JNLPPreverifyClassLoader.class$("java.lang.String")) : class$java$lang$String, class$sun$misc$Resource == null ? (class$sun$misc$Resource = JNLPPreverifyClassLoader.class$("sun.misc.Resource")) : class$sun$misc$Resource, Boolean.TYPE);
                    method.setAccessible(true);
                    return method;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }

    private static Field getUCPField(final String string) {
        return (Field)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Field field = (class$java$net$URLClassLoader == null ? (class$java$net$URLClassLoader = JNLPPreverifyClassLoader.class$("java.net.URLClassLoader")) : class$java$net$URLClassLoader).getDeclaredField(string);
                    field.setAccessible(true);
                    return field;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }

    private Class defineClassHelper(String string, Resource resource) throws IOException {
        try {
            Object object;
            String string2 = resource.getURL().toString();
            String string3 = string2.substring(4, string2.indexOf(33));
            URL uRL = new URL(string3);
            JARDesc jARDesc = this.getJarDescFromURL(uRL);
            Boolean bl = Boolean.TRUE;
            if (Cache.isCacheEnabled() && (object = Cache.getSystemCacheEntry((URL)jARDesc.getLocation(), (String)jARDesc.getVersion())) != null && object.getClassesVerificationStatus() == 1) {
                bl = Boolean.FALSE;
            }
            object = (Class)defineClassMethod.invoke((Object)this, string, resource, bl);
            return object;
        }
        catch (Exception exception) {
            for (Throwable throwable = exception.getCause(); throwable != null; throwable = throwable.getCause()) {
                if (throwable instanceof LinkageError) {
                    throw (LinkageError)throwable;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (!(throwable instanceof SecurityException)) continue;
                throw (SecurityException)throwable;
            }
            throw new RuntimeException(exception);
        }
    }

    private Class findClassHelper(final String string) throws ClassNotFoundException {
        if (ucpField == null || defineClassMethod == null) {
            return super.findClass(string);
        }
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    URLClassPath uRLClassPath;
                    String string2 = string.replace('.', '/').concat(".class");
                    try {
                        uRLClassPath = (URLClassPath)ucpField.get(JNLPPreverifyClassLoader.this);
                    }
                    catch (Exception exception) {
                        throw new ClassNotFoundException(string, exception);
                    }
                    Resource resource = uRLClassPath.getResource(string2, false);
                    if (resource != null) {
                        try {
                            return JNLPPreverifyClassLoader.this.defineClassHelper(string, new PreverifiedResource(resource));
                        }
                        catch (IOException iOException) {
                            throw new ClassNotFoundException(string, iOException);
                        }
                    }
                    throw new ClassNotFoundException(string);
                }
            }, this._acc);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (ClassNotFoundException)privilegedActionException.getException();
        }
    }

    private boolean needToApplyFXWorkaround() {
        int n = 1;
        Class clazz = Reflection.getCallerClass((int)n);
        while (clazz != null && (clazz == this.getClass() || clazz == (class$java$lang$ClassLoader == null ? JNLPPreverifyClassLoader.class$("java.lang.ClassLoader") : class$java$lang$ClassLoader) || clazz == (class$java$lang$Class == null ? JNLPPreverifyClassLoader.class$("java.lang.Class") : class$java$lang$Class))) {
            clazz = Reflection.getCallerClass((int)n);
            ++n;
        }
        return clazz != null && clazz.getClassLoader() == this && clazz.getName().equals("com.sun.javafx.runtime.adapter.AppletStartupRoutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class findClass(String string) throws ClassNotFoundException {
        if (!this._initialized) {
            return super.findClass(string);
        }
        try {
            return this.findClassHelper(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            JNLPPreverifyClassLoader jNLPPreverifyClassLoader = this;
            synchronized (jNLPPreverifyClassLoader) {
                if (!this.processingException && this.needToApplyFXWorkaround() && this._delegatingClassLoader != null) {
                    Class<?> clazz;
                    this.processingException = true;
                    try {
                        clazz = this._delegatingClassLoader.loadClass(string);
                        this.processingException = false;
                    }
                    catch (Throwable throwable) {
                        this.processingException = false;
                        throw throwable;
                    }
                    return clazz;
                }
                throw classNotFoundException;
            }
        }
    }

    public URL findResource(String string) {
        return super.findResource(string);
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        File file;
        CacheEntry cacheEntry;
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        try {
            this._appPolicy.addPermissions(JNLPPreverifyClassLoader.getInstance(), permissionCollection, codeSource, true);
        }
        catch (ExitException exitException) {
            Trace.println((String)("_appPolicy.addPermissions: " + exitException), (TraceLevel)TraceLevel.BASIC);
            Trace.ignoredException((Exception)exitException);
        }
        URL uRL = codeSource.getLocation();
        JARDesc jARDesc = this.getJarDescFromURL(uRL);
        if (jARDesc != null && (cacheEntry = Cache.getSystemCacheEntry((URL)jARDesc.getLocation(), (String)jARDesc.getVersion())) != null && (file = cacheEntry.getDataFile()) != null) {
            String string = file.getPath();
            permissionCollection.add(new FilePermission(string, "read"));
        }
        if (!permissionCollection.implies(new AWTPermission("accessClipboard"))) {
            AppContext.getAppContext().put("UNTRUSTED_URLClassLoader", Boolean.TRUE);
        }
        return permissionCollection;
    }

    public JarFile getJarFile(URL uRL) throws IOException {
        final JARDesc jARDesc = this.getJarDescFromURL(uRL);
        JarFile jarFile = null;
        if (jARDesc != null) {
            jarFile = (JarFile)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() throws SecurityException {
                    try {
                        CacheEntry cacheEntry = Cache.getSystemCacheEntry((URL)jARDesc.getLocation(), (String)jARDesc.getVersion());
                        if (cacheEntry == null) {
                            return null;
                        }
                        JarFile jarFile = cacheEntry.getJarFile();
                        if (jarFile != null) {
                            return jarFile;
                        }
                        return DownloadEngine.getUpdatedJarFile((URL)jARDesc.getLocation(), (String)jARDesc.getVersion());
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException((Exception)iOException);
                        return null;
                    }
                }
            });
            if (jarFile == null) {
                throw new IOException("Resource not found: " + jARDesc.getLocation() + ":" + jARDesc.getVersion());
            }
            return jarFile;
        }
        return null;
    }

    private void addLoadedJarsEntry(JARDesc jARDesc) {
        if (!this._jarsInURLClassLoader.contains(jARDesc) && !jARDesc.isNativeLib() && (Environment.allowAltJavaFxRuntimeURL() || jARDesc.getLocation().getHost().equals("dl.javafx.com"))) {
            this._jarsInURLClassLoader.add(jARDesc);
        }
    }

    private void sortDescriptors(ResourcesDesc resourcesDesc) {
        int n;
        ArrayList<JARDesc> arrayList = new ArrayList<JARDesc>();
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
        JARDesc jARDesc = resourcesDesc.getMainJar(true);
        JARDesc jARDesc2 = resourcesDesc.getProgressJar();
        if (jARDesc2 != null) {
            this.addLoadedJarsEntry(jARDesc2);
        }
        if (jARDesc != null) {
            this.addLoadedJarsEntry(jARDesc);
        }
        for (n = 0; n < jARDescArray.length; ++n) {
            if (jARDescArray[n] == jARDesc || jARDescArray[n] == jARDesc2) continue;
            if (!jARDescArray[n].isLazyDownload()) {
                this.addLoadedJarsEntry(jARDescArray[n]);
                continue;
            }
            if (!resourcesDesc.isPackagePart(jARDescArray[n].getPartName())) {
                arrayList.add(jARDescArray[n]);
                continue;
            }
            this._jarsNotInURLClassLoader.add(jARDescArray[n]);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.addLoadedJarsEntry((JARDesc)arrayList.get(n));
        }
    }

    public void addResource(URL uRL, String string, String string2) {
    }

    public BasicService getBasicService() {
        return BasicServiceImpl.getInstance();
    }

    public FileOpenService getFileOpenService() {
        return FileOpenServiceImpl.getInstance();
    }

    public FileSaveService getFileSaveService() {
        return FileSaveServiceImpl.getInstance();
    }

    public ExtensionInstallerService getExtensionInstallerService() {
        return ExtensionInstallerServiceImpl.getInstance();
    }

    public DownloadService getDownloadService() {
        return DownloadServiceImpl.getInstance();
    }

    public ClipboardService getClipboardService() {
        return ClipboardServiceImpl.getInstance();
    }

    public PrintService getPrintService() {
        return PrintServiceImpl.getInstance();
    }

    public PersistenceService getPersistenceService() {
        return PersistenceServiceImpl.getInstance();
    }

    public ExtendedService getExtendedService() {
        return ExtendedServiceImpl.getInstance();
    }

    public SingleInstanceService getSingleInstanceService() {
        return SingleInstanceServiceImpl.getInstance();
    }

    public IntegrationService getIntegrationService() {
        return new IntegrationServiceImpl(this);
    }

    public DownloadService2 getDownloadService2() {
        return DownloadService2Impl.getInstance();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PreverifiedResource
    extends Resource {
        private Resource res = null;
        private byte[] cbytes;

        public PreverifiedResource(Resource resource) {
            this.res = resource;
        }

        public String getName() {
            return this.res.getName();
        }

        public URL getURL() {
            return this.res.getURL();
        }

        public URL getCodeSourceURL() {
            return this.res.getCodeSourceURL();
        }

        public InputStream getInputStream() throws IOException {
            return this.res.getInputStream();
        }

        public int getContentLength() throws IOException {
            return this.res.getContentLength();
        }

        public byte[] getBytes() throws IOException {
            if (this.cbytes != null) {
                return this.cbytes;
            }
            this.cbytes = super.getBytes();
            return this.cbytes;
        }

        public ByteBuffer getByteBuffer() throws IOException {
            return this.res.getByteBuffer();
        }

        public Manifest getManifest() throws IOException {
            return this.res.getManifest();
        }

        public Certificate[] getCertificates() {
            return null;
        }

        public CodeSigner[] getCodeSigners() {
            return null;
        }
    }
}

