/*-------------------------------------------------------------------------
 *
 * unicode_case_table.h
 *	  Case mapping and information table.
 *
 * Portions Copyright (c) 1996-2025, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * src/include/common/unicode_case_table.h
 *
 *-------------------------------------------------------------------------
 */

/*
 * File auto-generated by src/common/unicode/generate-unicode_case_table.pl,
 * do not edit. There is deliberately not an #ifndef PG_UNICODE_CASE_TABLE_H
 * here.
 */

#include "common/unicode_case.h"
#include "mb/pg_wchar.h"

/*
 * The maximum number of codepoints that can result from case mapping
 * of a single character. See Unicode section 5.18 "Case Mappings".
 */
#define MAX_CASE_EXPANSION 3

/*
 * Case mapping condition flags. For now, only Final_Sigma is supported.
 *
 * See Unicode Context Specification for Casing.
 */
#define PG_U_FINAL_SIGMA		(1 << 0)

typedef enum
{
	CaseLower = 0,
	CaseTitle = 1,
	CaseUpper = 2,
	CaseFold = 3,
	NCaseKind
} CaseKind;

typedef struct
{
	int16		conditions;
	pg_wchar	map[NCaseKind][MAX_CASE_EXPANSION];
} pg_special_case;

/*
 * Special case mappings that aren't representable in the simple map.
 * Entries are referenced from simple_case_map.
 */
static const pg_special_case special_case[106] =
{
	{0, {{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}},
	{0, {[CaseLower] = {0x0000df, 0x000000, 0x000000},[CaseTitle] = {0x000053, 0x000073, 0x000000},[CaseUpper] = {0x000053, 0x000053, 0x000000},[CaseFold] = {0x000073, 0x000073, 0x000000}}},
	{0, {[CaseLower] = {0x000069, 0x000307, 0x000000},[CaseTitle] = {0x000130, 0x000000, 0x000000},[CaseUpper] = {0x000130, 0x000000, 0x000000},[CaseFold] = {0x000069, 0x000307, 0x000000}}},
	{0, {[CaseLower] = {0x000149, 0x000000, 0x000000},[CaseTitle] = {0x0002bc, 0x00004e, 0x000000},[CaseUpper] = {0x0002bc, 0x00004e, 0x000000},[CaseFold] = {0x0002bc, 0x00006e, 0x000000}}},
	{0, {[CaseLower] = {0x0001f0, 0x000000, 0x000000},[CaseTitle] = {0x00004a, 0x00030c, 0x000000},[CaseUpper] = {0x00004a, 0x00030c, 0x000000},[CaseFold] = {0x00006a, 0x00030c, 0x000000}}},
	{0, {[CaseLower] = {0x000390, 0x000000, 0x000000},[CaseTitle] = {0x000399, 0x000308, 0x000301},[CaseUpper] = {0x000399, 0x000308, 0x000301},[CaseFold] = {0x0003b9, 0x000308, 0x000301}}},
	{PG_U_FINAL_SIGMA, {[CaseLower] = {0x0003c2, 0x000000, 0x000000},[CaseTitle] = {0x0003a3, 0x000000, 0x000000},[CaseUpper] = {0x0003a3, 0x000000, 0x000000},[CaseFold] = {0x0003c3, 0x000000, 0x000000}}},
	{0, {[CaseLower] = {0x0003b0, 0x000000, 0x000000},[CaseTitle] = {0x0003a5, 0x000308, 0x000301},[CaseUpper] = {0x0003a5, 0x000308, 0x000301},[CaseFold] = {0x0003c5, 0x000308, 0x000301}}},
	{0, {[CaseLower] = {0x000587, 0x000000, 0x000000},[CaseTitle] = {0x000535, 0x000582, 0x000000},[CaseUpper] = {0x000535, 0x000552, 0x000000},[CaseFold] = {0x000565, 0x000582, 0x000000}}},
	{0, {[CaseLower] = {0x001e96, 0x000000, 0x000000},[CaseTitle] = {0x000048, 0x000331, 0x000000},[CaseUpper] = {0x000048, 0x000331, 0x000000},[CaseFold] = {0x000068, 0x000331, 0x000000}}},
	{0, {[CaseLower] = {0x001e97, 0x000000, 0x000000},[CaseTitle] = {0x000054, 0x000308, 0x000000},[CaseUpper] = {0x000054, 0x000308, 0x000000},[CaseFold] = {0x000074, 0x000308, 0x000000}}},
	{0, {[CaseLower] = {0x001e98, 0x000000, 0x000000},[CaseTitle] = {0x000057, 0x00030a, 0x000000},[CaseUpper] = {0x000057, 0x00030a, 0x000000},[CaseFold] = {0x000077, 0x00030a, 0x000000}}},
	{0, {[CaseLower] = {0x001e99, 0x000000, 0x000000},[CaseTitle] = {0x000059, 0x00030a, 0x000000},[CaseUpper] = {0x000059, 0x00030a, 0x000000},[CaseFold] = {0x000079, 0x00030a, 0x000000}}},
	{0, {[CaseLower] = {0x001e9a, 0x000000, 0x000000},[CaseTitle] = {0x000041, 0x0002be, 0x000000},[CaseUpper] = {0x000041, 0x0002be, 0x000000},[CaseFold] = {0x000061, 0x0002be, 0x000000}}},
	{0, {[CaseLower] = {0x0000df, 0x000000, 0x000000},[CaseTitle] = {0x001e9e, 0x000000, 0x000000},[CaseUpper] = {0x001e9e, 0x000000, 0x000000},[CaseFold] = {0x000073, 0x000073, 0x000000}}},
	{0, {[CaseLower] = {0x001f50, 0x000000, 0x000000},[CaseTitle] = {0x0003a5, 0x000313, 0x000000},[CaseUpper] = {0x0003a5, 0x000313, 0x000000},[CaseFold] = {0x0003c5, 0x000313, 0x000000}}},
	{0, {[CaseLower] = {0x001f52, 0x000000, 0x000000},[CaseTitle] = {0x0003a5, 0x000313, 0x000300},[CaseUpper] = {0x0003a5, 0x000313, 0x000300},[CaseFold] = {0x0003c5, 0x000313, 0x000300}}},
	{0, {[CaseLower] = {0x001f54, 0x000000, 0x000000},[CaseTitle] = {0x0003a5, 0x000313, 0x000301},[CaseUpper] = {0x0003a5, 0x000313, 0x000301},[CaseFold] = {0x0003c5, 0x000313, 0x000301}}},
	{0, {[CaseLower] = {0x001f56, 0x000000, 0x000000},[CaseTitle] = {0x0003a5, 0x000313, 0x000342},[CaseUpper] = {0x0003a5, 0x000313, 0x000342},[CaseFold] = {0x0003c5, 0x000313, 0x000342}}},
	{0, {[CaseLower] = {0x001f80, 0x000000, 0x000000},[CaseTitle] = {0x001f88, 0x000000, 0x000000},[CaseUpper] = {0x001f08, 0x000399, 0x000000},[CaseFold] = {0x001f00, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f81, 0x000000, 0x000000},[CaseTitle] = {0x001f89, 0x000000, 0x000000},[CaseUpper] = {0x001f09, 0x000399, 0x000000},[CaseFold] = {0x001f01, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f82, 0x000000, 0x000000},[CaseTitle] = {0x001f8a, 0x000000, 0x000000},[CaseUpper] = {0x001f0a, 0x000399, 0x000000},[CaseFold] = {0x001f02, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f83, 0x000000, 0x000000},[CaseTitle] = {0x001f8b, 0x000000, 0x000000},[CaseUpper] = {0x001f0b, 0x000399, 0x000000},[CaseFold] = {0x001f03, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f84, 0x000000, 0x000000},[CaseTitle] = {0x001f8c, 0x000000, 0x000000},[CaseUpper] = {0x001f0c, 0x000399, 0x000000},[CaseFold] = {0x001f04, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f85, 0x000000, 0x000000},[CaseTitle] = {0x001f8d, 0x000000, 0x000000},[CaseUpper] = {0x001f0d, 0x000399, 0x000000},[CaseFold] = {0x001f05, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f86, 0x000000, 0x000000},[CaseTitle] = {0x001f8e, 0x000000, 0x000000},[CaseUpper] = {0x001f0e, 0x000399, 0x000000},[CaseFold] = {0x001f06, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f87, 0x000000, 0x000000},[CaseTitle] = {0x001f8f, 0x000000, 0x000000},[CaseUpper] = {0x001f0f, 0x000399, 0x000000},[CaseFold] = {0x001f07, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f80, 0x000000, 0x000000},[CaseTitle] = {0x001f88, 0x000000, 0x000000},[CaseUpper] = {0x001f08, 0x000399, 0x000000},[CaseFold] = {0x001f00, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f81, 0x000000, 0x000000},[CaseTitle] = {0x001f89, 0x000000, 0x000000},[CaseUpper] = {0x001f09, 0x000399, 0x000000},[CaseFold] = {0x001f01, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f82, 0x000000, 0x000000},[CaseTitle] = {0x001f8a, 0x000000, 0x000000},[CaseUpper] = {0x001f0a, 0x000399, 0x000000},[CaseFold] = {0x001f02, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f83, 0x000000, 0x000000},[CaseTitle] = {0x001f8b, 0x000000, 0x000000},[CaseUpper] = {0x001f0b, 0x000399, 0x000000},[CaseFold] = {0x001f03, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f84, 0x000000, 0x000000},[CaseTitle] = {0x001f8c, 0x000000, 0x000000},[CaseUpper] = {0x001f0c, 0x000399, 0x000000},[CaseFold] = {0x001f04, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f85, 0x000000, 0x000000},[CaseTitle] = {0x001f8d, 0x000000, 0x000000},[CaseUpper] = {0x001f0d, 0x000399, 0x000000},[CaseFold] = {0x001f05, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f86, 0x000000, 0x000000},[CaseTitle] = {0x001f8e, 0x000000, 0x000000},[CaseUpper] = {0x001f0e, 0x000399, 0x000000},[CaseFold] = {0x001f06, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f87, 0x000000, 0x000000},[CaseTitle] = {0x001f8f, 0x000000, 0x000000},[CaseUpper] = {0x001f0f, 0x000399, 0x000000},[CaseFold] = {0x001f07, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f90, 0x000000, 0x000000},[CaseTitle] = {0x001f98, 0x000000, 0x000000},[CaseUpper] = {0x001f28, 0x000399, 0x000000},[CaseFold] = {0x001f20, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f91, 0x000000, 0x000000},[CaseTitle] = {0x001f99, 0x000000, 0x000000},[CaseUpper] = {0x001f29, 0x000399, 0x000000},[CaseFold] = {0x001f21, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f92, 0x000000, 0x000000},[CaseTitle] = {0x001f9a, 0x000000, 0x000000},[CaseUpper] = {0x001f2a, 0x000399, 0x000000},[CaseFold] = {0x001f22, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f93, 0x000000, 0x000000},[CaseTitle] = {0x001f9b, 0x000000, 0x000000},[CaseUpper] = {0x001f2b, 0x000399, 0x000000},[CaseFold] = {0x001f23, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f94, 0x000000, 0x000000},[CaseTitle] = {0x001f9c, 0x000000, 0x000000},[CaseUpper] = {0x001f2c, 0x000399, 0x000000},[CaseFold] = {0x001f24, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f95, 0x000000, 0x000000},[CaseTitle] = {0x001f9d, 0x000000, 0x000000},[CaseUpper] = {0x001f2d, 0x000399, 0x000000},[CaseFold] = {0x001f25, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f96, 0x000000, 0x000000},[CaseTitle] = {0x001f9e, 0x000000, 0x000000},[CaseUpper] = {0x001f2e, 0x000399, 0x000000},[CaseFold] = {0x001f26, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f97, 0x000000, 0x000000},[CaseTitle] = {0x001f9f, 0x000000, 0x000000},[CaseUpper] = {0x001f2f, 0x000399, 0x000000},[CaseFold] = {0x001f27, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f90, 0x000000, 0x000000},[CaseTitle] = {0x001f98, 0x000000, 0x000000},[CaseUpper] = {0x001f28, 0x000399, 0x000000},[CaseFold] = {0x001f20, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f91, 0x000000, 0x000000},[CaseTitle] = {0x001f99, 0x000000, 0x000000},[CaseUpper] = {0x001f29, 0x000399, 0x000000},[CaseFold] = {0x001f21, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f92, 0x000000, 0x000000},[CaseTitle] = {0x001f9a, 0x000000, 0x000000},[CaseUpper] = {0x001f2a, 0x000399, 0x000000},[CaseFold] = {0x001f22, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f93, 0x000000, 0x000000},[CaseTitle] = {0x001f9b, 0x000000, 0x000000},[CaseUpper] = {0x001f2b, 0x000399, 0x000000},[CaseFold] = {0x001f23, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f94, 0x000000, 0x000000},[CaseTitle] = {0x001f9c, 0x000000, 0x000000},[CaseUpper] = {0x001f2c, 0x000399, 0x000000},[CaseFold] = {0x001f24, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f95, 0x000000, 0x000000},[CaseTitle] = {0x001f9d, 0x000000, 0x000000},[CaseUpper] = {0x001f2d, 0x000399, 0x000000},[CaseFold] = {0x001f25, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f96, 0x000000, 0x000000},[CaseTitle] = {0x001f9e, 0x000000, 0x000000},[CaseUpper] = {0x001f2e, 0x000399, 0x000000},[CaseFold] = {0x001f26, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001f97, 0x000000, 0x000000},[CaseTitle] = {0x001f9f, 0x000000, 0x000000},[CaseUpper] = {0x001f2f, 0x000399, 0x000000},[CaseFold] = {0x001f27, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001fa0, 0x000000, 0x000000},[CaseTitle] = {0x001fa8, 0x000000, 0x000000},[CaseUpper] = {0x001f68, 0x000399, 0x000000},[CaseFold] = {0x001f60, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001fa1, 0x000000, 0x000000},[CaseTitle] = {0x001fa9, 0x000000, 0x000000},[CaseUpper] = {0x001f69, 0x000399, 0x000000},[CaseFold] = {0x001f61, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001fa2, 0x000000, 0x000000},[CaseTitle] = {0x001faa, 0x000000, 0x000000},[CaseUpper] = {0x001f6a, 0x000399, 0x000000},[CaseFold] = {0x001f62, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001fa3, 0x000000, 0x000000},[CaseTitle] = {0x001fab, 0x000000, 0x000000},[CaseUpper] = {0x001f6b, 0x000399, 0x000000},[CaseFold] = {0x001f63, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001fa4, 0x000000, 0x000000},[CaseTitle] = {0x001fac, 0x000000, 0x000000},[CaseUpper] = {0x001f6c, 0x000399, 0x000000},[CaseFold] = {0x001f64, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001fa5, 0x000000, 0x000000},[CaseTitle] = {0x001fad, 0x000000, 0x000000},[CaseUpper] = {0x001f6d, 0x000399, 0x000000},[CaseFold] = {0x001f65, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001fa6, 0x000000, 0x000000},[CaseTitle] = {0x001fae, 0x000000, 0x000000},[CaseUpper] = {0x001f6e, 0x000399, 0x000000},[CaseFold] = {0x001f66, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001fa7, 0x000000, 0x000000},[CaseTitle] = {0x001faf, 0x000000, 0x000000},[CaseUpper] = {0x001f6f, 0x000399, 0x000000},[CaseFold] = {0x001f67, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001fa0, 0x000000, 0x000000},[CaseTitle] = {0x001fa8, 0x000000, 0x000000},[CaseUpper] = {0x001f68, 0x000399, 0x000000},[CaseFold] = {0x001f60, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001fa1, 0x000000, 0x000000},[CaseTitle] = {0x001fa9, 0x000000, 0x000000},[CaseUpper] = {0x001f69, 0x000399, 0x000000},[CaseFold] = {0x001f61, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001fa2, 0x000000, 0x000000},[CaseTitle] = {0x001faa, 0x000000, 0x000000},[CaseUpper] = {0x001f6a, 0x000399, 0x000000},[CaseFold] = {0x001f62, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001fa3, 0x000000, 0x000000},[CaseTitle] = {0x001fab, 0x000000, 0x000000},[CaseUpper] = {0x001f6b, 0x000399, 0x000000},[CaseFold] = {0x001f63, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001fa4, 0x000000, 0x000000},[CaseTitle] = {0x001fac, 0x000000, 0x000000},[CaseUpper] = {0x001f6c, 0x000399, 0x000000},[CaseFold] = {0x001f64, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001fa5, 0x000000, 0x000000},[CaseTitle] = {0x001fad, 0x000000, 0x000000},[CaseUpper] = {0x001f6d, 0x000399, 0x000000},[CaseFold] = {0x001f65, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001fa6, 0x000000, 0x000000},[CaseTitle] = {0x001fae, 0x000000, 0x000000},[CaseUpper] = {0x001f6e, 0x000399, 0x000000},[CaseFold] = {0x001f66, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001fa7, 0x000000, 0x000000},[CaseTitle] = {0x001faf, 0x000000, 0x000000},[CaseUpper] = {0x001f6f, 0x000399, 0x000000},[CaseFold] = {0x001f67, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001fb2, 0x000000, 0x000000},[CaseTitle] = {0x001fba, 0x000345, 0x000000},[CaseUpper] = {0x001fba, 0x000399, 0x000000},[CaseFold] = {0x001f70, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001fb3, 0x000000, 0x000000},[CaseTitle] = {0x001fbc, 0x000000, 0x000000},[CaseUpper] = {0x000391, 0x000399, 0x000000},[CaseFold] = {0x0003b1, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001fb4, 0x000000, 0x000000},[CaseTitle] = {0x000386, 0x000345, 0x000000},[CaseUpper] = {0x000386, 0x000399, 0x000000},[CaseFold] = {0x0003ac, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001fb6, 0x000000, 0x000000},[CaseTitle] = {0x000391, 0x000342, 0x000000},[CaseUpper] = {0x000391, 0x000342, 0x000000},[CaseFold] = {0x0003b1, 0x000342, 0x000000}}},
	{0, {[CaseLower] = {0x001fb7, 0x000000, 0x000000},[CaseTitle] = {0x000391, 0x000342, 0x000345},[CaseUpper] = {0x000391, 0x000342, 0x000399},[CaseFold] = {0x0003b1, 0x000342, 0x0003b9}}},
	{0, {[CaseLower] = {0x001fb3, 0x000000, 0x000000},[CaseTitle] = {0x001fbc, 0x000000, 0x000000},[CaseUpper] = {0x000391, 0x000399, 0x000000},[CaseFold] = {0x0003b1, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001fc2, 0x000000, 0x000000},[CaseTitle] = {0x001fca, 0x000345, 0x000000},[CaseUpper] = {0x001fca, 0x000399, 0x000000},[CaseFold] = {0x001f74, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001fc3, 0x000000, 0x000000},[CaseTitle] = {0x001fcc, 0x000000, 0x000000},[CaseUpper] = {0x000397, 0x000399, 0x000000},[CaseFold] = {0x0003b7, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001fc4, 0x000000, 0x000000},[CaseTitle] = {0x000389, 0x000345, 0x000000},[CaseUpper] = {0x000389, 0x000399, 0x000000},[CaseFold] = {0x0003ae, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001fc6, 0x000000, 0x000000},[CaseTitle] = {0x000397, 0x000342, 0x000000},[CaseUpper] = {0x000397, 0x000342, 0x000000},[CaseFold] = {0x0003b7, 0x000342, 0x000000}}},
	{0, {[CaseLower] = {0x001fc7, 0x000000, 0x000000},[CaseTitle] = {0x000397, 0x000342, 0x000345},[CaseUpper] = {0x000397, 0x000342, 0x000399},[CaseFold] = {0x0003b7, 0x000342, 0x0003b9}}},
	{0, {[CaseLower] = {0x001fc3, 0x000000, 0x000000},[CaseTitle] = {0x001fcc, 0x000000, 0x000000},[CaseUpper] = {0x000397, 0x000399, 0x000000},[CaseFold] = {0x0003b7, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001fd2, 0x000000, 0x000000},[CaseTitle] = {0x000399, 0x000308, 0x000300},[CaseUpper] = {0x000399, 0x000308, 0x000300},[CaseFold] = {0x0003b9, 0x000308, 0x000300}}},
	{0, {[CaseLower] = {0x001fd3, 0x000000, 0x000000},[CaseTitle] = {0x000399, 0x000308, 0x000301},[CaseUpper] = {0x000399, 0x000308, 0x000301},[CaseFold] = {0x0003b9, 0x000308, 0x000301}}},
	{0, {[CaseLower] = {0x001fd6, 0x000000, 0x000000},[CaseTitle] = {0x000399, 0x000342, 0x000000},[CaseUpper] = {0x000399, 0x000342, 0x000000},[CaseFold] = {0x0003b9, 0x000342, 0x000000}}},
	{0, {[CaseLower] = {0x001fd7, 0x000000, 0x000000},[CaseTitle] = {0x000399, 0x000308, 0x000342},[CaseUpper] = {0x000399, 0x000308, 0x000342},[CaseFold] = {0x0003b9, 0x000308, 0x000342}}},
	{0, {[CaseLower] = {0x001fe2, 0x000000, 0x000000},[CaseTitle] = {0x0003a5, 0x000308, 0x000300},[CaseUpper] = {0x0003a5, 0x000308, 0x000300},[CaseFold] = {0x0003c5, 0x000308, 0x000300}}},
	{0, {[CaseLower] = {0x001fe3, 0x000000, 0x000000},[CaseTitle] = {0x0003a5, 0x000308, 0x000301},[CaseUpper] = {0x0003a5, 0x000308, 0x000301},[CaseFold] = {0x0003c5, 0x000308, 0x000301}}},
	{0, {[CaseLower] = {0x001fe4, 0x000000, 0x000000},[CaseTitle] = {0x0003a1, 0x000313, 0x000000},[CaseUpper] = {0x0003a1, 0x000313, 0x000000},[CaseFold] = {0x0003c1, 0x000313, 0x000000}}},
	{0, {[CaseLower] = {0x001fe6, 0x000000, 0x000000},[CaseTitle] = {0x0003a5, 0x000342, 0x000000},[CaseUpper] = {0x0003a5, 0x000342, 0x000000},[CaseFold] = {0x0003c5, 0x000342, 0x000000}}},
	{0, {[CaseLower] = {0x001fe7, 0x000000, 0x000000},[CaseTitle] = {0x0003a5, 0x000308, 0x000342},[CaseUpper] = {0x0003a5, 0x000308, 0x000342},[CaseFold] = {0x0003c5, 0x000308, 0x000342}}},
	{0, {[CaseLower] = {0x001ff2, 0x000000, 0x000000},[CaseTitle] = {0x001ffa, 0x000345, 0x000000},[CaseUpper] = {0x001ffa, 0x000399, 0x000000},[CaseFold] = {0x001f7c, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001ff3, 0x000000, 0x000000},[CaseTitle] = {0x001ffc, 0x000000, 0x000000},[CaseUpper] = {0x0003a9, 0x000399, 0x000000},[CaseFold] = {0x0003c9, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001ff4, 0x000000, 0x000000},[CaseTitle] = {0x00038f, 0x000345, 0x000000},[CaseUpper] = {0x00038f, 0x000399, 0x000000},[CaseFold] = {0x0003ce, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x001ff6, 0x000000, 0x000000},[CaseTitle] = {0x0003a9, 0x000342, 0x000000},[CaseUpper] = {0x0003a9, 0x000342, 0x000000},[CaseFold] = {0x0003c9, 0x000342, 0x000000}}},
	{0, {[CaseLower] = {0x001ff7, 0x000000, 0x000000},[CaseTitle] = {0x0003a9, 0x000342, 0x000345},[CaseUpper] = {0x0003a9, 0x000342, 0x000399},[CaseFold] = {0x0003c9, 0x000342, 0x0003b9}}},
	{0, {[CaseLower] = {0x001ff3, 0x000000, 0x000000},[CaseTitle] = {0x001ffc, 0x000000, 0x000000},[CaseUpper] = {0x0003a9, 0x000399, 0x000000},[CaseFold] = {0x0003c9, 0x0003b9, 0x000000}}},
	{0, {[CaseLower] = {0x00fb00, 0x000000, 0x000000},[CaseTitle] = {0x000046, 0x000066, 0x000000},[CaseUpper] = {0x000046, 0x000046, 0x000000},[CaseFold] = {0x000066, 0x000066, 0x000000}}},
	{0, {[CaseLower] = {0x00fb01, 0x000000, 0x000000},[CaseTitle] = {0x000046, 0x000069, 0x000000},[CaseUpper] = {0x000046, 0x000049, 0x000000},[CaseFold] = {0x000066, 0x000069, 0x000000}}},
	{0, {[CaseLower] = {0x00fb02, 0x000000, 0x000000},[CaseTitle] = {0x000046, 0x00006c, 0x000000},[CaseUpper] = {0x000046, 0x00004c, 0x000000},[CaseFold] = {0x000066, 0x00006c, 0x000000}}},
	{0, {[CaseLower] = {0x00fb03, 0x000000, 0x000000},[CaseTitle] = {0x000046, 0x000066, 0x000069},[CaseUpper] = {0x000046, 0x000046, 0x000049},[CaseFold] = {0x000066, 0x000066, 0x000069}}},
	{0, {[CaseLower] = {0x00fb04, 0x000000, 0x000000},[CaseTitle] = {0x000046, 0x000066, 0x00006c},[CaseUpper] = {0x000046, 0x000046, 0x00004c},[CaseFold] = {0x000066, 0x000066, 0x00006c}}},
	{0, {[CaseLower] = {0x00fb05, 0x000000, 0x000000},[CaseTitle] = {0x000053, 0x000074, 0x000000},[CaseUpper] = {0x000053, 0x000054, 0x000000},[CaseFold] = {0x000073, 0x000074, 0x000000}}},
	{0, {[CaseLower] = {0x00fb06, 0x000000, 0x000000},[CaseTitle] = {0x000053, 0x000074, 0x000000},[CaseUpper] = {0x000053, 0x000054, 0x000000},[CaseFold] = {0x000073, 0x000074, 0x000000}}},
	{0, {[CaseLower] = {0x00fb13, 0x000000, 0x000000},[CaseTitle] = {0x000544, 0x000576, 0x000000},[CaseUpper] = {0x000544, 0x000546, 0x000000},[CaseFold] = {0x000574, 0x000576, 0x000000}}},
	{0, {[CaseLower] = {0x00fb14, 0x000000, 0x000000},[CaseTitle] = {0x000544, 0x000565, 0x000000},[CaseUpper] = {0x000544, 0x000535, 0x000000},[CaseFold] = {0x000574, 0x000565, 0x000000}}},
	{0, {[CaseLower] = {0x00fb15, 0x000000, 0x000000},[CaseTitle] = {0x000544, 0x00056b, 0x000000},[CaseUpper] = {0x000544, 0x00053b, 0x000000},[CaseFold] = {0x000574, 0x00056b, 0x000000}}},
	{0, {[CaseLower] = {0x00fb16, 0x000000, 0x000000},[CaseTitle] = {0x00054e, 0x000576, 0x000000},[CaseUpper] = {0x00054e, 0x000546, 0x000000},[CaseFold] = {0x00057e, 0x000576, 0x000000}}},
	{0, {[CaseLower] = {0x00fb17, 0x000000, 0x000000},[CaseTitle] = {0x000544, 0x00056d, 0x000000},[CaseUpper] = {0x000544, 0x00053d, 0x000000},[CaseFold] = {0x000574, 0x00056d, 0x000000}}},
};

/*
 * The entry case_map_lower[case_index(codepoint)] is the mapping for the
 * given codepoint.
 */
static const pg_wchar case_map_lower[1704] =
{
	0x000000,					/* reserved */
	0x000000,					/* U+000000 */
	0x000001,					/* U+000001 */
	0x000002,					/* U+000002 */
	0x000003,					/* U+000003 */
	0x000004,					/* U+000004 */
	0x000005,					/* U+000005 */
	0x000006,					/* U+000006 */
	0x000007,					/* U+000007 */
	0x000008,					/* U+000008 */
	0x000009,					/* U+000009 */
	0x00000a,					/* U+00000a */
	0x00000b,					/* U+00000b */
	0x00000c,					/* U+00000c */
	0x00000d,					/* U+00000d */
	0x00000e,					/* U+00000e */
	0x00000f,					/* U+00000f */
	0x000010,					/* U+000010 */
	0x000011,					/* U+000011 */
	0x000012,					/* U+000012 */
	0x000013,					/* U+000013 */
	0x000014,					/* U+000014 */
	0x000015,					/* U+000015 */
	0x000016,					/* U+000016 */
	0x000017,					/* U+000017 */
	0x000018,					/* U+000018 */
	0x000019,					/* U+000019 */
	0x00001a,					/* U+00001a */
	0x00001b,					/* U+00001b */
	0x00001c,					/* U+00001c */
	0x00001d,					/* U+00001d */
	0x00001e,					/* U+00001e */
	0x00001f,					/* U+00001f */
	0x000020,					/* U+000020 */
	0x000021,					/* U+000021 */
	0x000022,					/* U+000022 */
	0x000023,					/* U+000023 */
	0x000024,					/* U+000024 */
	0x000025,					/* U+000025 */
	0x000026,					/* U+000026 */
	0x000027,					/* U+000027 */
	0x000028,					/* U+000028 */
	0x000029,					/* U+000029 */
	0x00002a,					/* U+00002a */
	0x00002b,					/* U+00002b */
	0x00002c,					/* U+00002c */
	0x00002d,					/* U+00002d */
	0x00002e,					/* U+00002e */
	0x00002f,					/* U+00002f */
	0x000030,					/* U+000030 */
	0x000031,					/* U+000031 */
	0x000032,					/* U+000032 */
	0x000033,					/* U+000033 */
	0x000034,					/* U+000034 */
	0x000035,					/* U+000035 */
	0x000036,					/* U+000036 */
	0x000037,					/* U+000037 */
	0x000038,					/* U+000038 */
	0x000039,					/* U+000039 */
	0x00003a,					/* U+00003a */
	0x00003b,					/* U+00003b */
	0x00003c,					/* U+00003c */
	0x00003d,					/* U+00003d */
	0x00003e,					/* U+00003e */
	0x00003f,					/* U+00003f */
	0x000040,					/* U+000040 */
	0x000061,					/* U+000041 */
	0x000062,					/* U+000042 */
	0x000063,					/* U+000043 */
	0x000064,					/* U+000044 */
	0x000065,					/* U+000045 */
	0x000066,					/* U+000046 */
	0x000067,					/* U+000047 */
	0x000068,					/* U+000048 */
	0x000069,					/* U+000049 */
	0x00006a,					/* U+00004a */
	0x00006b,					/* U+00004b */
	0x00006c,					/* U+00004c */
	0x00006d,					/* U+00004d */
	0x00006e,					/* U+00004e */
	0x00006f,					/* U+00004f */
	0x000070,					/* U+000050 */
	0x000071,					/* U+000051 */
	0x000072,					/* U+000052 */
	0x000073,					/* U+000053 */
	0x000074,					/* U+000054 */
	0x000075,					/* U+000055 */
	0x000076,					/* U+000056 */
	0x000077,					/* U+000057 */
	0x000078,					/* U+000058 */
	0x000079,					/* U+000059 */
	0x00007a,					/* U+00005a */
	0x00005b,					/* U+00005b */
	0x00005c,					/* U+00005c */
	0x00005d,					/* U+00005d */
	0x00005e,					/* U+00005e */
	0x00005f,					/* U+00005f */
	0x000060,					/* U+000060 */
	0x000061,					/* U+000061 */
	0x000062,					/* U+000062 */
	0x000063,					/* U+000063 */
	0x000064,					/* U+000064 */
	0x000065,					/* U+000065 */
	0x000066,					/* U+000066 */
	0x000067,					/* U+000067 */
	0x000068,					/* U+000068 */
	0x000069,					/* U+000069 */
	0x00006a,					/* U+00006a */
	0x00006b,					/* U+00006b */
	0x00006c,					/* U+00006c */
	0x00006d,					/* U+00006d */
	0x00006e,					/* U+00006e */
	0x00006f,					/* U+00006f */
	0x000070,					/* U+000070 */
	0x000071,					/* U+000071 */
	0x000072,					/* U+000072 */
	0x000073,					/* U+000073 */
	0x000074,					/* U+000074 */
	0x000075,					/* U+000075 */
	0x000076,					/* U+000076 */
	0x000077,					/* U+000077 */
	0x000078,					/* U+000078 */
	0x000079,					/* U+000079 */
	0x00007a,					/* U+00007a */
	0x00007b,					/* U+00007b */
	0x00007c,					/* U+00007c */
	0x00007d,					/* U+00007d */
	0x00007e,					/* U+00007e */
	0x00007f,					/* U+00007f */
	0x0000b5,					/* U+0000b5 */
	0x0000e0,					/* U+0000c0 */
	0x0000e1,					/* U+0000c1 */
	0x0000e2,					/* U+0000c2 */
	0x0000e3,					/* U+0000c3 */
	0x0000e4,					/* U+0000c4 */
	0x0000e5,					/* U+0000c5 */
	0x0000e6,					/* U+0000c6 */
	0x0000e7,					/* U+0000c7 */
	0x0000e8,					/* U+0000c8 */
	0x0000e9,					/* U+0000c9 */
	0x0000ea,					/* U+0000ca */
	0x0000eb,					/* U+0000cb */
	0x0000ec,					/* U+0000cc */
	0x0000ed,					/* U+0000cd */
	0x0000ee,					/* U+0000ce */
	0x0000ef,					/* U+0000cf */
	0x0000f0,					/* U+0000d0 */
	0x0000f1,					/* U+0000d1 */
	0x0000f2,					/* U+0000d2 */
	0x0000f3,					/* U+0000d3 */
	0x0000f4,					/* U+0000d4 */
	0x0000f5,					/* U+0000d5 */
	0x0000f6,					/* U+0000d6 */
	0x0000f8,					/* U+0000d8 */
	0x0000f9,					/* U+0000d9 */
	0x0000fa,					/* U+0000da */
	0x0000fb,					/* U+0000db */
	0x0000fc,					/* U+0000dc */
	0x0000fd,					/* U+0000dd */
	0x0000fe,					/* U+0000de */
	0x0000df,					/* U+0000df */
	0x0000ff,					/* U+0000ff */
	0x000101,					/* U+000100 */
	0x000103,					/* U+000102 */
	0x000105,					/* U+000104 */
	0x000107,					/* U+000106 */
	0x000109,					/* U+000108 */
	0x00010b,					/* U+00010a */
	0x00010d,					/* U+00010c */
	0x00010f,					/* U+00010e */
	0x000111,					/* U+000110 */
	0x000113,					/* U+000112 */
	0x000115,					/* U+000114 */
	0x000117,					/* U+000116 */
	0x000119,					/* U+000118 */
	0x00011b,					/* U+00011a */
	0x00011d,					/* U+00011c */
	0x00011f,					/* U+00011e */
	0x000121,					/* U+000120 */
	0x000123,					/* U+000122 */
	0x000125,					/* U+000124 */
	0x000127,					/* U+000126 */
	0x000129,					/* U+000128 */
	0x00012b,					/* U+00012a */
	0x00012d,					/* U+00012c */
	0x00012f,					/* U+00012e */
	0x000069,					/* U+000130 */
	0x000131,					/* U+000131 */
	0x000133,					/* U+000132 */
	0x000135,					/* U+000134 */
	0x000137,					/* U+000136 */
	0x00013a,					/* U+000139 */
	0x00013c,					/* U+00013b */
	0x00013e,					/* U+00013d */
	0x000140,					/* U+00013f */
	0x000142,					/* U+000141 */
	0x000144,					/* U+000143 */
	0x000146,					/* U+000145 */
	0x000148,					/* U+000147 */
	0x000149,					/* U+000149 */
	0x00014b,					/* U+00014a */
	0x00014d,					/* U+00014c */
	0x00014f,					/* U+00014e */
	0x000151,					/* U+000150 */
	0x000153,					/* U+000152 */
	0x000155,					/* U+000154 */
	0x000157,					/* U+000156 */
	0x000159,					/* U+000158 */
	0x00015b,					/* U+00015a */
	0x00015d,					/* U+00015c */
	0x00015f,					/* U+00015e */
	0x000161,					/* U+000160 */
	0x000163,					/* U+000162 */
	0x000165,					/* U+000164 */
	0x000167,					/* U+000166 */
	0x000169,					/* U+000168 */
	0x00016b,					/* U+00016a */
	0x00016d,					/* U+00016c */
	0x00016f,					/* U+00016e */
	0x000171,					/* U+000170 */
	0x000173,					/* U+000172 */
	0x000175,					/* U+000174 */
	0x000177,					/* U+000176 */
	0x00017a,					/* U+000179 */
	0x00017c,					/* U+00017b */
	0x00017e,					/* U+00017d */
	0x00017f,					/* U+00017f */
	0x000180,					/* U+000180 */
	0x000253,					/* U+000181 */
	0x000183,					/* U+000182 */
	0x000185,					/* U+000184 */
	0x000254,					/* U+000186 */
	0x000188,					/* U+000187 */
	0x000256,					/* U+000189 */
	0x000257,					/* U+00018a */
	0x00018c,					/* U+00018b */
	0x0001dd,					/* U+00018e */
	0x000259,					/* U+00018f */
	0x00025b,					/* U+000190 */
	0x000192,					/* U+000191 */
	0x000260,					/* U+000193 */
	0x000263,					/* U+000194 */
	0x000195,					/* U+000195 */
	0x000269,					/* U+000196 */
	0x000268,					/* U+000197 */
	0x000199,					/* U+000198 */
	0x00019a,					/* U+00019a */
	0x00019b,					/* U+00019b */
	0x00026f,					/* U+00019c */
	0x000272,					/* U+00019d */
	0x00019e,					/* U+00019e */
	0x000275,					/* U+00019f */
	0x0001a1,					/* U+0001a0 */
	0x0001a3,					/* U+0001a2 */
	0x0001a5,					/* U+0001a4 */
	0x000280,					/* U+0001a6 */
	0x0001a8,					/* U+0001a7 */
	0x000283,					/* U+0001a9 */
	0x0001ad,					/* U+0001ac */
	0x000288,					/* U+0001ae */
	0x0001b0,					/* U+0001af */
	0x00028a,					/* U+0001b1 */
	0x00028b,					/* U+0001b2 */
	0x0001b4,					/* U+0001b3 */
	0x0001b6,					/* U+0001b5 */
	0x000292,					/* U+0001b7 */
	0x0001b9,					/* U+0001b8 */
	0x0001bd,					/* U+0001bc */
	0x0001bf,					/* U+0001bf */
	0x0001c6,					/* U+0001c4 */
	0x0001c9,					/* U+0001c7 */
	0x0001cc,					/* U+0001ca */
	0x0001ce,					/* U+0001cd */
	0x0001d0,					/* U+0001cf */
	0x0001d2,					/* U+0001d1 */
	0x0001d4,					/* U+0001d3 */
	0x0001d6,					/* U+0001d5 */
	0x0001d8,					/* U+0001d7 */
	0x0001da,					/* U+0001d9 */
	0x0001dc,					/* U+0001db */
	0x0001df,					/* U+0001de */
	0x0001e1,					/* U+0001e0 */
	0x0001e3,					/* U+0001e2 */
	0x0001e5,					/* U+0001e4 */
	0x0001e7,					/* U+0001e6 */
	0x0001e9,					/* U+0001e8 */
	0x0001eb,					/* U+0001ea */
	0x0001ed,					/* U+0001ec */
	0x0001ef,					/* U+0001ee */
	0x0001f0,					/* U+0001f0 */
	0x0001f3,					/* U+0001f1 */
	0x0001f5,					/* U+0001f4 */
	0x0001f9,					/* U+0001f8 */
	0x0001fb,					/* U+0001fa */
	0x0001fd,					/* U+0001fc */
	0x0001ff,					/* U+0001fe */
	0x000201,					/* U+000200 */
	0x000203,					/* U+000202 */
	0x000205,					/* U+000204 */
	0x000207,					/* U+000206 */
	0x000209,					/* U+000208 */
	0x00020b,					/* U+00020a */
	0x00020d,					/* U+00020c */
	0x00020f,					/* U+00020e */
	0x000211,					/* U+000210 */
	0x000213,					/* U+000212 */
	0x000215,					/* U+000214 */
	0x000217,					/* U+000216 */
	0x000219,					/* U+000218 */
	0x00021b,					/* U+00021a */
	0x00021d,					/* U+00021c */
	0x00021f,					/* U+00021e */
	0x000223,					/* U+000222 */
	0x000225,					/* U+000224 */
	0x000227,					/* U+000226 */
	0x000229,					/* U+000228 */
	0x00022b,					/* U+00022a */
	0x00022d,					/* U+00022c */
	0x00022f,					/* U+00022e */
	0x000231,					/* U+000230 */
	0x000233,					/* U+000232 */
	0x002c65,					/* U+00023a */
	0x00023c,					/* U+00023b */
	0x002c66,					/* U+00023e */
	0x00023f,					/* U+00023f */
	0x000240,					/* U+000240 */
	0x000242,					/* U+000241 */
	0x000289,					/* U+000244 */
	0x00028c,					/* U+000245 */
	0x000247,					/* U+000246 */
	0x000249,					/* U+000248 */
	0x00024b,					/* U+00024a */
	0x00024d,					/* U+00024c */
	0x00024f,					/* U+00024e */
	0x000250,					/* U+000250 */
	0x000251,					/* U+000251 */
	0x000252,					/* U+000252 */
	0x00025c,					/* U+00025c */
	0x000261,					/* U+000261 */
	0x000264,					/* U+000264 */
	0x000265,					/* U+000265 */
	0x000266,					/* U+000266 */
	0x00026a,					/* U+00026a */
	0x00026b,					/* U+00026b */
	0x00026c,					/* U+00026c */
	0x000271,					/* U+000271 */
	0x00027d,					/* U+00027d */
	0x000282,					/* U+000282 */
	0x000287,					/* U+000287 */
	0x00029d,					/* U+00029d */
	0x00029e,					/* U+00029e */
	0x000345,					/* U+000345 */
	0x000371,					/* U+000370 */
	0x000373,					/* U+000372 */
	0x000377,					/* U+000376 */
	0x00037b,					/* U+00037b */
	0x00037c,					/* U+00037c */
	0x00037d,					/* U+00037d */
	0x0003f3,					/* U+00037f */
	0x0003ac,					/* U+000386 */
	0x0003ad,					/* U+000388 */
	0x0003ae,					/* U+000389 */
	0x0003af,					/* U+00038a */
	0x0003cc,					/* U+00038c */
	0x0003cd,					/* U+00038e */
	0x0003ce,					/* U+00038f */
	0x000390,					/* U+000390 */
	0x0003b1,					/* U+000391 */
	0x0003b2,					/* U+000392 */
	0x0003b3,					/* U+000393 */
	0x0003b4,					/* U+000394 */
	0x0003b5,					/* U+000395 */
	0x0003b6,					/* U+000396 */
	0x0003b7,					/* U+000397 */
	0x0003b8,					/* U+000398 */
	0x0003b9,					/* U+000399 */
	0x0003ba,					/* U+00039a */
	0x0003bb,					/* U+00039b */
	0x0003bc,					/* U+00039c */
	0x0003bd,					/* U+00039d */
	0x0003be,					/* U+00039e */
	0x0003bf,					/* U+00039f */
	0x0003c0,					/* U+0003a0 */
	0x0003c1,					/* U+0003a1 */
	0x0003c3,					/* U+0003a3 */
	0x0003c4,					/* U+0003a4 */
	0x0003c5,					/* U+0003a5 */
	0x0003c6,					/* U+0003a6 */
	0x0003c7,					/* U+0003a7 */
	0x0003c8,					/* U+0003a8 */
	0x0003c9,					/* U+0003a9 */
	0x0003ca,					/* U+0003aa */
	0x0003cb,					/* U+0003ab */
	0x0003b0,					/* U+0003b0 */
	0x0003c2,					/* U+0003c2 */
	0x0003c3,					/* U+0003c3 */
	0x0003d7,					/* U+0003cf */
	0x0003d0,					/* U+0003d0 */
	0x0003d1,					/* U+0003d1 */
	0x0003d5,					/* U+0003d5 */
	0x0003d6,					/* U+0003d6 */
	0x0003d9,					/* U+0003d8 */
	0x0003db,					/* U+0003da */
	0x0003dd,					/* U+0003dc */
	0x0003df,					/* U+0003de */
	0x0003e1,					/* U+0003e0 */
	0x0003e3,					/* U+0003e2 */
	0x0003e5,					/* U+0003e4 */
	0x0003e7,					/* U+0003e6 */
	0x0003e9,					/* U+0003e8 */
	0x0003eb,					/* U+0003ea */
	0x0003ed,					/* U+0003ec */
	0x0003ef,					/* U+0003ee */
	0x0003f0,					/* U+0003f0 */
	0x0003f1,					/* U+0003f1 */
	0x0003f2,					/* U+0003f2 */
	0x0003b8,					/* U+0003f4 */
	0x0003f5,					/* U+0003f5 */
	0x0003f8,					/* U+0003f7 */
	0x0003fb,					/* U+0003fa */
	0x000450,					/* U+000400 */
	0x000451,					/* U+000401 */
	0x000452,					/* U+000402 */
	0x000453,					/* U+000403 */
	0x000454,					/* U+000404 */
	0x000455,					/* U+000405 */
	0x000456,					/* U+000406 */
	0x000457,					/* U+000407 */
	0x000458,					/* U+000408 */
	0x000459,					/* U+000409 */
	0x00045a,					/* U+00040a */
	0x00045b,					/* U+00040b */
	0x00045c,					/* U+00040c */
	0x00045d,					/* U+00040d */
	0x00045e,					/* U+00040e */
	0x00045f,					/* U+00040f */
	0x000430,					/* U+000410 */
	0x000431,					/* U+000411 */
	0x000432,					/* U+000412 */
	0x000433,					/* U+000413 */
	0x000434,					/* U+000414 */
	0x000435,					/* U+000415 */
	0x000436,					/* U+000416 */
	0x000437,					/* U+000417 */
	0x000438,					/* U+000418 */
	0x000439,					/* U+000419 */
	0x00043a,					/* U+00041a */
	0x00043b,					/* U+00041b */
	0x00043c,					/* U+00041c */
	0x00043d,					/* U+00041d */
	0x00043e,					/* U+00041e */
	0x00043f,					/* U+00041f */
	0x000440,					/* U+000420 */
	0x000441,					/* U+000421 */
	0x000442,					/* U+000422 */
	0x000443,					/* U+000423 */
	0x000444,					/* U+000424 */
	0x000445,					/* U+000425 */
	0x000446,					/* U+000426 */
	0x000447,					/* U+000427 */
	0x000448,					/* U+000428 */
	0x000449,					/* U+000429 */
	0x00044a,					/* U+00042a */
	0x00044b,					/* U+00042b */
	0x00044c,					/* U+00042c */
	0x00044d,					/* U+00042d */
	0x00044e,					/* U+00042e */
	0x00044f,					/* U+00042f */
	0x000461,					/* U+000460 */
	0x000463,					/* U+000462 */
	0x000465,					/* U+000464 */
	0x000467,					/* U+000466 */
	0x000469,					/* U+000468 */
	0x00046b,					/* U+00046a */
	0x00046d,					/* U+00046c */
	0x00046f,					/* U+00046e */
	0x000471,					/* U+000470 */
	0x000473,					/* U+000472 */
	0x000475,					/* U+000474 */
	0x000477,					/* U+000476 */
	0x000479,					/* U+000478 */
	0x00047b,					/* U+00047a */
	0x00047d,					/* U+00047c */
	0x00047f,					/* U+00047e */
	0x000481,					/* U+000480 */
	0x00048b,					/* U+00048a */
	0x00048d,					/* U+00048c */
	0x00048f,					/* U+00048e */
	0x000491,					/* U+000490 */
	0x000493,					/* U+000492 */
	0x000495,					/* U+000494 */
	0x000497,					/* U+000496 */
	0x000499,					/* U+000498 */
	0x00049b,					/* U+00049a */
	0x00049d,					/* U+00049c */
	0x00049f,					/* U+00049e */
	0x0004a1,					/* U+0004a0 */
	0x0004a3,					/* U+0004a2 */
	0x0004a5,					/* U+0004a4 */
	0x0004a7,					/* U+0004a6 */
	0x0004a9,					/* U+0004a8 */
	0x0004ab,					/* U+0004aa */
	0x0004ad,					/* U+0004ac */
	0x0004af,					/* U+0004ae */
	0x0004b1,					/* U+0004b0 */
	0x0004b3,					/* U+0004b2 */
	0x0004b5,					/* U+0004b4 */
	0x0004b7,					/* U+0004b6 */
	0x0004b9,					/* U+0004b8 */
	0x0004bb,					/* U+0004ba */
	0x0004bd,					/* U+0004bc */
	0x0004bf,					/* U+0004be */
	0x0004cf,					/* U+0004c0 */
	0x0004c2,					/* U+0004c1 */
	0x0004c4,					/* U+0004c3 */
	0x0004c6,					/* U+0004c5 */
	0x0004c8,					/* U+0004c7 */
	0x0004ca,					/* U+0004c9 */
	0x0004cc,					/* U+0004cb */
	0x0004ce,					/* U+0004cd */
	0x0004d1,					/* U+0004d0 */
	0x0004d3,					/* U+0004d2 */
	0x0004d5,					/* U+0004d4 */
	0x0004d7,					/* U+0004d6 */
	0x0004d9,					/* U+0004d8 */
	0x0004db,					/* U+0004da */
	0x0004dd,					/* U+0004dc */
	0x0004df,					/* U+0004de */
	0x0004e1,					/* U+0004e0 */
	0x0004e3,					/* U+0004e2 */
	0x0004e5,					/* U+0004e4 */
	0x0004e7,					/* U+0004e6 */
	0x0004e9,					/* U+0004e8 */
	0x0004eb,					/* U+0004ea */
	0x0004ed,					/* U+0004ec */
	0x0004ef,					/* U+0004ee */
	0x0004f1,					/* U+0004f0 */
	0x0004f3,					/* U+0004f2 */
	0x0004f5,					/* U+0004f4 */
	0x0004f7,					/* U+0004f6 */
	0x0004f9,					/* U+0004f8 */
	0x0004fb,					/* U+0004fa */
	0x0004fd,					/* U+0004fc */
	0x0004ff,					/* U+0004fe */
	0x000501,					/* U+000500 */
	0x000503,					/* U+000502 */
	0x000505,					/* U+000504 */
	0x000507,					/* U+000506 */
	0x000509,					/* U+000508 */
	0x00050b,					/* U+00050a */
	0x00050d,					/* U+00050c */
	0x00050f,					/* U+00050e */
	0x000511,					/* U+000510 */
	0x000513,					/* U+000512 */
	0x000515,					/* U+000514 */
	0x000517,					/* U+000516 */
	0x000519,					/* U+000518 */
	0x00051b,					/* U+00051a */
	0x00051d,					/* U+00051c */
	0x00051f,					/* U+00051e */
	0x000521,					/* U+000520 */
	0x000523,					/* U+000522 */
	0x000525,					/* U+000524 */
	0x000527,					/* U+000526 */
	0x000529,					/* U+000528 */
	0x00052b,					/* U+00052a */
	0x00052d,					/* U+00052c */
	0x00052f,					/* U+00052e */
	0x000561,					/* U+000531 */
	0x000562,					/* U+000532 */
	0x000563,					/* U+000533 */
	0x000564,					/* U+000534 */
	0x000565,					/* U+000535 */
	0x000566,					/* U+000536 */
	0x000567,					/* U+000537 */
	0x000568,					/* U+000538 */
	0x000569,					/* U+000539 */
	0x00056a,					/* U+00053a */
	0x00056b,					/* U+00053b */
	0x00056c,					/* U+00053c */
	0x00056d,					/* U+00053d */
	0x00056e,					/* U+00053e */
	0x00056f,					/* U+00053f */
	0x000570,					/* U+000540 */
	0x000571,					/* U+000541 */
	0x000572,					/* U+000542 */
	0x000573,					/* U+000543 */
	0x000574,					/* U+000544 */
	0x000575,					/* U+000545 */
	0x000576,					/* U+000546 */
	0x000577,					/* U+000547 */
	0x000578,					/* U+000548 */
	0x000579,					/* U+000549 */
	0x00057a,					/* U+00054a */
	0x00057b,					/* U+00054b */
	0x00057c,					/* U+00054c */
	0x00057d,					/* U+00054d */
	0x00057e,					/* U+00054e */
	0x00057f,					/* U+00054f */
	0x000580,					/* U+000550 */
	0x000581,					/* U+000551 */
	0x000582,					/* U+000552 */
	0x000583,					/* U+000553 */
	0x000584,					/* U+000554 */
	0x000585,					/* U+000555 */
	0x000586,					/* U+000556 */
	0x000587,					/* U+000587 */
	0x002d00,					/* U+0010a0 */
	0x002d01,					/* U+0010a1 */
	0x002d02,					/* U+0010a2 */
	0x002d03,					/* U+0010a3 */
	0x002d04,					/* U+0010a4 */
	0x002d05,					/* U+0010a5 */
	0x002d06,					/* U+0010a6 */
	0x002d07,					/* U+0010a7 */
	0x002d08,					/* U+0010a8 */
	0x002d09,					/* U+0010a9 */
	0x002d0a,					/* U+0010aa */
	0x002d0b,					/* U+0010ab */
	0x002d0c,					/* U+0010ac */
	0x002d0d,					/* U+0010ad */
	0x002d0e,					/* U+0010ae */
	0x002d0f,					/* U+0010af */
	0x002d10,					/* U+0010b0 */
	0x002d11,					/* U+0010b1 */
	0x002d12,					/* U+0010b2 */
	0x002d13,					/* U+0010b3 */
	0x002d14,					/* U+0010b4 */
	0x002d15,					/* U+0010b5 */
	0x002d16,					/* U+0010b6 */
	0x002d17,					/* U+0010b7 */
	0x002d18,					/* U+0010b8 */
	0x002d19,					/* U+0010b9 */
	0x002d1a,					/* U+0010ba */
	0x002d1b,					/* U+0010bb */
	0x002d1c,					/* U+0010bc */
	0x002d1d,					/* U+0010bd */
	0x002d1e,					/* U+0010be */
	0x002d1f,					/* U+0010bf */
	0x002d20,					/* U+0010c0 */
	0x002d21,					/* U+0010c1 */
	0x002d22,					/* U+0010c2 */
	0x002d23,					/* U+0010c3 */
	0x002d24,					/* U+0010c4 */
	0x002d25,					/* U+0010c5 */
	0x002d27,					/* U+0010c7 */
	0x002d2d,					/* U+0010cd */
	0x0010d0,					/* U+0010d0 */
	0x0010d1,					/* U+0010d1 */
	0x0010d2,					/* U+0010d2 */
	0x0010d3,					/* U+0010d3 */
	0x0010d4,					/* U+0010d4 */
	0x0010d5,					/* U+0010d5 */
	0x0010d6,					/* U+0010d6 */
	0x0010d7,					/* U+0010d7 */
	0x0010d8,					/* U+0010d8 */
	0x0010d9,					/* U+0010d9 */
	0x0010da,					/* U+0010da */
	0x0010db,					/* U+0010db */
	0x0010dc,					/* U+0010dc */
	0x0010dd,					/* U+0010dd */
	0x0010de,					/* U+0010de */
	0x0010df,					/* U+0010df */
	0x0010e0,					/* U+0010e0 */
	0x0010e1,					/* U+0010e1 */
	0x0010e2,					/* U+0010e2 */
	0x0010e3,					/* U+0010e3 */
	0x0010e4,					/* U+0010e4 */
	0x0010e5,					/* U+0010e5 */
	0x0010e6,					/* U+0010e6 */
	0x0010e7,					/* U+0010e7 */
	0x0010e8,					/* U+0010e8 */
	0x0010e9,					/* U+0010e9 */
	0x0010ea,					/* U+0010ea */
	0x0010eb,					/* U+0010eb */
	0x0010ec,					/* U+0010ec */
	0x0010ed,					/* U+0010ed */
	0x0010ee,					/* U+0010ee */
	0x0010ef,					/* U+0010ef */
	0x0010f0,					/* U+0010f0 */
	0x0010f1,					/* U+0010f1 */
	0x0010f2,					/* U+0010f2 */
	0x0010f3,					/* U+0010f3 */
	0x0010f4,					/* U+0010f4 */
	0x0010f5,					/* U+0010f5 */
	0x0010f6,					/* U+0010f6 */
	0x0010f7,					/* U+0010f7 */
	0x0010f8,					/* U+0010f8 */
	0x0010f9,					/* U+0010f9 */
	0x0010fa,					/* U+0010fa */
	0x0010fd,					/* U+0010fd */
	0x0010fe,					/* U+0010fe */
	0x0010ff,					/* U+0010ff */
	0x00ab70,					/* U+0013a0 */
	0x00ab71,					/* U+0013a1 */
	0x00ab72,					/* U+0013a2 */
	0x00ab73,					/* U+0013a3 */
	0x00ab74,					/* U+0013a4 */
	0x00ab75,					/* U+0013a5 */
	0x00ab76,					/* U+0013a6 */
	0x00ab77,					/* U+0013a7 */
	0x00ab78,					/* U+0013a8 */
	0x00ab79,					/* U+0013a9 */
	0x00ab7a,					/* U+0013aa */
	0x00ab7b,					/* U+0013ab */
	0x00ab7c,					/* U+0013ac */
	0x00ab7d,					/* U+0013ad */
	0x00ab7e,					/* U+0013ae */
	0x00ab7f,					/* U+0013af */
	0x00ab80,					/* U+0013b0 */
	0x00ab81,					/* U+0013b1 */
	0x00ab82,					/* U+0013b2 */
	0x00ab83,					/* U+0013b3 */
	0x00ab84,					/* U+0013b4 */
	0x00ab85,					/* U+0013b5 */
	0x00ab86,					/* U+0013b6 */
	0x00ab87,					/* U+0013b7 */
	0x00ab88,					/* U+0013b8 */
	0x00ab89,					/* U+0013b9 */
	0x00ab8a,					/* U+0013ba */
	0x00ab8b,					/* U+0013bb */
	0x00ab8c,					/* U+0013bc */
	0x00ab8d,					/* U+0013bd */
	0x00ab8e,					/* U+0013be */
	0x00ab8f,					/* U+0013bf */
	0x00ab90,					/* U+0013c0 */
	0x00ab91,					/* U+0013c1 */
	0x00ab92,					/* U+0013c2 */
	0x00ab93,					/* U+0013c3 */
	0x00ab94,					/* U+0013c4 */
	0x00ab95,					/* U+0013c5 */
	0x00ab96,					/* U+0013c6 */
	0x00ab97,					/* U+0013c7 */
	0x00ab98,					/* U+0013c8 */
	0x00ab99,					/* U+0013c9 */
	0x00ab9a,					/* U+0013ca */
	0x00ab9b,					/* U+0013cb */
	0x00ab9c,					/* U+0013cc */
	0x00ab9d,					/* U+0013cd */
	0x00ab9e,					/* U+0013ce */
	0x00ab9f,					/* U+0013cf */
	0x00aba0,					/* U+0013d0 */
	0x00aba1,					/* U+0013d1 */
	0x00aba2,					/* U+0013d2 */
	0x00aba3,					/* U+0013d3 */
	0x00aba4,					/* U+0013d4 */
	0x00aba5,					/* U+0013d5 */
	0x00aba6,					/* U+0013d6 */
	0x00aba7,					/* U+0013d7 */
	0x00aba8,					/* U+0013d8 */
	0x00aba9,					/* U+0013d9 */
	0x00abaa,					/* U+0013da */
	0x00abab,					/* U+0013db */
	0x00abac,					/* U+0013dc */
	0x00abad,					/* U+0013dd */
	0x00abae,					/* U+0013de */
	0x00abaf,					/* U+0013df */
	0x00abb0,					/* U+0013e0 */
	0x00abb1,					/* U+0013e1 */
	0x00abb2,					/* U+0013e2 */
	0x00abb3,					/* U+0013e3 */
	0x00abb4,					/* U+0013e4 */
	0x00abb5,					/* U+0013e5 */
	0x00abb6,					/* U+0013e6 */
	0x00abb7,					/* U+0013e7 */
	0x00abb8,					/* U+0013e8 */
	0x00abb9,					/* U+0013e9 */
	0x00abba,					/* U+0013ea */
	0x00abbb,					/* U+0013eb */
	0x00abbc,					/* U+0013ec */
	0x00abbd,					/* U+0013ed */
	0x00abbe,					/* U+0013ee */
	0x00abbf,					/* U+0013ef */
	0x0013f8,					/* U+0013f0 */
	0x0013f9,					/* U+0013f1 */
	0x0013fa,					/* U+0013f2 */
	0x0013fb,					/* U+0013f3 */
	0x0013fc,					/* U+0013f4 */
	0x0013fd,					/* U+0013f5 */
	0x001c80,					/* U+001c80 */
	0x001c81,					/* U+001c81 */
	0x001c82,					/* U+001c82 */
	0x001c83,					/* U+001c83 */
	0x001c84,					/* U+001c84 */
	0x001c85,					/* U+001c85 */
	0x001c86,					/* U+001c86 */
	0x001c87,					/* U+001c87 */
	0x001c88,					/* U+001c88 */
	0x001c8a,					/* U+001c89 */
	0x0010d0,					/* U+001c90 */
	0x0010d1,					/* U+001c91 */
	0x0010d2,					/* U+001c92 */
	0x0010d3,					/* U+001c93 */
	0x0010d4,					/* U+001c94 */
	0x0010d5,					/* U+001c95 */
	0x0010d6,					/* U+001c96 */
	0x0010d7,					/* U+001c97 */
	0x0010d8,					/* U+001c98 */
	0x0010d9,					/* U+001c99 */
	0x0010da,					/* U+001c9a */
	0x0010db,					/* U+001c9b */
	0x0010dc,					/* U+001c9c */
	0x0010dd,					/* U+001c9d */
	0x0010de,					/* U+001c9e */
	0x0010df,					/* U+001c9f */
	0x0010e0,					/* U+001ca0 */
	0x0010e1,					/* U+001ca1 */
	0x0010e2,					/* U+001ca2 */
	0x0010e3,					/* U+001ca3 */
	0x0010e4,					/* U+001ca4 */
	0x0010e5,					/* U+001ca5 */
	0x0010e6,					/* U+001ca6 */
	0x0010e7,					/* U+001ca7 */
	0x0010e8,					/* U+001ca8 */
	0x0010e9,					/* U+001ca9 */
	0x0010ea,					/* U+001caa */
	0x0010eb,					/* U+001cab */
	0x0010ec,					/* U+001cac */
	0x0010ed,					/* U+001cad */
	0x0010ee,					/* U+001cae */
	0x0010ef,					/* U+001caf */
	0x0010f0,					/* U+001cb0 */
	0x0010f1,					/* U+001cb1 */
	0x0010f2,					/* U+001cb2 */
	0x0010f3,					/* U+001cb3 */
	0x0010f4,					/* U+001cb4 */
	0x0010f5,					/* U+001cb5 */
	0x0010f6,					/* U+001cb6 */
	0x0010f7,					/* U+001cb7 */
	0x0010f8,					/* U+001cb8 */
	0x0010f9,					/* U+001cb9 */
	0x0010fa,					/* U+001cba */
	0x0010fd,					/* U+001cbd */
	0x0010fe,					/* U+001cbe */
	0x0010ff,					/* U+001cbf */
	0x001d79,					/* U+001d79 */
	0x001d7d,					/* U+001d7d */
	0x001d8e,					/* U+001d8e */
	0x001e01,					/* U+001e00 */
	0x001e03,					/* U+001e02 */
	0x001e05,					/* U+001e04 */
	0x001e07,					/* U+001e06 */
	0x001e09,					/* U+001e08 */
	0x001e0b,					/* U+001e0a */
	0x001e0d,					/* U+001e0c */
	0x001e0f,					/* U+001e0e */
	0x001e11,					/* U+001e10 */
	0x001e13,					/* U+001e12 */
	0x001e15,					/* U+001e14 */
	0x001e17,					/* U+001e16 */
	0x001e19,					/* U+001e18 */
	0x001e1b,					/* U+001e1a */
	0x001e1d,					/* U+001e1c */
	0x001e1f,					/* U+001e1e */
	0x001e21,					/* U+001e20 */
	0x001e23,					/* U+001e22 */
	0x001e25,					/* U+001e24 */
	0x001e27,					/* U+001e26 */
	0x001e29,					/* U+001e28 */
	0x001e2b,					/* U+001e2a */
	0x001e2d,					/* U+001e2c */
	0x001e2f,					/* U+001e2e */
	0x001e31,					/* U+001e30 */
	0x001e33,					/* U+001e32 */
	0x001e35,					/* U+001e34 */
	0x001e37,					/* U+001e36 */
	0x001e39,					/* U+001e38 */
	0x001e3b,					/* U+001e3a */
	0x001e3d,					/* U+001e3c */
	0x001e3f,					/* U+001e3e */
	0x001e41,					/* U+001e40 */
	0x001e43,					/* U+001e42 */
	0x001e45,					/* U+001e44 */
	0x001e47,					/* U+001e46 */
	0x001e49,					/* U+001e48 */
	0x001e4b,					/* U+001e4a */
	0x001e4d,					/* U+001e4c */
	0x001e4f,					/* U+001e4e */
	0x001e51,					/* U+001e50 */
	0x001e53,					/* U+001e52 */
	0x001e55,					/* U+001e54 */
	0x001e57,					/* U+001e56 */
	0x001e59,					/* U+001e58 */
	0x001e5b,					/* U+001e5a */
	0x001e5d,					/* U+001e5c */
	0x001e5f,					/* U+001e5e */
	0x001e61,					/* U+001e60 */
	0x001e63,					/* U+001e62 */
	0x001e65,					/* U+001e64 */
	0x001e67,					/* U+001e66 */
	0x001e69,					/* U+001e68 */
	0x001e6b,					/* U+001e6a */
	0x001e6d,					/* U+001e6c */
	0x001e6f,					/* U+001e6e */
	0x001e71,					/* U+001e70 */
	0x001e73,					/* U+001e72 */
	0x001e75,					/* U+001e74 */
	0x001e77,					/* U+001e76 */
	0x001e79,					/* U+001e78 */
	0x001e7b,					/* U+001e7a */
	0x001e7d,					/* U+001e7c */
	0x001e7f,					/* U+001e7e */
	0x001e81,					/* U+001e80 */
	0x001e83,					/* U+001e82 */
	0x001e85,					/* U+001e84 */
	0x001e87,					/* U+001e86 */
	0x001e89,					/* U+001e88 */
	0x001e8b,					/* U+001e8a */
	0x001e8d,					/* U+001e8c */
	0x001e8f,					/* U+001e8e */
	0x001e91,					/* U+001e90 */
	0x001e93,					/* U+001e92 */
	0x001e95,					/* U+001e94 */
	0x001e96,					/* U+001e96 */
	0x001e97,					/* U+001e97 */
	0x001e98,					/* U+001e98 */
	0x001e99,					/* U+001e99 */
	0x001e9a,					/* U+001e9a */
	0x001e9b,					/* U+001e9b */
	0x0000df,					/* U+001e9e */
	0x001ea1,					/* U+001ea0 */
	0x001ea3,					/* U+001ea2 */
	0x001ea5,					/* U+001ea4 */
	0x001ea7,					/* U+001ea6 */
	0x001ea9,					/* U+001ea8 */
	0x001eab,					/* U+001eaa */
	0x001ead,					/* U+001eac */
	0x001eaf,					/* U+001eae */
	0x001eb1,					/* U+001eb0 */
	0x001eb3,					/* U+001eb2 */
	0x001eb5,					/* U+001eb4 */
	0x001eb7,					/* U+001eb6 */
	0x001eb9,					/* U+001eb8 */
	0x001ebb,					/* U+001eba */
	0x001ebd,					/* U+001ebc */
	0x001ebf,					/* U+001ebe */
	0x001ec1,					/* U+001ec0 */
	0x001ec3,					/* U+001ec2 */
	0x001ec5,					/* U+001ec4 */
	0x001ec7,					/* U+001ec6 */
	0x001ec9,					/* U+001ec8 */
	0x001ecb,					/* U+001eca */
	0x001ecd,					/* U+001ecc */
	0x001ecf,					/* U+001ece */
	0x001ed1,					/* U+001ed0 */
	0x001ed3,					/* U+001ed2 */
	0x001ed5,					/* U+001ed4 */
	0x001ed7,					/* U+001ed6 */
	0x001ed9,					/* U+001ed8 */
	0x001edb,					/* U+001eda */
	0x001edd,					/* U+001edc */
	0x001edf,					/* U+001ede */
	0x001ee1,					/* U+001ee0 */
	0x001ee3,					/* U+001ee2 */
	0x001ee5,					/* U+001ee4 */
	0x001ee7,					/* U+001ee6 */
	0x001ee9,					/* U+001ee8 */
	0x001eeb,					/* U+001eea */
	0x001eed,					/* U+001eec */
	0x001eef,					/* U+001eee */
	0x001ef1,					/* U+001ef0 */
	0x001ef3,					/* U+001ef2 */
	0x001ef5,					/* U+001ef4 */
	0x001ef7,					/* U+001ef6 */
	0x001ef9,					/* U+001ef8 */
	0x001efb,					/* U+001efa */
	0x001efd,					/* U+001efc */
	0x001eff,					/* U+001efe */
	0x001f00,					/* U+001f00 */
	0x001f01,					/* U+001f01 */
	0x001f02,					/* U+001f02 */
	0x001f03,					/* U+001f03 */
	0x001f04,					/* U+001f04 */
	0x001f05,					/* U+001f05 */
	0x001f06,					/* U+001f06 */
	0x001f07,					/* U+001f07 */
	0x001f10,					/* U+001f10 */
	0x001f11,					/* U+001f11 */
	0x001f12,					/* U+001f12 */
	0x001f13,					/* U+001f13 */
	0x001f14,					/* U+001f14 */
	0x001f15,					/* U+001f15 */
	0x001f20,					/* U+001f20 */
	0x001f21,					/* U+001f21 */
	0x001f22,					/* U+001f22 */
	0x001f23,					/* U+001f23 */
	0x001f24,					/* U+001f24 */
	0x001f25,					/* U+001f25 */
	0x001f26,					/* U+001f26 */
	0x001f27,					/* U+001f27 */
	0x001f30,					/* U+001f30 */
	0x001f31,					/* U+001f31 */
	0x001f32,					/* U+001f32 */
	0x001f33,					/* U+001f33 */
	0x001f34,					/* U+001f34 */
	0x001f35,					/* U+001f35 */
	0x001f36,					/* U+001f36 */
	0x001f37,					/* U+001f37 */
	0x001f40,					/* U+001f40 */
	0x001f41,					/* U+001f41 */
	0x001f42,					/* U+001f42 */
	0x001f43,					/* U+001f43 */
	0x001f44,					/* U+001f44 */
	0x001f45,					/* U+001f45 */
	0x001f50,					/* U+001f50 */
	0x001f51,					/* U+001f51 */
	0x001f52,					/* U+001f52 */
	0x001f53,					/* U+001f53 */
	0x001f54,					/* U+001f54 */
	0x001f55,					/* U+001f55 */
	0x001f56,					/* U+001f56 */
	0x001f57,					/* U+001f57 */
	0x001f60,					/* U+001f60 */
	0x001f61,					/* U+001f61 */
	0x001f62,					/* U+001f62 */
	0x001f63,					/* U+001f63 */
	0x001f64,					/* U+001f64 */
	0x001f65,					/* U+001f65 */
	0x001f66,					/* U+001f66 */
	0x001f67,					/* U+001f67 */
	0x001f70,					/* U+001f70 */
	0x001f71,					/* U+001f71 */
	0x001f72,					/* U+001f72 */
	0x001f73,					/* U+001f73 */
	0x001f74,					/* U+001f74 */
	0x001f75,					/* U+001f75 */
	0x001f76,					/* U+001f76 */
	0x001f77,					/* U+001f77 */
	0x001f78,					/* U+001f78 */
	0x001f79,					/* U+001f79 */
	0x001f7a,					/* U+001f7a */
	0x001f7b,					/* U+001f7b */
	0x001f7c,					/* U+001f7c */
	0x001f7d,					/* U+001f7d */
	0x001f80,					/* U+001f80 */
	0x001f81,					/* U+001f81 */
	0x001f82,					/* U+001f82 */
	0x001f83,					/* U+001f83 */
	0x001f84,					/* U+001f84 */
	0x001f85,					/* U+001f85 */
	0x001f86,					/* U+001f86 */
	0x001f87,					/* U+001f87 */
	0x001f80,					/* U+001f88 */
	0x001f81,					/* U+001f89 */
	0x001f82,					/* U+001f8a */
	0x001f83,					/* U+001f8b */
	0x001f84,					/* U+001f8c */
	0x001f85,					/* U+001f8d */
	0x001f86,					/* U+001f8e */
	0x001f87,					/* U+001f8f */
	0x001f90,					/* U+001f90 */
	0x001f91,					/* U+001f91 */
	0x001f92,					/* U+001f92 */
	0x001f93,					/* U+001f93 */
	0x001f94,					/* U+001f94 */
	0x001f95,					/* U+001f95 */
	0x001f96,					/* U+001f96 */
	0x001f97,					/* U+001f97 */
	0x001f90,					/* U+001f98 */
	0x001f91,					/* U+001f99 */
	0x001f92,					/* U+001f9a */
	0x001f93,					/* U+001f9b */
	0x001f94,					/* U+001f9c */
	0x001f95,					/* U+001f9d */
	0x001f96,					/* U+001f9e */
	0x001f97,					/* U+001f9f */
	0x001fa0,					/* U+001fa0 */
	0x001fa1,					/* U+001fa1 */
	0x001fa2,					/* U+001fa2 */
	0x001fa3,					/* U+001fa3 */
	0x001fa4,					/* U+001fa4 */
	0x001fa5,					/* U+001fa5 */
	0x001fa6,					/* U+001fa6 */
	0x001fa7,					/* U+001fa7 */
	0x001fa0,					/* U+001fa8 */
	0x001fa1,					/* U+001fa9 */
	0x001fa2,					/* U+001faa */
	0x001fa3,					/* U+001fab */
	0x001fa4,					/* U+001fac */
	0x001fa5,					/* U+001fad */
	0x001fa6,					/* U+001fae */
	0x001fa7,					/* U+001faf */
	0x001fb0,					/* U+001fb0 */
	0x001fb1,					/* U+001fb1 */
	0x001fb2,					/* U+001fb2 */
	0x001fb3,					/* U+001fb3 */
	0x001fb4,					/* U+001fb4 */
	0x001fb6,					/* U+001fb6 */
	0x001fb7,					/* U+001fb7 */
	0x001fb3,					/* U+001fbc */
	0x001fbe,					/* U+001fbe */
	0x001fc2,					/* U+001fc2 */
	0x001fc3,					/* U+001fc3 */
	0x001fc4,					/* U+001fc4 */
	0x001fc6,					/* U+001fc6 */
	0x001fc7,					/* U+001fc7 */
	0x001fc3,					/* U+001fcc */
	0x001fd0,					/* U+001fd0 */
	0x001fd1,					/* U+001fd1 */
	0x001fd2,					/* U+001fd2 */
	0x001fd3,					/* U+001fd3 */
	0x001fd6,					/* U+001fd6 */
	0x001fd7,					/* U+001fd7 */
	0x001fe0,					/* U+001fe0 */
	0x001fe1,					/* U+001fe1 */
	0x001fe2,					/* U+001fe2 */
	0x001fe3,					/* U+001fe3 */
	0x001fe4,					/* U+001fe4 */
	0x001fe5,					/* U+001fe5 */
	0x001fe6,					/* U+001fe6 */
	0x001fe7,					/* U+001fe7 */
	0x001ff2,					/* U+001ff2 */
	0x001ff3,					/* U+001ff3 */
	0x001ff4,					/* U+001ff4 */
	0x001ff6,					/* U+001ff6 */
	0x001ff7,					/* U+001ff7 */
	0x001ff3,					/* U+001ffc */
	0x0003c9,					/* U+002126 */
	0x00006b,					/* U+00212a */
	0x0000e5,					/* U+00212b */
	0x00214e,					/* U+002132 */
	0x002170,					/* U+002160 */
	0x002171,					/* U+002161 */
	0x002172,					/* U+002162 */
	0x002173,					/* U+002163 */
	0x002174,					/* U+002164 */
	0x002175,					/* U+002165 */
	0x002176,					/* U+002166 */
	0x002177,					/* U+002167 */
	0x002178,					/* U+002168 */
	0x002179,					/* U+002169 */
	0x00217a,					/* U+00216a */
	0x00217b,					/* U+00216b */
	0x00217c,					/* U+00216c */
	0x00217d,					/* U+00216d */
	0x00217e,					/* U+00216e */
	0x00217f,					/* U+00216f */
	0x002184,					/* U+002183 */
	0x0024d0,					/* U+0024b6 */
	0x0024d1,					/* U+0024b7 */
	0x0024d2,					/* U+0024b8 */
	0x0024d3,					/* U+0024b9 */
	0x0024d4,					/* U+0024ba */
	0x0024d5,					/* U+0024bb */
	0x0024d6,					/* U+0024bc */
	0x0024d7,					/* U+0024bd */
	0x0024d8,					/* U+0024be */
	0x0024d9,					/* U+0024bf */
	0x0024da,					/* U+0024c0 */
	0x0024db,					/* U+0024c1 */
	0x0024dc,					/* U+0024c2 */
	0x0024dd,					/* U+0024c3 */
	0x0024de,					/* U+0024c4 */
	0x0024df,					/* U+0024c5 */
	0x0024e0,					/* U+0024c6 */
	0x0024e1,					/* U+0024c7 */
	0x0024e2,					/* U+0024c8 */
	0x0024e3,					/* U+0024c9 */
	0x0024e4,					/* U+0024ca */
	0x0024e5,					/* U+0024cb */
	0x0024e6,					/* U+0024cc */
	0x0024e7,					/* U+0024cd */
	0x0024e8,					/* U+0024ce */
	0x0024e9,					/* U+0024cf */
	0x002c30,					/* U+002c00 */
	0x002c31,					/* U+002c01 */
	0x002c32,					/* U+002c02 */
	0x002c33,					/* U+002c03 */
	0x002c34,					/* U+002c04 */
	0x002c35,					/* U+002c05 */
	0x002c36,					/* U+002c06 */
	0x002c37,					/* U+002c07 */
	0x002c38,					/* U+002c08 */
	0x002c39,					/* U+002c09 */
	0x002c3a,					/* U+002c0a */
	0x002c3b,					/* U+002c0b */
	0x002c3c,					/* U+002c0c */
	0x002c3d,					/* U+002c0d */
	0x002c3e,					/* U+002c0e */
	0x002c3f,					/* U+002c0f */
	0x002c40,					/* U+002c10 */
	0x002c41,					/* U+002c11 */
	0x002c42,					/* U+002c12 */
	0x002c43,					/* U+002c13 */
	0x002c44,					/* U+002c14 */
	0x002c45,					/* U+002c15 */
	0x002c46,					/* U+002c16 */
	0x002c47,					/* U+002c17 */
	0x002c48,					/* U+002c18 */
	0x002c49,					/* U+002c19 */
	0x002c4a,					/* U+002c1a */
	0x002c4b,					/* U+002c1b */
	0x002c4c,					/* U+002c1c */
	0x002c4d,					/* U+002c1d */
	0x002c4e,					/* U+002c1e */
	0x002c4f,					/* U+002c1f */
	0x002c50,					/* U+002c20 */
	0x002c51,					/* U+002c21 */
	0x002c52,					/* U+002c22 */
	0x002c53,					/* U+002c23 */
	0x002c54,					/* U+002c24 */
	0x002c55,					/* U+002c25 */
	0x002c56,					/* U+002c26 */
	0x002c57,					/* U+002c27 */
	0x002c58,					/* U+002c28 */
	0x002c59,					/* U+002c29 */
	0x002c5a,					/* U+002c2a */
	0x002c5b,					/* U+002c2b */
	0x002c5c,					/* U+002c2c */
	0x002c5d,					/* U+002c2d */
	0x002c5e,					/* U+002c2e */
	0x002c5f,					/* U+002c2f */
	0x002c61,					/* U+002c60 */
	0x002c68,					/* U+002c67 */
	0x002c6a,					/* U+002c69 */
	0x002c6c,					/* U+002c6b */
	0x002c73,					/* U+002c72 */
	0x002c76,					/* U+002c75 */
	0x002c81,					/* U+002c80 */
	0x002c83,					/* U+002c82 */
	0x002c85,					/* U+002c84 */
	0x002c87,					/* U+002c86 */
	0x002c89,					/* U+002c88 */
	0x002c8b,					/* U+002c8a */
	0x002c8d,					/* U+002c8c */
	0x002c8f,					/* U+002c8e */
	0x002c91,					/* U+002c90 */
	0x002c93,					/* U+002c92 */
	0x002c95,					/* U+002c94 */
	0x002c97,					/* U+002c96 */
	0x002c99,					/* U+002c98 */
	0x002c9b,					/* U+002c9a */
	0x002c9d,					/* U+002c9c */
	0x002c9f,					/* U+002c9e */
	0x002ca1,					/* U+002ca0 */
	0x002ca3,					/* U+002ca2 */
	0x002ca5,					/* U+002ca4 */
	0x002ca7,					/* U+002ca6 */
	0x002ca9,					/* U+002ca8 */
	0x002cab,					/* U+002caa */
	0x002cad,					/* U+002cac */
	0x002caf,					/* U+002cae */
	0x002cb1,					/* U+002cb0 */
	0x002cb3,					/* U+002cb2 */
	0x002cb5,					/* U+002cb4 */
	0x002cb7,					/* U+002cb6 */
	0x002cb9,					/* U+002cb8 */
	0x002cbb,					/* U+002cba */
	0x002cbd,					/* U+002cbc */
	0x002cbf,					/* U+002cbe */
	0x002cc1,					/* U+002cc0 */
	0x002cc3,					/* U+002cc2 */
	0x002cc5,					/* U+002cc4 */
	0x002cc7,					/* U+002cc6 */
	0x002cc9,					/* U+002cc8 */
	0x002ccb,					/* U+002cca */
	0x002ccd,					/* U+002ccc */
	0x002ccf,					/* U+002cce */
	0x002cd1,					/* U+002cd0 */
	0x002cd3,					/* U+002cd2 */
	0x002cd5,					/* U+002cd4 */
	0x002cd7,					/* U+002cd6 */
	0x002cd9,					/* U+002cd8 */
	0x002cdb,					/* U+002cda */
	0x002cdd,					/* U+002cdc */
	0x002cdf,					/* U+002cde */
	0x002ce1,					/* U+002ce0 */
	0x002ce3,					/* U+002ce2 */
	0x002cec,					/* U+002ceb */
	0x002cee,					/* U+002ced */
	0x002cf3,					/* U+002cf2 */
	0x00a641,					/* U+00a640 */
	0x00a643,					/* U+00a642 */
	0x00a645,					/* U+00a644 */
	0x00a647,					/* U+00a646 */
	0x00a649,					/* U+00a648 */
	0x00a64b,					/* U+00a64a */
	0x00a64d,					/* U+00a64c */
	0x00a64f,					/* U+00a64e */
	0x00a651,					/* U+00a650 */
	0x00a653,					/* U+00a652 */
	0x00a655,					/* U+00a654 */
	0x00a657,					/* U+00a656 */
	0x00a659,					/* U+00a658 */
	0x00a65b,					/* U+00a65a */
	0x00a65d,					/* U+00a65c */
	0x00a65f,					/* U+00a65e */
	0x00a661,					/* U+00a660 */
	0x00a663,					/* U+00a662 */
	0x00a665,					/* U+00a664 */
	0x00a667,					/* U+00a666 */
	0x00a669,					/* U+00a668 */
	0x00a66b,					/* U+00a66a */
	0x00a66d,					/* U+00a66c */
	0x00a681,					/* U+00a680 */
	0x00a683,					/* U+00a682 */
	0x00a685,					/* U+00a684 */
	0x00a687,					/* U+00a686 */
	0x00a689,					/* U+00a688 */
	0x00a68b,					/* U+00a68a */
	0x00a68d,					/* U+00a68c */
	0x00a68f,					/* U+00a68e */
	0x00a691,					/* U+00a690 */
	0x00a693,					/* U+00a692 */
	0x00a695,					/* U+00a694 */
	0x00a697,					/* U+00a696 */
	0x00a699,					/* U+00a698 */
	0x00a69b,					/* U+00a69a */
	0x00a723,					/* U+00a722 */
	0x00a725,					/* U+00a724 */
	0x00a727,					/* U+00a726 */
	0x00a729,					/* U+00a728 */
	0x00a72b,					/* U+00a72a */
	0x00a72d,					/* U+00a72c */
	0x00a72f,					/* U+00a72e */
	0x00a733,					/* U+00a732 */
	0x00a735,					/* U+00a734 */
	0x00a737,					/* U+00a736 */
	0x00a739,					/* U+00a738 */
	0x00a73b,					/* U+00a73a */
	0x00a73d,					/* U+00a73c */
	0x00a73f,					/* U+00a73e */
	0x00a741,					/* U+00a740 */
	0x00a743,					/* U+00a742 */
	0x00a745,					/* U+00a744 */
	0x00a747,					/* U+00a746 */
	0x00a749,					/* U+00a748 */
	0x00a74b,					/* U+00a74a */
	0x00a74d,					/* U+00a74c */
	0x00a74f,					/* U+00a74e */
	0x00a751,					/* U+00a750 */
	0x00a753,					/* U+00a752 */
	0x00a755,					/* U+00a754 */
	0x00a757,					/* U+00a756 */
	0x00a759,					/* U+00a758 */
	0x00a75b,					/* U+00a75a */
	0x00a75d,					/* U+00a75c */
	0x00a75f,					/* U+00a75e */
	0x00a761,					/* U+00a760 */
	0x00a763,					/* U+00a762 */
	0x00a765,					/* U+00a764 */
	0x00a767,					/* U+00a766 */
	0x00a769,					/* U+00a768 */
	0x00a76b,					/* U+00a76a */
	0x00a76d,					/* U+00a76c */
	0x00a76f,					/* U+00a76e */
	0x00a77a,					/* U+00a779 */
	0x00a77c,					/* U+00a77b */
	0x00a77f,					/* U+00a77e */
	0x00a781,					/* U+00a780 */
	0x00a783,					/* U+00a782 */
	0x00a785,					/* U+00a784 */
	0x00a787,					/* U+00a786 */
	0x00a78c,					/* U+00a78b */
	0x00a791,					/* U+00a790 */
	0x00a793,					/* U+00a792 */
	0x00a794,					/* U+00a794 */
	0x00a797,					/* U+00a796 */
	0x00a799,					/* U+00a798 */
	0x00a79b,					/* U+00a79a */
	0x00a79d,					/* U+00a79c */
	0x00a79f,					/* U+00a79e */
	0x00a7a1,					/* U+00a7a0 */
	0x00a7a3,					/* U+00a7a2 */
	0x00a7a5,					/* U+00a7a4 */
	0x00a7a7,					/* U+00a7a6 */
	0x00a7a9,					/* U+00a7a8 */
	0x00ab53,					/* U+00a7b3 */
	0x00a7b5,					/* U+00a7b4 */
	0x00a7b7,					/* U+00a7b6 */
	0x00a7b9,					/* U+00a7b8 */
	0x00a7bb,					/* U+00a7ba */
	0x00a7bd,					/* U+00a7bc */
	0x00a7bf,					/* U+00a7be */
	0x00a7c1,					/* U+00a7c0 */
	0x00a7c3,					/* U+00a7c2 */
	0x00a7c8,					/* U+00a7c7 */
	0x00a7ca,					/* U+00a7c9 */
	0x00a7cd,					/* U+00a7cc */
	0x00a7d1,					/* U+00a7d0 */
	0x00a7d7,					/* U+00a7d6 */
	0x00a7d9,					/* U+00a7d8 */
	0x00a7db,					/* U+00a7da */
	0x00a7f6,					/* U+00a7f5 */
	0x00fb00,					/* U+00fb00 */
	0x00fb01,					/* U+00fb01 */
	0x00fb02,					/* U+00fb02 */
	0x00fb03,					/* U+00fb03 */
	0x00fb04,					/* U+00fb04 */
	0x00fb05,					/* U+00fb05 */
	0x00fb06,					/* U+00fb06 */
	0x00fb13,					/* U+00fb13 */
	0x00fb14,					/* U+00fb14 */
	0x00fb15,					/* U+00fb15 */
	0x00fb16,					/* U+00fb16 */
	0x00fb17,					/* U+00fb17 */
	0x00ff41,					/* U+00ff21 */
	0x00ff42,					/* U+00ff22 */
	0x00ff43,					/* U+00ff23 */
	0x00ff44,					/* U+00ff24 */
	0x00ff45,					/* U+00ff25 */
	0x00ff46,					/* U+00ff26 */
	0x00ff47,					/* U+00ff27 */
	0x00ff48,					/* U+00ff28 */
	0x00ff49,					/* U+00ff29 */
	0x00ff4a,					/* U+00ff2a */
	0x00ff4b,					/* U+00ff2b */
	0x00ff4c,					/* U+00ff2c */
	0x00ff4d,					/* U+00ff2d */
	0x00ff4e,					/* U+00ff2e */
	0x00ff4f,					/* U+00ff2f */
	0x00ff50,					/* U+00ff30 */
	0x00ff51,					/* U+00ff31 */
	0x00ff52,					/* U+00ff32 */
	0x00ff53,					/* U+00ff33 */
	0x00ff54,					/* U+00ff34 */
	0x00ff55,					/* U+00ff35 */
	0x00ff56,					/* U+00ff36 */
	0x00ff57,					/* U+00ff37 */
	0x00ff58,					/* U+00ff38 */
	0x00ff59,					/* U+00ff39 */
	0x00ff5a,					/* U+00ff3a */
	0x010428,					/* U+010400 */
	0x010429,					/* U+010401 */
	0x01042a,					/* U+010402 */
	0x01042b,					/* U+010403 */
	0x01042c,					/* U+010404 */
	0x01042d,					/* U+010405 */
	0x01042e,					/* U+010406 */
	0x01042f,					/* U+010407 */
	0x010430,					/* U+010408 */
	0x010431,					/* U+010409 */
	0x010432,					/* U+01040a */
	0x010433,					/* U+01040b */
	0x010434,					/* U+01040c */
	0x010435,					/* U+01040d */
	0x010436,					/* U+01040e */
	0x010437,					/* U+01040f */
	0x010438,					/* U+010410 */
	0x010439,					/* U+010411 */
	0x01043a,					/* U+010412 */
	0x01043b,					/* U+010413 */
	0x01043c,					/* U+010414 */
	0x01043d,					/* U+010415 */
	0x01043e,					/* U+010416 */
	0x01043f,					/* U+010417 */
	0x010440,					/* U+010418 */
	0x010441,					/* U+010419 */
	0x010442,					/* U+01041a */
	0x010443,					/* U+01041b */
	0x010444,					/* U+01041c */
	0x010445,					/* U+01041d */
	0x010446,					/* U+01041e */
	0x010447,					/* U+01041f */
	0x010448,					/* U+010420 */
	0x010449,					/* U+010421 */
	0x01044a,					/* U+010422 */
	0x01044b,					/* U+010423 */
	0x01044c,					/* U+010424 */
	0x01044d,					/* U+010425 */
	0x01044e,					/* U+010426 */
	0x01044f,					/* U+010427 */
	0x0104d8,					/* U+0104b0 */
	0x0104d9,					/* U+0104b1 */
	0x0104da,					/* U+0104b2 */
	0x0104db,					/* U+0104b3 */
	0x0104dc,					/* U+0104b4 */
	0x0104dd,					/* U+0104b5 */
	0x0104de,					/* U+0104b6 */
	0x0104df,					/* U+0104b7 */
	0x0104e0,					/* U+0104b8 */
	0x0104e1,					/* U+0104b9 */
	0x0104e2,					/* U+0104ba */
	0x0104e3,					/* U+0104bb */
	0x0104e4,					/* U+0104bc */
	0x0104e5,					/* U+0104bd */
	0x0104e6,					/* U+0104be */
	0x0104e7,					/* U+0104bf */
	0x0104e8,					/* U+0104c0 */
	0x0104e9,					/* U+0104c1 */
	0x0104ea,					/* U+0104c2 */
	0x0104eb,					/* U+0104c3 */
	0x0104ec,					/* U+0104c4 */
	0x0104ed,					/* U+0104c5 */
	0x0104ee,					/* U+0104c6 */
	0x0104ef,					/* U+0104c7 */
	0x0104f0,					/* U+0104c8 */
	0x0104f1,					/* U+0104c9 */
	0x0104f2,					/* U+0104ca */
	0x0104f3,					/* U+0104cb */
	0x0104f4,					/* U+0104cc */
	0x0104f5,					/* U+0104cd */
	0x0104f6,					/* U+0104ce */
	0x0104f7,					/* U+0104cf */
	0x0104f8,					/* U+0104d0 */
	0x0104f9,					/* U+0104d1 */
	0x0104fa,					/* U+0104d2 */
	0x0104fb,					/* U+0104d3 */
	0x010597,					/* U+010570 */
	0x010598,					/* U+010571 */
	0x010599,					/* U+010572 */
	0x01059a,					/* U+010573 */
	0x01059b,					/* U+010574 */
	0x01059c,					/* U+010575 */
	0x01059d,					/* U+010576 */
	0x01059e,					/* U+010577 */
	0x01059f,					/* U+010578 */
	0x0105a0,					/* U+010579 */
	0x0105a1,					/* U+01057a */
	0x0105a3,					/* U+01057c */
	0x0105a4,					/* U+01057d */
	0x0105a5,					/* U+01057e */
	0x0105a6,					/* U+01057f */
	0x0105a7,					/* U+010580 */
	0x0105a8,					/* U+010581 */
	0x0105a9,					/* U+010582 */
	0x0105aa,					/* U+010583 */
	0x0105ab,					/* U+010584 */
	0x0105ac,					/* U+010585 */
	0x0105ad,					/* U+010586 */
	0x0105ae,					/* U+010587 */
	0x0105af,					/* U+010588 */
	0x0105b0,					/* U+010589 */
	0x0105b1,					/* U+01058a */
	0x0105b3,					/* U+01058c */
	0x0105b4,					/* U+01058d */
	0x0105b5,					/* U+01058e */
	0x0105b6,					/* U+01058f */
	0x0105b7,					/* U+010590 */
	0x0105b8,					/* U+010591 */
	0x0105b9,					/* U+010592 */
	0x0105bb,					/* U+010594 */
	0x0105bc,					/* U+010595 */
	0x010cc0,					/* U+010c80 */
	0x010cc1,					/* U+010c81 */
	0x010cc2,					/* U+010c82 */
	0x010cc3,					/* U+010c83 */
	0x010cc4,					/* U+010c84 */
	0x010cc5,					/* U+010c85 */
	0x010cc6,					/* U+010c86 */
	0x010cc7,					/* U+010c87 */
	0x010cc8,					/* U+010c88 */
	0x010cc9,					/* U+010c89 */
	0x010cca,					/* U+010c8a */
	0x010ccb,					/* U+010c8b */
	0x010ccc,					/* U+010c8c */
	0x010ccd,					/* U+010c8d */
	0x010cce,					/* U+010c8e */
	0x010ccf,					/* U+010c8f */
	0x010cd0,					/* U+010c90 */
	0x010cd1,					/* U+010c91 */
	0x010cd2,					/* U+010c92 */
	0x010cd3,					/* U+010c93 */
	0x010cd4,					/* U+010c94 */
	0x010cd5,					/* U+010c95 */
	0x010cd6,					/* U+010c96 */
	0x010cd7,					/* U+010c97 */
	0x010cd8,					/* U+010c98 */
	0x010cd9,					/* U+010c99 */
	0x010cda,					/* U+010c9a */
	0x010cdb,					/* U+010c9b */
	0x010cdc,					/* U+010c9c */
	0x010cdd,					/* U+010c9d */
	0x010cde,					/* U+010c9e */
	0x010cdf,					/* U+010c9f */
	0x010ce0,					/* U+010ca0 */
	0x010ce1,					/* U+010ca1 */
	0x010ce2,					/* U+010ca2 */
	0x010ce3,					/* U+010ca3 */
	0x010ce4,					/* U+010ca4 */
	0x010ce5,					/* U+010ca5 */
	0x010ce6,					/* U+010ca6 */
	0x010ce7,					/* U+010ca7 */
	0x010ce8,					/* U+010ca8 */
	0x010ce9,					/* U+010ca9 */
	0x010cea,					/* U+010caa */
	0x010ceb,					/* U+010cab */
	0x010cec,					/* U+010cac */
	0x010ced,					/* U+010cad */
	0x010cee,					/* U+010cae */
	0x010cef,					/* U+010caf */
	0x010cf0,					/* U+010cb0 */
	0x010cf1,					/* U+010cb1 */
	0x010cf2,					/* U+010cb2 */
	0x010d70,					/* U+010d50 */
	0x010d71,					/* U+010d51 */
	0x010d72,					/* U+010d52 */
	0x010d73,					/* U+010d53 */
	0x010d74,					/* U+010d54 */
	0x010d75,					/* U+010d55 */
	0x010d76,					/* U+010d56 */
	0x010d77,					/* U+010d57 */
	0x010d78,					/* U+010d58 */
	0x010d79,					/* U+010d59 */
	0x010d7a,					/* U+010d5a */
	0x010d7b,					/* U+010d5b */
	0x010d7c,					/* U+010d5c */
	0x010d7d,					/* U+010d5d */
	0x010d7e,					/* U+010d5e */
	0x010d7f,					/* U+010d5f */
	0x010d80,					/* U+010d60 */
	0x010d81,					/* U+010d61 */
	0x010d82,					/* U+010d62 */
	0x010d83,					/* U+010d63 */
	0x010d84,					/* U+010d64 */
	0x010d85,					/* U+010d65 */
	0x0118c0,					/* U+0118a0 */
	0x0118c1,					/* U+0118a1 */
	0x0118c2,					/* U+0118a2 */
	0x0118c3,					/* U+0118a3 */
	0x0118c4,					/* U+0118a4 */
	0x0118c5,					/* U+0118a5 */
	0x0118c6,					/* U+0118a6 */
	0x0118c7,					/* U+0118a7 */
	0x0118c8,					/* U+0118a8 */
	0x0118c9,					/* U+0118a9 */
	0x0118ca,					/* U+0118aa */
	0x0118cb,					/* U+0118ab */
	0x0118cc,					/* U+0118ac */
	0x0118cd,					/* U+0118ad */
	0x0118ce,					/* U+0118ae */
	0x0118cf,					/* U+0118af */
	0x0118d0,					/* U+0118b0 */
	0x0118d1,					/* U+0118b1 */
	0x0118d2,					/* U+0118b2 */
	0x0118d3,					/* U+0118b3 */
	0x0118d4,					/* U+0118b4 */
	0x0118d5,					/* U+0118b5 */
	0x0118d6,					/* U+0118b6 */
	0x0118d7,					/* U+0118b7 */
	0x0118d8,					/* U+0118b8 */
	0x0118d9,					/* U+0118b9 */
	0x0118da,					/* U+0118ba */
	0x0118db,					/* U+0118bb */
	0x0118dc,					/* U+0118bc */
	0x0118dd,					/* U+0118bd */
	0x0118de,					/* U+0118be */
	0x0118df,					/* U+0118bf */
	0x016e60,					/* U+016e40 */
	0x016e61,					/* U+016e41 */
	0x016e62,					/* U+016e42 */
	0x016e63,					/* U+016e43 */
	0x016e64,					/* U+016e44 */
	0x016e65,					/* U+016e45 */
	0x016e66,					/* U+016e46 */
	0x016e67,					/* U+016e47 */
	0x016e68,					/* U+016e48 */
	0x016e69,					/* U+016e49 */
	0x016e6a,					/* U+016e4a */
	0x016e6b,					/* U+016e4b */
	0x016e6c,					/* U+016e4c */
	0x016e6d,					/* U+016e4d */
	0x016e6e,					/* U+016e4e */
	0x016e6f,					/* U+016e4f */
	0x016e70,					/* U+016e50 */
	0x016e71,					/* U+016e51 */
	0x016e72,					/* U+016e52 */
	0x016e73,					/* U+016e53 */
	0x016e74,					/* U+016e54 */
	0x016e75,					/* U+016e55 */
	0x016e76,					/* U+016e56 */
	0x016e77,					/* U+016e57 */
	0x016e78,					/* U+016e58 */
	0x016e79,					/* U+016e59 */
	0x016e7a,					/* U+016e5a */
	0x016e7b,					/* U+016e5b */
	0x016e7c,					/* U+016e5c */
	0x016e7d,					/* U+016e5d */
	0x016e7e,					/* U+016e5e */
	0x016e7f,					/* U+016e5f */
	0x01e922,					/* U+01e900 */
	0x01e923,					/* U+01e901 */
	0x01e924,					/* U+01e902 */
	0x01e925,					/* U+01e903 */
	0x01e926,					/* U+01e904 */
	0x01e927,					/* U+01e905 */
	0x01e928,					/* U+01e906 */
	0x01e929,					/* U+01e907 */
	0x01e92a,					/* U+01e908 */
	0x01e92b,					/* U+01e909 */
	0x01e92c,					/* U+01e90a */
	0x01e92d,					/* U+01e90b */
	0x01e92e,					/* U+01e90c */
	0x01e92f,					/* U+01e90d */
	0x01e930,					/* U+01e90e */
	0x01e931,					/* U+01e90f */
	0x01e932,					/* U+01e910 */
	0x01e933,					/* U+01e911 */
	0x01e934,					/* U+01e912 */
	0x01e935,					/* U+01e913 */
	0x01e936,					/* U+01e914 */
	0x01e937,					/* U+01e915 */
	0x01e938,					/* U+01e916 */
	0x01e939,					/* U+01e917 */
	0x01e93a,					/* U+01e918 */
	0x01e93b,					/* U+01e919 */
	0x01e93c,					/* U+01e91a */
	0x01e93d,					/* U+01e91b */
	0x01e93e,					/* U+01e91c */
	0x01e93f,					/* U+01e91d */
	0x01e940,					/* U+01e91e */
	0x01e941,					/* U+01e91f */
	0x01e942,					/* U+01e920 */
	0x01e943,					/* U+01e921 */

};

/*
 * The entry case_map_title[case_index(codepoint)] is the mapping for the
 * given codepoint.
 */
static const pg_wchar case_map_title[1704] =
{
	0x000000,					/* reserved */
	0x000000,					/* U+000000 */
	0x000001,					/* U+000001 */
	0x000002,					/* U+000002 */
	0x000003,					/* U+000003 */
	0x000004,					/* U+000004 */
	0x000005,					/* U+000005 */
	0x000006,					/* U+000006 */
	0x000007,					/* U+000007 */
	0x000008,					/* U+000008 */
	0x000009,					/* U+000009 */
	0x00000a,					/* U+00000a */
	0x00000b,					/* U+00000b */
	0x00000c,					/* U+00000c */
	0x00000d,					/* U+00000d */
	0x00000e,					/* U+00000e */
	0x00000f,					/* U+00000f */
	0x000010,					/* U+000010 */
	0x000011,					/* U+000011 */
	0x000012,					/* U+000012 */
	0x000013,					/* U+000013 */
	0x000014,					/* U+000014 */
	0x000015,					/* U+000015 */
	0x000016,					/* U+000016 */
	0x000017,					/* U+000017 */
	0x000018,					/* U+000018 */
	0x000019,					/* U+000019 */
	0x00001a,					/* U+00001a */
	0x00001b,					/* U+00001b */
	0x00001c,					/* U+00001c */
	0x00001d,					/* U+00001d */
	0x00001e,					/* U+00001e */
	0x00001f,					/* U+00001f */
	0x000020,					/* U+000020 */
	0x000021,					/* U+000021 */
	0x000022,					/* U+000022 */
	0x000023,					/* U+000023 */
	0x000024,					/* U+000024 */
	0x000025,					/* U+000025 */
	0x000026,					/* U+000026 */
	0x000027,					/* U+000027 */
	0x000028,					/* U+000028 */
	0x000029,					/* U+000029 */
	0x00002a,					/* U+00002a */
	0x00002b,					/* U+00002b */
	0x00002c,					/* U+00002c */
	0x00002d,					/* U+00002d */
	0x00002e,					/* U+00002e */
	0x00002f,					/* U+00002f */
	0x000030,					/* U+000030 */
	0x000031,					/* U+000031 */
	0x000032,					/* U+000032 */
	0x000033,					/* U+000033 */
	0x000034,					/* U+000034 */
	0x000035,					/* U+000035 */
	0x000036,					/* U+000036 */
	0x000037,					/* U+000037 */
	0x000038,					/* U+000038 */
	0x000039,					/* U+000039 */
	0x00003a,					/* U+00003a */
	0x00003b,					/* U+00003b */
	0x00003c,					/* U+00003c */
	0x00003d,					/* U+00003d */
	0x00003e,					/* U+00003e */
	0x00003f,					/* U+00003f */
	0x000040,					/* U+000040 */
	0x000041,					/* U+000041 */
	0x000042,					/* U+000042 */
	0x000043,					/* U+000043 */
	0x000044,					/* U+000044 */
	0x000045,					/* U+000045 */
	0x000046,					/* U+000046 */
	0x000047,					/* U+000047 */
	0x000048,					/* U+000048 */
	0x000049,					/* U+000049 */
	0x00004a,					/* U+00004a */
	0x00004b,					/* U+00004b */
	0x00004c,					/* U+00004c */
	0x00004d,					/* U+00004d */
	0x00004e,					/* U+00004e */
	0x00004f,					/* U+00004f */
	0x000050,					/* U+000050 */
	0x000051,					/* U+000051 */
	0x000052,					/* U+000052 */
	0x000053,					/* U+000053 */
	0x000054,					/* U+000054 */
	0x000055,					/* U+000055 */
	0x000056,					/* U+000056 */
	0x000057,					/* U+000057 */
	0x000058,					/* U+000058 */
	0x000059,					/* U+000059 */
	0x00005a,					/* U+00005a */
	0x00005b,					/* U+00005b */
	0x00005c,					/* U+00005c */
	0x00005d,					/* U+00005d */
	0x00005e,					/* U+00005e */
	0x00005f,					/* U+00005f */
	0x000060,					/* U+000060 */
	0x000041,					/* U+000061 */
	0x000042,					/* U+000062 */
	0x000043,					/* U+000063 */
	0x000044,					/* U+000064 */
	0x000045,					/* U+000065 */
	0x000046,					/* U+000066 */
	0x000047,					/* U+000067 */
	0x000048,					/* U+000068 */
	0x000049,					/* U+000069 */
	0x00004a,					/* U+00006a */
	0x00004b,					/* U+00006b */
	0x00004c,					/* U+00006c */
	0x00004d,					/* U+00006d */
	0x00004e,					/* U+00006e */
	0x00004f,					/* U+00006f */
	0x000050,					/* U+000070 */
	0x000051,					/* U+000071 */
	0x000052,					/* U+000072 */
	0x000053,					/* U+000073 */
	0x000054,					/* U+000074 */
	0x000055,					/* U+000075 */
	0x000056,					/* U+000076 */
	0x000057,					/* U+000077 */
	0x000058,					/* U+000078 */
	0x000059,					/* U+000079 */
	0x00005a,					/* U+00007a */
	0x00007b,					/* U+00007b */
	0x00007c,					/* U+00007c */
	0x00007d,					/* U+00007d */
	0x00007e,					/* U+00007e */
	0x00007f,					/* U+00007f */
	0x00039c,					/* U+0000b5 */
	0x0000c0,					/* U+0000c0 */
	0x0000c1,					/* U+0000c1 */
	0x0000c2,					/* U+0000c2 */
	0x0000c3,					/* U+0000c3 */
	0x0000c4,					/* U+0000c4 */
	0x0000c5,					/* U+0000c5 */
	0x0000c6,					/* U+0000c6 */
	0x0000c7,					/* U+0000c7 */
	0x0000c8,					/* U+0000c8 */
	0x0000c9,					/* U+0000c9 */
	0x0000ca,					/* U+0000ca */
	0x0000cb,					/* U+0000cb */
	0x0000cc,					/* U+0000cc */
	0x0000cd,					/* U+0000cd */
	0x0000ce,					/* U+0000ce */
	0x0000cf,					/* U+0000cf */
	0x0000d0,					/* U+0000d0 */
	0x0000d1,					/* U+0000d1 */
	0x0000d2,					/* U+0000d2 */
	0x0000d3,					/* U+0000d3 */
	0x0000d4,					/* U+0000d4 */
	0x0000d5,					/* U+0000d5 */
	0x0000d6,					/* U+0000d6 */
	0x0000d8,					/* U+0000d8 */
	0x0000d9,					/* U+0000d9 */
	0x0000da,					/* U+0000da */
	0x0000db,					/* U+0000db */
	0x0000dc,					/* U+0000dc */
	0x0000dd,					/* U+0000dd */
	0x0000de,					/* U+0000de */
	0x0000df,					/* U+0000df */
	0x000178,					/* U+0000ff */
	0x000100,					/* U+000100 */
	0x000102,					/* U+000102 */
	0x000104,					/* U+000104 */
	0x000106,					/* U+000106 */
	0x000108,					/* U+000108 */
	0x00010a,					/* U+00010a */
	0x00010c,					/* U+00010c */
	0x00010e,					/* U+00010e */
	0x000110,					/* U+000110 */
	0x000112,					/* U+000112 */
	0x000114,					/* U+000114 */
	0x000116,					/* U+000116 */
	0x000118,					/* U+000118 */
	0x00011a,					/* U+00011a */
	0x00011c,					/* U+00011c */
	0x00011e,					/* U+00011e */
	0x000120,					/* U+000120 */
	0x000122,					/* U+000122 */
	0x000124,					/* U+000124 */
	0x000126,					/* U+000126 */
	0x000128,					/* U+000128 */
	0x00012a,					/* U+00012a */
	0x00012c,					/* U+00012c */
	0x00012e,					/* U+00012e */
	0x000130,					/* U+000130 */
	0x000049,					/* U+000131 */
	0x000132,					/* U+000132 */
	0x000134,					/* U+000134 */
	0x000136,					/* U+000136 */
	0x000139,					/* U+000139 */
	0x00013b,					/* U+00013b */
	0x00013d,					/* U+00013d */
	0x00013f,					/* U+00013f */
	0x000141,					/* U+000141 */
	0x000143,					/* U+000143 */
	0x000145,					/* U+000145 */
	0x000147,					/* U+000147 */
	0x000149,					/* U+000149 */
	0x00014a,					/* U+00014a */
	0x00014c,					/* U+00014c */
	0x00014e,					/* U+00014e */
	0x000150,					/* U+000150 */
	0x000152,					/* U+000152 */
	0x000154,					/* U+000154 */
	0x000156,					/* U+000156 */
	0x000158,					/* U+000158 */
	0x00015a,					/* U+00015a */
	0x00015c,					/* U+00015c */
	0x00015e,					/* U+00015e */
	0x000160,					/* U+000160 */
	0x000162,					/* U+000162 */
	0x000164,					/* U+000164 */
	0x000166,					/* U+000166 */
	0x000168,					/* U+000168 */
	0x00016a,					/* U+00016a */
	0x00016c,					/* U+00016c */
	0x00016e,					/* U+00016e */
	0x000170,					/* U+000170 */
	0x000172,					/* U+000172 */
	0x000174,					/* U+000174 */
	0x000176,					/* U+000176 */
	0x000179,					/* U+000179 */
	0x00017b,					/* U+00017b */
	0x00017d,					/* U+00017d */
	0x000053,					/* U+00017f */
	0x000243,					/* U+000180 */
	0x000181,					/* U+000181 */
	0x000182,					/* U+000182 */
	0x000184,					/* U+000184 */
	0x000186,					/* U+000186 */
	0x000187,					/* U+000187 */
	0x000189,					/* U+000189 */
	0x00018a,					/* U+00018a */
	0x00018b,					/* U+00018b */
	0x00018e,					/* U+00018e */
	0x00018f,					/* U+00018f */
	0x000190,					/* U+000190 */
	0x000191,					/* U+000191 */
	0x000193,					/* U+000193 */
	0x000194,					/* U+000194 */
	0x0001f6,					/* U+000195 */
	0x000196,					/* U+000196 */
	0x000197,					/* U+000197 */
	0x000198,					/* U+000198 */
	0x00023d,					/* U+00019a */
	0x00a7dc,					/* U+00019b */
	0x00019c,					/* U+00019c */
	0x00019d,					/* U+00019d */
	0x000220,					/* U+00019e */
	0x00019f,					/* U+00019f */
	0x0001a0,					/* U+0001a0 */
	0x0001a2,					/* U+0001a2 */
	0x0001a4,					/* U+0001a4 */
	0x0001a6,					/* U+0001a6 */
	0x0001a7,					/* U+0001a7 */
	0x0001a9,					/* U+0001a9 */
	0x0001ac,					/* U+0001ac */
	0x0001ae,					/* U+0001ae */
	0x0001af,					/* U+0001af */
	0x0001b1,					/* U+0001b1 */
	0x0001b2,					/* U+0001b2 */
	0x0001b3,					/* U+0001b3 */
	0x0001b5,					/* U+0001b5 */
	0x0001b7,					/* U+0001b7 */
	0x0001b8,					/* U+0001b8 */
	0x0001bc,					/* U+0001bc */
	0x0001f7,					/* U+0001bf */
	0x0001c5,					/* U+0001c4 */
	0x0001c8,					/* U+0001c7 */
	0x0001cb,					/* U+0001ca */
	0x0001cd,					/* U+0001cd */
	0x0001cf,					/* U+0001cf */
	0x0001d1,					/* U+0001d1 */
	0x0001d3,					/* U+0001d3 */
	0x0001d5,					/* U+0001d5 */
	0x0001d7,					/* U+0001d7 */
	0x0001d9,					/* U+0001d9 */
	0x0001db,					/* U+0001db */
	0x0001de,					/* U+0001de */
	0x0001e0,					/* U+0001e0 */
	0x0001e2,					/* U+0001e2 */
	0x0001e4,					/* U+0001e4 */
	0x0001e6,					/* U+0001e6 */
	0x0001e8,					/* U+0001e8 */
	0x0001ea,					/* U+0001ea */
	0x0001ec,					/* U+0001ec */
	0x0001ee,					/* U+0001ee */
	0x0001f0,					/* U+0001f0 */
	0x0001f2,					/* U+0001f1 */
	0x0001f4,					/* U+0001f4 */
	0x0001f8,					/* U+0001f8 */
	0x0001fa,					/* U+0001fa */
	0x0001fc,					/* U+0001fc */
	0x0001fe,					/* U+0001fe */
	0x000200,					/* U+000200 */
	0x000202,					/* U+000202 */
	0x000204,					/* U+000204 */
	0x000206,					/* U+000206 */
	0x000208,					/* U+000208 */
	0x00020a,					/* U+00020a */
	0x00020c,					/* U+00020c */
	0x00020e,					/* U+00020e */
	0x000210,					/* U+000210 */
	0x000212,					/* U+000212 */
	0x000214,					/* U+000214 */
	0x000216,					/* U+000216 */
	0x000218,					/* U+000218 */
	0x00021a,					/* U+00021a */
	0x00021c,					/* U+00021c */
	0x00021e,					/* U+00021e */
	0x000222,					/* U+000222 */
	0x000224,					/* U+000224 */
	0x000226,					/* U+000226 */
	0x000228,					/* U+000228 */
	0x00022a,					/* U+00022a */
	0x00022c,					/* U+00022c */
	0x00022e,					/* U+00022e */
	0x000230,					/* U+000230 */
	0x000232,					/* U+000232 */
	0x00023a,					/* U+00023a */
	0x00023b,					/* U+00023b */
	0x00023e,					/* U+00023e */
	0x002c7e,					/* U+00023f */
	0x002c7f,					/* U+000240 */
	0x000241,					/* U+000241 */
	0x000244,					/* U+000244 */
	0x000245,					/* U+000245 */
	0x000246,					/* U+000246 */
	0x000248,					/* U+000248 */
	0x00024a,					/* U+00024a */
	0x00024c,					/* U+00024c */
	0x00024e,					/* U+00024e */
	0x002c6f,					/* U+000250 */
	0x002c6d,					/* U+000251 */
	0x002c70,					/* U+000252 */
	0x00a7ab,					/* U+00025c */
	0x00a7ac,					/* U+000261 */
	0x00a7cb,					/* U+000264 */
	0x00a78d,					/* U+000265 */
	0x00a7aa,					/* U+000266 */
	0x00a7ae,					/* U+00026a */
	0x002c62,					/* U+00026b */
	0x00a7ad,					/* U+00026c */
	0x002c6e,					/* U+000271 */
	0x002c64,					/* U+00027d */
	0x00a7c5,					/* U+000282 */
	0x00a7b1,					/* U+000287 */
	0x00a7b2,					/* U+00029d */
	0x00a7b0,					/* U+00029e */
	0x000399,					/* U+000345 */
	0x000370,					/* U+000370 */
	0x000372,					/* U+000372 */
	0x000376,					/* U+000376 */
	0x0003fd,					/* U+00037b */
	0x0003fe,					/* U+00037c */
	0x0003ff,					/* U+00037d */
	0x00037f,					/* U+00037f */
	0x000386,					/* U+000386 */
	0x000388,					/* U+000388 */
	0x000389,					/* U+000389 */
	0x00038a,					/* U+00038a */
	0x00038c,					/* U+00038c */
	0x00038e,					/* U+00038e */
	0x00038f,					/* U+00038f */
	0x000390,					/* U+000390 */
	0x000391,					/* U+000391 */
	0x000392,					/* U+000392 */
	0x000393,					/* U+000393 */
	0x000394,					/* U+000394 */
	0x000395,					/* U+000395 */
	0x000396,					/* U+000396 */
	0x000397,					/* U+000397 */
	0x000398,					/* U+000398 */
	0x000399,					/* U+000399 */
	0x00039a,					/* U+00039a */
	0x00039b,					/* U+00039b */
	0x00039c,					/* U+00039c */
	0x00039d,					/* U+00039d */
	0x00039e,					/* U+00039e */
	0x00039f,					/* U+00039f */
	0x0003a0,					/* U+0003a0 */
	0x0003a1,					/* U+0003a1 */
	0x0003a3,					/* U+0003a3 */
	0x0003a4,					/* U+0003a4 */
	0x0003a5,					/* U+0003a5 */
	0x0003a6,					/* U+0003a6 */
	0x0003a7,					/* U+0003a7 */
	0x0003a8,					/* U+0003a8 */
	0x0003a9,					/* U+0003a9 */
	0x0003aa,					/* U+0003aa */
	0x0003ab,					/* U+0003ab */
	0x0003b0,					/* U+0003b0 */
	0x0003a3,					/* U+0003c2 */
	0x0003a3,					/* U+0003c3 */
	0x0003cf,					/* U+0003cf */
	0x000392,					/* U+0003d0 */
	0x000398,					/* U+0003d1 */
	0x0003a6,					/* U+0003d5 */
	0x0003a0,					/* U+0003d6 */
	0x0003d8,					/* U+0003d8 */
	0x0003da,					/* U+0003da */
	0x0003dc,					/* U+0003dc */
	0x0003de,					/* U+0003de */
	0x0003e0,					/* U+0003e0 */
	0x0003e2,					/* U+0003e2 */
	0x0003e4,					/* U+0003e4 */
	0x0003e6,					/* U+0003e6 */
	0x0003e8,					/* U+0003e8 */
	0x0003ea,					/* U+0003ea */
	0x0003ec,					/* U+0003ec */
	0x0003ee,					/* U+0003ee */
	0x00039a,					/* U+0003f0 */
	0x0003a1,					/* U+0003f1 */
	0x0003f9,					/* U+0003f2 */
	0x0003f4,					/* U+0003f4 */
	0x000395,					/* U+0003f5 */
	0x0003f7,					/* U+0003f7 */
	0x0003fa,					/* U+0003fa */
	0x000400,					/* U+000400 */
	0x000401,					/* U+000401 */
	0x000402,					/* U+000402 */
	0x000403,					/* U+000403 */
	0x000404,					/* U+000404 */
	0x000405,					/* U+000405 */
	0x000406,					/* U+000406 */
	0x000407,					/* U+000407 */
	0x000408,					/* U+000408 */
	0x000409,					/* U+000409 */
	0x00040a,					/* U+00040a */
	0x00040b,					/* U+00040b */
	0x00040c,					/* U+00040c */
	0x00040d,					/* U+00040d */
	0x00040e,					/* U+00040e */
	0x00040f,					/* U+00040f */
	0x000410,					/* U+000410 */
	0x000411,					/* U+000411 */
	0x000412,					/* U+000412 */
	0x000413,					/* U+000413 */
	0x000414,					/* U+000414 */
	0x000415,					/* U+000415 */
	0x000416,					/* U+000416 */
	0x000417,					/* U+000417 */
	0x000418,					/* U+000418 */
	0x000419,					/* U+000419 */
	0x00041a,					/* U+00041a */
	0x00041b,					/* U+00041b */
	0x00041c,					/* U+00041c */
	0x00041d,					/* U+00041d */
	0x00041e,					/* U+00041e */
	0x00041f,					/* U+00041f */
	0x000420,					/* U+000420 */
	0x000421,					/* U+000421 */
	0x000422,					/* U+000422 */
	0x000423,					/* U+000423 */
	0x000424,					/* U+000424 */
	0x000425,					/* U+000425 */
	0x000426,					/* U+000426 */
	0x000427,					/* U+000427 */
	0x000428,					/* U+000428 */
	0x000429,					/* U+000429 */
	0x00042a,					/* U+00042a */
	0x00042b,					/* U+00042b */
	0x00042c,					/* U+00042c */
	0x00042d,					/* U+00042d */
	0x00042e,					/* U+00042e */
	0x00042f,					/* U+00042f */
	0x000460,					/* U+000460 */
	0x000462,					/* U+000462 */
	0x000464,					/* U+000464 */
	0x000466,					/* U+000466 */
	0x000468,					/* U+000468 */
	0x00046a,					/* U+00046a */
	0x00046c,					/* U+00046c */
	0x00046e,					/* U+00046e */
	0x000470,					/* U+000470 */
	0x000472,					/* U+000472 */
	0x000474,					/* U+000474 */
	0x000476,					/* U+000476 */
	0x000478,					/* U+000478 */
	0x00047a,					/* U+00047a */
	0x00047c,					/* U+00047c */
	0x00047e,					/* U+00047e */
	0x000480,					/* U+000480 */
	0x00048a,					/* U+00048a */
	0x00048c,					/* U+00048c */
	0x00048e,					/* U+00048e */
	0x000490,					/* U+000490 */
	0x000492,					/* U+000492 */
	0x000494,					/* U+000494 */
	0x000496,					/* U+000496 */
	0x000498,					/* U+000498 */
	0x00049a,					/* U+00049a */
	0x00049c,					/* U+00049c */
	0x00049e,					/* U+00049e */
	0x0004a0,					/* U+0004a0 */
	0x0004a2,					/* U+0004a2 */
	0x0004a4,					/* U+0004a4 */
	0x0004a6,					/* U+0004a6 */
	0x0004a8,					/* U+0004a8 */
	0x0004aa,					/* U+0004aa */
	0x0004ac,					/* U+0004ac */
	0x0004ae,					/* U+0004ae */
	0x0004b0,					/* U+0004b0 */
	0x0004b2,					/* U+0004b2 */
	0x0004b4,					/* U+0004b4 */
	0x0004b6,					/* U+0004b6 */
	0x0004b8,					/* U+0004b8 */
	0x0004ba,					/* U+0004ba */
	0x0004bc,					/* U+0004bc */
	0x0004be,					/* U+0004be */
	0x0004c0,					/* U+0004c0 */
	0x0004c1,					/* U+0004c1 */
	0x0004c3,					/* U+0004c3 */
	0x0004c5,					/* U+0004c5 */
	0x0004c7,					/* U+0004c7 */
	0x0004c9,					/* U+0004c9 */
	0x0004cb,					/* U+0004cb */
	0x0004cd,					/* U+0004cd */
	0x0004d0,					/* U+0004d0 */
	0x0004d2,					/* U+0004d2 */
	0x0004d4,					/* U+0004d4 */
	0x0004d6,					/* U+0004d6 */
	0x0004d8,					/* U+0004d8 */
	0x0004da,					/* U+0004da */
	0x0004dc,					/* U+0004dc */
	0x0004de,					/* U+0004de */
	0x0004e0,					/* U+0004e0 */
	0x0004e2,					/* U+0004e2 */
	0x0004e4,					/* U+0004e4 */
	0x0004e6,					/* U+0004e6 */
	0x0004e8,					/* U+0004e8 */
	0x0004ea,					/* U+0004ea */
	0x0004ec,					/* U+0004ec */
	0x0004ee,					/* U+0004ee */
	0x0004f0,					/* U+0004f0 */
	0x0004f2,					/* U+0004f2 */
	0x0004f4,					/* U+0004f4 */
	0x0004f6,					/* U+0004f6 */
	0x0004f8,					/* U+0004f8 */
	0x0004fa,					/* U+0004fa */
	0x0004fc,					/* U+0004fc */
	0x0004fe,					/* U+0004fe */
	0x000500,					/* U+000500 */
	0x000502,					/* U+000502 */
	0x000504,					/* U+000504 */
	0x000506,					/* U+000506 */
	0x000508,					/* U+000508 */
	0x00050a,					/* U+00050a */
	0x00050c,					/* U+00050c */
	0x00050e,					/* U+00050e */
	0x000510,					/* U+000510 */
	0x000512,					/* U+000512 */
	0x000514,					/* U+000514 */
	0x000516,					/* U+000516 */
	0x000518,					/* U+000518 */
	0x00051a,					/* U+00051a */
	0x00051c,					/* U+00051c */
	0x00051e,					/* U+00051e */
	0x000520,					/* U+000520 */
	0x000522,					/* U+000522 */
	0x000524,					/* U+000524 */
	0x000526,					/* U+000526 */
	0x000528,					/* U+000528 */
	0x00052a,					/* U+00052a */
	0x00052c,					/* U+00052c */
	0x00052e,					/* U+00052e */
	0x000531,					/* U+000531 */
	0x000532,					/* U+000532 */
	0x000533,					/* U+000533 */
	0x000534,					/* U+000534 */
	0x000535,					/* U+000535 */
	0x000536,					/* U+000536 */
	0x000537,					/* U+000537 */
	0x000538,					/* U+000538 */
	0x000539,					/* U+000539 */
	0x00053a,					/* U+00053a */
	0x00053b,					/* U+00053b */
	0x00053c,					/* U+00053c */
	0x00053d,					/* U+00053d */
	0x00053e,					/* U+00053e */
	0x00053f,					/* U+00053f */
	0x000540,					/* U+000540 */
	0x000541,					/* U+000541 */
	0x000542,					/* U+000542 */
	0x000543,					/* U+000543 */
	0x000544,					/* U+000544 */
	0x000545,					/* U+000545 */
	0x000546,					/* U+000546 */
	0x000547,					/* U+000547 */
	0x000548,					/* U+000548 */
	0x000549,					/* U+000549 */
	0x00054a,					/* U+00054a */
	0x00054b,					/* U+00054b */
	0x00054c,					/* U+00054c */
	0x00054d,					/* U+00054d */
	0x00054e,					/* U+00054e */
	0x00054f,					/* U+00054f */
	0x000550,					/* U+000550 */
	0x000551,					/* U+000551 */
	0x000552,					/* U+000552 */
	0x000553,					/* U+000553 */
	0x000554,					/* U+000554 */
	0x000555,					/* U+000555 */
	0x000556,					/* U+000556 */
	0x000587,					/* U+000587 */
	0x0010a0,					/* U+0010a0 */
	0x0010a1,					/* U+0010a1 */
	0x0010a2,					/* U+0010a2 */
	0x0010a3,					/* U+0010a3 */
	0x0010a4,					/* U+0010a4 */
	0x0010a5,					/* U+0010a5 */
	0x0010a6,					/* U+0010a6 */
	0x0010a7,					/* U+0010a7 */
	0x0010a8,					/* U+0010a8 */
	0x0010a9,					/* U+0010a9 */
	0x0010aa,					/* U+0010aa */
	0x0010ab,					/* U+0010ab */
	0x0010ac,					/* U+0010ac */
	0x0010ad,					/* U+0010ad */
	0x0010ae,					/* U+0010ae */
	0x0010af,					/* U+0010af */
	0x0010b0,					/* U+0010b0 */
	0x0010b1,					/* U+0010b1 */
	0x0010b2,					/* U+0010b2 */
	0x0010b3,					/* U+0010b3 */
	0x0010b4,					/* U+0010b4 */
	0x0010b5,					/* U+0010b5 */
	0x0010b6,					/* U+0010b6 */
	0x0010b7,					/* U+0010b7 */
	0x0010b8,					/* U+0010b8 */
	0x0010b9,					/* U+0010b9 */
	0x0010ba,					/* U+0010ba */
	0x0010bb,					/* U+0010bb */
	0x0010bc,					/* U+0010bc */
	0x0010bd,					/* U+0010bd */
	0x0010be,					/* U+0010be */
	0x0010bf,					/* U+0010bf */
	0x0010c0,					/* U+0010c0 */
	0x0010c1,					/* U+0010c1 */
	0x0010c2,					/* U+0010c2 */
	0x0010c3,					/* U+0010c3 */
	0x0010c4,					/* U+0010c4 */
	0x0010c5,					/* U+0010c5 */
	0x0010c7,					/* U+0010c7 */
	0x0010cd,					/* U+0010cd */
	0x0010d0,					/* U+0010d0 */
	0x0010d1,					/* U+0010d1 */
	0x0010d2,					/* U+0010d2 */
	0x0010d3,					/* U+0010d3 */
	0x0010d4,					/* U+0010d4 */
	0x0010d5,					/* U+0010d5 */
	0x0010d6,					/* U+0010d6 */
	0x0010d7,					/* U+0010d7 */
	0x0010d8,					/* U+0010d8 */
	0x0010d9,					/* U+0010d9 */
	0x0010da,					/* U+0010da */
	0x0010db,					/* U+0010db */
	0x0010dc,					/* U+0010dc */
	0x0010dd,					/* U+0010dd */
	0x0010de,					/* U+0010de */
	0x0010df,					/* U+0010df */
	0x0010e0,					/* U+0010e0 */
	0x0010e1,					/* U+0010e1 */
	0x0010e2,					/* U+0010e2 */
	0x0010e3,					/* U+0010e3 */
	0x0010e4,					/* U+0010e4 */
	0x0010e5,					/* U+0010e5 */
	0x0010e6,					/* U+0010e6 */
	0x0010e7,					/* U+0010e7 */
	0x0010e8,					/* U+0010e8 */
	0x0010e9,					/* U+0010e9 */
	0x0010ea,					/* U+0010ea */
	0x0010eb,					/* U+0010eb */
	0x0010ec,					/* U+0010ec */
	0x0010ed,					/* U+0010ed */
	0x0010ee,					/* U+0010ee */
	0x0010ef,					/* U+0010ef */
	0x0010f0,					/* U+0010f0 */
	0x0010f1,					/* U+0010f1 */
	0x0010f2,					/* U+0010f2 */
	0x0010f3,					/* U+0010f3 */
	0x0010f4,					/* U+0010f4 */
	0x0010f5,					/* U+0010f5 */
	0x0010f6,					/* U+0010f6 */
	0x0010f7,					/* U+0010f7 */
	0x0010f8,					/* U+0010f8 */
	0x0010f9,					/* U+0010f9 */
	0x0010fa,					/* U+0010fa */
	0x0010fd,					/* U+0010fd */
	0x0010fe,					/* U+0010fe */
	0x0010ff,					/* U+0010ff */
	0x0013a0,					/* U+0013a0 */
	0x0013a1,					/* U+0013a1 */
	0x0013a2,					/* U+0013a2 */
	0x0013a3,					/* U+0013a3 */
	0x0013a4,					/* U+0013a4 */
	0x0013a5,					/* U+0013a5 */
	0x0013a6,					/* U+0013a6 */
	0x0013a7,					/* U+0013a7 */
	0x0013a8,					/* U+0013a8 */
	0x0013a9,					/* U+0013a9 */
	0x0013aa,					/* U+0013aa */
	0x0013ab,					/* U+0013ab */
	0x0013ac,					/* U+0013ac */
	0x0013ad,					/* U+0013ad */
	0x0013ae,					/* U+0013ae */
	0x0013af,					/* U+0013af */
	0x0013b0,					/* U+0013b0 */
	0x0013b1,					/* U+0013b1 */
	0x0013b2,					/* U+0013b2 */
	0x0013b3,					/* U+0013b3 */
	0x0013b4,					/* U+0013b4 */
	0x0013b5,					/* U+0013b5 */
	0x0013b6,					/* U+0013b6 */
	0x0013b7,					/* U+0013b7 */
	0x0013b8,					/* U+0013b8 */
	0x0013b9,					/* U+0013b9 */
	0x0013ba,					/* U+0013ba */
	0x0013bb,					/* U+0013bb */
	0x0013bc,					/* U+0013bc */
	0x0013bd,					/* U+0013bd */
	0x0013be,					/* U+0013be */
	0x0013bf,					/* U+0013bf */
	0x0013c0,					/* U+0013c0 */
	0x0013c1,					/* U+0013c1 */
	0x0013c2,					/* U+0013c2 */
	0x0013c3,					/* U+0013c3 */
	0x0013c4,					/* U+0013c4 */
	0x0013c5,					/* U+0013c5 */
	0x0013c6,					/* U+0013c6 */
	0x0013c7,					/* U+0013c7 */
	0x0013c8,					/* U+0013c8 */
	0x0013c9,					/* U+0013c9 */
	0x0013ca,					/* U+0013ca */
	0x0013cb,					/* U+0013cb */
	0x0013cc,					/* U+0013cc */
	0x0013cd,					/* U+0013cd */
	0x0013ce,					/* U+0013ce */
	0x0013cf,					/* U+0013cf */
	0x0013d0,					/* U+0013d0 */
	0x0013d1,					/* U+0013d1 */
	0x0013d2,					/* U+0013d2 */
	0x0013d3,					/* U+0013d3 */
	0x0013d4,					/* U+0013d4 */
	0x0013d5,					/* U+0013d5 */
	0x0013d6,					/* U+0013d6 */
	0x0013d7,					/* U+0013d7 */
	0x0013d8,					/* U+0013d8 */
	0x0013d9,					/* U+0013d9 */
	0x0013da,					/* U+0013da */
	0x0013db,					/* U+0013db */
	0x0013dc,					/* U+0013dc */
	0x0013dd,					/* U+0013dd */
	0x0013de,					/* U+0013de */
	0x0013df,					/* U+0013df */
	0x0013e0,					/* U+0013e0 */
	0x0013e1,					/* U+0013e1 */
	0x0013e2,					/* U+0013e2 */
	0x0013e3,					/* U+0013e3 */
	0x0013e4,					/* U+0013e4 */
	0x0013e5,					/* U+0013e5 */
	0x0013e6,					/* U+0013e6 */
	0x0013e7,					/* U+0013e7 */
	0x0013e8,					/* U+0013e8 */
	0x0013e9,					/* U+0013e9 */
	0x0013ea,					/* U+0013ea */
	0x0013eb,					/* U+0013eb */
	0x0013ec,					/* U+0013ec */
	0x0013ed,					/* U+0013ed */
	0x0013ee,					/* U+0013ee */
	0x0013ef,					/* U+0013ef */
	0x0013f0,					/* U+0013f0 */
	0x0013f1,					/* U+0013f1 */
	0x0013f2,					/* U+0013f2 */
	0x0013f3,					/* U+0013f3 */
	0x0013f4,					/* U+0013f4 */
	0x0013f5,					/* U+0013f5 */
	0x000412,					/* U+001c80 */
	0x000414,					/* U+001c81 */
	0x00041e,					/* U+001c82 */
	0x000421,					/* U+001c83 */
	0x000422,					/* U+001c84 */
	0x000422,					/* U+001c85 */
	0x00042a,					/* U+001c86 */
	0x000462,					/* U+001c87 */
	0x00a64a,					/* U+001c88 */
	0x001c89,					/* U+001c89 */
	0x001c90,					/* U+001c90 */
	0x001c91,					/* U+001c91 */
	0x001c92,					/* U+001c92 */
	0x001c93,					/* U+001c93 */
	0x001c94,					/* U+001c94 */
	0x001c95,					/* U+001c95 */
	0x001c96,					/* U+001c96 */
	0x001c97,					/* U+001c97 */
	0x001c98,					/* U+001c98 */
	0x001c99,					/* U+001c99 */
	0x001c9a,					/* U+001c9a */
	0x001c9b,					/* U+001c9b */
	0x001c9c,					/* U+001c9c */
	0x001c9d,					/* U+001c9d */
	0x001c9e,					/* U+001c9e */
	0x001c9f,					/* U+001c9f */
	0x001ca0,					/* U+001ca0 */
	0x001ca1,					/* U+001ca1 */
	0x001ca2,					/* U+001ca2 */
	0x001ca3,					/* U+001ca3 */
	0x001ca4,					/* U+001ca4 */
	0x001ca5,					/* U+001ca5 */
	0x001ca6,					/* U+001ca6 */
	0x001ca7,					/* U+001ca7 */
	0x001ca8,					/* U+001ca8 */
	0x001ca9,					/* U+001ca9 */
	0x001caa,					/* U+001caa */
	0x001cab,					/* U+001cab */
	0x001cac,					/* U+001cac */
	0x001cad,					/* U+001cad */
	0x001cae,					/* U+001cae */
	0x001caf,					/* U+001caf */
	0x001cb0,					/* U+001cb0 */
	0x001cb1,					/* U+001cb1 */
	0x001cb2,					/* U+001cb2 */
	0x001cb3,					/* U+001cb3 */
	0x001cb4,					/* U+001cb4 */
	0x001cb5,					/* U+001cb5 */
	0x001cb6,					/* U+001cb6 */
	0x001cb7,					/* U+001cb7 */
	0x001cb8,					/* U+001cb8 */
	0x001cb9,					/* U+001cb9 */
	0x001cba,					/* U+001cba */
	0x001cbd,					/* U+001cbd */
	0x001cbe,					/* U+001cbe */
	0x001cbf,					/* U+001cbf */
	0x00a77d,					/* U+001d79 */
	0x002c63,					/* U+001d7d */
	0x00a7c6,					/* U+001d8e */
	0x001e00,					/* U+001e00 */
	0x001e02,					/* U+001e02 */
	0x001e04,					/* U+001e04 */
	0x001e06,					/* U+001e06 */
	0x001e08,					/* U+001e08 */
	0x001e0a,					/* U+001e0a */
	0x001e0c,					/* U+001e0c */
	0x001e0e,					/* U+001e0e */
	0x001e10,					/* U+001e10 */
	0x001e12,					/* U+001e12 */
	0x001e14,					/* U+001e14 */
	0x001e16,					/* U+001e16 */
	0x001e18,					/* U+001e18 */
	0x001e1a,					/* U+001e1a */
	0x001e1c,					/* U+001e1c */
	0x001e1e,					/* U+001e1e */
	0x001e20,					/* U+001e20 */
	0x001e22,					/* U+001e22 */
	0x001e24,					/* U+001e24 */
	0x001e26,					/* U+001e26 */
	0x001e28,					/* U+001e28 */
	0x001e2a,					/* U+001e2a */
	0x001e2c,					/* U+001e2c */
	0x001e2e,					/* U+001e2e */
	0x001e30,					/* U+001e30 */
	0x001e32,					/* U+001e32 */
	0x001e34,					/* U+001e34 */
	0x001e36,					/* U+001e36 */
	0x001e38,					/* U+001e38 */
	0x001e3a,					/* U+001e3a */
	0x001e3c,					/* U+001e3c */
	0x001e3e,					/* U+001e3e */
	0x001e40,					/* U+001e40 */
	0x001e42,					/* U+001e42 */
	0x001e44,					/* U+001e44 */
	0x001e46,					/* U+001e46 */
	0x001e48,					/* U+001e48 */
	0x001e4a,					/* U+001e4a */
	0x001e4c,					/* U+001e4c */
	0x001e4e,					/* U+001e4e */
	0x001e50,					/* U+001e50 */
	0x001e52,					/* U+001e52 */
	0x001e54,					/* U+001e54 */
	0x001e56,					/* U+001e56 */
	0x001e58,					/* U+001e58 */
	0x001e5a,					/* U+001e5a */
	0x001e5c,					/* U+001e5c */
	0x001e5e,					/* U+001e5e */
	0x001e60,					/* U+001e60 */
	0x001e62,					/* U+001e62 */
	0x001e64,					/* U+001e64 */
	0x001e66,					/* U+001e66 */
	0x001e68,					/* U+001e68 */
	0x001e6a,					/* U+001e6a */
	0x001e6c,					/* U+001e6c */
	0x001e6e,					/* U+001e6e */
	0x001e70,					/* U+001e70 */
	0x001e72,					/* U+001e72 */
	0x001e74,					/* U+001e74 */
	0x001e76,					/* U+001e76 */
	0x001e78,					/* U+001e78 */
	0x001e7a,					/* U+001e7a */
	0x001e7c,					/* U+001e7c */
	0x001e7e,					/* U+001e7e */
	0x001e80,					/* U+001e80 */
	0x001e82,					/* U+001e82 */
	0x001e84,					/* U+001e84 */
	0x001e86,					/* U+001e86 */
	0x001e88,					/* U+001e88 */
	0x001e8a,					/* U+001e8a */
	0x001e8c,					/* U+001e8c */
	0x001e8e,					/* U+001e8e */
	0x001e90,					/* U+001e90 */
	0x001e92,					/* U+001e92 */
	0x001e94,					/* U+001e94 */
	0x001e96,					/* U+001e96 */
	0x001e97,					/* U+001e97 */
	0x001e98,					/* U+001e98 */
	0x001e99,					/* U+001e99 */
	0x001e9a,					/* U+001e9a */
	0x001e60,					/* U+001e9b */
	0x001e9e,					/* U+001e9e */
	0x001ea0,					/* U+001ea0 */
	0x001ea2,					/* U+001ea2 */
	0x001ea4,					/* U+001ea4 */
	0x001ea6,					/* U+001ea6 */
	0x001ea8,					/* U+001ea8 */
	0x001eaa,					/* U+001eaa */
	0x001eac,					/* U+001eac */
	0x001eae,					/* U+001eae */
	0x001eb0,					/* U+001eb0 */
	0x001eb2,					/* U+001eb2 */
	0x001eb4,					/* U+001eb4 */
	0x001eb6,					/* U+001eb6 */
	0x001eb8,					/* U+001eb8 */
	0x001eba,					/* U+001eba */
	0x001ebc,					/* U+001ebc */
	0x001ebe,					/* U+001ebe */
	0x001ec0,					/* U+001ec0 */
	0x001ec2,					/* U+001ec2 */
	0x001ec4,					/* U+001ec4 */
	0x001ec6,					/* U+001ec6 */
	0x001ec8,					/* U+001ec8 */
	0x001eca,					/* U+001eca */
	0x001ecc,					/* U+001ecc */
	0x001ece,					/* U+001ece */
	0x001ed0,					/* U+001ed0 */
	0x001ed2,					/* U+001ed2 */
	0x001ed4,					/* U+001ed4 */
	0x001ed6,					/* U+001ed6 */
	0x001ed8,					/* U+001ed8 */
	0x001eda,					/* U+001eda */
	0x001edc,					/* U+001edc */
	0x001ede,					/* U+001ede */
	0x001ee0,					/* U+001ee0 */
	0x001ee2,					/* U+001ee2 */
	0x001ee4,					/* U+001ee4 */
	0x001ee6,					/* U+001ee6 */
	0x001ee8,					/* U+001ee8 */
	0x001eea,					/* U+001eea */
	0x001eec,					/* U+001eec */
	0x001eee,					/* U+001eee */
	0x001ef0,					/* U+001ef0 */
	0x001ef2,					/* U+001ef2 */
	0x001ef4,					/* U+001ef4 */
	0x001ef6,					/* U+001ef6 */
	0x001ef8,					/* U+001ef8 */
	0x001efa,					/* U+001efa */
	0x001efc,					/* U+001efc */
	0x001efe,					/* U+001efe */
	0x001f08,					/* U+001f00 */
	0x001f09,					/* U+001f01 */
	0x001f0a,					/* U+001f02 */
	0x001f0b,					/* U+001f03 */
	0x001f0c,					/* U+001f04 */
	0x001f0d,					/* U+001f05 */
	0x001f0e,					/* U+001f06 */
	0x001f0f,					/* U+001f07 */
	0x001f18,					/* U+001f10 */
	0x001f19,					/* U+001f11 */
	0x001f1a,					/* U+001f12 */
	0x001f1b,					/* U+001f13 */
	0x001f1c,					/* U+001f14 */
	0x001f1d,					/* U+001f15 */
	0x001f28,					/* U+001f20 */
	0x001f29,					/* U+001f21 */
	0x001f2a,					/* U+001f22 */
	0x001f2b,					/* U+001f23 */
	0x001f2c,					/* U+001f24 */
	0x001f2d,					/* U+001f25 */
	0x001f2e,					/* U+001f26 */
	0x001f2f,					/* U+001f27 */
	0x001f38,					/* U+001f30 */
	0x001f39,					/* U+001f31 */
	0x001f3a,					/* U+001f32 */
	0x001f3b,					/* U+001f33 */
	0x001f3c,					/* U+001f34 */
	0x001f3d,					/* U+001f35 */
	0x001f3e,					/* U+001f36 */
	0x001f3f,					/* U+001f37 */
	0x001f48,					/* U+001f40 */
	0x001f49,					/* U+001f41 */
	0x001f4a,					/* U+001f42 */
	0x001f4b,					/* U+001f43 */
	0x001f4c,					/* U+001f44 */
	0x001f4d,					/* U+001f45 */
	0x001f50,					/* U+001f50 */
	0x001f59,					/* U+001f51 */
	0x001f52,					/* U+001f52 */
	0x001f5b,					/* U+001f53 */
	0x001f54,					/* U+001f54 */
	0x001f5d,					/* U+001f55 */
	0x001f56,					/* U+001f56 */
	0x001f5f,					/* U+001f57 */
	0x001f68,					/* U+001f60 */
	0x001f69,					/* U+001f61 */
	0x001f6a,					/* U+001f62 */
	0x001f6b,					/* U+001f63 */
	0x001f6c,					/* U+001f64 */
	0x001f6d,					/* U+001f65 */
	0x001f6e,					/* U+001f66 */
	0x001f6f,					/* U+001f67 */
	0x001fba,					/* U+001f70 */
	0x001fbb,					/* U+001f71 */
	0x001fc8,					/* U+001f72 */
	0x001fc9,					/* U+001f73 */
	0x001fca,					/* U+001f74 */
	0x001fcb,					/* U+001f75 */
	0x001fda,					/* U+001f76 */
	0x001fdb,					/* U+001f77 */
	0x001ff8,					/* U+001f78 */
	0x001ff9,					/* U+001f79 */
	0x001fea,					/* U+001f7a */
	0x001feb,					/* U+001f7b */
	0x001ffa,					/* U+001f7c */
	0x001ffb,					/* U+001f7d */
	0x001f88,					/* U+001f80 */
	0x001f89,					/* U+001f81 */
	0x001f8a,					/* U+001f82 */
	0x001f8b,					/* U+001f83 */
	0x001f8c,					/* U+001f84 */
	0x001f8d,					/* U+001f85 */
	0x001f8e,					/* U+001f86 */
	0x001f8f,					/* U+001f87 */
	0x001f88,					/* U+001f88 */
	0x001f89,					/* U+001f89 */
	0x001f8a,					/* U+001f8a */
	0x001f8b,					/* U+001f8b */
	0x001f8c,					/* U+001f8c */
	0x001f8d,					/* U+001f8d */
	0x001f8e,					/* U+001f8e */
	0x001f8f,					/* U+001f8f */
	0x001f98,					/* U+001f90 */
	0x001f99,					/* U+001f91 */
	0x001f9a,					/* U+001f92 */
	0x001f9b,					/* U+001f93 */
	0x001f9c,					/* U+001f94 */
	0x001f9d,					/* U+001f95 */
	0x001f9e,					/* U+001f96 */
	0x001f9f,					/* U+001f97 */
	0x001f98,					/* U+001f98 */
	0x001f99,					/* U+001f99 */
	0x001f9a,					/* U+001f9a */
	0x001f9b,					/* U+001f9b */
	0x001f9c,					/* U+001f9c */
	0x001f9d,					/* U+001f9d */
	0x001f9e,					/* U+001f9e */
	0x001f9f,					/* U+001f9f */
	0x001fa8,					/* U+001fa0 */
	0x001fa9,					/* U+001fa1 */
	0x001faa,					/* U+001fa2 */
	0x001fab,					/* U+001fa3 */
	0x001fac,					/* U+001fa4 */
	0x001fad,					/* U+001fa5 */
	0x001fae,					/* U+001fa6 */
	0x001faf,					/* U+001fa7 */
	0x001fa8,					/* U+001fa8 */
	0x001fa9,					/* U+001fa9 */
	0x001faa,					/* U+001faa */
	0x001fab,					/* U+001fab */
	0x001fac,					/* U+001fac */
	0x001fad,					/* U+001fad */
	0x001fae,					/* U+001fae */
	0x001faf,					/* U+001faf */
	0x001fb8,					/* U+001fb0 */
	0x001fb9,					/* U+001fb1 */
	0x001fb2,					/* U+001fb2 */
	0x001fbc,					/* U+001fb3 */
	0x001fb4,					/* U+001fb4 */
	0x001fb6,					/* U+001fb6 */
	0x001fb7,					/* U+001fb7 */
	0x001fbc,					/* U+001fbc */
	0x000399,					/* U+001fbe */
	0x001fc2,					/* U+001fc2 */
	0x001fcc,					/* U+001fc3 */
	0x001fc4,					/* U+001fc4 */
	0x001fc6,					/* U+001fc6 */
	0x001fc7,					/* U+001fc7 */
	0x001fcc,					/* U+001fcc */
	0x001fd8,					/* U+001fd0 */
	0x001fd9,					/* U+001fd1 */
	0x001fd2,					/* U+001fd2 */
	0x001fd3,					/* U+001fd3 */
	0x001fd6,					/* U+001fd6 */
	0x001fd7,					/* U+001fd7 */
	0x001fe8,					/* U+001fe0 */
	0x001fe9,					/* U+001fe1 */
	0x001fe2,					/* U+001fe2 */
	0x001fe3,					/* U+001fe3 */
	0x001fe4,					/* U+001fe4 */
	0x001fec,					/* U+001fe5 */
	0x001fe6,					/* U+001fe6 */
	0x001fe7,					/* U+001fe7 */
	0x001ff2,					/* U+001ff2 */
	0x001ffc,					/* U+001ff3 */
	0x001ff4,					/* U+001ff4 */
	0x001ff6,					/* U+001ff6 */
	0x001ff7,					/* U+001ff7 */
	0x001ffc,					/* U+001ffc */
	0x002126,					/* U+002126 */
	0x00212a,					/* U+00212a */
	0x00212b,					/* U+00212b */
	0x002132,					/* U+002132 */
	0x002160,					/* U+002160 */
	0x002161,					/* U+002161 */
	0x002162,					/* U+002162 */
	0x002163,					/* U+002163 */
	0x002164,					/* U+002164 */
	0x002165,					/* U+002165 */
	0x002166,					/* U+002166 */
	0x002167,					/* U+002167 */
	0x002168,					/* U+002168 */
	0x002169,					/* U+002169 */
	0x00216a,					/* U+00216a */
	0x00216b,					/* U+00216b */
	0x00216c,					/* U+00216c */
	0x00216d,					/* U+00216d */
	0x00216e,					/* U+00216e */
	0x00216f,					/* U+00216f */
	0x002183,					/* U+002183 */
	0x0024b6,					/* U+0024b6 */
	0x0024b7,					/* U+0024b7 */
	0x0024b8,					/* U+0024b8 */
	0x0024b9,					/* U+0024b9 */
	0x0024ba,					/* U+0024ba */
	0x0024bb,					/* U+0024bb */
	0x0024bc,					/* U+0024bc */
	0x0024bd,					/* U+0024bd */
	0x0024be,					/* U+0024be */
	0x0024bf,					/* U+0024bf */
	0x0024c0,					/* U+0024c0 */
	0x0024c1,					/* U+0024c1 */
	0x0024c2,					/* U+0024c2 */
	0x0024c3,					/* U+0024c3 */
	0x0024c4,					/* U+0024c4 */
	0x0024c5,					/* U+0024c5 */
	0x0024c6,					/* U+0024c6 */
	0x0024c7,					/* U+0024c7 */
	0x0024c8,					/* U+0024c8 */
	0x0024c9,					/* U+0024c9 */
	0x0024ca,					/* U+0024ca */
	0x0024cb,					/* U+0024cb */
	0x0024cc,					/* U+0024cc */
	0x0024cd,					/* U+0024cd */
	0x0024ce,					/* U+0024ce */
	0x0024cf,					/* U+0024cf */
	0x002c00,					/* U+002c00 */
	0x002c01,					/* U+002c01 */
	0x002c02,					/* U+002c02 */
	0x002c03,					/* U+002c03 */
	0x002c04,					/* U+002c04 */
	0x002c05,					/* U+002c05 */
	0x002c06,					/* U+002c06 */
	0x002c07,					/* U+002c07 */
	0x002c08,					/* U+002c08 */
	0x002c09,					/* U+002c09 */
	0x002c0a,					/* U+002c0a */
	0x002c0b,					/* U+002c0b */
	0x002c0c,					/* U+002c0c */
	0x002c0d,					/* U+002c0d */
	0x002c0e,					/* U+002c0e */
	0x002c0f,					/* U+002c0f */
	0x002c10,					/* U+002c10 */
	0x002c11,					/* U+002c11 */
	0x002c12,					/* U+002c12 */
	0x002c13,					/* U+002c13 */
	0x002c14,					/* U+002c14 */
	0x002c15,					/* U+002c15 */
	0x002c16,					/* U+002c16 */
	0x002c17,					/* U+002c17 */
	0x002c18,					/* U+002c18 */
	0x002c19,					/* U+002c19 */
	0x002c1a,					/* U+002c1a */
	0x002c1b,					/* U+002c1b */
	0x002c1c,					/* U+002c1c */
	0x002c1d,					/* U+002c1d */
	0x002c1e,					/* U+002c1e */
	0x002c1f,					/* U+002c1f */
	0x002c20,					/* U+002c20 */
	0x002c21,					/* U+002c21 */
	0x002c22,					/* U+002c22 */
	0x002c23,					/* U+002c23 */
	0x002c24,					/* U+002c24 */
	0x002c25,					/* U+002c25 */
	0x002c26,					/* U+002c26 */
	0x002c27,					/* U+002c27 */
	0x002c28,					/* U+002c28 */
	0x002c29,					/* U+002c29 */
	0x002c2a,					/* U+002c2a */
	0x002c2b,					/* U+002c2b */
	0x002c2c,					/* U+002c2c */
	0x002c2d,					/* U+002c2d */
	0x002c2e,					/* U+002c2e */
	0x002c2f,					/* U+002c2f */
	0x002c60,					/* U+002c60 */
	0x002c67,					/* U+002c67 */
	0x002c69,					/* U+002c69 */
	0x002c6b,					/* U+002c6b */
	0x002c72,					/* U+002c72 */
	0x002c75,					/* U+002c75 */
	0x002c80,					/* U+002c80 */
	0x002c82,					/* U+002c82 */
	0x002c84,					/* U+002c84 */
	0x002c86,					/* U+002c86 */
	0x002c88,					/* U+002c88 */
	0x002c8a,					/* U+002c8a */
	0x002c8c,					/* U+002c8c */
	0x002c8e,					/* U+002c8e */
	0x002c90,					/* U+002c90 */
	0x002c92,					/* U+002c92 */
	0x002c94,					/* U+002c94 */
	0x002c96,					/* U+002c96 */
	0x002c98,					/* U+002c98 */
	0x002c9a,					/* U+002c9a */
	0x002c9c,					/* U+002c9c */
	0x002c9e,					/* U+002c9e */
	0x002ca0,					/* U+002ca0 */
	0x002ca2,					/* U+002ca2 */
	0x002ca4,					/* U+002ca4 */
	0x002ca6,					/* U+002ca6 */
	0x002ca8,					/* U+002ca8 */
	0x002caa,					/* U+002caa */
	0x002cac,					/* U+002cac */
	0x002cae,					/* U+002cae */
	0x002cb0,					/* U+002cb0 */
	0x002cb2,					/* U+002cb2 */
	0x002cb4,					/* U+002cb4 */
	0x002cb6,					/* U+002cb6 */
	0x002cb8,					/* U+002cb8 */
	0x002cba,					/* U+002cba */
	0x002cbc,					/* U+002cbc */
	0x002cbe,					/* U+002cbe */
	0x002cc0,					/* U+002cc0 */
	0x002cc2,					/* U+002cc2 */
	0x002cc4,					/* U+002cc4 */
	0x002cc6,					/* U+002cc6 */
	0x002cc8,					/* U+002cc8 */
	0x002cca,					/* U+002cca */
	0x002ccc,					/* U+002ccc */
	0x002cce,					/* U+002cce */
	0x002cd0,					/* U+002cd0 */
	0x002cd2,					/* U+002cd2 */
	0x002cd4,					/* U+002cd4 */
	0x002cd6,					/* U+002cd6 */
	0x002cd8,					/* U+002cd8 */
	0x002cda,					/* U+002cda */
	0x002cdc,					/* U+002cdc */
	0x002cde,					/* U+002cde */
	0x002ce0,					/* U+002ce0 */
	0x002ce2,					/* U+002ce2 */
	0x002ceb,					/* U+002ceb */
	0x002ced,					/* U+002ced */
	0x002cf2,					/* U+002cf2 */
	0x00a640,					/* U+00a640 */
	0x00a642,					/* U+00a642 */
	0x00a644,					/* U+00a644 */
	0x00a646,					/* U+00a646 */
	0x00a648,					/* U+00a648 */
	0x00a64a,					/* U+00a64a */
	0x00a64c,					/* U+00a64c */
	0x00a64e,					/* U+00a64e */
	0x00a650,					/* U+00a650 */
	0x00a652,					/* U+00a652 */
	0x00a654,					/* U+00a654 */
	0x00a656,					/* U+00a656 */
	0x00a658,					/* U+00a658 */
	0x00a65a,					/* U+00a65a */
	0x00a65c,					/* U+00a65c */
	0x00a65e,					/* U+00a65e */
	0x00a660,					/* U+00a660 */
	0x00a662,					/* U+00a662 */
	0x00a664,					/* U+00a664 */
	0x00a666,					/* U+00a666 */
	0x00a668,					/* U+00a668 */
	0x00a66a,					/* U+00a66a */
	0x00a66c,					/* U+00a66c */
	0x00a680,					/* U+00a680 */
	0x00a682,					/* U+00a682 */
	0x00a684,					/* U+00a684 */
	0x00a686,					/* U+00a686 */
	0x00a688,					/* U+00a688 */
	0x00a68a,					/* U+00a68a */
	0x00a68c,					/* U+00a68c */
	0x00a68e,					/* U+00a68e */
	0x00a690,					/* U+00a690 */
	0x00a692,					/* U+00a692 */
	0x00a694,					/* U+00a694 */
	0x00a696,					/* U+00a696 */
	0x00a698,					/* U+00a698 */
	0x00a69a,					/* U+00a69a */
	0x00a722,					/* U+00a722 */
	0x00a724,					/* U+00a724 */
	0x00a726,					/* U+00a726 */
	0x00a728,					/* U+00a728 */
	0x00a72a,					/* U+00a72a */
	0x00a72c,					/* U+00a72c */
	0x00a72e,					/* U+00a72e */
	0x00a732,					/* U+00a732 */
	0x00a734,					/* U+00a734 */
	0x00a736,					/* U+00a736 */
	0x00a738,					/* U+00a738 */
	0x00a73a,					/* U+00a73a */
	0x00a73c,					/* U+00a73c */
	0x00a73e,					/* U+00a73e */
	0x00a740,					/* U+00a740 */
	0x00a742,					/* U+00a742 */
	0x00a744,					/* U+00a744 */
	0x00a746,					/* U+00a746 */
	0x00a748,					/* U+00a748 */
	0x00a74a,					/* U+00a74a */
	0x00a74c,					/* U+00a74c */
	0x00a74e,					/* U+00a74e */
	0x00a750,					/* U+00a750 */
	0x00a752,					/* U+00a752 */
	0x00a754,					/* U+00a754 */
	0x00a756,					/* U+00a756 */
	0x00a758,					/* U+00a758 */
	0x00a75a,					/* U+00a75a */
	0x00a75c,					/* U+00a75c */
	0x00a75e,					/* U+00a75e */
	0x00a760,					/* U+00a760 */
	0x00a762,					/* U+00a762 */
	0x00a764,					/* U+00a764 */
	0x00a766,					/* U+00a766 */
	0x00a768,					/* U+00a768 */
	0x00a76a,					/* U+00a76a */
	0x00a76c,					/* U+00a76c */
	0x00a76e,					/* U+00a76e */
	0x00a779,					/* U+00a779 */
	0x00a77b,					/* U+00a77b */
	0x00a77e,					/* U+00a77e */
	0x00a780,					/* U+00a780 */
	0x00a782,					/* U+00a782 */
	0x00a784,					/* U+00a784 */
	0x00a786,					/* U+00a786 */
	0x00a78b,					/* U+00a78b */
	0x00a790,					/* U+00a790 */
	0x00a792,					/* U+00a792 */
	0x00a7c4,					/* U+00a794 */
	0x00a796,					/* U+00a796 */
	0x00a798,					/* U+00a798 */
	0x00a79a,					/* U+00a79a */
	0x00a79c,					/* U+00a79c */
	0x00a79e,					/* U+00a79e */
	0x00a7a0,					/* U+00a7a0 */
	0x00a7a2,					/* U+00a7a2 */
	0x00a7a4,					/* U+00a7a4 */
	0x00a7a6,					/* U+00a7a6 */
	0x00a7a8,					/* U+00a7a8 */
	0x00a7b3,					/* U+00a7b3 */
	0x00a7b4,					/* U+00a7b4 */
	0x00a7b6,					/* U+00a7b6 */
	0x00a7b8,					/* U+00a7b8 */
	0x00a7ba,					/* U+00a7ba */
	0x00a7bc,					/* U+00a7bc */
	0x00a7be,					/* U+00a7be */
	0x00a7c0,					/* U+00a7c0 */
	0x00a7c2,					/* U+00a7c2 */
	0x00a7c7,					/* U+00a7c7 */
	0x00a7c9,					/* U+00a7c9 */
	0x00a7cc,					/* U+00a7cc */
	0x00a7d0,					/* U+00a7d0 */
	0x00a7d6,					/* U+00a7d6 */
	0x00a7d8,					/* U+00a7d8 */
	0x00a7da,					/* U+00a7da */
	0x00a7f5,					/* U+00a7f5 */
	0x00fb00,					/* U+00fb00 */
	0x00fb01,					/* U+00fb01 */
	0x00fb02,					/* U+00fb02 */
	0x00fb03,					/* U+00fb03 */
	0x00fb04,					/* U+00fb04 */
	0x00fb05,					/* U+00fb05 */
	0x00fb06,					/* U+00fb06 */
	0x00fb13,					/* U+00fb13 */
	0x00fb14,					/* U+00fb14 */
	0x00fb15,					/* U+00fb15 */
	0x00fb16,					/* U+00fb16 */
	0x00fb17,					/* U+00fb17 */
	0x00ff21,					/* U+00ff21 */
	0x00ff22,					/* U+00ff22 */
	0x00ff23,					/* U+00ff23 */
	0x00ff24,					/* U+00ff24 */
	0x00ff25,					/* U+00ff25 */
	0x00ff26,					/* U+00ff26 */
	0x00ff27,					/* U+00ff27 */
	0x00ff28,					/* U+00ff28 */
	0x00ff29,					/* U+00ff29 */
	0x00ff2a,					/* U+00ff2a */
	0x00ff2b,					/* U+00ff2b */
	0x00ff2c,					/* U+00ff2c */
	0x00ff2d,					/* U+00ff2d */
	0x00ff2e,					/* U+00ff2e */
	0x00ff2f,					/* U+00ff2f */
	0x00ff30,					/* U+00ff30 */
	0x00ff31,					/* U+00ff31 */
	0x00ff32,					/* U+00ff32 */
	0x00ff33,					/* U+00ff33 */
	0x00ff34,					/* U+00ff34 */
	0x00ff35,					/* U+00ff35 */
	0x00ff36,					/* U+00ff36 */
	0x00ff37,					/* U+00ff37 */
	0x00ff38,					/* U+00ff38 */
	0x00ff39,					/* U+00ff39 */
	0x00ff3a,					/* U+00ff3a */
	0x010400,					/* U+010400 */
	0x010401,					/* U+010401 */
	0x010402,					/* U+010402 */
	0x010403,					/* U+010403 */
	0x010404,					/* U+010404 */
	0x010405,					/* U+010405 */
	0x010406,					/* U+010406 */
	0x010407,					/* U+010407 */
	0x010408,					/* U+010408 */
	0x010409,					/* U+010409 */
	0x01040a,					/* U+01040a */
	0x01040b,					/* U+01040b */
	0x01040c,					/* U+01040c */
	0x01040d,					/* U+01040d */
	0x01040e,					/* U+01040e */
	0x01040f,					/* U+01040f */
	0x010410,					/* U+010410 */
	0x010411,					/* U+010411 */
	0x010412,					/* U+010412 */
	0x010413,					/* U+010413 */
	0x010414,					/* U+010414 */
	0x010415,					/* U+010415 */
	0x010416,					/* U+010416 */
	0x010417,					/* U+010417 */
	0x010418,					/* U+010418 */
	0x010419,					/* U+010419 */
	0x01041a,					/* U+01041a */
	0x01041b,					/* U+01041b */
	0x01041c,					/* U+01041c */
	0x01041d,					/* U+01041d */
	0x01041e,					/* U+01041e */
	0x01041f,					/* U+01041f */
	0x010420,					/* U+010420 */
	0x010421,					/* U+010421 */
	0x010422,					/* U+010422 */
	0x010423,					/* U+010423 */
	0x010424,					/* U+010424 */
	0x010425,					/* U+010425 */
	0x010426,					/* U+010426 */
	0x010427,					/* U+010427 */
	0x0104b0,					/* U+0104b0 */
	0x0104b1,					/* U+0104b1 */
	0x0104b2,					/* U+0104b2 */
	0x0104b3,					/* U+0104b3 */
	0x0104b4,					/* U+0104b4 */
	0x0104b5,					/* U+0104b5 */
	0x0104b6,					/* U+0104b6 */
	0x0104b7,					/* U+0104b7 */
	0x0104b8,					/* U+0104b8 */
	0x0104b9,					/* U+0104b9 */
	0x0104ba,					/* U+0104ba */
	0x0104bb,					/* U+0104bb */
	0x0104bc,					/* U+0104bc */
	0x0104bd,					/* U+0104bd */
	0x0104be,					/* U+0104be */
	0x0104bf,					/* U+0104bf */
	0x0104c0,					/* U+0104c0 */
	0x0104c1,					/* U+0104c1 */
	0x0104c2,					/* U+0104c2 */
	0x0104c3,					/* U+0104c3 */
	0x0104c4,					/* U+0104c4 */
	0x0104c5,					/* U+0104c5 */
	0x0104c6,					/* U+0104c6 */
	0x0104c7,					/* U+0104c7 */
	0x0104c8,					/* U+0104c8 */
	0x0104c9,					/* U+0104c9 */
	0x0104ca,					/* U+0104ca */
	0x0104cb,					/* U+0104cb */
	0x0104cc,					/* U+0104cc */
	0x0104cd,					/* U+0104cd */
	0x0104ce,					/* U+0104ce */
	0x0104cf,					/* U+0104cf */
	0x0104d0,					/* U+0104d0 */
	0x0104d1,					/* U+0104d1 */
	0x0104d2,					/* U+0104d2 */
	0x0104d3,					/* U+0104d3 */
	0x010570,					/* U+010570 */
	0x010571,					/* U+010571 */
	0x010572,					/* U+010572 */
	0x010573,					/* U+010573 */
	0x010574,					/* U+010574 */
	0x010575,					/* U+010575 */
	0x010576,					/* U+010576 */
	0x010577,					/* U+010577 */
	0x010578,					/* U+010578 */
	0x010579,					/* U+010579 */
	0x01057a,					/* U+01057a */
	0x01057c,					/* U+01057c */
	0x01057d,					/* U+01057d */
	0x01057e,					/* U+01057e */
	0x01057f,					/* U+01057f */
	0x010580,					/* U+010580 */
	0x010581,					/* U+010581 */
	0x010582,					/* U+010582 */
	0x010583,					/* U+010583 */
	0x010584,					/* U+010584 */
	0x010585,					/* U+010585 */
	0x010586,					/* U+010586 */
	0x010587,					/* U+010587 */
	0x010588,					/* U+010588 */
	0x010589,					/* U+010589 */
	0x01058a,					/* U+01058a */
	0x01058c,					/* U+01058c */
	0x01058d,					/* U+01058d */
	0x01058e,					/* U+01058e */
	0x01058f,					/* U+01058f */
	0x010590,					/* U+010590 */
	0x010591,					/* U+010591 */
	0x010592,					/* U+010592 */
	0x010594,					/* U+010594 */
	0x010595,					/* U+010595 */
	0x010c80,					/* U+010c80 */
	0x010c81,					/* U+010c81 */
	0x010c82,					/* U+010c82 */
	0x010c83,					/* U+010c83 */
	0x010c84,					/* U+010c84 */
	0x010c85,					/* U+010c85 */
	0x010c86,					/* U+010c86 */
	0x010c87,					/* U+010c87 */
	0x010c88,					/* U+010c88 */
	0x010c89,					/* U+010c89 */
	0x010c8a,					/* U+010c8a */
	0x010c8b,					/* U+010c8b */
	0x010c8c,					/* U+010c8c */
	0x010c8d,					/* U+010c8d */
	0x010c8e,					/* U+010c8e */
	0x010c8f,					/* U+010c8f */
	0x010c90,					/* U+010c90 */
	0x010c91,					/* U+010c91 */
	0x010c92,					/* U+010c92 */
	0x010c93,					/* U+010c93 */
	0x010c94,					/* U+010c94 */
	0x010c95,					/* U+010c95 */
	0x010c96,					/* U+010c96 */
	0x010c97,					/* U+010c97 */
	0x010c98,					/* U+010c98 */
	0x010c99,					/* U+010c99 */
	0x010c9a,					/* U+010c9a */
	0x010c9b,					/* U+010c9b */
	0x010c9c,					/* U+010c9c */
	0x010c9d,					/* U+010c9d */
	0x010c9e,					/* U+010c9e */
	0x010c9f,					/* U+010c9f */
	0x010ca0,					/* U+010ca0 */
	0x010ca1,					/* U+010ca1 */
	0x010ca2,					/* U+010ca2 */
	0x010ca3,					/* U+010ca3 */
	0x010ca4,					/* U+010ca4 */
	0x010ca5,					/* U+010ca5 */
	0x010ca6,					/* U+010ca6 */
	0x010ca7,					/* U+010ca7 */
	0x010ca8,					/* U+010ca8 */
	0x010ca9,					/* U+010ca9 */
	0x010caa,					/* U+010caa */
	0x010cab,					/* U+010cab */
	0x010cac,					/* U+010cac */
	0x010cad,					/* U+010cad */
	0x010cae,					/* U+010cae */
	0x010caf,					/* U+010caf */
	0x010cb0,					/* U+010cb0 */
	0x010cb1,					/* U+010cb1 */
	0x010cb2,					/* U+010cb2 */
	0x010d50,					/* U+010d50 */
	0x010d51,					/* U+010d51 */
	0x010d52,					/* U+010d52 */
	0x010d53,					/* U+010d53 */
	0x010d54,					/* U+010d54 */
	0x010d55,					/* U+010d55 */
	0x010d56,					/* U+010d56 */
	0x010d57,					/* U+010d57 */
	0x010d58,					/* U+010d58 */
	0x010d59,					/* U+010d59 */
	0x010d5a,					/* U+010d5a */
	0x010d5b,					/* U+010d5b */
	0x010d5c,					/* U+010d5c */
	0x010d5d,					/* U+010d5d */
	0x010d5e,					/* U+010d5e */
	0x010d5f,					/* U+010d5f */
	0x010d60,					/* U+010d60 */
	0x010d61,					/* U+010d61 */
	0x010d62,					/* U+010d62 */
	0x010d63,					/* U+010d63 */
	0x010d64,					/* U+010d64 */
	0x010d65,					/* U+010d65 */
	0x0118a0,					/* U+0118a0 */
	0x0118a1,					/* U+0118a1 */
	0x0118a2,					/* U+0118a2 */
	0x0118a3,					/* U+0118a3 */
	0x0118a4,					/* U+0118a4 */
	0x0118a5,					/* U+0118a5 */
	0x0118a6,					/* U+0118a6 */
	0x0118a7,					/* U+0118a7 */
	0x0118a8,					/* U+0118a8 */
	0x0118a9,					/* U+0118a9 */
	0x0118aa,					/* U+0118aa */
	0x0118ab,					/* U+0118ab */
	0x0118ac,					/* U+0118ac */
	0x0118ad,					/* U+0118ad */
	0x0118ae,					/* U+0118ae */
	0x0118af,					/* U+0118af */
	0x0118b0,					/* U+0118b0 */
	0x0118b1,					/* U+0118b1 */
	0x0118b2,					/* U+0118b2 */
	0x0118b3,					/* U+0118b3 */
	0x0118b4,					/* U+0118b4 */
	0x0118b5,					/* U+0118b5 */
	0x0118b6,					/* U+0118b6 */
	0x0118b7,					/* U+0118b7 */
	0x0118b8,					/* U+0118b8 */
	0x0118b9,					/* U+0118b9 */
	0x0118ba,					/* U+0118ba */
	0x0118bb,					/* U+0118bb */
	0x0118bc,					/* U+0118bc */
	0x0118bd,					/* U+0118bd */
	0x0118be,					/* U+0118be */
	0x0118bf,					/* U+0118bf */
	0x016e40,					/* U+016e40 */
	0x016e41,					/* U+016e41 */
	0x016e42,					/* U+016e42 */
	0x016e43,					/* U+016e43 */
	0x016e44,					/* U+016e44 */
	0x016e45,					/* U+016e45 */
	0x016e46,					/* U+016e46 */
	0x016e47,					/* U+016e47 */
	0x016e48,					/* U+016e48 */
	0x016e49,					/* U+016e49 */
	0x016e4a,					/* U+016e4a */
	0x016e4b,					/* U+016e4b */
	0x016e4c,					/* U+016e4c */
	0x016e4d,					/* U+016e4d */
	0x016e4e,					/* U+016e4e */
	0x016e4f,					/* U+016e4f */
	0x016e50,					/* U+016e50 */
	0x016e51,					/* U+016e51 */
	0x016e52,					/* U+016e52 */
	0x016e53,					/* U+016e53 */
	0x016e54,					/* U+016e54 */
	0x016e55,					/* U+016e55 */
	0x016e56,					/* U+016e56 */
	0x016e57,					/* U+016e57 */
	0x016e58,					/* U+016e58 */
	0x016e59,					/* U+016e59 */
	0x016e5a,					/* U+016e5a */
	0x016e5b,					/* U+016e5b */
	0x016e5c,					/* U+016e5c */
	0x016e5d,					/* U+016e5d */
	0x016e5e,					/* U+016e5e */
	0x016e5f,					/* U+016e5f */
	0x01e900,					/* U+01e900 */
	0x01e901,					/* U+01e901 */
	0x01e902,					/* U+01e902 */
	0x01e903,					/* U+01e903 */
	0x01e904,					/* U+01e904 */
	0x01e905,					/* U+01e905 */
	0x01e906,					/* U+01e906 */
	0x01e907,					/* U+01e907 */
	0x01e908,					/* U+01e908 */
	0x01e909,					/* U+01e909 */
	0x01e90a,					/* U+01e90a */
	0x01e90b,					/* U+01e90b */
	0x01e90c,					/* U+01e90c */
	0x01e90d,					/* U+01e90d */
	0x01e90e,					/* U+01e90e */
	0x01e90f,					/* U+01e90f */
	0x01e910,					/* U+01e910 */
	0x01e911,					/* U+01e911 */
	0x01e912,					/* U+01e912 */
	0x01e913,					/* U+01e913 */
	0x01e914,					/* U+01e914 */
	0x01e915,					/* U+01e915 */
	0x01e916,					/* U+01e916 */
	0x01e917,					/* U+01e917 */
	0x01e918,					/* U+01e918 */
	0x01e919,					/* U+01e919 */
	0x01e91a,					/* U+01e91a */
	0x01e91b,					/* U+01e91b */
	0x01e91c,					/* U+01e91c */
	0x01e91d,					/* U+01e91d */
	0x01e91e,					/* U+01e91e */
	0x01e91f,					/* U+01e91f */
	0x01e920,					/* U+01e920 */
	0x01e921,					/* U+01e921 */

};

/*
 * The entry case_map_upper[case_index(codepoint)] is the mapping for the
 * given codepoint.
 */
static const pg_wchar case_map_upper[1704] =
{
	0x000000,					/* reserved */
	0x000000,					/* U+000000 */
	0x000001,					/* U+000001 */
	0x000002,					/* U+000002 */
	0x000003,					/* U+000003 */
	0x000004,					/* U+000004 */
	0x000005,					/* U+000005 */
	0x000006,					/* U+000006 */
	0x000007,					/* U+000007 */
	0x000008,					/* U+000008 */
	0x000009,					/* U+000009 */
	0x00000a,					/* U+00000a */
	0x00000b,					/* U+00000b */
	0x00000c,					/* U+00000c */
	0x00000d,					/* U+00000d */
	0x00000e,					/* U+00000e */
	0x00000f,					/* U+00000f */
	0x000010,					/* U+000010 */
	0x000011,					/* U+000011 */
	0x000012,					/* U+000012 */
	0x000013,					/* U+000013 */
	0x000014,					/* U+000014 */
	0x000015,					/* U+000015 */
	0x000016,					/* U+000016 */
	0x000017,					/* U+000017 */
	0x000018,					/* U+000018 */
	0x000019,					/* U+000019 */
	0x00001a,					/* U+00001a */
	0x00001b,					/* U+00001b */
	0x00001c,					/* U+00001c */
	0x00001d,					/* U+00001d */
	0x00001e,					/* U+00001e */
	0x00001f,					/* U+00001f */
	0x000020,					/* U+000020 */
	0x000021,					/* U+000021 */
	0x000022,					/* U+000022 */
	0x000023,					/* U+000023 */
	0x000024,					/* U+000024 */
	0x000025,					/* U+000025 */
	0x000026,					/* U+000026 */
	0x000027,					/* U+000027 */
	0x000028,					/* U+000028 */
	0x000029,					/* U+000029 */
	0x00002a,					/* U+00002a */
	0x00002b,					/* U+00002b */
	0x00002c,					/* U+00002c */
	0x00002d,					/* U+00002d */
	0x00002e,					/* U+00002e */
	0x00002f,					/* U+00002f */
	0x000030,					/* U+000030 */
	0x000031,					/* U+000031 */
	0x000032,					/* U+000032 */
	0x000033,					/* U+000033 */
	0x000034,					/* U+000034 */
	0x000035,					/* U+000035 */
	0x000036,					/* U+000036 */
	0x000037,					/* U+000037 */
	0x000038,					/* U+000038 */
	0x000039,					/* U+000039 */
	0x00003a,					/* U+00003a */
	0x00003b,					/* U+00003b */
	0x00003c,					/* U+00003c */
	0x00003d,					/* U+00003d */
	0x00003e,					/* U+00003e */
	0x00003f,					/* U+00003f */
	0x000040,					/* U+000040 */
	0x000041,					/* U+000041 */
	0x000042,					/* U+000042 */
	0x000043,					/* U+000043 */
	0x000044,					/* U+000044 */
	0x000045,					/* U+000045 */
	0x000046,					/* U+000046 */
	0x000047,					/* U+000047 */
	0x000048,					/* U+000048 */
	0x000049,					/* U+000049 */
	0x00004a,					/* U+00004a */
	0x00004b,					/* U+00004b */
	0x00004c,					/* U+00004c */
	0x00004d,					/* U+00004d */
	0x00004e,					/* U+00004e */
	0x00004f,					/* U+00004f */
	0x000050,					/* U+000050 */
	0x000051,					/* U+000051 */
	0x000052,					/* U+000052 */
	0x000053,					/* U+000053 */
	0x000054,					/* U+000054 */
	0x000055,					/* U+000055 */
	0x000056,					/* U+000056 */
	0x000057,					/* U+000057 */
	0x000058,					/* U+000058 */
	0x000059,					/* U+000059 */
	0x00005a,					/* U+00005a */
	0x00005b,					/* U+00005b */
	0x00005c,					/* U+00005c */
	0x00005d,					/* U+00005d */
	0x00005e,					/* U+00005e */
	0x00005f,					/* U+00005f */
	0x000060,					/* U+000060 */
	0x000041,					/* U+000061 */
	0x000042,					/* U+000062 */
	0x000043,					/* U+000063 */
	0x000044,					/* U+000064 */
	0x000045,					/* U+000065 */
	0x000046,					/* U+000066 */
	0x000047,					/* U+000067 */
	0x000048,					/* U+000068 */
	0x000049,					/* U+000069 */
	0x00004a,					/* U+00006a */
	0x00004b,					/* U+00006b */
	0x00004c,					/* U+00006c */
	0x00004d,					/* U+00006d */
	0x00004e,					/* U+00006e */
	0x00004f,					/* U+00006f */
	0x000050,					/* U+000070 */
	0x000051,					/* U+000071 */
	0x000052,					/* U+000072 */
	0x000053,					/* U+000073 */
	0x000054,					/* U+000074 */
	0x000055,					/* U+000075 */
	0x000056,					/* U+000076 */
	0x000057,					/* U+000077 */
	0x000058,					/* U+000078 */
	0x000059,					/* U+000079 */
	0x00005a,					/* U+00007a */
	0x00007b,					/* U+00007b */
	0x00007c,					/* U+00007c */
	0x00007d,					/* U+00007d */
	0x00007e,					/* U+00007e */
	0x00007f,					/* U+00007f */
	0x00039c,					/* U+0000b5 */
	0x0000c0,					/* U+0000c0 */
	0x0000c1,					/* U+0000c1 */
	0x0000c2,					/* U+0000c2 */
	0x0000c3,					/* U+0000c3 */
	0x0000c4,					/* U+0000c4 */
	0x0000c5,					/* U+0000c5 */
	0x0000c6,					/* U+0000c6 */
	0x0000c7,					/* U+0000c7 */
	0x0000c8,					/* U+0000c8 */
	0x0000c9,					/* U+0000c9 */
	0x0000ca,					/* U+0000ca */
	0x0000cb,					/* U+0000cb */
	0x0000cc,					/* U+0000cc */
	0x0000cd,					/* U+0000cd */
	0x0000ce,					/* U+0000ce */
	0x0000cf,					/* U+0000cf */
	0x0000d0,					/* U+0000d0 */
	0x0000d1,					/* U+0000d1 */
	0x0000d2,					/* U+0000d2 */
	0x0000d3,					/* U+0000d3 */
	0x0000d4,					/* U+0000d4 */
	0x0000d5,					/* U+0000d5 */
	0x0000d6,					/* U+0000d6 */
	0x0000d8,					/* U+0000d8 */
	0x0000d9,					/* U+0000d9 */
	0x0000da,					/* U+0000da */
	0x0000db,					/* U+0000db */
	0x0000dc,					/* U+0000dc */
	0x0000dd,					/* U+0000dd */
	0x0000de,					/* U+0000de */
	0x0000df,					/* U+0000df */
	0x000178,					/* U+0000ff */
	0x000100,					/* U+000100 */
	0x000102,					/* U+000102 */
	0x000104,					/* U+000104 */
	0x000106,					/* U+000106 */
	0x000108,					/* U+000108 */
	0x00010a,					/* U+00010a */
	0x00010c,					/* U+00010c */
	0x00010e,					/* U+00010e */
	0x000110,					/* U+000110 */
	0x000112,					/* U+000112 */
	0x000114,					/* U+000114 */
	0x000116,					/* U+000116 */
	0x000118,					/* U+000118 */
	0x00011a,					/* U+00011a */
	0x00011c,					/* U+00011c */
	0x00011e,					/* U+00011e */
	0x000120,					/* U+000120 */
	0x000122,					/* U+000122 */
	0x000124,					/* U+000124 */
	0x000126,					/* U+000126 */
	0x000128,					/* U+000128 */
	0x00012a,					/* U+00012a */
	0x00012c,					/* U+00012c */
	0x00012e,					/* U+00012e */
	0x000130,					/* U+000130 */
	0x000049,					/* U+000131 */
	0x000132,					/* U+000132 */
	0x000134,					/* U+000134 */
	0x000136,					/* U+000136 */
	0x000139,					/* U+000139 */
	0x00013b,					/* U+00013b */
	0x00013d,					/* U+00013d */
	0x00013f,					/* U+00013f */
	0x000141,					/* U+000141 */
	0x000143,					/* U+000143 */
	0x000145,					/* U+000145 */
	0x000147,					/* U+000147 */
	0x000149,					/* U+000149 */
	0x00014a,					/* U+00014a */
	0x00014c,					/* U+00014c */
	0x00014e,					/* U+00014e */
	0x000150,					/* U+000150 */
	0x000152,					/* U+000152 */
	0x000154,					/* U+000154 */
	0x000156,					/* U+000156 */
	0x000158,					/* U+000158 */
	0x00015a,					/* U+00015a */
	0x00015c,					/* U+00015c */
	0x00015e,					/* U+00015e */
	0x000160,					/* U+000160 */
	0x000162,					/* U+000162 */
	0x000164,					/* U+000164 */
	0x000166,					/* U+000166 */
	0x000168,					/* U+000168 */
	0x00016a,					/* U+00016a */
	0x00016c,					/* U+00016c */
	0x00016e,					/* U+00016e */
	0x000170,					/* U+000170 */
	0x000172,					/* U+000172 */
	0x000174,					/* U+000174 */
	0x000176,					/* U+000176 */
	0x000179,					/* U+000179 */
	0x00017b,					/* U+00017b */
	0x00017d,					/* U+00017d */
	0x000053,					/* U+00017f */
	0x000243,					/* U+000180 */
	0x000181,					/* U+000181 */
	0x000182,					/* U+000182 */
	0x000184,					/* U+000184 */
	0x000186,					/* U+000186 */
	0x000187,					/* U+000187 */
	0x000189,					/* U+000189 */
	0x00018a,					/* U+00018a */
	0x00018b,					/* U+00018b */
	0x00018e,					/* U+00018e */
	0x00018f,					/* U+00018f */
	0x000190,					/* U+000190 */
	0x000191,					/* U+000191 */
	0x000193,					/* U+000193 */
	0x000194,					/* U+000194 */
	0x0001f6,					/* U+000195 */
	0x000196,					/* U+000196 */
	0x000197,					/* U+000197 */
	0x000198,					/* U+000198 */
	0x00023d,					/* U+00019a */
	0x00a7dc,					/* U+00019b */
	0x00019c,					/* U+00019c */
	0x00019d,					/* U+00019d */
	0x000220,					/* U+00019e */
	0x00019f,					/* U+00019f */
	0x0001a0,					/* U+0001a0 */
	0x0001a2,					/* U+0001a2 */
	0x0001a4,					/* U+0001a4 */
	0x0001a6,					/* U+0001a6 */
	0x0001a7,					/* U+0001a7 */
	0x0001a9,					/* U+0001a9 */
	0x0001ac,					/* U+0001ac */
	0x0001ae,					/* U+0001ae */
	0x0001af,					/* U+0001af */
	0x0001b1,					/* U+0001b1 */
	0x0001b2,					/* U+0001b2 */
	0x0001b3,					/* U+0001b3 */
	0x0001b5,					/* U+0001b5 */
	0x0001b7,					/* U+0001b7 */
	0x0001b8,					/* U+0001b8 */
	0x0001bc,					/* U+0001bc */
	0x0001f7,					/* U+0001bf */
	0x0001c4,					/* U+0001c4 */
	0x0001c7,					/* U+0001c7 */
	0x0001ca,					/* U+0001ca */
	0x0001cd,					/* U+0001cd */
	0x0001cf,					/* U+0001cf */
	0x0001d1,					/* U+0001d1 */
	0x0001d3,					/* U+0001d3 */
	0x0001d5,					/* U+0001d5 */
	0x0001d7,					/* U+0001d7 */
	0x0001d9,					/* U+0001d9 */
	0x0001db,					/* U+0001db */
	0x0001de,					/* U+0001de */
	0x0001e0,					/* U+0001e0 */
	0x0001e2,					/* U+0001e2 */
	0x0001e4,					/* U+0001e4 */
	0x0001e6,					/* U+0001e6 */
	0x0001e8,					/* U+0001e8 */
	0x0001ea,					/* U+0001ea */
	0x0001ec,					/* U+0001ec */
	0x0001ee,					/* U+0001ee */
	0x0001f0,					/* U+0001f0 */
	0x0001f1,					/* U+0001f1 */
	0x0001f4,					/* U+0001f4 */
	0x0001f8,					/* U+0001f8 */
	0x0001fa,					/* U+0001fa */
	0x0001fc,					/* U+0001fc */
	0x0001fe,					/* U+0001fe */
	0x000200,					/* U+000200 */
	0x000202,					/* U+000202 */
	0x000204,					/* U+000204 */
	0x000206,					/* U+000206 */
	0x000208,					/* U+000208 */
	0x00020a,					/* U+00020a */
	0x00020c,					/* U+00020c */
	0x00020e,					/* U+00020e */
	0x000210,					/* U+000210 */
	0x000212,					/* U+000212 */
	0x000214,					/* U+000214 */
	0x000216,					/* U+000216 */
	0x000218,					/* U+000218 */
	0x00021a,					/* U+00021a */
	0x00021c,					/* U+00021c */
	0x00021e,					/* U+00021e */
	0x000222,					/* U+000222 */
	0x000224,					/* U+000224 */
	0x000226,					/* U+000226 */
	0x000228,					/* U+000228 */
	0x00022a,					/* U+00022a */
	0x00022c,					/* U+00022c */
	0x00022e,					/* U+00022e */
	0x000230,					/* U+000230 */
	0x000232,					/* U+000232 */
	0x00023a,					/* U+00023a */
	0x00023b,					/* U+00023b */
	0x00023e,					/* U+00023e */
	0x002c7e,					/* U+00023f */
	0x002c7f,					/* U+000240 */
	0x000241,					/* U+000241 */
	0x000244,					/* U+000244 */
	0x000245,					/* U+000245 */
	0x000246,					/* U+000246 */
	0x000248,					/* U+000248 */
	0x00024a,					/* U+00024a */
	0x00024c,					/* U+00024c */
	0x00024e,					/* U+00024e */
	0x002c6f,					/* U+000250 */
	0x002c6d,					/* U+000251 */
	0x002c70,					/* U+000252 */
	0x00a7ab,					/* U+00025c */
	0x00a7ac,					/* U+000261 */
	0x00a7cb,					/* U+000264 */
	0x00a78d,					/* U+000265 */
	0x00a7aa,					/* U+000266 */
	0x00a7ae,					/* U+00026a */
	0x002c62,					/* U+00026b */
	0x00a7ad,					/* U+00026c */
	0x002c6e,					/* U+000271 */
	0x002c64,					/* U+00027d */
	0x00a7c5,					/* U+000282 */
	0x00a7b1,					/* U+000287 */
	0x00a7b2,					/* U+00029d */
	0x00a7b0,					/* U+00029e */
	0x000399,					/* U+000345 */
	0x000370,					/* U+000370 */
	0x000372,					/* U+000372 */
	0x000376,					/* U+000376 */
	0x0003fd,					/* U+00037b */
	0x0003fe,					/* U+00037c */
	0x0003ff,					/* U+00037d */
	0x00037f,					/* U+00037f */
	0x000386,					/* U+000386 */
	0x000388,					/* U+000388 */
	0x000389,					/* U+000389 */
	0x00038a,					/* U+00038a */
	0x00038c,					/* U+00038c */
	0x00038e,					/* U+00038e */
	0x00038f,					/* U+00038f */
	0x000390,					/* U+000390 */
	0x000391,					/* U+000391 */
	0x000392,					/* U+000392 */
	0x000393,					/* U+000393 */
	0x000394,					/* U+000394 */
	0x000395,					/* U+000395 */
	0x000396,					/* U+000396 */
	0x000397,					/* U+000397 */
	0x000398,					/* U+000398 */
	0x000399,					/* U+000399 */
	0x00039a,					/* U+00039a */
	0x00039b,					/* U+00039b */
	0x00039c,					/* U+00039c */
	0x00039d,					/* U+00039d */
	0x00039e,					/* U+00039e */
	0x00039f,					/* U+00039f */
	0x0003a0,					/* U+0003a0 */
	0x0003a1,					/* U+0003a1 */
	0x0003a3,					/* U+0003a3 */
	0x0003a4,					/* U+0003a4 */
	0x0003a5,					/* U+0003a5 */
	0x0003a6,					/* U+0003a6 */
	0x0003a7,					/* U+0003a7 */
	0x0003a8,					/* U+0003a8 */
	0x0003a9,					/* U+0003a9 */
	0x0003aa,					/* U+0003aa */
	0x0003ab,					/* U+0003ab */
	0x0003b0,					/* U+0003b0 */
	0x0003a3,					/* U+0003c2 */
	0x0003a3,					/* U+0003c3 */
	0x0003cf,					/* U+0003cf */
	0x000392,					/* U+0003d0 */
	0x000398,					/* U+0003d1 */
	0x0003a6,					/* U+0003d5 */
	0x0003a0,					/* U+0003d6 */
	0x0003d8,					/* U+0003d8 */
	0x0003da,					/* U+0003da */
	0x0003dc,					/* U+0003dc */
	0x0003de,					/* U+0003de */
	0x0003e0,					/* U+0003e0 */
	0x0003e2,					/* U+0003e2 */
	0x0003e4,					/* U+0003e4 */
	0x0003e6,					/* U+0003e6 */
	0x0003e8,					/* U+0003e8 */
	0x0003ea,					/* U+0003ea */
	0x0003ec,					/* U+0003ec */
	0x0003ee,					/* U+0003ee */
	0x00039a,					/* U+0003f0 */
	0x0003a1,					/* U+0003f1 */
	0x0003f9,					/* U+0003f2 */
	0x0003f4,					/* U+0003f4 */
	0x000395,					/* U+0003f5 */
	0x0003f7,					/* U+0003f7 */
	0x0003fa,					/* U+0003fa */
	0x000400,					/* U+000400 */
	0x000401,					/* U+000401 */
	0x000402,					/* U+000402 */
	0x000403,					/* U+000403 */
	0x000404,					/* U+000404 */
	0x000405,					/* U+000405 */
	0x000406,					/* U+000406 */
	0x000407,					/* U+000407 */
	0x000408,					/* U+000408 */
	0x000409,					/* U+000409 */
	0x00040a,					/* U+00040a */
	0x00040b,					/* U+00040b */
	0x00040c,					/* U+00040c */
	0x00040d,					/* U+00040d */
	0x00040e,					/* U+00040e */
	0x00040f,					/* U+00040f */
	0x000410,					/* U+000410 */
	0x000411,					/* U+000411 */
	0x000412,					/* U+000412 */
	0x000413,					/* U+000413 */
	0x000414,					/* U+000414 */
	0x000415,					/* U+000415 */
	0x000416,					/* U+000416 */
	0x000417,					/* U+000417 */
	0x000418,					/* U+000418 */
	0x000419,					/* U+000419 */
	0x00041a,					/* U+00041a */
	0x00041b,					/* U+00041b */
	0x00041c,					/* U+00041c */
	0x00041d,					/* U+00041d */
	0x00041e,					/* U+00041e */
	0x00041f,					/* U+00041f */
	0x000420,					/* U+000420 */
	0x000421,					/* U+000421 */
	0x000422,					/* U+000422 */
	0x000423,					/* U+000423 */
	0x000424,					/* U+000424 */
	0x000425,					/* U+000425 */
	0x000426,					/* U+000426 */
	0x000427,					/* U+000427 */
	0x000428,					/* U+000428 */
	0x000429,					/* U+000429 */
	0x00042a,					/* U+00042a */
	0x00042b,					/* U+00042b */
	0x00042c,					/* U+00042c */
	0x00042d,					/* U+00042d */
	0x00042e,					/* U+00042e */
	0x00042f,					/* U+00042f */
	0x000460,					/* U+000460 */
	0x000462,					/* U+000462 */
	0x000464,					/* U+000464 */
	0x000466,					/* U+000466 */
	0x000468,					/* U+000468 */
	0x00046a,					/* U+00046a */
	0x00046c,					/* U+00046c */
	0x00046e,					/* U+00046e */
	0x000470,					/* U+000470 */
	0x000472,					/* U+000472 */
	0x000474,					/* U+000474 */
	0x000476,					/* U+000476 */
	0x000478,					/* U+000478 */
	0x00047a,					/* U+00047a */
	0x00047c,					/* U+00047c */
	0x00047e,					/* U+00047e */
	0x000480,					/* U+000480 */
	0x00048a,					/* U+00048a */
	0x00048c,					/* U+00048c */
	0x00048e,					/* U+00048e */
	0x000490,					/* U+000490 */
	0x000492,					/* U+000492 */
	0x000494,					/* U+000494 */
	0x000496,					/* U+000496 */
	0x000498,					/* U+000498 */
	0x00049a,					/* U+00049a */
	0x00049c,					/* U+00049c */
	0x00049e,					/* U+00049e */
	0x0004a0,					/* U+0004a0 */
	0x0004a2,					/* U+0004a2 */
	0x0004a4,					/* U+0004a4 */
	0x0004a6,					/* U+0004a6 */
	0x0004a8,					/* U+0004a8 */
	0x0004aa,					/* U+0004aa */
	0x0004ac,					/* U+0004ac */
	0x0004ae,					/* U+0004ae */
	0x0004b0,					/* U+0004b0 */
	0x0004b2,					/* U+0004b2 */
	0x0004b4,					/* U+0004b4 */
	0x0004b6,					/* U+0004b6 */
	0x0004b8,					/* U+0004b8 */
	0x0004ba,					/* U+0004ba */
	0x0004bc,					/* U+0004bc */
	0x0004be,					/* U+0004be */
	0x0004c0,					/* U+0004c0 */
	0x0004c1,					/* U+0004c1 */
	0x0004c3,					/* U+0004c3 */
	0x0004c5,					/* U+0004c5 */
	0x0004c7,					/* U+0004c7 */
	0x0004c9,					/* U+0004c9 */
	0x0004cb,					/* U+0004cb */
	0x0004cd,					/* U+0004cd */
	0x0004d0,					/* U+0004d0 */
	0x0004d2,					/* U+0004d2 */
	0x0004d4,					/* U+0004d4 */
	0x0004d6,					/* U+0004d6 */
	0x0004d8,					/* U+0004d8 */
	0x0004da,					/* U+0004da */
	0x0004dc,					/* U+0004dc */
	0x0004de,					/* U+0004de */
	0x0004e0,					/* U+0004e0 */
	0x0004e2,					/* U+0004e2 */
	0x0004e4,					/* U+0004e4 */
	0x0004e6,					/* U+0004e6 */
	0x0004e8,					/* U+0004e8 */
	0x0004ea,					/* U+0004ea */
	0x0004ec,					/* U+0004ec */
	0x0004ee,					/* U+0004ee */
	0x0004f0,					/* U+0004f0 */
	0x0004f2,					/* U+0004f2 */
	0x0004f4,					/* U+0004f4 */
	0x0004f6,					/* U+0004f6 */
	0x0004f8,					/* U+0004f8 */
	0x0004fa,					/* U+0004fa */
	0x0004fc,					/* U+0004fc */
	0x0004fe,					/* U+0004fe */
	0x000500,					/* U+000500 */
	0x000502,					/* U+000502 */
	0x000504,					/* U+000504 */
	0x000506,					/* U+000506 */
	0x000508,					/* U+000508 */
	0x00050a,					/* U+00050a */
	0x00050c,					/* U+00050c */
	0x00050e,					/* U+00050e */
	0x000510,					/* U+000510 */
	0x000512,					/* U+000512 */
	0x000514,					/* U+000514 */
	0x000516,					/* U+000516 */
	0x000518,					/* U+000518 */
	0x00051a,					/* U+00051a */
	0x00051c,					/* U+00051c */
	0x00051e,					/* U+00051e */
	0x000520,					/* U+000520 */
	0x000522,					/* U+000522 */
	0x000524,					/* U+000524 */
	0x000526,					/* U+000526 */
	0x000528,					/* U+000528 */
	0x00052a,					/* U+00052a */
	0x00052c,					/* U+00052c */
	0x00052e,					/* U+00052e */
	0x000531,					/* U+000531 */
	0x000532,					/* U+000532 */
	0x000533,					/* U+000533 */
	0x000534,					/* U+000534 */
	0x000535,					/* U+000535 */
	0x000536,					/* U+000536 */
	0x000537,					/* U+000537 */
	0x000538,					/* U+000538 */
	0x000539,					/* U+000539 */
	0x00053a,					/* U+00053a */
	0x00053b,					/* U+00053b */
	0x00053c,					/* U+00053c */
	0x00053d,					/* U+00053d */
	0x00053e,					/* U+00053e */
	0x00053f,					/* U+00053f */
	0x000540,					/* U+000540 */
	0x000541,					/* U+000541 */
	0x000542,					/* U+000542 */
	0x000543,					/* U+000543 */
	0x000544,					/* U+000544 */
	0x000545,					/* U+000545 */
	0x000546,					/* U+000546 */
	0x000547,					/* U+000547 */
	0x000548,					/* U+000548 */
	0x000549,					/* U+000549 */
	0x00054a,					/* U+00054a */
	0x00054b,					/* U+00054b */
	0x00054c,					/* U+00054c */
	0x00054d,					/* U+00054d */
	0x00054e,					/* U+00054e */
	0x00054f,					/* U+00054f */
	0x000550,					/* U+000550 */
	0x000551,					/* U+000551 */
	0x000552,					/* U+000552 */
	0x000553,					/* U+000553 */
	0x000554,					/* U+000554 */
	0x000555,					/* U+000555 */
	0x000556,					/* U+000556 */
	0x000587,					/* U+000587 */
	0x0010a0,					/* U+0010a0 */
	0x0010a1,					/* U+0010a1 */
	0x0010a2,					/* U+0010a2 */
	0x0010a3,					/* U+0010a3 */
	0x0010a4,					/* U+0010a4 */
	0x0010a5,					/* U+0010a5 */
	0x0010a6,					/* U+0010a6 */
	0x0010a7,					/* U+0010a7 */
	0x0010a8,					/* U+0010a8 */
	0x0010a9,					/* U+0010a9 */
	0x0010aa,					/* U+0010aa */
	0x0010ab,					/* U+0010ab */
	0x0010ac,					/* U+0010ac */
	0x0010ad,					/* U+0010ad */
	0x0010ae,					/* U+0010ae */
	0x0010af,					/* U+0010af */
	0x0010b0,					/* U+0010b0 */
	0x0010b1,					/* U+0010b1 */
	0x0010b2,					/* U+0010b2 */
	0x0010b3,					/* U+0010b3 */
	0x0010b4,					/* U+0010b4 */
	0x0010b5,					/* U+0010b5 */
	0x0010b6,					/* U+0010b6 */
	0x0010b7,					/* U+0010b7 */
	0x0010b8,					/* U+0010b8 */
	0x0010b9,					/* U+0010b9 */
	0x0010ba,					/* U+0010ba */
	0x0010bb,					/* U+0010bb */
	0x0010bc,					/* U+0010bc */
	0x0010bd,					/* U+0010bd */
	0x0010be,					/* U+0010be */
	0x0010bf,					/* U+0010bf */
	0x0010c0,					/* U+0010c0 */
	0x0010c1,					/* U+0010c1 */
	0x0010c2,					/* U+0010c2 */
	0x0010c3,					/* U+0010c3 */
	0x0010c4,					/* U+0010c4 */
	0x0010c5,					/* U+0010c5 */
	0x0010c7,					/* U+0010c7 */
	0x0010cd,					/* U+0010cd */
	0x001c90,					/* U+0010d0 */
	0x001c91,					/* U+0010d1 */
	0x001c92,					/* U+0010d2 */
	0x001c93,					/* U+0010d3 */
	0x001c94,					/* U+0010d4 */
	0x001c95,					/* U+0010d5 */
	0x001c96,					/* U+0010d6 */
	0x001c97,					/* U+0010d7 */
	0x001c98,					/* U+0010d8 */
	0x001c99,					/* U+0010d9 */
	0x001c9a,					/* U+0010da */
	0x001c9b,					/* U+0010db */
	0x001c9c,					/* U+0010dc */
	0x001c9d,					/* U+0010dd */
	0x001c9e,					/* U+0010de */
	0x001c9f,					/* U+0010df */
	0x001ca0,					/* U+0010e0 */
	0x001ca1,					/* U+0010e1 */
	0x001ca2,					/* U+0010e2 */
	0x001ca3,					/* U+0010e3 */
	0x001ca4,					/* U+0010e4 */
	0x001ca5,					/* U+0010e5 */
	0x001ca6,					/* U+0010e6 */
	0x001ca7,					/* U+0010e7 */
	0x001ca8,					/* U+0010e8 */
	0x001ca9,					/* U+0010e9 */
	0x001caa,					/* U+0010ea */
	0x001cab,					/* U+0010eb */
	0x001cac,					/* U+0010ec */
	0x001cad,					/* U+0010ed */
	0x001cae,					/* U+0010ee */
	0x001caf,					/* U+0010ef */
	0x001cb0,					/* U+0010f0 */
	0x001cb1,					/* U+0010f1 */
	0x001cb2,					/* U+0010f2 */
	0x001cb3,					/* U+0010f3 */
	0x001cb4,					/* U+0010f4 */
	0x001cb5,					/* U+0010f5 */
	0x001cb6,					/* U+0010f6 */
	0x001cb7,					/* U+0010f7 */
	0x001cb8,					/* U+0010f8 */
	0x001cb9,					/* U+0010f9 */
	0x001cba,					/* U+0010fa */
	0x001cbd,					/* U+0010fd */
	0x001cbe,					/* U+0010fe */
	0x001cbf,					/* U+0010ff */
	0x0013a0,					/* U+0013a0 */
	0x0013a1,					/* U+0013a1 */
	0x0013a2,					/* U+0013a2 */
	0x0013a3,					/* U+0013a3 */
	0x0013a4,					/* U+0013a4 */
	0x0013a5,					/* U+0013a5 */
	0x0013a6,					/* U+0013a6 */
	0x0013a7,					/* U+0013a7 */
	0x0013a8,					/* U+0013a8 */
	0x0013a9,					/* U+0013a9 */
	0x0013aa,					/* U+0013aa */
	0x0013ab,					/* U+0013ab */
	0x0013ac,					/* U+0013ac */
	0x0013ad,					/* U+0013ad */
	0x0013ae,					/* U+0013ae */
	0x0013af,					/* U+0013af */
	0x0013b0,					/* U+0013b0 */
	0x0013b1,					/* U+0013b1 */
	0x0013b2,					/* U+0013b2 */
	0x0013b3,					/* U+0013b3 */
	0x0013b4,					/* U+0013b4 */
	0x0013b5,					/* U+0013b5 */
	0x0013b6,					/* U+0013b6 */
	0x0013b7,					/* U+0013b7 */
	0x0013b8,					/* U+0013b8 */
	0x0013b9,					/* U+0013b9 */
	0x0013ba,					/* U+0013ba */
	0x0013bb,					/* U+0013bb */
	0x0013bc,					/* U+0013bc */
	0x0013bd,					/* U+0013bd */
	0x0013be,					/* U+0013be */
	0x0013bf,					/* U+0013bf */
	0x0013c0,					/* U+0013c0 */
	0x0013c1,					/* U+0013c1 */
	0x0013c2,					/* U+0013c2 */
	0x0013c3,					/* U+0013c3 */
	0x0013c4,					/* U+0013c4 */
	0x0013c5,					/* U+0013c5 */
	0x0013c6,					/* U+0013c6 */
	0x0013c7,					/* U+0013c7 */
	0x0013c8,					/* U+0013c8 */
	0x0013c9,					/* U+0013c9 */
	0x0013ca,					/* U+0013ca */
	0x0013cb,					/* U+0013cb */
	0x0013cc,					/* U+0013cc */
	0x0013cd,					/* U+0013cd */
	0x0013ce,					/* U+0013ce */
	0x0013cf,					/* U+0013cf */
	0x0013d0,					/* U+0013d0 */
	0x0013d1,					/* U+0013d1 */
	0x0013d2,					/* U+0013d2 */
	0x0013d3,					/* U+0013d3 */
	0x0013d4,					/* U+0013d4 */
	0x0013d5,					/* U+0013d5 */
	0x0013d6,					/* U+0013d6 */
	0x0013d7,					/* U+0013d7 */
	0x0013d8,					/* U+0013d8 */
	0x0013d9,					/* U+0013d9 */
	0x0013da,					/* U+0013da */
	0x0013db,					/* U+0013db */
	0x0013dc,					/* U+0013dc */
	0x0013dd,					/* U+0013dd */
	0x0013de,					/* U+0013de */
	0x0013df,					/* U+0013df */
	0x0013e0,					/* U+0013e0 */
	0x0013e1,					/* U+0013e1 */
	0x0013e2,					/* U+0013e2 */
	0x0013e3,					/* U+0013e3 */
	0x0013e4,					/* U+0013e4 */
	0x0013e5,					/* U+0013e5 */
	0x0013e6,					/* U+0013e6 */
	0x0013e7,					/* U+0013e7 */
	0x0013e8,					/* U+0013e8 */
	0x0013e9,					/* U+0013e9 */
	0x0013ea,					/* U+0013ea */
	0x0013eb,					/* U+0013eb */
	0x0013ec,					/* U+0013ec */
	0x0013ed,					/* U+0013ed */
	0x0013ee,					/* U+0013ee */
	0x0013ef,					/* U+0013ef */
	0x0013f0,					/* U+0013f0 */
	0x0013f1,					/* U+0013f1 */
	0x0013f2,					/* U+0013f2 */
	0x0013f3,					/* U+0013f3 */
	0x0013f4,					/* U+0013f4 */
	0x0013f5,					/* U+0013f5 */
	0x000412,					/* U+001c80 */
	0x000414,					/* U+001c81 */
	0x00041e,					/* U+001c82 */
	0x000421,					/* U+001c83 */
	0x000422,					/* U+001c84 */
	0x000422,					/* U+001c85 */
	0x00042a,					/* U+001c86 */
	0x000462,					/* U+001c87 */
	0x00a64a,					/* U+001c88 */
	0x001c89,					/* U+001c89 */
	0x001c90,					/* U+001c90 */
	0x001c91,					/* U+001c91 */
	0x001c92,					/* U+001c92 */
	0x001c93,					/* U+001c93 */
	0x001c94,					/* U+001c94 */
	0x001c95,					/* U+001c95 */
	0x001c96,					/* U+001c96 */
	0x001c97,					/* U+001c97 */
	0x001c98,					/* U+001c98 */
	0x001c99,					/* U+001c99 */
	0x001c9a,					/* U+001c9a */
	0x001c9b,					/* U+001c9b */
	0x001c9c,					/* U+001c9c */
	0x001c9d,					/* U+001c9d */
	0x001c9e,					/* U+001c9e */
	0x001c9f,					/* U+001c9f */
	0x001ca0,					/* U+001ca0 */
	0x001ca1,					/* U+001ca1 */
	0x001ca2,					/* U+001ca2 */
	0x001ca3,					/* U+001ca3 */
	0x001ca4,					/* U+001ca4 */
	0x001ca5,					/* U+001ca5 */
	0x001ca6,					/* U+001ca6 */
	0x001ca7,					/* U+001ca7 */
	0x001ca8,					/* U+001ca8 */
	0x001ca9,					/* U+001ca9 */
	0x001caa,					/* U+001caa */
	0x001cab,					/* U+001cab */
	0x001cac,					/* U+001cac */
	0x001cad,					/* U+001cad */
	0x001cae,					/* U+001cae */
	0x001caf,					/* U+001caf */
	0x001cb0,					/* U+001cb0 */
	0x001cb1,					/* U+001cb1 */
	0x001cb2,					/* U+001cb2 */
	0x001cb3,					/* U+001cb3 */
	0x001cb4,					/* U+001cb4 */
	0x001cb5,					/* U+001cb5 */
	0x001cb6,					/* U+001cb6 */
	0x001cb7,					/* U+001cb7 */
	0x001cb8,					/* U+001cb8 */
	0x001cb9,					/* U+001cb9 */
	0x001cba,					/* U+001cba */
	0x001cbd,					/* U+001cbd */
	0x001cbe,					/* U+001cbe */
	0x001cbf,					/* U+001cbf */
	0x00a77d,					/* U+001d79 */
	0x002c63,					/* U+001d7d */
	0x00a7c6,					/* U+001d8e */
	0x001e00,					/* U+001e00 */
	0x001e02,					/* U+001e02 */
	0x001e04,					/* U+001e04 */
	0x001e06,					/* U+001e06 */
	0x001e08,					/* U+001e08 */
	0x001e0a,					/* U+001e0a */
	0x001e0c,					/* U+001e0c */
	0x001e0e,					/* U+001e0e */
	0x001e10,					/* U+001e10 */
	0x001e12,					/* U+001e12 */
	0x001e14,					/* U+001e14 */
	0x001e16,					/* U+001e16 */
	0x001e18,					/* U+001e18 */
	0x001e1a,					/* U+001e1a */
	0x001e1c,					/* U+001e1c */
	0x001e1e,					/* U+001e1e */
	0x001e20,					/* U+001e20 */
	0x001e22,					/* U+001e22 */
	0x001e24,					/* U+001e24 */
	0x001e26,					/* U+001e26 */
	0x001e28,					/* U+001e28 */
	0x001e2a,					/* U+001e2a */
	0x001e2c,					/* U+001e2c */
	0x001e2e,					/* U+001e2e */
	0x001e30,					/* U+001e30 */
	0x001e32,					/* U+001e32 */
	0x001e34,					/* U+001e34 */
	0x001e36,					/* U+001e36 */
	0x001e38,					/* U+001e38 */
	0x001e3a,					/* U+001e3a */
	0x001e3c,					/* U+001e3c */
	0x001e3e,					/* U+001e3e */
	0x001e40,					/* U+001e40 */
	0x001e42,					/* U+001e42 */
	0x001e44,					/* U+001e44 */
	0x001e46,					/* U+001e46 */
	0x001e48,					/* U+001e48 */
	0x001e4a,					/* U+001e4a */
	0x001e4c,					/* U+001e4c */
	0x001e4e,					/* U+001e4e */
	0x001e50,					/* U+001e50 */
	0x001e52,					/* U+001e52 */
	0x001e54,					/* U+001e54 */
	0x001e56,					/* U+001e56 */
	0x001e58,					/* U+001e58 */
	0x001e5a,					/* U+001e5a */
	0x001e5c,					/* U+001e5c */
	0x001e5e,					/* U+001e5e */
	0x001e60,					/* U+001e60 */
	0x001e62,					/* U+001e62 */
	0x001e64,					/* U+001e64 */
	0x001e66,					/* U+001e66 */
	0x001e68,					/* U+001e68 */
	0x001e6a,					/* U+001e6a */
	0x001e6c,					/* U+001e6c */
	0x001e6e,					/* U+001e6e */
	0x001e70,					/* U+001e70 */
	0x001e72,					/* U+001e72 */
	0x001e74,					/* U+001e74 */
	0x001e76,					/* U+001e76 */
	0x001e78,					/* U+001e78 */
	0x001e7a,					/* U+001e7a */
	0x001e7c,					/* U+001e7c */
	0x001e7e,					/* U+001e7e */
	0x001e80,					/* U+001e80 */
	0x001e82,					/* U+001e82 */
	0x001e84,					/* U+001e84 */
	0x001e86,					/* U+001e86 */
	0x001e88,					/* U+001e88 */
	0x001e8a,					/* U+001e8a */
	0x001e8c,					/* U+001e8c */
	0x001e8e,					/* U+001e8e */
	0x001e90,					/* U+001e90 */
	0x001e92,					/* U+001e92 */
	0x001e94,					/* U+001e94 */
	0x001e96,					/* U+001e96 */
	0x001e97,					/* U+001e97 */
	0x001e98,					/* U+001e98 */
	0x001e99,					/* U+001e99 */
	0x001e9a,					/* U+001e9a */
	0x001e60,					/* U+001e9b */
	0x001e9e,					/* U+001e9e */
	0x001ea0,					/* U+001ea0 */
	0x001ea2,					/* U+001ea2 */
	0x001ea4,					/* U+001ea4 */
	0x001ea6,					/* U+001ea6 */
	0x001ea8,					/* U+001ea8 */
	0x001eaa,					/* U+001eaa */
	0x001eac,					/* U+001eac */
	0x001eae,					/* U+001eae */
	0x001eb0,					/* U+001eb0 */
	0x001eb2,					/* U+001eb2 */
	0x001eb4,					/* U+001eb4 */
	0x001eb6,					/* U+001eb6 */
	0x001eb8,					/* U+001eb8 */
	0x001eba,					/* U+001eba */
	0x001ebc,					/* U+001ebc */
	0x001ebe,					/* U+001ebe */
	0x001ec0,					/* U+001ec0 */
	0x001ec2,					/* U+001ec2 */
	0x001ec4,					/* U+001ec4 */
	0x001ec6,					/* U+001ec6 */
	0x001ec8,					/* U+001ec8 */
	0x001eca,					/* U+001eca */
	0x001ecc,					/* U+001ecc */
	0x001ece,					/* U+001ece */
	0x001ed0,					/* U+001ed0 */
	0x001ed2,					/* U+001ed2 */
	0x001ed4,					/* U+001ed4 */
	0x001ed6,					/* U+001ed6 */
	0x001ed8,					/* U+001ed8 */
	0x001eda,					/* U+001eda */
	0x001edc,					/* U+001edc */
	0x001ede,					/* U+001ede */
	0x001ee0,					/* U+001ee0 */
	0x001ee2,					/* U+001ee2 */
	0x001ee4,					/* U+001ee4 */
	0x001ee6,					/* U+001ee6 */
	0x001ee8,					/* U+001ee8 */
	0x001eea,					/* U+001eea */
	0x001eec,					/* U+001eec */
	0x001eee,					/* U+001eee */
	0x001ef0,					/* U+001ef0 */
	0x001ef2,					/* U+001ef2 */
	0x001ef4,					/* U+001ef4 */
	0x001ef6,					/* U+001ef6 */
	0x001ef8,					/* U+001ef8 */
	0x001efa,					/* U+001efa */
	0x001efc,					/* U+001efc */
	0x001efe,					/* U+001efe */
	0x001f08,					/* U+001f00 */
	0x001f09,					/* U+001f01 */
	0x001f0a,					/* U+001f02 */
	0x001f0b,					/* U+001f03 */
	0x001f0c,					/* U+001f04 */
	0x001f0d,					/* U+001f05 */
	0x001f0e,					/* U+001f06 */
	0x001f0f,					/* U+001f07 */
	0x001f18,					/* U+001f10 */
	0x001f19,					/* U+001f11 */
	0x001f1a,					/* U+001f12 */
	0x001f1b,					/* U+001f13 */
	0x001f1c,					/* U+001f14 */
	0x001f1d,					/* U+001f15 */
	0x001f28,					/* U+001f20 */
	0x001f29,					/* U+001f21 */
	0x001f2a,					/* U+001f22 */
	0x001f2b,					/* U+001f23 */
	0x001f2c,					/* U+001f24 */
	0x001f2d,					/* U+001f25 */
	0x001f2e,					/* U+001f26 */
	0x001f2f,					/* U+001f27 */
	0x001f38,					/* U+001f30 */
	0x001f39,					/* U+001f31 */
	0x001f3a,					/* U+001f32 */
	0x001f3b,					/* U+001f33 */
	0x001f3c,					/* U+001f34 */
	0x001f3d,					/* U+001f35 */
	0x001f3e,					/* U+001f36 */
	0x001f3f,					/* U+001f37 */
	0x001f48,					/* U+001f40 */
	0x001f49,					/* U+001f41 */
	0x001f4a,					/* U+001f42 */
	0x001f4b,					/* U+001f43 */
	0x001f4c,					/* U+001f44 */
	0x001f4d,					/* U+001f45 */
	0x001f50,					/* U+001f50 */
	0x001f59,					/* U+001f51 */
	0x001f52,					/* U+001f52 */
	0x001f5b,					/* U+001f53 */
	0x001f54,					/* U+001f54 */
	0x001f5d,					/* U+001f55 */
	0x001f56,					/* U+001f56 */
	0x001f5f,					/* U+001f57 */
	0x001f68,					/* U+001f60 */
	0x001f69,					/* U+001f61 */
	0x001f6a,					/* U+001f62 */
	0x001f6b,					/* U+001f63 */
	0x001f6c,					/* U+001f64 */
	0x001f6d,					/* U+001f65 */
	0x001f6e,					/* U+001f66 */
	0x001f6f,					/* U+001f67 */
	0x001fba,					/* U+001f70 */
	0x001fbb,					/* U+001f71 */
	0x001fc8,					/* U+001f72 */
	0x001fc9,					/* U+001f73 */
	0x001fca,					/* U+001f74 */
	0x001fcb,					/* U+001f75 */
	0x001fda,					/* U+001f76 */
	0x001fdb,					/* U+001f77 */
	0x001ff8,					/* U+001f78 */
	0x001ff9,					/* U+001f79 */
	0x001fea,					/* U+001f7a */
	0x001feb,					/* U+001f7b */
	0x001ffa,					/* U+001f7c */
	0x001ffb,					/* U+001f7d */
	0x001f88,					/* U+001f80 */
	0x001f89,					/* U+001f81 */
	0x001f8a,					/* U+001f82 */
	0x001f8b,					/* U+001f83 */
	0x001f8c,					/* U+001f84 */
	0x001f8d,					/* U+001f85 */
	0x001f8e,					/* U+001f86 */
	0x001f8f,					/* U+001f87 */
	0x001f88,					/* U+001f88 */
	0x001f89,					/* U+001f89 */
	0x001f8a,					/* U+001f8a */
	0x001f8b,					/* U+001f8b */
	0x001f8c,					/* U+001f8c */
	0x001f8d,					/* U+001f8d */
	0x001f8e,					/* U+001f8e */
	0x001f8f,					/* U+001f8f */
	0x001f98,					/* U+001f90 */
	0x001f99,					/* U+001f91 */
	0x001f9a,					/* U+001f92 */
	0x001f9b,					/* U+001f93 */
	0x001f9c,					/* U+001f94 */
	0x001f9d,					/* U+001f95 */
	0x001f9e,					/* U+001f96 */
	0x001f9f,					/* U+001f97 */
	0x001f98,					/* U+001f98 */
	0x001f99,					/* U+001f99 */
	0x001f9a,					/* U+001f9a */
	0x001f9b,					/* U+001f9b */
	0x001f9c,					/* U+001f9c */
	0x001f9d,					/* U+001f9d */
	0x001f9e,					/* U+001f9e */
	0x001f9f,					/* U+001f9f */
	0x001fa8,					/* U+001fa0 */
	0x001fa9,					/* U+001fa1 */
	0x001faa,					/* U+001fa2 */
	0x001fab,					/* U+001fa3 */
	0x001fac,					/* U+001fa4 */
	0x001fad,					/* U+001fa5 */
	0x001fae,					/* U+001fa6 */
	0x001faf,					/* U+001fa7 */
	0x001fa8,					/* U+001fa8 */
	0x001fa9,					/* U+001fa9 */
	0x001faa,					/* U+001faa */
	0x001fab,					/* U+001fab */
	0x001fac,					/* U+001fac */
	0x001fad,					/* U+001fad */
	0x001fae,					/* U+001fae */
	0x001faf,					/* U+001faf */
	0x001fb8,					/* U+001fb0 */
	0x001fb9,					/* U+001fb1 */
	0x001fb2,					/* U+001fb2 */
	0x001fbc,					/* U+001fb3 */
	0x001fb4,					/* U+001fb4 */
	0x001fb6,					/* U+001fb6 */
	0x001fb7,					/* U+001fb7 */
	0x001fbc,					/* U+001fbc */
	0x000399,					/* U+001fbe */
	0x001fc2,					/* U+001fc2 */
	0x001fcc,					/* U+001fc3 */
	0x001fc4,					/* U+001fc4 */
	0x001fc6,					/* U+001fc6 */
	0x001fc7,					/* U+001fc7 */
	0x001fcc,					/* U+001fcc */
	0x001fd8,					/* U+001fd0 */
	0x001fd9,					/* U+001fd1 */
	0x001fd2,					/* U+001fd2 */
	0x001fd3,					/* U+001fd3 */
	0x001fd6,					/* U+001fd6 */
	0x001fd7,					/* U+001fd7 */
	0x001fe8,					/* U+001fe0 */
	0x001fe9,					/* U+001fe1 */
	0x001fe2,					/* U+001fe2 */
	0x001fe3,					/* U+001fe3 */
	0x001fe4,					/* U+001fe4 */
	0x001fec,					/* U+001fe5 */
	0x001fe6,					/* U+001fe6 */
	0x001fe7,					/* U+001fe7 */
	0x001ff2,					/* U+001ff2 */
	0x001ffc,					/* U+001ff3 */
	0x001ff4,					/* U+001ff4 */
	0x001ff6,					/* U+001ff6 */
	0x001ff7,					/* U+001ff7 */
	0x001ffc,					/* U+001ffc */
	0x002126,					/* U+002126 */
	0x00212a,					/* U+00212a */
	0x00212b,					/* U+00212b */
	0x002132,					/* U+002132 */
	0x002160,					/* U+002160 */
	0x002161,					/* U+002161 */
	0x002162,					/* U+002162 */
	0x002163,					/* U+002163 */
	0x002164,					/* U+002164 */
	0x002165,					/* U+002165 */
	0x002166,					/* U+002166 */
	0x002167,					/* U+002167 */
	0x002168,					/* U+002168 */
	0x002169,					/* U+002169 */
	0x00216a,					/* U+00216a */
	0x00216b,					/* U+00216b */
	0x00216c,					/* U+00216c */
	0x00216d,					/* U+00216d */
	0x00216e,					/* U+00216e */
	0x00216f,					/* U+00216f */
	0x002183,					/* U+002183 */
	0x0024b6,					/* U+0024b6 */
	0x0024b7,					/* U+0024b7 */
	0x0024b8,					/* U+0024b8 */
	0x0024b9,					/* U+0024b9 */
	0x0024ba,					/* U+0024ba */
	0x0024bb,					/* U+0024bb */
	0x0024bc,					/* U+0024bc */
	0x0024bd,					/* U+0024bd */
	0x0024be,					/* U+0024be */
	0x0024bf,					/* U+0024bf */
	0x0024c0,					/* U+0024c0 */
	0x0024c1,					/* U+0024c1 */
	0x0024c2,					/* U+0024c2 */
	0x0024c3,					/* U+0024c3 */
	0x0024c4,					/* U+0024c4 */
	0x0024c5,					/* U+0024c5 */
	0x0024c6,					/* U+0024c6 */
	0x0024c7,					/* U+0024c7 */
	0x0024c8,					/* U+0024c8 */
	0x0024c9,					/* U+0024c9 */
	0x0024ca,					/* U+0024ca */
	0x0024cb,					/* U+0024cb */
	0x0024cc,					/* U+0024cc */
	0x0024cd,					/* U+0024cd */
	0x0024ce,					/* U+0024ce */
	0x0024cf,					/* U+0024cf */
	0x002c00,					/* U+002c00 */
	0x002c01,					/* U+002c01 */
	0x002c02,					/* U+002c02 */
	0x002c03,					/* U+002c03 */
	0x002c04,					/* U+002c04 */
	0x002c05,					/* U+002c05 */
	0x002c06,					/* U+002c06 */
	0x002c07,					/* U+002c07 */
	0x002c08,					/* U+002c08 */
	0x002c09,					/* U+002c09 */
	0x002c0a,					/* U+002c0a */
	0x002c0b,					/* U+002c0b */
	0x002c0c,					/* U+002c0c */
	0x002c0d,					/* U+002c0d */
	0x002c0e,					/* U+002c0e */
	0x002c0f,					/* U+002c0f */
	0x002c10,					/* U+002c10 */
	0x002c11,					/* U+002c11 */
	0x002c12,					/* U+002c12 */
	0x002c13,					/* U+002c13 */
	0x002c14,					/* U+002c14 */
	0x002c15,					/* U+002c15 */
	0x002c16,					/* U+002c16 */
	0x002c17,					/* U+002c17 */
	0x002c18,					/* U+002c18 */
	0x002c19,					/* U+002c19 */
	0x002c1a,					/* U+002c1a */
	0x002c1b,					/* U+002c1b */
	0x002c1c,					/* U+002c1c */
	0x002c1d,					/* U+002c1d */
	0x002c1e,					/* U+002c1e */
	0x002c1f,					/* U+002c1f */
	0x002c20,					/* U+002c20 */
	0x002c21,					/* U+002c21 */
	0x002c22,					/* U+002c22 */
	0x002c23,					/* U+002c23 */
	0x002c24,					/* U+002c24 */
	0x002c25,					/* U+002c25 */
	0x002c26,					/* U+002c26 */
	0x002c27,					/* U+002c27 */
	0x002c28,					/* U+002c28 */
	0x002c29,					/* U+002c29 */
	0x002c2a,					/* U+002c2a */
	0x002c2b,					/* U+002c2b */
	0x002c2c,					/* U+002c2c */
	0x002c2d,					/* U+002c2d */
	0x002c2e,					/* U+002c2e */
	0x002c2f,					/* U+002c2f */
	0x002c60,					/* U+002c60 */
	0x002c67,					/* U+002c67 */
	0x002c69,					/* U+002c69 */
	0x002c6b,					/* U+002c6b */
	0x002c72,					/* U+002c72 */
	0x002c75,					/* U+002c75 */
	0x002c80,					/* U+002c80 */
	0x002c82,					/* U+002c82 */
	0x002c84,					/* U+002c84 */
	0x002c86,					/* U+002c86 */
	0x002c88,					/* U+002c88 */
	0x002c8a,					/* U+002c8a */
	0x002c8c,					/* U+002c8c */
	0x002c8e,					/* U+002c8e */
	0x002c90,					/* U+002c90 */
	0x002c92,					/* U+002c92 */
	0x002c94,					/* U+002c94 */
	0x002c96,					/* U+002c96 */
	0x002c98,					/* U+002c98 */
	0x002c9a,					/* U+002c9a */
	0x002c9c,					/* U+002c9c */
	0x002c9e,					/* U+002c9e */
	0x002ca0,					/* U+002ca0 */
	0x002ca2,					/* U+002ca2 */
	0x002ca4,					/* U+002ca4 */
	0x002ca6,					/* U+002ca6 */
	0x002ca8,					/* U+002ca8 */
	0x002caa,					/* U+002caa */
	0x002cac,					/* U+002cac */
	0x002cae,					/* U+002cae */
	0x002cb0,					/* U+002cb0 */
	0x002cb2,					/* U+002cb2 */
	0x002cb4,					/* U+002cb4 */
	0x002cb6,					/* U+002cb6 */
	0x002cb8,					/* U+002cb8 */
	0x002cba,					/* U+002cba */
	0x002cbc,					/* U+002cbc */
	0x002cbe,					/* U+002cbe */
	0x002cc0,					/* U+002cc0 */
	0x002cc2,					/* U+002cc2 */
	0x002cc4,					/* U+002cc4 */
	0x002cc6,					/* U+002cc6 */
	0x002cc8,					/* U+002cc8 */
	0x002cca,					/* U+002cca */
	0x002ccc,					/* U+002ccc */
	0x002cce,					/* U+002cce */
	0x002cd0,					/* U+002cd0 */
	0x002cd2,					/* U+002cd2 */
	0x002cd4,					/* U+002cd4 */
	0x002cd6,					/* U+002cd6 */
	0x002cd8,					/* U+002cd8 */
	0x002cda,					/* U+002cda */
	0x002cdc,					/* U+002cdc */
	0x002cde,					/* U+002cde */
	0x002ce0,					/* U+002ce0 */
	0x002ce2,					/* U+002ce2 */
	0x002ceb,					/* U+002ceb */
	0x002ced,					/* U+002ced */
	0x002cf2,					/* U+002cf2 */
	0x00a640,					/* U+00a640 */
	0x00a642,					/* U+00a642 */
	0x00a644,					/* U+00a644 */
	0x00a646,					/* U+00a646 */
	0x00a648,					/* U+00a648 */
	0x00a64a,					/* U+00a64a */
	0x00a64c,					/* U+00a64c */
	0x00a64e,					/* U+00a64e */
	0x00a650,					/* U+00a650 */
	0x00a652,					/* U+00a652 */
	0x00a654,					/* U+00a654 */
	0x00a656,					/* U+00a656 */
	0x00a658,					/* U+00a658 */
	0x00a65a,					/* U+00a65a */
	0x00a65c,					/* U+00a65c */
	0x00a65e,					/* U+00a65e */
	0x00a660,					/* U+00a660 */
	0x00a662,					/* U+00a662 */
	0x00a664,					/* U+00a664 */
	0x00a666,					/* U+00a666 */
	0x00a668,					/* U+00a668 */
	0x00a66a,					/* U+00a66a */
	0x00a66c,					/* U+00a66c */
	0x00a680,					/* U+00a680 */
	0x00a682,					/* U+00a682 */
	0x00a684,					/* U+00a684 */
	0x00a686,					/* U+00a686 */
	0x00a688,					/* U+00a688 */
	0x00a68a,					/* U+00a68a */
	0x00a68c,					/* U+00a68c */
	0x00a68e,					/* U+00a68e */
	0x00a690,					/* U+00a690 */
	0x00a692,					/* U+00a692 */
	0x00a694,					/* U+00a694 */
	0x00a696,					/* U+00a696 */
	0x00a698,					/* U+00a698 */
	0x00a69a,					/* U+00a69a */
	0x00a722,					/* U+00a722 */
	0x00a724,					/* U+00a724 */
	0x00a726,					/* U+00a726 */
	0x00a728,					/* U+00a728 */
	0x00a72a,					/* U+00a72a */
	0x00a72c,					/* U+00a72c */
	0x00a72e,					/* U+00a72e */
	0x00a732,					/* U+00a732 */
	0x00a734,					/* U+00a734 */
	0x00a736,					/* U+00a736 */
	0x00a738,					/* U+00a738 */
	0x00a73a,					/* U+00a73a */
	0x00a73c,					/* U+00a73c */
	0x00a73e,					/* U+00a73e */
	0x00a740,					/* U+00a740 */
	0x00a742,					/* U+00a742 */
	0x00a744,					/* U+00a744 */
	0x00a746,					/* U+00a746 */
	0x00a748,					/* U+00a748 */
	0x00a74a,					/* U+00a74a */
	0x00a74c,					/* U+00a74c */
	0x00a74e,					/* U+00a74e */
	0x00a750,					/* U+00a750 */
	0x00a752,					/* U+00a752 */
	0x00a754,					/* U+00a754 */
	0x00a756,					/* U+00a756 */
	0x00a758,					/* U+00a758 */
	0x00a75a,					/* U+00a75a */
	0x00a75c,					/* U+00a75c */
	0x00a75e,					/* U+00a75e */
	0x00a760,					/* U+00a760 */
	0x00a762,					/* U+00a762 */
	0x00a764,					/* U+00a764 */
	0x00a766,					/* U+00a766 */
	0x00a768,					/* U+00a768 */
	0x00a76a,					/* U+00a76a */
	0x00a76c,					/* U+00a76c */
	0x00a76e,					/* U+00a76e */
	0x00a779,					/* U+00a779 */
	0x00a77b,					/* U+00a77b */
	0x00a77e,					/* U+00a77e */
	0x00a780,					/* U+00a780 */
	0x00a782,					/* U+00a782 */
	0x00a784,					/* U+00a784 */
	0x00a786,					/* U+00a786 */
	0x00a78b,					/* U+00a78b */
	0x00a790,					/* U+00a790 */
	0x00a792,					/* U+00a792 */
	0x00a7c4,					/* U+00a794 */
	0x00a796,					/* U+00a796 */
	0x00a798,					/* U+00a798 */
	0x00a79a,					/* U+00a79a */
	0x00a79c,					/* U+00a79c */
	0x00a79e,					/* U+00a79e */
	0x00a7a0,					/* U+00a7a0 */
	0x00a7a2,					/* U+00a7a2 */
	0x00a7a4,					/* U+00a7a4 */
	0x00a7a6,					/* U+00a7a6 */
	0x00a7a8,					/* U+00a7a8 */
	0x00a7b3,					/* U+00a7b3 */
	0x00a7b4,					/* U+00a7b4 */
	0x00a7b6,					/* U+00a7b6 */
	0x00a7b8,					/* U+00a7b8 */
	0x00a7ba,					/* U+00a7ba */
	0x00a7bc,					/* U+00a7bc */
	0x00a7be,					/* U+00a7be */
	0x00a7c0,					/* U+00a7c0 */
	0x00a7c2,					/* U+00a7c2 */
	0x00a7c7,					/* U+00a7c7 */
	0x00a7c9,					/* U+00a7c9 */
	0x00a7cc,					/* U+00a7cc */
	0x00a7d0,					/* U+00a7d0 */
	0x00a7d6,					/* U+00a7d6 */
	0x00a7d8,					/* U+00a7d8 */
	0x00a7da,					/* U+00a7da */
	0x00a7f5,					/* U+00a7f5 */
	0x00fb00,					/* U+00fb00 */
	0x00fb01,					/* U+00fb01 */
	0x00fb02,					/* U+00fb02 */
	0x00fb03,					/* U+00fb03 */
	0x00fb04,					/* U+00fb04 */
	0x00fb05,					/* U+00fb05 */
	0x00fb06,					/* U+00fb06 */
	0x00fb13,					/* U+00fb13 */
	0x00fb14,					/* U+00fb14 */
	0x00fb15,					/* U+00fb15 */
	0x00fb16,					/* U+00fb16 */
	0x00fb17,					/* U+00fb17 */
	0x00ff21,					/* U+00ff21 */
	0x00ff22,					/* U+00ff22 */
	0x00ff23,					/* U+00ff23 */
	0x00ff24,					/* U+00ff24 */
	0x00ff25,					/* U+00ff25 */
	0x00ff26,					/* U+00ff26 */
	0x00ff27,					/* U+00ff27 */
	0x00ff28,					/* U+00ff28 */
	0x00ff29,					/* U+00ff29 */
	0x00ff2a,					/* U+00ff2a */
	0x00ff2b,					/* U+00ff2b */
	0x00ff2c,					/* U+00ff2c */
	0x00ff2d,					/* U+00ff2d */
	0x00ff2e,					/* U+00ff2e */
	0x00ff2f,					/* U+00ff2f */
	0x00ff30,					/* U+00ff30 */
	0x00ff31,					/* U+00ff31 */
	0x00ff32,					/* U+00ff32 */
	0x00ff33,					/* U+00ff33 */
	0x00ff34,					/* U+00ff34 */
	0x00ff35,					/* U+00ff35 */
	0x00ff36,					/* U+00ff36 */
	0x00ff37,					/* U+00ff37 */
	0x00ff38,					/* U+00ff38 */
	0x00ff39,					/* U+00ff39 */
	0x00ff3a,					/* U+00ff3a */
	0x010400,					/* U+010400 */
	0x010401,					/* U+010401 */
	0x010402,					/* U+010402 */
	0x010403,					/* U+010403 */
	0x010404,					/* U+010404 */
	0x010405,					/* U+010405 */
	0x010406,					/* U+010406 */
	0x010407,					/* U+010407 */
	0x010408,					/* U+010408 */
	0x010409,					/* U+010409 */
	0x01040a,					/* U+01040a */
	0x01040b,					/* U+01040b */
	0x01040c,					/* U+01040c */
	0x01040d,					/* U+01040d */
	0x01040e,					/* U+01040e */
	0x01040f,					/* U+01040f */
	0x010410,					/* U+010410 */
	0x010411,					/* U+010411 */
	0x010412,					/* U+010412 */
	0x010413,					/* U+010413 */
	0x010414,					/* U+010414 */
	0x010415,					/* U+010415 */
	0x010416,					/* U+010416 */
	0x010417,					/* U+010417 */
	0x010418,					/* U+010418 */
	0x010419,					/* U+010419 */
	0x01041a,					/* U+01041a */
	0x01041b,					/* U+01041b */
	0x01041c,					/* U+01041c */
	0x01041d,					/* U+01041d */
	0x01041e,					/* U+01041e */
	0x01041f,					/* U+01041f */
	0x010420,					/* U+010420 */
	0x010421,					/* U+010421 */
	0x010422,					/* U+010422 */
	0x010423,					/* U+010423 */
	0x010424,					/* U+010424 */
	0x010425,					/* U+010425 */
	0x010426,					/* U+010426 */
	0x010427,					/* U+010427 */
	0x0104b0,					/* U+0104b0 */
	0x0104b1,					/* U+0104b1 */
	0x0104b2,					/* U+0104b2 */
	0x0104b3,					/* U+0104b3 */
	0x0104b4,					/* U+0104b4 */
	0x0104b5,					/* U+0104b5 */
	0x0104b6,					/* U+0104b6 */
	0x0104b7,					/* U+0104b7 */
	0x0104b8,					/* U+0104b8 */
	0x0104b9,					/* U+0104b9 */
	0x0104ba,					/* U+0104ba */
	0x0104bb,					/* U+0104bb */
	0x0104bc,					/* U+0104bc */
	0x0104bd,					/* U+0104bd */
	0x0104be,					/* U+0104be */
	0x0104bf,					/* U+0104bf */
	0x0104c0,					/* U+0104c0 */
	0x0104c1,					/* U+0104c1 */
	0x0104c2,					/* U+0104c2 */
	0x0104c3,					/* U+0104c3 */
	0x0104c4,					/* U+0104c4 */
	0x0104c5,					/* U+0104c5 */
	0x0104c6,					/* U+0104c6 */
	0x0104c7,					/* U+0104c7 */
	0x0104c8,					/* U+0104c8 */
	0x0104c9,					/* U+0104c9 */
	0x0104ca,					/* U+0104ca */
	0x0104cb,					/* U+0104cb */
	0x0104cc,					/* U+0104cc */
	0x0104cd,					/* U+0104cd */
	0x0104ce,					/* U+0104ce */
	0x0104cf,					/* U+0104cf */
	0x0104d0,					/* U+0104d0 */
	0x0104d1,					/* U+0104d1 */
	0x0104d2,					/* U+0104d2 */
	0x0104d3,					/* U+0104d3 */
	0x010570,					/* U+010570 */
	0x010571,					/* U+010571 */
	0x010572,					/* U+010572 */
	0x010573,					/* U+010573 */
	0x010574,					/* U+010574 */
	0x010575,					/* U+010575 */
	0x010576,					/* U+010576 */
	0x010577,					/* U+010577 */
	0x010578,					/* U+010578 */
	0x010579,					/* U+010579 */
	0x01057a,					/* U+01057a */
	0x01057c,					/* U+01057c */
	0x01057d,					/* U+01057d */
	0x01057e,					/* U+01057e */
	0x01057f,					/* U+01057f */
	0x010580,					/* U+010580 */
	0x010581,					/* U+010581 */
	0x010582,					/* U+010582 */
	0x010583,					/* U+010583 */
	0x010584,					/* U+010584 */
	0x010585,					/* U+010585 */
	0x010586,					/* U+010586 */
	0x010587,					/* U+010587 */
	0x010588,					/* U+010588 */
	0x010589,					/* U+010589 */
	0x01058a,					/* U+01058a */
	0x01058c,					/* U+01058c */
	0x01058d,					/* U+01058d */
	0x01058e,					/* U+01058e */
	0x01058f,					/* U+01058f */
	0x010590,					/* U+010590 */
	0x010591,					/* U+010591 */
	0x010592,					/* U+010592 */
	0x010594,					/* U+010594 */
	0x010595,					/* U+010595 */
	0x010c80,					/* U+010c80 */
	0x010c81,					/* U+010c81 */
	0x010c82,					/* U+010c82 */
	0x010c83,					/* U+010c83 */
	0x010c84,					/* U+010c84 */
	0x010c85,					/* U+010c85 */
	0x010c86,					/* U+010c86 */
	0x010c87,					/* U+010c87 */
	0x010c88,					/* U+010c88 */
	0x010c89,					/* U+010c89 */
	0x010c8a,					/* U+010c8a */
	0x010c8b,					/* U+010c8b */
	0x010c8c,					/* U+010c8c */
	0x010c8d,					/* U+010c8d */
	0x010c8e,					/* U+010c8e */
	0x010c8f,					/* U+010c8f */
	0x010c90,					/* U+010c90 */
	0x010c91,					/* U+010c91 */
	0x010c92,					/* U+010c92 */
	0x010c93,					/* U+010c93 */
	0x010c94,					/* U+010c94 */
	0x010c95,					/* U+010c95 */
	0x010c96,					/* U+010c96 */
	0x010c97,					/* U+010c97 */
	0x010c98,					/* U+010c98 */
	0x010c99,					/* U+010c99 */
	0x010c9a,					/* U+010c9a */
	0x010c9b,					/* U+010c9b */
	0x010c9c,					/* U+010c9c */
	0x010c9d,					/* U+010c9d */
	0x010c9e,					/* U+010c9e */
	0x010c9f,					/* U+010c9f */
	0x010ca0,					/* U+010ca0 */
	0x010ca1,					/* U+010ca1 */
	0x010ca2,					/* U+010ca2 */
	0x010ca3,					/* U+010ca3 */
	0x010ca4,					/* U+010ca4 */
	0x010ca5,					/* U+010ca5 */
	0x010ca6,					/* U+010ca6 */
	0x010ca7,					/* U+010ca7 */
	0x010ca8,					/* U+010ca8 */
	0x010ca9,					/* U+010ca9 */
	0x010caa,					/* U+010caa */
	0x010cab,					/* U+010cab */
	0x010cac,					/* U+010cac */
	0x010cad,					/* U+010cad */
	0x010cae,					/* U+010cae */
	0x010caf,					/* U+010caf */
	0x010cb0,					/* U+010cb0 */
	0x010cb1,					/* U+010cb1 */
	0x010cb2,					/* U+010cb2 */
	0x010d50,					/* U+010d50 */
	0x010d51,					/* U+010d51 */
	0x010d52,					/* U+010d52 */
	0x010d53,					/* U+010d53 */
	0x010d54,					/* U+010d54 */
	0x010d55,					/* U+010d55 */
	0x010d56,					/* U+010d56 */
	0x010d57,					/* U+010d57 */
	0x010d58,					/* U+010d58 */
	0x010d59,					/* U+010d59 */
	0x010d5a,					/* U+010d5a */
	0x010d5b,					/* U+010d5b */
	0x010d5c,					/* U+010d5c */
	0x010d5d,					/* U+010d5d */
	0x010d5e,					/* U+010d5e */
	0x010d5f,					/* U+010d5f */
	0x010d60,					/* U+010d60 */
	0x010d61,					/* U+010d61 */
	0x010d62,					/* U+010d62 */
	0x010d63,					/* U+010d63 */
	0x010d64,					/* U+010d64 */
	0x010d65,					/* U+010d65 */
	0x0118a0,					/* U+0118a0 */
	0x0118a1,					/* U+0118a1 */
	0x0118a2,					/* U+0118a2 */
	0x0118a3,					/* U+0118a3 */
	0x0118a4,					/* U+0118a4 */
	0x0118a5,					/* U+0118a5 */
	0x0118a6,					/* U+0118a6 */
	0x0118a7,					/* U+0118a7 */
	0x0118a8,					/* U+0118a8 */
	0x0118a9,					/* U+0118a9 */
	0x0118aa,					/* U+0118aa */
	0x0118ab,					/* U+0118ab */
	0x0118ac,					/* U+0118ac */
	0x0118ad,					/* U+0118ad */
	0x0118ae,					/* U+0118ae */
	0x0118af,					/* U+0118af */
	0x0118b0,					/* U+0118b0 */
	0x0118b1,					/* U+0118b1 */
	0x0118b2,					/* U+0118b2 */
	0x0118b3,					/* U+0118b3 */
	0x0118b4,					/* U+0118b4 */
	0x0118b5,					/* U+0118b5 */
	0x0118b6,					/* U+0118b6 */
	0x0118b7,					/* U+0118b7 */
	0x0118b8,					/* U+0118b8 */
	0x0118b9,					/* U+0118b9 */
	0x0118ba,					/* U+0118ba */
	0x0118bb,					/* U+0118bb */
	0x0118bc,					/* U+0118bc */
	0x0118bd,					/* U+0118bd */
	0x0118be,					/* U+0118be */
	0x0118bf,					/* U+0118bf */
	0x016e40,					/* U+016e40 */
	0x016e41,					/* U+016e41 */
	0x016e42,					/* U+016e42 */
	0x016e43,					/* U+016e43 */
	0x016e44,					/* U+016e44 */
	0x016e45,					/* U+016e45 */
	0x016e46,					/* U+016e46 */
	0x016e47,					/* U+016e47 */
	0x016e48,					/* U+016e48 */
	0x016e49,					/* U+016e49 */
	0x016e4a,					/* U+016e4a */
	0x016e4b,					/* U+016e4b */
	0x016e4c,					/* U+016e4c */
	0x016e4d,					/* U+016e4d */
	0x016e4e,					/* U+016e4e */
	0x016e4f,					/* U+016e4f */
	0x016e50,					/* U+016e50 */
	0x016e51,					/* U+016e51 */
	0x016e52,					/* U+016e52 */
	0x016e53,					/* U+016e53 */
	0x016e54,					/* U+016e54 */
	0x016e55,					/* U+016e55 */
	0x016e56,					/* U+016e56 */
	0x016e57,					/* U+016e57 */
	0x016e58,					/* U+016e58 */
	0x016e59,					/* U+016e59 */
	0x016e5a,					/* U+016e5a */
	0x016e5b,					/* U+016e5b */
	0x016e5c,					/* U+016e5c */
	0x016e5d,					/* U+016e5d */
	0x016e5e,					/* U+016e5e */
	0x016e5f,					/* U+016e5f */
	0x01e900,					/* U+01e900 */
	0x01e901,					/* U+01e901 */
	0x01e902,					/* U+01e902 */
	0x01e903,					/* U+01e903 */
	0x01e904,					/* U+01e904 */
	0x01e905,					/* U+01e905 */
	0x01e906,					/* U+01e906 */
	0x01e907,					/* U+01e907 */
	0x01e908,					/* U+01e908 */
	0x01e909,					/* U+01e909 */
	0x01e90a,					/* U+01e90a */
	0x01e90b,					/* U+01e90b */
	0x01e90c,					/* U+01e90c */
	0x01e90d,					/* U+01e90d */
	0x01e90e,					/* U+01e90e */
	0x01e90f,					/* U+01e90f */
	0x01e910,					/* U+01e910 */
	0x01e911,					/* U+01e911 */
	0x01e912,					/* U+01e912 */
	0x01e913,					/* U+01e913 */
	0x01e914,					/* U+01e914 */
	0x01e915,					/* U+01e915 */
	0x01e916,					/* U+01e916 */
	0x01e917,					/* U+01e917 */
	0x01e918,					/* U+01e918 */
	0x01e919,					/* U+01e919 */
	0x01e91a,					/* U+01e91a */
	0x01e91b,					/* U+01e91b */
	0x01e91c,					/* U+01e91c */
	0x01e91d,					/* U+01e91d */
	0x01e91e,					/* U+01e91e */
	0x01e91f,					/* U+01e91f */
	0x01e920,					/* U+01e920 */
	0x01e921,					/* U+01e921 */

};

/*
 * The entry case_map_fold[case_index(codepoint)] is the mapping for the
 * given codepoint.
 */
static const pg_wchar case_map_fold[1704] =
{
	0x000000,					/* reserved */
	0x000000,					/* U+000000 */
	0x000001,					/* U+000001 */
	0x000002,					/* U+000002 */
	0x000003,					/* U+000003 */
	0x000004,					/* U+000004 */
	0x000005,					/* U+000005 */
	0x000006,					/* U+000006 */
	0x000007,					/* U+000007 */
	0x000008,					/* U+000008 */
	0x000009,					/* U+000009 */
	0x00000a,					/* U+00000a */
	0x00000b,					/* U+00000b */
	0x00000c,					/* U+00000c */
	0x00000d,					/* U+00000d */
	0x00000e,					/* U+00000e */
	0x00000f,					/* U+00000f */
	0x000010,					/* U+000010 */
	0x000011,					/* U+000011 */
	0x000012,					/* U+000012 */
	0x000013,					/* U+000013 */
	0x000014,					/* U+000014 */
	0x000015,					/* U+000015 */
	0x000016,					/* U+000016 */
	0x000017,					/* U+000017 */
	0x000018,					/* U+000018 */
	0x000019,					/* U+000019 */
	0x00001a,					/* U+00001a */
	0x00001b,					/* U+00001b */
	0x00001c,					/* U+00001c */
	0x00001d,					/* U+00001d */
	0x00001e,					/* U+00001e */
	0x00001f,					/* U+00001f */
	0x000020,					/* U+000020 */
	0x000021,					/* U+000021 */
	0x000022,					/* U+000022 */
	0x000023,					/* U+000023 */
	0x000024,					/* U+000024 */
	0x000025,					/* U+000025 */
	0x000026,					/* U+000026 */
	0x000027,					/* U+000027 */
	0x000028,					/* U+000028 */
	0x000029,					/* U+000029 */
	0x00002a,					/* U+00002a */
	0x00002b,					/* U+00002b */
	0x00002c,					/* U+00002c */
	0x00002d,					/* U+00002d */
	0x00002e,					/* U+00002e */
	0x00002f,					/* U+00002f */
	0x000030,					/* U+000030 */
	0x000031,					/* U+000031 */
	0x000032,					/* U+000032 */
	0x000033,					/* U+000033 */
	0x000034,					/* U+000034 */
	0x000035,					/* U+000035 */
	0x000036,					/* U+000036 */
	0x000037,					/* U+000037 */
	0x000038,					/* U+000038 */
	0x000039,					/* U+000039 */
	0x00003a,					/* U+00003a */
	0x00003b,					/* U+00003b */
	0x00003c,					/* U+00003c */
	0x00003d,					/* U+00003d */
	0x00003e,					/* U+00003e */
	0x00003f,					/* U+00003f */
	0x000040,					/* U+000040 */
	0x000061,					/* U+000041 */
	0x000062,					/* U+000042 */
	0x000063,					/* U+000043 */
	0x000064,					/* U+000044 */
	0x000065,					/* U+000045 */
	0x000066,					/* U+000046 */
	0x000067,					/* U+000047 */
	0x000068,					/* U+000048 */
	0x000069,					/* U+000049 */
	0x00006a,					/* U+00004a */
	0x00006b,					/* U+00004b */
	0x00006c,					/* U+00004c */
	0x00006d,					/* U+00004d */
	0x00006e,					/* U+00004e */
	0x00006f,					/* U+00004f */
	0x000070,					/* U+000050 */
	0x000071,					/* U+000051 */
	0x000072,					/* U+000052 */
	0x000073,					/* U+000053 */
	0x000074,					/* U+000054 */
	0x000075,					/* U+000055 */
	0x000076,					/* U+000056 */
	0x000077,					/* U+000057 */
	0x000078,					/* U+000058 */
	0x000079,					/* U+000059 */
	0x00007a,					/* U+00005a */
	0x00005b,					/* U+00005b */
	0x00005c,					/* U+00005c */
	0x00005d,					/* U+00005d */
	0x00005e,					/* U+00005e */
	0x00005f,					/* U+00005f */
	0x000060,					/* U+000060 */
	0x000061,					/* U+000061 */
	0x000062,					/* U+000062 */
	0x000063,					/* U+000063 */
	0x000064,					/* U+000064 */
	0x000065,					/* U+000065 */
	0x000066,					/* U+000066 */
	0x000067,					/* U+000067 */
	0x000068,					/* U+000068 */
	0x000069,					/* U+000069 */
	0x00006a,					/* U+00006a */
	0x00006b,					/* U+00006b */
	0x00006c,					/* U+00006c */
	0x00006d,					/* U+00006d */
	0x00006e,					/* U+00006e */
	0x00006f,					/* U+00006f */
	0x000070,					/* U+000070 */
	0x000071,					/* U+000071 */
	0x000072,					/* U+000072 */
	0x000073,					/* U+000073 */
	0x000074,					/* U+000074 */
	0x000075,					/* U+000075 */
	0x000076,					/* U+000076 */
	0x000077,					/* U+000077 */
	0x000078,					/* U+000078 */
	0x000079,					/* U+000079 */
	0x00007a,					/* U+00007a */
	0x00007b,					/* U+00007b */
	0x00007c,					/* U+00007c */
	0x00007d,					/* U+00007d */
	0x00007e,					/* U+00007e */
	0x00007f,					/* U+00007f */
	0x0003bc,					/* U+0000b5 */
	0x0000e0,					/* U+0000c0 */
	0x0000e1,					/* U+0000c1 */
	0x0000e2,					/* U+0000c2 */
	0x0000e3,					/* U+0000c3 */
	0x0000e4,					/* U+0000c4 */
	0x0000e5,					/* U+0000c5 */
	0x0000e6,					/* U+0000c6 */
	0x0000e7,					/* U+0000c7 */
	0x0000e8,					/* U+0000c8 */
	0x0000e9,					/* U+0000c9 */
	0x0000ea,					/* U+0000ca */
	0x0000eb,					/* U+0000cb */
	0x0000ec,					/* U+0000cc */
	0x0000ed,					/* U+0000cd */
	0x0000ee,					/* U+0000ce */
	0x0000ef,					/* U+0000cf */
	0x0000f0,					/* U+0000d0 */
	0x0000f1,					/* U+0000d1 */
	0x0000f2,					/* U+0000d2 */
	0x0000f3,					/* U+0000d3 */
	0x0000f4,					/* U+0000d4 */
	0x0000f5,					/* U+0000d5 */
	0x0000f6,					/* U+0000d6 */
	0x0000f8,					/* U+0000d8 */
	0x0000f9,					/* U+0000d9 */
	0x0000fa,					/* U+0000da */
	0x0000fb,					/* U+0000db */
	0x0000fc,					/* U+0000dc */
	0x0000fd,					/* U+0000dd */
	0x0000fe,					/* U+0000de */
	0x0000df,					/* U+0000df */
	0x0000ff,					/* U+0000ff */
	0x000101,					/* U+000100 */
	0x000103,					/* U+000102 */
	0x000105,					/* U+000104 */
	0x000107,					/* U+000106 */
	0x000109,					/* U+000108 */
	0x00010b,					/* U+00010a */
	0x00010d,					/* U+00010c */
	0x00010f,					/* U+00010e */
	0x000111,					/* U+000110 */
	0x000113,					/* U+000112 */
	0x000115,					/* U+000114 */
	0x000117,					/* U+000116 */
	0x000119,					/* U+000118 */
	0x00011b,					/* U+00011a */
	0x00011d,					/* U+00011c */
	0x00011f,					/* U+00011e */
	0x000121,					/* U+000120 */
	0x000123,					/* U+000122 */
	0x000125,					/* U+000124 */
	0x000127,					/* U+000126 */
	0x000129,					/* U+000128 */
	0x00012b,					/* U+00012a */
	0x00012d,					/* U+00012c */
	0x00012f,					/* U+00012e */
	0x000130,					/* U+000130 */
	0x000131,					/* U+000131 */
	0x000133,					/* U+000132 */
	0x000135,					/* U+000134 */
	0x000137,					/* U+000136 */
	0x00013a,					/* U+000139 */
	0x00013c,					/* U+00013b */
	0x00013e,					/* U+00013d */
	0x000140,					/* U+00013f */
	0x000142,					/* U+000141 */
	0x000144,					/* U+000143 */
	0x000146,					/* U+000145 */
	0x000148,					/* U+000147 */
	0x000149,					/* U+000149 */
	0x00014b,					/* U+00014a */
	0x00014d,					/* U+00014c */
	0x00014f,					/* U+00014e */
	0x000151,					/* U+000150 */
	0x000153,					/* U+000152 */
	0x000155,					/* U+000154 */
	0x000157,					/* U+000156 */
	0x000159,					/* U+000158 */
	0x00015b,					/* U+00015a */
	0x00015d,					/* U+00015c */
	0x00015f,					/* U+00015e */
	0x000161,					/* U+000160 */
	0x000163,					/* U+000162 */
	0x000165,					/* U+000164 */
	0x000167,					/* U+000166 */
	0x000169,					/* U+000168 */
	0x00016b,					/* U+00016a */
	0x00016d,					/* U+00016c */
	0x00016f,					/* U+00016e */
	0x000171,					/* U+000170 */
	0x000173,					/* U+000172 */
	0x000175,					/* U+000174 */
	0x000177,					/* U+000176 */
	0x00017a,					/* U+000179 */
	0x00017c,					/* U+00017b */
	0x00017e,					/* U+00017d */
	0x000073,					/* U+00017f */
	0x000180,					/* U+000180 */
	0x000253,					/* U+000181 */
	0x000183,					/* U+000182 */
	0x000185,					/* U+000184 */
	0x000254,					/* U+000186 */
	0x000188,					/* U+000187 */
	0x000256,					/* U+000189 */
	0x000257,					/* U+00018a */
	0x00018c,					/* U+00018b */
	0x0001dd,					/* U+00018e */
	0x000259,					/* U+00018f */
	0x00025b,					/* U+000190 */
	0x000192,					/* U+000191 */
	0x000260,					/* U+000193 */
	0x000263,					/* U+000194 */
	0x000195,					/* U+000195 */
	0x000269,					/* U+000196 */
	0x000268,					/* U+000197 */
	0x000199,					/* U+000198 */
	0x00019a,					/* U+00019a */
	0x00019b,					/* U+00019b */
	0x00026f,					/* U+00019c */
	0x000272,					/* U+00019d */
	0x00019e,					/* U+00019e */
	0x000275,					/* U+00019f */
	0x0001a1,					/* U+0001a0 */
	0x0001a3,					/* U+0001a2 */
	0x0001a5,					/* U+0001a4 */
	0x000280,					/* U+0001a6 */
	0x0001a8,					/* U+0001a7 */
	0x000283,					/* U+0001a9 */
	0x0001ad,					/* U+0001ac */
	0x000288,					/* U+0001ae */
	0x0001b0,					/* U+0001af */
	0x00028a,					/* U+0001b1 */
	0x00028b,					/* U+0001b2 */
	0x0001b4,					/* U+0001b3 */
	0x0001b6,					/* U+0001b5 */
	0x000292,					/* U+0001b7 */
	0x0001b9,					/* U+0001b8 */
	0x0001bd,					/* U+0001bc */
	0x0001bf,					/* U+0001bf */
	0x0001c6,					/* U+0001c4 */
	0x0001c9,					/* U+0001c7 */
	0x0001cc,					/* U+0001ca */
	0x0001ce,					/* U+0001cd */
	0x0001d0,					/* U+0001cf */
	0x0001d2,					/* U+0001d1 */
	0x0001d4,					/* U+0001d3 */
	0x0001d6,					/* U+0001d5 */
	0x0001d8,					/* U+0001d7 */
	0x0001da,					/* U+0001d9 */
	0x0001dc,					/* U+0001db */
	0x0001df,					/* U+0001de */
	0x0001e1,					/* U+0001e0 */
	0x0001e3,					/* U+0001e2 */
	0x0001e5,					/* U+0001e4 */
	0x0001e7,					/* U+0001e6 */
	0x0001e9,					/* U+0001e8 */
	0x0001eb,					/* U+0001ea */
	0x0001ed,					/* U+0001ec */
	0x0001ef,					/* U+0001ee */
	0x0001f0,					/* U+0001f0 */
	0x0001f3,					/* U+0001f1 */
	0x0001f5,					/* U+0001f4 */
	0x0001f9,					/* U+0001f8 */
	0x0001fb,					/* U+0001fa */
	0x0001fd,					/* U+0001fc */
	0x0001ff,					/* U+0001fe */
	0x000201,					/* U+000200 */
	0x000203,					/* U+000202 */
	0x000205,					/* U+000204 */
	0x000207,					/* U+000206 */
	0x000209,					/* U+000208 */
	0x00020b,					/* U+00020a */
	0x00020d,					/* U+00020c */
	0x00020f,					/* U+00020e */
	0x000211,					/* U+000210 */
	0x000213,					/* U+000212 */
	0x000215,					/* U+000214 */
	0x000217,					/* U+000216 */
	0x000219,					/* U+000218 */
	0x00021b,					/* U+00021a */
	0x00021d,					/* U+00021c */
	0x00021f,					/* U+00021e */
	0x000223,					/* U+000222 */
	0x000225,					/* U+000224 */
	0x000227,					/* U+000226 */
	0x000229,					/* U+000228 */
	0x00022b,					/* U+00022a */
	0x00022d,					/* U+00022c */
	0x00022f,					/* U+00022e */
	0x000231,					/* U+000230 */
	0x000233,					/* U+000232 */
	0x002c65,					/* U+00023a */
	0x00023c,					/* U+00023b */
	0x002c66,					/* U+00023e */
	0x00023f,					/* U+00023f */
	0x000240,					/* U+000240 */
	0x000242,					/* U+000241 */
	0x000289,					/* U+000244 */
	0x00028c,					/* U+000245 */
	0x000247,					/* U+000246 */
	0x000249,					/* U+000248 */
	0x00024b,					/* U+00024a */
	0x00024d,					/* U+00024c */
	0x00024f,					/* U+00024e */
	0x000250,					/* U+000250 */
	0x000251,					/* U+000251 */
	0x000252,					/* U+000252 */
	0x00025c,					/* U+00025c */
	0x000261,					/* U+000261 */
	0x000264,					/* U+000264 */
	0x000265,					/* U+000265 */
	0x000266,					/* U+000266 */
	0x00026a,					/* U+00026a */
	0x00026b,					/* U+00026b */
	0x00026c,					/* U+00026c */
	0x000271,					/* U+000271 */
	0x00027d,					/* U+00027d */
	0x000282,					/* U+000282 */
	0x000287,					/* U+000287 */
	0x00029d,					/* U+00029d */
	0x00029e,					/* U+00029e */
	0x0003b9,					/* U+000345 */
	0x000371,					/* U+000370 */
	0x000373,					/* U+000372 */
	0x000377,					/* U+000376 */
	0x00037b,					/* U+00037b */
	0x00037c,					/* U+00037c */
	0x00037d,					/* U+00037d */
	0x0003f3,					/* U+00037f */
	0x0003ac,					/* U+000386 */
	0x0003ad,					/* U+000388 */
	0x0003ae,					/* U+000389 */
	0x0003af,					/* U+00038a */
	0x0003cc,					/* U+00038c */
	0x0003cd,					/* U+00038e */
	0x0003ce,					/* U+00038f */
	0x000390,					/* U+000390 */
	0x0003b1,					/* U+000391 */
	0x0003b2,					/* U+000392 */
	0x0003b3,					/* U+000393 */
	0x0003b4,					/* U+000394 */
	0x0003b5,					/* U+000395 */
	0x0003b6,					/* U+000396 */
	0x0003b7,					/* U+000397 */
	0x0003b8,					/* U+000398 */
	0x0003b9,					/* U+000399 */
	0x0003ba,					/* U+00039a */
	0x0003bb,					/* U+00039b */
	0x0003bc,					/* U+00039c */
	0x0003bd,					/* U+00039d */
	0x0003be,					/* U+00039e */
	0x0003bf,					/* U+00039f */
	0x0003c0,					/* U+0003a0 */
	0x0003c1,					/* U+0003a1 */
	0x0003c3,					/* U+0003a3 */
	0x0003c4,					/* U+0003a4 */
	0x0003c5,					/* U+0003a5 */
	0x0003c6,					/* U+0003a6 */
	0x0003c7,					/* U+0003a7 */
	0x0003c8,					/* U+0003a8 */
	0x0003c9,					/* U+0003a9 */
	0x0003ca,					/* U+0003aa */
	0x0003cb,					/* U+0003ab */
	0x0003b0,					/* U+0003b0 */
	0x0003c3,					/* U+0003c2 */
	0x0003c3,					/* U+0003c3 */
	0x0003d7,					/* U+0003cf */
	0x0003b2,					/* U+0003d0 */
	0x0003b8,					/* U+0003d1 */
	0x0003c6,					/* U+0003d5 */
	0x0003c0,					/* U+0003d6 */
	0x0003d9,					/* U+0003d8 */
	0x0003db,					/* U+0003da */
	0x0003dd,					/* U+0003dc */
	0x0003df,					/* U+0003de */
	0x0003e1,					/* U+0003e0 */
	0x0003e3,					/* U+0003e2 */
	0x0003e5,					/* U+0003e4 */
	0x0003e7,					/* U+0003e6 */
	0x0003e9,					/* U+0003e8 */
	0x0003eb,					/* U+0003ea */
	0x0003ed,					/* U+0003ec */
	0x0003ef,					/* U+0003ee */
	0x0003ba,					/* U+0003f0 */
	0x0003c1,					/* U+0003f1 */
	0x0003f2,					/* U+0003f2 */
	0x0003b8,					/* U+0003f4 */
	0x0003b5,					/* U+0003f5 */
	0x0003f8,					/* U+0003f7 */
	0x0003fb,					/* U+0003fa */
	0x000450,					/* U+000400 */
	0x000451,					/* U+000401 */
	0x000452,					/* U+000402 */
	0x000453,					/* U+000403 */
	0x000454,					/* U+000404 */
	0x000455,					/* U+000405 */
	0x000456,					/* U+000406 */
	0x000457,					/* U+000407 */
	0x000458,					/* U+000408 */
	0x000459,					/* U+000409 */
	0x00045a,					/* U+00040a */
	0x00045b,					/* U+00040b */
	0x00045c,					/* U+00040c */
	0x00045d,					/* U+00040d */
	0x00045e,					/* U+00040e */
	0x00045f,					/* U+00040f */
	0x000430,					/* U+000410 */
	0x000431,					/* U+000411 */
	0x000432,					/* U+000412 */
	0x000433,					/* U+000413 */
	0x000434,					/* U+000414 */
	0x000435,					/* U+000415 */
	0x000436,					/* U+000416 */
	0x000437,					/* U+000417 */
	0x000438,					/* U+000418 */
	0x000439,					/* U+000419 */
	0x00043a,					/* U+00041a */
	0x00043b,					/* U+00041b */
	0x00043c,					/* U+00041c */
	0x00043d,					/* U+00041d */
	0x00043e,					/* U+00041e */
	0x00043f,					/* U+00041f */
	0x000440,					/* U+000420 */
	0x000441,					/* U+000421 */
	0x000442,					/* U+000422 */
	0x000443,					/* U+000423 */
	0x000444,					/* U+000424 */
	0x000445,					/* U+000425 */
	0x000446,					/* U+000426 */
	0x000447,					/* U+000427 */
	0x000448,					/* U+000428 */
	0x000449,					/* U+000429 */
	0x00044a,					/* U+00042a */
	0x00044b,					/* U+00042b */
	0x00044c,					/* U+00042c */
	0x00044d,					/* U+00042d */
	0x00044e,					/* U+00042e */
	0x00044f,					/* U+00042f */
	0x000461,					/* U+000460 */
	0x000463,					/* U+000462 */
	0x000465,					/* U+000464 */
	0x000467,					/* U+000466 */
	0x000469,					/* U+000468 */
	0x00046b,					/* U+00046a */
	0x00046d,					/* U+00046c */
	0x00046f,					/* U+00046e */
	0x000471,					/* U+000470 */
	0x000473,					/* U+000472 */
	0x000475,					/* U+000474 */
	0x000477,					/* U+000476 */
	0x000479,					/* U+000478 */
	0x00047b,					/* U+00047a */
	0x00047d,					/* U+00047c */
	0x00047f,					/* U+00047e */
	0x000481,					/* U+000480 */
	0x00048b,					/* U+00048a */
	0x00048d,					/* U+00048c */
	0x00048f,					/* U+00048e */
	0x000491,					/* U+000490 */
	0x000493,					/* U+000492 */
	0x000495,					/* U+000494 */
	0x000497,					/* U+000496 */
	0x000499,					/* U+000498 */
	0x00049b,					/* U+00049a */
	0x00049d,					/* U+00049c */
	0x00049f,					/* U+00049e */
	0x0004a1,					/* U+0004a0 */
	0x0004a3,					/* U+0004a2 */
	0x0004a5,					/* U+0004a4 */
	0x0004a7,					/* U+0004a6 */
	0x0004a9,					/* U+0004a8 */
	0x0004ab,					/* U+0004aa */
	0x0004ad,					/* U+0004ac */
	0x0004af,					/* U+0004ae */
	0x0004b1,					/* U+0004b0 */
	0x0004b3,					/* U+0004b2 */
	0x0004b5,					/* U+0004b4 */
	0x0004b7,					/* U+0004b6 */
	0x0004b9,					/* U+0004b8 */
	0x0004bb,					/* U+0004ba */
	0x0004bd,					/* U+0004bc */
	0x0004bf,					/* U+0004be */
	0x0004cf,					/* U+0004c0 */
	0x0004c2,					/* U+0004c1 */
	0x0004c4,					/* U+0004c3 */
	0x0004c6,					/* U+0004c5 */
	0x0004c8,					/* U+0004c7 */
	0x0004ca,					/* U+0004c9 */
	0x0004cc,					/* U+0004cb */
	0x0004ce,					/* U+0004cd */
	0x0004d1,					/* U+0004d0 */
	0x0004d3,					/* U+0004d2 */
	0x0004d5,					/* U+0004d4 */
	0x0004d7,					/* U+0004d6 */
	0x0004d9,					/* U+0004d8 */
	0x0004db,					/* U+0004da */
	0x0004dd,					/* U+0004dc */
	0x0004df,					/* U+0004de */
	0x0004e1,					/* U+0004e0 */
	0x0004e3,					/* U+0004e2 */
	0x0004e5,					/* U+0004e4 */
	0x0004e7,					/* U+0004e6 */
	0x0004e9,					/* U+0004e8 */
	0x0004eb,					/* U+0004ea */
	0x0004ed,					/* U+0004ec */
	0x0004ef,					/* U+0004ee */
	0x0004f1,					/* U+0004f0 */
	0x0004f3,					/* U+0004f2 */
	0x0004f5,					/* U+0004f4 */
	0x0004f7,					/* U+0004f6 */
	0x0004f9,					/* U+0004f8 */
	0x0004fb,					/* U+0004fa */
	0x0004fd,					/* U+0004fc */
	0x0004ff,					/* U+0004fe */
	0x000501,					/* U+000500 */
	0x000503,					/* U+000502 */
	0x000505,					/* U+000504 */
	0x000507,					/* U+000506 */
	0x000509,					/* U+000508 */
	0x00050b,					/* U+00050a */
	0x00050d,					/* U+00050c */
	0x00050f,					/* U+00050e */
	0x000511,					/* U+000510 */
	0x000513,					/* U+000512 */
	0x000515,					/* U+000514 */
	0x000517,					/* U+000516 */
	0x000519,					/* U+000518 */
	0x00051b,					/* U+00051a */
	0x00051d,					/* U+00051c */
	0x00051f,					/* U+00051e */
	0x000521,					/* U+000520 */
	0x000523,					/* U+000522 */
	0x000525,					/* U+000524 */
	0x000527,					/* U+000526 */
	0x000529,					/* U+000528 */
	0x00052b,					/* U+00052a */
	0x00052d,					/* U+00052c */
	0x00052f,					/* U+00052e */
	0x000561,					/* U+000531 */
	0x000562,					/* U+000532 */
	0x000563,					/* U+000533 */
	0x000564,					/* U+000534 */
	0x000565,					/* U+000535 */
	0x000566,					/* U+000536 */
	0x000567,					/* U+000537 */
	0x000568,					/* U+000538 */
	0x000569,					/* U+000539 */
	0x00056a,					/* U+00053a */
	0x00056b,					/* U+00053b */
	0x00056c,					/* U+00053c */
	0x00056d,					/* U+00053d */
	0x00056e,					/* U+00053e */
	0x00056f,					/* U+00053f */
	0x000570,					/* U+000540 */
	0x000571,					/* U+000541 */
	0x000572,					/* U+000542 */
	0x000573,					/* U+000543 */
	0x000574,					/* U+000544 */
	0x000575,					/* U+000545 */
	0x000576,					/* U+000546 */
	0x000577,					/* U+000547 */
	0x000578,					/* U+000548 */
	0x000579,					/* U+000549 */
	0x00057a,					/* U+00054a */
	0x00057b,					/* U+00054b */
	0x00057c,					/* U+00054c */
	0x00057d,					/* U+00054d */
	0x00057e,					/* U+00054e */
	0x00057f,					/* U+00054f */
	0x000580,					/* U+000550 */
	0x000581,					/* U+000551 */
	0x000582,					/* U+000552 */
	0x000583,					/* U+000553 */
	0x000584,					/* U+000554 */
	0x000585,					/* U+000555 */
	0x000586,					/* U+000556 */
	0x000587,					/* U+000587 */
	0x002d00,					/* U+0010a0 */
	0x002d01,					/* U+0010a1 */
	0x002d02,					/* U+0010a2 */
	0x002d03,					/* U+0010a3 */
	0x002d04,					/* U+0010a4 */
	0x002d05,					/* U+0010a5 */
	0x002d06,					/* U+0010a6 */
	0x002d07,					/* U+0010a7 */
	0x002d08,					/* U+0010a8 */
	0x002d09,					/* U+0010a9 */
	0x002d0a,					/* U+0010aa */
	0x002d0b,					/* U+0010ab */
	0x002d0c,					/* U+0010ac */
	0x002d0d,					/* U+0010ad */
	0x002d0e,					/* U+0010ae */
	0x002d0f,					/* U+0010af */
	0x002d10,					/* U+0010b0 */
	0x002d11,					/* U+0010b1 */
	0x002d12,					/* U+0010b2 */
	0x002d13,					/* U+0010b3 */
	0x002d14,					/* U+0010b4 */
	0x002d15,					/* U+0010b5 */
	0x002d16,					/* U+0010b6 */
	0x002d17,					/* U+0010b7 */
	0x002d18,					/* U+0010b8 */
	0x002d19,					/* U+0010b9 */
	0x002d1a,					/* U+0010ba */
	0x002d1b,					/* U+0010bb */
	0x002d1c,					/* U+0010bc */
	0x002d1d,					/* U+0010bd */
	0x002d1e,					/* U+0010be */
	0x002d1f,					/* U+0010bf */
	0x002d20,					/* U+0010c0 */
	0x002d21,					/* U+0010c1 */
	0x002d22,					/* U+0010c2 */
	0x002d23,					/* U+0010c3 */
	0x002d24,					/* U+0010c4 */
	0x002d25,					/* U+0010c5 */
	0x002d27,					/* U+0010c7 */
	0x002d2d,					/* U+0010cd */
	0x0010d0,					/* U+0010d0 */
	0x0010d1,					/* U+0010d1 */
	0x0010d2,					/* U+0010d2 */
	0x0010d3,					/* U+0010d3 */
	0x0010d4,					/* U+0010d4 */
	0x0010d5,					/* U+0010d5 */
	0x0010d6,					/* U+0010d6 */
	0x0010d7,					/* U+0010d7 */
	0x0010d8,					/* U+0010d8 */
	0x0010d9,					/* U+0010d9 */
	0x0010da,					/* U+0010da */
	0x0010db,					/* U+0010db */
	0x0010dc,					/* U+0010dc */
	0x0010dd,					/* U+0010dd */
	0x0010de,					/* U+0010de */
	0x0010df,					/* U+0010df */
	0x0010e0,					/* U+0010e0 */
	0x0010e1,					/* U+0010e1 */
	0x0010e2,					/* U+0010e2 */
	0x0010e3,					/* U+0010e3 */
	0x0010e4,					/* U+0010e4 */
	0x0010e5,					/* U+0010e5 */
	0x0010e6,					/* U+0010e6 */
	0x0010e7,					/* U+0010e7 */
	0x0010e8,					/* U+0010e8 */
	0x0010e9,					/* U+0010e9 */
	0x0010ea,					/* U+0010ea */
	0x0010eb,					/* U+0010eb */
	0x0010ec,					/* U+0010ec */
	0x0010ed,					/* U+0010ed */
	0x0010ee,					/* U+0010ee */
	0x0010ef,					/* U+0010ef */
	0x0010f0,					/* U+0010f0 */
	0x0010f1,					/* U+0010f1 */
	0x0010f2,					/* U+0010f2 */
	0x0010f3,					/* U+0010f3 */
	0x0010f4,					/* U+0010f4 */
	0x0010f5,					/* U+0010f5 */
	0x0010f6,					/* U+0010f6 */
	0x0010f7,					/* U+0010f7 */
	0x0010f8,					/* U+0010f8 */
	0x0010f9,					/* U+0010f9 */
	0x0010fa,					/* U+0010fa */
	0x0010fd,					/* U+0010fd */
	0x0010fe,					/* U+0010fe */
	0x0010ff,					/* U+0010ff */
	0x0013a0,					/* U+0013a0 */
	0x0013a1,					/* U+0013a1 */
	0x0013a2,					/* U+0013a2 */
	0x0013a3,					/* U+0013a3 */
	0x0013a4,					/* U+0013a4 */
	0x0013a5,					/* U+0013a5 */
	0x0013a6,					/* U+0013a6 */
	0x0013a7,					/* U+0013a7 */
	0x0013a8,					/* U+0013a8 */
	0x0013a9,					/* U+0013a9 */
	0x0013aa,					/* U+0013aa */
	0x0013ab,					/* U+0013ab */
	0x0013ac,					/* U+0013ac */
	0x0013ad,					/* U+0013ad */
	0x0013ae,					/* U+0013ae */
	0x0013af,					/* U+0013af */
	0x0013b0,					/* U+0013b0 */
	0x0013b1,					/* U+0013b1 */
	0x0013b2,					/* U+0013b2 */
	0x0013b3,					/* U+0013b3 */
	0x0013b4,					/* U+0013b4 */
	0x0013b5,					/* U+0013b5 */
	0x0013b6,					/* U+0013b6 */
	0x0013b7,					/* U+0013b7 */
	0x0013b8,					/* U+0013b8 */
	0x0013b9,					/* U+0013b9 */
	0x0013ba,					/* U+0013ba */
	0x0013bb,					/* U+0013bb */
	0x0013bc,					/* U+0013bc */
	0x0013bd,					/* U+0013bd */
	0x0013be,					/* U+0013be */
	0x0013bf,					/* U+0013bf */
	0x0013c0,					/* U+0013c0 */
	0x0013c1,					/* U+0013c1 */
	0x0013c2,					/* U+0013c2 */
	0x0013c3,					/* U+0013c3 */
	0x0013c4,					/* U+0013c4 */
	0x0013c5,					/* U+0013c5 */
	0x0013c6,					/* U+0013c6 */
	0x0013c7,					/* U+0013c7 */
	0x0013c8,					/* U+0013c8 */
	0x0013c9,					/* U+0013c9 */
	0x0013ca,					/* U+0013ca */
	0x0013cb,					/* U+0013cb */
	0x0013cc,					/* U+0013cc */
	0x0013cd,					/* U+0013cd */
	0x0013ce,					/* U+0013ce */
	0x0013cf,					/* U+0013cf */
	0x0013d0,					/* U+0013d0 */
	0x0013d1,					/* U+0013d1 */
	0x0013d2,					/* U+0013d2 */
	0x0013d3,					/* U+0013d3 */
	0x0013d4,					/* U+0013d4 */
	0x0013d5,					/* U+0013d5 */
	0x0013d6,					/* U+0013d6 */
	0x0013d7,					/* U+0013d7 */
	0x0013d8,					/* U+0013d8 */
	0x0013d9,					/* U+0013d9 */
	0x0013da,					/* U+0013da */
	0x0013db,					/* U+0013db */
	0x0013dc,					/* U+0013dc */
	0x0013dd,					/* U+0013dd */
	0x0013de,					/* U+0013de */
	0x0013df,					/* U+0013df */
	0x0013e0,					/* U+0013e0 */
	0x0013e1,					/* U+0013e1 */
	0x0013e2,					/* U+0013e2 */
	0x0013e3,					/* U+0013e3 */
	0x0013e4,					/* U+0013e4 */
	0x0013e5,					/* U+0013e5 */
	0x0013e6,					/* U+0013e6 */
	0x0013e7,					/* U+0013e7 */
	0x0013e8,					/* U+0013e8 */
	0x0013e9,					/* U+0013e9 */
	0x0013ea,					/* U+0013ea */
	0x0013eb,					/* U+0013eb */
	0x0013ec,					/* U+0013ec */
	0x0013ed,					/* U+0013ed */
	0x0013ee,					/* U+0013ee */
	0x0013ef,					/* U+0013ef */
	0x0013f0,					/* U+0013f0 */
	0x0013f1,					/* U+0013f1 */
	0x0013f2,					/* U+0013f2 */
	0x0013f3,					/* U+0013f3 */
	0x0013f4,					/* U+0013f4 */
	0x0013f5,					/* U+0013f5 */
	0x000432,					/* U+001c80 */
	0x000434,					/* U+001c81 */
	0x00043e,					/* U+001c82 */
	0x000441,					/* U+001c83 */
	0x000442,					/* U+001c84 */
	0x000442,					/* U+001c85 */
	0x00044a,					/* U+001c86 */
	0x000463,					/* U+001c87 */
	0x00a64b,					/* U+001c88 */
	0x001c8a,					/* U+001c89 */
	0x0010d0,					/* U+001c90 */
	0x0010d1,					/* U+001c91 */
	0x0010d2,					/* U+001c92 */
	0x0010d3,					/* U+001c93 */
	0x0010d4,					/* U+001c94 */
	0x0010d5,					/* U+001c95 */
	0x0010d6,					/* U+001c96 */
	0x0010d7,					/* U+001c97 */
	0x0010d8,					/* U+001c98 */
	0x0010d9,					/* U+001c99 */
	0x0010da,					/* U+001c9a */
	0x0010db,					/* U+001c9b */
	0x0010dc,					/* U+001c9c */
	0x0010dd,					/* U+001c9d */
	0x0010de,					/* U+001c9e */
	0x0010df,					/* U+001c9f */
	0x0010e0,					/* U+001ca0 */
	0x0010e1,					/* U+001ca1 */
	0x0010e2,					/* U+001ca2 */
	0x0010e3,					/* U+001ca3 */
	0x0010e4,					/* U+001ca4 */
	0x0010e5,					/* U+001ca5 */
	0x0010e6,					/* U+001ca6 */
	0x0010e7,					/* U+001ca7 */
	0x0010e8,					/* U+001ca8 */
	0x0010e9,					/* U+001ca9 */
	0x0010ea,					/* U+001caa */
	0x0010eb,					/* U+001cab */
	0x0010ec,					/* U+001cac */
	0x0010ed,					/* U+001cad */
	0x0010ee,					/* U+001cae */
	0x0010ef,					/* U+001caf */
	0x0010f0,					/* U+001cb0 */
	0x0010f1,					/* U+001cb1 */
	0x0010f2,					/* U+001cb2 */
	0x0010f3,					/* U+001cb3 */
	0x0010f4,					/* U+001cb4 */
	0x0010f5,					/* U+001cb5 */
	0x0010f6,					/* U+001cb6 */
	0x0010f7,					/* U+001cb7 */
	0x0010f8,					/* U+001cb8 */
	0x0010f9,					/* U+001cb9 */
	0x0010fa,					/* U+001cba */
	0x0010fd,					/* U+001cbd */
	0x0010fe,					/* U+001cbe */
	0x0010ff,					/* U+001cbf */
	0x001d79,					/* U+001d79 */
	0x001d7d,					/* U+001d7d */
	0x001d8e,					/* U+001d8e */
	0x001e01,					/* U+001e00 */
	0x001e03,					/* U+001e02 */
	0x001e05,					/* U+001e04 */
	0x001e07,					/* U+001e06 */
	0x001e09,					/* U+001e08 */
	0x001e0b,					/* U+001e0a */
	0x001e0d,					/* U+001e0c */
	0x001e0f,					/* U+001e0e */
	0x001e11,					/* U+001e10 */
	0x001e13,					/* U+001e12 */
	0x001e15,					/* U+001e14 */
	0x001e17,					/* U+001e16 */
	0x001e19,					/* U+001e18 */
	0x001e1b,					/* U+001e1a */
	0x001e1d,					/* U+001e1c */
	0x001e1f,					/* U+001e1e */
	0x001e21,					/* U+001e20 */
	0x001e23,					/* U+001e22 */
	0x001e25,					/* U+001e24 */
	0x001e27,					/* U+001e26 */
	0x001e29,					/* U+001e28 */
	0x001e2b,					/* U+001e2a */
	0x001e2d,					/* U+001e2c */
	0x001e2f,					/* U+001e2e */
	0x001e31,					/* U+001e30 */
	0x001e33,					/* U+001e32 */
	0x001e35,					/* U+001e34 */
	0x001e37,					/* U+001e36 */
	0x001e39,					/* U+001e38 */
	0x001e3b,					/* U+001e3a */
	0x001e3d,					/* U+001e3c */
	0x001e3f,					/* U+001e3e */
	0x001e41,					/* U+001e40 */
	0x001e43,					/* U+001e42 */
	0x001e45,					/* U+001e44 */
	0x001e47,					/* U+001e46 */
	0x001e49,					/* U+001e48 */
	0x001e4b,					/* U+001e4a */
	0x001e4d,					/* U+001e4c */
	0x001e4f,					/* U+001e4e */
	0x001e51,					/* U+001e50 */
	0x001e53,					/* U+001e52 */
	0x001e55,					/* U+001e54 */
	0x001e57,					/* U+001e56 */
	0x001e59,					/* U+001e58 */
	0x001e5b,					/* U+001e5a */
	0x001e5d,					/* U+001e5c */
	0x001e5f,					/* U+001e5e */
	0x001e61,					/* U+001e60 */
	0x001e63,					/* U+001e62 */
	0x001e65,					/* U+001e64 */
	0x001e67,					/* U+001e66 */
	0x001e69,					/* U+001e68 */
	0x001e6b,					/* U+001e6a */
	0x001e6d,					/* U+001e6c */
	0x001e6f,					/* U+001e6e */
	0x001e71,					/* U+001e70 */
	0x001e73,					/* U+001e72 */
	0x001e75,					/* U+001e74 */
	0x001e77,					/* U+001e76 */
	0x001e79,					/* U+001e78 */
	0x001e7b,					/* U+001e7a */
	0x001e7d,					/* U+001e7c */
	0x001e7f,					/* U+001e7e */
	0x001e81,					/* U+001e80 */
	0x001e83,					/* U+001e82 */
	0x001e85,					/* U+001e84 */
	0x001e87,					/* U+001e86 */
	0x001e89,					/* U+001e88 */
	0x001e8b,					/* U+001e8a */
	0x001e8d,					/* U+001e8c */
	0x001e8f,					/* U+001e8e */
	0x001e91,					/* U+001e90 */
	0x001e93,					/* U+001e92 */
	0x001e95,					/* U+001e94 */
	0x001e96,					/* U+001e96 */
	0x001e97,					/* U+001e97 */
	0x001e98,					/* U+001e98 */
	0x001e99,					/* U+001e99 */
	0x001e9a,					/* U+001e9a */
	0x001e61,					/* U+001e9b */
	0x0000df,					/* U+001e9e */
	0x001ea1,					/* U+001ea0 */
	0x001ea3,					/* U+001ea2 */
	0x001ea5,					/* U+001ea4 */
	0x001ea7,					/* U+001ea6 */
	0x001ea9,					/* U+001ea8 */
	0x001eab,					/* U+001eaa */
	0x001ead,					/* U+001eac */
	0x001eaf,					/* U+001eae */
	0x001eb1,					/* U+001eb0 */
	0x001eb3,					/* U+001eb2 */
	0x001eb5,					/* U+001eb4 */
	0x001eb7,					/* U+001eb6 */
	0x001eb9,					/* U+001eb8 */
	0x001ebb,					/* U+001eba */
	0x001ebd,					/* U+001ebc */
	0x001ebf,					/* U+001ebe */
	0x001ec1,					/* U+001ec0 */
	0x001ec3,					/* U+001ec2 */
	0x001ec5,					/* U+001ec4 */
	0x001ec7,					/* U+001ec6 */
	0x001ec9,					/* U+001ec8 */
	0x001ecb,					/* U+001eca */
	0x001ecd,					/* U+001ecc */
	0x001ecf,					/* U+001ece */
	0x001ed1,					/* U+001ed0 */
	0x001ed3,					/* U+001ed2 */
	0x001ed5,					/* U+001ed4 */
	0x001ed7,					/* U+001ed6 */
	0x001ed9,					/* U+001ed8 */
	0x001edb,					/* U+001eda */
	0x001edd,					/* U+001edc */
	0x001edf,					/* U+001ede */
	0x001ee1,					/* U+001ee0 */
	0x001ee3,					/* U+001ee2 */
	0x001ee5,					/* U+001ee4 */
	0x001ee7,					/* U+001ee6 */
	0x001ee9,					/* U+001ee8 */
	0x001eeb,					/* U+001eea */
	0x001eed,					/* U+001eec */
	0x001eef,					/* U+001eee */
	0x001ef1,					/* U+001ef0 */
	0x001ef3,					/* U+001ef2 */
	0x001ef5,					/* U+001ef4 */
	0x001ef7,					/* U+001ef6 */
	0x001ef9,					/* U+001ef8 */
	0x001efb,					/* U+001efa */
	0x001efd,					/* U+001efc */
	0x001eff,					/* U+001efe */
	0x001f00,					/* U+001f00 */
	0x001f01,					/* U+001f01 */
	0x001f02,					/* U+001f02 */
	0x001f03,					/* U+001f03 */
	0x001f04,					/* U+001f04 */
	0x001f05,					/* U+001f05 */
	0x001f06,					/* U+001f06 */
	0x001f07,					/* U+001f07 */
	0x001f10,					/* U+001f10 */
	0x001f11,					/* U+001f11 */
	0x001f12,					/* U+001f12 */
	0x001f13,					/* U+001f13 */
	0x001f14,					/* U+001f14 */
	0x001f15,					/* U+001f15 */
	0x001f20,					/* U+001f20 */
	0x001f21,					/* U+001f21 */
	0x001f22,					/* U+001f22 */
	0x001f23,					/* U+001f23 */
	0x001f24,					/* U+001f24 */
	0x001f25,					/* U+001f25 */
	0x001f26,					/* U+001f26 */
	0x001f27,					/* U+001f27 */
	0x001f30,					/* U+001f30 */
	0x001f31,					/* U+001f31 */
	0x001f32,					/* U+001f32 */
	0x001f33,					/* U+001f33 */
	0x001f34,					/* U+001f34 */
	0x001f35,					/* U+001f35 */
	0x001f36,					/* U+001f36 */
	0x001f37,					/* U+001f37 */
	0x001f40,					/* U+001f40 */
	0x001f41,					/* U+001f41 */
	0x001f42,					/* U+001f42 */
	0x001f43,					/* U+001f43 */
	0x001f44,					/* U+001f44 */
	0x001f45,					/* U+001f45 */
	0x001f50,					/* U+001f50 */
	0x001f51,					/* U+001f51 */
	0x001f52,					/* U+001f52 */
	0x001f53,					/* U+001f53 */
	0x001f54,					/* U+001f54 */
	0x001f55,					/* U+001f55 */
	0x001f56,					/* U+001f56 */
	0x001f57,					/* U+001f57 */
	0x001f60,					/* U+001f60 */
	0x001f61,					/* U+001f61 */
	0x001f62,					/* U+001f62 */
	0x001f63,					/* U+001f63 */
	0x001f64,					/* U+001f64 */
	0x001f65,					/* U+001f65 */
	0x001f66,					/* U+001f66 */
	0x001f67,					/* U+001f67 */
	0x001f70,					/* U+001f70 */
	0x001f71,					/* U+001f71 */
	0x001f72,					/* U+001f72 */
	0x001f73,					/* U+001f73 */
	0x001f74,					/* U+001f74 */
	0x001f75,					/* U+001f75 */
	0x001f76,					/* U+001f76 */
	0x001f77,					/* U+001f77 */
	0x001f78,					/* U+001f78 */
	0x001f79,					/* U+001f79 */
	0x001f7a,					/* U+001f7a */
	0x001f7b,					/* U+001f7b */
	0x001f7c,					/* U+001f7c */
	0x001f7d,					/* U+001f7d */
	0x001f80,					/* U+001f80 */
	0x001f81,					/* U+001f81 */
	0x001f82,					/* U+001f82 */
	0x001f83,					/* U+001f83 */
	0x001f84,					/* U+001f84 */
	0x001f85,					/* U+001f85 */
	0x001f86,					/* U+001f86 */
	0x001f87,					/* U+001f87 */
	0x001f80,					/* U+001f88 */
	0x001f81,					/* U+001f89 */
	0x001f82,					/* U+001f8a */
	0x001f83,					/* U+001f8b */
	0x001f84,					/* U+001f8c */
	0x001f85,					/* U+001f8d */
	0x001f86,					/* U+001f8e */
	0x001f87,					/* U+001f8f */
	0x001f90,					/* U+001f90 */
	0x001f91,					/* U+001f91 */
	0x001f92,					/* U+001f92 */
	0x001f93,					/* U+001f93 */
	0x001f94,					/* U+001f94 */
	0x001f95,					/* U+001f95 */
	0x001f96,					/* U+001f96 */
	0x001f97,					/* U+001f97 */
	0x001f90,					/* U+001f98 */
	0x001f91,					/* U+001f99 */
	0x001f92,					/* U+001f9a */
	0x001f93,					/* U+001f9b */
	0x001f94,					/* U+001f9c */
	0x001f95,					/* U+001f9d */
	0x001f96,					/* U+001f9e */
	0x001f97,					/* U+001f9f */
	0x001fa0,					/* U+001fa0 */
	0x001fa1,					/* U+001fa1 */
	0x001fa2,					/* U+001fa2 */
	0x001fa3,					/* U+001fa3 */
	0x001fa4,					/* U+001fa4 */
	0x001fa5,					/* U+001fa5 */
	0x001fa6,					/* U+001fa6 */
	0x001fa7,					/* U+001fa7 */
	0x001fa0,					/* U+001fa8 */
	0x001fa1,					/* U+001fa9 */
	0x001fa2,					/* U+001faa */
	0x001fa3,					/* U+001fab */
	0x001fa4,					/* U+001fac */
	0x001fa5,					/* U+001fad */
	0x001fa6,					/* U+001fae */
	0x001fa7,					/* U+001faf */
	0x001fb0,					/* U+001fb0 */
	0x001fb1,					/* U+001fb1 */
	0x001fb2,					/* U+001fb2 */
	0x001fb3,					/* U+001fb3 */
	0x001fb4,					/* U+001fb4 */
	0x001fb6,					/* U+001fb6 */
	0x001fb7,					/* U+001fb7 */
	0x001fb3,					/* U+001fbc */
	0x0003b9,					/* U+001fbe */
	0x001fc2,					/* U+001fc2 */
	0x001fc3,					/* U+001fc3 */
	0x001fc4,					/* U+001fc4 */
	0x001fc6,					/* U+001fc6 */
	0x001fc7,					/* U+001fc7 */
	0x001fc3,					/* U+001fcc */
	0x001fd0,					/* U+001fd0 */
	0x001fd1,					/* U+001fd1 */
	0x001fd2,					/* U+001fd2 */
	0x000390,					/* U+001fd3 */
	0x001fd6,					/* U+001fd6 */
	0x001fd7,					/* U+001fd7 */
	0x001fe0,					/* U+001fe0 */
	0x001fe1,					/* U+001fe1 */
	0x001fe2,					/* U+001fe2 */
	0x0003b0,					/* U+001fe3 */
	0x001fe4,					/* U+001fe4 */
	0x001fe5,					/* U+001fe5 */
	0x001fe6,					/* U+001fe6 */
	0x001fe7,					/* U+001fe7 */
	0x001ff2,					/* U+001ff2 */
	0x001ff3,					/* U+001ff3 */
	0x001ff4,					/* U+001ff4 */
	0x001ff6,					/* U+001ff6 */
	0x001ff7,					/* U+001ff7 */
	0x001ff3,					/* U+001ffc */
	0x0003c9,					/* U+002126 */
	0x00006b,					/* U+00212a */
	0x0000e5,					/* U+00212b */
	0x00214e,					/* U+002132 */
	0x002170,					/* U+002160 */
	0x002171,					/* U+002161 */
	0x002172,					/* U+002162 */
	0x002173,					/* U+002163 */
	0x002174,					/* U+002164 */
	0x002175,					/* U+002165 */
	0x002176,					/* U+002166 */
	0x002177,					/* U+002167 */
	0x002178,					/* U+002168 */
	0x002179,					/* U+002169 */
	0x00217a,					/* U+00216a */
	0x00217b,					/* U+00216b */
	0x00217c,					/* U+00216c */
	0x00217d,					/* U+00216d */
	0x00217e,					/* U+00216e */
	0x00217f,					/* U+00216f */
	0x002184,					/* U+002183 */
	0x0024d0,					/* U+0024b6 */
	0x0024d1,					/* U+0024b7 */
	0x0024d2,					/* U+0024b8 */
	0x0024d3,					/* U+0024b9 */
	0x0024d4,					/* U+0024ba */
	0x0024d5,					/* U+0024bb */
	0x0024d6,					/* U+0024bc */
	0x0024d7,					/* U+0024bd */
	0x0024d8,					/* U+0024be */
	0x0024d9,					/* U+0024bf */
	0x0024da,					/* U+0024c0 */
	0x0024db,					/* U+0024c1 */
	0x0024dc,					/* U+0024c2 */
	0x0024dd,					/* U+0024c3 */
	0x0024de,					/* U+0024c4 */
	0x0024df,					/* U+0024c5 */
	0x0024e0,					/* U+0024c6 */
	0x0024e1,					/* U+0024c7 */
	0x0024e2,					/* U+0024c8 */
	0x0024e3,					/* U+0024c9 */
	0x0024e4,					/* U+0024ca */
	0x0024e5,					/* U+0024cb */
	0x0024e6,					/* U+0024cc */
	0x0024e7,					/* U+0024cd */
	0x0024e8,					/* U+0024ce */
	0x0024e9,					/* U+0024cf */
	0x002c30,					/* U+002c00 */
	0x002c31,					/* U+002c01 */
	0x002c32,					/* U+002c02 */
	0x002c33,					/* U+002c03 */
	0x002c34,					/* U+002c04 */
	0x002c35,					/* U+002c05 */
	0x002c36,					/* U+002c06 */
	0x002c37,					/* U+002c07 */
	0x002c38,					/* U+002c08 */
	0x002c39,					/* U+002c09 */
	0x002c3a,					/* U+002c0a */
	0x002c3b,					/* U+002c0b */
	0x002c3c,					/* U+002c0c */
	0x002c3d,					/* U+002c0d */
	0x002c3e,					/* U+002c0e */
	0x002c3f,					/* U+002c0f */
	0x002c40,					/* U+002c10 */
	0x002c41,					/* U+002c11 */
	0x002c42,					/* U+002c12 */
	0x002c43,					/* U+002c13 */
	0x002c44,					/* U+002c14 */
	0x002c45,					/* U+002c15 */
	0x002c46,					/* U+002c16 */
	0x002c47,					/* U+002c17 */
	0x002c48,					/* U+002c18 */
	0x002c49,					/* U+002c19 */
	0x002c4a,					/* U+002c1a */
	0x002c4b,					/* U+002c1b */
	0x002c4c,					/* U+002c1c */
	0x002c4d,					/* U+002c1d */
	0x002c4e,					/* U+002c1e */
	0x002c4f,					/* U+002c1f */
	0x002c50,					/* U+002c20 */
	0x002c51,					/* U+002c21 */
	0x002c52,					/* U+002c22 */
	0x002c53,					/* U+002c23 */
	0x002c54,					/* U+002c24 */
	0x002c55,					/* U+002c25 */
	0x002c56,					/* U+002c26 */
	0x002c57,					/* U+002c27 */
	0x002c58,					/* U+002c28 */
	0x002c59,					/* U+002c29 */
	0x002c5a,					/* U+002c2a */
	0x002c5b,					/* U+002c2b */
	0x002c5c,					/* U+002c2c */
	0x002c5d,					/* U+002c2d */
	0x002c5e,					/* U+002c2e */
	0x002c5f,					/* U+002c2f */
	0x002c61,					/* U+002c60 */
	0x002c68,					/* U+002c67 */
	0x002c6a,					/* U+002c69 */
	0x002c6c,					/* U+002c6b */
	0x002c73,					/* U+002c72 */
	0x002c76,					/* U+002c75 */
	0x002c81,					/* U+002c80 */
	0x002c83,					/* U+002c82 */
	0x002c85,					/* U+002c84 */
	0x002c87,					/* U+002c86 */
	0x002c89,					/* U+002c88 */
	0x002c8b,					/* U+002c8a */
	0x002c8d,					/* U+002c8c */
	0x002c8f,					/* U+002c8e */
	0x002c91,					/* U+002c90 */
	0x002c93,					/* U+002c92 */
	0x002c95,					/* U+002c94 */
	0x002c97,					/* U+002c96 */
	0x002c99,					/* U+002c98 */
	0x002c9b,					/* U+002c9a */
	0x002c9d,					/* U+002c9c */
	0x002c9f,					/* U+002c9e */
	0x002ca1,					/* U+002ca0 */
	0x002ca3,					/* U+002ca2 */
	0x002ca5,					/* U+002ca4 */
	0x002ca7,					/* U+002ca6 */
	0x002ca9,					/* U+002ca8 */
	0x002cab,					/* U+002caa */
	0x002cad,					/* U+002cac */
	0x002caf,					/* U+002cae */
	0x002cb1,					/* U+002cb0 */
	0x002cb3,					/* U+002cb2 */
	0x002cb5,					/* U+002cb4 */
	0x002cb7,					/* U+002cb6 */
	0x002cb9,					/* U+002cb8 */
	0x002cbb,					/* U+002cba */
	0x002cbd,					/* U+002cbc */
	0x002cbf,					/* U+002cbe */
	0x002cc1,					/* U+002cc0 */
	0x002cc3,					/* U+002cc2 */
	0x002cc5,					/* U+002cc4 */
	0x002cc7,					/* U+002cc6 */
	0x002cc9,					/* U+002cc8 */
	0x002ccb,					/* U+002cca */
	0x002ccd,					/* U+002ccc */
	0x002ccf,					/* U+002cce */
	0x002cd1,					/* U+002cd0 */
	0x002cd3,					/* U+002cd2 */
	0x002cd5,					/* U+002cd4 */
	0x002cd7,					/* U+002cd6 */
	0x002cd9,					/* U+002cd8 */
	0x002cdb,					/* U+002cda */
	0x002cdd,					/* U+002cdc */
	0x002cdf,					/* U+002cde */
	0x002ce1,					/* U+002ce0 */
	0x002ce3,					/* U+002ce2 */
	0x002cec,					/* U+002ceb */
	0x002cee,					/* U+002ced */
	0x002cf3,					/* U+002cf2 */
	0x00a641,					/* U+00a640 */
	0x00a643,					/* U+00a642 */
	0x00a645,					/* U+00a644 */
	0x00a647,					/* U+00a646 */
	0x00a649,					/* U+00a648 */
	0x00a64b,					/* U+00a64a */
	0x00a64d,					/* U+00a64c */
	0x00a64f,					/* U+00a64e */
	0x00a651,					/* U+00a650 */
	0x00a653,					/* U+00a652 */
	0x00a655,					/* U+00a654 */
	0x00a657,					/* U+00a656 */
	0x00a659,					/* U+00a658 */
	0x00a65b,					/* U+00a65a */
	0x00a65d,					/* U+00a65c */
	0x00a65f,					/* U+00a65e */
	0x00a661,					/* U+00a660 */
	0x00a663,					/* U+00a662 */
	0x00a665,					/* U+00a664 */
	0x00a667,					/* U+00a666 */
	0x00a669,					/* U+00a668 */
	0x00a66b,					/* U+00a66a */
	0x00a66d,					/* U+00a66c */
	0x00a681,					/* U+00a680 */
	0x00a683,					/* U+00a682 */
	0x00a685,					/* U+00a684 */
	0x00a687,					/* U+00a686 */
	0x00a689,					/* U+00a688 */
	0x00a68b,					/* U+00a68a */
	0x00a68d,					/* U+00a68c */
	0x00a68f,					/* U+00a68e */
	0x00a691,					/* U+00a690 */
	0x00a693,					/* U+00a692 */
	0x00a695,					/* U+00a694 */
	0x00a697,					/* U+00a696 */
	0x00a699,					/* U+00a698 */
	0x00a69b,					/* U+00a69a */
	0x00a723,					/* U+00a722 */
	0x00a725,					/* U+00a724 */
	0x00a727,					/* U+00a726 */
	0x00a729,					/* U+00a728 */
	0x00a72b,					/* U+00a72a */
	0x00a72d,					/* U+00a72c */
	0x00a72f,					/* U+00a72e */
	0x00a733,					/* U+00a732 */
	0x00a735,					/* U+00a734 */
	0x00a737,					/* U+00a736 */
	0x00a739,					/* U+00a738 */
	0x00a73b,					/* U+00a73a */
	0x00a73d,					/* U+00a73c */
	0x00a73f,					/* U+00a73e */
	0x00a741,					/* U+00a740 */
	0x00a743,					/* U+00a742 */
	0x00a745,					/* U+00a744 */
	0x00a747,					/* U+00a746 */
	0x00a749,					/* U+00a748 */
	0x00a74b,					/* U+00a74a */
	0x00a74d,					/* U+00a74c */
	0x00a74f,					/* U+00a74e */
	0x00a751,					/* U+00a750 */
	0x00a753,					/* U+00a752 */
	0x00a755,					/* U+00a754 */
	0x00a757,					/* U+00a756 */
	0x00a759,					/* U+00a758 */
	0x00a75b,					/* U+00a75a */
	0x00a75d,					/* U+00a75c */
	0x00a75f,					/* U+00a75e */
	0x00a761,					/* U+00a760 */
	0x00a763,					/* U+00a762 */
	0x00a765,					/* U+00a764 */
	0x00a767,					/* U+00a766 */
	0x00a769,					/* U+00a768 */
	0x00a76b,					/* U+00a76a */
	0x00a76d,					/* U+00a76c */
	0x00a76f,					/* U+00a76e */
	0x00a77a,					/* U+00a779 */
	0x00a77c,					/* U+00a77b */
	0x00a77f,					/* U+00a77e */
	0x00a781,					/* U+00a780 */
	0x00a783,					/* U+00a782 */
	0x00a785,					/* U+00a784 */
	0x00a787,					/* U+00a786 */
	0x00a78c,					/* U+00a78b */
	0x00a791,					/* U+00a790 */
	0x00a793,					/* U+00a792 */
	0x00a794,					/* U+00a794 */
	0x00a797,					/* U+00a796 */
	0x00a799,					/* U+00a798 */
	0x00a79b,					/* U+00a79a */
	0x00a79d,					/* U+00a79c */
	0x00a79f,					/* U+00a79e */
	0x00a7a1,					/* U+00a7a0 */
	0x00a7a3,					/* U+00a7a2 */
	0x00a7a5,					/* U+00a7a4 */
	0x00a7a7,					/* U+00a7a6 */
	0x00a7a9,					/* U+00a7a8 */
	0x00ab53,					/* U+00a7b3 */
	0x00a7b5,					/* U+00a7b4 */
	0x00a7b7,					/* U+00a7b6 */
	0x00a7b9,					/* U+00a7b8 */
	0x00a7bb,					/* U+00a7ba */
	0x00a7bd,					/* U+00a7bc */
	0x00a7bf,					/* U+00a7be */
	0x00a7c1,					/* U+00a7c0 */
	0x00a7c3,					/* U+00a7c2 */
	0x00a7c8,					/* U+00a7c7 */
	0x00a7ca,					/* U+00a7c9 */
	0x00a7cd,					/* U+00a7cc */
	0x00a7d1,					/* U+00a7d0 */
	0x00a7d7,					/* U+00a7d6 */
	0x00a7d9,					/* U+00a7d8 */
	0x00a7db,					/* U+00a7da */
	0x00a7f6,					/* U+00a7f5 */
	0x00fb00,					/* U+00fb00 */
	0x00fb01,					/* U+00fb01 */
	0x00fb02,					/* U+00fb02 */
	0x00fb03,					/* U+00fb03 */
	0x00fb04,					/* U+00fb04 */
	0x00fb06,					/* U+00fb05 */
	0x00fb06,					/* U+00fb06 */
	0x00fb13,					/* U+00fb13 */
	0x00fb14,					/* U+00fb14 */
	0x00fb15,					/* U+00fb15 */
	0x00fb16,					/* U+00fb16 */
	0x00fb17,					/* U+00fb17 */
	0x00ff41,					/* U+00ff21 */
	0x00ff42,					/* U+00ff22 */
	0x00ff43,					/* U+00ff23 */
	0x00ff44,					/* U+00ff24 */
	0x00ff45,					/* U+00ff25 */
	0x00ff46,					/* U+00ff26 */
	0x00ff47,					/* U+00ff27 */
	0x00ff48,					/* U+00ff28 */
	0x00ff49,					/* U+00ff29 */
	0x00ff4a,					/* U+00ff2a */
	0x00ff4b,					/* U+00ff2b */
	0x00ff4c,					/* U+00ff2c */
	0x00ff4d,					/* U+00ff2d */
	0x00ff4e,					/* U+00ff2e */
	0x00ff4f,					/* U+00ff2f */
	0x00ff50,					/* U+00ff30 */
	0x00ff51,					/* U+00ff31 */
	0x00ff52,					/* U+00ff32 */
	0x00ff53,					/* U+00ff33 */
	0x00ff54,					/* U+00ff34 */
	0x00ff55,					/* U+00ff35 */
	0x00ff56,					/* U+00ff36 */
	0x00ff57,					/* U+00ff37 */
	0x00ff58,					/* U+00ff38 */
	0x00ff59,					/* U+00ff39 */
	0x00ff5a,					/* U+00ff3a */
	0x010428,					/* U+010400 */
	0x010429,					/* U+010401 */
	0x01042a,					/* U+010402 */
	0x01042b,					/* U+010403 */
	0x01042c,					/* U+010404 */
	0x01042d,					/* U+010405 */
	0x01042e,					/* U+010406 */
	0x01042f,					/* U+010407 */
	0x010430,					/* U+010408 */
	0x010431,					/* U+010409 */
	0x010432,					/* U+01040a */
	0x010433,					/* U+01040b */
	0x010434,					/* U+01040c */
	0x010435,					/* U+01040d */
	0x010436,					/* U+01040e */
	0x010437,					/* U+01040f */
	0x010438,					/* U+010410 */
	0x010439,					/* U+010411 */
	0x01043a,					/* U+010412 */
	0x01043b,					/* U+010413 */
	0x01043c,					/* U+010414 */
	0x01043d,					/* U+010415 */
	0x01043e,					/* U+010416 */
	0x01043f,					/* U+010417 */
	0x010440,					/* U+010418 */
	0x010441,					/* U+010419 */
	0x010442,					/* U+01041a */
	0x010443,					/* U+01041b */
	0x010444,					/* U+01041c */
	0x010445,					/* U+01041d */
	0x010446,					/* U+01041e */
	0x010447,					/* U+01041f */
	0x010448,					/* U+010420 */
	0x010449,					/* U+010421 */
	0x01044a,					/* U+010422 */
	0x01044b,					/* U+010423 */
	0x01044c,					/* U+010424 */
	0x01044d,					/* U+010425 */
	0x01044e,					/* U+010426 */
	0x01044f,					/* U+010427 */
	0x0104d8,					/* U+0104b0 */
	0x0104d9,					/* U+0104b1 */
	0x0104da,					/* U+0104b2 */
	0x0104db,					/* U+0104b3 */
	0x0104dc,					/* U+0104b4 */
	0x0104dd,					/* U+0104b5 */
	0x0104de,					/* U+0104b6 */
	0x0104df,					/* U+0104b7 */
	0x0104e0,					/* U+0104b8 */
	0x0104e1,					/* U+0104b9 */
	0x0104e2,					/* U+0104ba */
	0x0104e3,					/* U+0104bb */
	0x0104e4,					/* U+0104bc */
	0x0104e5,					/* U+0104bd */
	0x0104e6,					/* U+0104be */
	0x0104e7,					/* U+0104bf */
	0x0104e8,					/* U+0104c0 */
	0x0104e9,					/* U+0104c1 */
	0x0104ea,					/* U+0104c2 */
	0x0104eb,					/* U+0104c3 */
	0x0104ec,					/* U+0104c4 */
	0x0104ed,					/* U+0104c5 */
	0x0104ee,					/* U+0104c6 */
	0x0104ef,					/* U+0104c7 */
	0x0104f0,					/* U+0104c8 */
	0x0104f1,					/* U+0104c9 */
	0x0104f2,					/* U+0104ca */
	0x0104f3,					/* U+0104cb */
	0x0104f4,					/* U+0104cc */
	0x0104f5,					/* U+0104cd */
	0x0104f6,					/* U+0104ce */
	0x0104f7,					/* U+0104cf */
	0x0104f8,					/* U+0104d0 */
	0x0104f9,					/* U+0104d1 */
	0x0104fa,					/* U+0104d2 */
	0x0104fb,					/* U+0104d3 */
	0x010597,					/* U+010570 */
	0x010598,					/* U+010571 */
	0x010599,					/* U+010572 */
	0x01059a,					/* U+010573 */
	0x01059b,					/* U+010574 */
	0x01059c,					/* U+010575 */
	0x01059d,					/* U+010576 */
	0x01059e,					/* U+010577 */
	0x01059f,					/* U+010578 */
	0x0105a0,					/* U+010579 */
	0x0105a1,					/* U+01057a */
	0x0105a3,					/* U+01057c */
	0x0105a4,					/* U+01057d */
	0x0105a5,					/* U+01057e */
	0x0105a6,					/* U+01057f */
	0x0105a7,					/* U+010580 */
	0x0105a8,					/* U+010581 */
	0x0105a9,					/* U+010582 */
	0x0105aa,					/* U+010583 */
	0x0105ab,					/* U+010584 */
	0x0105ac,					/* U+010585 */
	0x0105ad,					/* U+010586 */
	0x0105ae,					/* U+010587 */
	0x0105af,					/* U+010588 */
	0x0105b0,					/* U+010589 */
	0x0105b1,					/* U+01058a */
	0x0105b3,					/* U+01058c */
	0x0105b4,					/* U+01058d */
	0x0105b5,					/* U+01058e */
	0x0105b6,					/* U+01058f */
	0x0105b7,					/* U+010590 */
	0x0105b8,					/* U+010591 */
	0x0105b9,					/* U+010592 */
	0x0105bb,					/* U+010594 */
	0x0105bc,					/* U+010595 */
	0x010cc0,					/* U+010c80 */
	0x010cc1,					/* U+010c81 */
	0x010cc2,					/* U+010c82 */
	0x010cc3,					/* U+010c83 */
	0x010cc4,					/* U+010c84 */
	0x010cc5,					/* U+010c85 */
	0x010cc6,					/* U+010c86 */
	0x010cc7,					/* U+010c87 */
	0x010cc8,					/* U+010c88 */
	0x010cc9,					/* U+010c89 */
	0x010cca,					/* U+010c8a */
	0x010ccb,					/* U+010c8b */
	0x010ccc,					/* U+010c8c */
	0x010ccd,					/* U+010c8d */
	0x010cce,					/* U+010c8e */
	0x010ccf,					/* U+010c8f */
	0x010cd0,					/* U+010c90 */
	0x010cd1,					/* U+010c91 */
	0x010cd2,					/* U+010c92 */
	0x010cd3,					/* U+010c93 */
	0x010cd4,					/* U+010c94 */
	0x010cd5,					/* U+010c95 */
	0x010cd6,					/* U+010c96 */
	0x010cd7,					/* U+010c97 */
	0x010cd8,					/* U+010c98 */
	0x010cd9,					/* U+010c99 */
	0x010cda,					/* U+010c9a */
	0x010cdb,					/* U+010c9b */
	0x010cdc,					/* U+010c9c */
	0x010cdd,					/* U+010c9d */
	0x010cde,					/* U+010c9e */
	0x010cdf,					/* U+010c9f */
	0x010ce0,					/* U+010ca0 */
	0x010ce1,					/* U+010ca1 */
	0x010ce2,					/* U+010ca2 */
	0x010ce3,					/* U+010ca3 */
	0x010ce4,					/* U+010ca4 */
	0x010ce5,					/* U+010ca5 */
	0x010ce6,					/* U+010ca6 */
	0x010ce7,					/* U+010ca7 */
	0x010ce8,					/* U+010ca8 */
	0x010ce9,					/* U+010ca9 */
	0x010cea,					/* U+010caa */
	0x010ceb,					/* U+010cab */
	0x010cec,					/* U+010cac */
	0x010ced,					/* U+010cad */
	0x010cee,					/* U+010cae */
	0x010cef,					/* U+010caf */
	0x010cf0,					/* U+010cb0 */
	0x010cf1,					/* U+010cb1 */
	0x010cf2,					/* U+010cb2 */
	0x010d70,					/* U+010d50 */
	0x010d71,					/* U+010d51 */
	0x010d72,					/* U+010d52 */
	0x010d73,					/* U+010d53 */
	0x010d74,					/* U+010d54 */
	0x010d75,					/* U+010d55 */
	0x010d76,					/* U+010d56 */
	0x010d77,					/* U+010d57 */
	0x010d78,					/* U+010d58 */
	0x010d79,					/* U+010d59 */
	0x010d7a,					/* U+010d5a */
	0x010d7b,					/* U+010d5b */
	0x010d7c,					/* U+010d5c */
	0x010d7d,					/* U+010d5d */
	0x010d7e,					/* U+010d5e */
	0x010d7f,					/* U+010d5f */
	0x010d80,					/* U+010d60 */
	0x010d81,					/* U+010d61 */
	0x010d82,					/* U+010d62 */
	0x010d83,					/* U+010d63 */
	0x010d84,					/* U+010d64 */
	0x010d85,					/* U+010d65 */
	0x0118c0,					/* U+0118a0 */
	0x0118c1,					/* U+0118a1 */
	0x0118c2,					/* U+0118a2 */
	0x0118c3,					/* U+0118a3 */
	0x0118c4,					/* U+0118a4 */
	0x0118c5,					/* U+0118a5 */
	0x0118c6,					/* U+0118a6 */
	0x0118c7,					/* U+0118a7 */
	0x0118c8,					/* U+0118a8 */
	0x0118c9,					/* U+0118a9 */
	0x0118ca,					/* U+0118aa */
	0x0118cb,					/* U+0118ab */
	0x0118cc,					/* U+0118ac */
	0x0118cd,					/* U+0118ad */
	0x0118ce,					/* U+0118ae */
	0x0118cf,					/* U+0118af */
	0x0118d0,					/* U+0118b0 */
	0x0118d1,					/* U+0118b1 */
	0x0118d2,					/* U+0118b2 */
	0x0118d3,					/* U+0118b3 */
	0x0118d4,					/* U+0118b4 */
	0x0118d5,					/* U+0118b5 */
	0x0118d6,					/* U+0118b6 */
	0x0118d7,					/* U+0118b7 */
	0x0118d8,					/* U+0118b8 */
	0x0118d9,					/* U+0118b9 */
	0x0118da,					/* U+0118ba */
	0x0118db,					/* U+0118bb */
	0x0118dc,					/* U+0118bc */
	0x0118dd,					/* U+0118bd */
	0x0118de,					/* U+0118be */
	0x0118df,					/* U+0118bf */
	0x016e60,					/* U+016e40 */
	0x016e61,					/* U+016e41 */
	0x016e62,					/* U+016e42 */
	0x016e63,					/* U+016e43 */
	0x016e64,					/* U+016e44 */
	0x016e65,					/* U+016e45 */
	0x016e66,					/* U+016e46 */
	0x016e67,					/* U+016e47 */
	0x016e68,					/* U+016e48 */
	0x016e69,					/* U+016e49 */
	0x016e6a,					/* U+016e4a */
	0x016e6b,					/* U+016e4b */
	0x016e6c,					/* U+016e4c */
	0x016e6d,					/* U+016e4d */
	0x016e6e,					/* U+016e4e */
	0x016e6f,					/* U+016e4f */
	0x016e70,					/* U+016e50 */
	0x016e71,					/* U+016e51 */
	0x016e72,					/* U+016e52 */
	0x016e73,					/* U+016e53 */
	0x016e74,					/* U+016e54 */
	0x016e75,					/* U+016e55 */
	0x016e76,					/* U+016e56 */
	0x016e77,					/* U+016e57 */
	0x016e78,					/* U+016e58 */
	0x016e79,					/* U+016e59 */
	0x016e7a,					/* U+016e5a */
	0x016e7b,					/* U+016e5b */
	0x016e7c,					/* U+016e5c */
	0x016e7d,					/* U+016e5d */
	0x016e7e,					/* U+016e5e */
	0x016e7f,					/* U+016e5f */
	0x01e922,					/* U+01e900 */
	0x01e923,					/* U+01e901 */
	0x01e924,					/* U+01e902 */
	0x01e925,					/* U+01e903 */
	0x01e926,					/* U+01e904 */
	0x01e927,					/* U+01e905 */
	0x01e928,					/* U+01e906 */
	0x01e929,					/* U+01e907 */
	0x01e92a,					/* U+01e908 */
	0x01e92b,					/* U+01e909 */
	0x01e92c,					/* U+01e90a */
	0x01e92d,					/* U+01e90b */
	0x01e92e,					/* U+01e90c */
	0x01e92f,					/* U+01e90d */
	0x01e930,					/* U+01e90e */
	0x01e931,					/* U+01e90f */
	0x01e932,					/* U+01e910 */
	0x01e933,					/* U+01e911 */
	0x01e934,					/* U+01e912 */
	0x01e935,					/* U+01e913 */
	0x01e936,					/* U+01e914 */
	0x01e937,					/* U+01e915 */
	0x01e938,					/* U+01e916 */
	0x01e939,					/* U+01e917 */
	0x01e93a,					/* U+01e918 */
	0x01e93b,					/* U+01e919 */
	0x01e93c,					/* U+01e91a */
	0x01e93d,					/* U+01e91b */
	0x01e93e,					/* U+01e91c */
	0x01e93f,					/* U+01e91d */
	0x01e940,					/* U+01e91e */
	0x01e941,					/* U+01e91f */
	0x01e942,					/* U+01e920 */
	0x01e943,					/* U+01e921 */

};

/*
 * The entry case_map_special[case_index(codepoint)] is the index in
 * special_case for that codepoint, or 0 if no special case mapping exists.
 */
static const uint8 case_map_special[1704] =
{
	0,							/* reserved */
	0,							/* U+000000 */
	0,							/* U+000001 */
	0,							/* U+000002 */
	0,							/* U+000003 */
	0,							/* U+000004 */
	0,							/* U+000005 */
	0,							/* U+000006 */
	0,							/* U+000007 */
	0,							/* U+000008 */
	0,							/* U+000009 */
	0,							/* U+00000a */
	0,							/* U+00000b */
	0,							/* U+00000c */
	0,							/* U+00000d */
	0,							/* U+00000e */
	0,							/* U+00000f */
	0,							/* U+000010 */
	0,							/* U+000011 */
	0,							/* U+000012 */
	0,							/* U+000013 */
	0,							/* U+000014 */
	0,							/* U+000015 */
	0,							/* U+000016 */
	0,							/* U+000017 */
	0,							/* U+000018 */
	0,							/* U+000019 */
	0,							/* U+00001a */
	0,							/* U+00001b */
	0,							/* U+00001c */
	0,							/* U+00001d */
	0,							/* U+00001e */
	0,							/* U+00001f */
	0,							/* U+000020 */
	0,							/* U+000021 */
	0,							/* U+000022 */
	0,							/* U+000023 */
	0,							/* U+000024 */
	0,							/* U+000025 */
	0,							/* U+000026 */
	0,							/* U+000027 */
	0,							/* U+000028 */
	0,							/* U+000029 */
	0,							/* U+00002a */
	0,							/* U+00002b */
	0,							/* U+00002c */
	0,							/* U+00002d */
	0,							/* U+00002e */
	0,							/* U+00002f */
	0,							/* U+000030 */
	0,							/* U+000031 */
	0,							/* U+000032 */
	0,							/* U+000033 */
	0,							/* U+000034 */
	0,							/* U+000035 */
	0,							/* U+000036 */
	0,							/* U+000037 */
	0,							/* U+000038 */
	0,							/* U+000039 */
	0,							/* U+00003a */
	0,							/* U+00003b */
	0,							/* U+00003c */
	0,							/* U+00003d */
	0,							/* U+00003e */
	0,							/* U+00003f */
	0,							/* U+000040 */
	0,							/* U+000041 */
	0,							/* U+000042 */
	0,							/* U+000043 */
	0,							/* U+000044 */
	0,							/* U+000045 */
	0,							/* U+000046 */
	0,							/* U+000047 */
	0,							/* U+000048 */
	0,							/* U+000049 */
	0,							/* U+00004a */
	0,							/* U+00004b */
	0,							/* U+00004c */
	0,							/* U+00004d */
	0,							/* U+00004e */
	0,							/* U+00004f */
	0,							/* U+000050 */
	0,							/* U+000051 */
	0,							/* U+000052 */
	0,							/* U+000053 */
	0,							/* U+000054 */
	0,							/* U+000055 */
	0,							/* U+000056 */
	0,							/* U+000057 */
	0,							/* U+000058 */
	0,							/* U+000059 */
	0,							/* U+00005a */
	0,							/* U+00005b */
	0,							/* U+00005c */
	0,							/* U+00005d */
	0,							/* U+00005e */
	0,							/* U+00005f */
	0,							/* U+000060 */
	0,							/* U+000061 */
	0,							/* U+000062 */
	0,							/* U+000063 */
	0,							/* U+000064 */
	0,							/* U+000065 */
	0,							/* U+000066 */
	0,							/* U+000067 */
	0,							/* U+000068 */
	0,							/* U+000069 */
	0,							/* U+00006a */
	0,							/* U+00006b */
	0,							/* U+00006c */
	0,							/* U+00006d */
	0,							/* U+00006e */
	0,							/* U+00006f */
	0,							/* U+000070 */
	0,							/* U+000071 */
	0,							/* U+000072 */
	0,							/* U+000073 */
	0,							/* U+000074 */
	0,							/* U+000075 */
	0,							/* U+000076 */
	0,							/* U+000077 */
	0,							/* U+000078 */
	0,							/* U+000079 */
	0,							/* U+00007a */
	0,							/* U+00007b */
	0,							/* U+00007c */
	0,							/* U+00007d */
	0,							/* U+00007e */
	0,							/* U+00007f */
	0,							/* U+0000b5 */
	0,							/* U+0000c0 */
	0,							/* U+0000c1 */
	0,							/* U+0000c2 */
	0,							/* U+0000c3 */
	0,							/* U+0000c4 */
	0,							/* U+0000c5 */
	0,							/* U+0000c6 */
	0,							/* U+0000c7 */
	0,							/* U+0000c8 */
	0,							/* U+0000c9 */
	0,							/* U+0000ca */
	0,							/* U+0000cb */
	0,							/* U+0000cc */
	0,							/* U+0000cd */
	0,							/* U+0000ce */
	0,							/* U+0000cf */
	0,							/* U+0000d0 */
	0,							/* U+0000d1 */
	0,							/* U+0000d2 */
	0,							/* U+0000d3 */
	0,							/* U+0000d4 */
	0,							/* U+0000d5 */
	0,							/* U+0000d6 */
	0,							/* U+0000d8 */
	0,							/* U+0000d9 */
	0,							/* U+0000da */
	0,							/* U+0000db */
	0,							/* U+0000dc */
	0,							/* U+0000dd */
	0,							/* U+0000de */
	1,							/* U+0000df */
	0,							/* U+0000ff */
	0,							/* U+000100 */
	0,							/* U+000102 */
	0,							/* U+000104 */
	0,							/* U+000106 */
	0,							/* U+000108 */
	0,							/* U+00010a */
	0,							/* U+00010c */
	0,							/* U+00010e */
	0,							/* U+000110 */
	0,							/* U+000112 */
	0,							/* U+000114 */
	0,							/* U+000116 */
	0,							/* U+000118 */
	0,							/* U+00011a */
	0,							/* U+00011c */
	0,							/* U+00011e */
	0,							/* U+000120 */
	0,							/* U+000122 */
	0,							/* U+000124 */
	0,							/* U+000126 */
	0,							/* U+000128 */
	0,							/* U+00012a */
	0,							/* U+00012c */
	0,							/* U+00012e */
	2,							/* U+000130 */
	0,							/* U+000131 */
	0,							/* U+000132 */
	0,							/* U+000134 */
	0,							/* U+000136 */
	0,							/* U+000139 */
	0,							/* U+00013b */
	0,							/* U+00013d */
	0,							/* U+00013f */
	0,							/* U+000141 */
	0,							/* U+000143 */
	0,							/* U+000145 */
	0,							/* U+000147 */
	3,							/* U+000149 */
	0,							/* U+00014a */
	0,							/* U+00014c */
	0,							/* U+00014e */
	0,							/* U+000150 */
	0,							/* U+000152 */
	0,							/* U+000154 */
	0,							/* U+000156 */
	0,							/* U+000158 */
	0,							/* U+00015a */
	0,							/* U+00015c */
	0,							/* U+00015e */
	0,							/* U+000160 */
	0,							/* U+000162 */
	0,							/* U+000164 */
	0,							/* U+000166 */
	0,							/* U+000168 */
	0,							/* U+00016a */
	0,							/* U+00016c */
	0,							/* U+00016e */
	0,							/* U+000170 */
	0,							/* U+000172 */
	0,							/* U+000174 */
	0,							/* U+000176 */
	0,							/* U+000179 */
	0,							/* U+00017b */
	0,							/* U+00017d */
	0,							/* U+00017f */
	0,							/* U+000180 */
	0,							/* U+000181 */
	0,							/* U+000182 */
	0,							/* U+000184 */
	0,							/* U+000186 */
	0,							/* U+000187 */
	0,							/* U+000189 */
	0,							/* U+00018a */
	0,							/* U+00018b */
	0,							/* U+00018e */
	0,							/* U+00018f */
	0,							/* U+000190 */
	0,							/* U+000191 */
	0,							/* U+000193 */
	0,							/* U+000194 */
	0,							/* U+000195 */
	0,							/* U+000196 */
	0,							/* U+000197 */
	0,							/* U+000198 */
	0,							/* U+00019a */
	0,							/* U+00019b */
	0,							/* U+00019c */
	0,							/* U+00019d */
	0,							/* U+00019e */
	0,							/* U+00019f */
	0,							/* U+0001a0 */
	0,							/* U+0001a2 */
	0,							/* U+0001a4 */
	0,							/* U+0001a6 */
	0,							/* U+0001a7 */
	0,							/* U+0001a9 */
	0,							/* U+0001ac */
	0,							/* U+0001ae */
	0,							/* U+0001af */
	0,							/* U+0001b1 */
	0,							/* U+0001b2 */
	0,							/* U+0001b3 */
	0,							/* U+0001b5 */
	0,							/* U+0001b7 */
	0,							/* U+0001b8 */
	0,							/* U+0001bc */
	0,							/* U+0001bf */
	0,							/* U+0001c4 */
	0,							/* U+0001c7 */
	0,							/* U+0001ca */
	0,							/* U+0001cd */
	0,							/* U+0001cf */
	0,							/* U+0001d1 */
	0,							/* U+0001d3 */
	0,							/* U+0001d5 */
	0,							/* U+0001d7 */
	0,							/* U+0001d9 */
	0,							/* U+0001db */
	0,							/* U+0001de */
	0,							/* U+0001e0 */
	0,							/* U+0001e2 */
	0,							/* U+0001e4 */
	0,							/* U+0001e6 */
	0,							/* U+0001e8 */
	0,							/* U+0001ea */
	0,							/* U+0001ec */
	0,							/* U+0001ee */
	4,							/* U+0001f0 */
	0,							/* U+0001f1 */
	0,							/* U+0001f4 */
	0,							/* U+0001f8 */
	0,							/* U+0001fa */
	0,							/* U+0001fc */
	0,							/* U+0001fe */
	0,							/* U+000200 */
	0,							/* U+000202 */
	0,							/* U+000204 */
	0,							/* U+000206 */
	0,							/* U+000208 */
	0,							/* U+00020a */
	0,							/* U+00020c */
	0,							/* U+00020e */
	0,							/* U+000210 */
	0,							/* U+000212 */
	0,							/* U+000214 */
	0,							/* U+000216 */
	0,							/* U+000218 */
	0,							/* U+00021a */
	0,							/* U+00021c */
	0,							/* U+00021e */
	0,							/* U+000222 */
	0,							/* U+000224 */
	0,							/* U+000226 */
	0,							/* U+000228 */
	0,							/* U+00022a */
	0,							/* U+00022c */
	0,							/* U+00022e */
	0,							/* U+000230 */
	0,							/* U+000232 */
	0,							/* U+00023a */
	0,							/* U+00023b */
	0,							/* U+00023e */
	0,							/* U+00023f */
	0,							/* U+000240 */
	0,							/* U+000241 */
	0,							/* U+000244 */
	0,							/* U+000245 */
	0,							/* U+000246 */
	0,							/* U+000248 */
	0,							/* U+00024a */
	0,							/* U+00024c */
	0,							/* U+00024e */
	0,							/* U+000250 */
	0,							/* U+000251 */
	0,							/* U+000252 */
	0,							/* U+00025c */
	0,							/* U+000261 */
	0,							/* U+000264 */
	0,							/* U+000265 */
	0,							/* U+000266 */
	0,							/* U+00026a */
	0,							/* U+00026b */
	0,							/* U+00026c */
	0,							/* U+000271 */
	0,							/* U+00027d */
	0,							/* U+000282 */
	0,							/* U+000287 */
	0,							/* U+00029d */
	0,							/* U+00029e */
	0,							/* U+000345 */
	0,							/* U+000370 */
	0,							/* U+000372 */
	0,							/* U+000376 */
	0,							/* U+00037b */
	0,							/* U+00037c */
	0,							/* U+00037d */
	0,							/* U+00037f */
	0,							/* U+000386 */
	0,							/* U+000388 */
	0,							/* U+000389 */
	0,							/* U+00038a */
	0,							/* U+00038c */
	0,							/* U+00038e */
	0,							/* U+00038f */
	5,							/* U+000390 */
	0,							/* U+000391 */
	0,							/* U+000392 */
	0,							/* U+000393 */
	0,							/* U+000394 */
	0,							/* U+000395 */
	0,							/* U+000396 */
	0,							/* U+000397 */
	0,							/* U+000398 */
	0,							/* U+000399 */
	0,							/* U+00039a */
	0,							/* U+00039b */
	0,							/* U+00039c */
	0,							/* U+00039d */
	0,							/* U+00039e */
	0,							/* U+00039f */
	0,							/* U+0003a0 */
	0,							/* U+0003a1 */
	6,							/* U+0003a3 */
	0,							/* U+0003a4 */
	0,							/* U+0003a5 */
	0,							/* U+0003a6 */
	0,							/* U+0003a7 */
	0,							/* U+0003a8 */
	0,							/* U+0003a9 */
	0,							/* U+0003aa */
	0,							/* U+0003ab */
	7,							/* U+0003b0 */
	0,							/* U+0003c2 */
	0,							/* U+0003c3 */
	0,							/* U+0003cf */
	0,							/* U+0003d0 */
	0,							/* U+0003d1 */
	0,							/* U+0003d5 */
	0,							/* U+0003d6 */
	0,							/* U+0003d8 */
	0,							/* U+0003da */
	0,							/* U+0003dc */
	0,							/* U+0003de */
	0,							/* U+0003e0 */
	0,							/* U+0003e2 */
	0,							/* U+0003e4 */
	0,							/* U+0003e6 */
	0,							/* U+0003e8 */
	0,							/* U+0003ea */
	0,							/* U+0003ec */
	0,							/* U+0003ee */
	0,							/* U+0003f0 */
	0,							/* U+0003f1 */
	0,							/* U+0003f2 */
	0,							/* U+0003f4 */
	0,							/* U+0003f5 */
	0,							/* U+0003f7 */
	0,							/* U+0003fa */
	0,							/* U+000400 */
	0,							/* U+000401 */
	0,							/* U+000402 */
	0,							/* U+000403 */
	0,							/* U+000404 */
	0,							/* U+000405 */
	0,							/* U+000406 */
	0,							/* U+000407 */
	0,							/* U+000408 */
	0,							/* U+000409 */
	0,							/* U+00040a */
	0,							/* U+00040b */
	0,							/* U+00040c */
	0,							/* U+00040d */
	0,							/* U+00040e */
	0,							/* U+00040f */
	0,							/* U+000410 */
	0,							/* U+000411 */
	0,							/* U+000412 */
	0,							/* U+000413 */
	0,							/* U+000414 */
	0,							/* U+000415 */
	0,							/* U+000416 */
	0,							/* U+000417 */
	0,							/* U+000418 */
	0,							/* U+000419 */
	0,							/* U+00041a */
	0,							/* U+00041b */
	0,							/* U+00041c */
	0,							/* U+00041d */
	0,							/* U+00041e */
	0,							/* U+00041f */
	0,							/* U+000420 */
	0,							/* U+000421 */
	0,							/* U+000422 */
	0,							/* U+000423 */
	0,							/* U+000424 */
	0,							/* U+000425 */
	0,							/* U+000426 */
	0,							/* U+000427 */
	0,							/* U+000428 */
	0,							/* U+000429 */
	0,							/* U+00042a */
	0,							/* U+00042b */
	0,							/* U+00042c */
	0,							/* U+00042d */
	0,							/* U+00042e */
	0,							/* U+00042f */
	0,							/* U+000460 */
	0,							/* U+000462 */
	0,							/* U+000464 */
	0,							/* U+000466 */
	0,							/* U+000468 */
	0,							/* U+00046a */
	0,							/* U+00046c */
	0,							/* U+00046e */
	0,							/* U+000470 */
	0,							/* U+000472 */
	0,							/* U+000474 */
	0,							/* U+000476 */
	0,							/* U+000478 */
	0,							/* U+00047a */
	0,							/* U+00047c */
	0,							/* U+00047e */
	0,							/* U+000480 */
	0,							/* U+00048a */
	0,							/* U+00048c */
	0,							/* U+00048e */
	0,							/* U+000490 */
	0,							/* U+000492 */
	0,							/* U+000494 */
	0,							/* U+000496 */
	0,							/* U+000498 */
	0,							/* U+00049a */
	0,							/* U+00049c */
	0,							/* U+00049e */
	0,							/* U+0004a0 */
	0,							/* U+0004a2 */
	0,							/* U+0004a4 */
	0,							/* U+0004a6 */
	0,							/* U+0004a8 */
	0,							/* U+0004aa */
	0,							/* U+0004ac */
	0,							/* U+0004ae */
	0,							/* U+0004b0 */
	0,							/* U+0004b2 */
	0,							/* U+0004b4 */
	0,							/* U+0004b6 */
	0,							/* U+0004b8 */
	0,							/* U+0004ba */
	0,							/* U+0004bc */
	0,							/* U+0004be */
	0,							/* U+0004c0 */
	0,							/* U+0004c1 */
	0,							/* U+0004c3 */
	0,							/* U+0004c5 */
	0,							/* U+0004c7 */
	0,							/* U+0004c9 */
	0,							/* U+0004cb */
	0,							/* U+0004cd */
	0,							/* U+0004d0 */
	0,							/* U+0004d2 */
	0,							/* U+0004d4 */
	0,							/* U+0004d6 */
	0,							/* U+0004d8 */
	0,							/* U+0004da */
	0,							/* U+0004dc */
	0,							/* U+0004de */
	0,							/* U+0004e0 */
	0,							/* U+0004e2 */
	0,							/* U+0004e4 */
	0,							/* U+0004e6 */
	0,							/* U+0004e8 */
	0,							/* U+0004ea */
	0,							/* U+0004ec */
	0,							/* U+0004ee */
	0,							/* U+0004f0 */
	0,							/* U+0004f2 */
	0,							/* U+0004f4 */
	0,							/* U+0004f6 */
	0,							/* U+0004f8 */
	0,							/* U+0004fa */
	0,							/* U+0004fc */
	0,							/* U+0004fe */
	0,							/* U+000500 */
	0,							/* U+000502 */
	0,							/* U+000504 */
	0,							/* U+000506 */
	0,							/* U+000508 */
	0,							/* U+00050a */
	0,							/* U+00050c */
	0,							/* U+00050e */
	0,							/* U+000510 */
	0,							/* U+000512 */
	0,							/* U+000514 */
	0,							/* U+000516 */
	0,							/* U+000518 */
	0,							/* U+00051a */
	0,							/* U+00051c */
	0,							/* U+00051e */
	0,							/* U+000520 */
	0,							/* U+000522 */
	0,							/* U+000524 */
	0,							/* U+000526 */
	0,							/* U+000528 */
	0,							/* U+00052a */
	0,							/* U+00052c */
	0,							/* U+00052e */
	0,							/* U+000531 */
	0,							/* U+000532 */
	0,							/* U+000533 */
	0,							/* U+000534 */
	0,							/* U+000535 */
	0,							/* U+000536 */
	0,							/* U+000537 */
	0,							/* U+000538 */
	0,							/* U+000539 */
	0,							/* U+00053a */
	0,							/* U+00053b */
	0,							/* U+00053c */
	0,							/* U+00053d */
	0,							/* U+00053e */
	0,							/* U+00053f */
	0,							/* U+000540 */
	0,							/* U+000541 */
	0,							/* U+000542 */
	0,							/* U+000543 */
	0,							/* U+000544 */
	0,							/* U+000545 */
	0,							/* U+000546 */
	0,							/* U+000547 */
	0,							/* U+000548 */
	0,							/* U+000549 */
	0,							/* U+00054a */
	0,							/* U+00054b */
	0,							/* U+00054c */
	0,							/* U+00054d */
	0,							/* U+00054e */
	0,							/* U+00054f */
	0,							/* U+000550 */
	0,							/* U+000551 */
	0,							/* U+000552 */
	0,							/* U+000553 */
	0,							/* U+000554 */
	0,							/* U+000555 */
	0,							/* U+000556 */
	8,							/* U+000587 */
	0,							/* U+0010a0 */
	0,							/* U+0010a1 */
	0,							/* U+0010a2 */
	0,							/* U+0010a3 */
	0,							/* U+0010a4 */
	0,							/* U+0010a5 */
	0,							/* U+0010a6 */
	0,							/* U+0010a7 */
	0,							/* U+0010a8 */
	0,							/* U+0010a9 */
	0,							/* U+0010aa */
	0,							/* U+0010ab */
	0,							/* U+0010ac */
	0,							/* U+0010ad */
	0,							/* U+0010ae */
	0,							/* U+0010af */
	0,							/* U+0010b0 */
	0,							/* U+0010b1 */
	0,							/* U+0010b2 */
	0,							/* U+0010b3 */
	0,							/* U+0010b4 */
	0,							/* U+0010b5 */
	0,							/* U+0010b6 */
	0,							/* U+0010b7 */
	0,							/* U+0010b8 */
	0,							/* U+0010b9 */
	0,							/* U+0010ba */
	0,							/* U+0010bb */
	0,							/* U+0010bc */
	0,							/* U+0010bd */
	0,							/* U+0010be */
	0,							/* U+0010bf */
	0,							/* U+0010c0 */
	0,							/* U+0010c1 */
	0,							/* U+0010c2 */
	0,							/* U+0010c3 */
	0,							/* U+0010c4 */
	0,							/* U+0010c5 */
	0,							/* U+0010c7 */
	0,							/* U+0010cd */
	0,							/* U+0010d0 */
	0,							/* U+0010d1 */
	0,							/* U+0010d2 */
	0,							/* U+0010d3 */
	0,							/* U+0010d4 */
	0,							/* U+0010d5 */
	0,							/* U+0010d6 */
	0,							/* U+0010d7 */
	0,							/* U+0010d8 */
	0,							/* U+0010d9 */
	0,							/* U+0010da */
	0,							/* U+0010db */
	0,							/* U+0010dc */
	0,							/* U+0010dd */
	0,							/* U+0010de */
	0,							/* U+0010df */
	0,							/* U+0010e0 */
	0,							/* U+0010e1 */
	0,							/* U+0010e2 */
	0,							/* U+0010e3 */
	0,							/* U+0010e4 */
	0,							/* U+0010e5 */
	0,							/* U+0010e6 */
	0,							/* U+0010e7 */
	0,							/* U+0010e8 */
	0,							/* U+0010e9 */
	0,							/* U+0010ea */
	0,							/* U+0010eb */
	0,							/* U+0010ec */
	0,							/* U+0010ed */
	0,							/* U+0010ee */
	0,							/* U+0010ef */
	0,							/* U+0010f0 */
	0,							/* U+0010f1 */
	0,							/* U+0010f2 */
	0,							/* U+0010f3 */
	0,							/* U+0010f4 */
	0,							/* U+0010f5 */
	0,							/* U+0010f6 */
	0,							/* U+0010f7 */
	0,							/* U+0010f8 */
	0,							/* U+0010f9 */
	0,							/* U+0010fa */
	0,							/* U+0010fd */
	0,							/* U+0010fe */
	0,							/* U+0010ff */
	0,							/* U+0013a0 */
	0,							/* U+0013a1 */
	0,							/* U+0013a2 */
	0,							/* U+0013a3 */
	0,							/* U+0013a4 */
	0,							/* U+0013a5 */
	0,							/* U+0013a6 */
	0,							/* U+0013a7 */
	0,							/* U+0013a8 */
	0,							/* U+0013a9 */
	0,							/* U+0013aa */
	0,							/* U+0013ab */
	0,							/* U+0013ac */
	0,							/* U+0013ad */
	0,							/* U+0013ae */
	0,							/* U+0013af */
	0,							/* U+0013b0 */
	0,							/* U+0013b1 */
	0,							/* U+0013b2 */
	0,							/* U+0013b3 */
	0,							/* U+0013b4 */
	0,							/* U+0013b5 */
	0,							/* U+0013b6 */
	0,							/* U+0013b7 */
	0,							/* U+0013b8 */
	0,							/* U+0013b9 */
	0,							/* U+0013ba */
	0,							/* U+0013bb */
	0,							/* U+0013bc */
	0,							/* U+0013bd */
	0,							/* U+0013be */
	0,							/* U+0013bf */
	0,							/* U+0013c0 */
	0,							/* U+0013c1 */
	0,							/* U+0013c2 */
	0,							/* U+0013c3 */
	0,							/* U+0013c4 */
	0,							/* U+0013c5 */
	0,							/* U+0013c6 */
	0,							/* U+0013c7 */
	0,							/* U+0013c8 */
	0,							/* U+0013c9 */
	0,							/* U+0013ca */
	0,							/* U+0013cb */
	0,							/* U+0013cc */
	0,							/* U+0013cd */
	0,							/* U+0013ce */
	0,							/* U+0013cf */
	0,							/* U+0013d0 */
	0,							/* U+0013d1 */
	0,							/* U+0013d2 */
	0,							/* U+0013d3 */
	0,							/* U+0013d4 */
	0,							/* U+0013d5 */
	0,							/* U+0013d6 */
	0,							/* U+0013d7 */
	0,							/* U+0013d8 */
	0,							/* U+0013d9 */
	0,							/* U+0013da */
	0,							/* U+0013db */
	0,							/* U+0013dc */
	0,							/* U+0013dd */
	0,							/* U+0013de */
	0,							/* U+0013df */
	0,							/* U+0013e0 */
	0,							/* U+0013e1 */
	0,							/* U+0013e2 */
	0,							/* U+0013e3 */
	0,							/* U+0013e4 */
	0,							/* U+0013e5 */
	0,							/* U+0013e6 */
	0,							/* U+0013e7 */
	0,							/* U+0013e8 */
	0,							/* U+0013e9 */
	0,							/* U+0013ea */
	0,							/* U+0013eb */
	0,							/* U+0013ec */
	0,							/* U+0013ed */
	0,							/* U+0013ee */
	0,							/* U+0013ef */
	0,							/* U+0013f0 */
	0,							/* U+0013f1 */
	0,							/* U+0013f2 */
	0,							/* U+0013f3 */
	0,							/* U+0013f4 */
	0,							/* U+0013f5 */
	0,							/* U+001c80 */
	0,							/* U+001c81 */
	0,							/* U+001c82 */
	0,							/* U+001c83 */
	0,							/* U+001c84 */
	0,							/* U+001c85 */
	0,							/* U+001c86 */
	0,							/* U+001c87 */
	0,							/* U+001c88 */
	0,							/* U+001c89 */
	0,							/* U+001c90 */
	0,							/* U+001c91 */
	0,							/* U+001c92 */
	0,							/* U+001c93 */
	0,							/* U+001c94 */
	0,							/* U+001c95 */
	0,							/* U+001c96 */
	0,							/* U+001c97 */
	0,							/* U+001c98 */
	0,							/* U+001c99 */
	0,							/* U+001c9a */
	0,							/* U+001c9b */
	0,							/* U+001c9c */
	0,							/* U+001c9d */
	0,							/* U+001c9e */
	0,							/* U+001c9f */
	0,							/* U+001ca0 */
	0,							/* U+001ca1 */
	0,							/* U+001ca2 */
	0,							/* U+001ca3 */
	0,							/* U+001ca4 */
	0,							/* U+001ca5 */
	0,							/* U+001ca6 */
	0,							/* U+001ca7 */
	0,							/* U+001ca8 */
	0,							/* U+001ca9 */
	0,							/* U+001caa */
	0,							/* U+001cab */
	0,							/* U+001cac */
	0,							/* U+001cad */
	0,							/* U+001cae */
	0,							/* U+001caf */
	0,							/* U+001cb0 */
	0,							/* U+001cb1 */
	0,							/* U+001cb2 */
	0,							/* U+001cb3 */
	0,							/* U+001cb4 */
	0,							/* U+001cb5 */
	0,							/* U+001cb6 */
	0,							/* U+001cb7 */
	0,							/* U+001cb8 */
	0,							/* U+001cb9 */
	0,							/* U+001cba */
	0,							/* U+001cbd */
	0,							/* U+001cbe */
	0,							/* U+001cbf */
	0,							/* U+001d79 */
	0,							/* U+001d7d */
	0,							/* U+001d8e */
	0,							/* U+001e00 */
	0,							/* U+001e02 */
	0,							/* U+001e04 */
	0,							/* U+001e06 */
	0,							/* U+001e08 */
	0,							/* U+001e0a */
	0,							/* U+001e0c */
	0,							/* U+001e0e */
	0,							/* U+001e10 */
	0,							/* U+001e12 */
	0,							/* U+001e14 */
	0,							/* U+001e16 */
	0,							/* U+001e18 */
	0,							/* U+001e1a */
	0,							/* U+001e1c */
	0,							/* U+001e1e */
	0,							/* U+001e20 */
	0,							/* U+001e22 */
	0,							/* U+001e24 */
	0,							/* U+001e26 */
	0,							/* U+001e28 */
	0,							/* U+001e2a */
	0,							/* U+001e2c */
	0,							/* U+001e2e */
	0,							/* U+001e30 */
	0,							/* U+001e32 */
	0,							/* U+001e34 */
	0,							/* U+001e36 */
	0,							/* U+001e38 */
	0,							/* U+001e3a */
	0,							/* U+001e3c */
	0,							/* U+001e3e */
	0,							/* U+001e40 */
	0,							/* U+001e42 */
	0,							/* U+001e44 */
	0,							/* U+001e46 */
	0,							/* U+001e48 */
	0,							/* U+001e4a */
	0,							/* U+001e4c */
	0,							/* U+001e4e */
	0,							/* U+001e50 */
	0,							/* U+001e52 */
	0,							/* U+001e54 */
	0,							/* U+001e56 */
	0,							/* U+001e58 */
	0,							/* U+001e5a */
	0,							/* U+001e5c */
	0,							/* U+001e5e */
	0,							/* U+001e60 */
	0,							/* U+001e62 */
	0,							/* U+001e64 */
	0,							/* U+001e66 */
	0,							/* U+001e68 */
	0,							/* U+001e6a */
	0,							/* U+001e6c */
	0,							/* U+001e6e */
	0,							/* U+001e70 */
	0,							/* U+001e72 */
	0,							/* U+001e74 */
	0,							/* U+001e76 */
	0,							/* U+001e78 */
	0,							/* U+001e7a */
	0,							/* U+001e7c */
	0,							/* U+001e7e */
	0,							/* U+001e80 */
	0,							/* U+001e82 */
	0,							/* U+001e84 */
	0,							/* U+001e86 */
	0,							/* U+001e88 */
	0,							/* U+001e8a */
	0,							/* U+001e8c */
	0,							/* U+001e8e */
	0,							/* U+001e90 */
	0,							/* U+001e92 */
	0,							/* U+001e94 */
	9,							/* U+001e96 */
	10,							/* U+001e97 */
	11,							/* U+001e98 */
	12,							/* U+001e99 */
	13,							/* U+001e9a */
	0,							/* U+001e9b */
	14,							/* U+001e9e */
	0,							/* U+001ea0 */
	0,							/* U+001ea2 */
	0,							/* U+001ea4 */
	0,							/* U+001ea6 */
	0,							/* U+001ea8 */
	0,							/* U+001eaa */
	0,							/* U+001eac */
	0,							/* U+001eae */
	0,							/* U+001eb0 */
	0,							/* U+001eb2 */
	0,							/* U+001eb4 */
	0,							/* U+001eb6 */
	0,							/* U+001eb8 */
	0,							/* U+001eba */
	0,							/* U+001ebc */
	0,							/* U+001ebe */
	0,							/* U+001ec0 */
	0,							/* U+001ec2 */
	0,							/* U+001ec4 */
	0,							/* U+001ec6 */
	0,							/* U+001ec8 */
	0,							/* U+001eca */
	0,							/* U+001ecc */
	0,							/* U+001ece */
	0,							/* U+001ed0 */
	0,							/* U+001ed2 */
	0,							/* U+001ed4 */
	0,							/* U+001ed6 */
	0,							/* U+001ed8 */
	0,							/* U+001eda */
	0,							/* U+001edc */
	0,							/* U+001ede */
	0,							/* U+001ee0 */
	0,							/* U+001ee2 */
	0,							/* U+001ee4 */
	0,							/* U+001ee6 */
	0,							/* U+001ee8 */
	0,							/* U+001eea */
	0,							/* U+001eec */
	0,							/* U+001eee */
	0,							/* U+001ef0 */
	0,							/* U+001ef2 */
	0,							/* U+001ef4 */
	0,							/* U+001ef6 */
	0,							/* U+001ef8 */
	0,							/* U+001efa */
	0,							/* U+001efc */
	0,							/* U+001efe */
	0,							/* U+001f00 */
	0,							/* U+001f01 */
	0,							/* U+001f02 */
	0,							/* U+001f03 */
	0,							/* U+001f04 */
	0,							/* U+001f05 */
	0,							/* U+001f06 */
	0,							/* U+001f07 */
	0,							/* U+001f10 */
	0,							/* U+001f11 */
	0,							/* U+001f12 */
	0,							/* U+001f13 */
	0,							/* U+001f14 */
	0,							/* U+001f15 */
	0,							/* U+001f20 */
	0,							/* U+001f21 */
	0,							/* U+001f22 */
	0,							/* U+001f23 */
	0,							/* U+001f24 */
	0,							/* U+001f25 */
	0,							/* U+001f26 */
	0,							/* U+001f27 */
	0,							/* U+001f30 */
	0,							/* U+001f31 */
	0,							/* U+001f32 */
	0,							/* U+001f33 */
	0,							/* U+001f34 */
	0,							/* U+001f35 */
	0,							/* U+001f36 */
	0,							/* U+001f37 */
	0,							/* U+001f40 */
	0,							/* U+001f41 */
	0,							/* U+001f42 */
	0,							/* U+001f43 */
	0,							/* U+001f44 */
	0,							/* U+001f45 */
	15,							/* U+001f50 */
	0,							/* U+001f51 */
	16,							/* U+001f52 */
	0,							/* U+001f53 */
	17,							/* U+001f54 */
	0,							/* U+001f55 */
	18,							/* U+001f56 */
	0,							/* U+001f57 */
	0,							/* U+001f60 */
	0,							/* U+001f61 */
	0,							/* U+001f62 */
	0,							/* U+001f63 */
	0,							/* U+001f64 */
	0,							/* U+001f65 */
	0,							/* U+001f66 */
	0,							/* U+001f67 */
	0,							/* U+001f70 */
	0,							/* U+001f71 */
	0,							/* U+001f72 */
	0,							/* U+001f73 */
	0,							/* U+001f74 */
	0,							/* U+001f75 */
	0,							/* U+001f76 */
	0,							/* U+001f77 */
	0,							/* U+001f78 */
	0,							/* U+001f79 */
	0,							/* U+001f7a */
	0,							/* U+001f7b */
	0,							/* U+001f7c */
	0,							/* U+001f7d */
	19,							/* U+001f80 */
	20,							/* U+001f81 */
	21,							/* U+001f82 */
	22,							/* U+001f83 */
	23,							/* U+001f84 */
	24,							/* U+001f85 */
	25,							/* U+001f86 */
	26,							/* U+001f87 */
	27,							/* U+001f88 */
	28,							/* U+001f89 */
	29,							/* U+001f8a */
	30,							/* U+001f8b */
	31,							/* U+001f8c */
	32,							/* U+001f8d */
	33,							/* U+001f8e */
	34,							/* U+001f8f */
	35,							/* U+001f90 */
	36,							/* U+001f91 */
	37,							/* U+001f92 */
	38,							/* U+001f93 */
	39,							/* U+001f94 */
	40,							/* U+001f95 */
	41,							/* U+001f96 */
	42,							/* U+001f97 */
	43,							/* U+001f98 */
	44,							/* U+001f99 */
	45,							/* U+001f9a */
	46,							/* U+001f9b */
	47,							/* U+001f9c */
	48,							/* U+001f9d */
	49,							/* U+001f9e */
	50,							/* U+001f9f */
	51,							/* U+001fa0 */
	52,							/* U+001fa1 */
	53,							/* U+001fa2 */
	54,							/* U+001fa3 */
	55,							/* U+001fa4 */
	56,							/* U+001fa5 */
	57,							/* U+001fa6 */
	58,							/* U+001fa7 */
	59,							/* U+001fa8 */
	60,							/* U+001fa9 */
	61,							/* U+001faa */
	62,							/* U+001fab */
	63,							/* U+001fac */
	64,							/* U+001fad */
	65,							/* U+001fae */
	66,							/* U+001faf */
	0,							/* U+001fb0 */
	0,							/* U+001fb1 */
	67,							/* U+001fb2 */
	68,							/* U+001fb3 */
	69,							/* U+001fb4 */
	70,							/* U+001fb6 */
	71,							/* U+001fb7 */
	72,							/* U+001fbc */
	0,							/* U+001fbe */
	73,							/* U+001fc2 */
	74,							/* U+001fc3 */
	75,							/* U+001fc4 */
	76,							/* U+001fc6 */
	77,							/* U+001fc7 */
	78,							/* U+001fcc */
	0,							/* U+001fd0 */
	0,							/* U+001fd1 */
	79,							/* U+001fd2 */
	80,							/* U+001fd3 */
	81,							/* U+001fd6 */
	82,							/* U+001fd7 */
	0,							/* U+001fe0 */
	0,							/* U+001fe1 */
	83,							/* U+001fe2 */
	84,							/* U+001fe3 */
	85,							/* U+001fe4 */
	0,							/* U+001fe5 */
	86,							/* U+001fe6 */
	87,							/* U+001fe7 */
	88,							/* U+001ff2 */
	89,							/* U+001ff3 */
	90,							/* U+001ff4 */
	91,							/* U+001ff6 */
	92,							/* U+001ff7 */
	93,							/* U+001ffc */
	0,							/* U+002126 */
	0,							/* U+00212a */
	0,							/* U+00212b */
	0,							/* U+002132 */
	0,							/* U+002160 */
	0,							/* U+002161 */
	0,							/* U+002162 */
	0,							/* U+002163 */
	0,							/* U+002164 */
	0,							/* U+002165 */
	0,							/* U+002166 */
	0,							/* U+002167 */
	0,							/* U+002168 */
	0,							/* U+002169 */
	0,							/* U+00216a */
	0,							/* U+00216b */
	0,							/* U+00216c */
	0,							/* U+00216d */
	0,							/* U+00216e */
	0,							/* U+00216f */
	0,							/* U+002183 */
	0,							/* U+0024b6 */
	0,							/* U+0024b7 */
	0,							/* U+0024b8 */
	0,							/* U+0024b9 */
	0,							/* U+0024ba */
	0,							/* U+0024bb */
	0,							/* U+0024bc */
	0,							/* U+0024bd */
	0,							/* U+0024be */
	0,							/* U+0024bf */
	0,							/* U+0024c0 */
	0,							/* U+0024c1 */
	0,							/* U+0024c2 */
	0,							/* U+0024c3 */
	0,							/* U+0024c4 */
	0,							/* U+0024c5 */
	0,							/* U+0024c6 */
	0,							/* U+0024c7 */
	0,							/* U+0024c8 */
	0,							/* U+0024c9 */
	0,							/* U+0024ca */
	0,							/* U+0024cb */
	0,							/* U+0024cc */
	0,							/* U+0024cd */
	0,							/* U+0024ce */
	0,							/* U+0024cf */
	0,							/* U+002c00 */
	0,							/* U+002c01 */
	0,							/* U+002c02 */
	0,							/* U+002c03 */
	0,							/* U+002c04 */
	0,							/* U+002c05 */
	0,							/* U+002c06 */
	0,							/* U+002c07 */
	0,							/* U+002c08 */
	0,							/* U+002c09 */
	0,							/* U+002c0a */
	0,							/* U+002c0b */
	0,							/* U+002c0c */
	0,							/* U+002c0d */
	0,							/* U+002c0e */
	0,							/* U+002c0f */
	0,							/* U+002c10 */
	0,							/* U+002c11 */
	0,							/* U+002c12 */
	0,							/* U+002c13 */
	0,							/* U+002c14 */
	0,							/* U+002c15 */
	0,							/* U+002c16 */
	0,							/* U+002c17 */
	0,							/* U+002c18 */
	0,							/* U+002c19 */
	0,							/* U+002c1a */
	0,							/* U+002c1b */
	0,							/* U+002c1c */
	0,							/* U+002c1d */
	0,							/* U+002c1e */
	0,							/* U+002c1f */
	0,							/* U+002c20 */
	0,							/* U+002c21 */
	0,							/* U+002c22 */
	0,							/* U+002c23 */
	0,							/* U+002c24 */
	0,							/* U+002c25 */
	0,							/* U+002c26 */
	0,							/* U+002c27 */
	0,							/* U+002c28 */
	0,							/* U+002c29 */
	0,							/* U+002c2a */
	0,							/* U+002c2b */
	0,							/* U+002c2c */
	0,							/* U+002c2d */
	0,							/* U+002c2e */
	0,							/* U+002c2f */
	0,							/* U+002c60 */
	0,							/* U+002c67 */
	0,							/* U+002c69 */
	0,							/* U+002c6b */
	0,							/* U+002c72 */
	0,							/* U+002c75 */
	0,							/* U+002c80 */
	0,							/* U+002c82 */
	0,							/* U+002c84 */
	0,							/* U+002c86 */
	0,							/* U+002c88 */
	0,							/* U+002c8a */
	0,							/* U+002c8c */
	0,							/* U+002c8e */
	0,							/* U+002c90 */
	0,							/* U+002c92 */
	0,							/* U+002c94 */
	0,							/* U+002c96 */
	0,							/* U+002c98 */
	0,							/* U+002c9a */
	0,							/* U+002c9c */
	0,							/* U+002c9e */
	0,							/* U+002ca0 */
	0,							/* U+002ca2 */
	0,							/* U+002ca4 */
	0,							/* U+002ca6 */
	0,							/* U+002ca8 */
	0,							/* U+002caa */
	0,							/* U+002cac */
	0,							/* U+002cae */
	0,							/* U+002cb0 */
	0,							/* U+002cb2 */
	0,							/* U+002cb4 */
	0,							/* U+002cb6 */
	0,							/* U+002cb8 */
	0,							/* U+002cba */
	0,							/* U+002cbc */
	0,							/* U+002cbe */
	0,							/* U+002cc0 */
	0,							/* U+002cc2 */
	0,							/* U+002cc4 */
	0,							/* U+002cc6 */
	0,							/* U+002cc8 */
	0,							/* U+002cca */
	0,							/* U+002ccc */
	0,							/* U+002cce */
	0,							/* U+002cd0 */
	0,							/* U+002cd2 */
	0,							/* U+002cd4 */
	0,							/* U+002cd6 */
	0,							/* U+002cd8 */
	0,							/* U+002cda */
	0,							/* U+002cdc */
	0,							/* U+002cde */
	0,							/* U+002ce0 */
	0,							/* U+002ce2 */
	0,							/* U+002ceb */
	0,							/* U+002ced */
	0,							/* U+002cf2 */
	0,							/* U+00a640 */
	0,							/* U+00a642 */
	0,							/* U+00a644 */
	0,							/* U+00a646 */
	0,							/* U+00a648 */
	0,							/* U+00a64a */
	0,							/* U+00a64c */
	0,							/* U+00a64e */
	0,							/* U+00a650 */
	0,							/* U+00a652 */
	0,							/* U+00a654 */
	0,							/* U+00a656 */
	0,							/* U+00a658 */
	0,							/* U+00a65a */
	0,							/* U+00a65c */
	0,							/* U+00a65e */
	0,							/* U+00a660 */
	0,							/* U+00a662 */
	0,							/* U+00a664 */
	0,							/* U+00a666 */
	0,							/* U+00a668 */
	0,							/* U+00a66a */
	0,							/* U+00a66c */
	0,							/* U+00a680 */
	0,							/* U+00a682 */
	0,							/* U+00a684 */
	0,							/* U+00a686 */
	0,							/* U+00a688 */
	0,							/* U+00a68a */
	0,							/* U+00a68c */
	0,							/* U+00a68e */
	0,							/* U+00a690 */
	0,							/* U+00a692 */
	0,							/* U+00a694 */
	0,							/* U+00a696 */
	0,							/* U+00a698 */
	0,							/* U+00a69a */
	0,							/* U+00a722 */
	0,							/* U+00a724 */
	0,							/* U+00a726 */
	0,							/* U+00a728 */
	0,							/* U+00a72a */
	0,							/* U+00a72c */
	0,							/* U+00a72e */
	0,							/* U+00a732 */
	0,							/* U+00a734 */
	0,							/* U+00a736 */
	0,							/* U+00a738 */
	0,							/* U+00a73a */
	0,							/* U+00a73c */
	0,							/* U+00a73e */
	0,							/* U+00a740 */
	0,							/* U+00a742 */
	0,							/* U+00a744 */
	0,							/* U+00a746 */
	0,							/* U+00a748 */
	0,							/* U+00a74a */
	0,							/* U+00a74c */
	0,							/* U+00a74e */
	0,							/* U+00a750 */
	0,							/* U+00a752 */
	0,							/* U+00a754 */
	0,							/* U+00a756 */
	0,							/* U+00a758 */
	0,							/* U+00a75a */
	0,							/* U+00a75c */
	0,							/* U+00a75e */
	0,							/* U+00a760 */
	0,							/* U+00a762 */
	0,							/* U+00a764 */
	0,							/* U+00a766 */
	0,							/* U+00a768 */
	0,							/* U+00a76a */
	0,							/* U+00a76c */
	0,							/* U+00a76e */
	0,							/* U+00a779 */
	0,							/* U+00a77b */
	0,							/* U+00a77e */
	0,							/* U+00a780 */
	0,							/* U+00a782 */
	0,							/* U+00a784 */
	0,							/* U+00a786 */
	0,							/* U+00a78b */
	0,							/* U+00a790 */
	0,							/* U+00a792 */
	0,							/* U+00a794 */
	0,							/* U+00a796 */
	0,							/* U+00a798 */
	0,							/* U+00a79a */
	0,							/* U+00a79c */
	0,							/* U+00a79e */
	0,							/* U+00a7a0 */
	0,							/* U+00a7a2 */
	0,							/* U+00a7a4 */
	0,							/* U+00a7a6 */
	0,							/* U+00a7a8 */
	0,							/* U+00a7b3 */
	0,							/* U+00a7b4 */
	0,							/* U+00a7b6 */
	0,							/* U+00a7b8 */
	0,							/* U+00a7ba */
	0,							/* U+00a7bc */
	0,							/* U+00a7be */
	0,							/* U+00a7c0 */
	0,							/* U+00a7c2 */
	0,							/* U+00a7c7 */
	0,							/* U+00a7c9 */
	0,							/* U+00a7cc */
	0,							/* U+00a7d0 */
	0,							/* U+00a7d6 */
	0,							/* U+00a7d8 */
	0,							/* U+00a7da */
	0,							/* U+00a7f5 */
	94,							/* U+00fb00 */
	95,							/* U+00fb01 */
	96,							/* U+00fb02 */
	97,							/* U+00fb03 */
	98,							/* U+00fb04 */
	99,							/* U+00fb05 */
	100,						/* U+00fb06 */
	101,						/* U+00fb13 */
	102,						/* U+00fb14 */
	103,						/* U+00fb15 */
	104,						/* U+00fb16 */
	105,						/* U+00fb17 */
	0,							/* U+00ff21 */
	0,							/* U+00ff22 */
	0,							/* U+00ff23 */
	0,							/* U+00ff24 */
	0,							/* U+00ff25 */
	0,							/* U+00ff26 */
	0,							/* U+00ff27 */
	0,							/* U+00ff28 */
	0,							/* U+00ff29 */
	0,							/* U+00ff2a */
	0,							/* U+00ff2b */
	0,							/* U+00ff2c */
	0,							/* U+00ff2d */
	0,							/* U+00ff2e */
	0,							/* U+00ff2f */
	0,							/* U+00ff30 */
	0,							/* U+00ff31 */
	0,							/* U+00ff32 */
	0,							/* U+00ff33 */
	0,							/* U+00ff34 */
	0,							/* U+00ff35 */
	0,							/* U+00ff36 */
	0,							/* U+00ff37 */
	0,							/* U+00ff38 */
	0,							/* U+00ff39 */
	0,							/* U+00ff3a */
	0,							/* U+010400 */
	0,							/* U+010401 */
	0,							/* U+010402 */
	0,							/* U+010403 */
	0,							/* U+010404 */
	0,							/* U+010405 */
	0,							/* U+010406 */
	0,							/* U+010407 */
	0,							/* U+010408 */
	0,							/* U+010409 */
	0,							/* U+01040a */
	0,							/* U+01040b */
	0,							/* U+01040c */
	0,							/* U+01040d */
	0,							/* U+01040e */
	0,							/* U+01040f */
	0,							/* U+010410 */
	0,							/* U+010411 */
	0,							/* U+010412 */
	0,							/* U+010413 */
	0,							/* U+010414 */
	0,							/* U+010415 */
	0,							/* U+010416 */
	0,							/* U+010417 */
	0,							/* U+010418 */
	0,							/* U+010419 */
	0,							/* U+01041a */
	0,							/* U+01041b */
	0,							/* U+01041c */
	0,							/* U+01041d */
	0,							/* U+01041e */
	0,							/* U+01041f */
	0,							/* U+010420 */
	0,							/* U+010421 */
	0,							/* U+010422 */
	0,							/* U+010423 */
	0,							/* U+010424 */
	0,							/* U+010425 */
	0,							/* U+010426 */
	0,							/* U+010427 */
	0,							/* U+0104b0 */
	0,							/* U+0104b1 */
	0,							/* U+0104b2 */
	0,							/* U+0104b3 */
	0,							/* U+0104b4 */
	0,							/* U+0104b5 */
	0,							/* U+0104b6 */
	0,							/* U+0104b7 */
	0,							/* U+0104b8 */
	0,							/* U+0104b9 */
	0,							/* U+0104ba */
	0,							/* U+0104bb */
	0,							/* U+0104bc */
	0,							/* U+0104bd */
	0,							/* U+0104be */
	0,							/* U+0104bf */
	0,							/* U+0104c0 */
	0,							/* U+0104c1 */
	0,							/* U+0104c2 */
	0,							/* U+0104c3 */
	0,							/* U+0104c4 */
	0,							/* U+0104c5 */
	0,							/* U+0104c6 */
	0,							/* U+0104c7 */
	0,							/* U+0104c8 */
	0,							/* U+0104c9 */
	0,							/* U+0104ca */
	0,							/* U+0104cb */
	0,							/* U+0104cc */
	0,							/* U+0104cd */
	0,							/* U+0104ce */
	0,							/* U+0104cf */
	0,							/* U+0104d0 */
	0,							/* U+0104d1 */
	0,							/* U+0104d2 */
	0,							/* U+0104d3 */
	0,							/* U+010570 */
	0,							/* U+010571 */
	0,							/* U+010572 */
	0,							/* U+010573 */
	0,							/* U+010574 */
	0,							/* U+010575 */
	0,							/* U+010576 */
	0,							/* U+010577 */
	0,							/* U+010578 */
	0,							/* U+010579 */
	0,							/* U+01057a */
	0,							/* U+01057c */
	0,							/* U+01057d */
	0,							/* U+01057e */
	0,							/* U+01057f */
	0,							/* U+010580 */
	0,							/* U+010581 */
	0,							/* U+010582 */
	0,							/* U+010583 */
	0,							/* U+010584 */
	0,							/* U+010585 */
	0,							/* U+010586 */
	0,							/* U+010587 */
	0,							/* U+010588 */
	0,							/* U+010589 */
	0,							/* U+01058a */
	0,							/* U+01058c */
	0,							/* U+01058d */
	0,							/* U+01058e */
	0,							/* U+01058f */
	0,							/* U+010590 */
	0,							/* U+010591 */
	0,							/* U+010592 */
	0,							/* U+010594 */
	0,							/* U+010595 */
	0,							/* U+010c80 */
	0,							/* U+010c81 */
	0,							/* U+010c82 */
	0,							/* U+010c83 */
	0,							/* U+010c84 */
	0,							/* U+010c85 */
	0,							/* U+010c86 */
	0,							/* U+010c87 */
	0,							/* U+010c88 */
	0,							/* U+010c89 */
	0,							/* U+010c8a */
	0,							/* U+010c8b */
	0,							/* U+010c8c */
	0,							/* U+010c8d */
	0,							/* U+010c8e */
	0,							/* U+010c8f */
	0,							/* U+010c90 */
	0,							/* U+010c91 */
	0,							/* U+010c92 */
	0,							/* U+010c93 */
	0,							/* U+010c94 */
	0,							/* U+010c95 */
	0,							/* U+010c96 */
	0,							/* U+010c97 */
	0,							/* U+010c98 */
	0,							/* U+010c99 */
	0,							/* U+010c9a */
	0,							/* U+010c9b */
	0,							/* U+010c9c */
	0,							/* U+010c9d */
	0,							/* U+010c9e */
	0,							/* U+010c9f */
	0,							/* U+010ca0 */
	0,							/* U+010ca1 */
	0,							/* U+010ca2 */
	0,							/* U+010ca3 */
	0,							/* U+010ca4 */
	0,							/* U+010ca5 */
	0,							/* U+010ca6 */
	0,							/* U+010ca7 */
	0,							/* U+010ca8 */
	0,							/* U+010ca9 */
	0,							/* U+010caa */
	0,							/* U+010cab */
	0,							/* U+010cac */
	0,							/* U+010cad */
	0,							/* U+010cae */
	0,							/* U+010caf */
	0,							/* U+010cb0 */
	0,							/* U+010cb1 */
	0,							/* U+010cb2 */
	0,							/* U+010d50 */
	0,							/* U+010d51 */
	0,							/* U+010d52 */
	0,							/* U+010d53 */
	0,							/* U+010d54 */
	0,							/* U+010d55 */
	0,							/* U+010d56 */
	0,							/* U+010d57 */
	0,							/* U+010d58 */
	0,							/* U+010d59 */
	0,							/* U+010d5a */
	0,							/* U+010d5b */
	0,							/* U+010d5c */
	0,							/* U+010d5d */
	0,							/* U+010d5e */
	0,							/* U+010d5f */
	0,							/* U+010d60 */
	0,							/* U+010d61 */
	0,							/* U+010d62 */
	0,							/* U+010d63 */
	0,							/* U+010d64 */
	0,							/* U+010d65 */
	0,							/* U+0118a0 */
	0,							/* U+0118a1 */
	0,							/* U+0118a2 */
	0,							/* U+0118a3 */
	0,							/* U+0118a4 */
	0,							/* U+0118a5 */
	0,							/* U+0118a6 */
	0,							/* U+0118a7 */
	0,							/* U+0118a8 */
	0,							/* U+0118a9 */
	0,							/* U+0118aa */
	0,							/* U+0118ab */
	0,							/* U+0118ac */
	0,							/* U+0118ad */
	0,							/* U+0118ae */
	0,							/* U+0118af */
	0,							/* U+0118b0 */
	0,							/* U+0118b1 */
	0,							/* U+0118b2 */
	0,							/* U+0118b3 */
	0,							/* U+0118b4 */
	0,							/* U+0118b5 */
	0,							/* U+0118b6 */
	0,							/* U+0118b7 */
	0,							/* U+0118b8 */
	0,							/* U+0118b9 */
	0,							/* U+0118ba */
	0,							/* U+0118bb */
	0,							/* U+0118bc */
	0,							/* U+0118bd */
	0,							/* U+0118be */
	0,							/* U+0118bf */
	0,							/* U+016e40 */
	0,							/* U+016e41 */
	0,							/* U+016e42 */
	0,							/* U+016e43 */
	0,							/* U+016e44 */
	0,							/* U+016e45 */
	0,							/* U+016e46 */
	0,							/* U+016e47 */
	0,							/* U+016e48 */
	0,							/* U+016e49 */
	0,							/* U+016e4a */
	0,							/* U+016e4b */
	0,							/* U+016e4c */
	0,							/* U+016e4d */
	0,							/* U+016e4e */
	0,							/* U+016e4f */
	0,							/* U+016e50 */
	0,							/* U+016e51 */
	0,							/* U+016e52 */
	0,							/* U+016e53 */
	0,							/* U+016e54 */
	0,							/* U+016e55 */
	0,							/* U+016e56 */
	0,							/* U+016e57 */
	0,							/* U+016e58 */
	0,							/* U+016e59 */
	0,							/* U+016e5a */
	0,							/* U+016e5b */
	0,							/* U+016e5c */
	0,							/* U+016e5d */
	0,							/* U+016e5e */
	0,							/* U+016e5f */
	0,							/* U+01e900 */
	0,							/* U+01e901 */
	0,							/* U+01e902 */
	0,							/* U+01e903 */
	0,							/* U+01e904 */
	0,							/* U+01e905 */
	0,							/* U+01e906 */
	0,							/* U+01e907 */
	0,							/* U+01e908 */
	0,							/* U+01e909 */
	0,							/* U+01e90a */
	0,							/* U+01e90b */
	0,							/* U+01e90c */
	0,							/* U+01e90d */
	0,							/* U+01e90e */
	0,							/* U+01e90f */
	0,							/* U+01e910 */
	0,							/* U+01e911 */
	0,							/* U+01e912 */
	0,							/* U+01e913 */
	0,							/* U+01e914 */
	0,							/* U+01e915 */
	0,							/* U+01e916 */
	0,							/* U+01e917 */
	0,							/* U+01e918 */
	0,							/* U+01e919 */
	0,							/* U+01e91a */
	0,							/* U+01e91b */
	0,							/* U+01e91c */
	0,							/* U+01e91d */
	0,							/* U+01e91e */
	0,							/* U+01e91f */
	0,							/* U+01e920 */
	0,							/* U+01e921 */

};

/*
 * Used by case_index() to map a codepoint to an index that can be used in any
 * of the following arrays: case_map_lower, case_map_title, case_map_upper,
 * case_map_fold.
 */
static const uint16 case_map[4778] =
{
	1,							/* U+000000 */
	2,							/* U+000001 */
	3,							/* U+000002 */
	4,							/* U+000003 */
	5,							/* U+000004 */
	6,							/* U+000005 */
	7,							/* U+000006 */
	8,							/* U+000007 */
	9,							/* U+000008 */
	10,							/* U+000009 */
	11,							/* U+00000A */
	12,							/* U+00000B */
	13,							/* U+00000C */
	14,							/* U+00000D */
	15,							/* U+00000E */
	16,							/* U+00000F */
	17,							/* U+000010 */
	18,							/* U+000011 */
	19,							/* U+000012 */
	20,							/* U+000013 */
	21,							/* U+000014 */
	22,							/* U+000015 */
	23,							/* U+000016 */
	24,							/* U+000017 */
	25,							/* U+000018 */
	26,							/* U+000019 */
	27,							/* U+00001A */
	28,							/* U+00001B */
	29,							/* U+00001C */
	30,							/* U+00001D */
	31,							/* U+00001E */
	32,							/* U+00001F */
	33,							/* U+000020 */
	34,							/* U+000021 */
	35,							/* U+000022 */
	36,							/* U+000023 */
	37,							/* U+000024 */
	38,							/* U+000025 */
	39,							/* U+000026 */
	40,							/* U+000027 */
	41,							/* U+000028 */
	42,							/* U+000029 */
	43,							/* U+00002A */
	44,							/* U+00002B */
	45,							/* U+00002C */
	46,							/* U+00002D */
	47,							/* U+00002E */
	48,							/* U+00002F */
	49,							/* U+000030 */
	50,							/* U+000031 */
	51,							/* U+000032 */
	52,							/* U+000033 */
	53,							/* U+000034 */
	54,							/* U+000035 */
	55,							/* U+000036 */
	56,							/* U+000037 */
	57,							/* U+000038 */
	58,							/* U+000039 */
	59,							/* U+00003A */
	60,							/* U+00003B */
	61,							/* U+00003C */
	62,							/* U+00003D */
	63,							/* U+00003E */
	64,							/* U+00003F */
	65,							/* U+000040 */
	66,							/* U+000041 */
	67,							/* U+000042 */
	68,							/* U+000043 */
	69,							/* U+000044 */
	70,							/* U+000045 */
	71,							/* U+000046 */
	72,							/* U+000047 */
	73,							/* U+000048 */
	74,							/* U+000049 */
	75,							/* U+00004A */
	76,							/* U+00004B */
	77,							/* U+00004C */
	78,							/* U+00004D */
	79,							/* U+00004E */
	80,							/* U+00004F */
	81,							/* U+000050 */
	82,							/* U+000051 */
	83,							/* U+000052 */
	84,							/* U+000053 */
	85,							/* U+000054 */
	86,							/* U+000055 */
	87,							/* U+000056 */
	88,							/* U+000057 */
	89,							/* U+000058 */
	90,							/* U+000059 */
	91,							/* U+00005A */
	92,							/* U+00005B */
	93,							/* U+00005C */
	94,							/* U+00005D */
	95,							/* U+00005E */
	96,							/* U+00005F */
	97,							/* U+000060 */
	98,							/* U+000061 */
	99,							/* U+000062 */
	100,						/* U+000063 */
	101,						/* U+000064 */
	102,						/* U+000065 */
	103,						/* U+000066 */
	104,						/* U+000067 */
	105,						/* U+000068 */
	106,						/* U+000069 */
	107,						/* U+00006A */
	108,						/* U+00006B */
	109,						/* U+00006C */
	110,						/* U+00006D */
	111,						/* U+00006E */
	112,						/* U+00006F */
	113,						/* U+000070 */
	114,						/* U+000071 */
	115,						/* U+000072 */
	116,						/* U+000073 */
	117,						/* U+000074 */
	118,						/* U+000075 */
	119,						/* U+000076 */
	120,						/* U+000077 */
	121,						/* U+000078 */
	122,						/* U+000079 */
	123,						/* U+00007A */
	124,						/* U+00007B */
	125,						/* U+00007C */
	126,						/* U+00007D */
	127,						/* U+00007E */
	128,						/* U+00007F */
	0,							/* U+000080 */
	0,							/* U+000081 */
	0,							/* U+000082 */
	0,							/* U+000083 */
	0,							/* U+000084 */
	0,							/* U+000085 */
	0,							/* U+000086 */
	0,							/* U+000087 */
	0,							/* U+000088 */
	0,							/* U+000089 */
	0,							/* U+00008A */
	0,							/* U+00008B */
	0,							/* U+00008C */
	0,							/* U+00008D */
	0,							/* U+00008E */
	0,							/* U+00008F */
	0,							/* U+000090 */
	0,							/* U+000091 */
	0,							/* U+000092 */
	0,							/* U+000093 */
	0,							/* U+000094 */
	0,							/* U+000095 */
	0,							/* U+000096 */
	0,							/* U+000097 */
	0,							/* U+000098 */
	0,							/* U+000099 */
	0,							/* U+00009A */
	0,							/* U+00009B */
	0,							/* U+00009C */
	0,							/* U+00009D */
	0,							/* U+00009E */
	0,							/* U+00009F */
	0,							/* U+0000A0 */
	0,							/* U+0000A1 */
	0,							/* U+0000A2 */
	0,							/* U+0000A3 */
	0,							/* U+0000A4 */
	0,							/* U+0000A5 */
	0,							/* U+0000A6 */
	0,							/* U+0000A7 */
	0,							/* U+0000A8 */
	0,							/* U+0000A9 */
	0,							/* U+0000AA */
	0,							/* U+0000AB */
	0,							/* U+0000AC */
	0,							/* U+0000AD */
	0,							/* U+0000AE */
	0,							/* U+0000AF */
	0,							/* U+0000B0 */
	0,							/* U+0000B1 */
	0,							/* U+0000B2 */
	0,							/* U+0000B3 */
	0,							/* U+0000B4 */
	129,						/* U+0000B5 */
	0,							/* U+0000B6 */
	0,							/* U+0000B7 */
	0,							/* U+0000B8 */
	0,							/* U+0000B9 */
	0,							/* U+0000BA */
	0,							/* U+0000BB */
	0,							/* U+0000BC */
	0,							/* U+0000BD */
	0,							/* U+0000BE */
	0,							/* U+0000BF */
	130,						/* U+0000C0 */
	131,						/* U+0000C1 */
	132,						/* U+0000C2 */
	133,						/* U+0000C3 */
	134,						/* U+0000C4 */
	135,						/* U+0000C5 */
	136,						/* U+0000C6 */
	137,						/* U+0000C7 */
	138,						/* U+0000C8 */
	139,						/* U+0000C9 */
	140,						/* U+0000CA */
	141,						/* U+0000CB */
	142,						/* U+0000CC */
	143,						/* U+0000CD */
	144,						/* U+0000CE */
	145,						/* U+0000CF */
	146,						/* U+0000D0 */
	147,						/* U+0000D1 */
	148,						/* U+0000D2 */
	149,						/* U+0000D3 */
	150,						/* U+0000D4 */
	151,						/* U+0000D5 */
	152,						/* U+0000D6 */
	0,							/* U+0000D7 */
	153,						/* U+0000D8 */
	154,						/* U+0000D9 */
	155,						/* U+0000DA */
	156,						/* U+0000DB */
	157,						/* U+0000DC */
	158,						/* U+0000DD */
	159,						/* U+0000DE */
	160,						/* U+0000DF */
	130,						/* U+0000E0 */
	131,						/* U+0000E1 */
	132,						/* U+0000E2 */
	133,						/* U+0000E3 */
	134,						/* U+0000E4 */
	135,						/* U+0000E5 */
	136,						/* U+0000E6 */
	137,						/* U+0000E7 */
	138,						/* U+0000E8 */
	139,						/* U+0000E9 */
	140,						/* U+0000EA */
	141,						/* U+0000EB */
	142,						/* U+0000EC */
	143,						/* U+0000ED */
	144,						/* U+0000EE */
	145,						/* U+0000EF */
	146,						/* U+0000F0 */
	147,						/* U+0000F1 */
	148,						/* U+0000F2 */
	149,						/* U+0000F3 */
	150,						/* U+0000F4 */
	151,						/* U+0000F5 */
	152,						/* U+0000F6 */
	0,							/* U+0000F7 */
	153,						/* U+0000F8 */
	154,						/* U+0000F9 */
	155,						/* U+0000FA */
	156,						/* U+0000FB */
	157,						/* U+0000FC */
	158,						/* U+0000FD */
	159,						/* U+0000FE */
	161,						/* U+0000FF */
	162,						/* U+000100 */
	162,						/* U+000101 */
	163,						/* U+000102 */
	163,						/* U+000103 */
	164,						/* U+000104 */
	164,						/* U+000105 */
	165,						/* U+000106 */
	165,						/* U+000107 */
	166,						/* U+000108 */
	166,						/* U+000109 */
	167,						/* U+00010A */
	167,						/* U+00010B */
	168,						/* U+00010C */
	168,						/* U+00010D */
	169,						/* U+00010E */
	169,						/* U+00010F */
	170,						/* U+000110 */
	170,						/* U+000111 */
	171,						/* U+000112 */
	171,						/* U+000113 */
	172,						/* U+000114 */
	172,						/* U+000115 */
	173,						/* U+000116 */
	173,						/* U+000117 */
	174,						/* U+000118 */
	174,						/* U+000119 */
	175,						/* U+00011A */
	175,						/* U+00011B */
	176,						/* U+00011C */
	176,						/* U+00011D */
	177,						/* U+00011E */
	177,						/* U+00011F */
	178,						/* U+000120 */
	178,						/* U+000121 */
	179,						/* U+000122 */
	179,						/* U+000123 */
	180,						/* U+000124 */
	180,						/* U+000125 */
	181,						/* U+000126 */
	181,						/* U+000127 */
	182,						/* U+000128 */
	182,						/* U+000129 */
	183,						/* U+00012A */
	183,						/* U+00012B */
	184,						/* U+00012C */
	184,						/* U+00012D */
	185,						/* U+00012E */
	185,						/* U+00012F */
	186,						/* U+000130 */
	187,						/* U+000131 */
	188,						/* U+000132 */
	188,						/* U+000133 */
	189,						/* U+000134 */
	189,						/* U+000135 */
	190,						/* U+000136 */
	190,						/* U+000137 */
	0,							/* U+000138 */
	191,						/* U+000139 */
	191,						/* U+00013A */
	192,						/* U+00013B */
	192,						/* U+00013C */
	193,						/* U+00013D */
	193,						/* U+00013E */
	194,						/* U+00013F */
	194,						/* U+000140 */
	195,						/* U+000141 */
	195,						/* U+000142 */
	196,						/* U+000143 */
	196,						/* U+000144 */
	197,						/* U+000145 */
	197,						/* U+000146 */
	198,						/* U+000147 */
	198,						/* U+000148 */
	199,						/* U+000149 */
	200,						/* U+00014A */
	200,						/* U+00014B */
	201,						/* U+00014C */
	201,						/* U+00014D */
	202,						/* U+00014E */
	202,						/* U+00014F */
	203,						/* U+000150 */
	203,						/* U+000151 */
	204,						/* U+000152 */
	204,						/* U+000153 */
	205,						/* U+000154 */
	205,						/* U+000155 */
	206,						/* U+000156 */
	206,						/* U+000157 */
	207,						/* U+000158 */
	207,						/* U+000159 */
	208,						/* U+00015A */
	208,						/* U+00015B */
	209,						/* U+00015C */
	209,						/* U+00015D */
	210,						/* U+00015E */
	210,						/* U+00015F */
	211,						/* U+000160 */
	211,						/* U+000161 */
	212,						/* U+000162 */
	212,						/* U+000163 */
	213,						/* U+000164 */
	213,						/* U+000165 */
	214,						/* U+000166 */
	214,						/* U+000167 */
	215,						/* U+000168 */
	215,						/* U+000169 */
	216,						/* U+00016A */
	216,						/* U+00016B */
	217,						/* U+00016C */
	217,						/* U+00016D */
	218,						/* U+00016E */
	218,						/* U+00016F */
	219,						/* U+000170 */
	219,						/* U+000171 */
	220,						/* U+000172 */
	220,						/* U+000173 */
	221,						/* U+000174 */
	221,						/* U+000175 */
	222,						/* U+000176 */
	222,						/* U+000177 */
	161,						/* U+000178 */
	223,						/* U+000179 */
	223,						/* U+00017A */
	224,						/* U+00017B */
	224,						/* U+00017C */
	225,						/* U+00017D */
	225,						/* U+00017E */
	226,						/* U+00017F */
	227,						/* U+000180 */
	228,						/* U+000181 */
	229,						/* U+000182 */
	229,						/* U+000183 */
	230,						/* U+000184 */
	230,						/* U+000185 */
	231,						/* U+000186 */
	232,						/* U+000187 */
	232,						/* U+000188 */
	233,						/* U+000189 */
	234,						/* U+00018A */
	235,						/* U+00018B */
	235,						/* U+00018C */
	0,							/* U+00018D */
	236,						/* U+00018E */
	237,						/* U+00018F */
	238,						/* U+000190 */
	239,						/* U+000191 */
	239,						/* U+000192 */
	240,						/* U+000193 */
	241,						/* U+000194 */
	242,						/* U+000195 */
	243,						/* U+000196 */
	244,						/* U+000197 */
	245,						/* U+000198 */
	245,						/* U+000199 */
	246,						/* U+00019A */
	247,						/* U+00019B */
	248,						/* U+00019C */
	249,						/* U+00019D */
	250,						/* U+00019E */
	251,						/* U+00019F */
	252,						/* U+0001A0 */
	252,						/* U+0001A1 */
	253,						/* U+0001A2 */
	253,						/* U+0001A3 */
	254,						/* U+0001A4 */
	254,						/* U+0001A5 */
	255,						/* U+0001A6 */
	256,						/* U+0001A7 */
	256,						/* U+0001A8 */
	257,						/* U+0001A9 */
	0,							/* U+0001AA */
	0,							/* U+0001AB */
	258,						/* U+0001AC */
	258,						/* U+0001AD */
	259,						/* U+0001AE */
	260,						/* U+0001AF */
	260,						/* U+0001B0 */
	261,						/* U+0001B1 */
	262,						/* U+0001B2 */
	263,						/* U+0001B3 */
	263,						/* U+0001B4 */
	264,						/* U+0001B5 */
	264,						/* U+0001B6 */
	265,						/* U+0001B7 */
	266,						/* U+0001B8 */
	266,						/* U+0001B9 */
	0,							/* U+0001BA */
	0,							/* U+0001BB */
	267,						/* U+0001BC */
	267,						/* U+0001BD */
	0,							/* U+0001BE */
	268,						/* U+0001BF */
	0,							/* U+0001C0 */
	0,							/* U+0001C1 */
	0,							/* U+0001C2 */
	0,							/* U+0001C3 */
	269,						/* U+0001C4 */
	269,						/* U+0001C5 */
	269,						/* U+0001C6 */
	270,						/* U+0001C7 */
	270,						/* U+0001C8 */
	270,						/* U+0001C9 */
	271,						/* U+0001CA */
	271,						/* U+0001CB */
	271,						/* U+0001CC */
	272,						/* U+0001CD */
	272,						/* U+0001CE */
	273,						/* U+0001CF */
	273,						/* U+0001D0 */
	274,						/* U+0001D1 */
	274,						/* U+0001D2 */
	275,						/* U+0001D3 */
	275,						/* U+0001D4 */
	276,						/* U+0001D5 */
	276,						/* U+0001D6 */
	277,						/* U+0001D7 */
	277,						/* U+0001D8 */
	278,						/* U+0001D9 */
	278,						/* U+0001DA */
	279,						/* U+0001DB */
	279,						/* U+0001DC */
	236,						/* U+0001DD */
	280,						/* U+0001DE */
	280,						/* U+0001DF */
	281,						/* U+0001E0 */
	281,						/* U+0001E1 */
	282,						/* U+0001E2 */
	282,						/* U+0001E3 */
	283,						/* U+0001E4 */
	283,						/* U+0001E5 */
	284,						/* U+0001E6 */
	284,						/* U+0001E7 */
	285,						/* U+0001E8 */
	285,						/* U+0001E9 */
	286,						/* U+0001EA */
	286,						/* U+0001EB */
	287,						/* U+0001EC */
	287,						/* U+0001ED */
	288,						/* U+0001EE */
	288,						/* U+0001EF */
	289,						/* U+0001F0 */
	290,						/* U+0001F1 */
	290,						/* U+0001F2 */
	290,						/* U+0001F3 */
	291,						/* U+0001F4 */
	291,						/* U+0001F5 */
	242,						/* U+0001F6 */
	268,						/* U+0001F7 */
	292,						/* U+0001F8 */
	292,						/* U+0001F9 */
	293,						/* U+0001FA */
	293,						/* U+0001FB */
	294,						/* U+0001FC */
	294,						/* U+0001FD */
	295,						/* U+0001FE */
	295,						/* U+0001FF */
	296,						/* U+000200 */
	296,						/* U+000201 */
	297,						/* U+000202 */
	297,						/* U+000203 */
	298,						/* U+000204 */
	298,						/* U+000205 */
	299,						/* U+000206 */
	299,						/* U+000207 */
	300,						/* U+000208 */
	300,						/* U+000209 */
	301,						/* U+00020A */
	301,						/* U+00020B */
	302,						/* U+00020C */
	302,						/* U+00020D */
	303,						/* U+00020E */
	303,						/* U+00020F */
	304,						/* U+000210 */
	304,						/* U+000211 */
	305,						/* U+000212 */
	305,						/* U+000213 */
	306,						/* U+000214 */
	306,						/* U+000215 */
	307,						/* U+000216 */
	307,						/* U+000217 */
	308,						/* U+000218 */
	308,						/* U+000219 */
	309,						/* U+00021A */
	309,						/* U+00021B */
	310,						/* U+00021C */
	310,						/* U+00021D */
	311,						/* U+00021E */
	311,						/* U+00021F */
	250,						/* U+000220 */
	0,							/* U+000221 */
	312,						/* U+000222 */
	312,						/* U+000223 */
	313,						/* U+000224 */
	313,						/* U+000225 */
	314,						/* U+000226 */
	314,						/* U+000227 */
	315,						/* U+000228 */
	315,						/* U+000229 */
	316,						/* U+00022A */
	316,						/* U+00022B */
	317,						/* U+00022C */
	317,						/* U+00022D */
	318,						/* U+00022E */
	318,						/* U+00022F */
	319,						/* U+000230 */
	319,						/* U+000231 */
	320,						/* U+000232 */
	320,						/* U+000233 */
	0,							/* U+000234 */
	0,							/* U+000235 */
	0,							/* U+000236 */
	0,							/* U+000237 */
	0,							/* U+000238 */
	0,							/* U+000239 */
	321,						/* U+00023A */
	322,						/* U+00023B */
	322,						/* U+00023C */
	246,						/* U+00023D */
	323,						/* U+00023E */
	324,						/* U+00023F */
	325,						/* U+000240 */
	326,						/* U+000241 */
	326,						/* U+000242 */
	227,						/* U+000243 */
	327,						/* U+000244 */
	328,						/* U+000245 */
	329,						/* U+000246 */
	329,						/* U+000247 */
	330,						/* U+000248 */
	330,						/* U+000249 */
	331,						/* U+00024A */
	331,						/* U+00024B */
	332,						/* U+00024C */
	332,						/* U+00024D */
	333,						/* U+00024E */
	333,						/* U+00024F */
	334,						/* U+000250 */
	335,						/* U+000251 */
	336,						/* U+000252 */
	228,						/* U+000253 */
	231,						/* U+000254 */
	0,							/* U+000255 */
	233,						/* U+000256 */
	234,						/* U+000257 */
	0,							/* U+000258 */
	237,						/* U+000259 */
	0,							/* U+00025A */
	238,						/* U+00025B */
	337,						/* U+00025C */
	0,							/* U+00025D */
	0,							/* U+00025E */
	0,							/* U+00025F */
	240,						/* U+000260 */
	338,						/* U+000261 */
	0,							/* U+000262 */
	241,						/* U+000263 */
	339,						/* U+000264 */
	340,						/* U+000265 */
	341,						/* U+000266 */
	0,							/* U+000267 */
	244,						/* U+000268 */
	243,						/* U+000269 */
	342,						/* U+00026A */
	343,						/* U+00026B */
	344,						/* U+00026C */
	0,							/* U+00026D */
	0,							/* U+00026E */
	248,						/* U+00026F */
	0,							/* U+000270 */
	345,						/* U+000271 */
	249,						/* U+000272 */
	0,							/* U+000273 */
	0,							/* U+000274 */
	251,						/* U+000275 */
	0,							/* U+000276 */
	0,							/* U+000277 */
	0,							/* U+000278 */
	0,							/* U+000279 */
	0,							/* U+00027A */
	0,							/* U+00027B */
	0,							/* U+00027C */
	346,						/* U+00027D */
	0,							/* U+00027E */
	0,							/* U+00027F */
	255,						/* U+000280 */
	0,							/* U+000281 */
	347,						/* U+000282 */
	257,						/* U+000283 */
	0,							/* U+000284 */
	0,							/* U+000285 */
	0,							/* U+000286 */
	348,						/* U+000287 */
	259,						/* U+000288 */
	327,						/* U+000289 */
	261,						/* U+00028A */
	262,						/* U+00028B */
	328,						/* U+00028C */
	0,							/* U+00028D */
	0,							/* U+00028E */
	0,							/* U+00028F */
	0,							/* U+000290 */
	0,							/* U+000291 */
	265,						/* U+000292 */
	0,							/* U+000293 */
	0,							/* U+000294 */
	0,							/* U+000295 */
	0,							/* U+000296 */
	0,							/* U+000297 */
	0,							/* U+000298 */
	0,							/* U+000299 */
	0,							/* U+00029A */
	0,							/* U+00029B */
	0,							/* U+00029C */
	349,						/* U+00029D */
	350,						/* U+00029E */
	0,							/* U+00029F */
	0,							/* U+0002A0 */
	0,							/* U+0002A1 */
	0,							/* U+0002A2 */
	0,							/* U+0002A3 */
	0,							/* U+0002A4 */
	0,							/* U+0002A5 */
	0,							/* U+0002A6 */
	0,							/* U+0002A7 */
	0,							/* U+0002A8 */
	0,							/* U+0002A9 */
	0,							/* U+0002AA */
	0,							/* U+0002AB */
	0,							/* U+0002AC */
	0,							/* U+0002AD */
	0,							/* U+0002AE */
	0,							/* U+0002AF */
	0,							/* U+0002B0 */
	0,							/* U+0002B1 */
	0,							/* U+0002B2 */
	0,							/* U+0002B3 */
	0,							/* U+0002B4 */
	0,							/* U+0002B5 */
	0,							/* U+0002B6 */
	0,							/* U+0002B7 */
	0,							/* U+0002B8 */
	0,							/* U+0002B9 */
	0,							/* U+0002BA */
	0,							/* U+0002BB */
	0,							/* U+0002BC */
	0,							/* U+0002BD */
	0,							/* U+0002BE */
	0,							/* U+0002BF */
	0,							/* U+0002C0 */
	0,							/* U+0002C1 */
	0,							/* U+0002C2 */
	0,							/* U+0002C3 */
	0,							/* U+0002C4 */
	0,							/* U+0002C5 */
	0,							/* U+0002C6 */
	0,							/* U+0002C7 */
	0,							/* U+0002C8 */
	0,							/* U+0002C9 */
	0,							/* U+0002CA */
	0,							/* U+0002CB */
	0,							/* U+0002CC */
	0,							/* U+0002CD */
	0,							/* U+0002CE */
	0,							/* U+0002CF */
	0,							/* U+0002D0 */
	0,							/* U+0002D1 */
	0,							/* U+0002D2 */
	0,							/* U+0002D3 */
	0,							/* U+0002D4 */
	0,							/* U+0002D5 */
	0,							/* U+0002D6 */
	0,							/* U+0002D7 */
	0,							/* U+0002D8 */
	0,							/* U+0002D9 */
	0,							/* U+0002DA */
	0,							/* U+0002DB */
	0,							/* U+0002DC */
	0,							/* U+0002DD */
	0,							/* U+0002DE */
	0,							/* U+0002DF */
	0,							/* U+0002E0 */
	0,							/* U+0002E1 */
	0,							/* U+0002E2 */
	0,							/* U+0002E3 */
	0,							/* U+0002E4 */
	0,							/* U+0002E5 */
	0,							/* U+0002E6 */
	0,							/* U+0002E7 */
	0,							/* U+0002E8 */
	0,							/* U+0002E9 */
	0,							/* U+0002EA */
	0,							/* U+0002EB */
	0,							/* U+0002EC */
	0,							/* U+0002ED */
	0,							/* U+0002EE */
	0,							/* U+0002EF */
	0,							/* U+0002F0 */
	0,							/* U+0002F1 */
	0,							/* U+0002F2 */
	0,							/* U+0002F3 */
	0,							/* U+0002F4 */
	0,							/* U+0002F5 */
	0,							/* U+0002F6 */
	0,							/* U+0002F7 */
	0,							/* U+0002F8 */
	0,							/* U+0002F9 */
	0,							/* U+0002FA */
	0,							/* U+0002FB */
	0,							/* U+0002FC */
	0,							/* U+0002FD */
	0,							/* U+0002FE */
	0,							/* U+0002FF */
	0,							/* U+000300 */
	0,							/* U+000301 */
	0,							/* U+000302 */
	0,							/* U+000303 */
	0,							/* U+000304 */
	0,							/* U+000305 */
	0,							/* U+000306 */
	0,							/* U+000307 */
	0,							/* U+000308 */
	0,							/* U+000309 */
	0,							/* U+00030A */
	0,							/* U+00030B */
	0,							/* U+00030C */
	0,							/* U+00030D */
	0,							/* U+00030E */
	0,							/* U+00030F */
	0,							/* U+000310 */
	0,							/* U+000311 */
	0,							/* U+000312 */
	0,							/* U+000313 */
	0,							/* U+000314 */
	0,							/* U+000315 */
	0,							/* U+000316 */
	0,							/* U+000317 */
	0,							/* U+000318 */
	0,							/* U+000319 */
	0,							/* U+00031A */
	0,							/* U+00031B */
	0,							/* U+00031C */
	0,							/* U+00031D */
	0,							/* U+00031E */
	0,							/* U+00031F */
	0,							/* U+000320 */
	0,							/* U+000321 */
	0,							/* U+000322 */
	0,							/* U+000323 */
	0,							/* U+000324 */
	0,							/* U+000325 */
	0,							/* U+000326 */
	0,							/* U+000327 */
	0,							/* U+000328 */
	0,							/* U+000329 */
	0,							/* U+00032A */
	0,							/* U+00032B */
	0,							/* U+00032C */
	0,							/* U+00032D */
	0,							/* U+00032E */
	0,							/* U+00032F */
	0,							/* U+000330 */
	0,							/* U+000331 */
	0,							/* U+000332 */
	0,							/* U+000333 */
	0,							/* U+000334 */
	0,							/* U+000335 */
	0,							/* U+000336 */
	0,							/* U+000337 */
	0,							/* U+000338 */
	0,							/* U+000339 */
	0,							/* U+00033A */
	0,							/* U+00033B */
	0,							/* U+00033C */
	0,							/* U+00033D */
	0,							/* U+00033E */
	0,							/* U+00033F */
	0,							/* U+000340 */
	0,							/* U+000341 */
	0,							/* U+000342 */
	0,							/* U+000343 */
	0,							/* U+000344 */
	351,						/* U+000345 */
	0,							/* U+000346 */
	0,							/* U+000347 */
	0,							/* U+000348 */
	0,							/* U+000349 */
	0,							/* U+00034A */
	0,							/* U+00034B */
	0,							/* U+00034C */
	0,							/* U+00034D */
	0,							/* U+00034E */
	0,							/* U+00034F */
	0,							/* U+000350 */
	0,							/* U+000351 */
	0,							/* U+000352 */
	0,							/* U+000353 */
	0,							/* U+000354 */
	0,							/* U+000355 */
	0,							/* U+000356 */
	0,							/* U+000357 */
	0,							/* U+000358 */
	0,							/* U+000359 */
	0,							/* U+00035A */
	0,							/* U+00035B */
	0,							/* U+00035C */
	0,							/* U+00035D */
	0,							/* U+00035E */
	0,							/* U+00035F */
	0,							/* U+000360 */
	0,							/* U+000361 */
	0,							/* U+000362 */
	0,							/* U+000363 */
	0,							/* U+000364 */
	0,							/* U+000365 */
	0,							/* U+000366 */
	0,							/* U+000367 */
	0,							/* U+000368 */
	0,							/* U+000369 */
	0,							/* U+00036A */
	0,							/* U+00036B */
	0,							/* U+00036C */
	0,							/* U+00036D */
	0,							/* U+00036E */
	0,							/* U+00036F */
	352,						/* U+000370 */
	352,						/* U+000371 */
	353,						/* U+000372 */
	353,						/* U+000373 */
	0,							/* U+000374 */
	0,							/* U+000375 */
	354,						/* U+000376 */
	354,						/* U+000377 */
	0,							/* U+000378 */
	0,							/* U+000379 */
	0,							/* U+00037A */
	355,						/* U+00037B */
	356,						/* U+00037C */
	357,						/* U+00037D */
	0,							/* U+00037E */
	358,						/* U+00037F */
	0,							/* U+000380 */
	0,							/* U+000381 */
	0,							/* U+000382 */
	0,							/* U+000383 */
	0,							/* U+000384 */
	0,							/* U+000385 */
	359,						/* U+000386 */
	0,							/* U+000387 */
	360,						/* U+000388 */
	361,						/* U+000389 */
	362,						/* U+00038A */
	0,							/* U+00038B */
	363,						/* U+00038C */
	0,							/* U+00038D */
	364,						/* U+00038E */
	365,						/* U+00038F */
	366,						/* U+000390 */
	367,						/* U+000391 */
	368,						/* U+000392 */
	369,						/* U+000393 */
	370,						/* U+000394 */
	371,						/* U+000395 */
	372,						/* U+000396 */
	373,						/* U+000397 */
	374,						/* U+000398 */
	375,						/* U+000399 */
	376,						/* U+00039A */
	377,						/* U+00039B */
	378,						/* U+00039C */
	379,						/* U+00039D */
	380,						/* U+00039E */
	381,						/* U+00039F */
	382,						/* U+0003A0 */
	383,						/* U+0003A1 */
	0,							/* U+0003A2 */
	384,						/* U+0003A3 */
	385,						/* U+0003A4 */
	386,						/* U+0003A5 */
	387,						/* U+0003A6 */
	388,						/* U+0003A7 */
	389,						/* U+0003A8 */
	390,						/* U+0003A9 */
	391,						/* U+0003AA */
	392,						/* U+0003AB */
	359,						/* U+0003AC */
	360,						/* U+0003AD */
	361,						/* U+0003AE */
	362,						/* U+0003AF */
	393,						/* U+0003B0 */
	367,						/* U+0003B1 */
	368,						/* U+0003B2 */
	369,						/* U+0003B3 */
	370,						/* U+0003B4 */
	371,						/* U+0003B5 */
	372,						/* U+0003B6 */
	373,						/* U+0003B7 */
	374,						/* U+0003B8 */
	375,						/* U+0003B9 */
	376,						/* U+0003BA */
	377,						/* U+0003BB */
	378,						/* U+0003BC */
	379,						/* U+0003BD */
	380,						/* U+0003BE */
	381,						/* U+0003BF */
	382,						/* U+0003C0 */
	383,						/* U+0003C1 */
	394,						/* U+0003C2 */
	395,						/* U+0003C3 */
	385,						/* U+0003C4 */
	386,						/* U+0003C5 */
	387,						/* U+0003C6 */
	388,						/* U+0003C7 */
	389,						/* U+0003C8 */
	390,						/* U+0003C9 */
	391,						/* U+0003CA */
	392,						/* U+0003CB */
	363,						/* U+0003CC */
	364,						/* U+0003CD */
	365,						/* U+0003CE */
	396,						/* U+0003CF */
	397,						/* U+0003D0 */
	398,						/* U+0003D1 */
	0,							/* U+0003D2 */
	0,							/* U+0003D3 */
	0,							/* U+0003D4 */
	399,						/* U+0003D5 */
	400,						/* U+0003D6 */
	396,						/* U+0003D7 */
	401,						/* U+0003D8 */
	401,						/* U+0003D9 */
	402,						/* U+0003DA */
	402,						/* U+0003DB */
	403,						/* U+0003DC */
	403,						/* U+0003DD */
	404,						/* U+0003DE */
	404,						/* U+0003DF */
	405,						/* U+0003E0 */
	405,						/* U+0003E1 */
	406,						/* U+0003E2 */
	406,						/* U+0003E3 */
	407,						/* U+0003E4 */
	407,						/* U+0003E5 */
	408,						/* U+0003E6 */
	408,						/* U+0003E7 */
	409,						/* U+0003E8 */
	409,						/* U+0003E9 */
	410,						/* U+0003EA */
	410,						/* U+0003EB */
	411,						/* U+0003EC */
	411,						/* U+0003ED */
	412,						/* U+0003EE */
	412,						/* U+0003EF */
	413,						/* U+0003F0 */
	414,						/* U+0003F1 */
	415,						/* U+0003F2 */
	358,						/* U+0003F3 */
	416,						/* U+0003F4 */
	417,						/* U+0003F5 */
	0,							/* U+0003F6 */
	418,						/* U+0003F7 */
	418,						/* U+0003F8 */
	415,						/* U+0003F9 */
	419,						/* U+0003FA */
	419,						/* U+0003FB */
	0,							/* U+0003FC */
	355,						/* U+0003FD */
	356,						/* U+0003FE */
	357,						/* U+0003FF */
	420,						/* U+000400 */
	421,						/* U+000401 */
	422,						/* U+000402 */
	423,						/* U+000403 */
	424,						/* U+000404 */
	425,						/* U+000405 */
	426,						/* U+000406 */
	427,						/* U+000407 */
	428,						/* U+000408 */
	429,						/* U+000409 */
	430,						/* U+00040A */
	431,						/* U+00040B */
	432,						/* U+00040C */
	433,						/* U+00040D */
	434,						/* U+00040E */
	435,						/* U+00040F */
	436,						/* U+000410 */
	437,						/* U+000411 */
	438,						/* U+000412 */
	439,						/* U+000413 */
	440,						/* U+000414 */
	441,						/* U+000415 */
	442,						/* U+000416 */
	443,						/* U+000417 */
	444,						/* U+000418 */
	445,						/* U+000419 */
	446,						/* U+00041A */
	447,						/* U+00041B */
	448,						/* U+00041C */
	449,						/* U+00041D */
	450,						/* U+00041E */
	451,						/* U+00041F */
	452,						/* U+000420 */
	453,						/* U+000421 */
	454,						/* U+000422 */
	455,						/* U+000423 */
	456,						/* U+000424 */
	457,						/* U+000425 */
	458,						/* U+000426 */
	459,						/* U+000427 */
	460,						/* U+000428 */
	461,						/* U+000429 */
	462,						/* U+00042A */
	463,						/* U+00042B */
	464,						/* U+00042C */
	465,						/* U+00042D */
	466,						/* U+00042E */
	467,						/* U+00042F */
	436,						/* U+000430 */
	437,						/* U+000431 */
	438,						/* U+000432 */
	439,						/* U+000433 */
	440,						/* U+000434 */
	441,						/* U+000435 */
	442,						/* U+000436 */
	443,						/* U+000437 */
	444,						/* U+000438 */
	445,						/* U+000439 */
	446,						/* U+00043A */
	447,						/* U+00043B */
	448,						/* U+00043C */
	449,						/* U+00043D */
	450,						/* U+00043E */
	451,						/* U+00043F */
	452,						/* U+000440 */
	453,						/* U+000441 */
	454,						/* U+000442 */
	455,						/* U+000443 */
	456,						/* U+000444 */
	457,						/* U+000445 */
	458,						/* U+000446 */
	459,						/* U+000447 */
	460,						/* U+000448 */
	461,						/* U+000449 */
	462,						/* U+00044A */
	463,						/* U+00044B */
	464,						/* U+00044C */
	465,						/* U+00044D */
	466,						/* U+00044E */
	467,						/* U+00044F */
	420,						/* U+000450 */
	421,						/* U+000451 */
	422,						/* U+000452 */
	423,						/* U+000453 */
	424,						/* U+000454 */
	425,						/* U+000455 */
	426,						/* U+000456 */
	427,						/* U+000457 */
	428,						/* U+000458 */
	429,						/* U+000459 */
	430,						/* U+00045A */
	431,						/* U+00045B */
	432,						/* U+00045C */
	433,						/* U+00045D */
	434,						/* U+00045E */
	435,						/* U+00045F */
	468,						/* U+000460 */
	468,						/* U+000461 */
	469,						/* U+000462 */
	469,						/* U+000463 */
	470,						/* U+000464 */
	470,						/* U+000465 */
	471,						/* U+000466 */
	471,						/* U+000467 */
	472,						/* U+000468 */
	472,						/* U+000469 */
	473,						/* U+00046A */
	473,						/* U+00046B */
	474,						/* U+00046C */
	474,						/* U+00046D */
	475,						/* U+00046E */
	475,						/* U+00046F */
	476,						/* U+000470 */
	476,						/* U+000471 */
	477,						/* U+000472 */
	477,						/* U+000473 */
	478,						/* U+000474 */
	478,						/* U+000475 */
	479,						/* U+000476 */
	479,						/* U+000477 */
	480,						/* U+000478 */
	480,						/* U+000479 */
	481,						/* U+00047A */
	481,						/* U+00047B */
	482,						/* U+00047C */
	482,						/* U+00047D */
	483,						/* U+00047E */
	483,						/* U+00047F */
	484,						/* U+000480 */
	484,						/* U+000481 */
	0,							/* U+000482 */
	0,							/* U+000483 */
	0,							/* U+000484 */
	0,							/* U+000485 */
	0,							/* U+000486 */
	0,							/* U+000487 */
	0,							/* U+000488 */
	0,							/* U+000489 */
	485,						/* U+00048A */
	485,						/* U+00048B */
	486,						/* U+00048C */
	486,						/* U+00048D */
	487,						/* U+00048E */
	487,						/* U+00048F */
	488,						/* U+000490 */
	488,						/* U+000491 */
	489,						/* U+000492 */
	489,						/* U+000493 */
	490,						/* U+000494 */
	490,						/* U+000495 */
	491,						/* U+000496 */
	491,						/* U+000497 */
	492,						/* U+000498 */
	492,						/* U+000499 */
	493,						/* U+00049A */
	493,						/* U+00049B */
	494,						/* U+00049C */
	494,						/* U+00049D */
	495,						/* U+00049E */
	495,						/* U+00049F */
	496,						/* U+0004A0 */
	496,						/* U+0004A1 */
	497,						/* U+0004A2 */
	497,						/* U+0004A3 */
	498,						/* U+0004A4 */
	498,						/* U+0004A5 */
	499,						/* U+0004A6 */
	499,						/* U+0004A7 */
	500,						/* U+0004A8 */
	500,						/* U+0004A9 */
	501,						/* U+0004AA */
	501,						/* U+0004AB */
	502,						/* U+0004AC */
	502,						/* U+0004AD */
	503,						/* U+0004AE */
	503,						/* U+0004AF */
	504,						/* U+0004B0 */
	504,						/* U+0004B1 */
	505,						/* U+0004B2 */
	505,						/* U+0004B3 */
	506,						/* U+0004B4 */
	506,						/* U+0004B5 */
	507,						/* U+0004B6 */
	507,						/* U+0004B7 */
	508,						/* U+0004B8 */
	508,						/* U+0004B9 */
	509,						/* U+0004BA */
	509,						/* U+0004BB */
	510,						/* U+0004BC */
	510,						/* U+0004BD */
	511,						/* U+0004BE */
	511,						/* U+0004BF */
	512,						/* U+0004C0 */
	513,						/* U+0004C1 */
	513,						/* U+0004C2 */
	514,						/* U+0004C3 */
	514,						/* U+0004C4 */
	515,						/* U+0004C5 */
	515,						/* U+0004C6 */
	516,						/* U+0004C7 */
	516,						/* U+0004C8 */
	517,						/* U+0004C9 */
	517,						/* U+0004CA */
	518,						/* U+0004CB */
	518,						/* U+0004CC */
	519,						/* U+0004CD */
	519,						/* U+0004CE */
	512,						/* U+0004CF */
	520,						/* U+0004D0 */
	520,						/* U+0004D1 */
	521,						/* U+0004D2 */
	521,						/* U+0004D3 */
	522,						/* U+0004D4 */
	522,						/* U+0004D5 */
	523,						/* U+0004D6 */
	523,						/* U+0004D7 */
	524,						/* U+0004D8 */
	524,						/* U+0004D9 */
	525,						/* U+0004DA */
	525,						/* U+0004DB */
	526,						/* U+0004DC */
	526,						/* U+0004DD */
	527,						/* U+0004DE */
	527,						/* U+0004DF */
	528,						/* U+0004E0 */
	528,						/* U+0004E1 */
	529,						/* U+0004E2 */
	529,						/* U+0004E3 */
	530,						/* U+0004E4 */
	530,						/* U+0004E5 */
	531,						/* U+0004E6 */
	531,						/* U+0004E7 */
	532,						/* U+0004E8 */
	532,						/* U+0004E9 */
	533,						/* U+0004EA */
	533,						/* U+0004EB */
	534,						/* U+0004EC */
	534,						/* U+0004ED */
	535,						/* U+0004EE */
	535,						/* U+0004EF */
	536,						/* U+0004F0 */
	536,						/* U+0004F1 */
	537,						/* U+0004F2 */
	537,						/* U+0004F3 */
	538,						/* U+0004F4 */
	538,						/* U+0004F5 */
	539,						/* U+0004F6 */
	539,						/* U+0004F7 */
	540,						/* U+0004F8 */
	540,						/* U+0004F9 */
	541,						/* U+0004FA */
	541,						/* U+0004FB */
	542,						/* U+0004FC */
	542,						/* U+0004FD */
	543,						/* U+0004FE */
	543,						/* U+0004FF */
	544,						/* U+000500 */
	544,						/* U+000501 */
	545,						/* U+000502 */
	545,						/* U+000503 */
	546,						/* U+000504 */
	546,						/* U+000505 */
	547,						/* U+000506 */
	547,						/* U+000507 */
	548,						/* U+000508 */
	548,						/* U+000509 */
	549,						/* U+00050A */
	549,						/* U+00050B */
	550,						/* U+00050C */
	550,						/* U+00050D */
	551,						/* U+00050E */
	551,						/* U+00050F */
	552,						/* U+000510 */
	552,						/* U+000511 */
	553,						/* U+000512 */
	553,						/* U+000513 */
	554,						/* U+000514 */
	554,						/* U+000515 */
	555,						/* U+000516 */
	555,						/* U+000517 */
	556,						/* U+000518 */
	556,						/* U+000519 */
	557,						/* U+00051A */
	557,						/* U+00051B */
	558,						/* U+00051C */
	558,						/* U+00051D */
	559,						/* U+00051E */
	559,						/* U+00051F */
	560,						/* U+000520 */
	560,						/* U+000521 */
	561,						/* U+000522 */
	561,						/* U+000523 */
	562,						/* U+000524 */
	562,						/* U+000525 */
	563,						/* U+000526 */
	563,						/* U+000527 */
	564,						/* U+000528 */
	564,						/* U+000529 */
	565,						/* U+00052A */
	565,						/* U+00052B */
	566,						/* U+00052C */
	566,						/* U+00052D */
	567,						/* U+00052E */
	567,						/* U+00052F */
	0,							/* U+000530 */
	568,						/* U+000531 */
	569,						/* U+000532 */
	570,						/* U+000533 */
	571,						/* U+000534 */
	572,						/* U+000535 */
	573,						/* U+000536 */
	574,						/* U+000537 */
	575,						/* U+000538 */
	576,						/* U+000539 */
	577,						/* U+00053A */
	578,						/* U+00053B */
	579,						/* U+00053C */
	580,						/* U+00053D */
	581,						/* U+00053E */
	582,						/* U+00053F */
	583,						/* U+000540 */
	584,						/* U+000541 */
	585,						/* U+000542 */
	586,						/* U+000543 */
	587,						/* U+000544 */
	588,						/* U+000545 */
	589,						/* U+000546 */
	590,						/* U+000547 */
	591,						/* U+000548 */
	592,						/* U+000549 */
	593,						/* U+00054A */
	594,						/* U+00054B */
	595,						/* U+00054C */
	596,						/* U+00054D */
	597,						/* U+00054E */
	598,						/* U+00054F */
	599,						/* U+000550 */
	600,						/* U+000551 */
	601,						/* U+000552 */
	602,						/* U+000553 */
	603,						/* U+000554 */
	604,						/* U+000555 */
	605,						/* U+000556 */
	0,							/* U+000557 */
	0,							/* U+000558 */
	0,							/* U+000559 */
	0,							/* U+00055A */
	0,							/* U+00055B */
	0,							/* U+00055C */
	0,							/* U+00055D */
	0,							/* U+00055E */
	0,							/* U+00055F */
	0,							/* U+000560 */
	568,						/* U+000561 */
	569,						/* U+000562 */
	570,						/* U+000563 */
	571,						/* U+000564 */
	572,						/* U+000565 */
	573,						/* U+000566 */
	574,						/* U+000567 */
	575,						/* U+000568 */
	576,						/* U+000569 */
	577,						/* U+00056A */
	578,						/* U+00056B */
	579,						/* U+00056C */
	580,						/* U+00056D */
	581,						/* U+00056E */
	582,						/* U+00056F */
	583,						/* U+000570 */
	584,						/* U+000571 */
	585,						/* U+000572 */
	586,						/* U+000573 */
	587,						/* U+000574 */
	588,						/* U+000575 */
	589,						/* U+000576 */
	590,						/* U+000577 */
	591,						/* U+000578 */
	592,						/* U+000579 */
	593,						/* U+00057A */
	594,						/* U+00057B */
	595,						/* U+00057C */
	596,						/* U+00057D */
	597,						/* U+00057E */
	598,						/* U+00057F */
	599,						/* U+000580 */
	600,						/* U+000581 */
	601,						/* U+000582 */
	602,						/* U+000583 */
	603,						/* U+000584 */
	604,						/* U+000585 */
	605,						/* U+000586 */
	606,						/* U+000587 */
	607,						/* U+0010A0 */
	608,						/* U+0010A1 */
	609,						/* U+0010A2 */
	610,						/* U+0010A3 */
	611,						/* U+0010A4 */
	612,						/* U+0010A5 */
	613,						/* U+0010A6 */
	614,						/* U+0010A7 */
	615,						/* U+0010A8 */
	616,						/* U+0010A9 */
	617,						/* U+0010AA */
	618,						/* U+0010AB */
	619,						/* U+0010AC */
	620,						/* U+0010AD */
	621,						/* U+0010AE */
	622,						/* U+0010AF */
	623,						/* U+0010B0 */
	624,						/* U+0010B1 */
	625,						/* U+0010B2 */
	626,						/* U+0010B3 */
	627,						/* U+0010B4 */
	628,						/* U+0010B5 */
	629,						/* U+0010B6 */
	630,						/* U+0010B7 */
	631,						/* U+0010B8 */
	632,						/* U+0010B9 */
	633,						/* U+0010BA */
	634,						/* U+0010BB */
	635,						/* U+0010BC */
	636,						/* U+0010BD */
	637,						/* U+0010BE */
	638,						/* U+0010BF */
	639,						/* U+0010C0 */
	640,						/* U+0010C1 */
	641,						/* U+0010C2 */
	642,						/* U+0010C3 */
	643,						/* U+0010C4 */
	644,						/* U+0010C5 */
	0,							/* U+0010C6 */
	645,						/* U+0010C7 */
	0,							/* U+0010C8 */
	0,							/* U+0010C9 */
	0,							/* U+0010CA */
	0,							/* U+0010CB */
	0,							/* U+0010CC */
	646,						/* U+0010CD */
	0,							/* U+0010CE */
	0,							/* U+0010CF */
	647,						/* U+0010D0 */
	648,						/* U+0010D1 */
	649,						/* U+0010D2 */
	650,						/* U+0010D3 */
	651,						/* U+0010D4 */
	652,						/* U+0010D5 */
	653,						/* U+0010D6 */
	654,						/* U+0010D7 */
	655,						/* U+0010D8 */
	656,						/* U+0010D9 */
	657,						/* U+0010DA */
	658,						/* U+0010DB */
	659,						/* U+0010DC */
	660,						/* U+0010DD */
	661,						/* U+0010DE */
	662,						/* U+0010DF */
	663,						/* U+0010E0 */
	664,						/* U+0010E1 */
	665,						/* U+0010E2 */
	666,						/* U+0010E3 */
	667,						/* U+0010E4 */
	668,						/* U+0010E5 */
	669,						/* U+0010E6 */
	670,						/* U+0010E7 */
	671,						/* U+0010E8 */
	672,						/* U+0010E9 */
	673,						/* U+0010EA */
	674,						/* U+0010EB */
	675,						/* U+0010EC */
	676,						/* U+0010ED */
	677,						/* U+0010EE */
	678,						/* U+0010EF */
	679,						/* U+0010F0 */
	680,						/* U+0010F1 */
	681,						/* U+0010F2 */
	682,						/* U+0010F3 */
	683,						/* U+0010F4 */
	684,						/* U+0010F5 */
	685,						/* U+0010F6 */
	686,						/* U+0010F7 */
	687,						/* U+0010F8 */
	688,						/* U+0010F9 */
	689,						/* U+0010FA */
	0,							/* U+0010FB */
	0,							/* U+0010FC */
	690,						/* U+0010FD */
	691,						/* U+0010FE */
	692,						/* U+0010FF */
	693,						/* U+0013A0 */
	694,						/* U+0013A1 */
	695,						/* U+0013A2 */
	696,						/* U+0013A3 */
	697,						/* U+0013A4 */
	698,						/* U+0013A5 */
	699,						/* U+0013A6 */
	700,						/* U+0013A7 */
	701,						/* U+0013A8 */
	702,						/* U+0013A9 */
	703,						/* U+0013AA */
	704,						/* U+0013AB */
	705,						/* U+0013AC */
	706,						/* U+0013AD */
	707,						/* U+0013AE */
	708,						/* U+0013AF */
	709,						/* U+0013B0 */
	710,						/* U+0013B1 */
	711,						/* U+0013B2 */
	712,						/* U+0013B3 */
	713,						/* U+0013B4 */
	714,						/* U+0013B5 */
	715,						/* U+0013B6 */
	716,						/* U+0013B7 */
	717,						/* U+0013B8 */
	718,						/* U+0013B9 */
	719,						/* U+0013BA */
	720,						/* U+0013BB */
	721,						/* U+0013BC */
	722,						/* U+0013BD */
	723,						/* U+0013BE */
	724,						/* U+0013BF */
	725,						/* U+0013C0 */
	726,						/* U+0013C1 */
	727,						/* U+0013C2 */
	728,						/* U+0013C3 */
	729,						/* U+0013C4 */
	730,						/* U+0013C5 */
	731,						/* U+0013C6 */
	732,						/* U+0013C7 */
	733,						/* U+0013C8 */
	734,						/* U+0013C9 */
	735,						/* U+0013CA */
	736,						/* U+0013CB */
	737,						/* U+0013CC */
	738,						/* U+0013CD */
	739,						/* U+0013CE */
	740,						/* U+0013CF */
	741,						/* U+0013D0 */
	742,						/* U+0013D1 */
	743,						/* U+0013D2 */
	744,						/* U+0013D3 */
	745,						/* U+0013D4 */
	746,						/* U+0013D5 */
	747,						/* U+0013D6 */
	748,						/* U+0013D7 */
	749,						/* U+0013D8 */
	750,						/* U+0013D9 */
	751,						/* U+0013DA */
	752,						/* U+0013DB */
	753,						/* U+0013DC */
	754,						/* U+0013DD */
	755,						/* U+0013DE */
	756,						/* U+0013DF */
	757,						/* U+0013E0 */
	758,						/* U+0013E1 */
	759,						/* U+0013E2 */
	760,						/* U+0013E3 */
	761,						/* U+0013E4 */
	762,						/* U+0013E5 */
	763,						/* U+0013E6 */
	764,						/* U+0013E7 */
	765,						/* U+0013E8 */
	766,						/* U+0013E9 */
	767,						/* U+0013EA */
	768,						/* U+0013EB */
	769,						/* U+0013EC */
	770,						/* U+0013ED */
	771,						/* U+0013EE */
	772,						/* U+0013EF */
	773,						/* U+0013F0 */
	774,						/* U+0013F1 */
	775,						/* U+0013F2 */
	776,						/* U+0013F3 */
	777,						/* U+0013F4 */
	778,						/* U+0013F5 */
	0,							/* U+0013F6 */
	0,							/* U+0013F7 */
	773,						/* U+0013F8 */
	774,						/* U+0013F9 */
	775,						/* U+0013FA */
	776,						/* U+0013FB */
	777,						/* U+0013FC */
	778,						/* U+0013FD */
	779,						/* U+001C80 */
	780,						/* U+001C81 */
	781,						/* U+001C82 */
	782,						/* U+001C83 */
	783,						/* U+001C84 */
	784,						/* U+001C85 */
	785,						/* U+001C86 */
	786,						/* U+001C87 */
	787,						/* U+001C88 */
	788,						/* U+001C89 */
	788,						/* U+001C8A */
	0,							/* U+001C8B */
	0,							/* U+001C8C */
	0,							/* U+001C8D */
	0,							/* U+001C8E */
	0,							/* U+001C8F */
	789,						/* U+001C90 */
	790,						/* U+001C91 */
	791,						/* U+001C92 */
	792,						/* U+001C93 */
	793,						/* U+001C94 */
	794,						/* U+001C95 */
	795,						/* U+001C96 */
	796,						/* U+001C97 */
	797,						/* U+001C98 */
	798,						/* U+001C99 */
	799,						/* U+001C9A */
	800,						/* U+001C9B */
	801,						/* U+001C9C */
	802,						/* U+001C9D */
	803,						/* U+001C9E */
	804,						/* U+001C9F */
	805,						/* U+001CA0 */
	806,						/* U+001CA1 */
	807,						/* U+001CA2 */
	808,						/* U+001CA3 */
	809,						/* U+001CA4 */
	810,						/* U+001CA5 */
	811,						/* U+001CA6 */
	812,						/* U+001CA7 */
	813,						/* U+001CA8 */
	814,						/* U+001CA9 */
	815,						/* U+001CAA */
	816,						/* U+001CAB */
	817,						/* U+001CAC */
	818,						/* U+001CAD */
	819,						/* U+001CAE */
	820,						/* U+001CAF */
	821,						/* U+001CB0 */
	822,						/* U+001CB1 */
	823,						/* U+001CB2 */
	824,						/* U+001CB3 */
	825,						/* U+001CB4 */
	826,						/* U+001CB5 */
	827,						/* U+001CB6 */
	828,						/* U+001CB7 */
	829,						/* U+001CB8 */
	830,						/* U+001CB9 */
	831,						/* U+001CBA */
	0,							/* U+001CBB */
	0,							/* U+001CBC */
	832,						/* U+001CBD */
	833,						/* U+001CBE */
	834,						/* U+001CBF */
	0,							/* U+001CC0 */
	0,							/* U+001CC1 */
	0,							/* U+001CC2 */
	0,							/* U+001CC3 */
	0,							/* U+001CC4 */
	0,							/* U+001CC5 */
	0,							/* U+001CC6 */
	0,							/* U+001CC7 */
	0,							/* U+001CC8 */
	0,							/* U+001CC9 */
	0,							/* U+001CCA */
	0,							/* U+001CCB */
	0,							/* U+001CCC */
	0,							/* U+001CCD */
	0,							/* U+001CCE */
	0,							/* U+001CCF */
	0,							/* U+001CD0 */
	0,							/* U+001CD1 */
	0,							/* U+001CD2 */
	0,							/* U+001CD3 */
	0,							/* U+001CD4 */
	0,							/* U+001CD5 */
	0,							/* U+001CD6 */
	0,							/* U+001CD7 */
	0,							/* U+001CD8 */
	0,							/* U+001CD9 */
	0,							/* U+001CDA */
	0,							/* U+001CDB */
	0,							/* U+001CDC */
	0,							/* U+001CDD */
	0,							/* U+001CDE */
	0,							/* U+001CDF */
	0,							/* U+001CE0 */
	0,							/* U+001CE1 */
	0,							/* U+001CE2 */
	0,							/* U+001CE3 */
	0,							/* U+001CE4 */
	0,							/* U+001CE5 */
	0,							/* U+001CE6 */
	0,							/* U+001CE7 */
	0,							/* U+001CE8 */
	0,							/* U+001CE9 */
	0,							/* U+001CEA */
	0,							/* U+001CEB */
	0,							/* U+001CEC */
	0,							/* U+001CED */
	0,							/* U+001CEE */
	0,							/* U+001CEF */
	0,							/* U+001CF0 */
	0,							/* U+001CF1 */
	0,							/* U+001CF2 */
	0,							/* U+001CF3 */
	0,							/* U+001CF4 */
	0,							/* U+001CF5 */
	0,							/* U+001CF6 */
	0,							/* U+001CF7 */
	0,							/* U+001CF8 */
	0,							/* U+001CF9 */
	0,							/* U+001CFA */
	0,							/* U+001CFB */
	0,							/* U+001CFC */
	0,							/* U+001CFD */
	0,							/* U+001CFE */
	0,							/* U+001CFF */
	0,							/* U+001D00 */
	0,							/* U+001D01 */
	0,							/* U+001D02 */
	0,							/* U+001D03 */
	0,							/* U+001D04 */
	0,							/* U+001D05 */
	0,							/* U+001D06 */
	0,							/* U+001D07 */
	0,							/* U+001D08 */
	0,							/* U+001D09 */
	0,							/* U+001D0A */
	0,							/* U+001D0B */
	0,							/* U+001D0C */
	0,							/* U+001D0D */
	0,							/* U+001D0E */
	0,							/* U+001D0F */
	0,							/* U+001D10 */
	0,							/* U+001D11 */
	0,							/* U+001D12 */
	0,							/* U+001D13 */
	0,							/* U+001D14 */
	0,							/* U+001D15 */
	0,							/* U+001D16 */
	0,							/* U+001D17 */
	0,							/* U+001D18 */
	0,							/* U+001D19 */
	0,							/* U+001D1A */
	0,							/* U+001D1B */
	0,							/* U+001D1C */
	0,							/* U+001D1D */
	0,							/* U+001D1E */
	0,							/* U+001D1F */
	0,							/* U+001D20 */
	0,							/* U+001D21 */
	0,							/* U+001D22 */
	0,							/* U+001D23 */
	0,							/* U+001D24 */
	0,							/* U+001D25 */
	0,							/* U+001D26 */
	0,							/* U+001D27 */
	0,							/* U+001D28 */
	0,							/* U+001D29 */
	0,							/* U+001D2A */
	0,							/* U+001D2B */
	0,							/* U+001D2C */
	0,							/* U+001D2D */
	0,							/* U+001D2E */
	0,							/* U+001D2F */
	0,							/* U+001D30 */
	0,							/* U+001D31 */
	0,							/* U+001D32 */
	0,							/* U+001D33 */
	0,							/* U+001D34 */
	0,							/* U+001D35 */
	0,							/* U+001D36 */
	0,							/* U+001D37 */
	0,							/* U+001D38 */
	0,							/* U+001D39 */
	0,							/* U+001D3A */
	0,							/* U+001D3B */
	0,							/* U+001D3C */
	0,							/* U+001D3D */
	0,							/* U+001D3E */
	0,							/* U+001D3F */
	0,							/* U+001D40 */
	0,							/* U+001D41 */
	0,							/* U+001D42 */
	0,							/* U+001D43 */
	0,							/* U+001D44 */
	0,							/* U+001D45 */
	0,							/* U+001D46 */
	0,							/* U+001D47 */
	0,							/* U+001D48 */
	0,							/* U+001D49 */
	0,							/* U+001D4A */
	0,							/* U+001D4B */
	0,							/* U+001D4C */
	0,							/* U+001D4D */
	0,							/* U+001D4E */
	0,							/* U+001D4F */
	0,							/* U+001D50 */
	0,							/* U+001D51 */
	0,							/* U+001D52 */
	0,							/* U+001D53 */
	0,							/* U+001D54 */
	0,							/* U+001D55 */
	0,							/* U+001D56 */
	0,							/* U+001D57 */
	0,							/* U+001D58 */
	0,							/* U+001D59 */
	0,							/* U+001D5A */
	0,							/* U+001D5B */
	0,							/* U+001D5C */
	0,							/* U+001D5D */
	0,							/* U+001D5E */
	0,							/* U+001D5F */
	0,							/* U+001D60 */
	0,							/* U+001D61 */
	0,							/* U+001D62 */
	0,							/* U+001D63 */
	0,							/* U+001D64 */
	0,							/* U+001D65 */
	0,							/* U+001D66 */
	0,							/* U+001D67 */
	0,							/* U+001D68 */
	0,							/* U+001D69 */
	0,							/* U+001D6A */
	0,							/* U+001D6B */
	0,							/* U+001D6C */
	0,							/* U+001D6D */
	0,							/* U+001D6E */
	0,							/* U+001D6F */
	0,							/* U+001D70 */
	0,							/* U+001D71 */
	0,							/* U+001D72 */
	0,							/* U+001D73 */
	0,							/* U+001D74 */
	0,							/* U+001D75 */
	0,							/* U+001D76 */
	0,							/* U+001D77 */
	0,							/* U+001D78 */
	835,						/* U+001D79 */
	0,							/* U+001D7A */
	0,							/* U+001D7B */
	0,							/* U+001D7C */
	836,						/* U+001D7D */
	0,							/* U+001D7E */
	0,							/* U+001D7F */
	0,							/* U+001D80 */
	0,							/* U+001D81 */
	0,							/* U+001D82 */
	0,							/* U+001D83 */
	0,							/* U+001D84 */
	0,							/* U+001D85 */
	0,							/* U+001D86 */
	0,							/* U+001D87 */
	0,							/* U+001D88 */
	0,							/* U+001D89 */
	0,							/* U+001D8A */
	0,							/* U+001D8B */
	0,							/* U+001D8C */
	0,							/* U+001D8D */
	837,						/* U+001D8E */
	0,							/* U+001D8F */
	0,							/* U+001D90 */
	0,							/* U+001D91 */
	0,							/* U+001D92 */
	0,							/* U+001D93 */
	0,							/* U+001D94 */
	0,							/* U+001D95 */
	0,							/* U+001D96 */
	0,							/* U+001D97 */
	0,							/* U+001D98 */
	0,							/* U+001D99 */
	0,							/* U+001D9A */
	0,							/* U+001D9B */
	0,							/* U+001D9C */
	0,							/* U+001D9D */
	0,							/* U+001D9E */
	0,							/* U+001D9F */
	0,							/* U+001DA0 */
	0,							/* U+001DA1 */
	0,							/* U+001DA2 */
	0,							/* U+001DA3 */
	0,							/* U+001DA4 */
	0,							/* U+001DA5 */
	0,							/* U+001DA6 */
	0,							/* U+001DA7 */
	0,							/* U+001DA8 */
	0,							/* U+001DA9 */
	0,							/* U+001DAA */
	0,							/* U+001DAB */
	0,							/* U+001DAC */
	0,							/* U+001DAD */
	0,							/* U+001DAE */
	0,							/* U+001DAF */
	0,							/* U+001DB0 */
	0,							/* U+001DB1 */
	0,							/* U+001DB2 */
	0,							/* U+001DB3 */
	0,							/* U+001DB4 */
	0,							/* U+001DB5 */
	0,							/* U+001DB6 */
	0,							/* U+001DB7 */
	0,							/* U+001DB8 */
	0,							/* U+001DB9 */
	0,							/* U+001DBA */
	0,							/* U+001DBB */
	0,							/* U+001DBC */
	0,							/* U+001DBD */
	0,							/* U+001DBE */
	0,							/* U+001DBF */
	0,							/* U+001DC0 */
	0,							/* U+001DC1 */
	0,							/* U+001DC2 */
	0,							/* U+001DC3 */
	0,							/* U+001DC4 */
	0,							/* U+001DC5 */
	0,							/* U+001DC6 */
	0,							/* U+001DC7 */
	0,							/* U+001DC8 */
	0,							/* U+001DC9 */
	0,							/* U+001DCA */
	0,							/* U+001DCB */
	0,							/* U+001DCC */
	0,							/* U+001DCD */
	0,							/* U+001DCE */
	0,							/* U+001DCF */
	0,							/* U+001DD0 */
	0,							/* U+001DD1 */
	0,							/* U+001DD2 */
	0,							/* U+001DD3 */
	0,							/* U+001DD4 */
	0,							/* U+001DD5 */
	0,							/* U+001DD6 */
	0,							/* U+001DD7 */
	0,							/* U+001DD8 */
	0,							/* U+001DD9 */
	0,							/* U+001DDA */
	0,							/* U+001DDB */
	0,							/* U+001DDC */
	0,							/* U+001DDD */
	0,							/* U+001DDE */
	0,							/* U+001DDF */
	0,							/* U+001DE0 */
	0,							/* U+001DE1 */
	0,							/* U+001DE2 */
	0,							/* U+001DE3 */
	0,							/* U+001DE4 */
	0,							/* U+001DE5 */
	0,							/* U+001DE6 */
	0,							/* U+001DE7 */
	0,							/* U+001DE8 */
	0,							/* U+001DE9 */
	0,							/* U+001DEA */
	0,							/* U+001DEB */
	0,							/* U+001DEC */
	0,							/* U+001DED */
	0,							/* U+001DEE */
	0,							/* U+001DEF */
	0,							/* U+001DF0 */
	0,							/* U+001DF1 */
	0,							/* U+001DF2 */
	0,							/* U+001DF3 */
	0,							/* U+001DF4 */
	0,							/* U+001DF5 */
	0,							/* U+001DF6 */
	0,							/* U+001DF7 */
	0,							/* U+001DF8 */
	0,							/* U+001DF9 */
	0,							/* U+001DFA */
	0,							/* U+001DFB */
	0,							/* U+001DFC */
	0,							/* U+001DFD */
	0,							/* U+001DFE */
	0,							/* U+001DFF */
	838,						/* U+001E00 */
	838,						/* U+001E01 */
	839,						/* U+001E02 */
	839,						/* U+001E03 */
	840,						/* U+001E04 */
	840,						/* U+001E05 */
	841,						/* U+001E06 */
	841,						/* U+001E07 */
	842,						/* U+001E08 */
	842,						/* U+001E09 */
	843,						/* U+001E0A */
	843,						/* U+001E0B */
	844,						/* U+001E0C */
	844,						/* U+001E0D */
	845,						/* U+001E0E */
	845,						/* U+001E0F */
	846,						/* U+001E10 */
	846,						/* U+001E11 */
	847,						/* U+001E12 */
	847,						/* U+001E13 */
	848,						/* U+001E14 */
	848,						/* U+001E15 */
	849,						/* U+001E16 */
	849,						/* U+001E17 */
	850,						/* U+001E18 */
	850,						/* U+001E19 */
	851,						/* U+001E1A */
	851,						/* U+001E1B */
	852,						/* U+001E1C */
	852,						/* U+001E1D */
	853,						/* U+001E1E */
	853,						/* U+001E1F */
	854,						/* U+001E20 */
	854,						/* U+001E21 */
	855,						/* U+001E22 */
	855,						/* U+001E23 */
	856,						/* U+001E24 */
	856,						/* U+001E25 */
	857,						/* U+001E26 */
	857,						/* U+001E27 */
	858,						/* U+001E28 */
	858,						/* U+001E29 */
	859,						/* U+001E2A */
	859,						/* U+001E2B */
	860,						/* U+001E2C */
	860,						/* U+001E2D */
	861,						/* U+001E2E */
	861,						/* U+001E2F */
	862,						/* U+001E30 */
	862,						/* U+001E31 */
	863,						/* U+001E32 */
	863,						/* U+001E33 */
	864,						/* U+001E34 */
	864,						/* U+001E35 */
	865,						/* U+001E36 */
	865,						/* U+001E37 */
	866,						/* U+001E38 */
	866,						/* U+001E39 */
	867,						/* U+001E3A */
	867,						/* U+001E3B */
	868,						/* U+001E3C */
	868,						/* U+001E3D */
	869,						/* U+001E3E */
	869,						/* U+001E3F */
	870,						/* U+001E40 */
	870,						/* U+001E41 */
	871,						/* U+001E42 */
	871,						/* U+001E43 */
	872,						/* U+001E44 */
	872,						/* U+001E45 */
	873,						/* U+001E46 */
	873,						/* U+001E47 */
	874,						/* U+001E48 */
	874,						/* U+001E49 */
	875,						/* U+001E4A */
	875,						/* U+001E4B */
	876,						/* U+001E4C */
	876,						/* U+001E4D */
	877,						/* U+001E4E */
	877,						/* U+001E4F */
	878,						/* U+001E50 */
	878,						/* U+001E51 */
	879,						/* U+001E52 */
	879,						/* U+001E53 */
	880,						/* U+001E54 */
	880,						/* U+001E55 */
	881,						/* U+001E56 */
	881,						/* U+001E57 */
	882,						/* U+001E58 */
	882,						/* U+001E59 */
	883,						/* U+001E5A */
	883,						/* U+001E5B */
	884,						/* U+001E5C */
	884,						/* U+001E5D */
	885,						/* U+001E5E */
	885,						/* U+001E5F */
	886,						/* U+001E60 */
	886,						/* U+001E61 */
	887,						/* U+001E62 */
	887,						/* U+001E63 */
	888,						/* U+001E64 */
	888,						/* U+001E65 */
	889,						/* U+001E66 */
	889,						/* U+001E67 */
	890,						/* U+001E68 */
	890,						/* U+001E69 */
	891,						/* U+001E6A */
	891,						/* U+001E6B */
	892,						/* U+001E6C */
	892,						/* U+001E6D */
	893,						/* U+001E6E */
	893,						/* U+001E6F */
	894,						/* U+001E70 */
	894,						/* U+001E71 */
	895,						/* U+001E72 */
	895,						/* U+001E73 */
	896,						/* U+001E74 */
	896,						/* U+001E75 */
	897,						/* U+001E76 */
	897,						/* U+001E77 */
	898,						/* U+001E78 */
	898,						/* U+001E79 */
	899,						/* U+001E7A */
	899,						/* U+001E7B */
	900,						/* U+001E7C */
	900,						/* U+001E7D */
	901,						/* U+001E7E */
	901,						/* U+001E7F */
	902,						/* U+001E80 */
	902,						/* U+001E81 */
	903,						/* U+001E82 */
	903,						/* U+001E83 */
	904,						/* U+001E84 */
	904,						/* U+001E85 */
	905,						/* U+001E86 */
	905,						/* U+001E87 */
	906,						/* U+001E88 */
	906,						/* U+001E89 */
	907,						/* U+001E8A */
	907,						/* U+001E8B */
	908,						/* U+001E8C */
	908,						/* U+001E8D */
	909,						/* U+001E8E */
	909,						/* U+001E8F */
	910,						/* U+001E90 */
	910,						/* U+001E91 */
	911,						/* U+001E92 */
	911,						/* U+001E93 */
	912,						/* U+001E94 */
	912,						/* U+001E95 */
	913,						/* U+001E96 */
	914,						/* U+001E97 */
	915,						/* U+001E98 */
	916,						/* U+001E99 */
	917,						/* U+001E9A */
	918,						/* U+001E9B */
	0,							/* U+001E9C */
	0,							/* U+001E9D */
	919,						/* U+001E9E */
	0,							/* U+001E9F */
	920,						/* U+001EA0 */
	920,						/* U+001EA1 */
	921,						/* U+001EA2 */
	921,						/* U+001EA3 */
	922,						/* U+001EA4 */
	922,						/* U+001EA5 */
	923,						/* U+001EA6 */
	923,						/* U+001EA7 */
	924,						/* U+001EA8 */
	924,						/* U+001EA9 */
	925,						/* U+001EAA */
	925,						/* U+001EAB */
	926,						/* U+001EAC */
	926,						/* U+001EAD */
	927,						/* U+001EAE */
	927,						/* U+001EAF */
	928,						/* U+001EB0 */
	928,						/* U+001EB1 */
	929,						/* U+001EB2 */
	929,						/* U+001EB3 */
	930,						/* U+001EB4 */
	930,						/* U+001EB5 */
	931,						/* U+001EB6 */
	931,						/* U+001EB7 */
	932,						/* U+001EB8 */
	932,						/* U+001EB9 */
	933,						/* U+001EBA */
	933,						/* U+001EBB */
	934,						/* U+001EBC */
	934,						/* U+001EBD */
	935,						/* U+001EBE */
	935,						/* U+001EBF */
	936,						/* U+001EC0 */
	936,						/* U+001EC1 */
	937,						/* U+001EC2 */
	937,						/* U+001EC3 */
	938,						/* U+001EC4 */
	938,						/* U+001EC5 */
	939,						/* U+001EC6 */
	939,						/* U+001EC7 */
	940,						/* U+001EC8 */
	940,						/* U+001EC9 */
	941,						/* U+001ECA */
	941,						/* U+001ECB */
	942,						/* U+001ECC */
	942,						/* U+001ECD */
	943,						/* U+001ECE */
	943,						/* U+001ECF */
	944,						/* U+001ED0 */
	944,						/* U+001ED1 */
	945,						/* U+001ED2 */
	945,						/* U+001ED3 */
	946,						/* U+001ED4 */
	946,						/* U+001ED5 */
	947,						/* U+001ED6 */
	947,						/* U+001ED7 */
	948,						/* U+001ED8 */
	948,						/* U+001ED9 */
	949,						/* U+001EDA */
	949,						/* U+001EDB */
	950,						/* U+001EDC */
	950,						/* U+001EDD */
	951,						/* U+001EDE */
	951,						/* U+001EDF */
	952,						/* U+001EE0 */
	952,						/* U+001EE1 */
	953,						/* U+001EE2 */
	953,						/* U+001EE3 */
	954,						/* U+001EE4 */
	954,						/* U+001EE5 */
	955,						/* U+001EE6 */
	955,						/* U+001EE7 */
	956,						/* U+001EE8 */
	956,						/* U+001EE9 */
	957,						/* U+001EEA */
	957,						/* U+001EEB */
	958,						/* U+001EEC */
	958,						/* U+001EED */
	959,						/* U+001EEE */
	959,						/* U+001EEF */
	960,						/* U+001EF0 */
	960,						/* U+001EF1 */
	961,						/* U+001EF2 */
	961,						/* U+001EF3 */
	962,						/* U+001EF4 */
	962,						/* U+001EF5 */
	963,						/* U+001EF6 */
	963,						/* U+001EF7 */
	964,						/* U+001EF8 */
	964,						/* U+001EF9 */
	965,						/* U+001EFA */
	965,						/* U+001EFB */
	966,						/* U+001EFC */
	966,						/* U+001EFD */
	967,						/* U+001EFE */
	967,						/* U+001EFF */
	968,						/* U+001F00 */
	969,						/* U+001F01 */
	970,						/* U+001F02 */
	971,						/* U+001F03 */
	972,						/* U+001F04 */
	973,						/* U+001F05 */
	974,						/* U+001F06 */
	975,						/* U+001F07 */
	968,						/* U+001F08 */
	969,						/* U+001F09 */
	970,						/* U+001F0A */
	971,						/* U+001F0B */
	972,						/* U+001F0C */
	973,						/* U+001F0D */
	974,						/* U+001F0E */
	975,						/* U+001F0F */
	976,						/* U+001F10 */
	977,						/* U+001F11 */
	978,						/* U+001F12 */
	979,						/* U+001F13 */
	980,						/* U+001F14 */
	981,						/* U+001F15 */
	0,							/* U+001F16 */
	0,							/* U+001F17 */
	976,						/* U+001F18 */
	977,						/* U+001F19 */
	978,						/* U+001F1A */
	979,						/* U+001F1B */
	980,						/* U+001F1C */
	981,						/* U+001F1D */
	0,							/* U+001F1E */
	0,							/* U+001F1F */
	982,						/* U+001F20 */
	983,						/* U+001F21 */
	984,						/* U+001F22 */
	985,						/* U+001F23 */
	986,						/* U+001F24 */
	987,						/* U+001F25 */
	988,						/* U+001F26 */
	989,						/* U+001F27 */
	982,						/* U+001F28 */
	983,						/* U+001F29 */
	984,						/* U+001F2A */
	985,						/* U+001F2B */
	986,						/* U+001F2C */
	987,						/* U+001F2D */
	988,						/* U+001F2E */
	989,						/* U+001F2F */
	990,						/* U+001F30 */
	991,						/* U+001F31 */
	992,						/* U+001F32 */
	993,						/* U+001F33 */
	994,						/* U+001F34 */
	995,						/* U+001F35 */
	996,						/* U+001F36 */
	997,						/* U+001F37 */
	990,						/* U+001F38 */
	991,						/* U+001F39 */
	992,						/* U+001F3A */
	993,						/* U+001F3B */
	994,						/* U+001F3C */
	995,						/* U+001F3D */
	996,						/* U+001F3E */
	997,						/* U+001F3F */
	998,						/* U+001F40 */
	999,						/* U+001F41 */
	1000,						/* U+001F42 */
	1001,						/* U+001F43 */
	1002,						/* U+001F44 */
	1003,						/* U+001F45 */
	0,							/* U+001F46 */
	0,							/* U+001F47 */
	998,						/* U+001F48 */
	999,						/* U+001F49 */
	1000,						/* U+001F4A */
	1001,						/* U+001F4B */
	1002,						/* U+001F4C */
	1003,						/* U+001F4D */
	0,							/* U+001F4E */
	0,							/* U+001F4F */
	1004,						/* U+001F50 */
	1005,						/* U+001F51 */
	1006,						/* U+001F52 */
	1007,						/* U+001F53 */
	1008,						/* U+001F54 */
	1009,						/* U+001F55 */
	1010,						/* U+001F56 */
	1011,						/* U+001F57 */
	0,							/* U+001F58 */
	1005,						/* U+001F59 */
	0,							/* U+001F5A */
	1007,						/* U+001F5B */
	0,							/* U+001F5C */
	1009,						/* U+001F5D */
	0,							/* U+001F5E */
	1011,						/* U+001F5F */
	1012,						/* U+001F60 */
	1013,						/* U+001F61 */
	1014,						/* U+001F62 */
	1015,						/* U+001F63 */
	1016,						/* U+001F64 */
	1017,						/* U+001F65 */
	1018,						/* U+001F66 */
	1019,						/* U+001F67 */
	1012,						/* U+001F68 */
	1013,						/* U+001F69 */
	1014,						/* U+001F6A */
	1015,						/* U+001F6B */
	1016,						/* U+001F6C */
	1017,						/* U+001F6D */
	1018,						/* U+001F6E */
	1019,						/* U+001F6F */
	1020,						/* U+001F70 */
	1021,						/* U+001F71 */
	1022,						/* U+001F72 */
	1023,						/* U+001F73 */
	1024,						/* U+001F74 */
	1025,						/* U+001F75 */
	1026,						/* U+001F76 */
	1027,						/* U+001F77 */
	1028,						/* U+001F78 */
	1029,						/* U+001F79 */
	1030,						/* U+001F7A */
	1031,						/* U+001F7B */
	1032,						/* U+001F7C */
	1033,						/* U+001F7D */
	0,							/* U+001F7E */
	0,							/* U+001F7F */
	1034,						/* U+001F80 */
	1035,						/* U+001F81 */
	1036,						/* U+001F82 */
	1037,						/* U+001F83 */
	1038,						/* U+001F84 */
	1039,						/* U+001F85 */
	1040,						/* U+001F86 */
	1041,						/* U+001F87 */
	1042,						/* U+001F88 */
	1043,						/* U+001F89 */
	1044,						/* U+001F8A */
	1045,						/* U+001F8B */
	1046,						/* U+001F8C */
	1047,						/* U+001F8D */
	1048,						/* U+001F8E */
	1049,						/* U+001F8F */
	1050,						/* U+001F90 */
	1051,						/* U+001F91 */
	1052,						/* U+001F92 */
	1053,						/* U+001F93 */
	1054,						/* U+001F94 */
	1055,						/* U+001F95 */
	1056,						/* U+001F96 */
	1057,						/* U+001F97 */
	1058,						/* U+001F98 */
	1059,						/* U+001F99 */
	1060,						/* U+001F9A */
	1061,						/* U+001F9B */
	1062,						/* U+001F9C */
	1063,						/* U+001F9D */
	1064,						/* U+001F9E */
	1065,						/* U+001F9F */
	1066,						/* U+001FA0 */
	1067,						/* U+001FA1 */
	1068,						/* U+001FA2 */
	1069,						/* U+001FA3 */
	1070,						/* U+001FA4 */
	1071,						/* U+001FA5 */
	1072,						/* U+001FA6 */
	1073,						/* U+001FA7 */
	1074,						/* U+001FA8 */
	1075,						/* U+001FA9 */
	1076,						/* U+001FAA */
	1077,						/* U+001FAB */
	1078,						/* U+001FAC */
	1079,						/* U+001FAD */
	1080,						/* U+001FAE */
	1081,						/* U+001FAF */
	1082,						/* U+001FB0 */
	1083,						/* U+001FB1 */
	1084,						/* U+001FB2 */
	1085,						/* U+001FB3 */
	1086,						/* U+001FB4 */
	0,							/* U+001FB5 */
	1087,						/* U+001FB6 */
	1088,						/* U+001FB7 */
	1082,						/* U+001FB8 */
	1083,						/* U+001FB9 */
	1020,						/* U+001FBA */
	1021,						/* U+001FBB */
	1089,						/* U+001FBC */
	0,							/* U+001FBD */
	1090,						/* U+001FBE */
	0,							/* U+001FBF */
	0,							/* U+001FC0 */
	0,							/* U+001FC1 */
	1091,						/* U+001FC2 */
	1092,						/* U+001FC3 */
	1093,						/* U+001FC4 */
	0,							/* U+001FC5 */
	1094,						/* U+001FC6 */
	1095,						/* U+001FC7 */
	1022,						/* U+001FC8 */
	1023,						/* U+001FC9 */
	1024,						/* U+001FCA */
	1025,						/* U+001FCB */
	1096,						/* U+001FCC */
	0,							/* U+001FCD */
	0,							/* U+001FCE */
	0,							/* U+001FCF */
	1097,						/* U+001FD0 */
	1098,						/* U+001FD1 */
	1099,						/* U+001FD2 */
	1100,						/* U+001FD3 */
	0,							/* U+001FD4 */
	0,							/* U+001FD5 */
	1101,						/* U+001FD6 */
	1102,						/* U+001FD7 */
	1097,						/* U+001FD8 */
	1098,						/* U+001FD9 */
	1026,						/* U+001FDA */
	1027,						/* U+001FDB */
	0,							/* U+001FDC */
	0,							/* U+001FDD */
	0,							/* U+001FDE */
	0,							/* U+001FDF */
	1103,						/* U+001FE0 */
	1104,						/* U+001FE1 */
	1105,						/* U+001FE2 */
	1106,						/* U+001FE3 */
	1107,						/* U+001FE4 */
	1108,						/* U+001FE5 */
	1109,						/* U+001FE6 */
	1110,						/* U+001FE7 */
	1103,						/* U+001FE8 */
	1104,						/* U+001FE9 */
	1030,						/* U+001FEA */
	1031,						/* U+001FEB */
	1108,						/* U+001FEC */
	0,							/* U+001FED */
	0,							/* U+001FEE */
	0,							/* U+001FEF */
	0,							/* U+001FF0 */
	0,							/* U+001FF1 */
	1111,						/* U+001FF2 */
	1112,						/* U+001FF3 */
	1113,						/* U+001FF4 */
	0,							/* U+001FF5 */
	1114,						/* U+001FF6 */
	1115,						/* U+001FF7 */
	1028,						/* U+001FF8 */
	1029,						/* U+001FF9 */
	1032,						/* U+001FFA */
	1033,						/* U+001FFB */
	1116,						/* U+001FFC */
	0,							/* U+001FFD */
	0,							/* U+001FFE */
	0,							/* U+001FFF */
	0,							/* U+002000 */
	0,							/* U+002001 */
	0,							/* U+002002 */
	0,							/* U+002003 */
	0,							/* U+002004 */
	0,							/* U+002005 */
	0,							/* U+002006 */
	0,							/* U+002007 */
	0,							/* U+002008 */
	0,							/* U+002009 */
	0,							/* U+00200A */
	0,							/* U+00200B */
	0,							/* U+00200C */
	0,							/* U+00200D */
	0,							/* U+00200E */
	0,							/* U+00200F */
	0,							/* U+002010 */
	0,							/* U+002011 */
	0,							/* U+002012 */
	0,							/* U+002013 */
	0,							/* U+002014 */
	0,							/* U+002015 */
	0,							/* U+002016 */
	0,							/* U+002017 */
	0,							/* U+002018 */
	0,							/* U+002019 */
	0,							/* U+00201A */
	0,							/* U+00201B */
	0,							/* U+00201C */
	0,							/* U+00201D */
	0,							/* U+00201E */
	0,							/* U+00201F */
	0,							/* U+002020 */
	0,							/* U+002021 */
	0,							/* U+002022 */
	0,							/* U+002023 */
	0,							/* U+002024 */
	0,							/* U+002025 */
	0,							/* U+002026 */
	0,							/* U+002027 */
	0,							/* U+002028 */
	0,							/* U+002029 */
	0,							/* U+00202A */
	0,							/* U+00202B */
	0,							/* U+00202C */
	0,							/* U+00202D */
	0,							/* U+00202E */
	0,							/* U+00202F */
	0,							/* U+002030 */
	0,							/* U+002031 */
	0,							/* U+002032 */
	0,							/* U+002033 */
	0,							/* U+002034 */
	0,							/* U+002035 */
	0,							/* U+002036 */
	0,							/* U+002037 */
	0,							/* U+002038 */
	0,							/* U+002039 */
	0,							/* U+00203A */
	0,							/* U+00203B */
	0,							/* U+00203C */
	0,							/* U+00203D */
	0,							/* U+00203E */
	0,							/* U+00203F */
	0,							/* U+002040 */
	0,							/* U+002041 */
	0,							/* U+002042 */
	0,							/* U+002043 */
	0,							/* U+002044 */
	0,							/* U+002045 */
	0,							/* U+002046 */
	0,							/* U+002047 */
	0,							/* U+002048 */
	0,							/* U+002049 */
	0,							/* U+00204A */
	0,							/* U+00204B */
	0,							/* U+00204C */
	0,							/* U+00204D */
	0,							/* U+00204E */
	0,							/* U+00204F */
	0,							/* U+002050 */
	0,							/* U+002051 */
	0,							/* U+002052 */
	0,							/* U+002053 */
	0,							/* U+002054 */
	0,							/* U+002055 */
	0,							/* U+002056 */
	0,							/* U+002057 */
	0,							/* U+002058 */
	0,							/* U+002059 */
	0,							/* U+00205A */
	0,							/* U+00205B */
	0,							/* U+00205C */
	0,							/* U+00205D */
	0,							/* U+00205E */
	0,							/* U+00205F */
	0,							/* U+002060 */
	0,							/* U+002061 */
	0,							/* U+002062 */
	0,							/* U+002063 */
	0,							/* U+002064 */
	0,							/* U+002065 */
	0,							/* U+002066 */
	0,							/* U+002067 */
	0,							/* U+002068 */
	0,							/* U+002069 */
	0,							/* U+00206A */
	0,							/* U+00206B */
	0,							/* U+00206C */
	0,							/* U+00206D */
	0,							/* U+00206E */
	0,							/* U+00206F */
	0,							/* U+002070 */
	0,							/* U+002071 */
	0,							/* U+002072 */
	0,							/* U+002073 */
	0,							/* U+002074 */
	0,							/* U+002075 */
	0,							/* U+002076 */
	0,							/* U+002077 */
	0,							/* U+002078 */
	0,							/* U+002079 */
	0,							/* U+00207A */
	0,							/* U+00207B */
	0,							/* U+00207C */
	0,							/* U+00207D */
	0,							/* U+00207E */
	0,							/* U+00207F */
	0,							/* U+002080 */
	0,							/* U+002081 */
	0,							/* U+002082 */
	0,							/* U+002083 */
	0,							/* U+002084 */
	0,							/* U+002085 */
	0,							/* U+002086 */
	0,							/* U+002087 */
	0,							/* U+002088 */
	0,							/* U+002089 */
	0,							/* U+00208A */
	0,							/* U+00208B */
	0,							/* U+00208C */
	0,							/* U+00208D */
	0,							/* U+00208E */
	0,							/* U+00208F */
	0,							/* U+002090 */
	0,							/* U+002091 */
	0,							/* U+002092 */
	0,							/* U+002093 */
	0,							/* U+002094 */
	0,							/* U+002095 */
	0,							/* U+002096 */
	0,							/* U+002097 */
	0,							/* U+002098 */
	0,							/* U+002099 */
	0,							/* U+00209A */
	0,							/* U+00209B */
	0,							/* U+00209C */
	0,							/* U+00209D */
	0,							/* U+00209E */
	0,							/* U+00209F */
	0,							/* U+0020A0 */
	0,							/* U+0020A1 */
	0,							/* U+0020A2 */
	0,							/* U+0020A3 */
	0,							/* U+0020A4 */
	0,							/* U+0020A5 */
	0,							/* U+0020A6 */
	0,							/* U+0020A7 */
	0,							/* U+0020A8 */
	0,							/* U+0020A9 */
	0,							/* U+0020AA */
	0,							/* U+0020AB */
	0,							/* U+0020AC */
	0,							/* U+0020AD */
	0,							/* U+0020AE */
	0,							/* U+0020AF */
	0,							/* U+0020B0 */
	0,							/* U+0020B1 */
	0,							/* U+0020B2 */
	0,							/* U+0020B3 */
	0,							/* U+0020B4 */
	0,							/* U+0020B5 */
	0,							/* U+0020B6 */
	0,							/* U+0020B7 */
	0,							/* U+0020B8 */
	0,							/* U+0020B9 */
	0,							/* U+0020BA */
	0,							/* U+0020BB */
	0,							/* U+0020BC */
	0,							/* U+0020BD */
	0,							/* U+0020BE */
	0,							/* U+0020BF */
	0,							/* U+0020C0 */
	0,							/* U+0020C1 */
	0,							/* U+0020C2 */
	0,							/* U+0020C3 */
	0,							/* U+0020C4 */
	0,							/* U+0020C5 */
	0,							/* U+0020C6 */
	0,							/* U+0020C7 */
	0,							/* U+0020C8 */
	0,							/* U+0020C9 */
	0,							/* U+0020CA */
	0,							/* U+0020CB */
	0,							/* U+0020CC */
	0,							/* U+0020CD */
	0,							/* U+0020CE */
	0,							/* U+0020CF */
	0,							/* U+0020D0 */
	0,							/* U+0020D1 */
	0,							/* U+0020D2 */
	0,							/* U+0020D3 */
	0,							/* U+0020D4 */
	0,							/* U+0020D5 */
	0,							/* U+0020D6 */
	0,							/* U+0020D7 */
	0,							/* U+0020D8 */
	0,							/* U+0020D9 */
	0,							/* U+0020DA */
	0,							/* U+0020DB */
	0,							/* U+0020DC */
	0,							/* U+0020DD */
	0,							/* U+0020DE */
	0,							/* U+0020DF */
	0,							/* U+0020E0 */
	0,							/* U+0020E1 */
	0,							/* U+0020E2 */
	0,							/* U+0020E3 */
	0,							/* U+0020E4 */
	0,							/* U+0020E5 */
	0,							/* U+0020E6 */
	0,							/* U+0020E7 */
	0,							/* U+0020E8 */
	0,							/* U+0020E9 */
	0,							/* U+0020EA */
	0,							/* U+0020EB */
	0,							/* U+0020EC */
	0,							/* U+0020ED */
	0,							/* U+0020EE */
	0,							/* U+0020EF */
	0,							/* U+0020F0 */
	0,							/* U+0020F1 */
	0,							/* U+0020F2 */
	0,							/* U+0020F3 */
	0,							/* U+0020F4 */
	0,							/* U+0020F5 */
	0,							/* U+0020F6 */
	0,							/* U+0020F7 */
	0,							/* U+0020F8 */
	0,							/* U+0020F9 */
	0,							/* U+0020FA */
	0,							/* U+0020FB */
	0,							/* U+0020FC */
	0,							/* U+0020FD */
	0,							/* U+0020FE */
	0,							/* U+0020FF */
	0,							/* U+002100 */
	0,							/* U+002101 */
	0,							/* U+002102 */
	0,							/* U+002103 */
	0,							/* U+002104 */
	0,							/* U+002105 */
	0,							/* U+002106 */
	0,							/* U+002107 */
	0,							/* U+002108 */
	0,							/* U+002109 */
	0,							/* U+00210A */
	0,							/* U+00210B */
	0,							/* U+00210C */
	0,							/* U+00210D */
	0,							/* U+00210E */
	0,							/* U+00210F */
	0,							/* U+002110 */
	0,							/* U+002111 */
	0,							/* U+002112 */
	0,							/* U+002113 */
	0,							/* U+002114 */
	0,							/* U+002115 */
	0,							/* U+002116 */
	0,							/* U+002117 */
	0,							/* U+002118 */
	0,							/* U+002119 */
	0,							/* U+00211A */
	0,							/* U+00211B */
	0,							/* U+00211C */
	0,							/* U+00211D */
	0,							/* U+00211E */
	0,							/* U+00211F */
	0,							/* U+002120 */
	0,							/* U+002121 */
	0,							/* U+002122 */
	0,							/* U+002123 */
	0,							/* U+002124 */
	0,							/* U+002125 */
	1117,						/* U+002126 */
	0,							/* U+002127 */
	0,							/* U+002128 */
	0,							/* U+002129 */
	1118,						/* U+00212A */
	1119,						/* U+00212B */
	0,							/* U+00212C */
	0,							/* U+00212D */
	0,							/* U+00212E */
	0,							/* U+00212F */
	0,							/* U+002130 */
	0,							/* U+002131 */
	1120,						/* U+002132 */
	0,							/* U+002133 */
	0,							/* U+002134 */
	0,							/* U+002135 */
	0,							/* U+002136 */
	0,							/* U+002137 */
	0,							/* U+002138 */
	0,							/* U+002139 */
	0,							/* U+00213A */
	0,							/* U+00213B */
	0,							/* U+00213C */
	0,							/* U+00213D */
	0,							/* U+00213E */
	0,							/* U+00213F */
	0,							/* U+002140 */
	0,							/* U+002141 */
	0,							/* U+002142 */
	0,							/* U+002143 */
	0,							/* U+002144 */
	0,							/* U+002145 */
	0,							/* U+002146 */
	0,							/* U+002147 */
	0,							/* U+002148 */
	0,							/* U+002149 */
	0,							/* U+00214A */
	0,							/* U+00214B */
	0,							/* U+00214C */
	0,							/* U+00214D */
	1120,						/* U+00214E */
	0,							/* U+00214F */
	0,							/* U+002150 */
	0,							/* U+002151 */
	0,							/* U+002152 */
	0,							/* U+002153 */
	0,							/* U+002154 */
	0,							/* U+002155 */
	0,							/* U+002156 */
	0,							/* U+002157 */
	0,							/* U+002158 */
	0,							/* U+002159 */
	0,							/* U+00215A */
	0,							/* U+00215B */
	0,							/* U+00215C */
	0,							/* U+00215D */
	0,							/* U+00215E */
	0,							/* U+00215F */
	1121,						/* U+002160 */
	1122,						/* U+002161 */
	1123,						/* U+002162 */
	1124,						/* U+002163 */
	1125,						/* U+002164 */
	1126,						/* U+002165 */
	1127,						/* U+002166 */
	1128,						/* U+002167 */
	1129,						/* U+002168 */
	1130,						/* U+002169 */
	1131,						/* U+00216A */
	1132,						/* U+00216B */
	1133,						/* U+00216C */
	1134,						/* U+00216D */
	1135,						/* U+00216E */
	1136,						/* U+00216F */
	1121,						/* U+002170 */
	1122,						/* U+002171 */
	1123,						/* U+002172 */
	1124,						/* U+002173 */
	1125,						/* U+002174 */
	1126,						/* U+002175 */
	1127,						/* U+002176 */
	1128,						/* U+002177 */
	1129,						/* U+002178 */
	1130,						/* U+002179 */
	1131,						/* U+00217A */
	1132,						/* U+00217B */
	1133,						/* U+00217C */
	1134,						/* U+00217D */
	1135,						/* U+00217E */
	1136,						/* U+00217F */
	0,							/* U+002180 */
	0,							/* U+002181 */
	0,							/* U+002182 */
	1137,						/* U+002183 */
	1137,						/* U+002184 */
	1138,						/* U+0024B6 */
	1139,						/* U+0024B7 */
	1140,						/* U+0024B8 */
	1141,						/* U+0024B9 */
	1142,						/* U+0024BA */
	1143,						/* U+0024BB */
	1144,						/* U+0024BC */
	1145,						/* U+0024BD */
	1146,						/* U+0024BE */
	1147,						/* U+0024BF */
	1148,						/* U+0024C0 */
	1149,						/* U+0024C1 */
	1150,						/* U+0024C2 */
	1151,						/* U+0024C3 */
	1152,						/* U+0024C4 */
	1153,						/* U+0024C5 */
	1154,						/* U+0024C6 */
	1155,						/* U+0024C7 */
	1156,						/* U+0024C8 */
	1157,						/* U+0024C9 */
	1158,						/* U+0024CA */
	1159,						/* U+0024CB */
	1160,						/* U+0024CC */
	1161,						/* U+0024CD */
	1162,						/* U+0024CE */
	1163,						/* U+0024CF */
	1138,						/* U+0024D0 */
	1139,						/* U+0024D1 */
	1140,						/* U+0024D2 */
	1141,						/* U+0024D3 */
	1142,						/* U+0024D4 */
	1143,						/* U+0024D5 */
	1144,						/* U+0024D6 */
	1145,						/* U+0024D7 */
	1146,						/* U+0024D8 */
	1147,						/* U+0024D9 */
	1148,						/* U+0024DA */
	1149,						/* U+0024DB */
	1150,						/* U+0024DC */
	1151,						/* U+0024DD */
	1152,						/* U+0024DE */
	1153,						/* U+0024DF */
	1154,						/* U+0024E0 */
	1155,						/* U+0024E1 */
	1156,						/* U+0024E2 */
	1157,						/* U+0024E3 */
	1158,						/* U+0024E4 */
	1159,						/* U+0024E5 */
	1160,						/* U+0024E6 */
	1161,						/* U+0024E7 */
	1162,						/* U+0024E8 */
	1163,						/* U+0024E9 */
	1164,						/* U+002C00 */
	1165,						/* U+002C01 */
	1166,						/* U+002C02 */
	1167,						/* U+002C03 */
	1168,						/* U+002C04 */
	1169,						/* U+002C05 */
	1170,						/* U+002C06 */
	1171,						/* U+002C07 */
	1172,						/* U+002C08 */
	1173,						/* U+002C09 */
	1174,						/* U+002C0A */
	1175,						/* U+002C0B */
	1176,						/* U+002C0C */
	1177,						/* U+002C0D */
	1178,						/* U+002C0E */
	1179,						/* U+002C0F */
	1180,						/* U+002C10 */
	1181,						/* U+002C11 */
	1182,						/* U+002C12 */
	1183,						/* U+002C13 */
	1184,						/* U+002C14 */
	1185,						/* U+002C15 */
	1186,						/* U+002C16 */
	1187,						/* U+002C17 */
	1188,						/* U+002C18 */
	1189,						/* U+002C19 */
	1190,						/* U+002C1A */
	1191,						/* U+002C1B */
	1192,						/* U+002C1C */
	1193,						/* U+002C1D */
	1194,						/* U+002C1E */
	1195,						/* U+002C1F */
	1196,						/* U+002C20 */
	1197,						/* U+002C21 */
	1198,						/* U+002C22 */
	1199,						/* U+002C23 */
	1200,						/* U+002C24 */
	1201,						/* U+002C25 */
	1202,						/* U+002C26 */
	1203,						/* U+002C27 */
	1204,						/* U+002C28 */
	1205,						/* U+002C29 */
	1206,						/* U+002C2A */
	1207,						/* U+002C2B */
	1208,						/* U+002C2C */
	1209,						/* U+002C2D */
	1210,						/* U+002C2E */
	1211,						/* U+002C2F */
	1164,						/* U+002C30 */
	1165,						/* U+002C31 */
	1166,						/* U+002C32 */
	1167,						/* U+002C33 */
	1168,						/* U+002C34 */
	1169,						/* U+002C35 */
	1170,						/* U+002C36 */
	1171,						/* U+002C37 */
	1172,						/* U+002C38 */
	1173,						/* U+002C39 */
	1174,						/* U+002C3A */
	1175,						/* U+002C3B */
	1176,						/* U+002C3C */
	1177,						/* U+002C3D */
	1178,						/* U+002C3E */
	1179,						/* U+002C3F */
	1180,						/* U+002C40 */
	1181,						/* U+002C41 */
	1182,						/* U+002C42 */
	1183,						/* U+002C43 */
	1184,						/* U+002C44 */
	1185,						/* U+002C45 */
	1186,						/* U+002C46 */
	1187,						/* U+002C47 */
	1188,						/* U+002C48 */
	1189,						/* U+002C49 */
	1190,						/* U+002C4A */
	1191,						/* U+002C4B */
	1192,						/* U+002C4C */
	1193,						/* U+002C4D */
	1194,						/* U+002C4E */
	1195,						/* U+002C4F */
	1196,						/* U+002C50 */
	1197,						/* U+002C51 */
	1198,						/* U+002C52 */
	1199,						/* U+002C53 */
	1200,						/* U+002C54 */
	1201,						/* U+002C55 */
	1202,						/* U+002C56 */
	1203,						/* U+002C57 */
	1204,						/* U+002C58 */
	1205,						/* U+002C59 */
	1206,						/* U+002C5A */
	1207,						/* U+002C5B */
	1208,						/* U+002C5C */
	1209,						/* U+002C5D */
	1210,						/* U+002C5E */
	1211,						/* U+002C5F */
	1212,						/* U+002C60 */
	1212,						/* U+002C61 */
	343,						/* U+002C62 */
	836,						/* U+002C63 */
	346,						/* U+002C64 */
	321,						/* U+002C65 */
	323,						/* U+002C66 */
	1213,						/* U+002C67 */
	1213,						/* U+002C68 */
	1214,						/* U+002C69 */
	1214,						/* U+002C6A */
	1215,						/* U+002C6B */
	1215,						/* U+002C6C */
	335,						/* U+002C6D */
	345,						/* U+002C6E */
	334,						/* U+002C6F */
	336,						/* U+002C70 */
	0,							/* U+002C71 */
	1216,						/* U+002C72 */
	1216,						/* U+002C73 */
	0,							/* U+002C74 */
	1217,						/* U+002C75 */
	1217,						/* U+002C76 */
	0,							/* U+002C77 */
	0,							/* U+002C78 */
	0,							/* U+002C79 */
	0,							/* U+002C7A */
	0,							/* U+002C7B */
	0,							/* U+002C7C */
	0,							/* U+002C7D */
	324,						/* U+002C7E */
	325,						/* U+002C7F */
	1218,						/* U+002C80 */
	1218,						/* U+002C81 */
	1219,						/* U+002C82 */
	1219,						/* U+002C83 */
	1220,						/* U+002C84 */
	1220,						/* U+002C85 */
	1221,						/* U+002C86 */
	1221,						/* U+002C87 */
	1222,						/* U+002C88 */
	1222,						/* U+002C89 */
	1223,						/* U+002C8A */
	1223,						/* U+002C8B */
	1224,						/* U+002C8C */
	1224,						/* U+002C8D */
	1225,						/* U+002C8E */
	1225,						/* U+002C8F */
	1226,						/* U+002C90 */
	1226,						/* U+002C91 */
	1227,						/* U+002C92 */
	1227,						/* U+002C93 */
	1228,						/* U+002C94 */
	1228,						/* U+002C95 */
	1229,						/* U+002C96 */
	1229,						/* U+002C97 */
	1230,						/* U+002C98 */
	1230,						/* U+002C99 */
	1231,						/* U+002C9A */
	1231,						/* U+002C9B */
	1232,						/* U+002C9C */
	1232,						/* U+002C9D */
	1233,						/* U+002C9E */
	1233,						/* U+002C9F */
	1234,						/* U+002CA0 */
	1234,						/* U+002CA1 */
	1235,						/* U+002CA2 */
	1235,						/* U+002CA3 */
	1236,						/* U+002CA4 */
	1236,						/* U+002CA5 */
	1237,						/* U+002CA6 */
	1237,						/* U+002CA7 */
	1238,						/* U+002CA8 */
	1238,						/* U+002CA9 */
	1239,						/* U+002CAA */
	1239,						/* U+002CAB */
	1240,						/* U+002CAC */
	1240,						/* U+002CAD */
	1241,						/* U+002CAE */
	1241,						/* U+002CAF */
	1242,						/* U+002CB0 */
	1242,						/* U+002CB1 */
	1243,						/* U+002CB2 */
	1243,						/* U+002CB3 */
	1244,						/* U+002CB4 */
	1244,						/* U+002CB5 */
	1245,						/* U+002CB6 */
	1245,						/* U+002CB7 */
	1246,						/* U+002CB8 */
	1246,						/* U+002CB9 */
	1247,						/* U+002CBA */
	1247,						/* U+002CBB */
	1248,						/* U+002CBC */
	1248,						/* U+002CBD */
	1249,						/* U+002CBE */
	1249,						/* U+002CBF */
	1250,						/* U+002CC0 */
	1250,						/* U+002CC1 */
	1251,						/* U+002CC2 */
	1251,						/* U+002CC3 */
	1252,						/* U+002CC4 */
	1252,						/* U+002CC5 */
	1253,						/* U+002CC6 */
	1253,						/* U+002CC7 */
	1254,						/* U+002CC8 */
	1254,						/* U+002CC9 */
	1255,						/* U+002CCA */
	1255,						/* U+002CCB */
	1256,						/* U+002CCC */
	1256,						/* U+002CCD */
	1257,						/* U+002CCE */
	1257,						/* U+002CCF */
	1258,						/* U+002CD0 */
	1258,						/* U+002CD1 */
	1259,						/* U+002CD2 */
	1259,						/* U+002CD3 */
	1260,						/* U+002CD4 */
	1260,						/* U+002CD5 */
	1261,						/* U+002CD6 */
	1261,						/* U+002CD7 */
	1262,						/* U+002CD8 */
	1262,						/* U+002CD9 */
	1263,						/* U+002CDA */
	1263,						/* U+002CDB */
	1264,						/* U+002CDC */
	1264,						/* U+002CDD */
	1265,						/* U+002CDE */
	1265,						/* U+002CDF */
	1266,						/* U+002CE0 */
	1266,						/* U+002CE1 */
	1267,						/* U+002CE2 */
	1267,						/* U+002CE3 */
	0,							/* U+002CE4 */
	0,							/* U+002CE5 */
	0,							/* U+002CE6 */
	0,							/* U+002CE7 */
	0,							/* U+002CE8 */
	0,							/* U+002CE9 */
	0,							/* U+002CEA */
	1268,						/* U+002CEB */
	1268,						/* U+002CEC */
	1269,						/* U+002CED */
	1269,						/* U+002CEE */
	0,							/* U+002CEF */
	0,							/* U+002CF0 */
	0,							/* U+002CF1 */
	1270,						/* U+002CF2 */
	1270,						/* U+002CF3 */
	0,							/* U+002CF4 */
	0,							/* U+002CF5 */
	0,							/* U+002CF6 */
	0,							/* U+002CF7 */
	0,							/* U+002CF8 */
	0,							/* U+002CF9 */
	0,							/* U+002CFA */
	0,							/* U+002CFB */
	0,							/* U+002CFC */
	0,							/* U+002CFD */
	0,							/* U+002CFE */
	0,							/* U+002CFF */
	607,						/* U+002D00 */
	608,						/* U+002D01 */
	609,						/* U+002D02 */
	610,						/* U+002D03 */
	611,						/* U+002D04 */
	612,						/* U+002D05 */
	613,						/* U+002D06 */
	614,						/* U+002D07 */
	615,						/* U+002D08 */
	616,						/* U+002D09 */
	617,						/* U+002D0A */
	618,						/* U+002D0B */
	619,						/* U+002D0C */
	620,						/* U+002D0D */
	621,						/* U+002D0E */
	622,						/* U+002D0F */
	623,						/* U+002D10 */
	624,						/* U+002D11 */
	625,						/* U+002D12 */
	626,						/* U+002D13 */
	627,						/* U+002D14 */
	628,						/* U+002D15 */
	629,						/* U+002D16 */
	630,						/* U+002D17 */
	631,						/* U+002D18 */
	632,						/* U+002D19 */
	633,						/* U+002D1A */
	634,						/* U+002D1B */
	635,						/* U+002D1C */
	636,						/* U+002D1D */
	637,						/* U+002D1E */
	638,						/* U+002D1F */
	639,						/* U+002D20 */
	640,						/* U+002D21 */
	641,						/* U+002D22 */
	642,						/* U+002D23 */
	643,						/* U+002D24 */
	644,						/* U+002D25 */
	0,							/* U+002D26 */
	645,						/* U+002D27 */
	0,							/* U+002D28 */
	0,							/* U+002D29 */
	0,							/* U+002D2A */
	0,							/* U+002D2B */
	0,							/* U+002D2C */
	646,						/* U+002D2D */
	1271,						/* U+00A640 */
	1271,						/* U+00A641 */
	1272,						/* U+00A642 */
	1272,						/* U+00A643 */
	1273,						/* U+00A644 */
	1273,						/* U+00A645 */
	1274,						/* U+00A646 */
	1274,						/* U+00A647 */
	1275,						/* U+00A648 */
	1275,						/* U+00A649 */
	1276,						/* U+00A64A */
	1276,						/* U+00A64B */
	1277,						/* U+00A64C */
	1277,						/* U+00A64D */
	1278,						/* U+00A64E */
	1278,						/* U+00A64F */
	1279,						/* U+00A650 */
	1279,						/* U+00A651 */
	1280,						/* U+00A652 */
	1280,						/* U+00A653 */
	1281,						/* U+00A654 */
	1281,						/* U+00A655 */
	1282,						/* U+00A656 */
	1282,						/* U+00A657 */
	1283,						/* U+00A658 */
	1283,						/* U+00A659 */
	1284,						/* U+00A65A */
	1284,						/* U+00A65B */
	1285,						/* U+00A65C */
	1285,						/* U+00A65D */
	1286,						/* U+00A65E */
	1286,						/* U+00A65F */
	1287,						/* U+00A660 */
	1287,						/* U+00A661 */
	1288,						/* U+00A662 */
	1288,						/* U+00A663 */
	1289,						/* U+00A664 */
	1289,						/* U+00A665 */
	1290,						/* U+00A666 */
	1290,						/* U+00A667 */
	1291,						/* U+00A668 */
	1291,						/* U+00A669 */
	1292,						/* U+00A66A */
	1292,						/* U+00A66B */
	1293,						/* U+00A66C */
	1293,						/* U+00A66D */
	0,							/* U+00A66E */
	0,							/* U+00A66F */
	0,							/* U+00A670 */
	0,							/* U+00A671 */
	0,							/* U+00A672 */
	0,							/* U+00A673 */
	0,							/* U+00A674 */
	0,							/* U+00A675 */
	0,							/* U+00A676 */
	0,							/* U+00A677 */
	0,							/* U+00A678 */
	0,							/* U+00A679 */
	0,							/* U+00A67A */
	0,							/* U+00A67B */
	0,							/* U+00A67C */
	0,							/* U+00A67D */
	0,							/* U+00A67E */
	0,							/* U+00A67F */
	1294,						/* U+00A680 */
	1294,						/* U+00A681 */
	1295,						/* U+00A682 */
	1295,						/* U+00A683 */
	1296,						/* U+00A684 */
	1296,						/* U+00A685 */
	1297,						/* U+00A686 */
	1297,						/* U+00A687 */
	1298,						/* U+00A688 */
	1298,						/* U+00A689 */
	1299,						/* U+00A68A */
	1299,						/* U+00A68B */
	1300,						/* U+00A68C */
	1300,						/* U+00A68D */
	1301,						/* U+00A68E */
	1301,						/* U+00A68F */
	1302,						/* U+00A690 */
	1302,						/* U+00A691 */
	1303,						/* U+00A692 */
	1303,						/* U+00A693 */
	1304,						/* U+00A694 */
	1304,						/* U+00A695 */
	1305,						/* U+00A696 */
	1305,						/* U+00A697 */
	1306,						/* U+00A698 */
	1306,						/* U+00A699 */
	1307,						/* U+00A69A */
	1307,						/* U+00A69B */
	0,							/* U+00A69C */
	0,							/* U+00A69D */
	0,							/* U+00A69E */
	0,							/* U+00A69F */
	0,							/* U+00A6A0 */
	0,							/* U+00A6A1 */
	0,							/* U+00A6A2 */
	0,							/* U+00A6A3 */
	0,							/* U+00A6A4 */
	0,							/* U+00A6A5 */
	0,							/* U+00A6A6 */
	0,							/* U+00A6A7 */
	0,							/* U+00A6A8 */
	0,							/* U+00A6A9 */
	0,							/* U+00A6AA */
	0,							/* U+00A6AB */
	0,							/* U+00A6AC */
	0,							/* U+00A6AD */
	0,							/* U+00A6AE */
	0,							/* U+00A6AF */
	0,							/* U+00A6B0 */
	0,							/* U+00A6B1 */
	0,							/* U+00A6B2 */
	0,							/* U+00A6B3 */
	0,							/* U+00A6B4 */
	0,							/* U+00A6B5 */
	0,							/* U+00A6B6 */
	0,							/* U+00A6B7 */
	0,							/* U+00A6B8 */
	0,							/* U+00A6B9 */
	0,							/* U+00A6BA */
	0,							/* U+00A6BB */
	0,							/* U+00A6BC */
	0,							/* U+00A6BD */
	0,							/* U+00A6BE */
	0,							/* U+00A6BF */
	0,							/* U+00A6C0 */
	0,							/* U+00A6C1 */
	0,							/* U+00A6C2 */
	0,							/* U+00A6C3 */
	0,							/* U+00A6C4 */
	0,							/* U+00A6C5 */
	0,							/* U+00A6C6 */
	0,							/* U+00A6C7 */
	0,							/* U+00A6C8 */
	0,							/* U+00A6C9 */
	0,							/* U+00A6CA */
	0,							/* U+00A6CB */
	0,							/* U+00A6CC */
	0,							/* U+00A6CD */
	0,							/* U+00A6CE */
	0,							/* U+00A6CF */
	0,							/* U+00A6D0 */
	0,							/* U+00A6D1 */
	0,							/* U+00A6D2 */
	0,							/* U+00A6D3 */
	0,							/* U+00A6D4 */
	0,							/* U+00A6D5 */
	0,							/* U+00A6D6 */
	0,							/* U+00A6D7 */
	0,							/* U+00A6D8 */
	0,							/* U+00A6D9 */
	0,							/* U+00A6DA */
	0,							/* U+00A6DB */
	0,							/* U+00A6DC */
	0,							/* U+00A6DD */
	0,							/* U+00A6DE */
	0,							/* U+00A6DF */
	0,							/* U+00A6E0 */
	0,							/* U+00A6E1 */
	0,							/* U+00A6E2 */
	0,							/* U+00A6E3 */
	0,							/* U+00A6E4 */
	0,							/* U+00A6E5 */
	0,							/* U+00A6E6 */
	0,							/* U+00A6E7 */
	0,							/* U+00A6E8 */
	0,							/* U+00A6E9 */
	0,							/* U+00A6EA */
	0,							/* U+00A6EB */
	0,							/* U+00A6EC */
	0,							/* U+00A6ED */
	0,							/* U+00A6EE */
	0,							/* U+00A6EF */
	0,							/* U+00A6F0 */
	0,							/* U+00A6F1 */
	0,							/* U+00A6F2 */
	0,							/* U+00A6F3 */
	0,							/* U+00A6F4 */
	0,							/* U+00A6F5 */
	0,							/* U+00A6F6 */
	0,							/* U+00A6F7 */
	0,							/* U+00A6F8 */
	0,							/* U+00A6F9 */
	0,							/* U+00A6FA */
	0,							/* U+00A6FB */
	0,							/* U+00A6FC */
	0,							/* U+00A6FD */
	0,							/* U+00A6FE */
	0,							/* U+00A6FF */
	0,							/* U+00A700 */
	0,							/* U+00A701 */
	0,							/* U+00A702 */
	0,							/* U+00A703 */
	0,							/* U+00A704 */
	0,							/* U+00A705 */
	0,							/* U+00A706 */
	0,							/* U+00A707 */
	0,							/* U+00A708 */
	0,							/* U+00A709 */
	0,							/* U+00A70A */
	0,							/* U+00A70B */
	0,							/* U+00A70C */
	0,							/* U+00A70D */
	0,							/* U+00A70E */
	0,							/* U+00A70F */
	0,							/* U+00A710 */
	0,							/* U+00A711 */
	0,							/* U+00A712 */
	0,							/* U+00A713 */
	0,							/* U+00A714 */
	0,							/* U+00A715 */
	0,							/* U+00A716 */
	0,							/* U+00A717 */
	0,							/* U+00A718 */
	0,							/* U+00A719 */
	0,							/* U+00A71A */
	0,							/* U+00A71B */
	0,							/* U+00A71C */
	0,							/* U+00A71D */
	0,							/* U+00A71E */
	0,							/* U+00A71F */
	0,							/* U+00A720 */
	0,							/* U+00A721 */
	1308,						/* U+00A722 */
	1308,						/* U+00A723 */
	1309,						/* U+00A724 */
	1309,						/* U+00A725 */
	1310,						/* U+00A726 */
	1310,						/* U+00A727 */
	1311,						/* U+00A728 */
	1311,						/* U+00A729 */
	1312,						/* U+00A72A */
	1312,						/* U+00A72B */
	1313,						/* U+00A72C */
	1313,						/* U+00A72D */
	1314,						/* U+00A72E */
	1314,						/* U+00A72F */
	0,							/* U+00A730 */
	0,							/* U+00A731 */
	1315,						/* U+00A732 */
	1315,						/* U+00A733 */
	1316,						/* U+00A734 */
	1316,						/* U+00A735 */
	1317,						/* U+00A736 */
	1317,						/* U+00A737 */
	1318,						/* U+00A738 */
	1318,						/* U+00A739 */
	1319,						/* U+00A73A */
	1319,						/* U+00A73B */
	1320,						/* U+00A73C */
	1320,						/* U+00A73D */
	1321,						/* U+00A73E */
	1321,						/* U+00A73F */
	1322,						/* U+00A740 */
	1322,						/* U+00A741 */
	1323,						/* U+00A742 */
	1323,						/* U+00A743 */
	1324,						/* U+00A744 */
	1324,						/* U+00A745 */
	1325,						/* U+00A746 */
	1325,						/* U+00A747 */
	1326,						/* U+00A748 */
	1326,						/* U+00A749 */
	1327,						/* U+00A74A */
	1327,						/* U+00A74B */
	1328,						/* U+00A74C */
	1328,						/* U+00A74D */
	1329,						/* U+00A74E */
	1329,						/* U+00A74F */
	1330,						/* U+00A750 */
	1330,						/* U+00A751 */
	1331,						/* U+00A752 */
	1331,						/* U+00A753 */
	1332,						/* U+00A754 */
	1332,						/* U+00A755 */
	1333,						/* U+00A756 */
	1333,						/* U+00A757 */
	1334,						/* U+00A758 */
	1334,						/* U+00A759 */
	1335,						/* U+00A75A */
	1335,						/* U+00A75B */
	1336,						/* U+00A75C */
	1336,						/* U+00A75D */
	1337,						/* U+00A75E */
	1337,						/* U+00A75F */
	1338,						/* U+00A760 */
	1338,						/* U+00A761 */
	1339,						/* U+00A762 */
	1339,						/* U+00A763 */
	1340,						/* U+00A764 */
	1340,						/* U+00A765 */
	1341,						/* U+00A766 */
	1341,						/* U+00A767 */
	1342,						/* U+00A768 */
	1342,						/* U+00A769 */
	1343,						/* U+00A76A */
	1343,						/* U+00A76B */
	1344,						/* U+00A76C */
	1344,						/* U+00A76D */
	1345,						/* U+00A76E */
	1345,						/* U+00A76F */
	0,							/* U+00A770 */
	0,							/* U+00A771 */
	0,							/* U+00A772 */
	0,							/* U+00A773 */
	0,							/* U+00A774 */
	0,							/* U+00A775 */
	0,							/* U+00A776 */
	0,							/* U+00A777 */
	0,							/* U+00A778 */
	1346,						/* U+00A779 */
	1346,						/* U+00A77A */
	1347,						/* U+00A77B */
	1347,						/* U+00A77C */
	835,						/* U+00A77D */
	1348,						/* U+00A77E */
	1348,						/* U+00A77F */
	1349,						/* U+00A780 */
	1349,						/* U+00A781 */
	1350,						/* U+00A782 */
	1350,						/* U+00A783 */
	1351,						/* U+00A784 */
	1351,						/* U+00A785 */
	1352,						/* U+00A786 */
	1352,						/* U+00A787 */
	0,							/* U+00A788 */
	0,							/* U+00A789 */
	0,							/* U+00A78A */
	1353,						/* U+00A78B */
	1353,						/* U+00A78C */
	340,						/* U+00A78D */
	0,							/* U+00A78E */
	0,							/* U+00A78F */
	1354,						/* U+00A790 */
	1354,						/* U+00A791 */
	1355,						/* U+00A792 */
	1355,						/* U+00A793 */
	1356,						/* U+00A794 */
	0,							/* U+00A795 */
	1357,						/* U+00A796 */
	1357,						/* U+00A797 */
	1358,						/* U+00A798 */
	1358,						/* U+00A799 */
	1359,						/* U+00A79A */
	1359,						/* U+00A79B */
	1360,						/* U+00A79C */
	1360,						/* U+00A79D */
	1361,						/* U+00A79E */
	1361,						/* U+00A79F */
	1362,						/* U+00A7A0 */
	1362,						/* U+00A7A1 */
	1363,						/* U+00A7A2 */
	1363,						/* U+00A7A3 */
	1364,						/* U+00A7A4 */
	1364,						/* U+00A7A5 */
	1365,						/* U+00A7A6 */
	1365,						/* U+00A7A7 */
	1366,						/* U+00A7A8 */
	1366,						/* U+00A7A9 */
	341,						/* U+00A7AA */
	337,						/* U+00A7AB */
	338,						/* U+00A7AC */
	344,						/* U+00A7AD */
	342,						/* U+00A7AE */
	0,							/* U+00A7AF */
	350,						/* U+00A7B0 */
	348,						/* U+00A7B1 */
	349,						/* U+00A7B2 */
	1367,						/* U+00A7B3 */
	1368,						/* U+00A7B4 */
	1368,						/* U+00A7B5 */
	1369,						/* U+00A7B6 */
	1369,						/* U+00A7B7 */
	1370,						/* U+00A7B8 */
	1370,						/* U+00A7B9 */
	1371,						/* U+00A7BA */
	1371,						/* U+00A7BB */
	1372,						/* U+00A7BC */
	1372,						/* U+00A7BD */
	1373,						/* U+00A7BE */
	1373,						/* U+00A7BF */
	1374,						/* U+00A7C0 */
	1374,						/* U+00A7C1 */
	1375,						/* U+00A7C2 */
	1375,						/* U+00A7C3 */
	1356,						/* U+00A7C4 */
	347,						/* U+00A7C5 */
	837,						/* U+00A7C6 */
	1376,						/* U+00A7C7 */
	1376,						/* U+00A7C8 */
	1377,						/* U+00A7C9 */
	1377,						/* U+00A7CA */
	339,						/* U+00A7CB */
	1378,						/* U+00A7CC */
	1378,						/* U+00A7CD */
	0,							/* U+00A7CE */
	0,							/* U+00A7CF */
	1379,						/* U+00A7D0 */
	1379,						/* U+00A7D1 */
	0,							/* U+00A7D2 */
	0,							/* U+00A7D3 */
	0,							/* U+00A7D4 */
	0,							/* U+00A7D5 */
	1380,						/* U+00A7D6 */
	1380,						/* U+00A7D7 */
	1381,						/* U+00A7D8 */
	1381,						/* U+00A7D9 */
	1382,						/* U+00A7DA */
	1382,						/* U+00A7DB */
	247,						/* U+00A7DC */
	0,							/* U+00A7DD */
	0,							/* U+00A7DE */
	0,							/* U+00A7DF */
	0,							/* U+00A7E0 */
	0,							/* U+00A7E1 */
	0,							/* U+00A7E2 */
	0,							/* U+00A7E3 */
	0,							/* U+00A7E4 */
	0,							/* U+00A7E5 */
	0,							/* U+00A7E6 */
	0,							/* U+00A7E7 */
	0,							/* U+00A7E8 */
	0,							/* U+00A7E9 */
	0,							/* U+00A7EA */
	0,							/* U+00A7EB */
	0,							/* U+00A7EC */
	0,							/* U+00A7ED */
	0,							/* U+00A7EE */
	0,							/* U+00A7EF */
	0,							/* U+00A7F0 */
	0,							/* U+00A7F1 */
	0,							/* U+00A7F2 */
	0,							/* U+00A7F3 */
	0,							/* U+00A7F4 */
	1383,						/* U+00A7F5 */
	1383,						/* U+00A7F6 */
	1367,						/* U+00AB53 */
	0,							/* U+00AB54 */
	0,							/* U+00AB55 */
	0,							/* U+00AB56 */
	0,							/* U+00AB57 */
	0,							/* U+00AB58 */
	0,							/* U+00AB59 */
	0,							/* U+00AB5A */
	0,							/* U+00AB5B */
	0,							/* U+00AB5C */
	0,							/* U+00AB5D */
	0,							/* U+00AB5E */
	0,							/* U+00AB5F */
	0,							/* U+00AB60 */
	0,							/* U+00AB61 */
	0,							/* U+00AB62 */
	0,							/* U+00AB63 */
	0,							/* U+00AB64 */
	0,							/* U+00AB65 */
	0,							/* U+00AB66 */
	0,							/* U+00AB67 */
	0,							/* U+00AB68 */
	0,							/* U+00AB69 */
	0,							/* U+00AB6A */
	0,							/* U+00AB6B */
	0,							/* U+00AB6C */
	0,							/* U+00AB6D */
	0,							/* U+00AB6E */
	0,							/* U+00AB6F */
	693,						/* U+00AB70 */
	694,						/* U+00AB71 */
	695,						/* U+00AB72 */
	696,						/* U+00AB73 */
	697,						/* U+00AB74 */
	698,						/* U+00AB75 */
	699,						/* U+00AB76 */
	700,						/* U+00AB77 */
	701,						/* U+00AB78 */
	702,						/* U+00AB79 */
	703,						/* U+00AB7A */
	704,						/* U+00AB7B */
	705,						/* U+00AB7C */
	706,						/* U+00AB7D */
	707,						/* U+00AB7E */
	708,						/* U+00AB7F */
	709,						/* U+00AB80 */
	710,						/* U+00AB81 */
	711,						/* U+00AB82 */
	712,						/* U+00AB83 */
	713,						/* U+00AB84 */
	714,						/* U+00AB85 */
	715,						/* U+00AB86 */
	716,						/* U+00AB87 */
	717,						/* U+00AB88 */
	718,						/* U+00AB89 */
	719,						/* U+00AB8A */
	720,						/* U+00AB8B */
	721,						/* U+00AB8C */
	722,						/* U+00AB8D */
	723,						/* U+00AB8E */
	724,						/* U+00AB8F */
	725,						/* U+00AB90 */
	726,						/* U+00AB91 */
	727,						/* U+00AB92 */
	728,						/* U+00AB93 */
	729,						/* U+00AB94 */
	730,						/* U+00AB95 */
	731,						/* U+00AB96 */
	732,						/* U+00AB97 */
	733,						/* U+00AB98 */
	734,						/* U+00AB99 */
	735,						/* U+00AB9A */
	736,						/* U+00AB9B */
	737,						/* U+00AB9C */
	738,						/* U+00AB9D */
	739,						/* U+00AB9E */
	740,						/* U+00AB9F */
	741,						/* U+00ABA0 */
	742,						/* U+00ABA1 */
	743,						/* U+00ABA2 */
	744,						/* U+00ABA3 */
	745,						/* U+00ABA4 */
	746,						/* U+00ABA5 */
	747,						/* U+00ABA6 */
	748,						/* U+00ABA7 */
	749,						/* U+00ABA8 */
	750,						/* U+00ABA9 */
	751,						/* U+00ABAA */
	752,						/* U+00ABAB */
	753,						/* U+00ABAC */
	754,						/* U+00ABAD */
	755,						/* U+00ABAE */
	756,						/* U+00ABAF */
	757,						/* U+00ABB0 */
	758,						/* U+00ABB1 */
	759,						/* U+00ABB2 */
	760,						/* U+00ABB3 */
	761,						/* U+00ABB4 */
	762,						/* U+00ABB5 */
	763,						/* U+00ABB6 */
	764,						/* U+00ABB7 */
	765,						/* U+00ABB8 */
	766,						/* U+00ABB9 */
	767,						/* U+00ABBA */
	768,						/* U+00ABBB */
	769,						/* U+00ABBC */
	770,						/* U+00ABBD */
	771,						/* U+00ABBE */
	772,						/* U+00ABBF */
	1384,						/* U+00FB00 */
	1385,						/* U+00FB01 */
	1386,						/* U+00FB02 */
	1387,						/* U+00FB03 */
	1388,						/* U+00FB04 */
	1389,						/* U+00FB05 */
	1390,						/* U+00FB06 */
	0,							/* U+00FB07 */
	0,							/* U+00FB08 */
	0,							/* U+00FB09 */
	0,							/* U+00FB0A */
	0,							/* U+00FB0B */
	0,							/* U+00FB0C */
	0,							/* U+00FB0D */
	0,							/* U+00FB0E */
	0,							/* U+00FB0F */
	0,							/* U+00FB10 */
	0,							/* U+00FB11 */
	0,							/* U+00FB12 */
	1391,						/* U+00FB13 */
	1392,						/* U+00FB14 */
	1393,						/* U+00FB15 */
	1394,						/* U+00FB16 */
	1395,						/* U+00FB17 */
	1396,						/* U+00FF21 */
	1397,						/* U+00FF22 */
	1398,						/* U+00FF23 */
	1399,						/* U+00FF24 */
	1400,						/* U+00FF25 */
	1401,						/* U+00FF26 */
	1402,						/* U+00FF27 */
	1403,						/* U+00FF28 */
	1404,						/* U+00FF29 */
	1405,						/* U+00FF2A */
	1406,						/* U+00FF2B */
	1407,						/* U+00FF2C */
	1408,						/* U+00FF2D */
	1409,						/* U+00FF2E */
	1410,						/* U+00FF2F */
	1411,						/* U+00FF30 */
	1412,						/* U+00FF31 */
	1413,						/* U+00FF32 */
	1414,						/* U+00FF33 */
	1415,						/* U+00FF34 */
	1416,						/* U+00FF35 */
	1417,						/* U+00FF36 */
	1418,						/* U+00FF37 */
	1419,						/* U+00FF38 */
	1420,						/* U+00FF39 */
	1421,						/* U+00FF3A */
	0,							/* U+00FF3B */
	0,							/* U+00FF3C */
	0,							/* U+00FF3D */
	0,							/* U+00FF3E */
	0,							/* U+00FF3F */
	0,							/* U+00FF40 */
	1396,						/* U+00FF41 */
	1397,						/* U+00FF42 */
	1398,						/* U+00FF43 */
	1399,						/* U+00FF44 */
	1400,						/* U+00FF45 */
	1401,						/* U+00FF46 */
	1402,						/* U+00FF47 */
	1403,						/* U+00FF48 */
	1404,						/* U+00FF49 */
	1405,						/* U+00FF4A */
	1406,						/* U+00FF4B */
	1407,						/* U+00FF4C */
	1408,						/* U+00FF4D */
	1409,						/* U+00FF4E */
	1410,						/* U+00FF4F */
	1411,						/* U+00FF50 */
	1412,						/* U+00FF51 */
	1413,						/* U+00FF52 */
	1414,						/* U+00FF53 */
	1415,						/* U+00FF54 */
	1416,						/* U+00FF55 */
	1417,						/* U+00FF56 */
	1418,						/* U+00FF57 */
	1419,						/* U+00FF58 */
	1420,						/* U+00FF59 */
	1421,						/* U+00FF5A */
	1422,						/* U+010400 */
	1423,						/* U+010401 */
	1424,						/* U+010402 */
	1425,						/* U+010403 */
	1426,						/* U+010404 */
	1427,						/* U+010405 */
	1428,						/* U+010406 */
	1429,						/* U+010407 */
	1430,						/* U+010408 */
	1431,						/* U+010409 */
	1432,						/* U+01040A */
	1433,						/* U+01040B */
	1434,						/* U+01040C */
	1435,						/* U+01040D */
	1436,						/* U+01040E */
	1437,						/* U+01040F */
	1438,						/* U+010410 */
	1439,						/* U+010411 */
	1440,						/* U+010412 */
	1441,						/* U+010413 */
	1442,						/* U+010414 */
	1443,						/* U+010415 */
	1444,						/* U+010416 */
	1445,						/* U+010417 */
	1446,						/* U+010418 */
	1447,						/* U+010419 */
	1448,						/* U+01041A */
	1449,						/* U+01041B */
	1450,						/* U+01041C */
	1451,						/* U+01041D */
	1452,						/* U+01041E */
	1453,						/* U+01041F */
	1454,						/* U+010420 */
	1455,						/* U+010421 */
	1456,						/* U+010422 */
	1457,						/* U+010423 */
	1458,						/* U+010424 */
	1459,						/* U+010425 */
	1460,						/* U+010426 */
	1461,						/* U+010427 */
	1422,						/* U+010428 */
	1423,						/* U+010429 */
	1424,						/* U+01042A */
	1425,						/* U+01042B */
	1426,						/* U+01042C */
	1427,						/* U+01042D */
	1428,						/* U+01042E */
	1429,						/* U+01042F */
	1430,						/* U+010430 */
	1431,						/* U+010431 */
	1432,						/* U+010432 */
	1433,						/* U+010433 */
	1434,						/* U+010434 */
	1435,						/* U+010435 */
	1436,						/* U+010436 */
	1437,						/* U+010437 */
	1438,						/* U+010438 */
	1439,						/* U+010439 */
	1440,						/* U+01043A */
	1441,						/* U+01043B */
	1442,						/* U+01043C */
	1443,						/* U+01043D */
	1444,						/* U+01043E */
	1445,						/* U+01043F */
	1446,						/* U+010440 */
	1447,						/* U+010441 */
	1448,						/* U+010442 */
	1449,						/* U+010443 */
	1450,						/* U+010444 */
	1451,						/* U+010445 */
	1452,						/* U+010446 */
	1453,						/* U+010447 */
	1454,						/* U+010448 */
	1455,						/* U+010449 */
	1456,						/* U+01044A */
	1457,						/* U+01044B */
	1458,						/* U+01044C */
	1459,						/* U+01044D */
	1460,						/* U+01044E */
	1461,						/* U+01044F */
	0,							/* U+010450 */
	0,							/* U+010451 */
	0,							/* U+010452 */
	0,							/* U+010453 */
	0,							/* U+010454 */
	0,							/* U+010455 */
	0,							/* U+010456 */
	0,							/* U+010457 */
	0,							/* U+010458 */
	0,							/* U+010459 */
	0,							/* U+01045A */
	0,							/* U+01045B */
	0,							/* U+01045C */
	0,							/* U+01045D */
	0,							/* U+01045E */
	0,							/* U+01045F */
	0,							/* U+010460 */
	0,							/* U+010461 */
	0,							/* U+010462 */
	0,							/* U+010463 */
	0,							/* U+010464 */
	0,							/* U+010465 */
	0,							/* U+010466 */
	0,							/* U+010467 */
	0,							/* U+010468 */
	0,							/* U+010469 */
	0,							/* U+01046A */
	0,							/* U+01046B */
	0,							/* U+01046C */
	0,							/* U+01046D */
	0,							/* U+01046E */
	0,							/* U+01046F */
	0,							/* U+010470 */
	0,							/* U+010471 */
	0,							/* U+010472 */
	0,							/* U+010473 */
	0,							/* U+010474 */
	0,							/* U+010475 */
	0,							/* U+010476 */
	0,							/* U+010477 */
	0,							/* U+010478 */
	0,							/* U+010479 */
	0,							/* U+01047A */
	0,							/* U+01047B */
	0,							/* U+01047C */
	0,							/* U+01047D */
	0,							/* U+01047E */
	0,							/* U+01047F */
	0,							/* U+010480 */
	0,							/* U+010481 */
	0,							/* U+010482 */
	0,							/* U+010483 */
	0,							/* U+010484 */
	0,							/* U+010485 */
	0,							/* U+010486 */
	0,							/* U+010487 */
	0,							/* U+010488 */
	0,							/* U+010489 */
	0,							/* U+01048A */
	0,							/* U+01048B */
	0,							/* U+01048C */
	0,							/* U+01048D */
	0,							/* U+01048E */
	0,							/* U+01048F */
	0,							/* U+010490 */
	0,							/* U+010491 */
	0,							/* U+010492 */
	0,							/* U+010493 */
	0,							/* U+010494 */
	0,							/* U+010495 */
	0,							/* U+010496 */
	0,							/* U+010497 */
	0,							/* U+010498 */
	0,							/* U+010499 */
	0,							/* U+01049A */
	0,							/* U+01049B */
	0,							/* U+01049C */
	0,							/* U+01049D */
	0,							/* U+01049E */
	0,							/* U+01049F */
	0,							/* U+0104A0 */
	0,							/* U+0104A1 */
	0,							/* U+0104A2 */
	0,							/* U+0104A3 */
	0,							/* U+0104A4 */
	0,							/* U+0104A5 */
	0,							/* U+0104A6 */
	0,							/* U+0104A7 */
	0,							/* U+0104A8 */
	0,							/* U+0104A9 */
	0,							/* U+0104AA */
	0,							/* U+0104AB */
	0,							/* U+0104AC */
	0,							/* U+0104AD */
	0,							/* U+0104AE */
	0,							/* U+0104AF */
	1462,						/* U+0104B0 */
	1463,						/* U+0104B1 */
	1464,						/* U+0104B2 */
	1465,						/* U+0104B3 */
	1466,						/* U+0104B4 */
	1467,						/* U+0104B5 */
	1468,						/* U+0104B6 */
	1469,						/* U+0104B7 */
	1470,						/* U+0104B8 */
	1471,						/* U+0104B9 */
	1472,						/* U+0104BA */
	1473,						/* U+0104BB */
	1474,						/* U+0104BC */
	1475,						/* U+0104BD */
	1476,						/* U+0104BE */
	1477,						/* U+0104BF */
	1478,						/* U+0104C0 */
	1479,						/* U+0104C1 */
	1480,						/* U+0104C2 */
	1481,						/* U+0104C3 */
	1482,						/* U+0104C4 */
	1483,						/* U+0104C5 */
	1484,						/* U+0104C6 */
	1485,						/* U+0104C7 */
	1486,						/* U+0104C8 */
	1487,						/* U+0104C9 */
	1488,						/* U+0104CA */
	1489,						/* U+0104CB */
	1490,						/* U+0104CC */
	1491,						/* U+0104CD */
	1492,						/* U+0104CE */
	1493,						/* U+0104CF */
	1494,						/* U+0104D0 */
	1495,						/* U+0104D1 */
	1496,						/* U+0104D2 */
	1497,						/* U+0104D3 */
	0,							/* U+0104D4 */
	0,							/* U+0104D5 */
	0,							/* U+0104D6 */
	0,							/* U+0104D7 */
	1462,						/* U+0104D8 */
	1463,						/* U+0104D9 */
	1464,						/* U+0104DA */
	1465,						/* U+0104DB */
	1466,						/* U+0104DC */
	1467,						/* U+0104DD */
	1468,						/* U+0104DE */
	1469,						/* U+0104DF */
	1470,						/* U+0104E0 */
	1471,						/* U+0104E1 */
	1472,						/* U+0104E2 */
	1473,						/* U+0104E3 */
	1474,						/* U+0104E4 */
	1475,						/* U+0104E5 */
	1476,						/* U+0104E6 */
	1477,						/* U+0104E7 */
	1478,						/* U+0104E8 */
	1479,						/* U+0104E9 */
	1480,						/* U+0104EA */
	1481,						/* U+0104EB */
	1482,						/* U+0104EC */
	1483,						/* U+0104ED */
	1484,						/* U+0104EE */
	1485,						/* U+0104EF */
	1486,						/* U+0104F0 */
	1487,						/* U+0104F1 */
	1488,						/* U+0104F2 */
	1489,						/* U+0104F3 */
	1490,						/* U+0104F4 */
	1491,						/* U+0104F5 */
	1492,						/* U+0104F6 */
	1493,						/* U+0104F7 */
	1494,						/* U+0104F8 */
	1495,						/* U+0104F9 */
	1496,						/* U+0104FA */
	1497,						/* U+0104FB */
	0,							/* U+0104FC */
	0,							/* U+0104FD */
	0,							/* U+0104FE */
	0,							/* U+0104FF */
	0,							/* U+010500 */
	0,							/* U+010501 */
	0,							/* U+010502 */
	0,							/* U+010503 */
	0,							/* U+010504 */
	0,							/* U+010505 */
	0,							/* U+010506 */
	0,							/* U+010507 */
	0,							/* U+010508 */
	0,							/* U+010509 */
	0,							/* U+01050A */
	0,							/* U+01050B */
	0,							/* U+01050C */
	0,							/* U+01050D */
	0,							/* U+01050E */
	0,							/* U+01050F */
	0,							/* U+010510 */
	0,							/* U+010511 */
	0,							/* U+010512 */
	0,							/* U+010513 */
	0,							/* U+010514 */
	0,							/* U+010515 */
	0,							/* U+010516 */
	0,							/* U+010517 */
	0,							/* U+010518 */
	0,							/* U+010519 */
	0,							/* U+01051A */
	0,							/* U+01051B */
	0,							/* U+01051C */
	0,							/* U+01051D */
	0,							/* U+01051E */
	0,							/* U+01051F */
	0,							/* U+010520 */
	0,							/* U+010521 */
	0,							/* U+010522 */
	0,							/* U+010523 */
	0,							/* U+010524 */
	0,							/* U+010525 */
	0,							/* U+010526 */
	0,							/* U+010527 */
	0,							/* U+010528 */
	0,							/* U+010529 */
	0,							/* U+01052A */
	0,							/* U+01052B */
	0,							/* U+01052C */
	0,							/* U+01052D */
	0,							/* U+01052E */
	0,							/* U+01052F */
	0,							/* U+010530 */
	0,							/* U+010531 */
	0,							/* U+010532 */
	0,							/* U+010533 */
	0,							/* U+010534 */
	0,							/* U+010535 */
	0,							/* U+010536 */
	0,							/* U+010537 */
	0,							/* U+010538 */
	0,							/* U+010539 */
	0,							/* U+01053A */
	0,							/* U+01053B */
	0,							/* U+01053C */
	0,							/* U+01053D */
	0,							/* U+01053E */
	0,							/* U+01053F */
	0,							/* U+010540 */
	0,							/* U+010541 */
	0,							/* U+010542 */
	0,							/* U+010543 */
	0,							/* U+010544 */
	0,							/* U+010545 */
	0,							/* U+010546 */
	0,							/* U+010547 */
	0,							/* U+010548 */
	0,							/* U+010549 */
	0,							/* U+01054A */
	0,							/* U+01054B */
	0,							/* U+01054C */
	0,							/* U+01054D */
	0,							/* U+01054E */
	0,							/* U+01054F */
	0,							/* U+010550 */
	0,							/* U+010551 */
	0,							/* U+010552 */
	0,							/* U+010553 */
	0,							/* U+010554 */
	0,							/* U+010555 */
	0,							/* U+010556 */
	0,							/* U+010557 */
	0,							/* U+010558 */
	0,							/* U+010559 */
	0,							/* U+01055A */
	0,							/* U+01055B */
	0,							/* U+01055C */
	0,							/* U+01055D */
	0,							/* U+01055E */
	0,							/* U+01055F */
	0,							/* U+010560 */
	0,							/* U+010561 */
	0,							/* U+010562 */
	0,							/* U+010563 */
	0,							/* U+010564 */
	0,							/* U+010565 */
	0,							/* U+010566 */
	0,							/* U+010567 */
	0,							/* U+010568 */
	0,							/* U+010569 */
	0,							/* U+01056A */
	0,							/* U+01056B */
	0,							/* U+01056C */
	0,							/* U+01056D */
	0,							/* U+01056E */
	0,							/* U+01056F */
	1498,						/* U+010570 */
	1499,						/* U+010571 */
	1500,						/* U+010572 */
	1501,						/* U+010573 */
	1502,						/* U+010574 */
	1503,						/* U+010575 */
	1504,						/* U+010576 */
	1505,						/* U+010577 */
	1506,						/* U+010578 */
	1507,						/* U+010579 */
	1508,						/* U+01057A */
	0,							/* U+01057B */
	1509,						/* U+01057C */
	1510,						/* U+01057D */
	1511,						/* U+01057E */
	1512,						/* U+01057F */
	1513,						/* U+010580 */
	1514,						/* U+010581 */
	1515,						/* U+010582 */
	1516,						/* U+010583 */
	1517,						/* U+010584 */
	1518,						/* U+010585 */
	1519,						/* U+010586 */
	1520,						/* U+010587 */
	1521,						/* U+010588 */
	1522,						/* U+010589 */
	1523,						/* U+01058A */
	0,							/* U+01058B */
	1524,						/* U+01058C */
	1525,						/* U+01058D */
	1526,						/* U+01058E */
	1527,						/* U+01058F */
	1528,						/* U+010590 */
	1529,						/* U+010591 */
	1530,						/* U+010592 */
	0,							/* U+010593 */
	1531,						/* U+010594 */
	1532,						/* U+010595 */
	0,							/* U+010596 */
	1498,						/* U+010597 */
	1499,						/* U+010598 */
	1500,						/* U+010599 */
	1501,						/* U+01059A */
	1502,						/* U+01059B */
	1503,						/* U+01059C */
	1504,						/* U+01059D */
	1505,						/* U+01059E */
	1506,						/* U+01059F */
	1507,						/* U+0105A0 */
	1508,						/* U+0105A1 */
	0,							/* U+0105A2 */
	1509,						/* U+0105A3 */
	1510,						/* U+0105A4 */
	1511,						/* U+0105A5 */
	1512,						/* U+0105A6 */
	1513,						/* U+0105A7 */
	1514,						/* U+0105A8 */
	1515,						/* U+0105A9 */
	1516,						/* U+0105AA */
	1517,						/* U+0105AB */
	1518,						/* U+0105AC */
	1519,						/* U+0105AD */
	1520,						/* U+0105AE */
	1521,						/* U+0105AF */
	1522,						/* U+0105B0 */
	1523,						/* U+0105B1 */
	0,							/* U+0105B2 */
	1524,						/* U+0105B3 */
	1525,						/* U+0105B4 */
	1526,						/* U+0105B5 */
	1527,						/* U+0105B6 */
	1528,						/* U+0105B7 */
	1529,						/* U+0105B8 */
	1530,						/* U+0105B9 */
	0,							/* U+0105BA */
	1531,						/* U+0105BB */
	1532,						/* U+0105BC */
	1533,						/* U+010C80 */
	1534,						/* U+010C81 */
	1535,						/* U+010C82 */
	1536,						/* U+010C83 */
	1537,						/* U+010C84 */
	1538,						/* U+010C85 */
	1539,						/* U+010C86 */
	1540,						/* U+010C87 */
	1541,						/* U+010C88 */
	1542,						/* U+010C89 */
	1543,						/* U+010C8A */
	1544,						/* U+010C8B */
	1545,						/* U+010C8C */
	1546,						/* U+010C8D */
	1547,						/* U+010C8E */
	1548,						/* U+010C8F */
	1549,						/* U+010C90 */
	1550,						/* U+010C91 */
	1551,						/* U+010C92 */
	1552,						/* U+010C93 */
	1553,						/* U+010C94 */
	1554,						/* U+010C95 */
	1555,						/* U+010C96 */
	1556,						/* U+010C97 */
	1557,						/* U+010C98 */
	1558,						/* U+010C99 */
	1559,						/* U+010C9A */
	1560,						/* U+010C9B */
	1561,						/* U+010C9C */
	1562,						/* U+010C9D */
	1563,						/* U+010C9E */
	1564,						/* U+010C9F */
	1565,						/* U+010CA0 */
	1566,						/* U+010CA1 */
	1567,						/* U+010CA2 */
	1568,						/* U+010CA3 */
	1569,						/* U+010CA4 */
	1570,						/* U+010CA5 */
	1571,						/* U+010CA6 */
	1572,						/* U+010CA7 */
	1573,						/* U+010CA8 */
	1574,						/* U+010CA9 */
	1575,						/* U+010CAA */
	1576,						/* U+010CAB */
	1577,						/* U+010CAC */
	1578,						/* U+010CAD */
	1579,						/* U+010CAE */
	1580,						/* U+010CAF */
	1581,						/* U+010CB0 */
	1582,						/* U+010CB1 */
	1583,						/* U+010CB2 */
	0,							/* U+010CB3 */
	0,							/* U+010CB4 */
	0,							/* U+010CB5 */
	0,							/* U+010CB6 */
	0,							/* U+010CB7 */
	0,							/* U+010CB8 */
	0,							/* U+010CB9 */
	0,							/* U+010CBA */
	0,							/* U+010CBB */
	0,							/* U+010CBC */
	0,							/* U+010CBD */
	0,							/* U+010CBE */
	0,							/* U+010CBF */
	1533,						/* U+010CC0 */
	1534,						/* U+010CC1 */
	1535,						/* U+010CC2 */
	1536,						/* U+010CC3 */
	1537,						/* U+010CC4 */
	1538,						/* U+010CC5 */
	1539,						/* U+010CC6 */
	1540,						/* U+010CC7 */
	1541,						/* U+010CC8 */
	1542,						/* U+010CC9 */
	1543,						/* U+010CCA */
	1544,						/* U+010CCB */
	1545,						/* U+010CCC */
	1546,						/* U+010CCD */
	1547,						/* U+010CCE */
	1548,						/* U+010CCF */
	1549,						/* U+010CD0 */
	1550,						/* U+010CD1 */
	1551,						/* U+010CD2 */
	1552,						/* U+010CD3 */
	1553,						/* U+010CD4 */
	1554,						/* U+010CD5 */
	1555,						/* U+010CD6 */
	1556,						/* U+010CD7 */
	1557,						/* U+010CD8 */
	1558,						/* U+010CD9 */
	1559,						/* U+010CDA */
	1560,						/* U+010CDB */
	1561,						/* U+010CDC */
	1562,						/* U+010CDD */
	1563,						/* U+010CDE */
	1564,						/* U+010CDF */
	1565,						/* U+010CE0 */
	1566,						/* U+010CE1 */
	1567,						/* U+010CE2 */
	1568,						/* U+010CE3 */
	1569,						/* U+010CE4 */
	1570,						/* U+010CE5 */
	1571,						/* U+010CE6 */
	1572,						/* U+010CE7 */
	1573,						/* U+010CE8 */
	1574,						/* U+010CE9 */
	1575,						/* U+010CEA */
	1576,						/* U+010CEB */
	1577,						/* U+010CEC */
	1578,						/* U+010CED */
	1579,						/* U+010CEE */
	1580,						/* U+010CEF */
	1581,						/* U+010CF0 */
	1582,						/* U+010CF1 */
	1583,						/* U+010CF2 */
	0,							/* U+010CF3 */
	0,							/* U+010CF4 */
	0,							/* U+010CF5 */
	0,							/* U+010CF6 */
	0,							/* U+010CF7 */
	0,							/* U+010CF8 */
	0,							/* U+010CF9 */
	0,							/* U+010CFA */
	0,							/* U+010CFB */
	0,							/* U+010CFC */
	0,							/* U+010CFD */
	0,							/* U+010CFE */
	0,							/* U+010CFF */
	0,							/* U+010D00 */
	0,							/* U+010D01 */
	0,							/* U+010D02 */
	0,							/* U+010D03 */
	0,							/* U+010D04 */
	0,							/* U+010D05 */
	0,							/* U+010D06 */
	0,							/* U+010D07 */
	0,							/* U+010D08 */
	0,							/* U+010D09 */
	0,							/* U+010D0A */
	0,							/* U+010D0B */
	0,							/* U+010D0C */
	0,							/* U+010D0D */
	0,							/* U+010D0E */
	0,							/* U+010D0F */
	0,							/* U+010D10 */
	0,							/* U+010D11 */
	0,							/* U+010D12 */
	0,							/* U+010D13 */
	0,							/* U+010D14 */
	0,							/* U+010D15 */
	0,							/* U+010D16 */
	0,							/* U+010D17 */
	0,							/* U+010D18 */
	0,							/* U+010D19 */
	0,							/* U+010D1A */
	0,							/* U+010D1B */
	0,							/* U+010D1C */
	0,							/* U+010D1D */
	0,							/* U+010D1E */
	0,							/* U+010D1F */
	0,							/* U+010D20 */
	0,							/* U+010D21 */
	0,							/* U+010D22 */
	0,							/* U+010D23 */
	0,							/* U+010D24 */
	0,							/* U+010D25 */
	0,							/* U+010D26 */
	0,							/* U+010D27 */
	0,							/* U+010D28 */
	0,							/* U+010D29 */
	0,							/* U+010D2A */
	0,							/* U+010D2B */
	0,							/* U+010D2C */
	0,							/* U+010D2D */
	0,							/* U+010D2E */
	0,							/* U+010D2F */
	0,							/* U+010D30 */
	0,							/* U+010D31 */
	0,							/* U+010D32 */
	0,							/* U+010D33 */
	0,							/* U+010D34 */
	0,							/* U+010D35 */
	0,							/* U+010D36 */
	0,							/* U+010D37 */
	0,							/* U+010D38 */
	0,							/* U+010D39 */
	0,							/* U+010D3A */
	0,							/* U+010D3B */
	0,							/* U+010D3C */
	0,							/* U+010D3D */
	0,							/* U+010D3E */
	0,							/* U+010D3F */
	0,							/* U+010D40 */
	0,							/* U+010D41 */
	0,							/* U+010D42 */
	0,							/* U+010D43 */
	0,							/* U+010D44 */
	0,							/* U+010D45 */
	0,							/* U+010D46 */
	0,							/* U+010D47 */
	0,							/* U+010D48 */
	0,							/* U+010D49 */
	0,							/* U+010D4A */
	0,							/* U+010D4B */
	0,							/* U+010D4C */
	0,							/* U+010D4D */
	0,							/* U+010D4E */
	0,							/* U+010D4F */
	1584,						/* U+010D50 */
	1585,						/* U+010D51 */
	1586,						/* U+010D52 */
	1587,						/* U+010D53 */
	1588,						/* U+010D54 */
	1589,						/* U+010D55 */
	1590,						/* U+010D56 */
	1591,						/* U+010D57 */
	1592,						/* U+010D58 */
	1593,						/* U+010D59 */
	1594,						/* U+010D5A */
	1595,						/* U+010D5B */
	1596,						/* U+010D5C */
	1597,						/* U+010D5D */
	1598,						/* U+010D5E */
	1599,						/* U+010D5F */
	1600,						/* U+010D60 */
	1601,						/* U+010D61 */
	1602,						/* U+010D62 */
	1603,						/* U+010D63 */
	1604,						/* U+010D64 */
	1605,						/* U+010D65 */
	0,							/* U+010D66 */
	0,							/* U+010D67 */
	0,							/* U+010D68 */
	0,							/* U+010D69 */
	0,							/* U+010D6A */
	0,							/* U+010D6B */
	0,							/* U+010D6C */
	0,							/* U+010D6D */
	0,							/* U+010D6E */
	0,							/* U+010D6F */
	1584,						/* U+010D70 */
	1585,						/* U+010D71 */
	1586,						/* U+010D72 */
	1587,						/* U+010D73 */
	1588,						/* U+010D74 */
	1589,						/* U+010D75 */
	1590,						/* U+010D76 */
	1591,						/* U+010D77 */
	1592,						/* U+010D78 */
	1593,						/* U+010D79 */
	1594,						/* U+010D7A */
	1595,						/* U+010D7B */
	1596,						/* U+010D7C */
	1597,						/* U+010D7D */
	1598,						/* U+010D7E */
	1599,						/* U+010D7F */
	1600,						/* U+010D80 */
	1601,						/* U+010D81 */
	1602,						/* U+010D82 */
	1603,						/* U+010D83 */
	1604,						/* U+010D84 */
	1605,						/* U+010D85 */
	1606,						/* U+0118A0 */
	1607,						/* U+0118A1 */
	1608,						/* U+0118A2 */
	1609,						/* U+0118A3 */
	1610,						/* U+0118A4 */
	1611,						/* U+0118A5 */
	1612,						/* U+0118A6 */
	1613,						/* U+0118A7 */
	1614,						/* U+0118A8 */
	1615,						/* U+0118A9 */
	1616,						/* U+0118AA */
	1617,						/* U+0118AB */
	1618,						/* U+0118AC */
	1619,						/* U+0118AD */
	1620,						/* U+0118AE */
	1621,						/* U+0118AF */
	1622,						/* U+0118B0 */
	1623,						/* U+0118B1 */
	1624,						/* U+0118B2 */
	1625,						/* U+0118B3 */
	1626,						/* U+0118B4 */
	1627,						/* U+0118B5 */
	1628,						/* U+0118B6 */
	1629,						/* U+0118B7 */
	1630,						/* U+0118B8 */
	1631,						/* U+0118B9 */
	1632,						/* U+0118BA */
	1633,						/* U+0118BB */
	1634,						/* U+0118BC */
	1635,						/* U+0118BD */
	1636,						/* U+0118BE */
	1637,						/* U+0118BF */
	1606,						/* U+0118C0 */
	1607,						/* U+0118C1 */
	1608,						/* U+0118C2 */
	1609,						/* U+0118C3 */
	1610,						/* U+0118C4 */
	1611,						/* U+0118C5 */
	1612,						/* U+0118C6 */
	1613,						/* U+0118C7 */
	1614,						/* U+0118C8 */
	1615,						/* U+0118C9 */
	1616,						/* U+0118CA */
	1617,						/* U+0118CB */
	1618,						/* U+0118CC */
	1619,						/* U+0118CD */
	1620,						/* U+0118CE */
	1621,						/* U+0118CF */
	1622,						/* U+0118D0 */
	1623,						/* U+0118D1 */
	1624,						/* U+0118D2 */
	1625,						/* U+0118D3 */
	1626,						/* U+0118D4 */
	1627,						/* U+0118D5 */
	1628,						/* U+0118D6 */
	1629,						/* U+0118D7 */
	1630,						/* U+0118D8 */
	1631,						/* U+0118D9 */
	1632,						/* U+0118DA */
	1633,						/* U+0118DB */
	1634,						/* U+0118DC */
	1635,						/* U+0118DD */
	1636,						/* U+0118DE */
	1637,						/* U+0118DF */
	1638,						/* U+016E40 */
	1639,						/* U+016E41 */
	1640,						/* U+016E42 */
	1641,						/* U+016E43 */
	1642,						/* U+016E44 */
	1643,						/* U+016E45 */
	1644,						/* U+016E46 */
	1645,						/* U+016E47 */
	1646,						/* U+016E48 */
	1647,						/* U+016E49 */
	1648,						/* U+016E4A */
	1649,						/* U+016E4B */
	1650,						/* U+016E4C */
	1651,						/* U+016E4D */
	1652,						/* U+016E4E */
	1653,						/* U+016E4F */
	1654,						/* U+016E50 */
	1655,						/* U+016E51 */
	1656,						/* U+016E52 */
	1657,						/* U+016E53 */
	1658,						/* U+016E54 */
	1659,						/* U+016E55 */
	1660,						/* U+016E56 */
	1661,						/* U+016E57 */
	1662,						/* U+016E58 */
	1663,						/* U+016E59 */
	1664,						/* U+016E5A */
	1665,						/* U+016E5B */
	1666,						/* U+016E5C */
	1667,						/* U+016E5D */
	1668,						/* U+016E5E */
	1669,						/* U+016E5F */
	1638,						/* U+016E60 */
	1639,						/* U+016E61 */
	1640,						/* U+016E62 */
	1641,						/* U+016E63 */
	1642,						/* U+016E64 */
	1643,						/* U+016E65 */
	1644,						/* U+016E66 */
	1645,						/* U+016E67 */
	1646,						/* U+016E68 */
	1647,						/* U+016E69 */
	1648,						/* U+016E6A */
	1649,						/* U+016E6B */
	1650,						/* U+016E6C */
	1651,						/* U+016E6D */
	1652,						/* U+016E6E */
	1653,						/* U+016E6F */
	1654,						/* U+016E70 */
	1655,						/* U+016E71 */
	1656,						/* U+016E72 */
	1657,						/* U+016E73 */
	1658,						/* U+016E74 */
	1659,						/* U+016E75 */
	1660,						/* U+016E76 */
	1661,						/* U+016E77 */
	1662,						/* U+016E78 */
	1663,						/* U+016E79 */
	1664,						/* U+016E7A */
	1665,						/* U+016E7B */
	1666,						/* U+016E7C */
	1667,						/* U+016E7D */
	1668,						/* U+016E7E */
	1669,						/* U+016E7F */
	1670,						/* U+01E900 */
	1671,						/* U+01E901 */
	1672,						/* U+01E902 */
	1673,						/* U+01E903 */
	1674,						/* U+01E904 */
	1675,						/* U+01E905 */
	1676,						/* U+01E906 */
	1677,						/* U+01E907 */
	1678,						/* U+01E908 */
	1679,						/* U+01E909 */
	1680,						/* U+01E90A */
	1681,						/* U+01E90B */
	1682,						/* U+01E90C */
	1683,						/* U+01E90D */
	1684,						/* U+01E90E */
	1685,						/* U+01E90F */
	1686,						/* U+01E910 */
	1687,						/* U+01E911 */
	1688,						/* U+01E912 */
	1689,						/* U+01E913 */
	1690,						/* U+01E914 */
	1691,						/* U+01E915 */
	1692,						/* U+01E916 */
	1693,						/* U+01E917 */
	1694,						/* U+01E918 */
	1695,						/* U+01E919 */
	1696,						/* U+01E91A */
	1697,						/* U+01E91B */
	1698,						/* U+01E91C */
	1699,						/* U+01E91D */
	1700,						/* U+01E91E */
	1701,						/* U+01E91F */
	1702,						/* U+01E920 */
	1703,						/* U+01E921 */
	1670,						/* U+01E922 */
	1671,						/* U+01E923 */
	1672,						/* U+01E924 */
	1673,						/* U+01E925 */
	1674,						/* U+01E926 */
	1675,						/* U+01E927 */
	1676,						/* U+01E928 */
	1677,						/* U+01E929 */
	1678,						/* U+01E92A */
	1679,						/* U+01E92B */
	1680,						/* U+01E92C */
	1681,						/* U+01E92D */
	1682,						/* U+01E92E */
	1683,						/* U+01E92F */
	1684,						/* U+01E930 */
	1685,						/* U+01E931 */
	1686,						/* U+01E932 */
	1687,						/* U+01E933 */
	1688,						/* U+01E934 */
	1689,						/* U+01E935 */
	1690,						/* U+01E936 */
	1691,						/* U+01E937 */
	1692,						/* U+01E938 */
	1693,						/* U+01E939 */
	1694,						/* U+01E93A */
	1695,						/* U+01E93B */
	1696,						/* U+01E93C */
	1697,						/* U+01E93D */
	1698,						/* U+01E93E */
	1699,						/* U+01E93F */
	1700,						/* U+01E940 */
	1701,						/* U+01E941 */
	1702,						/* U+01E942 */
	1703,						/* U+01E943 */
};


/*
 * case_index()
 *
 * Given a code point, compute the index in the case_map at which we can find
 * the offset into the mapping tables.
 */
static inline uint16
case_index(pg_wchar cp)
{
	/* Fast path for codepoints < 0x0588 */
	if (cp < 0x0588)
	{
		return case_map[cp];
	}

	if (cp < 0xABC0)
	{
		if (cp < 0x2185)
		{
			if (cp >= 0x10A0 && cp < 0x1100)
			{
				return case_map[cp - 0x10A0 + 1416];
			}
			else if (cp >= 0x13A0)
			{
				if (cp < 0x13FE)
				{
					return case_map[cp - 0x13A0 + 1512];
				}
				else if (cp >= 0x1C80)
				{
					return case_map[cp - 0x1C80 + 1606];
				}
			}
		}
		else if (cp >= 0x24B6)
		{
			if (cp < 0x2D2E)
			{
				if (cp < 0x24EA)
				{
					return case_map[cp - 0x24B6 + 2891];
				}
				else if (cp >= 0x2C00)
				{
					return case_map[cp - 0x2C00 + 2943];
				}
			}
			else if (cp >= 0xA640)
			{
				if (cp < 0xA7F7)
				{
					return case_map[cp - 0xA640 + 3245];
				}
				else if (cp >= 0xAB53)
				{
					return case_map[cp - 0xAB53 + 3684];
				}
			}
		}
	}
	else if (cp >= 0xFB00)
	{
		if (cp < 0x10D86)
		{
			if (cp < 0xFF5B)
			{
				if (cp < 0xFB18)
				{
					return case_map[cp - 0xFB00 + 3793];
				}
				else if (cp >= 0xFF21)
				{
					return case_map[cp - 0xFF21 + 3817];
				}
			}
			else if (cp >= 0x10400)
			{
				if (cp < 0x105BD)
				{
					return case_map[cp - 0x10400 + 3875];
				}
				else if (cp >= 0x10C80)
				{
					return case_map[cp - 0x10C80 + 4320];
				}
			}
		}
		else if (cp >= 0x118A0)
		{
			if (cp < 0x16E80)
			{
				if (cp < 0x118E0)
				{
					return case_map[cp - 0x118A0 + 4582];
				}
				else if (cp >= 0x16E40)
				{
					return case_map[cp - 0x16E40 + 4646];
				}
			}
			else if (cp >= 0x1E900)
			{
				if (cp < 0x1E944)
				{
					return case_map[cp - 0x1E900 + 4710];
				}
			}
		}
	}

	return 0;
}
