/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.vocab;

import com.adobe.epubcheck.vocab.Property;
import com.adobe.epubcheck.vocab.Vocab;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class AggregateVocab
implements Vocab {
    private final List<Vocab> vocabs;
    private final String uri;

    public static Vocab of(Vocab ... vocabs) {
        return new AggregateVocab((List<Vocab>)new ImmutableList.Builder().add((Object[])vocabs).build());
    }

    private AggregateVocab(List<Vocab> vocabs) {
        this.uri = !vocabs.isEmpty() ? Strings.nullToEmpty((String)vocabs.get(0).getURI()) : "";
        for (Vocab vocab : vocabs) {
            if (this.uri.equals(Strings.nullToEmpty((String)vocab.getURI()))) continue;
            throw new IllegalArgumentException("Aggregated vocabs must share the same base URI");
        }
        this.vocabs = vocabs;
    }

    @Override
    public Optional<Property> lookup(String name) {
        for (Vocab vocab : this.vocabs) {
            Optional<Property> found = vocab.lookup(name);
            if (!found.isPresent()) continue;
            return found;
        }
        return Optional.absent();
    }

    @Override
    public String getURI() {
        return this.uri;
    }
}

