/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.components.table;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class CustomSortableHeaderRenderer
implements TableCellRenderer {
    private ImageIcon ascIcon;
    private ImageIcon descIcon;
    private boolean sortOrder = false;
    private int pressedColumn = -1;
    private int sortingColumn = -1;

    public CustomSortableHeaderRenderer(ImageIcon asc, ImageIcon desc) {
        this.ascIcon = asc;
        this.descIcon = desc;
    }

    public void setPressedColumn(int column) {
        this.pressedColumn = column;
    }

    public int getPressedColumn() {
        return this.pressedColumn;
    }

    public void setSortingColumn(int column) {
        this.sortingColumn = column;
    }

    public int getSortingColumn() {
        return this.sortingColumn;
    }

    public void setSortingOrder(boolean order) {
        this.sortOrder = order;
    }

    public boolean getSortingOrder() {
        return this.sortOrder;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableCellRenderer tableCellRenderer = table.getTableHeader().getDefaultRenderer();
        Component c = tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (c instanceof JLabel) {
            JLabel l = (JLabel)c;
            if (column == this.sortingColumn) {
                l.setIcon(this.sortOrder ? this.ascIcon : this.descIcon);
                l.setFont(l.getFont().deriveFont(1));
            } else {
                l.setIcon(null);
            }
            l.setHorizontalTextPosition(2);
        }
        return c;
    }

    public void reverseSortingOrder() {
        this.sortOrder = !this.sortOrder;
    }
}

