/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.util.ServerNames;

public final class ServerNameExtension
extends HelloExtension {
    private static ServerNameExtension EMPTY_SERVER_NAMES = new ServerNameExtension(null);
    private final ServerNames serverNames;

    private ServerNameExtension(ServerNames serverNames) {
        super(HelloExtension.ExtensionType.SERVER_NAME);
        this.serverNames = serverNames;
    }

    public static ServerNameExtension emptyServerNameIndication() {
        return EMPTY_SERVER_NAMES;
    }

    public static ServerNameExtension forServerNames(ServerNames serverNames) {
        if (serverNames == null) {
            throw new NullPointerException("server names must not be null");
        }
        if (serverNames.size() == 0) {
            throw new IllegalArgumentException("server names must not be empty");
        }
        return new ServerNameExtension(serverNames);
    }

    public ServerNames getServerNames() {
        return this.serverNames;
    }

    @Override
    public String toString(int indent) {
        String text = super.toString(indent);
        if (this.serverNames != null) {
            text = text + this.serverNames.toString(indent + 1) + StringUtil.lineSeparator();
        }
        return text;
    }

    @Override
    protected int getExtensionLength() {
        if (this.serverNames != null) {
            return this.serverNames.getLength();
        }
        return 0;
    }

    @Override
    protected void writeExtensionTo(DatagramWriter writer) {
        if (this.serverNames != null) {
            this.serverNames.encode(writer);
        }
    }

    public static ServerNameExtension fromExtensionDataReader(DatagramReader extensionDataReader) throws HandshakeException {
        if (!extensionDataReader.bytesAvailable()) {
            return ServerNameExtension.emptyServerNameIndication();
        }
        ServerNames serverNames = ServerNames.newInstance();
        try {
            serverNames.decode(extensionDataReader);
        }
        catch (IllegalArgumentException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                throw new HandshakeException("Server Name Indication extension contains unknown name_type", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
            }
            throw new HandshakeException("malformed Server Name Indication extension", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.DECODE_ERROR));
        }
        return new ServerNameExtension(serverNames);
    }
}

