/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.elements.EndpointContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointContextTracer
extends MessageObserverAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointContextTracer.class);
    private final AtomicReference<EndpointContext> endpointContext = new AtomicReference();

    @Override
    public void onContextEstablished(EndpointContext endpointContext) {
        if (this.endpointContext.compareAndSet(null, endpointContext)) {
            this.onContextChanged(endpointContext);
        }
    }

    public EndpointContext getCurrentContext() {
        return this.endpointContext.get();
    }

    protected void onContextChanged(EndpointContext endpointContext) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("{}", (Object)Utils.prettyPrint(endpointContext));
        }
    }
}

