/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import io.opentelemetry.semconv.UrlAttributes;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class DropTargetsSampler
implements Sampler {
    private final Sampler sampler;
    private final Set<String> dropTargetsExact;
    private final Set<String> dropTargetsWildcard;

    public DropTargetsSampler(Sampler sampler, Set<String> dropTargets) {
        this.sampler = sampler;
        this.dropTargetsExact = dropTargets.stream().filter(s -> !s.endsWith("*")).collect(Collectors.toCollection(HashSet::new));
        this.dropTargetsWildcard = dropTargets.stream().filter(s -> s.endsWith("*")).map(s -> s.substring(0, s.length() - 1)).collect(Collectors.toCollection(HashSet::new));
    }

    public SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        if (spanKind.equals((Object)SpanKind.SERVER)) {
            String query = (String)attributes.get(UrlAttributes.URL_QUERY);
            String target = (String)attributes.get(UrlAttributes.URL_PATH) + (String)(query == null ? "" : "?" + query);
            if (this.shouldDrop(target)) {
                return SamplingResult.drop();
            }
        }
        return this.sampler.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
    }

    private boolean shouldDrop(String target) {
        if (target == null || target.isEmpty()) {
            return false;
        }
        if (this.containsExactly(target)) {
            return true;
        }
        if (target.charAt(target.length() - 1) == '/' && this.containsExactly(target.substring(0, target.length() - 1))) {
            return true;
        }
        for (String dropTargetsWildcard : this.dropTargetsWildcard) {
            if (!target.startsWith(dropTargetsWildcard)) continue;
            return true;
        }
        return false;
    }

    private boolean containsExactly(String target) {
        return this.dropTargetsExact.contains(target);
    }

    public String getDescription() {
        return this.sampler.getDescription();
    }
}

