/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Paint;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java2d.AnimatingControlsSurface;
import java2d.CustomControls;
import javax.swing.JComboBox;

public class GradAnim
extends AnimatingControlsSurface {
    private static final int BASIC_GRADIENT = 0;
    private static final int LINEAR_GRADIENT = 1;
    private static final int RADIAL_GRADIENT = 2;
    private static final int FOCUS_GRADIENT = 3;
    private static final int MAX_HUE = 1536;
    private animval x1;
    private animval y1;
    private animval x2;
    private animval y2;
    private int hue = (int)(Math.random() * 1536.0);
    private int gradientType;

    public GradAnim() {
        this.setBackground(Color.white);
        this.setControls(new Component[]{new DemoControls(this)});
        this.x1 = new animval(this, 0, 300, 2, 10);
        this.y1 = new animval(this, 0, 300, 2, 10);
        this.x2 = new animval(this, 0, 300, 2, 10);
        this.y2 = new animval(this, 0, 300, 2, 10);
        this.gradientType = 0;
    }

    @Override
    public void reset(int w, int h) {
        this.x1.newlimits(0, w);
        this.y1.newlimits(0, h);
        this.x2.newlimits(0, w);
        this.y2.newlimits(0, h);
    }

    @Override
    public void step(int w, int h) {
        this.x1.anim();
        this.y1.anim();
        this.x2.anim();
        this.y2.anim();
        this.hue = (this.hue + (int)(Math.random() * 10.0)) % 1536;
    }

    public static Color getColor(int hue) {
        int leg = hue / 256 % 6;
        int step = hue % 256 * 2;
        int falling = step < 256 ? 255 : 511 - step;
        int rising = step < 256 ? step : 255;
        int b = 0;
        int g = 0;
        int r = 0;
        switch (leg) {
            case 0: {
                r = 255;
                break;
            }
            case 1: {
                r = falling;
                g = rising;
                break;
            }
            case 2: {
                g = 255;
                break;
            }
            case 3: {
                g = falling;
                b = rising;
                break;
            }
            case 4: {
                b = 255;
                break;
            }
            case 5: {
                b = falling;
                r = rising;
            }
        }
        return new Color(r, g, b);
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        float fx1 = this.x1.getFlt();
        float fy1 = this.y1.getFlt();
        float fx2 = this.x2.getFlt();
        float fy2 = this.y2.getFlt();
        if (fx1 == fx2 && fy1 == fy2) {
            fx2 += 1.0f;
            fy2 += 1.0f;
        }
        Color c1 = GradAnim.getColor(this.hue);
        Color c2 = GradAnim.getColor(this.hue + 768);
        g2.setPaint(switch (this.gradientType) {
            default -> new GradientPaint(fx1, fy1, c1, fx2, fy2, c2, true);
            case 1 -> {
                float[] fractions = new float[]{0.0f, 0.2f, 1.0f};
                Color c3 = GradAnim.getColor(this.hue + 512);
                Color[] colors = new Color[]{c1, c2, c3};
                yield new LinearGradientPaint(fx1, fy1, fx2, fy2, fractions, colors, MultipleGradientPaint.CycleMethod.REFLECT);
            }
            case 2 -> {
                float[] fractions = new float[]{0.0f, 0.2f, 0.8f, 1.0f};
                Color c3 = GradAnim.getColor(this.hue + 512);
                Color c4 = GradAnim.getColor(this.hue + 1024);
                Color[] colors = new Color[]{c1, c2, c3, c4};
                float radius = (float)Point2D.distance(fx1, fy1, fx2, fy2);
                yield new RadialGradientPaint(fx1, fy1, radius, fractions, colors, MultipleGradientPaint.CycleMethod.REFLECT);
            }
            case 3 -> {
                float[] fractions = new float[]{0.0f, 0.2f, 0.8f, 1.0f};
                Color c3 = GradAnim.getColor(this.hue + 1024);
                Color c4 = GradAnim.getColor(this.hue + 512);
                Color[] colors = new Color[]{c1, c2, c3, c4};
                float radius = (float)Point2D.distance(fx1, fy1, fx2, fy2);
                float max = Math.max(w, h);
                radius = max * (radius / max * 0.9f + 0.1f);
                yield new RadialGradientPaint(fx2, fy2, radius, fx1, fy1, fractions, colors, MultipleGradientPaint.CycleMethod.REPEAT);
            }
        });
        g2.fillRect(0, 0, w, h);
        g2.setColor(Color.yellow);
        g2.drawLine(this.x1.getInt(), this.y1.getInt(), this.x2.getInt(), this.y2.getInt());
    }

    public static void main(String[] argv) {
        GradAnim.createDemoFrame(new GradAnim());
    }

    class DemoControls
    extends CustomControls
    implements ActionListener {
        GradAnim demo;
        JComboBox<String> combo;

        public DemoControls(GradAnim demo) {
            super(demo.name);
            this.demo = demo;
            this.combo = new JComboBox();
            this.combo.addActionListener(this);
            this.combo.addItem("2-color GradientPaint");
            this.combo.addItem("3-color LinearGradientPaint");
            this.combo.addItem("4-color RadialGradientPaint");
            this.combo.addItem("4-color RadialGradientPaint with focus");
            this.combo.setSelectedIndex(0);
            this.add(this.combo);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = this.combo.getSelectedIndex();
            if (index >= 0) {
                this.demo.gradientType = index;
            }
            if (!this.demo.animating.running()) {
                this.demo.repaint();
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(200, 41);
        }

        @Override
        public void run() {
            Thread me = Thread.currentThread();
            while (this.thread == me) {
                for (int i = 0; i < this.combo.getItemCount(); ++i) {
                    this.combo.setSelectedIndex(i);
                    try {
                        Thread.sleep(4444L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
            this.thread = null;
        }
    }

    public final class animval {
        float curval;
        float lowval;
        float highval;
        float currate;
        float lowrate;
        float highrate;

        public animval(GradAnim this$0, int lowval, int highval, int lowrate, int highrate) {
            this.lowval = lowval;
            this.highval = highval;
            this.lowrate = lowrate;
            this.highrate = highrate;
            this.curval = this.randval(lowval, highval);
            this.currate = this.randval(lowrate, highrate);
        }

        public float randval(float low, float high) {
            return (float)((double)low + Math.random() * (double)(high - low));
        }

        public float getFlt() {
            return this.curval;
        }

        public int getInt() {
            return (int)this.curval;
        }

        public void anim() {
            this.curval += this.currate;
            this.clip();
        }

        public void clip() {
            if (this.curval > this.highval) {
                this.curval = this.highval - (this.curval - this.highval);
                if (this.curval < this.lowval) {
                    this.curval = this.highval;
                }
                this.currate = -this.randval(this.lowrate, this.highrate);
            } else if (this.curval < this.lowval) {
                this.curval = this.lowval + (this.lowval - this.curval);
                if (this.curval > this.highval) {
                    this.curval = this.lowval;
                }
                this.currate = this.randval(this.lowrate, this.highrate);
            }
        }

        public void newlimits(int lowval, int highval) {
            this.lowval = lowval;
            this.highval = highval;
            this.clip();
        }
    }
}

