/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import sun.jvm.hotspot.oops.CounterData;
import sun.jvm.hotspot.oops.DataLayout;
import sun.jvm.hotspot.oops.MethodData;

public class RetData
extends CounterData {
    static final int bci0Offset = 1;
    static final int count0Offset = 2;
    static final int displacement0Offset = 3;
    static final int retRowCellCount = 3;
    static final int noBci = -1;

    public RetData(DataLayout layout) {
        super(layout);
    }

    static int staticCellCount() {
        return 1 + MethodData.BciProfileWidth * 3;
    }

    @Override
    public int cellCount() {
        return RetData.staticCellCount();
    }

    static int rowLimit() {
        return MethodData.BciProfileWidth;
    }

    static int bciCellIndex(int row) {
        return 1 + row * 3;
    }

    static int bciCountCellIndex(int row) {
        return 2 + row * 3;
    }

    static int bciDisplacementCellIndex(int row) {
        return 3 + row * 3;
    }

    int bci(int row) {
        return this.intAt(RetData.bciCellIndex(row));
    }

    int bciCount(int row) {
        return this.uintAt(RetData.bciCountCellIndex(row));
    }

    int bciDisplacement(int row) {
        return this.intAt(RetData.bciDisplacementCellIndex(row));
    }

    static int bciOffset(int row) {
        return RetData.cellOffset(RetData.bciCellIndex(row));
    }

    static int bciCountOffset(int row) {
        return RetData.cellOffset(RetData.bciCountCellIndex(row));
    }

    static int bciDisplacementOffset(int row) {
        return RetData.cellOffset(RetData.bciDisplacementCellIndex(row));
    }

    @Override
    public void printDataOn(PrintStream st) {
        int row;
        this.printShared(st, "RetData");
        int entries = 0;
        for (row = 0; row < RetData.rowLimit(); ++row) {
            if (this.bci(row) == -1) continue;
            ++entries;
        }
        st.println("count(" + this.count() + ") entries(" + entries + ")");
        for (row = 0; row < RetData.rowLimit(); ++row) {
            if (this.bci(row) == -1) continue;
            this.tab(st);
            st.println(" bci(" + this.bci(row) + ": count(" + this.bciCount(row) + ") displacement(" + this.bciDisplacement(row) + "))");
        }
    }
}

