/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.jrrd;

import org.rrd4j.core.jrrd.RRDFile;
import org.rrd4j.core.jrrd.UnivalArray;

public class PDPStatusBlock {
    private final long offset;
    private final long size;
    final String lastReading;
    final int unknownSeconds;
    final double value;

    PDPStatusBlock(RRDFile file) {
        this.offset = file.getFilePointer();
        this.lastReading = file.readString(30);
        UnivalArray scratch = file.getUnivalArray(10);
        this.unknownSeconds = (int)scratch.getLong(pdp_par_en.PDP_unkn_sec_cnt);
        this.value = scratch.getDouble(pdp_par_en.PDP_val);
        this.size = file.getFilePointer() - this.offset;
    }

    public String getLastReading() {
        return this.lastReading;
    }

    public double getValue() {
        return this.value;
    }

    public int getUnknownSeconds() {
        return this.unknownSeconds;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[PDPStatus: OFFSET=0x");
        sb.append(Long.toHexString(this.offset));
        sb.append(", SIZE=0x");
        sb.append(Long.toHexString(this.size));
        sb.append(", lastReading=");
        sb.append(this.lastReading);
        sb.append(", unknownSeconds=");
        sb.append(this.unknownSeconds);
        sb.append(", value=");
        sb.append(this.value);
        sb.append("]");
        return sb.toString();
    }

    private static enum pdp_par_en {
        PDP_unkn_sec_cnt,
        PDP_val;

    }
}

