/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Appender;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.Log4jStringAppender;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobConfiguration;
import org.pentaho.di.trans.StepLoader;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.Messages;
import org.pentaho.di.www.WebResult;

public class StartJobServlet
extends HttpServlet {
    private static final long serialVersionUID = -8487225953910464032L;
    public static final String CONTEXT_PATH = "/kettle/startJob";
    private static LogWriter log = LogWriter.getInstance();
    private JobMap jobMap;

    public StartJobServlet(JobMap jobMap) {
        this.jobMap = jobMap;
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out;
        boolean useXML;
        block19: {
            if (!request.getContextPath().equals(CONTEXT_PATH)) {
                return;
            }
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("StartJobServlet.Log.StartJobRequested"), new Object[0]);
            }
            String jobName = request.getParameter("name");
            useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
            response.setStatus(200);
            out = response.getWriter();
            if (useXML) {
                response.setContentType("text/xml");
                response.setCharacterEncoding("UTF-8");
                out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
            } else {
                response.setContentType("text/html");
                out.println("<HTML>");
                out.println("<HEAD>");
                out.println("<TITLE>Start job</TITLE>");
                out.println("<META http-equiv=\"Refresh\" content=\"2;url=/kettle/jobStatus?name=" + URLEncoder.encode(jobName, "UTF-8") + "\">");
                out.println("</HEAD>");
                out.println("<BODY>");
            }
            try {
                Job job = this.jobMap.getJob(jobName);
                if (job != null) {
                    if (job.isInitialized() && !job.isActive()) {
                        if (job.getRep() != null && !job.getRep().getRepositoryInfo().isLocked()) {
                            job.getRep().connect(this.toString());
                        }
                        JobMap jobMap = this.jobMap;
                        synchronized (jobMap) {
                            JobConfiguration jobConfiguration = this.jobMap.getConfiguration(jobName);
                            Job newJob = new Job(LogWriter.getInstance(), StepLoader.getInstance(), job.getRep(), job.getJobMeta());
                            Appender appender = this.jobMap.getAppender(jobName);
                            if (appender != null) {
                                log.removeAppender(appender);
                            }
                            this.jobMap.removeAppender(jobName);
                            this.jobMap.removeJob(jobName);
                            this.jobMap.addJob(jobName, newJob, jobConfiguration);
                            job = newJob;
                        }
                    }
                    Log4jStringAppender appender = LogWriter.createStringAppender();
                    log.addAppender((Appender)appender);
                    this.jobMap.addAppender(jobName, (Appender)appender);
                    job.start();
                    String message = Messages.getString("StartJobServlet.Log.JobStarted", jobName);
                    if (useXML) {
                        out.println(new WebResult("OK", message).getXML());
                    } else {
                        out.println("<H1>" + message + "</H1>");
                        out.println("<a href=\"/kettle/jobStatus?name=" + URLEncoder.encode(jobName, "UTF-8") + "\">" + Messages.getString("JobStatusServlet.BackToJobStatusPage") + "</a><p>");
                    }
                    break block19;
                }
                String message = Messages.getString("StartJobServlet.Log.SpecifiedJobNotFound", jobName);
                if (useXML) {
                    out.println(new WebResult("ERROR", message));
                } else {
                    out.println("<H1>" + message + "</H1>");
                    out.println("<a href=\"/kettle/status\">" + Messages.getString("TransStatusServlet.BackToStatusPage") + "</a><p>");
                }
            }
            catch (Exception ex) {
                if (useXML) {
                    out.println(new WebResult("ERROR", Messages.getString("StartJobServlet.Error.UnexpectedError", Const.CR + Const.getStackTracker((Throwable)ex))));
                }
                out.println("<p>");
                out.println("<pre>");
                ex.printStackTrace(out);
                out.println("</pre>");
            }
        }
        if (!useXML) {
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    public String toString() {
        return "Start job";
    }
}

