/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.swingx.icons;

import com.formdev.flatlaf.icons.FlatAbstractIcon;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.UIManager;

public class FlatMonthDownIcon
extends FlatAbstractIcon {
    protected final boolean chevron = FlatUIUtils.isChevron((String)UIManager.getString("Component.arrowType"));
    protected final Color arrowColor = UIManager.getColor("JXMonthView.arrowColor");
    protected final Color disabledArrowColor = UIManager.getColor("JXMonthView.disabledArrowColor");
    private final int direction;

    public FlatMonthDownIcon() {
        this(7);
    }

    protected FlatMonthDownIcon(int direction) {
        super(20, 20, null);
        this.direction = direction;
    }

    protected void paintIcon(Component c, Graphics2D g) {
        int w = this.chevron ? 4 : 5;
        int h = this.chevron ? 8 : 9;
        int x = Math.round((float)(this.width - w) / 2.0f);
        int y = Math.round((float)(this.height - h) / 2.0f);
        g.setColor(c.isEnabled() ? this.arrowColor : this.disabledArrowColor);
        g.translate(x, y);
        Shape arrowShape = FlatUIUtils.createArrowShape((int)this.direction, (boolean)this.chevron, (float)w, (float)h);
        if (this.chevron) {
            g.setStroke(new BasicStroke(1.0f));
            g.draw(arrowShape);
        } else {
            g.fill(arrowShape);
        }
        g.translate(-x, -y);
    }
}

