/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (i64vec3(-1333333333333333259l, 85l, 94l) / 3l) => i64vec3(-444444444444444419l, 28l, 31l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) / -1192l) => i64vec3(1118568232662192l, 0l, 0l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) / 1048576l) => i64vec3(-1271565755208l, 0l, 0l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) / 4251475l) => i64vec3(-313616646771l, 0l, 0l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) / 29852643761l) => i64vec3(-44663827l, 0l, 0l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) / -4398046511104l) => i64vec3(303164l, 0l, 0l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) / -3948976685146l) => i64vec3(337640l, 0l, 0l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) / -135763469567146206l) => i64vec3(9l, 0l, 0l)
 * (i64vec3(167l, 66l, 187l) / 3l) => i64vec3(55l, 22l, 62l)
 * (i64vec3(167l, 66l, 187l) / -1192l) => i64vec3(0l, 0l, 0l)
 * (i64vec3(167l, 66l, 187l) / 1048576l) => i64vec3(0l, 0l, 0l)
 * (i64vec3(167l, 66l, 187l) / 4251475l) => i64vec3(0l, 0l, 0l)
 * (i64vec3(167l, 66l, 187l) / 29852643761l) => i64vec3(0l, 0l, 0l)
 * (i64vec3(167l, 66l, 187l) / -4398046511104l) => i64vec3(0l, 0l, 0l)
 * (i64vec3(167l, 66l, 187l) / -3948976685146l) => i64vec3(0l, 0l, 0l)
 * (i64vec3(167l, 66l, 187l) / -135763469567146206l) => i64vec3(0l, 0l, 0l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) / 3l), i64vec3(-444444444444444419l, 28l, 31l))) ? 1 : -1] array0;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) / -1192l), i64vec3(1118568232662192l, 0l, 0l))) ? 1 : -1] array1;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) / 1048576l), i64vec3(-1271565755208l, 0l, 0l))) ? 1 : -1] array2;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) / 4251475l), i64vec3(-313616646771l, 0l, 0l))) ? 1 : -1] array3;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) / 29852643761l), i64vec3(-44663827l, 0l, 0l))) ? 1 : -1] array4;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) / -4398046511104l), i64vec3(303164l, 0l, 0l))) ? 1 : -1] array5;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) / -3948976685146l), i64vec3(337640l, 0l, 0l))) ? 1 : -1] array6;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) / -135763469567146206l), i64vec3(9l, 0l, 0l))) ? 1 : -1] array7;
  float[all(equal((i64vec3(167l, 66l, 187l) / 3l), i64vec3(55l, 22l, 62l))) ? 1 : -1] array8;
  float[all(equal((i64vec3(167l, 66l, 187l) / -1192l), i64vec3(0l, 0l, 0l))) ? 1 : -1] array9;
  float[all(equal((i64vec3(167l, 66l, 187l) / 1048576l), i64vec3(0l, 0l, 0l))) ? 1 : -1] array10;
  float[all(equal((i64vec3(167l, 66l, 187l) / 4251475l), i64vec3(0l, 0l, 0l))) ? 1 : -1] array11;
  float[all(equal((i64vec3(167l, 66l, 187l) / 29852643761l), i64vec3(0l, 0l, 0l))) ? 1 : -1] array12;
  float[all(equal((i64vec3(167l, 66l, 187l) / -4398046511104l), i64vec3(0l, 0l, 0l))) ? 1 : -1] array13;
  float[all(equal((i64vec3(167l, 66l, 187l) / -3948976685146l), i64vec3(0l, 0l, 0l))) ? 1 : -1] array14;
  float[all(equal((i64vec3(167l, 66l, 187l) / -135763469567146206l), i64vec3(0l, 0l, 0l))) ? 1 : -1] array15;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length());
}
