/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ext;

import co.elastic.logstash.api.TimerMetric;
import java.util.Collection;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.execution.queue.QueueWriter;
import org.logstash.ext.JRubyAbstractQueueWriteClientExt;
import org.logstash.ext.JrubyEventExtLibrary;
import org.logstash.instrument.metrics.AbstractMetricExt;
import org.logstash.instrument.metrics.AbstractNamespacedMetricExt;
import org.logstash.instrument.metrics.MetricKeys;
import org.logstash.instrument.metrics.counter.LongCounter;
import org.logstash.instrument.metrics.timer.TimerMetric;

@JRubyClass(name={"WrappedWriteClient"})
public final class JRubyWrappedWriteClientExt
extends RubyObject
implements QueueWriter {
    private static final long serialVersionUID = 1L;
    private JRubyAbstractQueueWriteClientExt writeClient;
    private transient LongCounter eventsMetricsCounter;
    private transient TimerMetric eventsMetricsTime;
    private transient LongCounter pipelineMetricsCounter;
    private transient TimerMetric pipelineMetricsTime;
    private transient LongCounter pluginMetricsCounter;
    private transient TimerMetric pluginMetricsTime;

    public JRubyWrappedWriteClientExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod(required=4)
    public JRubyWrappedWriteClientExt initialize(ThreadContext context, IRubyObject[] args) {
        return this.initialize((JRubyAbstractQueueWriteClientExt)args[0], args[1].asJavaString(), (AbstractMetricExt)args[2], args[3]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRubyWrappedWriteClientExt initialize(JRubyAbstractQueueWriteClientExt queueWriteClientExt, String pipelineId, AbstractMetricExt metric, IRubyObject pluginId) {
        this.writeClient = queueWriteClientExt;
        RubySymbol pipelineIdSym = this.getRuntime().newString(pipelineId).intern();
        RubySymbol pluginIdSym = pluginId.asString().intern();
        AbstractMetricExt abstractMetricExt = metric;
        synchronized (abstractMetricExt) {
            AbstractNamespacedMetricExt eventsMetrics = this.getMetric(metric, MetricKeys.STATS_KEY, MetricKeys.EVENTS_KEY);
            this.eventsMetricsCounter = LongCounter.fromRubyBase(eventsMetrics, MetricKeys.IN_KEY);
            this.eventsMetricsTime = TimerMetric.fromRubyBase(eventsMetrics, MetricKeys.PUSH_DURATION_KEY);
            AbstractNamespacedMetricExt pipelineEventMetrics = this.getMetric(metric, MetricKeys.STATS_KEY, MetricKeys.PIPELINES_KEY, pipelineIdSym, MetricKeys.EVENTS_KEY);
            this.pipelineMetricsCounter = LongCounter.fromRubyBase(pipelineEventMetrics, MetricKeys.IN_KEY);
            this.pipelineMetricsTime = TimerMetric.fromRubyBase(pipelineEventMetrics, MetricKeys.PUSH_DURATION_KEY);
            AbstractNamespacedMetricExt pluginMetrics = this.getMetric(metric, MetricKeys.STATS_KEY, MetricKeys.PIPELINES_KEY, pipelineIdSym, MetricKeys.PLUGINS_KEY, MetricKeys.INPUTS_KEY, pluginIdSym, MetricKeys.EVENTS_KEY);
            this.pluginMetricsCounter = LongCounter.fromRubyBase(pluginMetrics, MetricKeys.OUT_KEY);
            this.pluginMetricsTime = TimerMetric.fromRubyBase(pluginMetrics, MetricKeys.PUSH_DURATION_KEY);
        }
        return this;
    }

    @JRubyMethod(name={"push", "<<"}, required=1)
    public IRubyObject push(ThreadContext context, IRubyObject event) throws InterruptedException {
        JrubyEventExtLibrary.RubyEvent rubyEvent = (JrubyEventExtLibrary.RubyEvent)event;
        this.incrementCounters(1L);
        return (IRubyObject)this.executeWithTimers(() -> this.writeClient.doPush(context, rubyEvent));
    }

    @JRubyMethod(name={"push_batch"}, required=1)
    public IRubyObject pushBatch(ThreadContext context, IRubyObject batch) throws InterruptedException {
        Collection rubyEvents = (Collection)batch;
        this.incrementCounters(rubyEvents.size());
        return (IRubyObject)this.executeWithTimers(() -> this.writeClient.doPushBatch(context, rubyEvents));
    }

    @Deprecated
    @JRubyMethod(name={"get_new_batch"})
    public IRubyObject newBatch(ThreadContext context) {
        return context.runtime.newArray();
    }

    private void incrementCounters(long count) {
        this.eventsMetricsCounter.increment(count);
        this.pipelineMetricsCounter.increment(count);
        this.pluginMetricsCounter.increment(count);
    }

    private <V, E extends Exception> V executeWithTimers(TimerMetric.ExceptionalSupplier<V, E> supplier) throws E {
        return (V)this.eventsMetricsTime.time(() -> this.pipelineMetricsTime.time(() -> this.pluginMetricsTime.time(supplier)));
    }

    private <E extends Exception> void executeWithTimers(Runnable runnable) {
        this.eventsMetricsTime.time(() -> this.pipelineMetricsTime.time(() -> this.pluginMetricsTime.time(runnable::run)));
    }

    private AbstractNamespacedMetricExt getMetric(AbstractMetricExt base, RubySymbol ... keys) {
        return base.namespace(this.getRuntime().getCurrentContext(), (IRubyObject)this.getRuntime().newArray((IRubyObject[])keys));
    }

    @Override
    public void push(Map<String, Object> event) {
        this.incrementCounters(1L);
        this.executeWithTimers(() -> this.writeClient.push(event));
    }
}

