/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.execution;

import java.security.SecureRandom;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.ackedqueue.QueueFactoryExt;
import org.logstash.execution.QueueBatch;
import org.logstash.ext.JrubyEventExtLibrary;
import org.logstash.instrument.metrics.AbstractNamespacedMetricExt;
import org.logstash.instrument.metrics.MetricKeys;
import org.logstash.instrument.metrics.counter.LongCounter;
import org.logstash.instrument.metrics.gauge.LazyDelegatingGauge;

class QueueReadClientBatchMetrics {
    private static final Logger LOG = LogManager.getLogger(QueueReadClientBatchMetrics.class);
    private final QueueFactoryExt.BatchMetricMode batchMetricMode;
    private LongCounter pipelineMetricBatchCount;
    private LongCounter pipelineMetricBatchByteSize;
    private LongCounter pipelineMetricBatchTotalEvents;
    private final SecureRandom random = new SecureRandom();
    private LazyDelegatingGauge currentBatchDimensions;

    public QueueReadClientBatchMetrics(QueueFactoryExt.BatchMetricMode batchMetricMode) {
        this.batchMetricMode = batchMetricMode;
    }

    public void setupMetrics(AbstractNamespacedMetricExt namespacedMetric) {
        LOG.debug("setupMetrics called with mode: {}", (Object)this.batchMetricMode);
        ThreadContext context = namespacedMetric.getRuntime().getCurrentContext();
        AbstractNamespacedMetricExt batchNamespace = namespacedMetric.namespace(context, (IRubyObject)MetricKeys.BATCH_KEY);
        if (this.batchMetricMode != QueueFactoryExt.BatchMetricMode.DISABLED) {
            this.pipelineMetricBatchCount = LongCounter.fromRubyBase(batchNamespace, MetricKeys.BATCH_COUNT);
            this.pipelineMetricBatchTotalEvents = LongCounter.fromRubyBase(batchNamespace, MetricKeys.BATCH_TOTAL_EVENTS);
            this.pipelineMetricBatchByteSize = LongCounter.fromRubyBase(batchNamespace, MetricKeys.BATCH_TOTAL_BYTES);
            this.currentBatchDimensions = LazyDelegatingGauge.fromRubyBase(batchNamespace, MetricKeys.BATCH_CURRENT_KEY);
        }
    }

    public void updateBatchMetrics(QueueBatch batch) {
        if (this.batchMetricMode == QueueFactoryExt.BatchMetricMode.DISABLED) {
            return;
        }
        if (batch.events().isEmpty()) {
            this.currentBatchDimensions.set(Arrays.asList(0L, 0L));
            return;
        }
        boolean updateMetric = true;
        if (this.batchMetricMode == QueueFactoryExt.BatchMetricMode.MINIMAL) {
            boolean bl = updateMetric = this.random.nextInt(100) < 2;
        }
        if (updateMetric) {
            this.updateBatchSizeMetric(batch);
        }
    }

    private void updateBatchSizeMetric(QueueBatch batch) {
        try {
            long totalByteSize = 0L;
            for (JrubyEventExtLibrary.RubyEvent rubyEvent : batch.events()) {
                totalByteSize += rubyEvent.getEvent().estimateMemory();
            }
            this.pipelineMetricBatchCount.increment();
            this.pipelineMetricBatchTotalEvents.increment(batch.filteredSize());
            this.pipelineMetricBatchByteSize.increment(totalByteSize);
            this.currentBatchDimensions.set(Arrays.asList(batch.filteredSize(), totalByteSize));
        }
        catch (IllegalArgumentException e) {
            LOG.error("Failed to calculate batch byte size for metrics", (Throwable)e);
        }
    }
}

