/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.credentials;

import com.microsoft.aad.adal4j.AsymmetricKeyCredential;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationException;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.azure.credentials.ApplicationTokenCredentials;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.apigeneration.Beta;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Beta(value=Beta.SinceVersion.V1_2_0)
public class DelegatedTokenCredentials
extends AzureTokenCredentials {
    private Map<String, AuthenticationResult> tokens;
    private String redirectUrl;
    private String authorizationCode;
    private ApplicationTokenCredentials applicationCredentials;

    public DelegatedTokenCredentials(ApplicationTokenCredentials applicationCredentials, String redirectUrl) {
        super(applicationCredentials.environment(), applicationCredentials.domain());
        this.applicationCredentials = applicationCredentials;
        this.tokens = new ConcurrentHashMap<String, AuthenticationResult>();
        this.redirectUrl = redirectUrl;
    }

    public DelegatedTokenCredentials(ApplicationTokenCredentials applicationCredentials, String redirectUrl, String authorizationCode) {
        this(applicationCredentials, redirectUrl);
        this.authorizationCode = authorizationCode;
    }

    public static DelegatedTokenCredentials fromFile(File authFile, String redirectUrl) throws IOException {
        return new DelegatedTokenCredentials(ApplicationTokenCredentials.fromFile(authFile), redirectUrl);
    }

    public static DelegatedTokenCredentials fromFile(File authFile, String redirectUrl, String authorizationCode) throws IOException {
        return new DelegatedTokenCredentials(ApplicationTokenCredentials.fromFile(authFile), redirectUrl, authorizationCode);
    }

    public String clientId() {
        return this.applicationCredentials.clientId();
    }

    public String generateAuthenticationUrl() {
        return String.format("%s/%s/oauth2/authorize?client_id=%s&response_type=code&redirect_uri=%s&response_mode=query&state=%s", this.environment().activeDirectoryEndpoint(), this.domain(), this.clientId(), this.redirectUrl, UUID.randomUUID());
    }

    public String generateAuthenticationUrl(ResponseMode responseMode, String state) {
        return String.format("%s/%s/oauth2/authorize?client_id=%s&response_type=code&redirect_uri=%s&response_mode=%s&state=%s", this.environment().activeDirectoryEndpoint(), this.domain(), this.clientId(), this.redirectUrl, responseMode.value, state);
    }

    public void setAuthorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    public synchronized String getToken(String resource) throws IOException {
        boolean shouldRefresh;
        AuthenticationResult authenticationResult = this.tokens.get(resource);
        if (authenticationResult != null && authenticationResult.getExpiresOnDate().after(new Date())) {
            return authenticationResult.getAccessToken();
        }
        boolean bl = shouldRefresh = authenticationResult != null;
        if (authenticationResult == null && !this.tokens.isEmpty()) {
            authenticationResult = new ArrayList<AuthenticationResult>(this.tokens.values()).get(0);
            shouldRefresh = authenticationResult.isMultipleResourceRefreshToken();
        }
        if (shouldRefresh) {
            authenticationResult = this.acquireAccessTokenFromRefreshToken(resource, authenticationResult.getRefreshToken());
        }
        if (authenticationResult == null) {
            authenticationResult = this.acquireNewAccessToken(resource);
        }
        this.tokens.put(resource, authenticationResult);
        return authenticationResult.getAccessToken();
    }

    AuthenticationResult acquireNewAccessToken(String resource) throws IOException {
        if (this.authorizationCode == null) {
            throw new IllegalArgumentException("You must acquire an authorization code by redirecting to the authentication URL");
        }
        String authorityUrl = this.environment().activeDirectoryEndpoint() + this.domain();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AuthenticationContext context = new AuthenticationContext(authorityUrl, false, executor);
        if (this.proxy() != null) {
            context.setProxy(this.proxy());
        }
        try {
            if (this.applicationCredentials.clientSecret() != null) {
                AuthenticationResult authenticationResult = (AuthenticationResult)context.acquireTokenByAuthorizationCode(this.authorizationCode, new URI(this.redirectUrl), new ClientCredential(this.applicationCredentials.clientId(), this.applicationCredentials.clientSecret()), resource, null).get();
                return authenticationResult;
            }
            if (this.applicationCredentials.clientCertificate() != null && this.applicationCredentials.clientCertificatePassword() != null) {
                AuthenticationResult authenticationResult = (AuthenticationResult)context.acquireTokenByAuthorizationCode(this.authorizationCode, new URI(this.redirectUrl), AsymmetricKeyCredential.create((String)this.applicationCredentials.clientId(), (InputStream)new ByteArrayInputStream(this.applicationCredentials.clientCertificate()), (String)this.applicationCredentials.clientCertificatePassword()), resource, null).get();
                return authenticationResult;
            }
            if (this.applicationCredentials.clientCertificate() != null) {
                AuthenticationResult authenticationResult = (AuthenticationResult)context.acquireTokenByAuthorizationCode(this.authorizationCode, new URI(this.redirectUrl), AsymmetricKeyCredential.create((String)this.clientId(), (PrivateKey)ApplicationTokenCredentials.privateKeyFromPem(new String(this.applicationCredentials.clientCertificate())), (X509Certificate)ApplicationTokenCredentials.publicKeyFromPem(new String(this.applicationCredentials.clientCertificate()))), resource, null).get();
                return authenticationResult;
            }
            try {
                throw new AuthenticationException("Please provide either a non-null secret or a non-null certificate.");
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        finally {
            executor.shutdown();
        }
    }

    private AuthenticationResult acquireAccessTokenFromRefreshToken(String resource, String refreshToken) throws IOException {
        String authorityUrl = this.environment().activeDirectoryEndpoint() + this.domain();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AuthenticationContext context = new AuthenticationContext(authorityUrl, false, executor);
        if (this.proxy() != null) {
            context.setProxy(this.proxy());
        }
        try {
            AuthenticationResult authenticationResult = (AuthenticationResult)context.acquireTokenByRefreshToken(refreshToken, new ClientCredential(this.applicationCredentials.clientId(), this.applicationCredentials.clientSecret()), resource, null).get();
            return authenticationResult;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        finally {
            executor.shutdown();
        }
    }

    public static enum ResponseMode {
        QUERY("query"),
        FORM_DATA("form_data");

        private String value;

        private ResponseMode(String value) {
            this.value = value;
        }
    }
}

