/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import org.infinispan.client.hotrod.configuration.AbstractConfigurationChildBuilder;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ServerConfiguration;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;

public class ServerConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<ServerConfiguration> {
    private String host;
    private int port = 11222;

    ServerConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public AttributeSet attributes() {
        return AttributeSet.EMPTY;
    }

    public ServerConfigurationBuilder host(String host) {
        this.host = host;
        return this;
    }

    public ServerConfigurationBuilder port(int port) {
        this.port = port;
        return this;
    }

    public void validate() {
        if (this.host == null || this.host.isEmpty()) {
            throw Log.HOTROD.missingHostDefinition();
        }
    }

    public ServerConfiguration create() {
        return new ServerConfiguration(this.host, this.port);
    }

    public ServerConfigurationBuilder read(ServerConfiguration template, Combine combine) {
        this.host = template.host();
        this.port = template.port();
        return this;
    }
}

