/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.sql.ast;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.common.FetchClauseType;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleTableGroupProducer;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.spi.SqlAstTranslatorWithMerge;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.MutationStatement;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.DerivedTableReference;
import org.hibernate.sql.ast.tree.from.FunctionTableReference;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.insert.ConflictClause;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.internal.TableInsertStandard;
import org.hibernate.sql.model.internal.TableUpdateStandard;

public class DB2SqlAstTranslator<T extends JdbcOperation>
extends SqlAstTranslatorWithMerge<T> {
    private boolean inLateral;

    public DB2SqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    protected boolean needsRecursiveKeywordInWithClause() {
        return false;
    }

    @Override
    protected void renderTableReferenceJoins(TableGroup tableGroup, LockMode lockMode, int swappedJoinIndex, boolean forceLeftJoin) {
        if (this.isInRecursiveQueryPart()) {
            List<TableReferenceJoin> joins = tableGroup.getTableReferenceJoins();
            if (joins == null || joins.isEmpty()) {
                return;
            }
            for (TableReferenceJoin tableJoin : joins) {
                switch (tableJoin.getJoinType()) {
                    case CROSS: 
                    case INNER: {
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Can't emulate '" + tableJoin.getJoinType().getText() + "join' in a DB2 recursive query part");
                    }
                }
                this.appendSql(',');
                this.renderNamedTableReference(tableJoin.getJoinedTableReference(), lockMode);
                if (tableJoin.getPredicate() == null || tableJoin.getPredicate().isEmpty()) continue;
                this.addAdditionalWherePredicate(tableJoin.getPredicate());
            }
        } else {
            super.renderTableReferenceJoins(tableGroup, lockMode, swappedJoinIndex, forceLeftJoin);
        }
    }

    @Override
    protected void renderTableGroupJoin(TableGroupJoin tableGroupJoin, List<TableGroupJoin> tableGroupJoinCollector) {
        if (this.isInRecursiveQueryPart()) {
            switch (tableGroupJoin.getJoinType()) {
                case CROSS: 
                case INNER: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Can't emulate '" + tableGroupJoin.getJoinType().getText() + "join' in a DB2 recursive query part");
                }
            }
            this.appendSql(',');
            this.renderJoinedTableGroup(tableGroupJoin.getJoinedGroup(), null, tableGroupJoinCollector);
            if (tableGroupJoin.getPredicate() != null && !tableGroupJoin.getPredicate().isEmpty()) {
                this.addAdditionalWherePredicate(tableGroupJoin.getPredicate());
            }
        } else {
            super.renderTableGroupJoin(tableGroupJoin, tableGroupJoinCollector);
        }
    }

    @Override
    protected void renderExpressionAsClauseItem(Expression expression) {
        expression.accept(this);
    }

    @Override
    protected void visitArithmeticOperand(Expression expression) {
        this.render(expression, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
    }

    @Override
    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        boolean isNegated = booleanExpressionPredicate.isNegated();
        if (isNegated) {
            this.appendSql("not(");
        }
        booleanExpressionPredicate.getExpression().accept(this);
        if (isNegated) {
            this.appendSql(')');
        }
    }

    @Override
    protected void visitAnsiCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(caseSearchedExpression)) {
            List<CaseSearchedExpression.WhenFragment> whenFragments = caseSearchedExpression.getWhenFragments();
            Expression firstResult = whenFragments.get(0).getResult();
            super.visitAnsiCaseSearchedExpression(caseSearchedExpression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSearchedExpression(caseSearchedExpression, resultRenderer);
        }
    }

    @Override
    protected void visitAnsiCaseSimpleExpression(CaseSimpleExpression caseSimpleExpression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(caseSimpleExpression)) {
            List<CaseSimpleExpression.WhenFragment> whenFragments = caseSimpleExpression.getWhenFragments();
            Expression firstResult = whenFragments.get(0).getResult();
            super.visitAnsiCaseSimpleExpression(caseSimpleExpression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSimpleExpression(caseSimpleExpression, resultRenderer);
        }
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        if (this.getQueryPartForRowNumbering() == queryPart) {
            return false;
        }
        return this.useOffsetFetchClause(queryPart) && !this.isRowsOnlyFetchClauseType(queryPart);
    }

    protected boolean supportsOffsetClause() {
        return true;
    }

    @Override
    public void visitQueryPartTableReference(QueryPartTableReference tableReference) {
        boolean oldLateral = this.inLateral;
        this.inLateral = tableReference.isLateral();
        super.visitQueryPartTableReference(tableReference);
        this.inLateral = oldLateral;
    }

    @Override
    protected void renderDerivedTableReference(DerivedTableReference tableReference) {
        if (tableReference instanceof FunctionTableReference && tableReference.isLateral()) {
            tableReference.accept(this);
        } else {
            super.renderDerivedTableReference(tableReference);
        }
    }

    @Override
    public void renderNamedSetReturningFunction(String functionName, List<? extends SqlAstNode> sqlAstArguments, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstNodeRenderingMode argumentRenderingMode) {
        ModelPart ordinalitySubPart = tupleType.findSubPart(CollectionPart.Nature.INDEX.getName(), null);
        if (ordinalitySubPart != null) {
            this.appendSql("lateral (select t.*, row_number() over() ");
            this.appendSql(ordinalitySubPart.asBasicValuedModelPart().getSelectionExpression());
            this.appendSql(" from table(");
            this.renderSimpleNamedFunction(functionName, sqlAstArguments, argumentRenderingMode);
            this.append(") t)");
        } else {
            this.appendSql("table(");
            super.renderNamedSetReturningFunction(functionName, sqlAstArguments, tupleType, tableIdentifierVariable, argumentRenderingMode);
            this.append(')');
        }
    }

    @Override
    public void visitSelectStatement(SelectStatement statement) {
        if (this.getQueryPartForRowNumbering() == statement.getQueryPart() && this.inLateral) {
            this.appendSql("lateral ");
        }
        super.visitSelectStatement(statement);
    }

    @Override
    protected void emulateFetchOffsetWithWindowFunctionsVisitQueryPart(QueryPart queryPart) {
        if (this.inLateral) {
            this.appendSql("lateral ");
            boolean oldLateral = this.inLateral;
            this.inLateral = false;
            super.emulateFetchOffsetWithWindowFunctionsVisitQueryPart(queryPart);
            this.inLateral = oldLateral;
        } else {
            super.emulateFetchOffsetWithWindowFunctionsVisitQueryPart(queryPart);
        }
    }

    private boolean shouldEmulateFetch(QueryPart queryPart) {
        return this.shouldEmulateFetchClause(queryPart) || this.getQueryPartForRowNumbering() != queryPart && !this.supportsOffsetClause() && this.hasOffset(queryPart);
    }

    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetch(queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions(queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetch(querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions(querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            if (this.supportsOffsetClause() || !this.hasOffset(queryPart)) {
                this.renderOffsetFetchClause(queryPart, true);
            } else if (queryPart.isRoot() && this.hasLimit()) {
                this.renderFetch(this.getLimitParameter(), null, FetchClauseType.ROWS_ONLY);
            } else if (queryPart.getFetchClauseExpression() != null) {
                this.renderFetch(queryPart.getFetchClauseExpression(), null, queryPart.getFetchClauseType());
            }
        }
    }

    @Override
    protected void renderOffsetExpression(Expression offsetExpression) {
        if (this.supportsParameterOffsetFetchExpression()) {
            super.renderOffsetExpression(offsetExpression);
        } else {
            this.renderExpressionAsLiteral(offsetExpression, this.getJdbcParameterBindings());
        }
    }

    @Override
    protected void renderFetchExpression(Expression fetchExpression) {
        if (this.supportsParameterOffsetFetchExpression()) {
            super.renderFetchExpression(fetchExpression);
        } else {
            this.renderExpressionAsLiteral(fetchExpression, this.getJdbcParameterBindings());
        }
    }

    @Override
    protected void visitDeleteStatementOnly(DeleteStatement statement) {
        boolean closeWrapper = this.renderReturningClause(statement);
        super.visitDeleteStatementOnly(statement);
        if (closeWrapper) {
            this.appendSql(')');
        }
    }

    @Override
    protected void visitUpdateStatementOnly(UpdateStatement statement) {
        boolean closeWrapper = this.renderReturningClause(statement);
        if (this.supportsFromClauseInUpdate() || !DB2SqlAstTranslator.hasNonTrivialFromClause(statement.getFromClause())) {
            super.visitUpdateStatementOnly(statement);
        } else if (closeWrapper) {
            this.visitUpdateStatementEmulateTupleSet(statement);
        } else {
            this.visitUpdateStatementEmulateMerge(statement);
        }
        if (closeWrapper) {
            this.appendSql(')');
        }
    }

    protected boolean supportsFromClauseInUpdate() {
        return this.getDB2Version().isSameOrAfter(11);
    }

    @Override
    protected void visitInsertStatementOnly(InsertSelectStatement statement) {
        boolean closeWrapper = this.renderReturningClause(statement);
        if (statement.getConflictClause() == null || statement.getConflictClause().isDoNothing()) {
            super.visitInsertStatementOnly(statement);
        } else {
            this.visitInsertStatementEmulateMerge(statement);
        }
        if (closeWrapper) {
            this.appendSql(')');
        }
    }

    @Override
    protected void visitConflictClause(ConflictClause conflictClause) {
        if (conflictClause != null && conflictClause.isDoUpdate() && conflictClause.getConstraintName() != null) {
            throw new IllegalQueryOperationException("Insert conflict 'do update' clause with constraint name is not supported");
        }
    }

    @Override
    protected void renderDmlTargetTableExpression(NamedTableReference tableReference) {
        super.renderDmlTargetTableExpression(tableReference);
        if (this.getClauseStack().getCurrent() != Clause.INSERT) {
            this.renderTableReferenceIdentificationVariable(tableReference);
        }
    }

    @Override
    protected void renderFromClauseAfterUpdateSet(UpdateStatement statement) {
        this.renderFromClauseExcludingDmlTargetReference(statement);
    }

    protected boolean renderReturningClause(MutationStatement statement) {
        List<ColumnReference> returningColumns = statement.getReturningColumns();
        if (CollectionHelper.isEmpty(returningColumns)) {
            return false;
        }
        this.appendSql("select ");
        for (int i = 0; i < returningColumns.size(); ++i) {
            if (i > 0) {
                this.appendSql(", ");
            }
            this.appendSql(returningColumns.get(i).getColumnExpression());
        }
        if (statement instanceof DeleteStatement) {
            this.appendSql(" from old table (");
        } else {
            this.appendSql(" from ");
            this.appendSql(this.getNewTableChangeModifier());
            this.appendSql(" table (");
        }
        return true;
    }

    protected String getNewTableChangeModifier() {
        return "new";
    }

    @Override
    public void visitStandardTableInsert(TableInsertStandard tableInsert) {
        List<ColumnReference> returningColumns = tableInsert.getReturningColumns();
        if (CollectionHelper.isNotEmpty(returningColumns)) {
            this.appendSql("select ");
            for (int i = 0; i < returningColumns.size(); ++i) {
                if (i > 0) {
                    this.appendSql(", ");
                }
                this.appendSql(returningColumns.get(i).getColumnExpression());
            }
            this.appendSql(" from ");
            this.appendSql(this.getNewTableChangeModifier());
            this.appendSql(" table (");
            super.visitStandardTableInsert(tableInsert);
            this.appendSql(")");
        } else {
            super.visitStandardTableInsert(tableInsert);
        }
    }

    @Override
    public void visitStandardTableUpdate(TableUpdateStandard tableUpdate) {
        List<ColumnReference> returningColumns = tableUpdate.getReturningColumns();
        if (CollectionHelper.isNotEmpty(returningColumns)) {
            this.appendSql("select ");
            for (int i = 0; i < returningColumns.size(); ++i) {
                if (i > 0) {
                    this.appendSql(", ");
                }
                this.appendSql(returningColumns.get(i).getColumnExpression());
            }
            this.appendSql(" from final table (");
            super.visitStandardTableUpdate(tableUpdate);
            this.appendSql(")");
        } else {
            super.visitStandardTableUpdate(tableUpdate);
        }
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        if (this.getDB2Version().isSameOrAfter(11, 1)) {
            this.renderComparisonStandard(lhs, operator, rhs);
        } else {
            JdbcMappingContainer lhsExpressionType = lhs.getExpressionType();
            if (lhsExpressionType != null && lhsExpressionType.getJdbcTypeCount() == 1 && lhsExpressionType.getSingleJdbcMapping().getJdbcType().getDdlTypeCode() == 2009) {
                switch (operator) {
                    case DISTINCT_FROM: {
                        this.appendSql("decode(");
                        this.appendSql("xmlserialize(");
                        lhs.accept(this);
                        this.appendSql(" as varchar(32672))");
                        this.appendSql(',');
                        this.appendSql("xmlserialize(");
                        rhs.accept(this);
                        this.appendSql(" as varchar(32672))");
                        this.appendSql(",0,1)=1");
                        return;
                    }
                    case NOT_DISTINCT_FROM: {
                        this.appendSql("decode(");
                        this.appendSql("xmlserialize(");
                        lhs.accept(this);
                        this.appendSql(" as varchar(32672))");
                        this.appendSql(',');
                        this.appendSql("xmlserialize(");
                        rhs.accept(this);
                        this.appendSql(" as varchar(32672))");
                        this.appendSql(",0,1)=0");
                        return;
                    }
                    case EQUAL: 
                    case NOT_EQUAL: {
                        this.appendSql("xmlserialize(");
                        lhs.accept(this);
                        this.appendSql(" as varchar(32672))");
                        this.appendSql(operator.sqlText());
                        this.appendSql("xmlserialize(");
                        rhs.accept(this);
                        this.appendSql(" as varchar(32672))");
                        return;
                    }
                }
            }
            this.renderComparisonEmulateDecode(lhs, operator, rhs, SqlAstNodeRenderingMode.NO_UNTYPED);
        }
    }

    @Override
    protected void renderComparisonStandard(Expression lhs, ComparisonOperator operator, Expression rhs) {
        JdbcMappingContainer lhsExpressionType = lhs.getExpressionType();
        if (lhsExpressionType != null && lhsExpressionType.getJdbcTypeCount() == 1 && lhsExpressionType.getSingleJdbcMapping().getJdbcType().getDdlTypeCode() == 2009) {
            switch (operator) {
                case DISTINCT_FROM: 
                case NOT_DISTINCT_FROM: 
                case EQUAL: 
                case NOT_EQUAL: {
                    this.appendSql("xmlserialize(");
                    lhs.accept(this);
                    this.appendSql(" as varchar(32672))");
                    this.appendSql(operator.sqlText());
                    this.appendSql("xmlserialize(");
                    rhs.accept(this);
                    this.appendSql(" as varchar(32672))");
                    return;
                }
            }
        }
        super.renderComparisonStandard(lhs, operator, rhs);
    }

    @Override
    protected void renderSelectExpression(Expression expression) {
        this.renderSelectExpressionWithCastedOrInlinedPlainParameters(expression);
    }

    @Override
    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    @Override
    protected void visitReturningColumns(List<ColumnReference> returningColumns) {
    }

    public DatabaseVersion getDB2Version() {
        return this.getDialect().getVersion();
    }

    protected boolean supportsParameterOffsetFetchExpression() {
        return this.getDB2Version().isSameOrAfter(11);
    }
}

