/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.text.MessageFormat;
import java.util.Locale;

enum OnOffOption {
    ON("ON"),
    OFF("OFF");

    private final String option;

    private OnOffOption(String option) {
        this.option = option;
    }

    public String toString() {
        return this.option;
    }

    static OnOffOption valueOfString(String value) throws SQLServerException {
        OnOffOption option = null;
        if (value.toLowerCase(Locale.US).equalsIgnoreCase(ON.toString())) {
            option = ON;
        } else if (value.toLowerCase(Locale.US).equalsIgnoreCase(OFF.toString())) {
            option = OFF;
        } else {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_InvalidConnectionSetting"));
            Object[] msgArgs = new Object[]{"OnOffOption", value};
            throw new SQLServerException(form.format(msgArgs), null);
        }
        return option;
    }

    static boolean isValidOnOffOption(String option) {
        for (OnOffOption t : OnOffOption.values()) {
            if (!option.equalsIgnoreCase(t.toString())) continue;
            return true;
        }
        return false;
    }
}

