/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.awt.Point;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.Projected;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileRange;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.IProjected;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;

public class TMSTileSource
extends AbstractTMSTileSource {
    protected int maxZoom;
    protected int minZoom;
    protected OsmMercator osmMercator;

    public TMSTileSource(TileSourceInfo info) {
        super(info);
        this.minZoom = info.getMinZoom();
        this.maxZoom = info.getMaxZoom();
        this.osmMercator = new OsmMercator(this.getTileSize());
    }

    @Override
    public int getMinZoom() {
        return this.minZoom == 0 ? super.getMinZoom() : this.minZoom;
    }

    @Override
    public int getMaxZoom() {
        return this.maxZoom == 0 ? super.getMaxZoom() : this.maxZoom;
    }

    @Override
    public double getDistance(double lat1, double lon1, double lat2, double lon2) {
        return this.osmMercator.getDistance(lat1, lon1, lat2, lon2);
    }

    @Override
    public Point latLonToXY(double lat, double lon, int zoom) {
        return new Point((int)Math.round(this.osmMercator.lonToX(lon, zoom)), (int)Math.round(this.osmMercator.latToY(lat, zoom)));
    }

    @Override
    public ICoordinate xyToLatLon(int x, int y, int zoom) {
        return new Coordinate(this.osmMercator.yToLat(y, zoom), this.osmMercator.xToLon(x, zoom));
    }

    @Override
    public TileXY latLonToTileXY(double lat, double lon, int zoom) {
        return new TileXY(this.osmMercator.lonToX(lon, zoom) / (double)this.getTileSize(), this.osmMercator.latToY(lat, zoom) / (double)this.getTileSize());
    }

    @Override
    public ICoordinate tileXYToLatLon(int x, int y, int zoom) {
        return new Coordinate(this.osmMercator.yToLat((long)y * (long)this.getTileSize(), zoom), this.osmMercator.xToLon((long)x * (long)this.getTileSize(), zoom));
    }

    @Override
    public IProjected tileXYtoProjected(int x, int y, int zoom) {
        double mercatorWidth = 4.007501668557849E7;
        double f = mercatorWidth * (double)this.getTileSize() / (double)this.osmMercator.getMaxPixels(zoom);
        return new Projected(f * (double)x - mercatorWidth / 2.0, -(f * (double)y - mercatorWidth / 2.0));
    }

    @Override
    public TileXY projectedToTileXY(IProjected p, int zoom) {
        double mercatorWidth = 4.007501668557849E7;
        double f = mercatorWidth * (double)this.getTileSize() / (double)this.osmMercator.getMaxPixels(zoom);
        return new TileXY((p.getEast() + mercatorWidth / 2.0) / f, (-p.getNorth() + mercatorWidth / 2.0) / f);
    }

    @Override
    public boolean isInside(Tile inner, Tile outer) {
        int dz = inner.getZoom() - outer.getZoom();
        if (dz < 0) {
            return false;
        }
        return outer.getXtile() == inner.getXtile() >> dz && outer.getYtile() == inner.getYtile() >> dz;
    }

    @Override
    public TileRange getCoveringTileRange(Tile tile, int newZoom) {
        if (newZoom <= tile.getZoom()) {
            int dz = tile.getZoom() - newZoom;
            TileXY xy = new TileXY(tile.getXtile() >> dz, tile.getYtile() >> dz);
            return new TileRange(xy, xy, newZoom);
        }
        int dz = newZoom - tile.getZoom();
        TileXY t1 = new TileXY(tile.getXtile() << dz, tile.getYtile() << dz);
        TileXY t2 = new TileXY(t1.getX() + (double)(1 << dz) - 1.0, t1.getY() + (double)(1 << dz) - 1.0);
        return new TileRange(t1, t2, newZoom);
    }

    @Override
    public String getServerCRS() {
        return "EPSG:3857";
    }
}

