/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DOMSyntaxException;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.AnimationShorthandSetter;
import io.sf.carte.doc.style.css.om.BackgroundShorthandSetter;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BorderColorShorthandSetter;
import io.sf.carte.doc.style.css.om.BorderImageShorthandSetter;
import io.sf.carte.doc.style.css.om.BorderRadiusShorthandSetter;
import io.sf.carte.doc.style.css.om.BorderShorthandSetter;
import io.sf.carte.doc.style.css.om.BorderSideShorthandSetter;
import io.sf.carte.doc.style.css.om.BorderStyleShorthandSetter;
import io.sf.carte.doc.style.css.om.BorderWidthShorthandSetter;
import io.sf.carte.doc.style.css.om.BoxShorthandSetter;
import io.sf.carte.doc.style.css.om.ColumnRuleShorthandSetter;
import io.sf.carte.doc.style.css.om.ColumnsShorthandSetter;
import io.sf.carte.doc.style.css.om.CueShorthandSetter;
import io.sf.carte.doc.style.css.om.FlexShorthandSetter;
import io.sf.carte.doc.style.css.om.FontShorthandSetter;
import io.sf.carte.doc.style.css.om.FontVariantShorthandSetter;
import io.sf.carte.doc.style.css.om.GridAreaShorthandSetter;
import io.sf.carte.doc.style.css.om.GridPlacementShorthandSetter;
import io.sf.carte.doc.style.css.om.GridShorthandSetter;
import io.sf.carte.doc.style.css.om.GridTemplateShorthandSetter;
import io.sf.carte.doc.style.css.om.ListStyleShorthandSetter;
import io.sf.carte.doc.style.css.om.MarginShorthandSetter;
import io.sf.carte.doc.style.css.om.MaskShorthandSetter;
import io.sf.carte.doc.style.css.om.OrderedTwoIdentifierShorthandSetter;
import io.sf.carte.doc.style.css.om.OrderedTwoLPIShorthandSetter;
import io.sf.carte.doc.style.css.om.OutlineShorthandSetter;
import io.sf.carte.doc.style.css.om.SequenceShorthandSetter;
import io.sf.carte.doc.style.css.om.ShorthandDecomposer;
import io.sf.carte.doc.style.css.om.SubpropertySetter;
import io.sf.carte.doc.style.css.om.TransitionShorthandSetter;
import io.sf.carte.doc.style.css.parser.CSSParser;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import org.w3c.dom.DOMException;

class ShorthandDecomposers {
    private static final HashMap<String, ShorthandDecomposer> decomposers = ShorthandDecomposers.createShorthandDecomposerMap();
    private static final ShorthandDecomposers instance = new ShorthandDecomposers();

    private ShorthandDecomposers() {
    }

    private static HashMap<String, ShorthandDecomposer> createShorthandDecomposerMap() {
        HashMap<String, ShorthandDecomposer> decompMap = new HashMap<String, ShorthandDecomposer>(38);
        decompMap.put("font", new ShorthandDecomposer(){

            @Override
            public SubpropertySetter assignLonghands(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important, boolean attrTainted) {
                String decl;
                if (style.getStyleDatabase() != null && value.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && value.getNextLexicalUnit() == null && (decl = style.getStyleDatabase().getSystemFontDeclaration(value.getStringValue())) != null) {
                    StringReader re = new StringReader(decl);
                    try {
                        value = new CSSParser().parsePropertyValue(re);
                    }
                    catch (CSSParseException e) {
                        throw new DOMSyntaxException(e);
                    }
                    catch (IOException e) {
                        throw new DOMException(11, e.getMessage());
                    }
                }
                FontShorthandSetter setter = new FontShorthandSetter(style);
                return this.assignLonghands(setter, value, important, attrTainted);
            }
        });
        decompMap.put("margin", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new MarginShorthandSetter(style);
            }
        });
        decompMap.put("padding", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new BoxShorthandSetter(style, "padding");
            }
        });
        decompMap.put("border", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new BorderShorthandSetter(style);
            }
        });
        decompMap.put("border-width", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new BorderWidthShorthandSetter(style);
            }
        });
        decompMap.put("border-style", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new BorderStyleShorthandSetter(style);
            }
        });
        decompMap.put("border-color", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new BorderColorShorthandSetter(style);
            }
        });
        decompMap.put("border-top", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new BorderSideShorthandSetter(style, propertyName, "top");
            }
        });
        decompMap.put("border-right", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new BorderSideShorthandSetter(style, propertyName, "right");
            }
        });
        decompMap.put("border-bottom", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new BorderSideShorthandSetter(style, propertyName, "bottom");
            }
        });
        decompMap.put("border-left", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new BorderSideShorthandSetter(style, propertyName, "left");
            }
        });
        decompMap.put("background", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new BackgroundShorthandSetter(style);
            }
        });
        decompMap.put("transition", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new TransitionShorthandSetter(style);
            }
        });
        decompMap.put("border-image", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new BorderImageShorthandSetter(style);
            }
        });
        decompMap.put("font-variant", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new FontVariantShorthandSetter(style);
            }
        });
        decompMap.put("border-radius", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new BorderRadiusShorthandSetter(style);
            }
        });
        decompMap.put("list-style", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new ListStyleShorthandSetter(style);
            }
        });
        decompMap.put("animation", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new AnimationShorthandSetter(style);
            }
        });
        decompMap.put("mask", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new MaskShorthandSetter(style);
            }
        });
        decompMap.put("outline", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new OutlineShorthandSetter(style);
            }
        });
        decompMap.put("flex", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new FlexShorthandSetter(style);
            }
        });
        decompMap.put("grid", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new GridShorthandSetter(style);
            }
        });
        decompMap.put("grid-template", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new GridTemplateShorthandSetter(style);
            }
        });
        decompMap.put("grid-area", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new GridAreaShorthandSetter(style);
            }
        });
        ShorthandDecomposer gridPlacement = new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new GridPlacementShorthandSetter(style, propertyName);
            }
        };
        decompMap.put("grid-column", gridPlacement);
        decompMap.put("grid-row", gridPlacement);
        decompMap.put("columns", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new ColumnsShorthandSetter(style);
            }
        });
        decompMap.put("column-rule", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new ColumnRuleShorthandSetter(style);
            }
        });
        ShorthandDecomposer orderedTwoLPI = new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new OrderedTwoLPIShorthandSetter(style, propertyName);
            }
        };
        decompMap.put("margin-inline", orderedTwoLPI);
        decompMap.put("padding-inline", orderedTwoLPI);
        decompMap.put("gap", orderedTwoLPI);
        ShorthandDecomposer orderedTwoIdent = new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new OrderedTwoIdentifierShorthandSetter(style, propertyName);
            }
        };
        decompMap.put("place-content", orderedTwoIdent);
        decompMap.put("place-items", orderedTwoIdent);
        decompMap.put("place-self", orderedTwoIdent);
        decompMap.put("cue", new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new CueShorthandSetter(style);
            }
        });
        ShorthandDecomposer sequence = new ShorthandDecomposer(){

            @Override
            SubpropertySetter createSetter(BaseCSSStyleDeclaration style, String propertyName, LexicalUnit value, boolean important) {
                return new SequenceShorthandSetter(style, propertyName);
            }
        };
        decompMap.put("pause", sequence);
        decompMap.put("rest", sequence);
        return decompMap;
    }

    public static ShorthandDecomposers getInstance() {
        return instance;
    }

    public ShorthandDecomposer get(String propertyName) {
        return decomposers.get(propertyName);
    }
}

