/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.RandomUtils;

public class LandMap {
    private static final Logger logger = Logger.getLogger(LandMap.class.getName());
    private final int width;
    private final int height;
    private final RandomUtils.RandomIntCache cache;
    private boolean[][] map;
    private int numberOfLandTiles;

    public LandMap(int width, int height, RandomUtils.RandomIntCache cache) {
        this.width = width;
        this.height = height;
        this.cache = cache;
        this.map = new boolean[this.width][this.height];
        this.numberOfLandTiles = 0;
    }

    public LandMap(Map map, RandomUtils.RandomIntCache cache) {
        this(map.getWidth(), map.getHeight(), cache);
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                boolean bl = this.map[x][y] = map.isValid(x, y) ? map.getTile(x, y).isLand() : false;
                if (!this.map[x][y]) continue;
                ++this.numberOfLandTiles;
            }
        }
    }

    public LandMap(OptionGroup mgo, RandomUtils.RandomIntCache cache) {
        this(mgo.getInteger("model.option.mapWidth"), mgo.getInteger("model.option.mapHeight"), cache);
        int distanceToEdge = mgo.getInteger("model.option.preferredDistanceToEdge");
        int minNumberOfTiles = mgo.getInteger("model.option.landMass") * this.getWidth() * this.getHeight() / 100;
        int gen = mgo.getSelection("model.option.landGeneratorType");
        logger.info("Using land generator " + mgo.getSelectionName("model.option.landGeneratorType") + " to make " + this.width + "x" + this.height + " map with distance-to-edge=" + distanceToEdge + " and min-tile#=" + minNumberOfTiles);
        this.generate(gen, distanceToEdge, minNumberOfTiles);
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public boolean isValid(int x, int y) {
        return x >= 0 && y >= 0 && x < this.getWidth() && y < this.getHeight();
    }

    public boolean isLand(int x, int y) {
        return this.isValid(x, y) ? this.map[x][y] : false;
    }

    public boolean hasLand() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (!this.map[x][y]) continue;
                return true;
            }
        }
        return false;
    }

    private boolean setLand(int x, int y) {
        if (this.isLand(x, y)) {
            return false;
        }
        this.map[x][y] = true;
        ++this.numberOfLandTiles;
        return true;
    }

    private void setLand(int x, int y, int distanceToEdge) {
        if (!this.setLand(x, y)) {
            return;
        }
        Map.Position p = new Map.Position(x, y);
        for (Direction direction : Direction.longSides) {
            Map.Position n = new Map.Position(p, direction);
            if (!n.isValid(this.getWidth(), this.getHeight())) continue;
            this.growLand(n.getX(), n.getY(), distanceToEdge);
        }
    }

    private final void generate(int type, int distanceToEdge, int minNumberOfTiles) {
        switch (type) {
            case 0: {
                this.createClassicLandMap(distanceToEdge, minNumberOfTiles);
                break;
            }
            case 1: {
                this.addPolarRegions();
                int contsize = minNumberOfTiles * 75 / 100;
                int height = this.getHeight() / 4 + this.cache.nextInt(this.getHeight() / 2);
                this.addLandMass(contsize, contsize, this.getWidth() / 2, height, distanceToEdge);
                while (this.numberOfLandTiles < minNumberOfTiles) {
                    this.addLandMass(15, 25, -1, -1, distanceToEdge);
                }
                break;
            }
            case 2: {
                this.addPolarRegions();
                int archsize = minNumberOfTiles * 10 / 100;
                for (int i = 0; i < 5; ++i) {
                    this.addLandMass(archsize - 5, archsize + 5, -1, -1, distanceToEdge);
                }
            }
            case 3: {
                this.addPolarRegions();
                while (this.numberOfLandTiles < minNumberOfTiles) {
                    this.addLandMass(25, 25 + this.cache.nextInt(50), -1, -1, distanceToEdge);
                }
                break;
            }
        }
        this.cleanMap();
    }

    private void createClassicLandMap(int distanceToEdge, int minNumberOfTiles) {
        int edg = distanceToEdge * 2;
        int wid = this.getWidth() - edg * 2;
        int hgt = this.getHeight() - edg * 2;
        while (this.numberOfLandTiles < minNumberOfTiles) {
            int y;
            int x;
            int failCounter = 0;
            do {
                x = edg + this.cache.nextInt(wid);
                y = edg + this.cache.nextInt(hgt);
                if (++failCounter <= 100) continue;
                failCounter = 0;
                --minNumberOfTiles;
                break;
            } while (this.isLand(x, y));
            this.setLand(x, y, distanceToEdge);
        }
        this.addPolarRegions();
    }

    private void addPolarRegions() {
        for (int x = 0; x < this.width; ++x) {
            int limit;
            for (int y = 0; y < 2; ++y) {
                this.setLand(x, y);
            }
            for (int y = limit = this.height - 1 - 2; y < this.height; ++y) {
                this.setLand(x, y);
            }
        }
    }

    private void cleanMap() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (this.hasAdjacentLand(x, y)) continue;
                this.map[x][y] = false;
            }
        }
    }

    private boolean hasAdjacentLand(int x, int y) {
        Map.Position p = new Map.Position(x, y);
        Predicate<Direction> landPred = d -> {
            Map.Position n = new Map.Position(p, (Direction)d);
            return this.isLand(n.getX(), n.getY());
        };
        return CollectionUtils.any(Direction.values(), landPred);
    }

    private List<Map.Position> newPositions(Map.Position position, int distanceToEdge) {
        Predicate<Map.Position> landPred = p -> p.isValid(this.getWidth(), this.getHeight()) && !this.hasAdjacentLand(p.getX(), p.getY()) && p.getX() > distanceToEdge && p.getX() < this.getWidth() - distanceToEdge;
        Function<Direction, Map.Position> positionMapper = d -> new Map.Position(position, (Direction)d);
        return CollectionUtils.transform(CollectionUtils.map(Direction.longSides, positionMapper), landPred);
    }

    private void growLand(int x, int y, int distanceToEdge) {
        if (this.isLand(x, y)) {
            return;
        }
        int r = this.cache.nextInt(8) + Math.max(-1, 1 + Math.max(distanceToEdge - Math.min(x, this.getWidth() - x), 2 * distanceToEdge - Math.min(y, this.getHeight() - y)));
        Map.Position p = new Map.Position(x, y);
        Predicate<Direction> landPred = d -> {
            Map.Position n = new Map.Position(p, (Direction)d);
            return this.isLand(n.getX(), n.getY());
        };
        if (CollectionUtils.count(Direction.values(), landPred) > r) {
            this.setLand(x, y, distanceToEdge);
        }
    }

    private int addLandMass(int minSize, int maxSize, int x, int y, int distanceToEdge) {
        int size = 0;
        boolean[][] newLand = new boolean[this.getWidth()][this.getHeight()];
        if (x < 0 || y < 0) {
            int wid = this.getWidth() - distanceToEdge * 2;
            int hgt = this.getHeight() - distanceToEdge * 2;
            while (this.isLand(x = distanceToEdge + this.cache.nextInt(wid), y = distanceToEdge + this.cache.nextInt(hgt)) || this.hasAdjacentLand(x, y)) {
            }
        }
        newLand[x][y] = true;
        ++size;
        Map.Position p = new Map.Position(x, y);
        List<Map.Position> l = this.newPositions(p, distanceToEdge);
        int enough = minSize + this.cache.nextInt(maxSize - minSize + 1);
        while (size < enough && !l.isEmpty()) {
            int i = this.cache.nextInt(l.size());
            p = l.remove(i);
            if (newLand[p.getX()][p.getY()]) continue;
            newLand[p.getX()][p.getY()] = true;
            ++size;
            l.addAll(this.newPositions(p, distanceToEdge));
        }
        if (size >= minSize) {
            for (x = 0; x < this.width; ++x) {
                for (y = 0; y < this.height; ++y) {
                    if (!newLand[x][y]) continue;
                    this.setLand(x, y);
                }
            }
        }
        return size >= minSize ? size : 0;
    }
}

