/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.turboproject;

import java.util.HashMap;
import net.sf.mpxj.Duration;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.turboproject.PEPUtility;
import net.sf.mpxj.turboproject.Table;

class TableA5TAB
extends Table {
    TableA5TAB() {
    }

    @Override
    protected void readRow(int uniqueID, byte[] data) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UNIQUE_ID", uniqueID);
        int originalDuration = PEPUtility.getShort(data, 22);
        int remainingDuration = PEPUtility.getShort(data, 24);
        int percentComplete = 0;
        if (originalDuration != 0) {
            percentComplete = (originalDuration - remainingDuration) * 100 / originalDuration;
        }
        map.put("ORIGINAL_DURATION", Duration.getInstance(originalDuration, TimeUnit.DAYS));
        map.put("REMAINING_DURATION", Duration.getInstance(remainingDuration, TimeUnit.DAYS));
        map.put("PERCENT_COMPLETE", percentComplete);
        map.put("TARGET_START", PEPUtility.getStartDate(data, 4));
        map.put("TARGET_FINISH", PEPUtility.getFinishDate(data, 6));
        map.put("ACTUAL_START", PEPUtility.getStartDate(data, 16));
        map.put("ACTUAL_FINISH", PEPUtility.getFinishDate(data, 18));
        this.addRow(uniqueID, map);
    }
}

