/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.AccessDeniedException;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationTrustResolver;
import org.springframework.security.AuthenticationTrustResolverImpl;
import org.springframework.security.InsufficientAuthenticationException;
import org.springframework.security.SpringSecurityException;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.ui.AccessDeniedHandler;
import org.springframework.security.ui.AccessDeniedHandlerImpl;
import org.springframework.security.ui.AuthenticationEntryPoint;
import org.springframework.security.ui.FilterChainOrder;
import org.springframework.security.ui.SpringSecurityFilter;
import org.springframework.security.ui.savedrequest.SavedRequest;
import org.springframework.security.util.PortResolver;
import org.springframework.security.util.PortResolverImpl;
import org.springframework.security.util.ThrowableAnalyzer;
import org.springframework.security.util.ThrowableCauseExtractor;
import org.springframework.util.Assert;

public class ExceptionTranslationFilter
extends SpringSecurityFilter
implements InitializingBean {
    private AccessDeniedHandler accessDeniedHandler = new AccessDeniedHandlerImpl();
    private AuthenticationEntryPoint authenticationEntryPoint;
    private AuthenticationTrustResolver authenticationTrustResolver = new AuthenticationTrustResolverImpl();
    private PortResolver portResolver = new PortResolverImpl();
    private ThrowableAnalyzer throwableAnalyzer = new DefaultThrowableAnalyzer();
    private boolean createSessionAllowed = true;
    static /* synthetic */ Class class$org$springframework$security$SpringSecurityException;
    static /* synthetic */ Class class$javax$servlet$ServletException;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationEntryPoint, (String)"authenticationEntryPoint must be specified");
        Assert.notNull((Object)this.portResolver, (String)"portResolver must be specified");
        Assert.notNull((Object)this.authenticationTrustResolver, (String)"authenticationTrustResolver must be specified");
        Assert.notNull((Object)this.throwableAnalyzer, (String)"throwableAnalyzer must be specified");
    }

    public void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Chain processed normally");
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Throwable[] causeChain = this.throwableAnalyzer.determineCauseChain(ex);
            SpringSecurityException ase = (SpringSecurityException)((Object)this.throwableAnalyzer.getFirstThrowableOfType(class$org$springframework$security$SpringSecurityException == null ? (class$org$springframework$security$SpringSecurityException = ExceptionTranslationFilter.class$("org.springframework.security.SpringSecurityException")) : class$org$springframework$security$SpringSecurityException, causeChain));
            if (ase != null) {
                this.handleException((ServletRequest)request, (ServletResponse)response, chain, ase);
            }
            if (ex instanceof ServletException) {
                throw (ServletException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    public AuthenticationEntryPoint getAuthenticationEntryPoint() {
        return this.authenticationEntryPoint;
    }

    public AuthenticationTrustResolver getAuthenticationTrustResolver() {
        return this.authenticationTrustResolver;
    }

    public PortResolver getPortResolver() {
        return this.portResolver;
    }

    private void handleException(ServletRequest request, ServletResponse response, FilterChain chain, SpringSecurityException exception) throws IOException, ServletException {
        if (exception instanceof AuthenticationException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Authentication exception occurred; redirecting to authentication entry point", (Throwable)((Object)exception));
            }
            this.sendStartAuthentication(request, response, chain, (AuthenticationException)exception);
        } else if (exception instanceof AccessDeniedException) {
            if (this.authenticationTrustResolver.isAnonymous(SecurityContextHolder.getContext().getAuthentication())) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Access is denied (user is anonymous); redirecting to authentication entry point", (Throwable)((Object)exception));
                }
                this.sendStartAuthentication(request, response, chain, new InsufficientAuthenticationException("Full authentication is required to access this resource"));
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Access is denied (user is not anonymous); delegating to AccessDeniedHandler", (Throwable)((Object)exception));
                }
                this.accessDeniedHandler.handle(request, response, (AccessDeniedException)exception);
            }
        }
    }

    public boolean isCreateSessionAllowed() {
        return this.createSessionAllowed;
    }

    protected void sendStartAuthentication(ServletRequest request, ServletResponse response, FilterChain chain, AuthenticationException reason) throws ServletException, IOException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        SavedRequest savedRequest = new SavedRequest(httpRequest, this.portResolver);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Authentication entry point being called; SavedRequest added to Session: " + savedRequest));
        }
        if (this.createSessionAllowed) {
            httpRequest.getSession().setAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY", (Object)savedRequest);
        }
        SecurityContextHolder.getContext().setAuthentication(null);
        this.authenticationEntryPoint.commence((ServletRequest)httpRequest, response, reason);
    }

    public void setAccessDeniedHandler(AccessDeniedHandler accessDeniedHandler) {
        Assert.notNull((Object)accessDeniedHandler, (String)"AccessDeniedHandler required");
        this.accessDeniedHandler = accessDeniedHandler;
    }

    public void setAuthenticationEntryPoint(AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public void setAuthenticationTrustResolver(AuthenticationTrustResolver authenticationTrustResolver) {
        this.authenticationTrustResolver = authenticationTrustResolver;
    }

    public void setCreateSessionAllowed(boolean createSessionAllowed) {
        this.createSessionAllowed = createSessionAllowed;
    }

    public void setPortResolver(PortResolver portResolver) {
        this.portResolver = portResolver;
    }

    public void setThrowableAnalyzer(ThrowableAnalyzer throwableAnalyzer) {
        this.throwableAnalyzer = throwableAnalyzer;
    }

    public int getOrder() {
        return FilterChainOrder.EXCEPTION_TRANSLATION_FILTER;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class DefaultThrowableAnalyzer
    extends ThrowableAnalyzer {
        private DefaultThrowableAnalyzer() {
        }

        protected void initExtractorMap() {
            super.initExtractorMap();
            this.registerExtractor(class$javax$servlet$ServletException == null ? (class$javax$servlet$ServletException = ExceptionTranslationFilter.class$("javax.servlet.ServletException")) : class$javax$servlet$ServletException, new ThrowableCauseExtractor(){

                public Throwable extractCause(Throwable throwable) {
                    ThrowableAnalyzer.verifyThrowableHierarchy(throwable, class$javax$servlet$ServletException == null ? (class$javax$servlet$ServletException = ExceptionTranslationFilter.class$("javax.servlet.ServletException")) : class$javax$servlet$ServletException);
                    return ((ServletException)throwable).getRootCause();
                }
            });
        }
    }
}

