/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.Util;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;

public final class SQLServerDriver
implements Driver {
    static final String[] driverProperties = new String[]{"databaseName", "user", "password", "serverName", "portNumber", "disableStatementPooling", "integratedSecurity", "lockTimeout", "sendStringParametersAsUnicode", "lastUpdateCount", "applicationName", "selectMethod", "loginTimeout", "instanceName", "workstationID", "xopenStates", "failoverPartner", "packetSize"};
    static final String[][] driverPropertiesSynonyms = new String[][]{{"database", "databaseName"}, {"userName", "user"}, {"server", "serverName"}, {"port", "portNumber"}};
    static Properties connProperties;

    static Properties fixupProperties(Properties properties) {
        Properties properties2 = new Properties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = Util.normalizePropertyNames(string);
            if (null == string2) continue;
            String string3 = properties.getProperty(string);
            properties2.setProperty(string2, string3);
        }
        return properties2;
    }

    static Properties mergeURLAndSuppliedProperties(Properties properties, Properties properties2) throws SQLServerException {
        if (null == properties2) {
            return properties;
        }
        if (properties2.isEmpty()) {
            return properties;
        }
        Properties properties3 = SQLServerDriver.fixupProperties(properties2);
        for (int i = 0; i < driverProperties.length; ++i) {
            String string = driverProperties[i];
            String string2 = properties3.getProperty(string);
            if (null == string2) continue;
            properties.put(string, string2);
        }
        return properties;
    }

    public Connection connect(String string, Properties properties) throws SQLServerException {
        SQLServerConnection sQLServerConnection = null;
        if (string == null) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_nullConnection"), null, 0, false);
        }
        Properties properties2 = Util.parseUrl(string);
        if (properties2 == null) {
            return null;
        }
        int n = DriverManager.getLoginTimeout();
        if (n > 0) {
            properties2.put("loginTimeout", new Integer(n).toString());
        }
        connProperties = properties2 = SQLServerDriver.mergeURLAndSuppliedProperties(properties2, properties);
        sQLServerConnection = new SQLServerConnection();
        sQLServerConnection.sConnectURL = string;
        sQLServerConnection.connect(properties2, null);
        return sQLServerConnection;
    }

    public boolean acceptsURL(String string) throws SQLServerException {
        boolean bl = Util.parseUrl(string) != null;
        return bl;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLServerException {
        DriverPropertyInfo driverPropertyInfo = null;
        int n = 0;
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[driverProperties.length];
        if (connProperties == null) {
            connProperties = new Properties();
        }
        String string2 = connProperties.getProperty("user");
        driverPropertyInfo = new DriverPropertyInfo("user", string2);
        driverPropertyInfo.required = true;
        driverPropertyInfo.description = "User name";
        driverPropertyInfoArray[n++] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("password", null);
        driverPropertyInfo.required = true;
        driverPropertyInfo.description = "Password";
        driverPropertyInfoArray[n++] = driverPropertyInfo;
        string2 = connProperties.getProperty("databaseName");
        driverPropertyInfo = new DriverPropertyInfo("databaseName", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Database to connect to";
        driverPropertyInfoArray[n++] = driverPropertyInfo;
        string2 = connProperties.getProperty("serverName");
        driverPropertyInfo = new DriverPropertyInfo("serverName", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "The host to connect to";
        driverPropertyInfoArray[n++] = driverPropertyInfo;
        string2 = connProperties.getProperty("portNumber");
        if (string2 == null) {
            string2 = "1433";
        }
        driverPropertyInfo = new DriverPropertyInfo("portNumber", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "The SQL Server port";
        driverPropertyInfoArray[n++] = driverPropertyInfo;
        string2 = connProperties.getProperty("sendStringParametersAsUnicode");
        if (string2 == null) {
            string2 = "true";
        }
        driverPropertyInfo = new DriverPropertyInfo("sendStringParametersAsUnicode", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Send prepared string parameters as Unicode";
        driverPropertyInfoArray[n++] = driverPropertyInfo;
        string2 = connProperties.getProperty("applicationName");
        if (string2 == null) {
            string2 = "Microsoft SQL Server 2005 JDBC Driver";
        }
        driverPropertyInfo = new DriverPropertyInfo("applicationName", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Set the application name for profiling";
        driverPropertyInfoArray[n++] = driverPropertyInfo;
        string2 = connProperties.getProperty("lastUpdateCount");
        if (string2 == null) {
            string2 = "true";
        }
        driverPropertyInfo = new DriverPropertyInfo("lastUpdateCount", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Ensure that only the last update count from an update or insert is returned";
        driverPropertyInfoArray[n++] = driverPropertyInfo;
        string2 = connProperties.getProperty("disableStatementPooling");
        if (string2 == null) {
            string2 = "true";
        }
        driverPropertyInfo = new DriverPropertyInfo("disableStatementPooling", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Disable statement pooling";
        driverPropertyInfoArray[n++] = driverPropertyInfo;
        string2 = connProperties.getProperty("integratedSecurity");
        if (string2 == null) {
            string2 = "false";
        }
        driverPropertyInfo = new DriverPropertyInfo("integratedSecurity", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Integrated security";
        driverPropertyInfoArray[n++] = driverPropertyInfo;
        string2 = connProperties.getProperty("lockTimeout");
        if (string2 == null) {
            string2 = "-1";
        }
        driverPropertyInfo = new DriverPropertyInfo("lockTimeout", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Set the lock timeout";
        driverPropertyInfoArray[n++] = driverPropertyInfo;
        string2 = connProperties.getProperty("loginTimeout");
        if (string2 == null) {
            string2 = "0";
        }
        driverPropertyInfo = new DriverPropertyInfo("loginTimeout", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Set the login Timeout";
        driverPropertyInfoArray[n++] = driverPropertyInfo;
        string2 = connProperties.getProperty("instanceName");
        driverPropertyInfo = new DriverPropertyInfo("instanceName", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Set the Instance Name";
        driverPropertyInfoArray[n++] = driverPropertyInfo;
        string2 = connProperties.getProperty("xopenStates");
        if (string2 == null) {
            string2 = "false";
        }
        driverPropertyInfo = new DriverPropertyInfo("xopenStates", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Set the SQLException state to XOPEN mode";
        driverPropertyInfoArray[n++] = driverPropertyInfo;
        string2 = connProperties.getProperty("selectMethod");
        if (string2 == null) {
            string2 = "direct";
        }
        driverPropertyInfo = new DriverPropertyInfo("selectMethod", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Enable Serverside cursors";
        driverPropertyInfoArray[n++] = driverPropertyInfo;
        string2 = connProperties.getProperty("workstationID");
        driverPropertyInfo = new DriverPropertyInfo("workstationID", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Host name of the workstation";
        driverPropertyInfoArray[n++] = driverPropertyInfo;
        string2 = connProperties.getProperty("failoverPartner");
        driverPropertyInfo = new DriverPropertyInfo("failoverPartner", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Failover Partner Name";
        driverPropertyInfoArray[n++] = driverPropertyInfo;
        string2 = connProperties.getProperty("packetSize");
        if (string2 == null) {
            string2 = String.valueOf(4096);
        }
        driverPropertyInfo = new DriverPropertyInfo("packetSize", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Network packet size";
        driverPropertyInfoArray[n++] = driverPropertyInfo;
        return driverPropertyInfoArray;
    }

    public int getMajorVersion() {
        return Util.majorVersion();
    }

    public int getMinorVersion() {
        try {
            Integer n = new Integer(Util.minorVersion());
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public boolean jdbcCompliant() {
        return true;
    }

    static {
        try {
            DriverManager.registerDriver(new SQLServerDriver());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }
}

