/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.immutable.instruction;

import com.android.tools.smali.dexlib2.Format;
import com.android.tools.smali.dexlib2.Opcode;
import com.android.tools.smali.dexlib2.iface.instruction.formats.ArrayPayload;
import com.android.tools.smali.dexlib2.immutable.instruction.ImmutableInstruction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class ImmutableArrayPayload
extends ImmutableInstruction
implements ArrayPayload {
    public static final Opcode OPCODE = Opcode.ARRAY_PAYLOAD;
    public final int elementWidth;
    public final List arrayElements;

    public ImmutableArrayPayload(int n, List object) {
        super(OPCODE);
        long l;
        long l2;
        if (n != 1 && n != 2 && n != 4 && n != 8) {
            Integer n2 = n;
            Object[] objectArray = new Object[1];
            object = objectArray;
            objectArray[0] = n2;
            throw new IllegalArgumentException(String.format("Not a valid element width: %d", (Object[])object));
        }
        this.elementWidth = n;
        object = object == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList(object));
        if (n == 2) {
            l2 = 65535L;
            l = -32768L;
        } else {
            int n3 = n * 8 - 1;
            l2 = (1L << n3) - 1L;
            l = -l2 - 1L;
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Number number = (Number)iterator.next();
            if (number.longValue() >= l && number.longValue() <= l2) continue;
            Long l3 = number.longValue();
            object = n;
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = l3;
            objectArray[1] = object;
            throw new IllegalArgumentException(String.format("%d does not fit into a %d-byte signed integer", objectArray2));
        }
        this.arrayElements = object;
    }

    @Override
    public final int getElementWidth() {
        return this.elementWidth;
    }

    @Override
    public final List getArrayElements() {
        return this.arrayElements;
    }

    @Override
    public final int getCodeUnits() {
        ImmutableArrayPayload immutableArrayPayload = this;
        int n = immutableArrayPayload.elementWidth;
        return (immutableArrayPayload.arrayElements.size() * n + 1) / 2 + 4;
    }

    @Override
    public final Format getFormat() {
        return ImmutableArrayPayload.OPCODE.format;
    }
}

