module RDP;

export {
	# https://www.c-amie.co.uk/technical/mstsc-versions/
	const builds = {
		[0419] = "RDP 4.0",
		[2195] = "RDP 5.0",
		[2221] = "RDP 5.0",
		[2600] = "RDP 5.1",
		[3790] = "RDP 5.2",
		[6000] = "RDP 6.0",
		[6001] = "RDP 6.1",
		[6002] = "RDP 6.2",
		[7600] = "RDP 7.0",
		[7601] = "RDP 7.1",
		[9200] = "RDP 8.0",
		[9600] = "RDP 8.1",
		[25189] = "RDP 8.0 (Mac)",
		[25282] = "RDP 8.0 (Mac)"
	} &default = function(n: count): string { return fmt("client_build-%d", n); };

	const security_protocols = {
		[0x00] = "RDP",
		[0x01] = "SSL",
		[0x02] = "HYBRID",
		[0x08] = "HYBRID_EX"
	} &default = function(n: count): string { return fmt("security_protocol-%d", n); };

	const failure_codes = {
		[0x01] = "SSL_REQUIRED_BY_SERVER",
		[0x02] = "SSL_NOT_ALLOWED_BY_SERVER",
		[0x03] = "SSL_CERT_NOT_ON_SERVER",
		[0x04] = "INCONSISTENT_FLAGS",
		[0x05] = "HYBRID_REQUIRED_BY_SERVER",
		[0x06] = "SSL_WITH_USER_AUTH_REQUIRED_BY_SERVER"
	} &default = function(n: count): string { return fmt("failure_code-%d", n); };

	const cert_types = {
		[1] = "RSA",
		[2] = "X.509"
	} &default = function(n: count): string { return fmt("cert_type-%d", n); };

	const encryption_methods = {
		[0] = "None",
		[1] = "40bit",
		[2] = "128bit",
		[8] = "56bit",
		[10] = "FIPS"
	} &default = function(n: count): string { return fmt("encryption_method-%d", n); };

	const encryption_levels = {
		[0] = "None",
		[1] = "Low",
		[2] = "Client compatible",
		[3] = "High",
		[4] = "FIPS"
	} &default = function(n: count): string { return fmt("encryption_level-%d", n); };

	const high_color_depths = {
		[0x0004] = "4bit",
		[0x0008] = "8bit",
		[0x000F] = "15bit",
		[0x0010] = "16bit",
		[0x0018] = "24bit"
	} &default = function(n: count): string { return fmt("high_color_depth-%d", n); };

	const color_depths = {
		[0x0001] = "24bit",
		[0x0002] = "16bit",
		[0x0004] = "15bit",
		[0x0008] = "32bit"
	} &default = function(n: count): string { return fmt("color_depth-%d", n); };

	const results = {
		[0] = "Success",
		[1] = "User rejected",
		[2] = "Resources not available",
		[3] = "Rejected for symmetry breaking",
		[4] = "Locked conference",
	} &default = function(n: count): string { return fmt("result-%d", n); };

	# https://msdn.microsoft.com/en-us/goglobal/bb964664.aspx
	# https://learn.microsoft.com/en-us/windows-hardware/manufacture/desktop/windows-language-pack-default-values
	const languages = {
		[1078] = "Afrikaans - South Africa",
		[1052] = "Albanian - Albania",
		[1156] = "Alsatian",
		[1118] = "Amharic - Ethiopia",
		[5121] = "Arabic - Algeria",
		[15361] = "Arabic - Bahrain",
		[3073] = "Arabic - Egypt",
		[2049] = "Arabic - Iraq",
		[11265] = "Arabic - Jordan",
		[13313] = "Arabic - Kuwait",
		[12289] = "Arabic - Lebanon",
		[4097] = "Arabic - Libya",
		[6145] = "Arabic - Morocco",
		[8193] = "Arabic - Oman",
		[16385] = "Arabic - Qatar",
		[1025] = "Arabic - Saudi Arabia",
		[10241] = "Arabic - Syria",
		[7169] = "Arabic - Tunisia",
		[14337] = "Arabic - U.A.E.",
		[9217] = "Arabic - Yemen",
		[132097] = "Arabic (102) AZERTY",
		[66561] = "Arabic (102)",
		[1067] = "Armenian - Armenia",
		[132139] = "Armenian Phonetic",
		[197675] = "Armenian Typewriter",
		[66603] = "Armenian Western",
		[1101] = "Assamese",
		[66604] = "Azerbaijani (Standard)",
		[2092] = "Azeri (Cyrillic)",
		[1068] = "Azeri (Latin)",
		[66629] = "Bangla (India - Legacy)",
		[132165] = "Bangla (India)",
		[1133] = "Bashkir",
		[1069] = "Basque",
		[1059] = "Belarusian",
		[67596] = "Belgian (Comma)",
		[2117] = "Bengali (Bangladesh)",
		[1093] = "Bengali (India)",
		[5146] = "Bosnian (Bosnia/Herzegovina)",
		[8218] = "Bosnian (Cyrillic) - Bosnia and Herzegovina",
		[1150] = "Breton",
		[723968] = "Buginese",
		[66562] = "Bulgarian (Latin)",
		[132098] = "Bulgarian (phonetic layout)",
		[263170] = "Bulgarian (phonetic traditional)",
		[1026] = "Bulgarian",
		[197634] = "Bulgarian",
		[1109] = "Burmese",
		[69641] = "Canadian Multilingual Standard",
		[1027] = "Catalan",
		[4191] = "Central Atlas Tamazight (Tifinagh) - Morocco",
		[1116] = "Cherokee - United States",
		[66652] = "Cherokee Nation Phonetic",
		[3076] = "Chinese - Hong Kong SAR",
		[5124] = "Chinese - Macao SAR",
		[2052] = "Chinese - People's Republic of China",
		[4100] = "Chinese - Singapore",
		[1028] = "Chinese - Taiwan",
		[31748] = "Chinese - Traditional",
		[1155] = "Corsican",
		[4122] = "Croatian (Bosnia/Herzegovina)",
		[1050] = "Croatian",
		[66565] = "Czech (QWERTY)",
		[132101] = "Czech Programmers",
		[1029] = "Czech",
		[1030] = "Danish",
		[1164] = "Dari",
		[66661] = "Divehi Typewriter",
		[1125] = "Divehi",
		[2067] = "Dutch - Belgium",
		[1043] = "Dutch - Netherlands",
		[3153] = "Dzongkha",
		[1126] = "Edo",
		[3081] = "English - Australia",
		[10249] = "English - Belize",
		[4105] = "English - Canada",
		[9225] = "English - Caribbean",
		[15369] = "English - Hong Kong SAR",
		[16393] = "English - India",
		[14345] = "English - Indonesia",
		[6153] = "English - Ireland",
		[8201] = "English - Jamaica",
		[17417] = "English - Malaysia",
		[5129] = "English - New Zealand",
		[13321] = "English - Philippines",
		[18441] = "English - Singapore",
		[7177] = "English - South Africa",
		[11273] = "English - Trinidad",
		[2057] = "English - United Kingdom",
		[197641] = "English - United States (Dvorak for left hand)",
		[263177] = "English - United States (Dvorak for right hand)",
		[66569] = "English - United States (Dvorak)",
		[132105] = "English - United States (International)",
		[1033] = "English - United States",
		[12297] = "English - Zimbabwe",
		[1061] = "Estonian",
		[1080] = "Faroese",
		[1065] = "Farsi",
		[1124] = "Filipino",
		[67643] = "Finnish with Sami",
		[1035] = "Finnish",
		[2060] = "French - Belgium",
		[11276] = "French - Cameroon",
		[3084] = "French - Canada",
		[12300] = "French - Cote d'Ivoire",
		[9228] = "French - Democratic Rep. of Congo",
		[1036] = "French - France",
		[15372] = "French - Haiti",
		[5132] = "French - Luxembourg",
		[13324] = "French - Mali",
		[6156] = "French - Monaco",
		[14348] = "French - Morocco",
		[58380] = "French - North Africa",
		[8204] = "French - Reunion",
		[10252] = "French - Senegal",
		[4108] = "French - Switzerland",
		[1122] = "French - West Indies",
		[7180] = "French - West Indies",
		[1127] = "Fulfulde - Nigeria",
		[1182720] = "Futhark",
		[1071] = "FYRO Macedonian",
		[1110] = "Galician",
		[132151] = "Georgian (Ergonomic)",
		[263223] = "Georgian (Old Alphabets)",
		[66615] = "Georgian (QWERTY)",
		[197687] = "Georgian Ministry of Education and Science Schools",
		[1079] = "Georgian",
		[3079] = "German - Austria",
		[1031] = "German - Germany",
		[5127] = "German - Liechtenstein",
		[4103] = "German - Luxembourg",
		[2055] = "German - Switzerland",
		[66567] = "German (IBM)",
		[789504] = "Gothic",
		[197640] = "Greek (220) Latin",
		[66568] = "Greek (220)",
		[263176] = "Greek (319) Latin",
		[132104] = "Greek (319)",
		[328712] = "Greek Latin",
		[394248] = "Greek Polytonic",
		[1032] = "Greek",
		[1135] = "Greenlandic",
		[1140] = "Guarani - Paraguay",
		[1095] = "Gujarati",
		[1128] = "Hausa - Nigeria",
		[1141] = "Hawaiian - United States",
		[1037] = "Hebrew",
		[1279] = "HID (Human Interface Device)",
		[66617] = "Hindi Traditional",
		[1081] = "Hindi",
		[66574] = "Hungarian 101-key",
		[1038] = "Hungarian",
		[1129] = "Ibibio - Nigeria",
		[1039] = "Icelandic",
		[1136] = "Igbo - Nigeria",
		[1057] = "Indonesian",
		[66653] = "Inuktitut - Naqittaut",
		[2141] = "Inuktitut (Latin) - Canada",
		[1117] = "Inuktitut",
		[2108] = "Irish",
		[1040] = "Italian - Italy",
		[2064] = "Italian - Switzerland",
		[66576] = "Italian (142)",
		[1041] = "Japanese",
		[1117184] = "Javanese",
		[1099] = "Kannada",
		[1137] = "Kanuri - Nigeria",
		[1120] = "Kashmiri (Arabic)",
		[2144] = "Kashmiri",
		[1087] = "Kazakh",
		[66643] = "Khmer (NIDA)",
		[1107] = "Khmer",
		[1158] = "K'iche",
		[1159] = "Kinyarwanda",
		[1111] = "Konkani",
		[1042] = "Korean",
		[1088] = "Kyrgyz (Cyrillic)",
		[1108] = "Lao",
		[1142] = "Latin",
		[66598] = "Latvian (Legacy)",
		[132134] = "Latvian (Standard)",
		[1062] = "Latvian",
		[461824] = "Lisu (Basic)",
		[527360] = "Lisu (Standard)",
		[132135] = "Lithuanian Standard",
		[1063] = "Lithuanian",
		[66599] = "Lithuanian",
		[1134] = "Luxembourgish",
		[66607] = "Macedonia (FYROM) - Standard",
		[2110] = "Malay - Brunei Darussalam",
		[1086] = "Malay - Malaysia",
		[1100] = "Malayalam",
		[66618] = "Maltese 48-key",
		[1082] = "Maltese",
		[1112] = "Manipuri",
		[1153] = "Maori - New Zealand",
		[1146] = "Mapudungun",
		[1102] = "Marathi",
		[1148] = "Mohawk",
		[1104] = "Mongolian (Cyrillic)",
		[133200] = "Mongolian (Mongolian Script - Standard)",
		[2128] = "Mongolian (Mongolian)",
		[68608] = "Myanmar",
		[2145] = "Nepali - India",
		[1121] = "Nepali",
		[134144] = "New Tai Lue",
		[592896] = "N'ko",
		[1044] = "Norwegian (Bokmal)",
		[2068] = "Norwegian (Nynorsk)",
		[1154] = "Occitan",
		[855040] = "Ol Chiki",
		[986112] = "Old Italic",
		[1096] = "Oriya",
		[1138] = "Oromo",
		[920576] = "Osmanya",
		[1145] = "Papiamentu",
		[1123] = "Pashto",
		[328745] = "Persian (Standard)",
		[658432] = "Phags-pa",
		[66581] = "Polish (214)",
		[1045] = "Polish",
		[1046] = "Portuguese - Brazil",
		[2070] = "Portuguese - Portugal",
		[66582] = "Portuguese (Brazilian ABNT2)",
		[2151] = "Pular - Senegal",
		[2118] = "Punjabi (Pakistan)",
		[1094] = "Punjabi",
		[1131] = "Quecha - Bolivia",
		[2155] = "Quecha - Ecuador",
		[3179] = "Quecha - Peru	CB",
		[1047] = "Rhaeto-Romanic",
		[2072] = "Romanian - Moldava",
		[132120] = "Romanian (Programmers)",
		[66584] = "Romanian (Standard)",
		[1048] = "Romanian",
		[132121] = "Russian - Mnemonic",
		[2073] = "Russian - Moldava",
		[66585] = "Russian (Typewriter)",
		[1049] = "Russian",
		[9275] = "Sami (Inari) - Finland",
		[1083] = "Sami (Lappish)",
		[4155] = "Sami (Lule) - Norway",
		[5179] = "Sami (Lule) - Sweden",
		[3131] = "Sami (Northern) - Finland",
		[2107] = "Sami (Northern) - Sweden",
		[8251] = "Sami (Skolt) - Finland",
		[6203] = "Sami (Southern) - Norway",
		[7227] = "Sami (Southern) - Sweden",
		[133179] = "Sami Extended Finland-Sweden",
		[66619] = "Sami Extended Norway",
		[1103] = "Sanskrit",
		[1084] = "Scottish Gaelic",
		[71689] = "Scottish Gaelic",
		[1132] = "Sepedi",
		[12314] = "Serbian (Cyrillic) - Montenegro",
		[10266] = "Serbian (Cyrillic) - Serbia",
		[3098] = "Serbian (Cyrillic)",
		[6170] = "Serbian (Latin) - Bosnia and Herzegovina",
		[11290] = "Serbian (Latin) - Montenegro",
		[9242] = "Serbian (Latin) - Serbia",
		[2074] = "Serbian (Latin)",
		[1113] = "Sindhi - India",
		[2137] = "Sindhi - Pakistan",
		[66651] = "Sinhala - wij 9",
		[1115] = "Sinhalese - Sri Lanka",
		[66587] = "Slovak (QWERTY)",
		[1051] = "Slovak",
		[1060] = "Slovenian",
		[1143] = "Somali",
		[1051648] = "Sora",
		[66606] = "Sorbian Extended",
		[132142] = "Sorbian Standard",
		[1070] = "Sorbian",
		[11274] = "Spanish - Argentina",
		[16394] = "Spanish - Bolivia",
		[13322] = "Spanish - Chile",
		[9226] = "Spanish - Colombia",
		[5130] = "Spanish - Costa Rica",
		[7178] = "Spanish - Dominican Republic",
		[12298] = "Spanish - Ecuador",
		[17418] = "Spanish - El Salvador",
		[4106] = "Spanish - Guatemala",
		[18442] = "Spanish - Honduras",
		[22538] = "Spanish - Latin America",
		[2058] = "Spanish - Mexico",
		[19466] = "Spanish - Nicaragua",
		[6154] = "Spanish - Panama",
		[15370] = "Spanish - Paraguay",
		[10250] = "Spanish - Peru",
		[20490] = "Spanish - Puerto Rico",
		[3082] = "Spanish - Spain (Modern Sort)",
		[1034] = "Spanish - Spain (Traditional Sort)",
		[21514] = "Spanish - United States",
		[14346] = "Spanish - Uruguay",
		[8202] = "Spanish - Venezuela",
		[66570] = "Spanish Variation",
		[1072] = "Sutu",
		[1089] = "Swahili",
		[2077] = "Swedish - Finland",
		[1053] = "Swedish",
		[66650] = "Syriac Phonetic",
		[1114] = "Syriac",
		[199680] = "Tai Le",
		[1064] = "Tajik",
		[1119] = "Tamazight (Arabic)",
		[2143] = "Tamazight (Latin)",
		[2121] = "Tamil - Sri Lanka",
		[1097] = "Tamil",
		[1092] = "Tatar",
		[66628] = "Tatar",
		[1098] = "Telugu",
		[132126] = "Thai Kedmanee (non-ShiftLock)",
		[197662] = "Thai Pattachote (non-ShiftLock)",
		[66590] = "Thai Pattachote",
		[1054] = "Thai",
		[2129] = "Tibetan - Bhutan",
		[1105] = "Tibetan - People's Republic of China",
		[66641] = "Tibetan (PRC - Standard)",
		[330752] = "Tifinagh (Basic)",
		[396288] = "Tifinagh (Full)",
		[2163] = "Tigrigna - Eritrea",
		[1139] = "Tigrigna - Ethiopia",
		[1073] = "Tsonga",
		[1074] = "Tswana",
		[66591] = "Turkish F",
		[1055] = "Turkish",
		[1090] = "Turkmen",
		[1152] = "Uighur - China",
		[132130] = "Ukrainian (Enhanced)",
		[1058] = "Ukrainian",
		[2080] = "Urdu - India",
		[1056] = "Urdu",
		[66568] = "Uyghur",
		[66688] = "Uyghur",
		[2115] = "Uzbek (Cyrillic)",
		[1091] = "Uzbek (Latin)",
		[1075] = "Venda",
		[1066] = "Vietnamese",
		[1106] = "Welsh",
		[1160] = "Wolof",
		[1076] = "Xhosa",
		[1157] = "Yakut",
		[1144] = "Yi",
		[1085] = "Yiddish",
		[1130] = "Yoruba",
		[1077] = "Zulu",
	} &default = function(n: count): string { return fmt("keyboard-%d", n); };
}
