/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging.internal;

import com.google.api.client.json.GenericJson;
import com.google.api.client.util.Key;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.internal.Nullable;
import com.google.firebase.messaging.MessagingErrorCode;
import java.util.List;
import java.util.Map;

public final class MessagingServiceErrorResponse
extends GenericJson {
    private static final Map<String, MessagingErrorCode> MESSAGING_ERROR_CODES = ImmutableMap.builder().put((Object)"APNS_AUTH_ERROR", (Object)MessagingErrorCode.THIRD_PARTY_AUTH_ERROR).put((Object)"INTERNAL", (Object)MessagingErrorCode.INTERNAL).put((Object)"INVALID_ARGUMENT", (Object)MessagingErrorCode.INVALID_ARGUMENT).put((Object)"QUOTA_EXCEEDED", (Object)MessagingErrorCode.QUOTA_EXCEEDED).put((Object)"SENDER_ID_MISMATCH", (Object)MessagingErrorCode.SENDER_ID_MISMATCH).put((Object)"THIRD_PARTY_AUTH_ERROR", (Object)MessagingErrorCode.THIRD_PARTY_AUTH_ERROR).put((Object)"UNAVAILABLE", (Object)MessagingErrorCode.UNAVAILABLE).put((Object)"UNREGISTERED", (Object)MessagingErrorCode.UNREGISTERED).build();
    private static final String FCM_ERROR_TYPE = "type.googleapis.com/google.firebase.fcm.v1.FcmError";
    @Key(value="error")
    private Map<String, Object> error;

    public String getStatus() {
        if (this.error == null) {
            return null;
        }
        return (String)this.error.get("status");
    }

    @Nullable
    public MessagingErrorCode getMessagingErrorCode() {
        if (this.error == null) {
            return null;
        }
        Object details = this.error.get("details");
        if (details instanceof List) {
            for (Object detail : (List)details) {
                Map detailMap;
                if (!(detail instanceof Map) || !FCM_ERROR_TYPE.equals((detailMap = (Map)detail).get("@type"))) continue;
                String errorCode = (String)detailMap.get("errorCode");
                return MESSAGING_ERROR_CODES.get(errorCode);
            }
        }
        return null;
    }

    @Nullable
    public String getErrorMessage() {
        if (this.error != null) {
            return (String)this.error.get("message");
        }
        return null;
    }
}

