/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseFrameDecoder;
import org.traccar.BasePipelineFactory;
import org.traccar.protocol.NavisProtocolDecoder;

public class NavisFrameDecoder
extends BaseFrameDecoder {
    private static final int NTCB_HEADER_LENGTH = 16;
    private static final int NTCB_LENGTH_OFFSET = 12;
    private static final int FLEX_HEADER_LENGTH = 2;
    private int flexDataSize;

    public void setFlexDataSize(int flexDataSize) {
        this.flexDataSize = flexDataSize;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ByteBuf buf) throws Exception {
        NavisProtocolDecoder protocolDecoder;
        if (buf.getByte(buf.readerIndex()) == 127) {
            return buf.readRetainedSlice(1);
        }
        if (ctx != null && this.flexDataSize == 0 && (protocolDecoder = BasePipelineFactory.getHandler(ctx.pipeline(), NavisProtocolDecoder.class)) != null) {
            this.flexDataSize = protocolDecoder.getFlexDataSize();
        }
        if (this.flexDataSize > 0) {
            if (buf.readableBytes() > 2) {
                String type;
                int length = 0;
                switch (type = buf.toString(buf.readerIndex(), 2, StandardCharsets.US_ASCII)) {
                    case "~A": {
                        length = this.flexDataSize * buf.getByte(buf.readerIndex() + 2) + 1 + 1;
                        break;
                    }
                    case "~T": {
                        length = this.flexDataSize + 4 + 1;
                        break;
                    }
                    case "~C": {
                        length = this.flexDataSize + 1;
                        break;
                    }
                    case "~E": {
                        ++length;
                        for (int i = 0; i < buf.getByte(buf.readerIndex() + 2); ++i) {
                            if (buf.readableBytes() > 2 + length + 1) {
                                length += buf.getUnsignedShort(length + 2) + 2;
                                continue;
                            }
                            return null;
                        }
                        ++length;
                        break;
                    }
                    case "~X": {
                        length = buf.getUnsignedShortLE(buf.readerIndex() + 2) + 4 + 1;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if (buf.readableBytes() >= 2 + length) {
                    return buf.readRetainedSlice(buf.readableBytes());
                }
            }
        } else {
            if (buf.readableBytes() < 16) {
                return null;
            }
            int length = 16 + buf.getUnsignedShortLE(buf.readerIndex() + 12);
            if (buf.readableBytes() >= length) {
                return buf.readRetainedSlice(length);
            }
        }
        return null;
    }
}

