/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.unit;

import java.math.BigDecimal;
import java.util.Objects;
import javax.measure.Unit;
import javax.measure.spi.SystemOfUnits;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.internal.library.unit.CurrencyService;
import org.openhab.core.library.dimension.Currency;
import org.openhab.core.library.dimension.EnergyPrice;
import org.openhab.core.library.unit.CurrencyUnit;
import org.openhab.core.library.unit.Units;
import tech.units.indriya.AbstractSystemOfUnits;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.units.indriya.unit.ProductUnit;

@NonNullByDefault
public final class CurrencyUnits
extends AbstractSystemOfUnits {
    private static final CurrencyUnits INSTANCE = new CurrencyUnits();
    public static final Unit<Currency> BASE_CURRENCY = new CurrencyUnit("DEF", null);
    public static final Unit<EnergyPrice> BASE_ENERGY_PRICE = new ProductUnit(BASE_CURRENCY.divide(Units.KILOWATT_HOUR));

    static {
        CurrencyUnits.addUnit(BASE_CURRENCY);
        CurrencyUnits.INSTANCE.units.add(BASE_ENERGY_PRICE);
    }

    public String getName() {
        return CurrencyUnits.class.getSimpleName();
    }

    public static void addUnit(Unit<Currency> unit) {
        if (!(unit instanceof CurrencyUnit)) {
            throw new IllegalArgumentException("Not an instance of CurrencyUnit");
        }
        CurrencyUnits.INSTANCE.units.add(unit);
        SimpleUnitFormat.getInstance().label(unit, unit.getName());
        String symbol = unit.getSymbol();
        if (symbol != null && !symbol.isBlank()) {
            SimpleUnitFormat.getInstance().alias(unit, symbol);
        }
    }

    public static void removeUnit(Unit<Currency> unit) {
        SimpleUnitFormat.getInstance().removeLabel(unit);
        SimpleUnitFormat.getInstance().removeAliases(unit);
        CurrencyUnits.INSTANCE.units.remove(unit);
    }

    public static SystemOfUnits getInstance() {
        return (SystemOfUnits)Objects.requireNonNull(INSTANCE);
    }

    public static Unit<Currency> createCurrency(String symbol, String name) {
        return new CurrencyUnit(symbol, name);
    }

    public static @Nullable BigDecimal getExchangeRate(Unit<Currency> currency) {
        return CurrencyService.FACTOR_FCN.apply(currency);
    }
}

