/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Provider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.common.Profile;
import org.keycloak.common.Version;
import org.keycloak.common.util.MimeTypeUtil;
import org.keycloak.encoding.ResourceEncodingHelper;
import org.keycloak.encoding.ResourceEncodingProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.cors.Cors;
import org.keycloak.services.resources.KeySource;
import org.keycloak.services.resources.Source;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.services.util.LocaleUtil;
import org.keycloak.theme.Theme;

@Provider
@Path(value="/resources")
public class ThemeResource {
    private static final Logger log = Logger.getLogger(ThemeResource.class);
    private static final Pattern RESOURCE_TAG_PATTERN = Pattern.compile("[0-9a-z]{5}");
    @Context
    private KeycloakSession session;

    @GET
    @Path(value="/{version}/{themeType}/{themeName}/{path:.*}")
    public Response getResource(@PathParam(value="version") String version, @PathParam(value="themeType") String themeType, @PathParam(value="themeName") String themeName, @PathParam(value="path") String path, @HeaderParam(value="If-None-Match") String etag, @Context UriInfo uriInfo) {
        Optional<Theme.Type> type = ThemeResource.getThemeType(themeType);
        if (!version.equals(Version.RESOURCES_VERSION) && !Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ROLLING_UPDATES_V2)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (type.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            ResourceEncodingProvider encodingProvider;
            InputStream resource;
            String contentType = MimeTypeUtil.getContentType((String)path);
            Theme theme = this.session.theme().getTheme(themeName, type.get());
            boolean hasContentHash = theme.hasContentHash(path);
            if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ROLLING_UPDATES_V2)) {
                String base = uriInfo.getBaseUri().getPath();
                base = base.substring(0, base.length() - 1);
                if (!RESOURCE_TAG_PATTERN.matcher(version).matches()) {
                    log.debugf("Illegal version passed, returning a 404: %s", (Object)uriInfo.getRequestUri().getPath());
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
                if (!version.equals(Version.RESOURCES_VERSION) && !hasContentHash) {
                    if (!uriInfo.getRequestUri().toURL().getPath().startsWith(base + UriBuilder.fromResource(ThemeResource.class).path("/{version}/{themeType}/{themeName}/{path}").build(new Object[]{version, themeType, themeName, path}).getPath())) {
                        log.debugf("No URL encoding should be necessary for the path, returning a 404: %s", (Object)uriInfo.getRequestUri().getPath());
                        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                    }
                    URI redirectUri = UriBuilder.fromResource(ThemeResource.class).path("/{version}/{themeType}/{themeName}/{path}").replaceQuery(uriInfo.getRequestUri().getRawQuery()).build(new Object[]{Version.RESOURCES_VERSION, themeType, themeName, path}, false);
                    if (!redirectUri.normalize().equals(redirectUri)) {
                        log.debugf("Redirect URL should not require normalization, returning a 404: %s", (Object)redirectUri.toString());
                        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                    }
                    return Response.temporaryRedirect((URI)redirectUri).build();
                }
                if (hasContentHash && Objects.equals(etag, Version.RESOURCES_VERSION)) {
                    return Response.notModified().header("ETag", (Object)Version.RESOURCES_VERSION).cacheControl(CacheControlUtil.getDefaultCacheControl()).build();
                }
            }
            if ((resource = (encodingProvider = this.session.theme().isCacheEnabled() ? ResourceEncodingHelper.getResourceEncodingProvider(this.session, contentType) : null) != null ? encodingProvider.getEncodedStream(() -> theme.getResourceAsStream(path), themeType, themeName, path.replace('/', File.separatorChar)) : theme.getResourceAsStream(path)) != null) {
                Response.ResponseBuilder rb = Response.ok((Object)resource).type(contentType).cacheControl(CacheControlUtil.getDefaultCacheControl());
                if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ROLLING_UPDATES_V2) && hasContentHash) {
                    rb.header("ETag", (Object)Version.RESOURCES_VERSION);
                }
                if (encodingProvider != null) {
                    rb.encoding(encodingProvider.getEncoding());
                }
                return rb.build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            ServicesLogger.LOGGER.failedToGetThemeRequest(e);
            return Response.serverError().build();
        }
    }

    @Path(value="/{realm}/{themeType}/{locale}")
    @OPTIONS
    public Response localizationTextPreflight() {
        return Cors.builder().auth().preflight().add(Response.ok());
    }

    @GET
    @Path(value="/{realm}/{themeType}/{locale}")
    @Produces(value={"application/json"})
    public Response getLocalizationTexts(@PathParam(value="realm") String realmName, @QueryParam(value="theme") String theme, @PathParam(value="locale") String localeString, @PathParam(value="themeType") String themeType, @QueryParam(value="source") boolean showSource) throws IOException {
        List result;
        RealmModel realm = this.session.realms().getRealmByName(realmName);
        Optional<Theme.Type> type = ThemeResource.getThemeType(themeType);
        if (realm == null || type.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.session.getContext().setRealm(realm);
        Theme theTheme = theme == null ? this.session.theme().getTheme(type.get()) : this.session.theme().getTheme(theme, type.get());
        Locale locale = Locale.forLanguageTag(localeString);
        if (showSource) {
            Properties messagesByLocale = theTheme.getMessages("messages", locale);
            Set resultSet = messagesByLocale.entrySet().stream().map(e -> new KeySource((String)e.getKey(), (String)e.getValue(), Source.THEME)).collect(Collectors.toSet());
            Map<Locale, Properties> realmLocalizationMessages = LocaleUtil.getRealmLocalizationTexts(realm, locale);
            Locale currentLocale = locale;
            while (currentLocale != null) {
                List realmOverride = realmLocalizationMessages.get(currentLocale).entrySet().stream().map(e -> new KeySource((String)e.getKey(), (String)e.getValue(), Source.REALM)).collect(Collectors.toList());
                resultSet.addAll(realmOverride);
                currentLocale = LocaleUtil.getParentLocale(currentLocale, realm);
            }
            result = new ArrayList(resultSet);
        } else {
            result = theTheme.getEnhancedMessages(realm, locale).entrySet().stream().map(e -> new KeySource((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        }
        return Cors.builder().allowAllOrigins().auth().add(Response.ok(result));
    }

    private static Optional<Theme.Type> getThemeType(String themeType) {
        try {
            return Optional.of(Theme.Type.valueOf((String)themeType.toUpperCase()));
        }
        catch (IllegalArgumentException iae) {
            return Optional.empty();
        }
    }
}

