/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.UploadPolicy;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.data.osm.pbf.Blob;
import org.openstreetmap.josm.data.osm.pbf.BlobHeader;
import org.openstreetmap.josm.data.osm.pbf.HeaderBlock;
import org.openstreetmap.josm.data.osm.pbf.Info;
import org.openstreetmap.josm.data.protobuf.ProtobufPacked;
import org.openstreetmap.josm.data.protobuf.ProtobufParser;
import org.openstreetmap.josm.data.protobuf.ProtobufRecord;
import org.openstreetmap.josm.data.protobuf.WireType;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.tools.Utils;

public final class OsmPbfReader
extends AbstractReader {
    private static final long[] EMPTY_LONG = new long[0];
    private static final double NANO_DEGREES = 1.0E-9;
    private static final int MAX_BLOBHEADER_SIZE = 65536;
    private static final int MAX_BLOB_SIZE = 0x2000000;

    private OsmPbfReader() {
    }

    public static DataSet parseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        return new OsmPbfReader().doParseDataSet(source, progressMonitor);
    }

    @Override
    protected DataSet doParseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        return this.doParseDataSet(source, progressMonitor, this::parse);
    }

    private void parse(InputStream source) throws IllegalDataException, IOException {
        BoundedInputStream inputStream = source.markSupported() ? new BoundedInputStream(source) : new BoundedInputStream(new BufferedInputStream(source));
        try (ProtobufParser parser = new ProtobufParser(inputStream);){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            HeaderBlock headerBlock = null;
            BlobHeader blobHeader = null;
            while (parser.hasNext() && !this.cancel) {
                Blob blob;
                if (blobHeader == null) {
                    blobHeader = OsmPbfReader.parseBlobHeader(inputStream, baos, parser);
                    continue;
                }
                if ("OSMHeader".equals(blobHeader.type())) {
                    if (headerBlock != null) {
                        throw new IllegalDataException("Too many header blocks in protobuf");
                    }
                    blob = OsmPbfReader.parseBlob(blobHeader, inputStream, parser, baos);
                    headerBlock = OsmPbfReader.parseHeaderBlock(blob, baos);
                    OsmPbfReader.checkRequiredFeatures(headerBlock);
                    blobHeader = null;
                    continue;
                }
                if (!"OSMData".equals(blobHeader.type())) continue;
                if (headerBlock == null) {
                    throw new IllegalStateException("A header block must occur before the first data block");
                }
                blob = OsmPbfReader.parseBlob(blobHeader, inputStream, parser, baos);
                this.parseDataBlock(baos, headerBlock, blob);
                blobHeader = null;
            }
        }
    }

    @Nonnull
    private static BlobHeader parseBlobHeader(BoundedInputStream cis, ByteArrayOutputStream baos, ProtobufParser parser) throws IOException, IllegalDataException {
        String type = null;
        byte[] indexData = null;
        int datasize = Integer.MIN_VALUE;
        int length = 0;
        long start = cis.getCount();
        block5: while (parser.hasNext() && (length == 0 || cis.getCount() - start < (long)length)) {
            ProtobufRecord current = new ProtobufRecord(baos, parser);
            switch (current.getField()) {
                case 1: {
                    type = current.asString();
                    continue block5;
                }
                case 2: {
                    indexData = current.getBytes();
                    continue block5;
                }
                case 3: {
                    datasize = current.asUnsignedVarInt().intValue();
                    continue block5;
                }
            }
            start = cis.getCount();
            if ((length += current.asUnsignedVarInt().intValue()) <= 65536) continue;
            throw new IllegalDataException("OSM PBF BlobHeader is too large. PBF is probably corrupted. (" + Utils.getSizeString(65536L, Locale.ENGLISH) + " < " + Utils.getSizeString(length, Locale.ENGLISH));
        }
        if (type == null || Integer.MIN_VALUE == datasize) {
            throw new IllegalDataException("OSM PBF BlobHeader could not be read. PBF is probably corrupted.");
        }
        if (datasize > 0x2000000) {
            throw new IllegalDataException("OSM PBF Blob size is too large. PBF is probably corrupted. (" + Utils.getSizeString(0x2000000L, Locale.ENGLISH) + " < " + Utils.getSizeString(datasize, Locale.ENGLISH));
        }
        return new BlobHeader(type, indexData, datasize);
    }

    /*
     * Unable to fully structure code
     */
    @Nonnull
    private static Blob parseBlob(BlobHeader header, BoundedInputStream cis, ProtobufParser parser, ByteArrayOutputStream baos) throws IOException {
        start = cis.getCount();
        size = -2147483648;
        type = null;
        bytes = null;
lbl5:
        // 9 sources

        while (parser.hasNext() && cis.getCount() - start < (long)header.dataSize()) {
            current = new ProtobufRecord(baos, parser);
            try {
                switch (current.getField()) {
                    case 1: {
                        type = Blob.CompressionType.raw;
                        bytes = current.getBytes();
                        ** break;
                    }
                    case 2: {
                        size = current.asUnsignedVarInt().intValue();
                        ** break;
                    }
                    case 3: {
                        type = Blob.CompressionType.zlib;
                        bytes = current.getBytes();
                        ** break;
                    }
                    case 4: {
                        type = Blob.CompressionType.lzma;
                        bytes = current.getBytes();
                        ** break;
                    }
                    case 5: {
                        type = Blob.CompressionType.bzip2;
                        bytes = current.getBytes();
                        ** break;
                    }
                    case 6: {
                        type = Blob.CompressionType.lz4;
                        bytes = current.getBytes();
                        ** break;
                    }
                    case 7: {
                        type = Blob.CompressionType.zstd;
                        bytes = current.getBytes();
                        ** break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown compression type: " + current.getField());
                    }
                }
            }
            finally {
                current.close();
            }
        }
        if (type == null) {
            throw new IllegalStateException("Compression type not found, pbf may be malformed");
        }
        return new Blob(size, type, bytes);
    }

    @Nonnull
    private static HeaderBlock parseHeaderBlock(Blob blob, ByteArrayOutputStream baos) throws IOException {
        try (InputStream blobInput = blob.inputStream();){
            ProtobufParser parser = new ProtobufParser(blobInput);
            try {
                BBox bbox = null;
                ArrayList<String> required = new ArrayList<String>();
                ArrayList<String> optional = new ArrayList<String>();
                String program = null;
                String source = null;
                Long osmosisReplicationTimestamp = null;
                Long osmosisReplicationSequenceNumber = null;
                String osmosisReplicationBaseUrl = null;
                while (parser.hasNext()) {
                    ProtobufRecord current = new ProtobufRecord(baos, parser);
                    switch (current.getField()) {
                        case 1: {
                            bbox = OsmPbfReader.parseBBox(baos, current);
                            break;
                        }
                        case 4: {
                            required.add(current.asString());
                            break;
                        }
                        case 5: {
                            optional.add(current.asString());
                            break;
                        }
                        case 16: {
                            program = current.asString();
                            break;
                        }
                        case 17: {
                            source = current.asString();
                            break;
                        }
                        case 32: {
                            osmosisReplicationTimestamp = current.asSignedVarInt().longValue();
                            break;
                        }
                        case 33: {
                            osmosisReplicationSequenceNumber = current.asSignedVarInt().longValue();
                            break;
                        }
                        case 34: {
                            osmosisReplicationBaseUrl = current.asString();
                            break;
                        }
                    }
                }
                HeaderBlock headerBlock = new HeaderBlock(bbox, required.toArray(new String[0]), optional.toArray(new String[0]), program, source, osmosisReplicationTimestamp, osmosisReplicationSequenceNumber, osmosisReplicationBaseUrl);
                parser.close();
                return headerBlock;
            }
            catch (Throwable throwable) {
                try {
                    parser.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private static void checkRequiredFeatures(HeaderBlock headerBlock) throws IllegalDataException {
        HashSet<String> supportedFeatures = new HashSet<String>(Arrays.asList("OsmSchema-V0.6", "DenseNodes", "HistoricalInformation"));
        for (String requiredFeature : headerBlock.requiredFeatures()) {
            if (supportedFeatures.contains(requiredFeature)) continue;
            throw new IllegalDataException("PBF Parser: Unknown required feature " + requiredFeature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseDataBlock(ByteArrayOutputStream baos, HeaderBlock headerBlock, Blob blob) throws IOException, IllegalDataException {
        String[] stringTable = null;
        ArrayList<ProtobufRecord> primitiveGroups = new ArrayList<ProtobufRecord>();
        int granularity = 100;
        long latOffset = 0L;
        long lonOffset = 0L;
        int dateGranularity = 1000;
        try (InputStream inputStream = blob.inputStream();
             ProtobufParser parser = new ProtobufParser(inputStream);){
            while (parser.hasNext()) {
                ProtobufRecord protobufRecord = new ProtobufRecord(baos, parser);
                switch (protobufRecord.getField()) {
                    case 1: {
                        stringTable = OsmPbfReader.parseStringTable(baos, protobufRecord.getBytes());
                        break;
                    }
                    case 2: {
                        primitiveGroups.add(protobufRecord);
                        break;
                    }
                    case 17: {
                        granularity = protobufRecord.asUnsignedVarInt().intValue();
                        break;
                    }
                    case 18: {
                        dateGranularity = protobufRecord.asUnsignedVarInt().intValue();
                        break;
                    }
                    case 19: {
                        latOffset = protobufRecord.asUnsignedVarInt().longValue();
                        break;
                    }
                    case 20: {
                        lonOffset = protobufRecord.asUnsignedVarInt().longValue();
                        break;
                    }
                }
            }
        }
        PrimitiveBlockRecord primitiveBlockRecord = new PrimitiveBlockRecord(stringTable, granularity, latOffset, lonOffset, dateGranularity);
        DataSet ds = this.getDataSet();
        if (!primitiveGroups.isEmpty() && headerBlock.bbox() != null) {
            try {
                ds.beginUpdate();
                ds.addDataSource(new DataSource(new Bounds((LatLon)headerBlock.bbox().getMin(), (LatLon)headerBlock.bbox().getMax()), headerBlock.source()));
            }
            finally {
                ds.endUpdate();
            }
        }
        for (ProtobufRecord primitiveGroup : primitiveGroups) {
            try {
                ProtobufRecord protobufRecord = primitiveGroup;
                try {
                    ds.beginUpdate();
                    this.parsePrimitiveGroup(baos, primitiveGroup.getBytes(), primitiveBlockRecord);
                }
                finally {
                    if (protobufRecord == null) continue;
                    protobufRecord.close();
                }
            }
            finally {
                ds.endUpdate();
            }
        }
    }

    @Nullable
    private static BBox parseBBox(ByteArrayOutputStream baos, ProtobufRecord current) throws IOException {
        try (ByteArrayInputStream bboxInputStream = new ByteArrayInputStream(current.getBytes());
             ProtobufParser bboxParser = new ProtobufParser(bboxInputStream);){
            double left = Double.NaN;
            double right = Double.NaN;
            double top = Double.NaN;
            double bottom = Double.NaN;
            while (bboxParser.hasNext()) {
                ProtobufRecord protobufRecord = new ProtobufRecord(baos, bboxParser);
                if (protobufRecord.getType() != WireType.VARINT) continue;
                double value = (double)protobufRecord.asSignedVarInt().longValue() * 1.0E-9;
                switch (protobufRecord.getField()) {
                    case 1: {
                        left = value;
                        break;
                    }
                    case 2: {
                        right = value;
                        break;
                    }
                    case 3: {
                        top = value;
                        break;
                    }
                    case 4: {
                        bottom = value;
                        break;
                    }
                }
            }
            if (!(Double.isNaN(left) || Double.isNaN(top) || Double.isNaN(right) || Double.isNaN(bottom))) {
                BBox bBox = new BBox(left, top, right, bottom).toImmutable();
                return bBox;
            }
        }
        return null;
    }

    @Nonnull
    private static String[] parseStringTable(ByteArrayOutputStream baos, byte[] bytes) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
            ProtobufParser parser = new ProtobufParser(is);
            try {
                ArrayList<String> list = new ArrayList<String>();
                while (parser.hasNext()) {
                    ProtobufRecord protobufRecord = new ProtobufRecord(baos, parser);
                    if (protobufRecord.getField() != 1) continue;
                    list.add(protobufRecord.asString().intern());
                }
                String[] stringArray = list.toArray(new String[0]);
                parser.close();
                return stringArray;
            }
            catch (Throwable throwable) {
                try {
                    parser.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void parsePrimitiveGroup(ByteArrayOutputStream baos, byte[] bytes, PrimitiveBlockRecord primitiveBlockRecord) throws IllegalDataException, IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
             ProtobufParser parser = new ProtobufParser(bais);){
            while (parser.hasNext()) {
                ProtobufRecord protobufRecord = new ProtobufRecord(baos, parser);
                switch (protobufRecord.getField()) {
                    case 1: {
                        this.parseNode(baos, protobufRecord.getBytes(), primitiveBlockRecord);
                        break;
                    }
                    case 2: {
                        this.parseDenseNodes(baos, protobufRecord.getBytes(), primitiveBlockRecord);
                        break;
                    }
                    case 3: {
                        this.parseWay(baos, protobufRecord.getBytes(), primitiveBlockRecord);
                        break;
                    }
                    case 4: {
                        this.parseRelation(baos, protobufRecord.getBytes(), primitiveBlockRecord);
                        break;
                    }
                }
            }
        }
    }

    private void parseNode(ByteArrayOutputStream baos, byte[] bytes, PrimitiveBlockRecord primitiveBlockRecord) throws IllegalDataException, IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
             ProtobufParser parser = new ProtobufParser(bais);){
            long id = Long.MIN_VALUE;
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            Info info = null;
            long lat = Long.MIN_VALUE;
            long lon = Long.MIN_VALUE;
            block18: while (parser.hasNext()) {
                ProtobufRecord protobufRecord = new ProtobufRecord(baos, parser);
                switch (protobufRecord.getField()) {
                    case 1: {
                        id = protobufRecord.asSignedVarInt().intValue();
                        break;
                    }
                    case 2: {
                        for (long number : new ProtobufPacked(protobufRecord.getBytes()).getArray()) {
                            keys.add(primitiveBlockRecord.stringTable[(int)number]);
                        }
                        continue block18;
                    }
                    case 3: {
                        for (long number : new ProtobufPacked(protobufRecord.getBytes()).getArray()) {
                            values.add(primitiveBlockRecord.stringTable[(int)number]);
                        }
                        continue block18;
                    }
                    case 4: {
                        info = OsmPbfReader.parseInfo(baos, protobufRecord.getBytes());
                        break;
                    }
                    case 8: {
                        lat = protobufRecord.asSignedVarInt().longValue();
                        break;
                    }
                    case 9: {
                        lon = protobufRecord.asSignedVarInt().longValue();
                        break;
                    }
                }
            }
            if (id == Long.MIN_VALUE || lat == Long.MIN_VALUE || lon == Long.MIN_VALUE) {
                throw new IllegalDataException("OSM PBF did not provide all the required node information");
            }
            NodeData node = new NodeData(id);
            node.setCoor(OsmPbfReader.calculateLatLon(primitiveBlockRecord, lat, lon));
            OsmPbfReader.addTags(node, keys, values);
            if (info != null) {
                OsmPbfReader.setOsmPrimitiveData(primitiveBlockRecord, node, info);
            } else {
                this.ds.setUploadPolicy(UploadPolicy.DISCOURAGED);
            }
            this.buildPrimitive(node);
        }
    }

    private void parseDenseNodes(ByteArrayOutputStream baos, byte[] bytes, PrimitiveBlockRecord primitiveBlockRecord) throws IllegalDataException, IOException {
        long[] ids = EMPTY_LONG;
        long[] lats = EMPTY_LONG;
        long[] lons = EMPTY_LONG;
        long[] keyVals = EMPTY_LONG;
        Info[] denseInfo = null;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
             ProtobufParser parser = new ProtobufParser(bais);){
            while (parser.hasNext()) {
                ProtobufRecord protobufRecord = new ProtobufRecord(baos, parser);
                switch (protobufRecord.getField()) {
                    case 1: {
                        long[] tids = OsmPbfReader.decodePackedSInt64(new ProtobufPacked(protobufRecord.getBytes()).getArray());
                        ids = OsmPbfReader.joinArrays(ids, tids);
                        break;
                    }
                    case 5: {
                        denseInfo = OsmPbfReader.parseDenseInfo(baos, protobufRecord.getBytes());
                        break;
                    }
                    case 8: {
                        long[] tlats = OsmPbfReader.decodePackedSInt64(new ProtobufPacked(protobufRecord.getBytes()).getArray());
                        lats = OsmPbfReader.joinArrays(lats, tlats);
                        break;
                    }
                    case 9: {
                        long[] tlons = OsmPbfReader.decodePackedSInt64(new ProtobufPacked(protobufRecord.getBytes()).getArray());
                        lons = OsmPbfReader.joinArrays(lons, tlons);
                        break;
                    }
                    case 10: {
                        long[] tkeyVal = new ProtobufPacked(protobufRecord.getBytes()).getArray();
                        keyVals = OsmPbfReader.joinArrays(keyVals, tkeyVal);
                        break;
                    }
                }
            }
        }
        int keyValIndex = 0;
        if (ids.length == lats.length && lats.length == lons.length && (denseInfo == null || denseInfo.length == lons.length)) {
            long id = 0L;
            long lat = 0L;
            long lon = 0L;
            for (int i = 0; i < ids.length; ++i) {
                NodeData node = new NodeData(id += ids[i]);
                if (denseInfo != null) {
                    Info info = denseInfo[i];
                    OsmPbfReader.setOsmPrimitiveData(primitiveBlockRecord, node, info);
                } else {
                    this.ds.setUploadPolicy(UploadPolicy.DISCOURAGED);
                }
                node.setCoor(OsmPbfReader.calculateLatLon(primitiveBlockRecord, lat += lats[i], lon += lons[i]));
                String key = null;
                while (keyValIndex < keyVals.length) {
                    int stringIndex = (int)keyVals[keyValIndex];
                    if (stringIndex != 0) {
                        if (key == null) {
                            key = primitiveBlockRecord.stringTable[stringIndex];
                        } else {
                            node.put(key, primitiveBlockRecord.stringTable[stringIndex]);
                            key = null;
                        }
                        ++keyValIndex;
                        continue;
                    }
                    ++keyValIndex;
                    break;
                }
                this.buildPrimitive(node);
            }
        } else {
            throw new IllegalDataException("OSM PBF has mismatched DenseNode lengths");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseWay(ByteArrayOutputStream baos, byte[] bytes, PrimitiveBlockRecord primitiveBlockRecord) throws IllegalDataException, IOException {
        long id = Long.MIN_VALUE;
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        Info info = null;
        long[] refs = EMPTY_LONG;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
             ProtobufParser parser = new ProtobufParser(bais);){
            block17: while (parser.hasNext()) {
                ProtobufRecord protobufRecord = new ProtobufRecord(baos, parser);
                switch (protobufRecord.getField()) {
                    case 1: {
                        id = protobufRecord.asUnsignedVarInt().longValue();
                        break;
                    }
                    case 2: {
                        for (long number : new ProtobufPacked(protobufRecord.getBytes()).getArray()) {
                            keys.add(primitiveBlockRecord.stringTable[(int)number]);
                        }
                        continue block17;
                    }
                    case 3: {
                        for (long number : new ProtobufPacked(protobufRecord.getBytes()).getArray()) {
                            values.add(primitiveBlockRecord.stringTable[(int)number]);
                        }
                        continue block17;
                    }
                    case 4: {
                        info = OsmPbfReader.parseInfo(baos, protobufRecord.getBytes());
                        break;
                    }
                    case 8: {
                        long[] tRefs = OsmPbfReader.decodePackedSInt64(new ProtobufPacked(protobufRecord.getBytes()).getArray());
                        refs = OsmPbfReader.joinArrays(refs, tRefs);
                        break;
                    }
                }
            }
        }
        if (refs.length == 0 || id == Long.MIN_VALUE) {
            throw new IllegalDataException("A way with either no id or no nodes was found");
        }
        WayData wayData = new WayData(id);
        ArrayList<Long> nodeIds = new ArrayList<Long>(refs.length);
        long ref = 0L;
        for (long tRef : refs) {
            nodeIds.add(ref += tRef);
        }
        this.ways.put(wayData.getUniqueId(), nodeIds);
        OsmPbfReader.addTags(wayData, keys, values);
        if (info != null) {
            OsmPbfReader.setOsmPrimitiveData(primitiveBlockRecord, wayData, info);
        } else {
            this.ds.setUploadPolicy(UploadPolicy.DISCOURAGED);
        }
        this.buildPrimitive(wayData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseRelation(ByteArrayOutputStream baos, byte[] bytes, PrimitiveBlockRecord primitiveBlockRecord) throws IllegalDataException, IOException {
        long id = Long.MIN_VALUE;
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        Info info = null;
        long[] rolesStringId = EMPTY_LONG;
        long[] memids = EMPTY_LONG;
        long[] types = EMPTY_LONG;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
             ProtobufParser parser = new ProtobufParser(bais);){
            block19: while (parser.hasNext()) {
                ProtobufRecord protobufRecord = new ProtobufRecord(baos, parser);
                switch (protobufRecord.getField()) {
                    case 1: {
                        id = protobufRecord.asUnsignedVarInt().longValue();
                        break;
                    }
                    case 2: {
                        for (long number : new ProtobufPacked(protobufRecord.getBytes()).getArray()) {
                            keys.add(primitiveBlockRecord.stringTable[(int)number]);
                        }
                        continue block19;
                    }
                    case 3: {
                        for (long number : new ProtobufPacked(protobufRecord.getBytes()).getArray()) {
                            values.add(primitiveBlockRecord.stringTable[(int)number]);
                        }
                        continue block19;
                    }
                    case 4: {
                        info = OsmPbfReader.parseInfo(baos, protobufRecord.getBytes());
                        break;
                    }
                    case 8: {
                        long[] tRoles = new ProtobufPacked(protobufRecord.getBytes()).getArray();
                        rolesStringId = OsmPbfReader.joinArrays(rolesStringId, tRoles);
                        break;
                    }
                    case 9: {
                        long[] tMemids = OsmPbfReader.decodePackedSInt64(new ProtobufPacked(protobufRecord.getBytes()).getArray());
                        memids = OsmPbfReader.joinArrays(memids, tMemids);
                        break;
                    }
                    case 10: {
                        long[] tTypes = new ProtobufPacked(protobufRecord.getBytes()).getArray();
                        types = OsmPbfReader.joinArrays(types, tTypes);
                        break;
                    }
                }
            }
        }
        if (keys.size() != values.size() || rolesStringId.length != memids.length || memids.length != types.length || id == Long.MIN_VALUE) {
            throw new IllegalDataException("OSM PBF contains a bad relation definition");
        }
        RelationData data = new RelationData(id);
        if (info != null) {
            OsmPbfReader.setOsmPrimitiveData(primitiveBlockRecord, data, info);
        } else {
            this.ds.setUploadPolicy(UploadPolicy.DISCOURAGED);
        }
        OsmPbfReader.addTags(data, keys, values);
        OsmPrimitiveType[] valueTypes = OsmPrimitiveType.values();
        ArrayList<RelationMemberData> members = new ArrayList<RelationMemberData>(rolesStringId.length);
        long memberId = 0L;
        int i = 0;
        while (true) {
            if (i >= rolesStringId.length) {
                this.relations.put(data.getUniqueId(), members);
                this.buildPrimitive(data);
                return;
            }
            String role = primitiveBlockRecord.stringTable[(int)rolesStringId[i]];
            OsmPrimitiveType type = valueTypes[(int)types[i]];
            members.add(new RelationMemberData(role, type, memberId += memids[i]));
            ++i;
        }
    }

    @Nonnull
    private static Info parseInfo(ByteArrayOutputStream baos, byte[] bytes) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            ProtobufParser parser = new ProtobufParser(bais);
            try {
                int version = -1;
                Long timestamp = null;
                Long changeset = null;
                Integer uid = null;
                Integer userSid = null;
                boolean visible = true;
                while (parser.hasNext()) {
                    ProtobufRecord protobufRecord = new ProtobufRecord(baos, parser);
                    switch (protobufRecord.getField()) {
                        case 1: {
                            version = protobufRecord.asUnsignedVarInt().intValue();
                            break;
                        }
                        case 2: {
                            timestamp = protobufRecord.asUnsignedVarInt().longValue();
                            break;
                        }
                        case 3: {
                            changeset = protobufRecord.asUnsignedVarInt().longValue();
                            break;
                        }
                        case 4: {
                            uid = protobufRecord.asUnsignedVarInt().intValue();
                            break;
                        }
                        case 5: {
                            userSid = protobufRecord.asUnsignedVarInt().intValue();
                            break;
                        }
                        case 6: {
                            visible = protobufRecord.asUnsignedVarInt().byteValue() == 1;
                            break;
                        }
                    }
                }
                Info info = new Info(version, timestamp, changeset, uid, userSid, visible);
                parser.close();
                return info;
            }
            catch (Throwable throwable) {
                try {
                    parser.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    @Nonnull
    private static LatLon calculateLatLon(PrimitiveBlockRecord primitiveBlockRecord, long lat, long lon) {
        return new LatLon(1.0E-9 * (double)(primitiveBlockRecord.latOffset + (long)primitiveBlockRecord.granularity * lat), 1.0E-9 * (double)(primitiveBlockRecord.lonOffset + (long)primitiveBlockRecord.granularity * lon));
    }

    private static void addTags(Tagged primitive, List<String> keys, List<String> values) {
        if (keys.isEmpty()) {
            return;
        }
        HashMap<String, String> tagMap = new HashMap<String, String>(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            tagMap.put(keys.get(i), values.get(i));
        }
        primitive.putAll(tagMap);
    }

    private static void setOsmPrimitiveData(PrimitiveBlockRecord primitiveBlockRecord, PrimitiveData primitive, Info info) {
        primitive.setVisible(info.isVisible());
        if (info.timestamp() != null) {
            primitive.setRawTimestamp(Math.toIntExact(info.timestamp() * (long)primitiveBlockRecord.dateGranularity / 1000L));
        }
        if (info.uid() != null && info.userSid() != null) {
            primitive.setUser(User.createOsmUser(info.uid().intValue(), primitiveBlockRecord.stringTable[info.userSid()]));
        } else if (info.uid() != null) {
            primitive.setUser(User.getById(info.uid().intValue()));
        }
        if (info.version() > 0) {
            primitive.setVersion(info.version());
        }
        if (info.changeset() != null) {
            primitive.setChangesetId(Math.toIntExact(info.changeset()));
        }
    }

    @Nonnull
    private static long[] decodePackedSInt64(long[] numbers) {
        for (int i = 0; i < numbers.length; ++i) {
            numbers[i] = ProtobufParser.decodeZigZag(numbers[i]);
        }
        return numbers;
    }

    @Nonnull
    private static long[] joinArrays(long[] array1, long[] array2) {
        if (array1.length == 0) {
            return array2;
        }
        if (array2.length == 0) {
            return array1;
        }
        long[] result = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    @Nonnull
    private static Info[] parseDenseInfo(ByteArrayOutputStream baos, byte[] bytes) throws IllegalDataException, IOException {
        long[] version = EMPTY_LONG;
        long[] timestamp = EMPTY_LONG;
        long[] changeset = EMPTY_LONG;
        long[] uid = EMPTY_LONG;
        long[] userSid = EMPTY_LONG;
        long[] visible = EMPTY_LONG;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
             ProtobufParser parser = new ProtobufParser(bais);){
            while (parser.hasNext()) {
                ProtobufRecord protobufRecord = new ProtobufRecord(baos, parser);
                switch (protobufRecord.getField()) {
                    case 1: {
                        long[] tVersion = new ProtobufPacked(protobufRecord.getBytes()).getArray();
                        version = OsmPbfReader.joinArrays(version, tVersion);
                        break;
                    }
                    case 2: {
                        long[] tTimestamp = OsmPbfReader.decodePackedSInt64(new ProtobufPacked(protobufRecord.getBytes()).getArray());
                        timestamp = OsmPbfReader.joinArrays(timestamp, tTimestamp);
                        break;
                    }
                    case 3: {
                        long[] tChangeset = OsmPbfReader.decodePackedSInt64(new ProtobufPacked(protobufRecord.getBytes()).getArray());
                        changeset = OsmPbfReader.joinArrays(changeset, tChangeset);
                        break;
                    }
                    case 4: {
                        long[] tUid = OsmPbfReader.decodePackedSInt64(new ProtobufPacked(protobufRecord.getBytes()).getArray());
                        uid = OsmPbfReader.joinArrays(uid, tUid);
                        break;
                    }
                    case 5: {
                        long[] tUserSid = OsmPbfReader.decodePackedSInt64(new ProtobufPacked(protobufRecord.getBytes()).getArray());
                        userSid = OsmPbfReader.joinArrays(userSid, tUserSid);
                        break;
                    }
                    case 6: {
                        long[] tVisible = new ProtobufPacked(protobufRecord.getBytes()).getArray();
                        visible = OsmPbfReader.joinArrays(visible, tVisible);
                        break;
                    }
                }
            }
        }
        if (version.length > 0) {
            Info[] infos = new Info[version.length];
            long lastTimestamp = 0L;
            long lastChangeset = 0L;
            long lastUid = 0L;
            long lastUserSid = 0L;
            for (int i = 0; i < version.length; ++i) {
                if (timestamp.length > i) {
                    lastTimestamp += timestamp[i];
                }
                if (changeset.length > i) {
                    lastChangeset += changeset[i];
                }
                if (uid.length > i && userSid.length > i) {
                    lastUid += uid[i];
                    lastUserSid += userSid[i];
                }
                infos[i] = new Info((int)version[i], lastTimestamp, lastChangeset, (int)lastUid, (int)lastUserSid, visible == EMPTY_LONG || visible[i] == 1L);
            }
            return infos;
        }
        throw new IllegalDataException("OSM PBF has mismatched DenseInfo lengths");
    }

    private static final class PrimitiveBlockRecord {
        private final String[] stringTable;
        private final int granularity;
        private final long latOffset;
        private final long lonOffset;
        private final int dateGranularity;

        PrimitiveBlockRecord(String[] stringTable, int granularity, long latOffset, long lonOffset, int dateGranularity) {
            this.stringTable = stringTable;
            this.granularity = granularity;
            this.latOffset = latOffset;
            this.lonOffset = lonOffset;
            this.dateGranularity = dateGranularity;
        }
    }

    private static final class BoundedInputStream
    extends InputStream {
        private final InputStream source;
        private long count;
        private long mark;

        BoundedInputStream(InputStream source) {
            this.source = source;
        }

        @Override
        public int read() throws IOException {
            int read = this.source.read();
            if (read > 0) {
                ++this.count;
            }
            return read;
        }

        @Override
        public int read(@Nonnull byte[] b, int off, int len) throws IOException {
            int read = this.source.read(b, off, len);
            if (read > 0) {
                this.count += (long)read;
            }
            return read;
        }

        @Override
        public long skip(long n) throws IOException {
            long skipped = super.skip(n);
            this.count += skipped;
            return skipped;
        }

        @Override
        public int available() throws IOException {
            return this.source.available();
        }

        @Override
        public void close() throws IOException {
            this.source.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.source.mark(readlimit);
            this.mark = this.count;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.source.reset();
            this.count = this.mark;
        }

        @Override
        public boolean markSupported() {
            return this.source.markSupported();
        }

        long getCount() {
            return this.count;
        }
    }
}

