/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.FIFOBandwidthRefiller;
import net.i2p.router.util.PQEntry;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class FIFOBandwidthLimiter {
    private final Log _log;
    private final RouterContext _context;
    private final List<SimpleRequest> _pendingInboundRequests;
    private final List<SimpleRequest> _pendingOutboundRequests;
    private final AtomicInteger _availableInbound = new AtomicInteger();
    private final AtomicInteger _availableOutbound = new AtomicInteger();
    private final AtomicInteger _unavailableInboundBurst = new AtomicInteger();
    private final AtomicInteger _unavailableOutboundBurst = new AtomicInteger();
    private int _maxInboundBurst;
    private int _maxOutboundBurst;
    private int _maxInbound;
    private int _maxOutbound;
    private boolean _outboundUnlimited;
    private boolean _inboundUnlimited;
    private final AtomicLong _totalAllocatedInboundBytes = new AtomicLong();
    private final AtomicLong _totalAllocatedOutboundBytes = new AtomicLong();
    private static final AtomicLong __requestId = new AtomicLong();
    private final FIFOBandwidthRefiller _refiller;
    private final Thread _refillerThread;
    private long _lastTotalSent;
    private long _lastTotalReceived;
    private long _lastStatsUpdated;
    private float _sendBps;
    private float _recvBps;
    private float _sendBps15s;
    private float _recvBps15s;
    private static final NoopRequest _noop = new NoopRequest();

    public long now() {
        return System.currentTimeMillis();
    }

    public FIFOBandwidthLimiter(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(FIFOBandwidthLimiter.class);
        this._context.statManager().createRateStat("bwLimiter.pendingOutboundRequests", "How many outbound requests are ahead of the current one (ignoring ones with 0)?", "BandwidthLimiter", new long[]{300000L, 3600000L});
        this._context.statManager().createRateStat("bwLimiter.pendingInboundRequests", "How many inbound requests are ahead of the current one (ignoring ones with 0)?", "BandwidthLimiter", new long[]{300000L, 3600000L});
        this._context.statManager().createRateStat("bwLimiter.outboundDelayedTime", "How long it takes to honor an outbound request (ignoring ones with that go instantly)?", "BandwidthLimiter", new long[]{300000L, 3600000L});
        this._context.statManager().createRateStat("bwLimiter.inboundDelayedTime", "How long it takes to honor an inbound request (ignoring ones with that go instantly)?", "BandwidthLimiter", new long[]{300000L, 3600000L});
        this._pendingInboundRequests = new ArrayList<SimpleRequest>(16);
        this._pendingOutboundRequests = new ArrayList<SimpleRequest>(16);
        this._lastTotalSent = this._totalAllocatedOutboundBytes.get();
        this._lastTotalReceived = this._totalAllocatedInboundBytes.get();
        this._lastStatsUpdated = this.now();
        this._refiller = new FIFOBandwidthRefiller(this._context, this);
        this._refillerThread = new I2PThread(this._refiller, "BWRefiller", true);
        this._refillerThread.setPriority(6);
        this._refillerThread.start();
    }

    public long getTotalAllocatedInboundBytes() {
        return this._totalAllocatedInboundBytes.get();
    }

    public long getTotalAllocatedOutboundBytes() {
        return this._totalAllocatedOutboundBytes.get();
    }

    @Deprecated
    void setInboundUnlimited(boolean isUnlimited) {
        this._inboundUnlimited = isUnlimited;
    }

    @Deprecated
    void setOutboundUnlimited(boolean isUnlimited) {
        this._outboundUnlimited = isUnlimited;
    }

    public float getSendBps() {
        return this._sendBps;
    }

    public float getReceiveBps() {
        return this._recvBps;
    }

    public float getSendBps15s() {
        return this._sendBps15s;
    }

    public float getReceiveBps15s() {
        return this._recvBps15s;
    }

    public int getOutboundKBytesPerSecond() {
        return this._refiller.getOutboundKBytesPerSecond();
    }

    public int getInboundKBytesPerSecond() {
        return this._refiller.getInboundKBytesPerSecond();
    }

    public int getOutboundBurstKBytesPerSecond() {
        return this._refiller.getOutboundBurstKBytesPerSecond();
    }

    public int getInboundBurstKBytesPerSecond() {
        return this._refiller.getInboundBurstKBytesPerSecond();
    }

    public synchronized void reinitialize() {
        this.clear();
        this._refiller.reinitialize();
    }

    public synchronized void shutdown() {
        this._refiller.shutdown();
        this._refillerThread.interrupt();
        this.clear();
    }

    private void clear() {
        this._pendingInboundRequests.clear();
        this._pendingOutboundRequests.clear();
        this._availableInbound.set(0);
        this._availableOutbound.set(0);
        this._maxInbound = 0;
        this._maxOutbound = 0;
        this._maxInboundBurst = 0;
        this._maxOutboundBurst = 0;
        this._unavailableInboundBurst.set(0);
        this._unavailableOutboundBurst.set(0);
    }

    public boolean sentParticipatingMessage(int size, float factor) {
        return this._refiller.incrementParticipatingMessageBytes(size, factor);
    }

    public int getCurrentParticipatingBandwidth() {
        return this._refiller.getCurrentParticipatingBandwidth();
    }

    public Request requestInbound(int bytesIn, String purpose) {
        if (this.shortcutSatisfyInboundRequest(bytesIn)) {
            return _noop;
        }
        SimpleRequest req = new SimpleRequest(bytesIn, 0);
        this.requestInbound(req, bytesIn, purpose);
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestInbound(SimpleRequest req, int bytesIn, String purpose) {
        int pending;
        List<SimpleRequest> list = this._pendingInboundRequests;
        synchronized (list) {
            pending = this._pendingInboundRequests.size();
            this._pendingInboundRequests.add(req);
        }
        this.satisfyInboundRequests(req.satisfiedBuffer);
        req.satisfiedBuffer.clear();
        if (pending > 0) {
            this._context.statManager().addRateData("bwLimiter.pendingInboundRequests", pending);
        }
    }

    public Request requestOutbound(int bytesOut, int priority, String purpose) {
        if (this.shortcutSatisfyOutboundRequest(bytesOut)) {
            return _noop;
        }
        SimpleRequest req = new SimpleRequest(bytesOut, priority);
        this.requestOutbound(req, bytesOut, purpose);
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestOutbound(SimpleRequest req, int bytesOut, String purpose) {
        int pending;
        List<SimpleRequest> list = this._pendingOutboundRequests;
        synchronized (list) {
            pending = this._pendingOutboundRequests.size();
            this._pendingOutboundRequests.add(req);
        }
        this.satisfyOutboundRequests(req.satisfiedBuffer);
        req.satisfiedBuffer.clear();
        if (pending > 0) {
            this._context.statManager().addRateData("bwLimiter.pendingOutboundRequests", pending);
        }
    }

    void setInboundBurstKBps(int kbytesPerSecond) {
        this._maxInbound = kbytesPerSecond * 1024;
    }

    void setOutboundBurstKBps(int kbytesPerSecond) {
        this._maxOutbound = kbytesPerSecond * 1024;
    }

    public int getInboundBurstBytes() {
        return this._maxInboundBurst;
    }

    public int getOutboundBurstBytes() {
        return this._maxOutboundBurst;
    }

    void setInboundBurstBytes(int bytes) {
        this._maxInboundBurst = bytes;
    }

    void setOutboundBurstBytes(int bytes) {
        this._maxOutboundBurst = bytes;
    }

    StringBuilder getStatus() {
        StringBuilder rv = new StringBuilder(128);
        rv.append("Available: ").append(this._availableInbound).append('/').append(this._availableOutbound);
        rv.append(" Max: ").append(this._maxInbound).append('/').append(this._maxOutbound);
        rv.append(" Burst: ").append(this._unavailableInboundBurst).append('/').append(this._unavailableOutboundBurst);
        rv.append(" Burst max: ").append(this._maxInboundBurst).append('/').append(this._maxOutboundBurst);
        return rv;
    }

    private StringBuilder getInboundStatus() {
        StringBuilder rv = new StringBuilder(128);
        rv.append("Available: ").append(this._availableInbound);
        rv.append(" Max: ").append(this._maxInbound);
        rv.append(" Burst: ").append(this._unavailableInboundBurst);
        rv.append(" Burst max: ").append(this._maxInboundBurst);
        return rv;
    }

    private StringBuilder getOutboundStatus() {
        StringBuilder rv = new StringBuilder(128);
        rv.append("Available: ").append(this._availableOutbound);
        rv.append(" Max: ").append(this._maxOutbound);
        rv.append(" Burst: ").append(this._unavailableOutboundBurst);
        rv.append(" Burst max: ").append(this._maxOutboundBurst);
        return rv;
    }

    final void refillBandwidthQueues(List<Request> buf, long bytesInbound, long bytesOutbound, long maxBurstIn, long maxBurstOut) {
        int avi = this._availableInbound.addAndGet((int)bytesInbound);
        if (avi > this._maxInbound) {
            int uib = this._unavailableInboundBurst.addAndGet(avi - this._maxInbound);
            this._availableInbound.set(this._maxInbound);
            if (uib > this._maxInboundBurst) {
                this._unavailableInboundBurst.set(this._maxInboundBurst);
            }
        } else {
            int want = (int)maxBurstIn;
            if (want > this._maxInbound - avi) {
                want = this._maxInbound - avi;
            }
            if (want > 0) {
                int uib = this._unavailableInboundBurst.get();
                if (want <= uib) {
                    this._availableInbound.addAndGet(want);
                    this._unavailableInboundBurst.addAndGet(0 - want);
                } else {
                    this._availableInbound.addAndGet(uib);
                    this._unavailableInboundBurst.set(0);
                }
            }
        }
        int avo = this._availableOutbound.addAndGet((int)bytesOutbound);
        if (avo > this._maxOutbound) {
            int uob = this._unavailableOutboundBurst.getAndAdd(avo - this._maxOutbound);
            this._availableOutbound.set(this._maxOutbound);
            if (uob > this._maxOutboundBurst) {
                this._unavailableOutboundBurst.set(this._maxOutboundBurst);
            }
        } else {
            int want = (int)maxBurstOut;
            if (want > this._maxOutbound - avo) {
                want = this._maxOutbound - avo;
            }
            if (want > 0) {
                int uob = this._unavailableOutboundBurst.get();
                if (want <= uob) {
                    this._availableOutbound.addAndGet(want);
                    this._unavailableOutboundBurst.addAndGet(0 - want);
                } else {
                    this._availableOutbound.addAndGet(uob);
                    this._unavailableOutboundBurst.set(0);
                }
            }
        }
        this.satisfyRequests(buf);
        this.updateStats();
    }

    private void updateStats() {
        long now = this.now();
        long time = now - this._lastStatsUpdated;
        if (time >= 1000L) {
            long totS = this._totalAllocatedOutboundBytes.get();
            long totR = this._totalAllocatedInboundBytes.get();
            long sent = totS - this._lastTotalSent;
            long recv = totR - this._lastTotalReceived;
            this._lastTotalSent = totS;
            this._lastTotalReceived = totR;
            this._lastStatsUpdated = now;
            this._sendBps = this._sendBps <= 0.0f ? (float)sent * 1000.0f / (float)time : 0.9f * this._sendBps + 0.1f * ((float)sent * 1000.0f) / (float)time;
            this._recvBps = this._recvBps <= 0.0f ? (float)recv * 1000.0f / (float)time : 0.9f * this._recvBps + 0.1f * ((float)recv * 1000.0f) / (float)time;
            this._sendBps15s = 0.955f * this._sendBps15s + 0.045f * ((float)sent * 1000.0f) / (float)time;
            this._recvBps15s = 0.955f * this._recvBps15s + 0.045f * ((float)recv * 1000.0f) / (float)time;
        }
    }

    private final void satisfyRequests(List<Request> buffer) {
        buffer.clear();
        this.satisfyInboundRequests(buffer);
        buffer.clear();
        this.satisfyOutboundRequests(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void satisfyInboundRequests(List<Request> satisfied) {
        List<SimpleRequest> list = this._pendingInboundRequests;
        synchronized (list) {
            if (this._inboundUnlimited) {
                this.locked_satisfyInboundUnlimited(satisfied);
            } else if (this._availableInbound.get() > 0) {
                this.locked_satisfyInboundAvailable(satisfied);
            } else if (this._log.shouldLog(10)) {
                this._log.debug("Denying " + this._pendingInboundRequests.size() + " pending inbound requests (status: " + this.getInboundStatus() + ", longest waited " + this.locked_getLongestInboundWait() + ')');
            }
        }
        if (satisfied != null) {
            for (int i = 0; i < satisfied.size(); ++i) {
                SimpleRequest creq = (SimpleRequest)satisfied.get(i);
                creq.notifyAllocation();
            }
        }
    }

    private long locked_getLongestInboundWait() {
        long start = -1L;
        for (int i = 0; i < this._pendingInboundRequests.size(); ++i) {
            Request req = this._pendingInboundRequests.get(i);
            if (start >= 0L && start <= req.getRequestTime()) continue;
            start = req.getRequestTime();
        }
        if (start == -1L) {
            return 0L;
        }
        return this.now() - start;
    }

    private long locked_getLongestOutboundWait() {
        long start = -1L;
        for (int i = 0; i < this._pendingOutboundRequests.size(); ++i) {
            Request req = this._pendingOutboundRequests.get(i);
            if (req == null || start >= 0L && start <= req.getRequestTime()) continue;
            start = req.getRequestTime();
        }
        if (start == -1L) {
            return 0L;
        }
        return this.now() - start;
    }

    private final void locked_satisfyInboundUnlimited(List<Request> satisfied) {
        while (!this._pendingInboundRequests.isEmpty()) {
            SimpleRequest req = this._pendingInboundRequests.remove(0);
            int allocated = req.getPendingRequested();
            this._totalAllocatedInboundBytes.addAndGet(allocated);
            req.allocateBytes(allocated);
            satisfied.add(req);
            long waited = this.now() - req.getRequestTime();
            if (this._log.shouldLog(10)) {
                this._log.debug("Granting inbound request " + req + " fully (waited " + waited + "ms) pending " + this._pendingInboundRequests.size());
            }
            if (waited <= 10L) continue;
            this._context.statManager().addRateData("bwLimiter.inboundDelayedTime", waited);
        }
    }

    private final void locked_satisfyInboundAvailable(List<Request> satisfied) {
        for (int i = 0; i < this._pendingInboundRequests.size(); ++i) {
            SimpleRequest req = this._pendingInboundRequests.get(i);
            long waited = this.now() - req.getRequestTime();
            if (req.getAborted()) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Aborting inbound request to " + req + " waited " + waited + "ms) pending " + this._pendingInboundRequests.size());
                }
                this._pendingInboundRequests.remove(i);
                --i;
                continue;
            }
            int avi = this._availableInbound.get();
            if (avi <= 0) break;
            int requested = req.getPendingRequested();
            int allocated = avi >= requested ? requested : avi;
            this._availableInbound.addAndGet(0 - allocated);
            this._totalAllocatedInboundBytes.addAndGet(allocated);
            req.allocateBytes(allocated);
            satisfied.add(req);
            if (req.getPendingRequested() > 0) {
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Allocating " + allocated + " bytes inbound as a partial grant to " + req + " waited " + waited + "ms) pending " + this._pendingInboundRequests.size() + ", longest waited " + this.locked_getLongestInboundWait() + " in");
                continue;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Allocating " + allocated + " bytes inbound to finish the partial grant to " + req + " waited " + waited + "ms) pending " + this._pendingInboundRequests.size() + ", longest waited " + this.locked_getLongestInboundWait() + " out");
            }
            this._pendingInboundRequests.remove(i);
            --i;
            if (waited <= 10L) continue;
            this._context.statManager().addRateData("bwLimiter.inboundDelayedTime", waited);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void satisfyOutboundRequests(List<Request> satisfied) {
        List<SimpleRequest> list = this._pendingOutboundRequests;
        synchronized (list) {
            if (this._outboundUnlimited) {
                this.locked_satisfyOutboundUnlimited(satisfied);
            } else if (this._availableOutbound.get() > 0) {
                this.locked_satisfyOutboundAvailable(satisfied);
            } else if (this._log.shouldLog(20)) {
                this._log.info("Denying " + this._pendingOutboundRequests.size() + " pending outbound requests (status: " + this.getOutboundStatus() + ", longest waited " + this.locked_getLongestOutboundWait() + ')');
            }
        }
        if (satisfied != null) {
            for (int i = 0; i < satisfied.size(); ++i) {
                SimpleRequest creq = (SimpleRequest)satisfied.get(i);
                creq.notifyAllocation();
            }
        }
    }

    private final void locked_satisfyOutboundUnlimited(List<Request> satisfied) {
        while (!this._pendingOutboundRequests.isEmpty()) {
            SimpleRequest req = this._pendingOutboundRequests.remove(0);
            int allocated = req.getPendingRequested();
            this._totalAllocatedOutboundBytes.addAndGet(allocated);
            req.allocateBytes(allocated);
            satisfied.add(req);
            long waited = this.now() - req.getRequestTime();
            if (this._log.shouldLog(10)) {
                this._log.debug("Granting outbound request " + req + " fully (waited " + waited + "ms) pending " + this._pendingOutboundRequests.size() + ", longest waited " + this.locked_getLongestOutboundWait() + " out");
            }
            if (waited <= 10L) continue;
            this._context.statManager().addRateData("bwLimiter.outboundDelayedTime", waited);
        }
    }

    private final void locked_satisfyOutboundAvailable(List<Request> satisfied) {
        for (int i = 0; i < this._pendingOutboundRequests.size(); ++i) {
            SimpleRequest req = this._pendingOutboundRequests.get(i);
            long waited = this.now() - req.getRequestTime();
            if (req.getAborted()) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Aborting outbound request to " + req + " waited " + waited + "ms) pending " + this._pendingOutboundRequests.size());
                }
                this._pendingOutboundRequests.remove(i);
                --i;
                continue;
            }
            int avo = this._availableOutbound.get();
            if (avo <= 0) break;
            int requested = req.getPendingRequested();
            int allocated = avo >= requested ? requested : avo;
            this._availableOutbound.addAndGet(0 - allocated);
            this._totalAllocatedOutboundBytes.addAndGet(allocated);
            req.allocateBytes(allocated);
            satisfied.add(req);
            if (req.getPendingRequested() > 0) {
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Allocating " + allocated + " bytes outbound as a partial grant to " + req + " waited " + waited + "ms) pending " + this._pendingOutboundRequests.size() + ", longest waited " + this.locked_getLongestOutboundWait() + " out");
                continue;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Allocating " + allocated + " bytes outbound to finish the partial grant to " + req + " waited " + waited + "ms) pending " + this._pendingOutboundRequests.size() + ", longest waited " + this.locked_getLongestOutboundWait() + " out)");
            }
            this._pendingOutboundRequests.remove(i);
            --i;
            if (waited <= 10L) continue;
            this._context.statManager().addRateData("bwLimiter.outboundDelayedTime", waited);
        }
    }

    private boolean shortcutSatisfyInboundRequest(int requested) {
        boolean rv;
        boolean bl = rv = this._inboundUnlimited || this._pendingInboundRequests.isEmpty() && this._availableInbound.get() >= requested;
        if (rv) {
            this._availableInbound.addAndGet(0 - requested);
            this._totalAllocatedInboundBytes.addAndGet(requested);
        }
        return rv;
    }

    private boolean shortcutSatisfyOutboundRequest(int requested) {
        boolean rv;
        boolean bl = rv = this._outboundUnlimited || this._pendingOutboundRequests.isEmpty() && this._availableOutbound.get() >= requested;
        if (rv) {
            this._availableOutbound.addAndGet(0 - requested);
            this._totalAllocatedOutboundBytes.addAndGet(requested);
        }
        return rv;
    }

    @Deprecated
    public void renderStatusHTML(Writer out) throws IOException {
    }

    private static class NoopRequest
    implements Request {
        private NoopRequest() {
        }

        @Override
        public void abort() {
        }

        @Override
        public boolean getAborted() {
            return false;
        }

        @Override
        public int getPendingRequested() {
            return 0;
        }

        public String toString() {
            return "noop";
        }

        @Override
        public long getRequestTime() {
            return 0L;
        }

        @Override
        public int getTotalRequested() {
            return 0;
        }

        @Override
        public void waitForNextAllocation() {
        }

        @Override
        public CompleteListener getCompleteListener() {
            return null;
        }

        @Override
        public void setCompleteListener(CompleteListener lsnr) {
            lsnr.complete(this);
        }

        @Override
        public void attach(Object obj) {
            throw new UnsupportedOperationException("Don't attach to a satisfied request");
        }

        @Override
        public Object attachment() {
            return null;
        }

        @Override
        public int getPriority() {
            return 0;
        }

        @Override
        public void setSeqNum(long num) {
        }

        @Override
        public long getSeqNum() {
            return 0L;
        }
    }

    private static class SimpleRequest
    implements Request {
        private int _allocated;
        private final int _total;
        private final long _requestId;
        private final long _requestTime;
        private int _allocationsSinceWait;
        private boolean _aborted;
        private boolean _waited;
        final List<Request> satisfiedBuffer = new ArrayList<Request>(1);
        private CompleteListener _lsnr;
        private Object _attachment;
        private final int _priority;

        public SimpleRequest(int bytes, int priority) {
            this._total = bytes;
            this._priority = priority;
            this._requestTime = System.currentTimeMillis();
            this._requestId = __requestId.incrementAndGet();
        }

        @Override
        public long getRequestTime() {
            return this._requestTime;
        }

        @Override
        public int getTotalRequested() {
            return this._total;
        }

        @Override
        public synchronized int getPendingRequested() {
            return this._total - this._allocated;
        }

        @Override
        public boolean getAborted() {
            return this._aborted;
        }

        @Override
        public synchronized void abort() {
            this._aborted = true;
            this._allocated = this._total;
            this.notifyAllocation();
        }

        @Override
        public CompleteListener getCompleteListener() {
            return this._lsnr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCompleteListener(CompleteListener lsnr) {
            boolean complete = false;
            SimpleRequest simpleRequest = this;
            synchronized (simpleRequest) {
                this._lsnr = lsnr;
                if (this.isComplete()) {
                    complete = true;
                }
            }
            if (complete && lsnr != null) {
                lsnr.complete(this);
            }
        }

        private synchronized boolean isComplete() {
            return this._allocated >= this._total;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void waitForNextAllocation() {
            boolean complete = false;
            try {
                SimpleRequest simpleRequest = this;
                synchronized (simpleRequest) {
                    this._waited = true;
                    this._allocationsSinceWait = 0;
                    if (this.isComplete()) {
                        complete = true;
                    } else {
                        this.wait(100L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (complete && this._lsnr != null) {
                this._lsnr.complete(this);
            }
        }

        synchronized int getAllocationsSinceWait() {
            return this._waited ? this._allocationsSinceWait : 0;
        }

        synchronized void allocateBytes(int bytes) {
            this._allocated += bytes;
            if (this._lsnr == null) {
                ++this._allocationsSinceWait;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void notifyAllocation() {
            boolean complete = false;
            SimpleRequest simpleRequest = this;
            synchronized (simpleRequest) {
                if (this.isComplete()) {
                    complete = true;
                }
                this.notifyAll();
            }
            if (complete && this._lsnr != null) {
                this._lsnr.complete(this);
            }
        }

        @Override
        public void attach(Object obj) {
            this._attachment = obj;
        }

        @Override
        public Object attachment() {
            return this._attachment;
        }

        @Override
        public int getPriority() {
            return this._priority;
        }

        @Override
        public void setSeqNum(long num) {
        }

        @Override
        public long getSeqNum() {
            return this._requestId;
        }

        public String toString() {
            return "Req: " + this._requestId + " priority: " + this._priority + ' ' + this._allocated + '/' + this._total + " bytes";
        }
    }

    public static interface Request
    extends PQEntry {
        public long getRequestTime();

        public int getTotalRequested();

        public int getPendingRequested();

        public void waitForNextAllocation();

        public void abort();

        public boolean getAborted();

        public void setCompleteListener(CompleteListener var1);

        public void attach(Object var1);

        public Object attachment();

        public CompleteListener getCompleteListener();
    }

    public static interface CompleteListener {
        public void complete(Request var1);
    }
}

