/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SelectableChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.client.streaming.impl.Connection;
import net.i2p.client.streaming.impl.ConnectionOptions;
import net.i2p.client.streaming.impl.MessageInputStream;
import net.i2p.client.streaming.impl.MessageOutputStream;
import net.i2p.data.Destination;
import net.i2p.util.Log;

class I2PSocketFull
implements I2PSocket {
    private final Log log;
    private volatile Connection _connection;
    private final Destination _remotePeer;
    private final Destination _localPeer;
    private final AtomicBoolean _closed = new AtomicBoolean();

    public I2PSocketFull(Connection con, I2PAppContext context) {
        this.log = context.logManager().getLog(I2PSocketFull.class);
        this._connection = con;
        if (con != null) {
            this._remotePeer = con.getRemotePeer();
            this._localPeer = con.getSession().getMyDestination();
        } else {
            this._localPeer = null;
            this._remotePeer = null;
        }
    }

    public void close() throws IOException {
        if (!this._closed.compareAndSet(false, true)) {
            this.log.logCloseLoop(new Object[]{"I2PSocket", this._localPeer, "-->", this._remotePeer, this._connection});
            return;
        }
        Connection c = this._connection;
        if (c == null) {
            return;
        }
        if (this.log.shouldLog(20)) {
            this.log.info("close() called, connected? " + c.getIsConnected() + " : " + c, (Throwable)new Exception());
        }
        if (c.getIsConnected()) {
            MessageInputStream in = c.getInputStream();
            in.close();
            MessageOutputStream out = c.getOutputStream();
            out.closeInternal();
            c.windowAdjusted();
        }
        this.destroy();
    }

    public void reset() throws IOException {
        Connection c = this._connection;
        if (c == null) {
            return;
        }
        if (this.log.shouldLog(20)) {
            this.log.info("reset() called, connected? " + c.getIsConnected() + " : " + c, (Throwable)new Exception());
        }
        if (c.getIsConnected()) {
            c.disconnect(false);
            c.windowAdjusted();
        }
        this.destroy();
    }

    Connection getConnection() {
        return this._connection;
    }

    public InputStream getInputStream() throws IOException {
        Connection c = this._connection;
        if (c != null) {
            return c.getInputStream();
        }
        throw new IOException("Socket closed");
    }

    public I2PSocketOptions getOptions() {
        Connection c = this._connection;
        if (c != null) {
            return c.getOptions();
        }
        return null;
    }

    @Deprecated
    public synchronized SelectableChannel getChannel() {
        return null;
    }

    public OutputStream getOutputStream() throws IOException {
        Connection c = this._connection;
        if (c != null) {
            return c.getOutputStream();
        }
        throw new IOException("Socket closed");
    }

    public Destination getPeerDestination() {
        return this._remotePeer;
    }

    public long getReadTimeout() {
        I2PSocketOptions opts = this.getOptions();
        if (opts != null) {
            return opts.getReadTimeout();
        }
        return -1L;
    }

    public Destination getThisDestination() {
        return this._localPeer;
    }

    public void setOptions(I2PSocketOptions options) {
        Connection c = this._connection;
        if (c == null) {
            return;
        }
        if (options instanceof ConnectionOptions) {
            c.setOptions((ConnectionOptions)options);
        } else {
            c.setOptions(new ConnectionOptions(options));
        }
    }

    public void setReadTimeout(long ms) {
        Connection c = this._connection;
        if (c == null) {
            return;
        }
        if (ms > Integer.MAX_VALUE) {
            ms = Integer.MAX_VALUE;
        }
        c.getInputStream().setReadTimeout((int)ms);
        c.getOptions().setReadTimeout(ms);
    }

    public void setSocketErrorListener(I2PSocket.SocketErrorListener lsnr) {
    }

    public boolean isClosed() {
        Connection c = this._connection;
        return c == null || !c.getIsConnected() || c.getResetReceived() || c.getResetSent();
    }

    void destroy() {
        this.destroy2();
    }

    void destroy2() {
        this._connection = null;
    }

    public int getPort() {
        Connection c = this._connection;
        return c == null ? 0 : c.getPort();
    }

    public int getLocalPort() {
        Connection c = this._connection;
        return c == null ? 0 : c.getLocalPort();
    }

    public String toString() {
        Connection c = this._connection;
        if (c == null) {
            return super.toString();
        }
        return c.toString();
    }
}

