/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apiguardian.api.API;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;

@API(status=API.Status.INTERNAL, since="1.7", consumers={"org.junit.platform.testkit", "org.junit.platform.suite.engine"})
public class LauncherDiscoveryResult {
    private final Map<TestEngine, TestDescriptor> testEngineDescriptors;
    private final ConfigurationParameters configurationParameters;

    LauncherDiscoveryResult(Map<TestEngine, TestDescriptor> testEngineDescriptors, ConfigurationParameters configurationParameters) {
        this.testEngineDescriptors = Collections.unmodifiableMap(new LinkedHashMap<TestEngine, TestDescriptor>(testEngineDescriptors));
        this.configurationParameters = configurationParameters;
    }

    public TestDescriptor getEngineTestDescriptor(TestEngine testEngine) {
        return this.testEngineDescriptors.get(testEngine);
    }

    ConfigurationParameters getConfigurationParameters() {
        return this.configurationParameters;
    }

    public Collection<TestEngine> getTestEngines() {
        return this.testEngineDescriptors.keySet();
    }

    Collection<TestDescriptor> getEngineTestDescriptors() {
        return this.testEngineDescriptors.values();
    }
}

