/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Writer;
import jogamp.graph.font.typecast.ot.Glyph;
import jogamp.graph.font.typecast.ot.table.CmapTable;
import jogamp.graph.font.typecast.ot.table.GsubTable;
import jogamp.graph.font.typecast.ot.table.HeadTable;
import jogamp.graph.font.typecast.ot.table.HheaTable;
import jogamp.graph.font.typecast.ot.table.HmtxTable;
import jogamp.graph.font.typecast.ot.table.MaxpTable;
import jogamp.graph.font.typecast.ot.table.NameRecord;
import jogamp.graph.font.typecast.ot.table.NameTable;
import jogamp.graph.font.typecast.ot.table.Os2Table;
import jogamp.graph.font.typecast.ot.table.PostTable;
import jogamp.graph.font.typecast.ot.table.Table;
import jogamp.graph.font.typecast.ot.table.TableDirectory;
import jogamp.graph.font.typecast.ot.table.VheaTable;

public abstract class OTFont {
    private final Os2Table _os2;
    private final CmapTable _cmap;
    private final HeadTable _head;
    private final HheaTable _hhea;
    private final HmtxTable _hmtx;
    private final MaxpTable _maxp;
    private final NameTable _name;
    private final PostTable _post;
    private final VheaTable _vhea;
    private final GsubTable _gsub;
    private final TableDirectory _tableDirectory;

    OTFont(DataInputStream dataInputStream, TableDirectory tableDirectory, int n) throws IOException {
        this._tableDirectory = tableDirectory;
        this.seekTable(tableDirectory, dataInputStream, n, 1751474532);
        this._head = new HeadTable(dataInputStream);
        this.seekTable(tableDirectory, dataInputStream, n, 1751672161);
        this._hhea = new HheaTable(dataInputStream);
        this.seekTable(tableDirectory, dataInputStream, n, 1835104368);
        this._maxp = new MaxpTable(dataInputStream);
        int n2 = this.seekTable(tableDirectory, dataInputStream, n, 1986553185);
        this._vhea = n2 > 0 ? new VheaTable(dataInputStream) : null;
        this.seekTable(tableDirectory, dataInputStream, n, 1886352244);
        this._post = new PostTable(dataInputStream);
        this.seekTable(tableDirectory, dataInputStream, n, 1668112752);
        this._cmap = new CmapTable(dataInputStream);
        n2 = this.seekTable(tableDirectory, dataInputStream, n, 1752003704);
        this._hmtx = new HmtxTable(dataInputStream, n2, this._hhea, this._maxp);
        n2 = this.seekTable(tableDirectory, dataInputStream, n, 1851878757);
        this._name = new NameTable(dataInputStream, n2);
        this.seekTable(tableDirectory, dataInputStream, n, 1330851634);
        this._os2 = new Os2Table(dataInputStream);
        this._gsub = null;
    }

    public TableDirectory getTableDirectory() {
        return this._tableDirectory;
    }

    public Os2Table getOS2Table() {
        return this._os2;
    }

    public CmapTable getCmapTable() {
        return this._cmap;
    }

    public HeadTable getHeadTable() {
        return this._head;
    }

    public HheaTable getHheaTable() {
        return this._hhea;
    }

    public HmtxTable getHmtxTable() {
        return this._hmtx;
    }

    public MaxpTable getMaxpTable() {
        return this._maxp;
    }

    public NameTable getNameTable() {
        return this._name;
    }

    public PostTable getPostTable() {
        return this._post;
    }

    public VheaTable getVheaTable() {
        return this._vhea;
    }

    public GsubTable getGsubTable() {
        return this._gsub;
    }

    public int getAscent() {
        return this._hhea.getAscender();
    }

    public int getDescent() {
        return this._hhea.getDescender();
    }

    public int getNumGlyphs() {
        return this._maxp.getNumGlyphs();
    }

    public abstract int getGlyphCount();

    public abstract Glyph getGlyph(int var1);

    int seekTable(TableDirectory tableDirectory, DataInputStream dataInputStream, int n, int n2) throws IOException {
        dataInputStream.reset();
        TableDirectory.Entry entry = tableDirectory.getEntryByTag(n2);
        if (entry == null) {
            return 0;
        }
        dataInputStream.skip(n + entry.getOffset());
        return entry.getLength();
    }

    public String getName(int n) {
        return this._name.getRecordsRecordString(n);
    }

    public StringBuilder getAllNames(StringBuilder stringBuilder, String string) {
        if (null != this._name) {
            if (null == stringBuilder) {
                stringBuilder = new StringBuilder();
            }
            for (int i = 0; i < this._name.getNumberOfNameRecords(); ++i) {
                NameRecord nameRecord = this._name.getRecord(i);
                if (null == nameRecord) continue;
                stringBuilder.append(nameRecord.getRecordString()).append(string);
            }
        }
        return stringBuilder;
    }

    public String toString() {
        return this._head.toString();
    }

    public void dumpTo(Writer writer) throws IOException {
        writer.write(this.getTableDirectory().toString());
        writer.write("\n");
        OTFont.dump(writer, this.getHeadTable());
        OTFont.dump(writer, this.getOS2Table());
        OTFont.dump(writer, this.getCmapTable());
        OTFont.dump(writer, this.getHheaTable());
        OTFont.dump(writer, this.getHmtxTable());
        OTFont.dump(writer, this.getMaxpTable());
        OTFont.dump(writer, this.getNameTable());
        OTFont.dump(writer, this.getPostTable());
        OTFont.dump(writer, this.getVheaTable());
        OTFont.dump(writer, this.getGsubTable());
    }

    protected static void dump(Writer writer, Table table) throws IOException {
        if (table != null) {
            table.dump(writer);
            writer.write("\n");
            writer.write("\n");
        }
    }
}

