/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementCompound;
import org.hsqldb.error.Error;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.result.Result;

public class StatementSimple
extends Statement {
    HsqlNameManager.HsqlName label;

    StatementSimple(int n, HsqlNameManager.HsqlName hsqlName) {
        super(n, 2007);
        this.references = new OrderedHashSet();
        this.isTransactionStatement = false;
        this.label = hsqlName;
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.type) {
            case 103: {
                stringBuilder.append("ITERATE").append(' ').append(this.label);
                break;
            }
            case 104: {
                stringBuilder.append("LEAVE").append(' ').append(this.label);
            }
        }
        return stringBuilder.toString();
    }

    protected String describe(Session session, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        stringBuilder.append("STATEMENT");
        return stringBuilder.toString();
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable throwable) {
            result = Result.newErrorResult(throwable);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    Result getResult(Session session) {
        switch (this.type) {
            case 103: 
            case 104: {
                return Result.newPSMResult(this.type, this.label.name, null);
            }
        }
        throw Error.runtimeError(201, "StatementSimple");
    }

    @Override
    public void resolve(Session session) {
        boolean bl = false;
        block0 : switch (this.type) {
            case 103: {
                StatementCompound statementCompound = this.parent;
                while (statementCompound != null) {
                    if (statementCompound.isLoop) {
                        if (this.label == null) {
                            bl = true;
                            break block0;
                        }
                        if (statementCompound.label != null && this.label.name.equals(statementCompound.label.name)) {
                            bl = true;
                            break block0;
                        }
                    }
                    statementCompound = statementCompound.parent;
                }
                break;
            }
            case 104: {
                bl = true;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSimple");
            }
        }
        if (!bl) {
            throw Error.error(5602);
        }
    }

    @Override
    public String describe(Session session) {
        return "";
    }

    @Override
    public boolean isCatalogLock(int n) {
        return false;
    }

    @Override
    public boolean isCatalogChange() {
        return false;
    }
}

